/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.sync.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.sync.element.SyncFileElement;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.MiniCloudAccessControlService;
import com.parablu.cloud.security.service.DeviceAndUserSecurityService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.cloud.security.to.DeviceStatusTo;
import com.parablu.helper.constant.GeneralHelperConstant;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.BluKryptBackupFileElement;
import com.parablu.paracloud.element.ChunkFileInfoElement;
import com.parablu.paracloud.element.FileElement;
import com.parablu.pcbd.domain.BackupFile;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.User;
import com.parablu.psc.service.UserAndDeviceStatisticService;
import com.parablu.rf.delegate.UploadService;
import com.parablu.rf.exception.ResourceFunnelException;
import com.parablu.rf.service.DownloadService;
import com.parablu.rf.to.UploadStatusAndIndexTO;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class FileDirectoryController
extends BaseController {
    private static Logger logger = LogManager.getLogger(FileDirectoryController.class);
    @Autowired
    private UploadService uploadService;
    @Autowired
    private DownloadService downloadService;
    @Autowired
    UserAndDeviceStatisticService userAndDeviceStatisticService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Autowired
    private DeviceAndUserSecurityService deviceAndUserSecurityService;
    @Autowired
    private MiniCloudAccessControlService miniCloudAccessControlService;
    private static final String WINDOWS_OS = "win";
    private static final String IO_EXCEPTION = "IOException ";
    private static final String EXCEPTION = "Exception";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"cloud/{cloudName}/upload"}, method={RequestMethod.PUT})
    public void uploadFile(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String fileMetadata;
        String fileName;
        String filePath;
        logger.debug("INSIDE FileDirectoryController cloud/{cloudName}/upload ");
        String cloudNameTemp = cloudName;
        FileElement fileElement = null;
        String renamedConflictedOriginalFileName = null;
        boolean requestSuccess = false;
        InputStream inputStream = null;
        String token = request.getHeader("token");
        String miniCloudId = request.getHeader("multi-cloud-id");
        CloudLicenseTo cl = this.licenseService.validateLicenseAndStorageRestrictions(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            this.closeInputStreamIfExists(request);
            return;
        }
        cloudNameTemp = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudNameTemp, token, cl.getCloud());
        User user = new User();
        if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
            return;
        }
        if (!this.checkLicense(code.getStatus(), response)) {
            this.closeInputStreamIfExists(request);
            return;
        }
        if (!this.checkIfDeviceIsAttached(cl.getCloud().getCloudName(), response)) {
            return;
        }
        if (!this.checkIfUserIsValid(user, 1, response)) {
            this.closeInputStreamIfExists(request);
            return;
        }
        String headerEncoding = request.getHeader("header-encoding");
        if (headerEncoding != null && "base64".equalsIgnoreCase(headerEncoding)) {
            filePath = this.decodeBase64UTFString(request.getHeader("file-path"));
            fileName = this.decodeBase64UTFString(request.getHeader("file-name"));
            fileMetadata = this.decodeBase64UTFString(request.getHeader("meta-data"));
        } else {
            filePath = request.getHeader("file-path");
            fileName = request.getHeader("file-name");
            fileMetadata = request.getHeader("meta-data");
        }
        if (!this.validateMiniCloudAccessForUser(response, filePath, cloudId, cloudNameTemp, code, user)) {
            return;
        }
        try {
            fileElement = new FileElement();
            fileElement.setFileName(fileName);
            fileElement.setMetaData(fileMetadata);
            fileElement.setFileCompletePath(filePath);
            fileElement.setExists(Boolean.valueOf(request.getHeader("is-exists")).booleanValue());
            fileElement.setFolder(Boolean.valueOf(request.getHeader("is-folder")).booleanValue());
            fileElement.setMd5checksum(request.getHeader("fileMD5"));
            fileElement.setSize(request.getHeader("file-size"));
            String fileModifiedTimestamp = request.getHeader("modified");
            fileElement.setLastModifiedTimestamp(Long.valueOf(fileModifiedTimestamp).longValue());
            fileElement.setCrawlTimestamp(Long.parseLong(request.getHeader("crawlTimestamp")));
            long cloudSizeAllowedInBytes = (long)((float)(this.licenseService.getCloudDiskSpaceLimit(cloudNameTemp) * 1024L * 1024L) * 1.01f);
            if (fileElement.isFolder()) {
                UploadStatusAndIndexTO uploadStatusAndIndexTO = this.uploadService.uploadFile(cloudId, cloudNameTemp, cl.getCloud(), null, fileElement, cloudSizeAllowedInBytes, miniCloudId, code.getDevice());
                response.setStatus(200);
                if (uploadStatusAndIndexTO.getSearchIndex() != null) {
                    this.addSearchIndexToTable(cl.getCloud(), uploadStatusAndIndexTO.getSearchIndex());
                }
            } else {
                inputStream = request.getInputStream();
                UploadStatusAndIndexTO uploadStatusAndIndexTO = this.uploadService.uploadFile(cloudId, cloudNameTemp, cl.getCloud(), inputStream, fileElement, cloudSizeAllowedInBytes, miniCloudId, code.getDevice());
                if (uploadStatusAndIndexTO.getSearchIndex() != null) {
                    this.addSearchIndexToTable(cl.getCloud(), uploadStatusAndIndexTO.getSearchIndex());
                }
                if ((renamedConflictedOriginalFileName = uploadStatusAndIndexTO.getConflictFileName()) != null) {
                    response.setHeader("upload-conflict", renamedConflictedOriginalFileName);
                    response.setStatus(409);
                } else {
                    response.setStatus(200);
                }
            }
            requestSuccess = true;
        }
        catch (ResourceFunnelException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while uploading file " + e.getMessage());
            response.setHeader("errorMessage", e.getErrMsg());
            response.setStatus(e.getResponseCode());
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception while uploading file " + e.getMessage());
            response.setHeader("errorMessage", e.getMessage());
            response.setStatus(500);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.debug(IO_EXCEPTION, (Throwable)e);
                }
            }
            try {
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
            catch (IOException e) {
                logger.debug(IO_EXCEPTION, (Throwable)e);
            }
        }
        if (requestSuccess && fileElement != null && renamedConflictedOriginalFileName != null) {
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudNameTemp, "uploaded", code.getDevice().getUserName(), renamedConflictedOriginalFileName, code.getDevice().getDeviceName(), System.currentTimeMillis(), PCActionTypes.FILE_UPLOAD.getActionTypeValue());
        } else if (requestSuccess && fileElement != null) {
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudNameTemp, "uploaded", code.getDevice().getUserName(), fileElement.getFileName(), code.getDevice().getDeviceName(), System.currentTimeMillis(), PCActionTypes.FILE_UPLOAD.getActionTypeValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"cloud/{cloudName}/sync/blukrypt/upload"}, method={RequestMethod.POST})
    public void insertEntryFromBlukrypt(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("INSIDE FileDirectoryController sync1/upload ");
        String cloudNameTemp = cloudName;
        Object renamedConflictedOriginalFileName = null;
        Object inputStream = null;
        SyncFileElement syncFileElement = new SyncFileElement();
        String token = request.getParameter("token");
        int miniCloudId = 0;
        CloudLicenseTo cl = this.licenseService.validateLicenseAndStorageRestrictions(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            this.closeInputStreamIfExists(request);
            return;
        }
        cloudNameTemp = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudNameTemp, token, cl.getCloud());
        logger.debug(token + "!!!!!! ..... " + request.getParameter("userName"));
        String deviceName = code.getDevice().getDeviceName();
        String userName = code.getDevice().getUserName();
        SyncFileElement element = new SyncFileElement();
        logger.debug("!!!!! ..... " + element.toString());
        String filePath = "";
        String fileName = "";
        String fileMetadata = "";
        try {
            logger.debug(token + "!!!!! ..... " + request.getParameter("file-name"));
            syncFileElement.setFileName(request.getParameter("file-name"));
            syncFileElement.setMetaData(request.getParameter("meta-data"));
            syncFileElement.setFileCompletePath(request.getParameter("file-path"));
            syncFileElement.setExists(Boolean.valueOf(request.getParameter("is-exists")).booleanValue());
            syncFileElement.setFolder(Boolean.valueOf(request.getParameter("is-folder")).booleanValue());
            syncFileElement.setMd5checksum(request.getParameter("fileMD5"));
            syncFileElement.setSize(request.getParameter("file-size"));
            String fileModifiedTimestamp = request.getParameter("modified");
            syncFileElement.setLastModifiedTimestamp(Long.valueOf(fileModifiedTimestamp).longValue());
            syncFileElement.setUserName(userName);
            long cloudSizeAllowedInBytes = (long)((float)(this.licenseService.getCloudDiskSpaceLimit(cloudNameTemp) * 1024L * 1024L) * 1.01f);
            String osType = "Android";
            String deviceUUID = request.getParameter("deviceUUID");
            String revisionId = this.uploadService.insertSyncEntryForFile(cloudId, cloudNameTemp, cl.getCloud(), syncFileElement, cloudSizeAllowedInBytes, miniCloudId, deviceUUID);
            logger.debug(" REVISION ID ............... " + revisionId);
            response.setHeader("syncRevisionId", revisionId);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace("Exception :" + e);
            logger.error("Exception :" + e.getMessage());
            response.setHeader("errorMessage", e.getMessage());
            response.setStatus(500);
        }
        finally {
            try {
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
            catch (IOException e) {
                logger.debug(IO_EXCEPTION, (Throwable)e);
            }
        }
        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudNameTemp, "uploaded", code.getDevice().getUserName(), syncFileElement.getFileName(), code.getDevice().getDeviceName(), System.currentTimeMillis(), PCActionTypes.FILE_UPLOAD.getActionTypeValue());
    }

    @RequestMapping(value={"cloud/{cloudName}/save/syncfile/user/{userName}/"}, method={RequestMethod.PUT})
    public void saveBackupFileInfo(@PathVariable(value="cloudName") String cloudName, @PathVariable(value="userName") String userName, @RequestBody BluKryptBackupFileElement bluKryptBackupFileElement, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling save backup file info in couch DB ...");
        try {
            String cloudNameTemp = cloudName;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            BackupFile backupFile = new BackupFile();
            BeanUtils.copyProperties((Object)bluKryptBackupFileElement, (Object)backupFile);
            backupFile.setId(new ObjectId(bluKryptBackupFileElement.getBackupId()));
            this.uploadService.saveSyncFileInfo(cloudId, cloudNameTemp, userName, backupFile);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace("Exception :" + e);
            logger.error("Exception :" + e.getMessage());
            response.setStatus(500);
            logger.error("Error failed to save backup file info ..." + e.getMessage());
        }
        logger.debug("end of calling /authenticateOneDrive ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/get/syncfile/"}, method={RequestMethod.GET})
    public ResponseEntity<BluKryptBackupFileElement> getExternalBackupFile(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling BluKryptBackupFileElement get backup file info in couch DB ...");
        BackupFile backupFile = null;
        BluKryptBackupFileElement element = new BluKryptBackupFileElement();
        try {
            String cloudNameTemp = cloudName;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String userName = request.getHeader("userName");
            String id = request.getHeader("sync-revision-id");
            backupFile = this.uploadService.getSyncFile(cloudId, cloudNameTemp, userName, id);
            ArrayList<ChunkFileInfoElement> chunkList = new ArrayList<ChunkFileInfoElement>();
            if (backupFile != null) {
                for (ChunkFile chunkFile : backupFile.getChunkFiles()) {
                    ChunkFileInfoElement file = new ChunkFileInfoElement();
                    BeanUtils.copyProperties((Object)chunkFile, (Object)file);
                    chunkList.add(file);
                }
                BeanUtils.copyProperties((Object)backupFile, (Object)element);
                element.setBackupId(backupFile.getId().toString());
                element.getChunkFiles().clear();
                element.getChunkFiles().addAll(chunkList);
            } else {
                logger.debug("Sync FILE NOT AVAILABLE ......." + id);
            }
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("" + (Object)((Object)e));
            logger.error("Error failed to get backup file info ..." + e.getMessage());
        }
        logger.debug("end of calling /get External BackupFile Info ...");
        return new ResponseEntity((Object)element, HttpStatus.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @RequestMapping(value={"/cloud/{cloudName}/download"}, method={RequestMethod.GET})
    public void downloadFile(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("SYNC DOWNLOAD ........... /cloud/{cloudName}/download ");
        BufferedInputStream inputStream = null;
        List downloadReturnList = null;
        String relativePath = request.getHeader("relative-path");
        String token = request.getHeader("token");
        logger.debug("SYNC DOWNLOAD path ...........  " + relativePath);
        String cloudNameTemp = cloudName;
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        cloudNameTemp = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudNameTemp, token, cl.getCloud());
        if (!this.checkLicense(code.getStatus(), response)) {
            return;
        }
        User user = new User();
        if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
            return;
        }
        if (!this.checkIfDeviceIsAttached(cl.getCloud().getCloudName(), response)) {
            return;
        }
        if (!this.checkIfUserIsValid(user, 1, response)) {
            return;
        }
        if (!this.validateMiniCloudAccessForUser(response, relativePath, cloudId, cloudNameTemp, code, user)) {
            return;
        }
        try {
            downloadReturnList = this.downloadService.downloadFile(cloudId, cloudNameTemp, relativePath, code.getDevice());
            response.addHeader("file-size", (String)downloadReturnList.get(2));
            response.setStatus(200);
            response.addHeader("fileMD5", (String)downloadReturnList.get(3));
            inputStream = (BufferedInputStream)downloadReturnList.get(0);
            response.setContentType((String)downloadReturnList.get(1));
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudNameTemp, "downloaded", code.getDevice().getUserName(), this.parseFileName(relativePath), code.getDevice().getDeviceName(), System.currentTimeMillis(), PCActionTypes.FILE_DOWNLOAD.getActionTypeValue());
        }
        catch (ResourceFunnelException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while downloading file " + e.getMessage());
            response.setHeader("errorMessage", e.getErrMsg());
            response.setStatus(e.getResponseCode());
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        catch (IOException ex) {
            logger.trace("" + ex);
            logger.error("Exception while downloading file " + ex.getMessage());
            response.setHeader("errorMessage", IO_EXCEPTION);
            response.setStatus(500);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    private String parseFileName(String relativePath) {
        File file = new File(relativePath.replace("\\", "/"));
        return file.getName();
    }

    @RequestMapping(value={"/cloud/{cloudName}/download/thumbnail"}, method={RequestMethod.GET})
    public void downloadDODFile(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String relativePath = request.getHeader("relative-path");
        String token = request.getHeader("token");
        String cloudNameTemp = cloudName;
        boolean requestSuccess = false;
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        cloudNameTemp = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudNameTemp, token, cl.getCloud());
        if (!this.checkLicense(code.getStatus(), response)) {
            return;
        }
        User user = new User();
        if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
            return;
        }
        if (!this.checkIfDeviceIsAttached(cl.getCloud().getCloudName(), response)) {
            return;
        }
        if (!this.checkIfUserIsValid(user, 1, response)) {
            return;
        }
        if (!this.validateMiniCloudAccessForUser(response, relativePath, cloudId, cloudNameTemp, code, user)) {
            return;
        }
        try {
            List downloadReturnList = this.downloadService.downloadDODFile(cloudId, cloudNameTemp, relativePath, code.getDevice());
            response.setContentType((String)downloadReturnList.get(1));
            response.addHeader("file-size", (String)downloadReturnList.get(2));
            response.setStatus(200);
            BufferedInputStream inputStream = (BufferedInputStream)downloadReturnList.get(0);
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
            IOUtils.closeQuietly((InputStream)inputStream);
            requestSuccess = true;
        }
        catch (ResourceFunnelException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while downloading dod file " + e.getMessage());
            response.setHeader("errorMessage", e.getErrMsg());
            logger.debug("@@@@@@@@@@ --Setting response for dod" + e.getResponseCode());
            response.setStatus(e.getResponseCode());
        }
        catch (IOException ex) {
            logger.trace("" + ex);
            logger.error("Exception while downloading dod file " + ex.getMessage());
            response.setHeader("errorMessage", ex.getMessage());
            response.setStatus(500);
        }
        if (requestSuccess) {
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudNameTemp, "downloaded", code.getDevice().getUserName(), this.parseFileName(relativePath), code.getDevice().getDeviceName(), System.currentTimeMillis(), PCActionTypes.FILE_DOWNLOAD.getActionTypeValue());
        }
    }

    private boolean validateMiniCloudAccessForUser(HttpServletResponse response, String relativePath, int cloudId, String cloudName, DeviceStatusTo code, User user) {
        String[] params = code.getDevice().getOsType().toLowerCase().contains(WINDOWS_OS) ? relativePath.split("\\\\") : relativePath.split(GeneralHelperConstant.CLOUD_PATH_SEPARATOR);
        if (params == null || params.length == 0 || !params[0].equalsIgnoreCase("ParaBlu")) {
            response.setStatus(400);
            return false;
        }
        if (params.length > 1 && !this.miniCloudAccessControlService.validateMiniCloudOperationAccessForUser(cloudId, cloudName, user, params[1])) {
            response.setStatus(401);
            return false;
        }
        return true;
    }
}

