/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.service.impl;

import com.parablu.bluvault.udc.service.EventHubManagementService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.BackupFolderElement;
import com.parablu.paracloud.element.FileElement;
import com.parablu.paracloud.element.RestoreEventsElement;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.BackupFoldersDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.EventHubDao;
import com.parablu.pcbd.dao.InclusionFilterDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.FileInfo;
import com.parablu.pcbd.domain.MailBackupBatch;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.RestoreProgressEvents;
import com.parablu.pcbd.domain.Schedule;
import com.parablu.pcsd.dao.SyncPolicyDao;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;

public class EventHubManagementServiceImpl
implements EventHubManagementService {
    private static Logger logger = LogManager.getLogger(EventHubManagementServiceImpl.class);
    private static final String STARTED = "STARTED";
    @Resource
    private EventHubDao eventHubDao;
    @Resource
    private DeviceDao deviceDao;
    @Resource
    SyncPolicyDao syncPolicyDao;
    @Resource
    BackupPolicyDao backupPolicyDao;
    @Resource
    private BackupFoldersDao backupFoldersDao;
    @Resource
    private InclusionFilterDao inclusionFilterDao;
    @Resource
    private AuditHistoryDao auditHistoryDao;

    public EventHubDao getEventHubDao() {
        return this.eventHubDao;
    }

    public void setEventHubDao(EventHubDao eventHubDao) {
        this.eventHubDao = eventHubDao;
    }

    @Override
    public void saveAction(int cloudId, String cloudName, EventHub eventHub) {
        this.eventHubDao.saveAction(cloudId, cloudName, eventHub);
    }

    @Override
    public void changeStatus(int cloudId, String cloudName, EventHub eventHub) {
        this.eventHubDao.changeStatus(cloudId, cloudName, eventHub);
    }

    @Override
    public List<String> getActionsByUserNameAndAction(int cloudId, String cloudName, EventHub eventHub) {
        List eventHubList = this.eventHubDao.getActionsByUserNameAndActionByDeviceUUID(cloudId, cloudName, eventHub);
        return eventHubList.stream().filter(line -> Objects.nonNull(line.getAction())).map(line -> line.getAction()).collect(Collectors.toList());
    }

    @Override
    public void deleteAction(int cloudId, String cloudName, EventHub eventHub) {
        this.eventHubDao.deleteAction(cloudId, cloudName, eventHub);
    }

    @Override
    public void deleteAllLogEvents(int cloudId, String cloudName, EventHub eventHub) {
        eventHub.setAction(PCHelperConstant.EVENTHUB_ACTION.PULL_AGENTLOGS.toString());
        this.eventHubDao.deleteAction(cloudId, cloudName, eventHub);
        eventHub.setAction(PCHelperConstant.EVENTHUB_ACTION.PULL_HISTORICAL_LOGS.toString());
        this.eventHubDao.deleteAction(cloudId, cloudName, eventHub);
    }

    @Override
    public boolean checkActionIsPresent(int cloudId, String cloudName, EventHub eventHub) {
        return this.eventHubDao.checkActionIsPresent(cloudId, cloudName, eventHub);
    }

    @Override
    public void saveActionFromBackupFolder(int cloudId, String cloudName, BackupFolderElement backupFolderElement, String userName) {
        BackupFolders existingBackupFolders = this.backupFoldersDao.getBackupFolders(cloudId, cloudName, backupFolderElement.getFolderPath());
        List backupPolicyList = this.backupPolicyDao.getAllBackupPolicies(cloudId);
        backupPolicyList.forEach(backupPolicy -> {
            if (backupPolicy.getBackupFolders().contains(existingBackupFolders)) {
                this.backupPolicyDao.updatePolicyModifiedTime(cloudId, backupPolicy.getId());
            }
        });
    }

    @Override
    public void saveActionFromBackupScheduler(int cloudId, String cloudName, Schedule schedule, String userName) {
        List backupPolicyList = this.backupPolicyDao.getAllBackupPolicies(cloudId);
        backupPolicyList.forEach(backupPolicy -> backupPolicy.getSchedules().forEach(schedules -> {
            if (schedules.getScheduleName().equals(schedule.getScheduleName())) {
                this.backupPolicyDao.updatePolicyModifiedTime(cloudId, backupPolicy.getId());
            }
        }));
    }

    @Override
    public List<String> getActionForDevice(int cloudId, String cloudName, EventHub eventHub, long timeStampOfPolicyModified, long devicePolicyUpdatedTime) {
        logger.debug("Inisde getActionForDevice ..............");
        List eventHubList = this.eventHubDao.getActionsByUserNameAndActionByDeviceUUID(cloudId, cloudName, eventHub);
        List<String> actions = eventHubList.stream().filter(action -> Objects.nonNull(action.getAction())).map(action -> action.getAction()).collect(Collectors.toList());
        for (String acc : actions) {
            logger.debug("....acccccc...." + acc);
        }
        if (actions.contains(PCHelperConstant.EVENTHUB_ACTION.BACKUPPOLICY_REFRESH.toString())) {
            logger.debug("Actions contains backupPolicy refresh so return");
            return actions;
        }
        return this.checkPolicyModifiedAndReturnActions(cloudId, cloudName, eventHub, actions, timeStampOfPolicyModified, devicePolicyUpdatedTime);
    }

    private List<String> checkPolicyModifiedAndReturnActions(int cloudId, String cloudName, EventHub eventHub, List<String> actions, long timeStampOfPolicyModified, long devicePolicyUpdatedTime) {
        logger.debug(devicePolicyUpdatedTime + "....device...usertime...." + timeStampOfPolicyModified);
        if (devicePolicyUpdatedTime < timeStampOfPolicyModified) {
            actions.add(PCHelperConstant.EVENTHUB_ACTION.BACKUPPOLICY_REFRESH.toString());
            eventHub.setAction(PCHelperConstant.EVENTHUB_ACTION.BACKUPPOLICY_REFRESH.toString());
            this.eventHubDao.saveAction(cloudId, cloudName, eventHub);
        }
        return actions;
    }

    @Override
    public void deleteAllActionByDeviceUUID(int cloudId, EventHub eventHub) {
        this.eventHubDao.deleteAllActionByDeviceUUID(cloudId, eventHub);
    }

    @Override
    public void deleteActionBasedOnBackupBatchStatus(int cloudId, String cloudName, String deviceUUID, String action, BackupBatch backupBatch, String errorCode) {
        if (action.equalsIgnoreCase(STARTED) || action.equalsIgnoreCase("STARTED/COMPLETED") || action.equalsIgnoreCase("FAILED")) {
            this.eventHubDao.deleteActionBasedOnBackupBatchStatus(cloudId, deviceUUID, PCHelperConstant.EVENTHUB_ACTION.START_BACKUP.toString());
        } else if (errorCode.equalsIgnoreCase("1208") || errorCode.equalsIgnoreCase("1209")) {
            this.deleteEvent(cloudId, deviceUUID, errorCode, backupBatch.getUserName());
        }
    }

    private void deleteEvent(int cloudId, String deviceUUID, String errorCode, String userName) {
        logger.debug("Deleteing based on error code...");
        EventHub eventHub = new EventHub();
        eventHub.setActionToDeviceUUID(deviceUUID);
        eventHub.setActionToUserName(userName);
        if (errorCode.equalsIgnoreCase("1208")) {
            eventHub.setAction(PCHelperConstant.EVENTHUB_ACTION.PAUSE_BACKUP.toString());
        } else if (errorCode.equalsIgnoreCase("1209")) {
            eventHub.setAction(PCHelperConstant.EVENTHUB_ACTION.STOP_BACKUP.toString());
        }
        this.eventHubDao.deleteAction(cloudId, "", eventHub);
        logger.debug("if admin stops or pause backup also delete started state event also");
        this.eventHubDao.deleteActionBasedOnBackupBatchStatus(cloudId, deviceUUID, PCHelperConstant.EVENTHUB_ACTION.START_BACKUP.toString());
    }

    void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser, String actionUsingObject, long timeStamp, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(timeStamp);
        audit.setActionUsingObject(actionUsingObject);
        audit.setActionType(actionType);
        this.auditHistoryDao.saveAudit(cloudId, cloudName, audit);
    }

    @Override
    public void updateBackupBatchForStopAndPauseBkp(int cloudId, String actionToDeviceUUID, String errorCode, String status) {
        this.eventHubDao.updateBackupBatchForStopAndPauseBkp(cloudId, actionToDeviceUUID, errorCode, status);
    }

    @Override
    public RestoreEventsElement getRestoreEventByUUIDAndFolder(int cloudId, String deviceUUID, String destinationFolder) {
        RestoreEvents restoreEventByUUIDAndFolder = this.eventHubDao.getRestoreEventsByDestUUIDAndFolder(cloudId, deviceUUID, destinationFolder);
        RestoreEventsElement elements = null;
        if (restoreEventByUUIDAndFolder != null) {
            try {
                elements = new RestoreEventsElement();
                logger.debug(restoreEventByUUIDAndFolder.getFileInfo().getFilePath() + "...Inside loop...." + restoreEventByUUIDAndFolder.getId());
                BeanUtils.copyProperties((Object)restoreEventByUUIDAndFolder, (Object)elements);
                elements.setSuspendBackup(restoreEventByUUIDAndFolder.isSuspendBackup());
                FileElement fileElement = new FileElement();
                fileElement.setFileCompletePath(restoreEventByUUIDAndFolder.getFileInfo().getFilePath());
                fileElement.setFolder(restoreEventByUUIDAndFolder.getFileInfo().isFolder());
                fileElement.setBackupId(restoreEventByUUIDAndFolder.getFileInfo().getId());
                RestoreProgressEvents restoreProgressByEvents = this.eventHubDao.getRestoreProgressByEvents(cloudId, deviceUUID);
                elements.setStatus("QUEUE");
                if (restoreProgressByEvents != null) {
                    elements.setStatus(STARTED);
                }
                elements.setFileElement(fileElement);
            }
            catch (Exception e) {
                logger.debug("Exception on service......");
            }
        }
        return elements;
    }

    @Override
    public RestoreEventsElement updateRestoreEvents(int cloudId, RestoreEventsElement restoreEventsElement, String userName) {
        RestoreEventsElement eventsElement = this.getRestoreEventByUUIDAndFolder(cloudId, restoreEventsElement.getDestinationDeviceUUID(), "");
        if (eventsElement != null) {
            logger.debug(".....eventsElement..." + eventsElement.toString());
            return eventsElement;
        }
        this.saveRestoreEvents(cloudId, restoreEventsElement, userName);
        return eventsElement;
    }

    @Override
    public void deleteRestoreEventsByUUID(int cloudId, String deviceUUID) {
        logger.debug("...Inside delete restore events ..." + deviceUUID);
        this.eventHubDao.deleteRestoreEventsByDestUUID(cloudId, deviceUUID);
        this.eventHubDao.deleteActionBasedOnBackupBatchStatus(cloudId, deviceUUID, PCHelperConstant.EVENTHUB_ACTION.START_RESTORE.toString());
    }

    @Override
    public void saveRestoreEvents(int cloudId, RestoreEventsElement restoreEventsElement, String userName) {
        RestoreEvents restoreEvents = new RestoreEvents();
        FileElement fileElement = restoreEventsElement.getFileElement();
        FileInfo fileInfo = new FileInfo();
        fileInfo.setId(fileElement.getBackupId());
        fileInfo.setFolder(fileElement.isFolder());
        fileInfo.setFilePath(fileElement.getFileCompletePath());
        restoreEvents.setDestinationDeviceUUID(restoreEventsElement.getDestinationDeviceUUID());
        restoreEvents.setActionOnDeviceUUID(restoreEventsElement.getActionOnDeviceUUID());
        restoreEvents.setDestinationPath(restoreEventsElement.getDestinationPath());
        restoreEvents.setActionBy(restoreEventsElement.getActionBy());
        restoreEvents.setFileInfo(fileInfo);
        restoreEvents.setInPlaceRestore(restoreEventsElement.isInPlaceRestore());
        logger.debug(".........restoreEventsElement........" + restoreEventsElement.isRestoreAllVersions());
        restoreEvents.setRestoreAllVersions(restoreEventsElement.isRestoreAllVersions());
        restoreEvents.setRestoreDataBefore(restoreEventsElement.getRestoreDataBefore());
        restoreEvents.setStatus("QUEUE");
        restoreEvents.setNoOfThreads(restoreEventsElement.getNoOfThreads());
        RestoreEventsElement eventsElement = this.getRestoreEventByUUIDAndFolder(cloudId, restoreEventsElement.getDestinationDeviceUUID(), "");
        restoreEvents.setSuspendBackup(restoreEventsElement.getSuspendBackup());
        restoreEvents.setRestoreDeletedFiles(restoreEventsElement.isRestoreDeletedFiles());
        restoreEvents.setOverwriteNewerFiles(restoreEventsElement.isOverwriteNewerFiles());
        logger.debug(".........Restore DeletedFiles........" + restoreEvents.isRestoreDeletedFiles());
        logger.debug(".........Restore OverwriteNewerFiles........" + restoreEventsElement.isOverwriteNewerFiles());
        logger.debug(".........restoreEvents........" + restoreEvents.isRestoreAllVersions());
        this.eventHubDao.saveRestoreEvents(cloudId, restoreEvents);
        EventHub eventHub = new EventHub();
        eventHub.setAction(PCHelperConstant.EVENTHUB_ACTION.START_RESTORE.toString());
        eventHub.setActionToDeviceUUID(restoreEvents.getDestinationDeviceUUID());
        eventHub.setActionToUserName(userName);
        boolean checkActionIsPresent = this.checkActionIsPresent(cloudId, "", eventHub);
        logger.debug("....checkActionIsPresent..." + checkActionIsPresent);
        if (!checkActionIsPresent) {
            eventHub.setActionBy(restoreEventsElement.getActionBy());
            this.eventHubDao.saveAction(cloudId, "", eventHub);
        }
    }

    @Override
    public void updateRestoreEventsStatus(int cloudId, String deviceUUID, String status) {
        logger.debug("..updating status for deviceUUID..." + deviceUUID + "...status as..." + status);
        RestoreEvents restoreEventByUUID = this.eventHubDao.getRestoreEventsByDestUUIDAndFolder(cloudId, deviceUUID, "");
        if (restoreEventByUUID != null && !StringUtils.isEmpty((String)restoreEventByUUID.getStatus())) {
            if (status.equals(STARTED) && !status.equalsIgnoreCase(restoreEventByUUID.getStatus())) {
                logger.debug("..old status.." + status);
                restoreEventByUUID.setStatus(status);
                this.eventHubDao.saveRestoreEvents(cloudId, restoreEventByUUID);
                this.eventHubDao.deleteActionBasedOnBackupBatchStatus(cloudId, deviceUUID, PCHelperConstant.EVENTHUB_ACTION.START_RESTORE.toString());
            } else if (status.equals("COMPLETED") || status.equals("FAILED")) {
                logger.debug("ststus " + status + "...deleting action.......");
                this.eventHubDao.deleteRestoreEvents(cloudId, restoreEventByUUID);
                this.eventHubDao.removeRestoreProgressById(cloudId, restoreEventByUUID.getId());
                this.eventHubDao.deleteActionBasedOnBackupBatchStatus(cloudId, deviceUUID, PCHelperConstant.EVENTHUB_ACTION.START_RESTORE.toString());
            } else {
                logger.debug("..restore events is empty for deviceUUID :" + deviceUUID);
            }
        }
    }

    @Override
    public MailBackupBatch getMailBackupBatch(int cloudId, String deviceUUID) {
        return this.eventHubDao.getMailBackupBatch(cloudId, deviceUUID);
    }

    @Override
    public BackupBatch getBackupBatch(int cloudId, String deviceUUID) {
        return this.eventHubDao.getBackupBatch(cloudId, deviceUUID);
    }

    @Override
    public void updateBackupBatchForStopRestore(int cloudId, String actionToDeviceUUID, String errorCode, String status) {
        this.eventHubDao.updateBackupBatchForStopRestore(cloudId, actionToDeviceUUID, errorCode, status);
    }

    @Override
    public RestoreEvents getRestoreEventByUUID(int cloudId, String deviceUUID) {
        return this.eventHubDao.getRestoreEventsByDestUUIDAndFolder(cloudId, deviceUUID);
    }

    @Override
    public void removeRestoreProgress(int cloudId, String deviceUUID) {
        this.eventHubDao.removeRestoreProgress(cloudId, deviceUUID);
    }

    @Override
    public void updateBackupBatchForStopRestore(int cloudId, String actionToDeviceUUID, String errorCode) {
        this.eventHubDao.updateBackupBatchForStopRestore(cloudId, actionToDeviceUUID, errorCode);
    }

    @Override
    public void deleteRestoreEventsByBatchId(int cloudId, String batchId) {
        RestoreEvents restoreEvents = this.eventHubDao.getRestoreEventForBatchId(cloudId, batchId);
        if (restoreEvents != null) {
            String deviceUUID = restoreEvents.getDestinationDeviceUUID();
            this.eventHubDao.deleteRestoreEventsByDestUUID(cloudId, deviceUUID);
            this.eventHubDao.deleteActionBasedOnBackupBatchStatus(cloudId, deviceUUID, PCHelperConstant.EVENTHUB_ACTION.START_RESTORE.toString());
        }
    }
}

