/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.service.impl;

import com.parablu.bluvault.udc.service.ComponentSettingService;
import com.parablu.pcbd.dao.ComponentDao;
import com.parablu.pcbd.domain.Components;
import com.parablu.pcbd.domain.ComponentsElement;
import com.parablu.pcbd.domain.MSAppSetting;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;

public class ComponentSettingServiceImpl
implements ComponentSettingService {
    private static Logger logger = LogManager.getLogger(ComponentSettingServiceImpl.class);
    private ComponentDao componentDao;

    public ComponentDao getComponentDao() {
        return this.componentDao;
    }

    public void setComponentDao(ComponentDao componentDao) {
        this.componentDao = componentDao;
    }

    @Override
    public ComponentsElement getComponents(String componenetName, int cloudId) {
        ComponentsElement componentsElement = new ComponentsElement();
        logger.debug("componentName" + componenetName);
        logger.debug("cloudId" + cloudId);
        Components components = this.componentDao.getComponentProperties(componenetName, cloudId);
        BeanUtils.copyProperties((Object)components, (Object)componentsElement);
        return componentsElement;
    }

    @Override
    public boolean updateComponents(ComponentsElement componentsElement, int cloudId) {
        Components components = new Components();
        BeanUtils.copyProperties((Object)componentsElement, (Object)components);
        if (this.componentDao.getComponentProperties(components.getComponentName(), cloudId) != null) {
            this.componentDao.updateComponentProperties(components, cloudId);
            return true;
        }
        return false;
    }

    @Override
    public boolean insertComponents(ComponentsElement componentsElement, int cloudId) {
        Components components = new Components();
        BeanUtils.copyProperties((Object)componentsElement, (Object)components);
        if (this.componentDao.getComponentProperties(components.getComponentName(), cloudId) == null) {
            this.componentDao.saveComponentProperties(components, cloudId);
            return true;
        }
        return false;
    }

    @Override
    public MSAppSetting getMSAppSettingsDetails(int cloudId) {
        return this.componentDao.getMSAppSettingsDetails(cloudId);
    }
}

