/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.LicenseDetails;
import com.microsoft.graph.models.ServicePlanInfo;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.LicenseDetailsCollectionPage;
import com.microsoft.graph.requests.LicenseDetailsCollectionRequest;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.PciAuthorizationTokensService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.pc.timer.helper.Graph;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import okhttp3.Request;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class UserStatusCheckForOffice365Job
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(UserStatusCheckForOffice365Job.class);
    private LicenseService licenseService;
    private UserManagementService userManagementService;
    private PciAuthorizationTokensService pciAuthorizationTokensService;
    @Autowired
    private DeviceManagementService deviceManagementService;

    public void setDeviceManagementService(DeviceManagementService deviceManagementService) {
        this.deviceManagementService = deviceManagementService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setPciAuthorizationTokensService(PciAuthorizationTokensService pciAuthorizationTokensService) {
        this.pciAuthorizationTokensService = pciAuthorizationTokensService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        try {
            List jobs = arg0.getScheduler().getCurrentlyExecutingJobs();
            if (jobs != null && !jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (!job.getTrigger().equals((Object)arg0.getTrigger()) || job.getJobInstance().equals((Object)this)) continue;
                    logger.debug("There's another instance running,SO skipping>>>>>>>>>>>>> : " + (Object)((Object)this));
                    return;
                }
            }
        }
        catch (SchedulerException e) {
            logger.debug("" + (Object)((Object)e));
            logger.error("" + e.getCause());
        }
    }

    private boolean isExchangeBackupEnabled(Cloud cl) {
        boolean isExpiredFileDeleteEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"Exchange Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    private boolean isOneDriveForBusinessBackupEnabled(Cloud cl) {
        boolean isExpiredFileDeleteEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"OneDrive Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    private void checkForLicenseAndUserstatusToBlockDevices(Cloud cloud) {
        List exchangeBkpEnabledUsers;
        List oneDriveBkpEnabledUsers = this.userManagementService.getAllOneDriveBkpEnabledUsers(cloud.getCloudId());
        if (!CollectionUtils.isEmpty((Collection)oneDriveBkpEnabledUsers)) {
            for (com.parablu.pcbd.domain.User user : oneDriveBkpEnabledUsers) {
                try {
                    if (user == null) continue;
                    String emailId = user.getEmailId();
                    if (!StringUtils.isEmpty((String)user.getOdbLoginId())) {
                        emailId = user.getOdbLoginId();
                    }
                    String deviceName = emailId + " (Microsoft OneDrive)";
                    Device device = this.deviceManagementService.getDeviceByName(cloud.getCloudId(), cloud.getCloudName(), deviceName);
                    if (device == null) continue;
                    logger.debug(deviceName + "... user device .... " + user.getUserName());
                    UserOfficeElement userOfficeElement = this.getLicenseDetailsForUser(cloud, user, true, false);
                    if (userOfficeElement.isTokenExpired() || userOfficeElement.isUserActive() && !userOfficeElement.isOneDriveEnabled()) continue;
                    this.deviceManagementService.blockUnblockDevice(cloud.getCloudId(), cloud.getCloudName(), device, true);
                    logger.debug("...device is blocked...." + deviceName + "....user..." + user.getUserName());
                }
                catch (Exception e) {
                    logger.error("exception inside UserStatusCheckForOffice365Job .... " + e.getMessage());
                    logger.trace("exception inside UserStatusCheckForOffice365Job ...." + e);
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(exchangeBkpEnabledUsers = this.userManagementService.getAllExchangeBkpEnabledUsers(cloud.getCloudId())))) {
            for (com.parablu.pcbd.domain.User user : exchangeBkpEnabledUsers) {
                try {
                    if (user == null) continue;
                    String emailId = user.getEmailId();
                    if (!StringUtils.isEmpty((String)user.getOdbLoginId())) {
                        emailId = user.getOdbLoginId();
                    }
                    String deviceName = emailId + " (Microsoft Exchange)";
                    Device device = this.deviceManagementService.getDeviceByName(cloud.getCloudId(), cloud.getCloudName(), deviceName);
                    if (device == null) continue;
                    logger.debug(deviceName + "... user device .... " + user.getUserName());
                    UserOfficeElement userOfficeElement = this.getLicenseDetailsForUser(cloud, user, false, true);
                    if (userOfficeElement.isTokenExpired() || userOfficeElement.isUserActive() && !userOfficeElement.isOneDriveEnabled()) continue;
                    this.deviceManagementService.blockUnblockDevice(cloud.getCloudId(), cloud.getCloudName(), device, true);
                    logger.debug("...device is blocked...." + deviceName + "....user..." + user.getUserName());
                }
                catch (Exception e) {
                    logger.error("exception inside UserStatusCheckForOffice365Job .... " + e.getMessage());
                    logger.trace("exception inside UserStatusCheckForOffice365Job ...." + e);
                }
            }
        }
    }

    private UserOfficeElement getLicenseDetailsForUser(Cloud cloud, com.parablu.pcbd.domain.User user, boolean checkOneDrive, boolean checkMail) {
        UserOfficeElement userOfficeElement = new UserOfficeElement();
        String userName = user.getUserName();
        String accessToken = this.pciAuthorizationTokensService.getAccessTokenForODBBackup(cloud.getCloudId());
        if (accessToken == null) {
            logger.error("....Token not mapped....");
            userOfficeElement.setTokenExpired(true);
            return userOfficeElement;
        }
        try {
            GraphServiceClient<Request> graphClient;
            String emailId = user.getEmailId();
            if (!StringUtils.isEmpty((String)user.getOdbLoginId())) {
                emailId = user.getOdbLoginId();
            }
            if ((graphClient = this.getGraphClient(cloud.getCloudId())) == null) {
                userOfficeElement.setTokenExpired(true);
            }
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
            String userId = "";
            for (User userObj : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                userId = userObj.id;
            }
            logger.debug(userId + ".. get license for user given name.... " + userName);
            if (StringUtils.isEmpty((String)userId)) {
                userOfficeElement.setUserActive(false);
            } else {
                userOfficeElement.setUserActive(true);
            }
            if (!userOfficeElement.isUserActive()) {
                logger.error("... user is not active in office " + emailId);
                return userOfficeElement;
            }
            LicenseDetailsCollectionPage licenseDetails = (LicenseDetailsCollectionPage)((LicenseDetailsCollectionRequest)graphClient.users(userId).licenseDetails().buildRequest(new Option[0])).get();
            boolean isOneDriveLicenseEnabled = false;
            boolean isExchangeLicenseEnabled = false;
            if (licenseDetails != null) {
                logger.debug("..... license exists  .... " + userName);
                for (LicenseDetails licenDetails : licenseDetails.getCurrentPage()) {
                    logger.debug(licenDetails + "..... license not empty .... ");
                    Iterator iterator = licenDetails.servicePlans.iterator();
                    logger.debug(licenDetails + "..... license not empty .12... " + licenDetails.servicePlans);
                    while (iterator.hasNext()) {
                        ServicePlanInfo servicePlanInfo = (ServicePlanInfo)iterator.next();
                        logger.debug(user.getUserName() + "... licenDetails ..." + servicePlanInfo.servicePlanName);
                        if (servicePlanInfo.servicePlanName.contains("EXCHANGE") && servicePlanInfo.provisioningStatus.equals("Success")) {
                            isExchangeLicenseEnabled = true;
                        }
                        if (!servicePlanInfo.servicePlanName.contains("SHAREPOINT_S_DEVELOPER") || !servicePlanInfo.provisioningStatus.equals("Success")) continue;
                        isOneDriveLicenseEnabled = true;
                    }
                }
            }
            logger.debug(userName + "......status of license for user..... " + isExchangeLicenseEnabled + "......" + isOneDriveLicenseEnabled);
            userOfficeElement.setExchangeEnabled(isExchangeLicenseEnabled);
            userOfficeElement.setOneDriveEnabled(isOneDriveLicenseEnabled);
        }
        catch (GraphServiceException e) {
            logger.error(" ... error trying to get token ..." + e.getResponseCode());
            if (e.getResponseCode() == 401) {
                logger.debug("..sleep for 90 sec...");
                try {
                    Thread.sleep(90000L);
                    return this.getLicenseDetailsForUser(cloud, user, checkOneDrive, checkMail);
                }
                catch (InterruptedException interruptedException) {
                }
            } else if (e.getResponseCode() == 404) {
                logger.error("... not able to access resource check right user token is mapped .... " + userName);
            }
        }
        catch (Exception ee) {
            logger.error(".... exception......" + ee.getMessage());
        }
        return userOfficeElement;
    }

    private GraphServiceClient<Request> getGraphClient(int cloudId) {
        Graph graph = Graph.getInstance();
        GraphServiceClient<Request> graphClient = graph.getGraphClient();
        return graphClient;
    }

    public class UserOfficeElement {
        private boolean tokenExpired;
        private boolean isOneDriveEnabled;
        private boolean isExchangeEnabled;
        private boolean userActive;

        public boolean isOneDriveEnabled() {
            return this.isOneDriveEnabled;
        }

        public void setOneDriveEnabled(boolean isOneDriveEnabled) {
            this.isOneDriveEnabled = isOneDriveEnabled;
        }

        public boolean isExchangeEnabled() {
            return this.isExchangeEnabled;
        }

        public void setExchangeEnabled(boolean isExchangeEnabled) {
            this.isExchangeEnabled = isExchangeEnabled;
        }

        public boolean isUserActive() {
            return this.userActive;
        }

        public void setUserActive(boolean userActive) {
            this.userActive = userActive;
        }

        public boolean isTokenExpired() {
            return this.tokenExpired;
        }

        public void setTokenExpired(boolean tokenExpired) {
            this.tokenExpired = tokenExpired;
        }
    }
}

