/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.domain.Cloud;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class UnusualAuditHistoryCleanerTimer
extends QuartzJobBean {
    private static Logger logger = LogManager.getLogger(UnusualAuditHistoryCleanerTimer.class);
    private LicenseService licenseService;
    private AuditHistoryService auditHistoryService;
    private static final long THREESIXFIVE_DAYS_TIME_PERIOD = 2592000000L;

    public void setAuditHistoryService(AuditHistoryService auditHistoryService) {
        this.auditHistoryService = auditHistoryService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"UnusualAuditHistoryCleanerTimer")) {
            logger.debug("UnusualAuditHistoryCleanerTimer ........ disabled");
            return;
        }
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            logger.debug("UnusualAuditHistoryCleanerTimer ........ Enabled");
            long daysPeriod = 2592000000L;
            if (PCHelperConstant.getDaysToKeepAuditLog() > 30) {
                daysPeriod = 86400000L * (long)PCHelperConstant.getDaysToKeepAuditLog();
            }
            this.auditHistoryService.deleteUnusualActivityRecordsBasedOnTimeStamp(cloud.getCloudId(), cloud.getCloudName(), System.currentTimeMillis() - daysPeriod);
        }
    }
}

