/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.paracloud.element.CloudInformationElement;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.paracloud.element.DeviceListElement;
import com.parablu.paracloud.util.DiskSpaceHelper;
import com.parablu.paracloud.util.JaxBSerializerHelper;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.parablu.psc.service.CrawlStatisticsCollector;
import com.parablu.psc.service.UserAndDeviceStatisticService;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class StatisticsUpdaterTimer
extends QuartzJobBean {
    private static final int STATUS_FAILED = -10;
    private Logger logger = LogManager.getLogger(StatisticsUpdaterTimer.class);
    private static final String IO_EXCEPTION = "IOException  ";
    private CrawlStatisticsCollector crawlStatisticsCollector;
    private UserAndDeviceStatisticService userAndDeviceStatisticService;

    public void setCrawlStatisticsCollector(CrawlStatisticsCollector crawlStatisticsCollector) {
        this.crawlStatisticsCollector = crawlStatisticsCollector;
    }

    public void setUserAndDeviceStatisticService(UserAndDeviceStatisticService userAndDeviceStatisticService) {
        this.userAndDeviceStatisticService = userAndDeviceStatisticService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
    }

    protected void sendStatisticsForGivenCloud(int cloudId, String cloudName, Cloud cloud) {
        this.logger.debug("here0");
        Map fileTypeCount = this.crawlStatisticsCollector.getFileTypeCount(cloudId, cloudName);
        List devices = this.userAndDeviceStatisticService.getNewlyCreatedAndModifiedDevices(cloudId, cloudName);
        long totalc = this.crawlStatisticsCollector.getTotalNumberOfCrawlRequest(cloudId, cloudName);
        long totald = this.crawlStatisticsCollector.getTotalNumberOfDeleteRequest(cloudId, cloudName);
        long totaldod = this.crawlStatisticsCollector.getTotalNumberOfDODRequest(cloudId, cloudName);
        long totaldown = this.crawlStatisticsCollector.getTotalNumberOfDownloadRequest(cloudId, cloudName);
        long totalu = this.crawlStatisticsCollector.getTotalNumberOfUploadRequest(cloudId, cloudName);
        long totaldev = this.userAndDeviceStatisticService.getNumberOfDevicePresent(cloudId, cloudName, false);
        long totaluse = this.userAndDeviceStatisticService.getNumberOfUserPresent(cloudId, cloudName);
        this.logger.debug("here");
        CloudInformationElement cloudInformationElement = this.fillCloudInformationDetails(cloudId, cloudName, cloud, fileTypeCount, devices, totalc, totald, totaldod, totaldown, totalu, totaldev, totaluse);
        this.sendStatisticToParablu(cloudInformationElement);
    }

    private CloudInformationElement fillCloudInformationDetails(int cloudId, String cloudName, Cloud cloud, Map<String, Long> abd, List<Device> devices, long totalc, long totald, long totaldod, long totaldown, long totalu, long totaldev, long totaluse) {
        CloudInformationElement cloudInformationElement = new CloudInformationElement();
        DeviceListElement deviceListElement = this.setDeviceListElement(devices);
        long fileSizeCount = DiskSpaceHelper.spaceUsedInKB((String)cloud.getCloudName());
        cloudInformationElement.setCloudName(cloud.getCloudName());
        cloudInformationElement.setFileSystemSpaceRemaining(0L);
        cloudInformationElement.setTotalFilesSize(fileSizeCount);
        cloudInformationElement.setActiveDeviceCount(totaldev);
        cloudInformationElement.setUserCount(totaluse);
        cloudInformationElement.setLatestCrawlRequestcount(totalc);
        cloudInformationElement.setLatestDeleteOperationCount(totald);
        cloudInformationElement.setLatestDODRequestCount(totaldod);
        cloudInformationElement.setLatestDownloadRequestCount(totaldown);
        cloudInformationElement.setLatestUploadRequestCount(totalu);
        cloudInformationElement.setDeviceListElement(deviceListElement);
        return cloudInformationElement;
    }

    private DeviceListElement setDeviceListElement(List<Device> devices) {
        ArrayList<DeviceElement> devElementList = new ArrayList<DeviceElement>();
        DeviceListElement deviceListElement = new DeviceListElement();
        for (Device device : devices) {
            DeviceElement ue = new DeviceElement();
            BeanUtils.copyProperties((Object)device, (Object)ue);
            devElementList.add(ue);
        }
        deviceListElement.setDeviceList(devElementList);
        return deviceListElement;
    }

    private int sendStatisticToParablu(CloudInformationElement cloudInformationElement) {
        HttpsURLConnection conn;
        int status = -10;
        StringBuilder urlWithParams = new StringBuilder("https://crm.parablu.com/api").append("/statistic");
        String xmlRequest = JaxBSerializerHelper.marshallCloudInformationElement((CloudInformationElement)cloudInformationElement);
        if (xmlRequest == null) {
            return -10;
        }
        try {
            URL url = new URL(urlWithParams.toString());
            conn = (HttpsURLConnection)url.openConnection();
        }
        catch (MalformedURLException ex) {
            this.logger.debug("Exception", (Throwable)ex);
            this.logger.error("MalformedURLException  " + ex.getMessage());
            return status;
        }
        catch (IOException ex) {
            this.logger.debug("Exception", (Throwable)ex);
            this.logger.error(IO_EXCEPTION + ex.getMessage());
            return status;
        }
        conn.setDoOutput(true);
        conn.setDoInput(true);
        try {
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-type", "application/xml");
            try (OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());){
                wr.write(xmlRequest);
            }
            catch (IOException e) {
                this.logger.debug(IO_EXCEPTION + e);
                this.logger.error(IO_EXCEPTION + e.getMessage());
            }
        }
        catch (IOException ex) {
            this.logger.debug("Exception", (Throwable)ex);
            return status;
        }
        try {
            status = conn.getResponseCode();
        }
        catch (IOException ex) {
            this.logger.trace("IO Exception " + ex);
            this.logger.error("IO Exception " + ex.getMessage());
            return status;
        }
        try {
            BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());
            bis.close();
        }
        catch (IOException e) {
            this.logger.debug("Exception", (Throwable)e);
        }
        return status;
    }
}

