/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.Site;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.SiteCollectionPage;
import com.microsoft.graph.requests.SiteCollectionRequest;
import com.microsoft.graph.requests.SiteCollectionRequestBuilder;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.pc.timer.helper.Graph;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.User;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import okhttp3.Request;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class SharePointUserRegistryJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(SharePointUserRegistryJob.class);
    private LicenseService licenseService;
    private UserManagementService userManagementService;

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        try {
            List jobs = arg0.getScheduler().getCurrentlyExecutingJobs();
            if (jobs != null && !jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (!job.getTrigger().equals((Object)arg0.getTrigger()) || job.getJobInstance().equals((Object)this)) continue;
                    logger.debug("There's another instance running,SO skipping>>>>>>>>>>>>> : " + (Object)((Object)this));
                    return;
                }
            }
        }
        catch (SchedulerException e) {
            logger.debug("" + (Object)((Object)e));
            logger.error("" + e.getCause());
        }
        List clouds = this.licenseService.getClouds();
        Cloud cloud = clouds.stream().findFirst().orElse(null);
        boolean isSharePointBackupEnabled = this.isSharePointBackupEnabled(cloud);
        logger.debug("@@@@SharePointUserRegistryJob check ..... " + isSharePointBackupEnabled);
        if (isSharePointBackupEnabled) {
            try {
                this.registerUsersForSharePoint(cloud);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(" exception in SharePointUserRegistryJob ......." + e.getMessage());
                logger.trace("exception in SharePointUserRegistryJob ......." + e);
            }
        }
        logger.debug("@@@@SharePointUserRegistryJob ended latest ..... ");
    }

    private boolean isSharePointBackupEnabled(Cloud cl) {
        boolean isSharePointBackupEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"Sharepoint Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isSharePointBackupEnabled = true;
                break;
            }
        }
        return isSharePointBackupEnabled;
    }

    private void registerUsersForSharePoint(Cloud cloud) {
        Graph graph = Graph.getInstance();
        GraphServiceClient<Request> graphClient = graph.getGraphClient();
        SiteCollectionPage siteCollectionPage = (SiteCollectionPage)((SiteCollectionRequest)graphClient.sites().buildRequest(new Option[0])).get();
        String siteId = "";
        List currentPageVal = null;
        SiteCollectionRequestBuilder nextPage = (SiteCollectionRequestBuilder)siteCollectionPage.getNextPage();
        HashMap<String, String> siteMap = new HashMap<String, String>();
        HashMap<String, String> siteDispMap = new HashMap<String, String>();
        do {
            currentPageVal = siteCollectionPage.getCurrentPage();
            for (Site site : siteCollectionPage.getCurrentPage()) {
                if (!site.webUrl.contains("sites/")) continue;
                logger.debug(site.name + "....insidennn..." + site.displayName + "...s" + site.description);
                String siteName = site.name;
                String siteUrlName = StringUtils.substringAfterLast((String)site.webUrl, (String)"sites/");
                siteUrlName = URLDecoder.decode(siteUrlName);
                siteUrlName = StringEscapeUtils.unescapeHtml3((String)siteUrlName);
                if (siteName.equalsIgnoreCase(siteUrlName)) {
                    siteMap.put(site.name, site.id);
                    siteDispMap.put(site.id, site.name);
                } else {
                    siteMap.put(siteUrlName, site.id);
                    siteDispMap.put(site.id, site.name);
                }
                siteId = site.id;
                logger.debug(site.webUrl + "..foundsite..." + siteId);
            }
            nextPage = (SiteCollectionRequestBuilder)siteCollectionPage.getNextPage();
            if (nextPage == null) continue;
            siteCollectionPage = (SiteCollectionPage)((SiteCollectionRequest)nextPage.buildRequest(new Option[0])).get();
        } while (currentPageVal.size() > 0 && nextPage != null && siteCollectionPage != null && nextPage != null);
        int processedSite = 0;
        int totalsubsiteFound = 0;
        HashMap<String, String> subsiteMap = new HashMap<String, String>();
        HashMap<String, String> subsiteDispMap = new HashMap<String, String>();
        for (Map.Entry site : siteMap.entrySet()) {
            logger.debug("...iterating sit ...." + (String)site.getKey());
            String parentSiteId = (String)site.getValue();
            logger.debug(++processedSite + "....processedSite found..." + parentSiteId);
            siteCollectionPage = null;
            try {
                siteCollectionPage = (SiteCollectionPage)((SiteCollectionRequest)graphClient.sites(parentSiteId).sites().buildRequest(new Option[0])).get();
            }
            catch (GraphServiceException graphServiceException) {
                logger.debug("...error processing site..." + parentSiteId);
                graphServiceException.printStackTrace();
            }
            if (siteCollectionPage == null) continue;
            do {
                currentPageVal = siteCollectionPage.getCurrentPage();
                for (Site subsiteVal : siteCollectionPage.getCurrentPage()) {
                    siteId = "";
                    String subsiteId = subsiteVal.id;
                    logger.debug("....." + subsiteVal.displayName + "..found sub site..." + subsiteId);
                    if (!subsiteVal.webUrl.contains("sites/")) continue;
                    logger.debug(subsiteVal.name + "....insidennn..." + subsiteVal.displayName + "...s" + subsiteVal.description);
                    String siteName = subsiteVal.name;
                    String siteUrlName = StringUtils.substringAfterLast((String)subsiteVal.webUrl, (String)"sites/");
                    if (siteName.equalsIgnoreCase(siteUrlName)) {
                        subsiteMap.put(subsiteVal.name, subsiteVal.id);
                        subsiteDispMap.put(subsiteVal.id, subsiteVal.name);
                    } else {
                        subsiteMap.put(siteUrlName, subsiteVal.id);
                        subsiteDispMap.put(subsiteVal.id, subsiteVal.name);
                    }
                    ++totalsubsiteFound;
                }
                nextPage = (SiteCollectionRequestBuilder)siteCollectionPage.getNextPage();
                if (nextPage == null) continue;
                siteCollectionPage = (SiteCollectionPage)((SiteCollectionRequest)nextPage.buildRequest(new Option[0])).get();
            } while (currentPageVal.size() > 0 && nextPage != null && siteCollectionPage != null && nextPage != null);
        }
        logger.debug(subsiteMap.size() + "...after iteration...." + siteMap.size());
        siteMap.putAll(subsiteMap);
        List usersWithoutDeviceList = this.userManagementService.getExistingSites(cloud.getCloudId());
        logger.debug("...after getExistingSites...." + siteMap.size());
        HashSet<String> userSet = new HashSet<String>();
        if (!CollectionUtils.isEmpty((Collection)usersWithoutDeviceList)) {
            for (User user : usersWithoutDeviceList) {
                try {
                    if (user == null) continue;
                    userSet.add(user.getUserName());
                    siteMap.remove(user.getUserName());
                }
                catch (Exception subsiteVal) {}
            }
        } else {
            logger.debug("....no existing sites.....");
        }
        logger.debug("...before iteration...." + siteMap.size());
        for (Map.Entry entry : siteMap.entrySet()) {
            logger.debug("...iterating sit ...." + (String)entry.getKey());
            User siteUser = new User();
            siteUser.setUserName((String)entry.getKey());
            siteUser.setSite(true);
            siteUser.setSiteId((String)entry.getValue());
            siteUser.setUserNameLowerCase(((String)entry.getKey()).toLowerCase());
            siteUser.setDisplayName((String)siteDispMap.get(entry.getValue()));
            siteUser.setActive(true);
            siteUser.setBackupEnabled(true);
            siteUser.setSpPolicyName("STATISTICS_SP_POLICY");
            siteUser.setCreatedTimestamp("" + System.currentTimeMillis());
            siteUser.setLastModifiedTimestamp(Long.toString(System.currentTimeMillis()));
            this.userManagementService.createSite(cloud.getCloudId(), siteUser);
        }
    }

    public int validateSPUserRestrictions(int cloudId, Cloud cloud) {
        if ((long)cloud.getNoOfSPSitesAllowed() <= this.userManagementService.countOfPresentSite(cloudId, true)) {
            return 1536;
        }
        return 1500;
    }

    protected GraphServiceClient<Request> getGraphClient(String accessToken) {
        Graph graph = Graph.getInstance();
        GraphServiceClient<Request> graphClient = graph.getGraphClient();
        return graphClient;
    }
}

