/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.ReportSchedulerElement;
import com.parablu.pc.timer.helper.SchedulerResponseHandler;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.User;
import com.parablu.report.service.ReportService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class SendStorageUtilizationReportTimerNew
extends QuartzJobBean {
    private static Logger logger = LogManager.getLogger(SendStorageUtilizationReportTimerNew.class);
    private LicenseService licenseService;
    private UserManagementService userManagementService;
    private CloudMailService cloudMailService;
    private ReportService reportService;
    private int cloudId;
    private String cloudName;
    private String currentDate = LocalDate.now().toString();

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"sendStorageUtilizationReport")) {
            logger.debug("SendStorageUtilizationReportTimer .......... disabled");
            return;
        }
        List clouds = this.licenseService.getClouds();
        Cloud cloud = (Cloud)clouds.get(0);
        this.cloudId = cloud.getCloudId();
        this.cloudName = cloud.getCloudName();
        ReportSchedulerElement reportConfigBySchedulerName = null;
        ReportQueryElement reportQueryElement = new ReportQueryElement();
        try {
            String schedulerId = arg0.getJobDetail().getDescription();
            logger.debug("schedulerId.... " + schedulerId);
            reportConfigBySchedulerName = this.reportService.getReportConfigById(cloud.getCloudId(), schedulerId);
            if (reportConfigBySchedulerName != null) {
                BeanUtils.copyProperties((Object)reportQueryElement, (Object)reportConfigBySchedulerName);
            }
        }
        catch (Exception e) {
            logger.debug("" + e);
            logger.error("" + e.getCause());
        }
        CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(this.cloudId);
        String userName = null;
        List<User> users = SchedulerResponseHandler.getValidUsers(reportConfigBySchedulerName, reportQueryElement, cloud, this.userManagementService);
        reportQueryElement.setUserName(userName);
        this.reportService.createExcelForDailyBkpOverview(cloud, reportQueryElement, cloudPropertyElement.isShowLatestBkpInfo(), cloudPropertyElement.isHideCompressedSize());
        int userCount = users.size();
        int userProccessed = 0;
        boolean deleteAttachment = false;
        for (User user : users) {
            if (userCount == ++userProccessed) {
                deleteAttachment = true;
            }
            this.sendEmail(user, reportConfigBySchedulerName, deleteAttachment);
        }
    }

    private void sendEmail(User user, ReportSchedulerElement reportConfigBySchedulerName, boolean deleteAttachment) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("storage-utilization-report");
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(user.getUserName());
        emailRecipent.setEmail(user.getEmailId());
        email.setActionBy(user.getUserName());
        email.setSubject(reportConfigBySchedulerName.getDisplayName());
        String fileName = "Storage_Utilization_Report.xlsx";
        if (!StringUtils.isEmpty((String)reportConfigBySchedulerName.getDisplayName())) {
            fileName = "Storage_Utilization_Report_From_Scheduler_" + reportConfigBySchedulerName.getDisplayName() + ".xlsx";
        }
        email.setAttachFileName(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/bkpOverview/" + fileName);
        email.setToUser(true);
        email.setDeleteAttachment(deleteAttachment);
        email.setStartDate(reportConfigBySchedulerName.getDisplayName());
        emailRecipents.add(emailRecipent);
        if (!emailRecipents.isEmpty()) {
            logger.debug(" @@@ Before sending mail ");
            try {
                email.setRecipents(emailRecipents);
                this.cloudMailService.sendMail(email);
            }
            catch (Exception e) {
                logger.debug("" + e.getMessage(), (Throwable)e);
                logger.error("Error in Sending Mail");
            }
            logger.error("after sending mail");
        }
    }
}

