/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.constant.Report;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.ReportSchedulerElement;
import com.parablu.pc.timer.helper.SchedulerResponseHandler;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.User;
import com.parablu.report.service.ReportService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.StatefulJob;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class SendBackupSummeryReport
extends QuartzJobBean
implements StatefulJob {
    private static Logger logger = LogManager.getLogger(SendBackupSummeryReport.class);
    private static final String URL = "%s/paracloud/versions/2.2/clouds/%s/report";
    private ReportService reportService;
    private LicenseService licenseService;
    private CloudMailService cloudMailService;
    private UserManagementService userManagementService;

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"sendBackupSummeryReport")) {
            logger.debug("sendBackupSummeryReport ....... disabled");
            return;
        }
        ReportSchedulerElement reportConfigBySchedulerName = null;
        ReportQueryElement reportQueryElement = new ReportQueryElement();
        try {
            String schedulerId = context.getJobDetail().getDescription();
            logger.debug("schedulerId.... " + schedulerId);
            reportConfigBySchedulerName = this.reportService.getReportConfigById(1, schedulerId);
            if (reportConfigBySchedulerName != null) {
                BeanUtils.copyProperties((Object)reportQueryElement, (Object)reportConfigBySchedulerName);
            }
        }
        catch (Exception e) {
            logger.debug("" + e);
            logger.error("" + e.getCause());
        }
        int noOfDays = reportQueryElement.getNoOfDays();
        logger.debug("   start of job SendBackupSummeryReport .... " + noOfDays);
        if (noOfDays <= 0) {
            logger.debug("no of days must be more than 0");
            return;
        }
        logger.debug("no of days :" + noOfDays);
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            List<User> users = SchedulerResponseHandler.getValidUsers(reportConfigBySchedulerName, reportQueryElement, cloud, this.userManagementService);
            reportQueryElement.setNoOfDays(noOfDays);
            String productType = "BACKUP";
            if (StringUtils.isNotEmpty((String)reportQueryElement.getProductType())) {
                productType = reportQueryElement.getProductType();
            }
            reportQueryElement.setProductType(productType);
            reportQueryElement.setOperationType(ReportQueryElement.ReportOperation.GENERATE_EXCEL);
            reportQueryElement.setReport(Report.DATA_PROTECTION_SCORECARD.toString());
            String paracloudUrl = PCHelperConstant.getPropertyFileValueParacloudUrl();
            String cloudName = ((Cloud)clouds.get(0)).getCloudName();
            String apiUrl = String.format(URL, paracloudUrl, cloudName);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("internal-call", "true");
            HttpEntity requestEntity = new HttpEntity((Object)reportQueryElement, (MultiValueMap)headers);
            logger.debug("making a call to api={}, for generating the data protection scorecard report", (Object)apiUrl);
            ResponseEntity responseEntity = new RestTemplate().postForEntity(apiUrl, (Object)requestEntity, Object.class, new Object[0]);
            logger.debug("Received a response from the api to create report");
            if (responseEntity != null && responseEntity.getStatusCode().is2xxSuccessful()) {
                logger.debug("creating a report is successfully completed");
                int userCount = users.size();
                int userProccessed = 0;
                boolean deleteAttachment = false;
                for (User user : users) {
                    if (userCount == ++userProccessed) {
                        deleteAttachment = true;
                    }
                    this.sendEmail(user, reportConfigBySchedulerName, deleteAttachment);
                }
                continue;
            }
            logger.debug("There is an error while creating a report");
        }
    }

    private void sendEmail(User user, ReportSchedulerElement reportConfigBySchedulerName, boolean deleteAttachment) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("backup-Summery");
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(user.getUserName());
        emailRecipent.setEmail(user.getEmailId());
        email.setActionBy(user.getUserName());
        email.setToUser(true);
        email.setStartDate(reportConfigBySchedulerName.getDisplayName());
        String fileName = "DataProtectionScorecard.xlsx";
        if (!StringUtils.isEmpty((String)reportConfigBySchedulerName.getDisplayName())) {
            fileName = "DataProtectionScorecard_From_Scheduler_" + reportConfigBySchedulerName.getDisplayName() + ".xlsx";
        }
        email.setAttachFileName(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/" + fileName);
        email.setDeleteAttachment(deleteAttachment);
        email.setStartDate(reportConfigBySchedulerName.getDisplayName());
        email.setDeleteAttachment(deleteAttachment);
        logger.debug("............");
        emailRecipents.add(emailRecipent);
        if (!emailRecipents.isEmpty()) {
            logger.debug(" @@@ Before sending mail ");
            email.setRecipents(emailRecipents);
            try {
                this.cloudMailService.sendMail(email);
            }
            catch (Exception e) {
                logger.debug("" + e);
                logger.error("Error in Sending Mail");
            }
            logger.error("after sending mail");
        }
    }
}

