/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.constant.Report;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.ReportSchedulerElement;
import com.parablu.pc.timer.helper.SchedulerResponseHandler;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.User;
import com.parablu.report.service.ReportService;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class SendBackupHistoryTimer
extends QuartzJobBean {
    private static final String URL = "%s/paracloud/versions/2.2/clouds/%s/report";
    private static Logger logger = LogManager.getLogger(SendBackupHistoryTimer.class);
    private LicenseService licenseService;
    private UserManagementService userManagementService;
    private CloudMailService cloudMailService;
    private ReportService reportService;
    private String noOfDays;
    private int cloudId;
    private String cloudName;
    private String currentDate = LocalDate.now().toString();
    private DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private static final String YYYY_MM_DD = "MM/dd/yyyy";
    private Date date = new Date();
    private String endDate = this.dateFormat.format(this.date);

    public void setNoOfDays(String noOfDays) {
        this.noOfDays = noOfDays;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"sendBackupHistory")) {
            logger.debug("SendBackupHistoryTimer ........... disbled");
            return;
        }
        logger.debug("   start of job SendBackupHistoryTimer .... ");
        List clouds = this.licenseService.getClouds();
        Cloud cloud = (Cloud)clouds.get(0);
        this.cloudId = cloud.getCloudId();
        this.cloudName = cloud.getCloudName();
        ReportSchedulerElement reportConfigBySchedulerName = null;
        ReportQueryElement reportQueryElement = new ReportQueryElement();
        try {
            String schedulerId = arg0.getJobDetail().getDescription();
            logger.debug("schedulerId.... " + schedulerId);
            reportConfigBySchedulerName = this.reportService.getReportConfigById(cloud.getCloudId(), schedulerId);
            if (reportConfigBySchedulerName != null) {
                BeanUtils.copyProperties((Object)reportQueryElement, (Object)reportConfigBySchedulerName);
            }
        }
        catch (Exception e) {
            logger.debug("" + e);
            logger.error("" + e.getCause());
        }
        int startDate = 0;
        startDate = reportQueryElement.getNoOfDays();
        logger.debug("inside get report....startDate........" + startDate);
        if (startDate != 0) {
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat dateFormat = new SimpleDateFormat(YYYY_MM_DD);
            cal.add(5, -startDate);
            String startTime = dateFormat.format(cal.getTime());
            reportQueryElement.setEndDate(this.endDate);
            reportQueryElement.setStartDate(startTime);
            reportConfigBySchedulerName.setEndDate(this.endDate);
            reportConfigBySchedulerName.setStartDate(startTime);
            logger.debug("inside get report....startDate........" + this.endDate);
            logger.debug("inside get report....startDate........" + startTime);
        }
        List<User> users = SchedulerResponseHandler.getValidUsers(reportConfigBySchedulerName, reportQueryElement, cloud, this.userManagementService);
        reportQueryElement.setOperationType(ReportQueryElement.ReportOperation.GENERATE_EXCEL);
        reportQueryElement.setReport(Report.BACKUP_HISTORY.toString());
        String paracloudUrl = PCHelperConstant.getPropertyFileValueParacloudUrl();
        String cloudName = ((Cloud)clouds.get(0)).getCloudName();
        String apiUrl = String.format(URL, paracloudUrl, cloudName);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("internal-call", "true");
        HttpEntity requestEntity = new HttpEntity((Object)reportQueryElement, (MultiValueMap)headers);
        logger.debug("making a call to api={}, for generating the data protection scorecard report", (Object)apiUrl);
        ResponseEntity responseEntity = new RestTemplate().postForEntity(apiUrl, (Object)requestEntity, Object.class, new Object[0]);
        logger.debug("Received a response from the api to create report");
        if (responseEntity != null && responseEntity.getStatusCode().is2xxSuccessful()) {
            logger.debug("creating a report is successfully completed");
            int userCount = users.size();
            int userProccessed = 0;
            boolean deleteAttachment = false;
            for (User user : users) {
                if (userCount == ++userProccessed) {
                    deleteAttachment = true;
                }
                this.sendEmail(user, reportConfigBySchedulerName, deleteAttachment);
            }
        } else {
            logger.debug("There is an error while creating a report");
        }
    }

    private void sendEmail(User user, ReportSchedulerElement reportConfigBySchedulerName, boolean deleteAttachment) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("backup-history-report");
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(user.getUserName());
        emailRecipent.setEmail(user.getEmailId());
        email.setActionBy(user.getUserName());
        email.setToUser(true);
        String fileName = "BackupHistory.xlsx";
        if (!StringUtils.isEmpty((String)reportConfigBySchedulerName.getDisplayName())) {
            fileName = "BackupHistory_From_Scheduler_" + reportConfigBySchedulerName.getDisplayName() + ".xlsx";
        }
        email.setAttachFileName(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/bkpOverview/" + fileName);
        email.setDeleteAttachment(deleteAttachment);
        email.setStartDate(reportConfigBySchedulerName.getDisplayName());
        emailRecipents.add(emailRecipent);
        if (!emailRecipents.isEmpty()) {
            logger.debug(" @@@ Before sending mail ");
            email.setRecipents(emailRecipents);
            try {
                this.cloudMailService.sendMail(email);
            }
            catch (Exception e) {
                logger.debug("" + e);
                logger.error("Error in Sending Mail");
            }
            logger.debug("...after sending mail......");
        }
    }
}

