/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.ListInfo;
import com.microsoft.graph.models.Site;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.DriveCollectionPage;
import com.microsoft.graph.requests.DriveCollectionRequest;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.ListCollectionRequest;
import com.microsoft.graph.requests.SiteCollectionPage;
import com.microsoft.graph.requests.SiteCollectionRequest;
import com.microsoft.graph.requests.SiteCollectionRequestBuilder;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.microsoft.graph.requests.UserRequestBuilder;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pc.timer.helper.Graph;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import okhttp3.Request;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class PBDriveRegistryJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(PBDriveRegistryJob.class);
    private LicenseService licenseService;
    private UserManagementService userManagementService;

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"pbDriveRegistryJobTrigger")) {
            logger.debug("pbDriveRegistryJobTrigger ........... disabled");
            return;
        }
        logger.debug("@@@@PBDriveRegistryJob started ..... ");
        List clouds = this.licenseService.getClouds();
        Cloud cloud = clouds.stream().findFirst().orElse(null);
        boolean isOneDriveForBusinessBackupEnabled = this.isOneDriveForBusinessBackupEnabled(cloud);
        logger.debug("@@@@PBDriveRegistryJob started flag ..... " + isOneDriveForBusinessBackupEnabled);
        if (isOneDriveForBusinessBackupEnabled) {
            try {
                logger.debug("@@@@PBDriveRegistryJob started ..... ");
                this.createPBFolderForOdUsers(cloud);
                logger.debug(" exit upload part..........");
            }
            catch (Exception e) {
                logger.error(" exception in PBDriveRegistryJob ......." + e.getMessage());
                logger.trace("exception in PBDriveRegistryJob ......." + e);
            }
            logger.debug("@@@@PBDriveRegistryJob started ..... ");
        }
    }

    private boolean isOneDriveForBusinessBackupEnabled(Cloud cl) {
        boolean isExpiredFileDeleteEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"ODB Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    private void createPBFolderForOdUsers(Cloud cloud) {
        List usersWithoutDeviceList = this.userManagementService.getAllActiveUsers(cloud.getCloudId());
        if (!CollectionUtils.isEmpty((Collection)usersWithoutDeviceList)) {
            for (com.parablu.pcbd.domain.User user : usersWithoutDeviceList) {
                try {
                    DriveCollectionPage driveCollectionPages;
                    String userId;
                    GraphServiceClient<Request> graphClient;
                    String emailId;
                    block20: {
                        if (user == null) continue;
                        emailId = user.getEmailId();
                        if (!StringUtils.isEmpty((String)user.getOdbLoginId())) {
                            emailId = user.getOdbLoginId();
                        }
                        boolean muxedEnabled = false;
                        if (StringUtils.isNotEmpty((String)PCHelperConstant.getOneDriveBackupType()) && PCHelperConstant.getOneDriveBackupType().equalsIgnoreCase("MUX")) {
                            muxedEnabled = true;
                        }
                        if (muxedEnabled && StringUtils.isEmpty((String)user.getOdbLoginId())) {
                            boolean targetAssigned = false;
                            int backupTargetErrorCode = 201;
                            logger.debug(user.getUserName() + "...muxedEnabled..." + muxedEnabled + "...user OdbLoginId is empty or return...");
                            this.userManagementService.updateTargetStatus(1, targetAssigned, backupTargetErrorCode, user.getUserName());
                            continue;
                        }
                        Graph graph = Graph.getInstance();
                        graphClient = graph.getGraphClient();
                        ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
                        requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
                        UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
                        userId = "";
                        for (User userObj : iUserCollectionPage.getCurrentPage()) {
                            logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                            userId = userObj.id;
                        }
                        if (StringUtils.isEmpty((String)userId)) {
                            requestOptions = new ArrayList();
                            requestOptions.add(new QueryOption("$filter", (Object)("userPrincipalName eq '" + emailId + "'")));
                            iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
                            for (User userObj : iUserCollectionPage.getCurrentPage()) {
                                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                                userId = userObj.id;
                            }
                        }
                        logger.debug(user.getUserName() + "....." + emailId + "....user and userid....." + userId);
                        if (StringUtils.isEmpty((String)userId)) {
                            boolean targetAssigned = false;
                            int backupTargetErrorCode = 201;
                            this.userManagementService.updateTargetStatus(1, targetAssigned, backupTargetErrorCode, user.getUserName());
                            continue;
                        }
                        UserRequestBuilder users = graphClient.users(userId);
                        driveCollectionPages = null;
                        try {
                            driveCollectionPages = (DriveCollectionPage)((DriveCollectionRequest)users.drives().buildRequest(new Option[0])).get();
                        }
                        catch (GraphServiceException ee) {
                            if (ee.getResponseCode() != 404) break block20;
                            boolean targetAssigned = false;
                            int backupTargetErrorCode = 202;
                            this.userManagementService.updateTargetStatus(1, targetAssigned, backupTargetErrorCode, user.getUserName());
                            continue;
                        }
                    }
                    String pbFolderItemId = "";
                    for (Drive drive : driveCollectionPages.getCurrentPage()) {
                        if (!PBDriveRegistryJob.isPBDrive(drive.webUrl)) continue;
                        pbFolderItemId = drive.id;
                    }
                    logger.debug(userId + "....user and pbFolderItemId....." + pbFolderItemId);
                    if (StringUtils.isEmpty((String)pbFolderItemId)) {
                        Long total = 0L;
                        try {
                            logger.debug(".....tryto get pb for quota...." + emailId);
                            Drive driveObj = graphClient.users(userId).drive().buildRequest(new Option[0]).get();
                            logger.debug(".....after get pb for quota...." + driveObj);
                            total = driveObj.quota.total;
                        }
                        catch (GraphServiceException e) {
                            logger.error("...errror trying to get size for drive.." + e.getMessage());
                        }
                        catch (Exception ee) {
                            logger.error("...errror trying to get size for drive..");
                        }
                        logger.debug(".....pb for total...." + total);
                        if (total < 50000000000L) {
                            boolean targetAssigned = false;
                            int backupTargetErrorCode = 203;
                            this.userManagementService.updateTargetStatus(1, targetAssigned, backupTargetErrorCode, user.getUserName());
                            continue;
                        }
                        logger.debug(".....trytocreate pb for email...." + emailId);
                        this.createDriveInsideList(graphClient, emailId, user.getUserName(), userId);
                        continue;
                    }
                    this.userManagementService.updateTargetStatus(1, true, 0, user.getUserName());
                }
                catch (GraphServiceException ee) {
                    ee.printStackTrace();
                    logger.error("....graph exception trying to create PB library...." + ee.getMessage());
                    boolean targetAssigned = false;
                    int backupTargetErrorCode = ee.getResponseCode();
                    this.userManagementService.updateTargetStatus(1, targetAssigned, backupTargetErrorCode, user.getUserName());
                }
                catch (Exception e) {
                    logger.error("exception inside BackupUploadJob .... " + e.getMessage());
                    logger.trace("exception inside BackupUploadJob ...." + e);
                }
            }
        }
    }

    private void createDriveInsideList(GraphServiceClient<Request> graphClient, String emailId, String userName, String userId) {
        SiteCollectionPage siteCollectionPage = (SiteCollectionPage)((SiteCollectionRequest)graphClient.sites().buildRequest(new Option[0])).get();
        String siteId = "";
        List currentPageVal = null;
        SiteCollectionRequestBuilder nextPage = (SiteCollectionRequestBuilder)siteCollectionPage.getNextPage();
        String url = PCHelperConstant.getPersonalSite((String)PCHelperConstant.getMSSharePointUrl(), (String)emailId);
        ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
        requestOptions.add(new QueryOption("$select", (Object)"mySite"));
        User user = graphClient.users(userId).buildRequest(requestOptions).get();
        boolean targetAssigned = false;
        int backupTargetErrorCode = 0;
        if (StringUtils.isEmpty((String)user.mySite)) {
            logger.error("...site not available.....");
            backupTargetErrorCode = 404;
            targetAssigned = false;
            this.userManagementService.updateTargetStatus(1, targetAssigned, backupTargetErrorCode, userName);
            return;
        }
        url = user.mySite;
        if (user.mySite.endsWith("/")) {
            int lastIndex = url.lastIndexOf(47);
            url = url.substring(0, lastIndex);
        }
        try {
            do {
                currentPageVal = siteCollectionPage.getCurrentPage();
                for (Site site : siteCollectionPage.getCurrentPage()) {
                    logger.debug("....insidennn..." + site.webUrl);
                    if (StringUtils.isEmpty((String)site.webUrl) || !site.webUrl.equalsIgnoreCase(url)) continue;
                    siteId = site.id;
                    logger.debug(site.webUrl + "..foundsite..." + siteId);
                    break;
                }
                if ((nextPage = (SiteCollectionRequestBuilder)siteCollectionPage.getNextPage()) == null) continue;
                siteCollectionPage = (SiteCollectionPage)((SiteCollectionRequest)nextPage.buildRequest(new Option[0])).get();
            } while (StringUtils.isEmpty((String)siteId) && currentPageVal.size() > 0 && nextPage != null && siteCollectionPage != null && nextPage != null);
            if (StringUtils.isEmpty((String)siteId)) {
                logger.error("...site not available.....");
                backupTargetErrorCode = 404;
                targetAssigned = false;
                this.userManagementService.updateTargetStatus(1, targetAssigned, backupTargetErrorCode, userName);
                return;
            }
            Site site = graphClient.sites(siteId).buildRequest(new Option[0]).get();
            logger.debug("..before creating.." + site.name + "...." + site.webUrl);
            com.microsoft.graph.models.List list = new com.microsoft.graph.models.List();
            list.displayName = "PB";
            list.description = "MY Description";
            ListInfo listInfo = new ListInfo();
            listInfo.template = "documentLibrary";
            list.list = listInfo;
            ((ListCollectionRequest)graphClient.sites(siteId).lists().buildRequest(new Option[0])).post(list);
            targetAssigned = true;
        }
        catch (GraphServiceException ee) {
            logger.error("....graph exception trying to create PB library...." + ee.getMessage());
            backupTargetErrorCode = ee.getResponseCode();
        }
        catch (Exception e) {
            logger.error("....exception trying to create PB library...." + e.getMessage());
            backupTargetErrorCode = 404;
        }
        this.userManagementService.updateTargetStatus(1, targetAssigned, backupTargetErrorCode, userName);
    }

    private static boolean isPBDrive(String webUrl) {
        boolean pbDrive = false;
        try {
            String docLibraryName = webUrl.substring(webUrl.lastIndexOf("/") + 1);
            if (!StringUtils.isEmpty((String)docLibraryName) && docLibraryName.equalsIgnoreCase("PB")) {
                pbDrive = true;
            }
        }
        catch (Exception e) {
            logger.error(webUrl + "...unable to get drive .... " + e.getMessage());
            pbDrive = false;
        }
        return pbDrive;
    }

    protected GraphServiceClient<Request> getGraphClient(String accessToken) {
        Graph graph = Graph.getInstance();
        GraphServiceClient<Request> graphClient = graph.getGraphClient();
        return graphClient;
    }
}

