/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.microsoft.graph.requests.UserCollectionRequestBuilder;
import com.parablu.bluvault.udc.service.PciAuthorizationTokensService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.pc.timer.helper.Graph;
import com.parablu.pcbd.domain.Cloud;
import java.util.List;
import okhttp3.Request;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class MsgTokenUpdateJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(MsgTokenUpdateJob.class);
    private LicenseService licenseService;
    private PciAuthorizationTokensService pciAuthorizationTokensService;

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setPciAuthorizationTokensService(PciAuthorizationTokensService pciAuthorizationTokensService) {
        this.pciAuthorizationTokensService = pciAuthorizationTokensService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        try {
            List jobs = arg0.getScheduler().getCurrentlyExecutingJobs();
            if (jobs != null && !jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (!job.getTrigger().equals((Object)arg0.getTrigger()) || job.getJobInstance().equals((Object)this)) continue;
                    logger.debug("There's another instance running,SO skipping>>>>>>>>>>>>> : " + (Object)((Object)this));
                    return;
                }
            }
        }
        catch (SchedulerException e) {
            logger.debug("" + (Object)((Object)e));
            logger.error("" + e.getCause());
        }
        List clouds = this.licenseService.getClouds();
        Cloud cloud = clouds.stream().findFirst().orElse(null);
        String accessToken = this.pciAuthorizationTokensService.getAccessTokenForODBBackup(cloud.getCloudId());
        if (accessToken == null) {
            logger.error("....Token not mapped....");
            return;
        }
        try {
            Graph graph = Graph.getInstance();
            GraphServiceClient<Request> graphClient = graph.getGraphClient();
            UserCollectionRequestBuilder usersRequestBuilder = graphClient.users();
            ((UserCollectionRequest)usersRequestBuilder.buildRequest(new Option[0])).get();
        }
        catch (GraphServiceException e) {
            logger.error(" ... error trying to get token ..." + e.getResponseCode());
            if (e.getResponseCode() == 401) {
                boolean updateToken = this.pciAuthorizationTokensService.updateTokenForODBBackup(cloud.getCloudId());
                if (updateToken) {
                    accessToken = this.pciAuthorizationTokensService.getAccessTokenForODBBackup(cloud.getCloudId());
                    Graph graph = Graph.getInstance();
                    GraphServiceClient<Request> graphClient = graph.getGraphClient();
                    UserCollectionRequestBuilder usersRequestBuilder = graphClient.users();
                    ((UserCollectionRequest)usersRequestBuilder.buildRequest(new Option[0])).get();
                    logger.debug(" ...updated token  successfully...");
                }
            } else if (e.getResponseCode() == 404) {
                logger.error("... not able to access resource .... ");
            }
        }
        catch (Exception ee) {
            logger.error(".... exception......" + ee.getMessage());
        }
    }
}

