/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.cloud.security.service.LicenseService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.domain.Cloud;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class LicenseUpdateTimer
extends QuartzJobBean {
    private Logger logger = LogManager.getLogger(LicenseUpdateTimer.class);
    private LicenseService licenseService;

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"licenseCheckTrigger")) {
            this.logger.debug("LicenseUpdateTimer .............. disabled");
            return;
        }
        List clouds = this.licenseService.getClouds();
        if (clouds == null) {
            return;
        }
        for (Cloud cloud : clouds) {
            int licenseUpdateStatus = this.licenseService.updateLicenseFromParabluApi(cloud.getCloudName());
            this.logger.debug("Status After License Update =" + licenseUpdateStatus);
        }
        this.licenseService.reInitialiseCloudMappings();
    }
}

