/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.settings.service.SettingsService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.domain.Cloud;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class LicenseKeyTamperTimer
extends QuartzJobBean {
    private static Logger logger = LogManager.getLogger(LicenseKeyTamperTimer.class);
    private LicenseService licenseService;
    private SettingsService settingsService;
    private AuditHistoryService auditHistoryService;

    public void setAuditHistoryService(AuditHistoryService auditHistoryService) {
        this.auditHistoryService = auditHistoryService;
    }

    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"licenseKeyTamperTimer")) {
            logger.debug("licenseKeyTamperTimer  ....... disabled");
            return;
        }
        logger.debug("%%%%%%%%%%%%% licenseKey Tamper RsTimer started....%%%%%%%%%%%%%");
        String fileName = null;
        String operation = "tamper";
        try {
            HttpServletResponse response = null;
            List clouds = this.licenseService.getClouds();
            Cloud cloud = clouds.stream().findFirst().orElse(null);
            String cloudName = cloud.getCloudName();
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            int cloudId = cl.getCloud().getCloudId();
            logger.debug("cloudId.." + cloudId);
            fileName = cloud.getLicenseKeyFileName();
            if (StringUtils.isEmpty((String)cloudName) || StringUtils.isEmpty((String)fileName)) {
                logger.debug("cloudName/fileName is empty ......");
                this.settingsService.addTamperDetection("", "License key not found on the server", true);
                logger.debug("after add TamperDetection......");
                this.settingsService.updateCloud(cloudName);
                this.auditHistoryService.saveStatisticToDatabase(1, cloudName, "Tampering detected-License key not found on the server", "", "", "Portal", System.currentTimeMillis(), PCActionTypes.LICENSE_KEY.getActionTypeValue());
                this.settingsService.saveBrandingPropertyToRestartServices(cloudId);
                return;
            }
            logger.debug("fileName to check tamper .." + fileName);
            this.settingsService.updateLicense(fileName, operation, response, cloudName, "", this.auditHistoryService, cloud, cloudId);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("...error " + e.getMessage());
        }
    }
}

