/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.UserElement;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.SharedFileImage;
import com.parablu.pcbd.domain.User;
import com.parablu.report.service.ReportService;
import com.parablu.share.service.SharedFileImageService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class FileShareLinkExpiryTimer
extends QuartzJobBean {
    public static final String EMAIL_IDS = "emailIds";
    private Logger logger = LogManager.getLogger(FileShareLinkExpiryTimer.class);
    private static final String EXCEPTION = "Exception :";
    private SharedFileImageService sharedFileImageService;
    private LicenseService licenseService;
    private CloudMailService cloudMailService;
    private ReportService reportService;
    private UserManagementService userManagementService;

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setSharedFileImageService(SharedFileImageService sharedFileImageService) {
        this.sharedFileImageService = sharedFileImageService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"fileShareLinkExpiryTrigger")) {
            this.logger.debug("FileShareLinkExpiryTimer ............... disabled");
            return;
        }
        this.logger.debug("   start of job to check for FileShareLinkExpiryTimer .... ");
        try {
            List clouds = this.licenseService.getClouds();
            if (!CollectionUtils.isEmpty((Collection)clouds)) {
                for (Cloud cloud : clouds) {
                    List shareList = this.sharedFileImageService.getAllSharedFilesWithLinkExpiry();
                    Map reportConfigProperties = this.reportService.getReportConfig(cloud.getCloudId(), "fileShareLinkExpiry");
                    for (SharedFileImage sharedFileImage : shareList) {
                        Date date = new Date(sharedFileImage.getValidUntil());
                        DateTime validityPeriod = new DateTime((Object)date);
                        DateTime currentDateTime = new DateTime();
                        boolean isCurrentTimeGreater = currentDateTime.toDate().getTime() > validityPeriod.toDate().getTime();
                        long difference = FileShareLinkExpiryTimer.removeTime(validityPeriod.toDate()).getTime() - FileShareLinkExpiryTimer.removeTime(currentDateTime.toDate()).getTime();
                        int daysDiff = (int)(difference / 86400000L);
                        if (daysDiff > 0) {
                            --daysDiff;
                        }
                        this.logger.debug(sharedFileImage.getFileName() + "...Days Difference for share.. " + daysDiff);
                        ArrayList<String> emailIds = new ArrayList();
                        if (!StringUtils.isEmpty((String)sharedFileImage.getToEmailList())) {
                            String strSpaceRemoval = sharedFileImage.getToEmailList().replaceAll(" ", "");
                            emailIds = Arrays.asList(sharedFileImage.getToEmailList().split(","));
                        }
                        if (reportConfigProperties.get("days") != null) {
                            ArrayList<Integer> compareDay = this.getIntegerArray(reportConfigProperties.get("days").toString());
                            if (daysDiff < 0 || !compareDay.contains(daysDiff)) continue;
                            UserElement user = this.userManagementService.getUserByUserName(cloud, sharedFileImage.getUserName());
                            String actionBy = sharedFileImage.getUserName();
                            if (user != null) {
                                actionBy = user.getUserName().equalsIgnoreCase(user.getEmailId()) ? user.getUserName() : user.getUserName() + " (" + user.getEmailId() + ")";
                            }
                            this.sendmail(cloud, emailIds, date, sharedFileImage.getDownloadLink(), actionBy);
                            continue;
                        }
                        this.logger.debug("... fileShareLinkExpiry reportConfig is empty  specify days .... ");
                    }
                }
            } else {
                this.logger.debug("   cloud is empty .... ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.trace(EXCEPTION + e);
            this.logger.error(EXCEPTION + e.getMessage());
        }
    }

    private ArrayList<Integer> getIntegerArray(String string) {
        List<String> stringArray = Arrays.asList(string.split(","));
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String stringValue : stringArray) {
            try {
                result.add(Integer.parseInt(stringValue));
            }
            catch (NumberFormatException e) {
                this.logger.trace(EXCEPTION + e);
                this.logger.error(EXCEPTION + e.getMessage());
            }
        }
        return result;
    }

    private void sendmail(Cloud cloud, List<String> userMailIds, Date validityPeriod, String downloadLink, String actionBy) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setDownloadLink(downloadLink);
        email.setActionBy(actionBy);
        email.setAction("fileshare-expiry-notification");
        email.setClientMailName(PCHelperConstant.getClientMailName());
        email.setCloudName(cloud.getCloudName());
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
        sdf.setTimeZone(TimeZone.getTimeZone("IST"));
        email.setStartDate(sdf.format(validityPeriod));
        for (String userEmail : userMailIds) {
            EmailRecipent emailRecipent = new EmailRecipent();
            User user = this.userManagementService.getUserDetailsForEmail(cloud.getCloudId(), userEmail);
            if (user != null) {
                emailRecipent.setUserName(user.getUserName());
            }
            emailRecipent.setEmail(userEmail);
            emailRecipents.add(emailRecipent);
        }
        this.logger.debug(" @@@ Before sending mail with user fileshare-expiry-notification ");
        email.setRecipents(emailRecipents);
        this.cloudMailService.sendMail(email);
    }

    public static Date removeTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }
}

