/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.UserElement;
import com.parablu.paracloud.util.CacheHelper;
import com.parablu.paracloud.util.DiskSpaceHelper;
import com.parablu.pcbd.domain.Cloud;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class DiskUsageNotifierTimer
extends QuartzJobBean {
    private Logger logger = LogManager.getLogger(DiskUsageNotifierTimer.class);
    private LicenseService licenseService;
    private UserManagementService managementService;
    private CloudMailService cloudMailService;
    private static String diskSpaceNotifierEmail90 = "DISK_SPACE_NOTIFIER_MAIL_90";
    private static String diskSpaceNotifierEmail99 = "DISK_SPACE_NOTIFIER_MAIL_99";
    private static final String IO_EXCEPTION = "IOException : ";

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setManagementService(UserManagementService managementService) {
        this.managementService = managementService;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"diskSpaceNotifierTrigger")) {
            this.logger.debug("DiskUsageNotifierTimer .............. disabled");
            return;
        }
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            long total;
            CloudLicenseTo cloudLicenseTo = this.licenseService.validateLicense(cloud.getCloudName());
            long used = DiskSpaceHelper.spaceUsedInMB((String)cloud.getCloudName());
            long a = used / (total = (long)cloudLicenseTo.getCloud().getCloudSizeAllowed()) * 100L;
            if (a <= 92L && a >= 88L) {
                this.logger.debug("SENDING EMAIL..90 used: " + used + " total: " + total);
                this.sendEmail(cloud.getCloudId(), cloud.getCloudName());
                continue;
            }
            if (a > 100L || a < 95L) continue;
            this.logger.debug(" SENDING EMAIL..99 used: " + used + " total: " + total);
            this.sendEmail(cloud.getCloudId(), cloud.getCloudName());
        }
    }

    private void sendEmail(int cloudId, String cloudName) {
        if (!this.isEmailAlreadySent(cloudName, diskSpaceNotifierEmail90)) {
            EmailProps props = new EmailProps();
            props.setAction("disk-space-90-notifier");
            List elements = this.managementService.getAllUsers(cloudId, cloudName, false, false);
            if (!CollectionUtils.isEmpty((Collection)elements)) {
                ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
                for (UserElement element : elements) {
                    EmailRecipent emailRecipent = new EmailRecipent();
                    emailRecipent.setUserName(element.getUserName());
                    emailRecipent.setEmail(element.getEmailId());
                    if (PCHelperConstant.getPropertyFileValueEmailsToadminsOnly()) {
                        if (!element.isAdmin()) continue;
                        emailRecipents.add(emailRecipent);
                        continue;
                    }
                    emailRecipents.add(emailRecipent);
                }
                if (!emailRecipents.isEmpty()) {
                    props.setRecipents(emailRecipents);
                    this.cloudMailService.sendMail(props);
                    this.setEmailAlreadySent(diskSpaceNotifierEmail90 + cloudName);
                }
            }
        } else if (!this.isEmailAlreadySent(cloudName, diskSpaceNotifierEmail99)) {
            EmailProps props = new EmailProps();
            props.setAction("disk-space-99-notifier");
            List elements = this.managementService.getAllUsers(cloudId, cloudName, false, false);
            if (!CollectionUtils.isEmpty((Collection)elements)) {
                ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
                for (UserElement element : elements) {
                    EmailRecipent emailRecipent = new EmailRecipent();
                    emailRecipent.setUserName(element.getUserName());
                    emailRecipent.setEmail(element.getEmailId());
                    if (PCHelperConstant.getPropertyFileValueEmailsToadminsOnly()) {
                        if (!element.isAdmin()) continue;
                        emailRecipents.add(emailRecipent);
                        continue;
                    }
                    emailRecipents.add(emailRecipent);
                }
                if (!emailRecipents.isEmpty()) {
                    props.setRecipents(emailRecipents);
                    this.cloudMailService.sendMail(props);
                    this.setEmailAlreadySent(diskSpaceNotifierEmail99 + cloudName);
                }
            }
        }
    }

    private boolean isEmailAlreadySent(String cloudName, String key) {
        try {
            CacheHelper cacheHelper = new CacheHelper();
            String a = cacheHelper.getValueFromCache(key + cloudName);
            if (a == null) {
                return false;
            }
        }
        catch (IOException e) {
            this.logger.error(IO_EXCEPTION + e.getMessage());
            this.logger.debug(IO_EXCEPTION + e);
        }
        return true;
    }

    private boolean setEmailAlreadySent(String key) {
        try {
            CacheHelper cacheHelper = new CacheHelper();
            cacheHelper.addValueToCache(key, "true", 86400);
        }
        catch (IOException e) {
            this.logger.error(IO_EXCEPTION + e.getMessage());
            this.logger.debug(IO_EXCEPTION + e);
        }
        return true;
    }
}

