/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.backup.service.BackupDataCleanerService;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.DeletedUser;
import com.parablu.pcbd.domain.Device;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class DeletedUserCleanerTimer
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(DeletedUserCleanerTimer.class);
    private BackupDataCleanerService backupDataCleanerService;
    private LicenseService licenseService;
    private UserManagementService userManagementService;
    private DeviceManagementService deviceManagementService;

    public void setBackupDataCleanerService(BackupDataCleanerService backupDataCleanerService) {
        this.backupDataCleanerService = backupDataCleanerService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"deletedUserCleanerTrigger")) {
            logger.debug("DeletedUserCleanerTimer ........... disabled");
            return;
        }
        logger.debug("@@@ Delete JOB STARTED for delete blob...");
        try {
            List clouds = this.licenseService.getClouds();
            for (Cloud cloud : clouds) {
                logger.debug("deviceManagementService>>>" + this.deviceManagementService);
                List userElements = this.userManagementService.getAllDeletedUsers(cloud.getCloudId(), cloud.getCloudName());
                List deletedDevices = this.deviceManagementService.getAllDeletedDevices(cloud.getCloudId(), cloud.getCloudName());
                for (DeletedUser element : userElements) {
                    logger.debug(element.getUserName() + "<<<<<<<<<<username for delete");
                    this.triggerChunkDereferenceJob(cloud.getCloudId(), cloud.getCloudName(), element.getUserName(), null);
                    this.triggerJobToDeleteUserData(cloud.getCloudId(), cloud.getCloudName(), element.getUserName());
                    this.deleteDevicePathForDeviceUUIDs(cloud, element);
                }
                for (Device device : deletedDevices) {
                    logger.debug("Inside device Block for deviceUUID :" + device.getDeviceUUID());
                    this.triggerChunkDereferenceJob(cloud.getCloudId(), cloud.getCloudName(), null, device);
                    this.triggerJobToDeleteDeviceData(cloud.getCloudId(), device);
                }
            }
            logger.debug("@@@@ Delete JOB ENDED...");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug("Exception for delete stack : " + e);
            logger.error("Exception for delete message: " + e.getMessage());
        }
    }

    private void triggerChunkDereferenceJob(int cloudId, String cloudName, String userName, Device device) {
        this.backupDataCleanerService.dereferenceChunksInBackupImages(cloudId, cloudName, userName, device);
    }

    private void deleteDevicePathForDeviceUUIDs(Cloud cloud, DeletedUser element) {
        List deviceUUIDs = element.getDeviceUUIDs();
        deviceUUIDs.forEach(deviceUUID -> {});
    }

    private void triggerJobToDeleteUserData(int cloudId, String cloudName, String user) {
        this.backupDataCleanerService.deleteDBEntriesForDeletedUser(cloudId, cloudName, user);
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    private void triggerJobToDeleteDeviceData(int cloudId, Device device) {
        this.backupDataCleanerService.deleteDBEntriesForDeletedDevice(cloudId, device);
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setDeviceManagementService(DeviceManagementService deviceManagementService) {
        this.deviceManagementService = deviceManagementService;
    }

    private void deleteDevicePathForDeviceUUID(int cloudId, String cloudName, String deviceUUID) {
        String devicePath = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/" + cloudName + "/upload/" + deviceUUID;
        try {
            logger.debug("Deleting Device Files in PG , Path :" + devicePath);
            FileUtils.deleteDirectory((File)new File(devicePath));
        }
        catch (IOException e) {
            logger.debug("" + e);
            logger.error("Error in deleting Directory");
        }
    }
}

