/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.domain.Cloud;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class DeleteSyncOverviewTimer
extends QuartzJobBean {
    private Logger logger = LogManager.getLogger(DeleteSyncOverviewTimer.class);
    private UserManagementService userManagementService;
    private LicenseService licenseService;

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"deleteSyncOverviewTrigger")) {
            this.logger.debug("DeleteSyncOverviewTimer .......... disabled");
            return;
        }
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            this.logger.debug(" before deleting records in overview table .... ");
            this.userManagementService.deleteOldSyncOverView(cloud.getCloudId());
            this.logger.debug(" end of deleting records in overview table .... ");
        }
    }
}

