/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.backup.service.BackupDataCleanerService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.domain.Cloud;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.StatefulJob;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class DeleteBackupFilesByPolicy
extends QuartzJobBean
implements StatefulJob {
    private static Logger logger = LogManager.getLogger(DeleteBackupFilesByPolicy.class);
    private BackupDataCleanerService backupDataCleanerService;
    private LicenseService licenseService;

    public BackupDataCleanerService getBackupDataCleanerService() {
        return this.backupDataCleanerService;
    }

    public void setBackupDataCleanerService(BackupDataCleanerService backupDataCleanerService) {
        this.backupDataCleanerService = backupDataCleanerService;
    }

    public LicenseService getLicenseService() {
        return this.licenseService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"deleteBackupDataByPolicyTrigger")) {
            logger.debug("deleteBackupDataByPolicyTrigger ............... disabled");
            return;
        }
        logger.debug("@@@ deleteBackupDataByPolicyTrigger JOB STARTED...");
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            this.backupDataCleanerService.deleteBackupFileByPolicy(cloud);
        }
    }
}

