/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.cloud.security.service.LicenseService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.rf.delegate.CrawlDelegateServiceAsync;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class CrawlStatusCleanerTimer
extends QuartzJobBean {
    private static Logger logger = LogManager.getLogger(CrawlStatusCleanerTimer.class);
    private CrawlDelegateServiceAsync crawlDelegateServiceAsync;
    private LicenseService licenseService;
    private static final long JOB_TIME = 86400000L;

    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            if (!PCHelperConstant.isJobEnabled((String)"crawlStatusCleanerTrigger")) {
                logger.debug("crawlStatusCleanerTrigger ............ disabled");
                return;
            }
            List clouds = this.licenseService.getClouds();
            for (Cloud cloud : clouds) {
                logger.debug("Running crawl status cleaner for cloud : " + cloud.getCloudName());
                long currentTimestamp = System.currentTimeMillis();
                long beforeTimestamp = currentTimestamp - 86400000L;
                this.crawlDelegateServiceAsync.deleteCrawlStatusListBeforeTimestamp(cloud.getCloudId(), beforeTimestamp);
            }
        }
        catch (Exception e) {
            logger.error("Exception trying to cleanup crawl status" + e.getMessage());
        }
    }

    public CrawlDelegateServiceAsync getCrawlDelegateServiceAsync() {
        return this.crawlDelegateServiceAsync;
    }

    public void setCrawlDelegateServiceAsync(CrawlDelegateServiceAsync crawlDelegateServiceAsync) {
        this.crawlDelegateServiceAsync = crawlDelegateServiceAsync;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }
}

