/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.BackupActivityHistoryElement;
import com.parablu.paracloud.element.CloudInformationElement;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.paracloud.element.DeviceListElement;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.util.DiskSpaceHelper;
import com.parablu.pc.utils.DaysEnum;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.LatestDeviceBackupInfo;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.User;
import com.parablu.psc.service.UserAndDeviceStatisticService;
import com.parablu.report.service.ReportService;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.iterators.ArrayListIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class CloudOverviewTimer
extends QuartzJobBean {
    private Logger logger = LogManager.getLogger(CloudOverviewTimer.class);
    private UserAndDeviceStatisticService userAndDeviceStatisticService;
    private ReportService reportService;
    private LicenseService licenseService;
    private CloudMailService cloudMailService;
    public static final String PRESCAN_COMMAND_EXECUTION = "PRESCAN_COMMAND_EXECUTION";
    private static final String MM_DD_YYYY = "MM/dd/yyyy";
    private static final String INSIDE_SEND_CLOUD_OVER_VIEW_JOB_TIMER = " @@@@@@@@@@@@@@@@@@@@@@@@@@ inside send cloud over view job timer ";
    private static final String BEFORE_SENDING_MAIL = " @@@ Before sending mail ";
    private static final String NO_ATTEMPT = "No Attempt";
    private static final String NILL = " ";
    private static final String PARSE_EXCEPTION = "ParseException  ";
    private static final String INVALID_DAY_VALUE = "Invalid Day value";
    private static final String NUMBER_FORMAT_EXCEPTION = "NumberFormatException  ";

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setUserAndDeviceStatisticService(UserAndDeviceStatisticService userAndDeviceStatisticService) {
        this.userAndDeviceStatisticService = userAndDeviceStatisticService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        this.logger.debug("....start of CloudOverviewTimer... ");
        if (!PCHelperConstant.isJobEnabled((String)"sendCloudOverviewTrigger")) {
            this.logger.debug("CloudOverviewTimer ............... disabled");
            return;
        }
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            List devices = this.userAndDeviceStatisticService.getAllDevices(cloud.getCloudId(), cloud.getCloudName());
            List backupPolicies = this.userAndDeviceStatisticService.getAllPolicies(cloud.getCloudId(), cloud.getCloudName());
            HashMap<String, List> deviceListMap = new HashMap<String, List>();
            ArrayList<String> impUsersPolicyNames = new ArrayList<String>();
            if (StringUtils.isNotEmpty((String)PCHelperConstant.getPropertyFileValueImpUsersPolicyNames())) {
                impUsersPolicyNames.addAll(Arrays.asList(PCHelperConstant.getPropertyFileValueImpUsersPolicyNames().split(",")));
            }
            for (Device device : devices) {
                DeviceBackupOverView backupOverView;
                boolean isExchangeBackupEnabled = false;
                boolean isOdbBackupEnabled = false;
                boolean isBackupEnabled = false;
                boolean isSyncEnabled = false;
                if (device == null || (backupOverView = this.userAndDeviceStatisticService.getDeviceBkpOverviewForDeviceUUID(cloud.getCloudId(), device.getDeviceUUID())) == null || backupOverView.getLastBkpStatus() == null || backupOverView.getLastBkpStartTime() == null) continue;
                User user = this.userAndDeviceStatisticService.getUserDetails(cloud.getCloudId(), device.getUserName());
                if (PCHelperConstant.getPropertyFileValueEmailsToadminsOnly() && (user == null || !user.isAdmin()) || user == null || !user.isBackupEnabled() && !user.isExchangeBkpEnabled() && !user.isOnedriveBkpEnabled()) continue;
                if (user != null) {
                    isOdbBackupEnabled = user.isOnedriveBkpEnabled();
                    isExchangeBackupEnabled = user.isExchangeBkpEnabled();
                    isBackupEnabled = user.isBackupEnabled();
                }
                if (!user.isActive()) continue;
                String userName = user.getUserName();
                boolean isDeviceAllowed = false;
                if (isBackupEnabled && "BACKUP".equalsIgnoreCase(device.getDeviceType())) {
                    isDeviceAllowed = true;
                } else if (isOdbBackupEnabled && "ONEDRIVE".equalsIgnoreCase(device.getDeviceType())) {
                    isDeviceAllowed = true;
                } else if (isExchangeBackupEnabled && "OUTLOOK".equalsIgnoreCase(device.getDeviceType())) {
                    isDeviceAllowed = true;
                }
                if (!StringUtils.isNotEmpty((String)userName)) continue;
                if (deviceListMap.containsKey(userName)) {
                    List devicesForUser = (List)deviceListMap.get(userName);
                    if (!isDeviceAllowed) continue;
                    devicesForUser.add(device);
                    deviceListMap.remove(userName);
                    deviceListMap.put(userName, devicesForUser);
                    continue;
                }
                ArrayList<Device> deviceList = new ArrayList<Device>();
                if (!isDeviceAllowed) continue;
                deviceList.add(device);
                deviceListMap.put(userName, deviceList);
            }
            for (String user : deviceListMap.keySet()) {
                try {
                    List devicesForUser = (List)deviceListMap.get(user);
                    this.sendBackupStatusToUser(cloud, devicesForUser, "backup-status", backupPolicies);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error("...unable to send mail for user report..." + user);
                }
            }
        }
        this.logger.debug("....end of CloudOverviewTimer... ");
    }

    private String getEndDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 23);
        cal.set(12, 55);
        ((Calendar)cal).add(5, -1);
        Date date = cal.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat(MM_DD_YYYY);
        return formatter.format(date);
    }

    private String getStartDate() {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(5, -7);
        Date fiveDaysAgo = cal.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat(MM_DD_YYYY);
        return formatter.format(fiveDaysAgo);
    }

    private String getDateForApproprioteDay(int i) {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(5, -7 + i);
        Date fiveDaysAgo = cal.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat(MM_DD_YYYY);
        return formatter.format(fiveDaysAgo);
    }

    private String getDay(String startDate) {
        String date = "";
        try {
            this.logger.debug("...Start date..." + startDate);
            SimpleDateFormat df2 = new SimpleDateFormat(MM_DD_YYYY);
            Date dateD = new Date(startDate);
            date = df2.format(dateD);
        }
        catch (NumberFormatException e) {
            this.logger.debug(NUMBER_FORMAT_EXCEPTION + e);
            this.logger.error(NUMBER_FORMAT_EXCEPTION + e.getMessage());
        }
        return date;
    }

    private int getDayOfTheWeek(String dat) {
        SimpleDateFormat format = new SimpleDateFormat(MM_DD_YYYY);
        Date date = null;
        try {
            date = format.parse(dat);
        }
        catch (ParseException e) {
            this.logger.debug(PARSE_EXCEPTION + e);
            this.logger.error(PARSE_EXCEPTION + e.getMessage());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(7);
    }

    private void sendBackupStatusToUser(Cloud cloud, List<Device> devices, String action, List<BackupPolicy> backupPolicies1) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction(action);
        EmailRecipent emailRecipent = new EmailRecipent();
        User user = this.userAndDeviceStatisticService.getUserDetails(cloud.getCloudId(), devices.get(0).getUserName());
        emailRecipent.setUserName(user.getUserName());
        emailRecipent.setEmail(user.getEmailId());
        emailRecipents.add(emailRecipent);
        if (StringUtils.isEmpty((String)user.getDisplayName())) {
            email.setActionBy(user.getUserName());
        } else {
            email.setActionBy(user.getDisplayName());
        }
        StringBuilder bodyData = new StringBuilder();
        for (Device device : devices) {
            EmailProps tempEmail = new EmailProps();
            ReportQueryElement reportQueryElement = new ReportQueryElement();
            reportQueryElement.setDeviceName(device.getDeviceName());
            reportQueryElement.setUserName(device.getUserName());
            reportQueryElement.setStartDate(this.getStartDate());
            reportQueryElement.setEndDate(this.getEndDate());
            List backupHistoryElements = this.reportService.getBackupBatchHistoryElementForWeeklyMail(cloud.getCloudId(), reportQueryElement);
            this.setDaysElementForSendmail(tempEmail);
            String prviousState = "";
            backupHistoryElements.sort(Comparator.comparing(BackupActivityHistoryElement::getStartTimeInMillis).reversed());
            for (BackupActivityHistoryElement backupHistoryElement : backupHistoryElements) {
                this.logger.debug(backupHistoryElements.size() + "....statdate...." + backupHistoryElement.getStartTimeInMillis() + "..files..." + backupHistoryElement.getNoOfFilesBackedup());
            }
            for (BackupActivityHistoryElement backupHistoryElement : backupHistoryElements) {
                if (backupHistoryElement == null) continue;
                String batchId = backupHistoryElement.getBatchId();
                this.logger.debug(backupHistoryElement.getBatchId() + "...backupHistoryElement..." + backupHistoryElement.getErrorCode() + "....." + batchId);
                boolean isScanning = false;
                List collect = backupHistoryElements.stream().filter(attempt -> attempt.getBatchId().equals(batchId)).collect(Collectors.toList());
                this.logger.debug(batchId + "......Size...." + collect.size());
                if (!CollectionUtils.isEmpty(collect) && collect.size() == 1) {
                    this.logger.debug("....." + backupHistoryElement.getErrorCode());
                    if ("1207".equals(backupHistoryElement.getErrorCode())) {
                        backupHistoryElement.setComments("Admin stopped Scanning manually");
                    }
                }
                this.logger.debug("...backupHistoryElement.getComments()..." + backupHistoryElement.getComments());
                String dateToCheck = "";
                int dayVal = this.getDayOfTheWeek(this.getDay(backupHistoryElement.getEndTime()));
                this.logger.debug("...backupHistoryElement.getStatus()....|||..." + backupHistoryElement.getStatus());
                if (StringUtils.isEmpty((String)backupHistoryElement.getStatus())) {
                    backupHistoryElement.setStatus("");
                }
                if (StringUtils.isEmpty((String)prviousState)) {
                    prviousState = "";
                }
                this.logger.debug(backupHistoryElement.getStatus() + "....prviousState......" + prviousState);
                this.logger.debug(backupHistoryElement.getEndTime() + "................" + backupHistoryElement.getComments());
                if (this.isBackupStartedinWindowPeriod(this.getDay(backupHistoryElement.getStartTime()))) {
                    int startDayVal = this.getDayOfTheWeek(this.getDay(backupHistoryElement.getStartTime()));
                    if (backupHistoryElement.getStatus().contains("SCANNING") || prviousState.contains("Successfully Completed") || StringUtils.isEmpty((String)prviousState) || prviousState.toLowerCase().contains("stop") || prviousState.toLowerCase().contains("aborted") || prviousState.toLowerCase().contains("pre scan command failed")) {
                        CloudOverviewTimer.setBackupStatusForDay(tempEmail, startDayVal, this.getStatusWithTime(backupHistoryElement.getStartTime(), "Backup Started"), "", this.getDay(backupHistoryElement.getStartTime()), "", backupHistoryElement);
                    } else {
                        this.logger.debug(prviousState + "...RESUMEEEED..." + backupHistoryElement.getStatus());
                        CloudOverviewTimer.setBackupStatusForDay(tempEmail, startDayVal, this.getStatusWithTime(backupHistoryElement.getStartTime(), "Backup resumed"), "", this.getDay(backupHistoryElement.getStartTime()), "", backupHistoryElement);
                    }
                } else if (backupHistoryElement.getComments().contains("User exited the agent manually or the endpoint was shutdown during the backup")) {
                    this.logger.debug("..inside....User exited the agent manually or the endpoint was shutdown during the backup");
                    CloudOverviewTimer.setBackupStatusForDay(tempEmail, dayVal, this.getStatusWithTime(backupHistoryElement.getEndTime(), "Backup Interrupted"), backupHistoryElement.getComments(), dateToCheck, this.getCompletionDetails(backupHistoryElement), backupHistoryElement);
                    this.logger.debug("..inside....User exited the agent manually or the endpoint was shutdown during the backup");
                } else if (backupHistoryElement.getComments().contains("Network disconnected or endpoint was shutdown during the backup")) {
                    this.logger.debug("..inside....Network disconnected or endpoint was shutdown during the backup");
                    CloudOverviewTimer.setBackupStatusForDay(tempEmail, dayVal, this.getStatusWithTime(backupHistoryElement.getEndTime(), "Backup Interrupted"), backupHistoryElement.getComments(), dateToCheck, this.getCompletionDetails(backupHistoryElement), backupHistoryElement);
                } else if (backupHistoryElement.getComments().contains("User paused BackUp manually")) {
                    this.logger.debug("..inside....User paused BackUp manually");
                    CloudOverviewTimer.setBackupStatusForDay(tempEmail, dayVal, this.getStatusWithTime(backupHistoryElement.getEndTime(), "Backup Interrupted"), backupHistoryElement.getComments(), dateToCheck, this.getCompletionDetails(backupHistoryElement), backupHistoryElement);
                } else if (backupHistoryElement.getComments().contains("Backup temporarily suspended because server is busy.Will be retried later")) {
                    this.logger.debug("..inside....Backup temporarily suspended because server is busy.Will be retried later");
                    String actionTemp = "Backup temporarily suspended because server is busy.";
                    CloudOverviewTimer.setBackupStatusForDay(tempEmail, dayVal, this.getStatusWithTime(backupHistoryElement.getEndTime(), "Backup Interrupted"), actionTemp, dateToCheck, this.getCompletionDetails(backupHistoryElement), backupHistoryElement);
                } else if (backupHistoryElement.getComments().contains("Pre scan command failed")) {
                    this.logger.debug("..inside....Pre scan command failed");
                    CloudOverviewTimer.setBackupStatusForDay(tempEmail, dayVal, this.getStatusWithTime(backupHistoryElement.getEndTime(), "Backup Interrupted"), backupHistoryElement.getComments(), dateToCheck, this.getCompletionDetails(backupHistoryElement), backupHistoryElement);
                } else if (backupHistoryElement.getComments().contains("Backup Deferre")) {
                    this.logger.debug("..inside....Backup Deferred.");
                    CloudOverviewTimer.setBackupStatusForDay(tempEmail, dayVal, this.getStatusWithTime(backupHistoryElement.getEndTime(), "Backup Interrupted"), backupHistoryElement.getComments(), dateToCheck, this.getCompletionDetails(backupHistoryElement), backupHistoryElement);
                } else if (backupHistoryElement.getComments().contains("User stopped BackUp manually")) {
                    this.logger.debug("..inside....User stopped BackUp manually");
                    CloudOverviewTimer.setBackupStatusForDay(tempEmail, dayVal, this.getStatusWithTime(backupHistoryElement.getEndTime(), "Aborted"), backupHistoryElement.getComments(), dateToCheck, this.getCompletionDetails(backupHistoryElement), backupHistoryElement);
                } else if (backupHistoryElement.getComments().contains("Admin stopped BackUp manually")) {
                    this.logger.debug("..inside....Admin stopped BackUp manually");
                    CloudOverviewTimer.setBackupStatusForDay(tempEmail, dayVal, this.getStatusWithTime(backupHistoryElement.getEndTime(), "Aborted"), backupHistoryElement.getComments(), dateToCheck, this.getCompletionDetails(backupHistoryElement), backupHistoryElement);
                } else if (backupHistoryElement.getComments().contains("Admin paused BackUp manually")) {
                    this.logger.debug("..inside....Admin paused BackUp manually");
                    CloudOverviewTimer.setBackupStatusForDay(tempEmail, dayVal, this.getStatusWithTime(backupHistoryElement.getEndTime(), "Backup Interrupted"), backupHistoryElement.getComments(), dateToCheck, this.getCompletionDetails(backupHistoryElement), backupHistoryElement);
                } else if (backupHistoryElement.getComments().contains("Admin stopped Scanning manually")) {
                    this.logger.debug("..inside....Admin stopped Scanning manually");
                    CloudOverviewTimer.setBackupStatusForDay(tempEmail, dayVal, this.getStatusWithTime(backupHistoryElement.getEndTime(), "Aborted"), backupHistoryElement.getComments(), dateToCheck, this.getCompletionDetails(backupHistoryElement), backupHistoryElement);
                } else if (backupHistoryElement.getComments().contains("Successfully Completed")) {
                    this.logger.debug("..inside ss....Successfully Completed");
                    String status = "Successfully Completed";
                    String completionDetails = "-";
                    if (backupHistoryElement.getStatus().equals("SCANNING")) {
                        status = "Scanning completed";
                    } else {
                        completionDetails = this.getCompletionDetails(backupHistoryElement);
                    }
                    CloudOverviewTimer.setBackupStatusForDay(tempEmail, dayVal, this.getStatusWithTime(backupHistoryElement.getEndTime(), backupHistoryElement.getComments()), status, dateToCheck, completionDetails, backupHistoryElement);
                }
                prviousState = backupHistoryElement.getComments();
            }
            DeviceBackupOverView backupOverView = this.userAndDeviceStatisticService.getDeviceBkpOverviewForDeviceUUID(cloud.getCloudId(), device.getDeviceUUID());
            this.setNoAttemptForSendmail(tempEmail, backupHistoryElements, backupOverView);
            long LatestVersionsSize = 0L;
            List allBackupInfoList = this.userAndDeviceStatisticService.getAllLatestDeviceBkpInfo(1, backupOverView.getDeviceUUID());
            for (LatestDeviceBackupInfo bkpInfo : allBackupInfoList) {
                LatestVersionsSize += bkpInfo.getLatestVersionsSize();
            }
            email.setDeviceUUID(backupOverView.getDeviceUUID());
            email.setBackupsDone(CloudOverviewTimer.formatFileSize(LatestVersionsSize));
            bodyData.append(this.setDynamicDeviceTemplate(device, tempEmail, backupOverView));
            this.logger.debug("********************************************************************************");
            this.logger.debug(this.setDynamicDeviceTemplate(device, tempEmail, backupOverView));
            this.logger.debug("********************************************************************************");
        }
        email.setBodyData(bodyData.toString());
        this.logger.debug(INSIDE_SEND_CLOUD_OVER_VIEW_JOB_TIMER);
        if (!emailRecipents.isEmpty()) {
            this.logger.debug(BEFORE_SENDING_MAIL);
            email.setRecipents(emailRecipents);
            this.cloudMailService.sendMail(email);
            int delayTime = PCHelperConstant.getBulkEmailDelay();
            if (delayTime > 0) {
                try {
                    Thread.sleep((long)delayTime * 1000L);
                }
                catch (InterruptedException e) {
                    this.logger.error(" error in sleep >>" + e + "Message is>>" + e.getMessage());
                }
            }
            this.logger.debug("Delay time is..." + delayTime + " .so sleepinggggg......");
        }
    }

    private String getCompletionDetails(BackupActivityHistoryElement backupHistoryElement) {
        if (backupHistoryElement.getComments().contains("Scanning")) {
            return "-";
        }
        boolean uploadedFiles = false;
        long noOfFilesBackedup = 0L;
        long noOfFilesFailed = 0L;
        long toatalFiles = backupHistoryElement.getTotalNumberOfFiles();
        long percentCompleted = 0L;
        try {
            noOfFilesBackedup = Long.parseLong(backupHistoryElement.getNoOfFilesBackedup());
            noOfFilesFailed = Long.parseLong(backupHistoryElement.getNoOfFilesFailed());
            percentCompleted = (noOfFilesFailed + noOfFilesBackedup) / toatalFiles;
        }
        catch (Exception e) {
            this.logger.trace("Exception  :" + e);
            this.logger.error("Exception  :" + e.getMessage());
        }
        return "(" + (noOfFilesBackedup + noOfFilesFailed) + "/" + toatalFiles + " files " + percentCompleted * 100L + "%)Completed";
    }

    private static void setBackupStatusForDay(EmailProps email, int dayValue, String status, String remark, String date, String complitionDetails, BackupActivityHistoryElement backupHistoryElement) {
        if (status.contains("Backup Interrupted") || status.toLowerCase().contains("completed") || status.toLowerCase().contains("stopped") || status.toLowerCase().contains("aborted")) {
            status = status + "<hr>";
        }
        if (!StringUtils.isEmpty((String)complitionDetails)) {
            complitionDetails = complitionDetails + "<hr>";
        }
        String tempRemark = NILL;
        if (!StringUtils.isEmpty((String)remark)) {
            tempRemark = remark + "<hr>";
        }
        dayValue = 1;
        switch (dayValue) {
            case 1: {
                email.setSundayStatus(status);
                email.setSundayRemarks(tempRemark);
                email.setSundayDate(date);
                email.setSundayComplitionDetails(complitionDetails);
                email.setSundayStartTime(CloudOverviewTimer.getDateStr(backupHistoryElement.getStartTimeInMillis()));
                email.setSundayEndTime(CloudOverviewTimer.getDateStr(backupHistoryElement.getEndTimeInMillis()));
                long noOfFilesBckup = 0L;
                long noOfFilesFailedCount = 0L;
                if (!StringUtils.isEmpty((String)backupHistoryElement.getNoOfFilesFailed())) {
                    noOfFilesFailedCount = Long.parseLong(backupHistoryElement.getNoOfFilesFailed());
                }
                if (!StringUtils.isEmpty((String)backupHistoryElement.getNoOfFilesBackedup())) {
                    noOfFilesBckup = Long.parseLong(backupHistoryElement.getNoOfFilesBackedup());
                }
                email.setSundayAttempted("" + (noOfFilesBckup + noOfFilesFailedCount));
                email.setSundayTotalItems("" + backupHistoryElement.getTotalNumberOfFiles());
                String successPct = "(" + String.valueOf(CloudOverviewTimer.getPercentageCompleted(backupHistoryElement.getNoOfFilesBackedup(), backupHistoryElement.getNoOfFilesFailed(), backupHistoryElement.getTotalNumberOfFiles())) + " %)";
                email.setSundaySuccess("" + backupHistoryElement.getNoOfFilesBackedup() + successPct);
                email.setSundayFailed("" + backupHistoryElement.getNoOfFilesFailed());
                email.setSundayComments(backupHistoryElement.getComments());
                break;
            }
            case 2: {
                email.setMondayStatus(status);
                email.setMondayRemarks(tempRemark);
                email.setMondayDate(date);
                email.setMondayComplitionDetails(complitionDetails);
                email.setMondayStartTime(CloudOverviewTimer.getDateStr(backupHistoryElement.getStartTimeInMillis()));
                email.setMondayEndTime(CloudOverviewTimer.getDateStr(backupHistoryElement.getEndTimeInMillis()));
                long noOfFilesBckup = 0L;
                long noOfFilesFailedCount = 0L;
                if (!StringUtils.isEmpty((String)backupHistoryElement.getNoOfFilesFailed())) {
                    noOfFilesFailedCount = Long.parseLong(backupHistoryElement.getNoOfFilesFailed());
                }
                if (!StringUtils.isEmpty((String)backupHistoryElement.getNoOfFilesBackedup())) {
                    noOfFilesBckup = Long.parseLong(backupHistoryElement.getNoOfFilesBackedup());
                }
                email.setMondayAttempted("" + (noOfFilesBckup + noOfFilesFailedCount));
                email.setMondayTotalItems("" + backupHistoryElement.getTotalNumberOfFiles());
                String successPct = "(" + String.valueOf(CloudOverviewTimer.getPercentageCompleted(backupHistoryElement.getNoOfFilesBackedup(), backupHistoryElement.getNoOfFilesFailed(), backupHistoryElement.getTotalNumberOfFiles())) + " %)";
                email.setMondaySuccess("" + backupHistoryElement.getNoOfFilesBackedup() + successPct);
                email.setMondayFailed("" + backupHistoryElement.getNoOfFilesFailed());
                email.setMondayComments(backupHistoryElement.getComments());
                break;
            }
            case 3: {
                email.setTuesdayStatus(status);
                email.setTuesdayRemarks(tempRemark);
                email.setTuesdayDate(date);
                email.setTuesdayComplitionDetails(complitionDetails);
                email.setTuesdayStartTime(CloudOverviewTimer.getDateStr(backupHistoryElement.getStartTimeInMillis()));
                email.setTuesdayEndTime(CloudOverviewTimer.getDateStr(backupHistoryElement.getEndTimeInMillis()));
                long noOfFilesBckup = 0L;
                long noOfFilesFailedCount = 0L;
                if (!StringUtils.isEmpty((String)backupHistoryElement.getNoOfFilesFailed())) {
                    noOfFilesFailedCount = Long.parseLong(backupHistoryElement.getNoOfFilesFailed());
                }
                if (!StringUtils.isEmpty((String)backupHistoryElement.getNoOfFilesBackedup())) {
                    noOfFilesBckup = Long.parseLong(backupHistoryElement.getNoOfFilesBackedup());
                }
                email.setTuesdayAttempted("" + (noOfFilesBckup + noOfFilesFailedCount));
                email.setTuesdayTotalItems("" + backupHistoryElement.getTotalNumberOfFiles());
                String successPct = "(" + String.valueOf(CloudOverviewTimer.getPercentageCompleted(backupHistoryElement.getNoOfFilesBackedup(), backupHistoryElement.getNoOfFilesFailed(), backupHistoryElement.getTotalNumberOfFiles())) + " %)";
                email.setTuesdaySuccess("" + backupHistoryElement.getNoOfFilesBackedup() + successPct);
                email.setTuesdayFailed("" + backupHistoryElement.getNoOfFilesFailed());
                email.setTuesdayComments(backupHistoryElement.getComments());
                break;
            }
            case 4: {
                email.setWednesdayStatus(status);
                email.setWednesDayRemarks(tempRemark);
                email.setWednesdayDate(date);
                email.setWednesdayComplitionDetails(complitionDetails);
                email.setWednesdayStartTime(CloudOverviewTimer.getDateStr(backupHistoryElement.getStartTimeInMillis()));
                email.setWednesdayEndTime(CloudOverviewTimer.getDateStr(backupHistoryElement.getEndTimeInMillis()));
                long noOfFilesBckup = 0L;
                long noOfFilesFailedCount = 0L;
                if (!StringUtils.isEmpty((String)backupHistoryElement.getNoOfFilesFailed())) {
                    noOfFilesFailedCount = Long.parseLong(backupHistoryElement.getNoOfFilesFailed());
                }
                if (!StringUtils.isEmpty((String)backupHistoryElement.getNoOfFilesBackedup())) {
                    noOfFilesBckup = Long.parseLong(backupHistoryElement.getNoOfFilesBackedup());
                }
                email.setWednesdayAttempted("" + (noOfFilesBckup + noOfFilesFailedCount));
                email.setWednesdayTotalItems("" + backupHistoryElement.getTotalNumberOfFiles());
                String successPct = "(" + String.valueOf(CloudOverviewTimer.getPercentageCompleted(backupHistoryElement.getNoOfFilesBackedup(), backupHistoryElement.getNoOfFilesFailed(), backupHistoryElement.getTotalNumberOfFiles())) + " %)";
                email.setWednesdaySuccess("" + backupHistoryElement.getNoOfFilesBackedup() + successPct);
                email.setWednesdayFailed("" + backupHistoryElement.getNoOfFilesFailed());
                email.setWednesdayComments(backupHistoryElement.getComments());
                break;
            }
            case 5: {
                email.setThursdayStatus(status);
                email.setThursdayRemarks(tempRemark);
                email.setThursdayDate(date);
                email.setThursdayComplitionDetails(complitionDetails);
                email.setThursdayStartTime(CloudOverviewTimer.getDateStr(backupHistoryElement.getStartTimeInMillis()));
                email.setThursdayEndTime(CloudOverviewTimer.getDateStr(backupHistoryElement.getEndTimeInMillis()));
                long noOfFilesBckup = 0L;
                long noOfFilesFailedCount = 0L;
                if (!StringUtils.isEmpty((String)backupHistoryElement.getNoOfFilesFailed())) {
                    noOfFilesFailedCount = Long.parseLong(backupHistoryElement.getNoOfFilesFailed());
                }
                if (!StringUtils.isEmpty((String)backupHistoryElement.getNoOfFilesBackedup())) {
                    noOfFilesBckup = Long.parseLong(backupHistoryElement.getNoOfFilesBackedup());
                }
                email.setThursdayAttempted("" + (noOfFilesBckup + noOfFilesFailedCount));
                email.setThursdayTotalItems("" + backupHistoryElement.getTotalNumberOfFiles());
                String successPct = "(" + String.valueOf(CloudOverviewTimer.getPercentageCompleted(backupHistoryElement.getNoOfFilesBackedup(), backupHistoryElement.getNoOfFilesFailed(), backupHistoryElement.getTotalNumberOfFiles())) + " %)";
                email.setThursdaySuccess("" + backupHistoryElement.getNoOfFilesBackedup() + successPct);
                email.setThursdayFailed("" + backupHistoryElement.getNoOfFilesFailed());
                email.setThursdayComments(backupHistoryElement.getComments());
                break;
            }
            case 6: {
                email.setFridayStatus(status);
                email.setFridayRemarks(tempRemark);
                email.setFridayDate(date);
                email.setFridayComplitionDetails(complitionDetails);
                email.setFridayStartTime(CloudOverviewTimer.getDateStr(backupHistoryElement.getStartTimeInMillis()));
                email.setFridayEndTime(CloudOverviewTimer.getDateStr(backupHistoryElement.getEndTimeInMillis()));
                long noOfFilesBckup = 0L;
                long noOfFilesFailedCount = 0L;
                if (!StringUtils.isEmpty((String)backupHistoryElement.getNoOfFilesFailed())) {
                    noOfFilesFailedCount = Long.parseLong(backupHistoryElement.getNoOfFilesFailed());
                }
                if (!StringUtils.isEmpty((String)backupHistoryElement.getNoOfFilesBackedup())) {
                    noOfFilesBckup = Long.parseLong(backupHistoryElement.getNoOfFilesBackedup());
                }
                email.setFridayAttempted("" + (noOfFilesBckup + noOfFilesFailedCount));
                email.setFridayTotalItems("" + backupHistoryElement.getTotalNumberOfFiles());
                String successPct = "(" + String.valueOf(CloudOverviewTimer.getPercentageCompleted(backupHistoryElement.getNoOfFilesBackedup(), backupHistoryElement.getNoOfFilesFailed(), backupHistoryElement.getTotalNumberOfFiles())) + " %)";
                email.setFridaySuccess("" + backupHistoryElement.getNoOfFilesBackedup() + successPct);
                email.setFridayFailed("" + backupHistoryElement.getNoOfFilesFailed());
                email.setFridayComments(backupHistoryElement.getComments());
                break;
            }
            case 7: {
                email.setSaturdayStatus(status);
                email.setSaturdayRemarks(tempRemark);
                email.setSaturdayDate(date);
                email.setSaturdayComplitionDetails(complitionDetails);
                email.setSaturdayStartTime(CloudOverviewTimer.getDateStr(backupHistoryElement.getStartTimeInMillis()));
                email.setSaturdayEndTime(CloudOverviewTimer.getDateStr(backupHistoryElement.getEndTimeInMillis()));
                long noOfFilesBckup = 0L;
                long noOfFilesFailedCount = 0L;
                if (!StringUtils.isEmpty((String)backupHistoryElement.getNoOfFilesFailed())) {
                    noOfFilesFailedCount = Long.parseLong(backupHistoryElement.getNoOfFilesFailed());
                }
                if (!StringUtils.isEmpty((String)backupHistoryElement.getNoOfFilesBackedup())) {
                    noOfFilesBckup = Long.parseLong(backupHistoryElement.getNoOfFilesBackedup());
                }
                email.setSaturdayAttempted("" + (noOfFilesBckup + noOfFilesFailedCount));
                email.setSaturdayTotalItems("" + backupHistoryElement.getTotalNumberOfFiles());
                String successPct = "(" + String.valueOf(CloudOverviewTimer.getPercentageCompleted(backupHistoryElement.getNoOfFilesBackedup(), backupHistoryElement.getNoOfFilesFailed(), backupHistoryElement.getTotalNumberOfFiles())) + " %)";
                email.setSaturdaySuccess("" + backupHistoryElement.getNoOfFilesBackedup() + successPct);
                email.setSaturdayFailed("" + backupHistoryElement.getNoOfFilesFailed());
                email.setSaturdayComments(backupHistoryElement.getComments());
                break;
            }
        }
    }

    private static long getPercentageCompleted(String noOfFilesBackedup, String noOfFilesFailed, long totalNumberOfFiles) {
        long percentage = 0L;
        long noOfFilesBckup = 0L;
        long noOfFilesFailedCount = 0L;
        if (!StringUtils.isEmpty((String)noOfFilesFailed)) {
            noOfFilesFailedCount = Long.parseLong(noOfFilesFailed);
        }
        if (!StringUtils.isEmpty((String)noOfFilesBackedup)) {
            noOfFilesBckup = Long.parseLong(noOfFilesBackedup);
        }
        if (totalNumberOfFiles != 0L) {
            percentage = (noOfFilesBckup + noOfFilesFailedCount) * 100L / totalNumberOfFiles;
        }
        if (noOfFilesBckup + noOfFilesFailedCount == 0L && totalNumberOfFiles == 0L) {
            percentage = 100L;
        }
        return percentage;
    }

    private static String getCommentsForBackupBatch(String status, String errorCode, String deviceName) {
        String comments = "";
        if ("STARTED".equalsIgnoreCase(status)) {
            return comments;
        }
        if ("0".equals(errorCode)) {
            comments = "Successfully Completed";
        }
        if (PRESCAN_COMMAND_EXECUTION.equals(status)) {
            comments = "-";
        }
        boolean officeProduct = false;
        if (deviceName.contains("Microsoft Exchange") || deviceName.contains("Microsoft OneDrive")) {
            officeProduct = true;
        }
        if ("909".equals(errorCode)) {
            comments = !officeProduct ? "Network disconnected or endpoint was shutdown during the backup" : "Network disconnected during the backup";
        }
        if ("911".equals(errorCode)) {
            comments = "User exited the agent manually or the endpoint was shutdown during the backup";
        }
        if ("912".equals(errorCode)) {
            comments = "Machine Utilization exceeded during backup";
        }
        if ("2304".equals(errorCode)) {
            comments = "Backup temporarily suspended because server is busy.Will be retried later";
        }
        if ("1992".equals(errorCode)) {
            comments = officeProduct ? "Admin paused BackUp manually" : "User paused BackUp manually";
        }
        if ("1981".equals(errorCode)) {
            comments = "User storage limit reached.";
        }
        if ("1996".equals(errorCode)) {
            comments = "Backup Deferred.";
        }
        if ("1207".equals(errorCode)) {
            comments = officeProduct ? "Admin stopped BackUp manually" : "User stopped BackUp manually";
        }
        if ("1208".equals(errorCode)) {
            comments = "Admin paused BackUp manually";
        }
        if ("1209".equals(errorCode)) {
            comments = "Admin stopped BackUp manually";
        }
        if ("543".equals(errorCode)) {
            comments = "OneDrive target not assigned";
        }
        if ("544".equals(errorCode)) {
            comments = "Invalid Mailbox License";
        }
        if ("1211".equals(errorCode)) {
            comments = "Pre scan command failed.";
        }
        if ("1210".equals(errorCode)) {
            comments = "Pre backup command failed.";
        }
        if ("1501".equals(errorCode)) {
            comments = "License Expired";
        }
        if ("1212".equals(errorCode)) {
            comments = "Access denied.";
        }
        return comments;
    }

    private void setDaysElementForSendmail(EmailProps email) {
        email.setMonday(DaysEnum.MONDAY.toString());
        email.setMondayRemark(NILL);
        email.setTuesday(DaysEnum.TUESDAY.toString());
        email.setTuesdayRemark(NILL);
        email.setWednesday(DaysEnum.WEDNESDAY.toString());
        email.setWednesdayRemark(NILL);
        email.setThursday(DaysEnum.THURSDAY.toString());
        email.setThursdayRemark(NILL);
        email.setFriday(DaysEnum.FRIDAY.toString());
        email.setFridayRemark(NILL);
        email.setSaturday(DaysEnum.SATURDAY.toString());
        email.setSaturdayRemark(NILL);
        email.setSunday(DaysEnum.SUNDAY.toString());
        email.setSundayRemark(NILL);
    }

    public static String formatFileSize(long size) {
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : dec.format(m).concat(" MB"));
        return hrSize;
    }

    public static String avgStoragePerUser(long size, Long noOfUsers) {
        String hrSize;
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        if (t > 1.0) {
            double avgSize = t / (double)noOfUsers.longValue();
            hrSize = dec.format(avgSize).concat(" TB");
        } else if (g > 1.0) {
            double avgSize = g / (double)noOfUsers.longValue();
            hrSize = dec.format(avgSize).concat(" GB");
        } else {
            double avgSize = m / (double)noOfUsers.longValue();
            hrSize = dec.format(avgSize).concat(" MB");
        }
        return hrSize;
    }

    private CloudInformationElement fillCloudInformationDetails(int cloudId, String cloudName, Cloud cloud, Map<String, Long> abd, List<Device> devices, long totalc, long totald, long totaldod, long totaldown, long totalu, long totaldev, long totaluse) {
        CloudInformationElement cloudInformationElement = new CloudInformationElement();
        DeviceListElement deviceListElement = this.setDeviceListElement(devices);
        long fileSizeCount = DiskSpaceHelper.spaceUsedInKB((String)cloud.getCloudName());
        cloudInformationElement.setCloudName(cloud.getCloudName());
        cloudInformationElement.setFileSystemSpaceRemaining(0L);
        cloudInformationElement.setTotalFilesSize(fileSizeCount);
        cloudInformationElement.setActiveDeviceCount(totaldev);
        cloudInformationElement.setUserCount(totaluse);
        cloudInformationElement.setLatestCrawlRequestcount(totalc);
        cloudInformationElement.setLatestDeleteOperationCount(totald);
        cloudInformationElement.setLatestDODRequestCount(totaldod);
        cloudInformationElement.setLatestDownloadRequestCount(totaldown);
        cloudInformationElement.setLatestUploadRequestCount(totalu);
        cloudInformationElement.setDeviceListElement(deviceListElement);
        return cloudInformationElement;
    }

    private DeviceListElement setDeviceListElement(List<Device> devices) {
        ArrayList<DeviceElement> devElementList = new ArrayList<DeviceElement>();
        DeviceListElement deviceListElement = new DeviceListElement();
        for (Device device : devices) {
            DeviceElement ue = new DeviceElement();
            BeanUtils.copyProperties((Object)device, (Object)ue);
            devElementList.add(ue);
        }
        deviceListElement.setDeviceList(devElementList);
        return deviceListElement;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    private String setDynamicDeviceTemplate(Device device, EmailProps email, DeviceBackupOverView bkpOverview) {
        StringBuilder bodyData = new StringBuilder("<table class=\"table\" style=\"width:75%\">");
        bodyData.append("<thead>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Device Name").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(device.getDeviceName()).append("</th>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Last Successful").append("<br>").append("Backup").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(Optional.ofNullable(bkpOverview.getLastSuccessfulBkp()).orElse("")).append("</th>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Start Time").append("</th>").append("<th style=\"border: 1px solid black;text-align: left\">").append("End Time").append("</th>").append("<th style=\"border: 1px solid black;text-align: left\">").append("Attempted").append("</th>").append("<th style=\"border: 1px solid black;text-align: left\">").append("Total Items").append("</th>").append("<th style=\"border: 1px solid black;text-align: left\">").append("Success").append("</th>").append("<th style=\"border: 1px solid black;text-align: left\">").append("Failed").append("</th>").append("<th style=\"border: 1px solid black;text-align: left\">").append("Comments").append("</th>");
        for (int i = 7; i > 0; --i) {
            List<String> statusList = this.getStatus(i, email);
            List<String> startTimeList = this.getBackupStartTime(i, email);
            List<String> endTimeList = this.getBackupEndTime(i, email);
            List<String> backupAttemptedList = this.getBackupAttempted(i, email);
            List<String> backupTotalItemsList = this.getBackupTotalItems(i, email);
            List<String> backupSuccessItemsList = this.getBackupSuccess(i, email);
            List<String> backupFailedItemsList = this.getBackupFailed(i, email);
            List<String> commentsList = this.getComments(i, email);
            int rowspan = 1;
            if (!CollectionUtils.isEmpty(startTimeList) && startTimeList.size() > 2) {
                rowspan = startTimeList.size() / 2;
            }
            if (!CollectionUtils.isEmpty(startTimeList)) {
                this.logger.debug(i + "....&&&startTimeList&&&...." + startTimeList.size());
            }
            this.logger.debug("....&&&rowspan&&&...." + rowspan);
            bodyData.append("<tr align=\"center\" style=\"border: 1px solid black;\">");
            Object listIterator = new ArrayListIterator();
            if (!CollectionUtils.isEmpty(statusList)) {
                listIterator = statusList.listIterator();
            }
            Object bkpStartlistIterator = new ArrayListIterator();
            if (!CollectionUtils.isEmpty(startTimeList)) {
                bkpStartlistIterator = startTimeList.listIterator();
            }
            Object bkpEndlistIterator = new ArrayListIterator();
            if (!CollectionUtils.isEmpty(endTimeList)) {
                bkpEndlistIterator = endTimeList.listIterator();
            }
            Object backupAttemptedListIterator = new ArrayListIterator();
            if (!CollectionUtils.isEmpty(backupAttemptedList)) {
                backupAttemptedListIterator = backupAttemptedList.listIterator();
            }
            Object backupTotalItemsListIterator = new ArrayListIterator();
            if (!CollectionUtils.isEmpty(backupTotalItemsList)) {
                backupTotalItemsListIterator = backupTotalItemsList.listIterator();
            }
            Object backupSuccessItemsListIterator = new ArrayListIterator();
            if (!CollectionUtils.isEmpty(backupSuccessItemsList)) {
                backupSuccessItemsListIterator = backupSuccessItemsList.listIterator();
            }
            Object backupFailedItemsListIterator = new ArrayListIterator();
            if (!CollectionUtils.isEmpty(backupFailedItemsList)) {
                backupFailedItemsListIterator = backupFailedItemsList.listIterator();
            }
            List<String> completionPercentageList = this.getCompletionPercentage(i, email);
            Object comlistIterator = new ArrayListIterator();
            if (!CollectionUtils.isEmpty(completionPercentageList)) {
                comlistIterator = completionPercentageList.listIterator();
            }
            List<String> remarksList = this.getRemarks(i, email);
            Object remarklistIterator = new ArrayListIterator();
            if (!CollectionUtils.isEmpty(remarksList)) {
                ArrayList<String> cleanedList = new ArrayList<String>();
                for (String val : remarksList) {
                    cleanedList.add(val);
                }
                this.logger.debug(remarksList.size() + "..overalllist..." + cleanedList.size());
                remarklistIterator = remarksList.listIterator();
            }
            Object commentsListIterator = new ArrayListIterator();
            if (!CollectionUtils.isEmpty(commentsList)) {
                commentsListIterator = commentsList.listIterator();
            }
            this.logger.debug("///////" + this.getWeekDay(i));
            boolean firstTime = true;
            boolean j = false;
            while (bkpStartlistIterator.hasNext()) {
                String comStr;
                String str = (String)bkpStartlistIterator.next();
                this.logger.debug("&&&&&&&&&&&&&&&&&&&&&&status...." + str);
                bodyData.append("<tr class=\"top bottom row\">");
                bodyData.append("<td style=\"border: 1px solid black;text-align: center;\">");
                str = str.replaceAll("<hr>", "");
                if (j) {
                    bodyData.append("<br/>");
                }
                bodyData.append(str);
                bodyData.append("</td>");
                if (bkpEndlistIterator.hasNext()) {
                    comStr = (String)bkpEndlistIterator.next();
                    if (!StringUtils.isEmpty((String)comStr)) {
                        comStr = comStr.trim();
                    }
                    if (StringUtils.isEmpty((String)comStr) && bkpEndlistIterator.hasNext()) {
                        comStr = (String)bkpEndlistIterator.next();
                    }
                    comStr = comStr.replaceAll("<hr>", "");
                    bodyData.append("<td style=\"border: 1px solid black;text-align: center;\">").append(comStr).append("</td>");
                } else {
                    bodyData.append("<td style=\"border: 1px solid black;text-align: center;\">").append("-").append("</td>");
                }
                bodyData.append("</td>");
                if (backupAttemptedListIterator.hasNext()) {
                    comStr = (String)backupAttemptedListIterator.next();
                    if (!StringUtils.isEmpty((String)comStr)) {
                        comStr = comStr.trim();
                    }
                    if (StringUtils.isEmpty((String)comStr) && backupAttemptedListIterator.hasNext()) {
                        comStr = (String)backupAttemptedListIterator.next();
                    }
                    comStr = comStr.replaceAll("<hr>", "");
                    bodyData.append("<td style=\"border: 1px solid black;text-align: center;\">").append(comStr).append("</td>");
                } else {
                    bodyData.append("<td style=\"border: 1px solid black;text-align: center;\">").append("-").append("</td>");
                }
                bodyData.append("</td>");
                if (backupTotalItemsListIterator.hasNext()) {
                    comStr = (String)backupTotalItemsListIterator.next();
                    if (!StringUtils.isEmpty((String)comStr)) {
                        comStr = comStr.trim();
                    }
                    if (StringUtils.isEmpty((String)comStr) && backupTotalItemsListIterator.hasNext()) {
                        comStr = (String)backupTotalItemsListIterator.next();
                    }
                    comStr = comStr.replaceAll("<hr>", "");
                    bodyData.append("<td style=\"border: 1px solid black;text-align: center;\">").append(comStr).append("</td>");
                } else {
                    bodyData.append("<td style=\"border: 1px solid black;text-align: center;\">").append("-").append("</td>");
                }
                bodyData.append("</td>");
                if (backupSuccessItemsListIterator.hasNext()) {
                    comStr = (String)backupSuccessItemsListIterator.next();
                    if (!StringUtils.isEmpty((String)comStr)) {
                        comStr = comStr.trim();
                    }
                    if (StringUtils.isEmpty((String)comStr) && backupSuccessItemsListIterator.hasNext()) {
                        comStr = (String)backupSuccessItemsListIterator.next();
                    }
                    comStr = comStr.replaceAll("<hr>", "");
                    bodyData.append("<td style=\"border: 1px solid black;text-align: center;\">").append(comStr).append("</td>");
                } else {
                    bodyData.append("<td style=\"border: 1px solid black;text-align: center;\">").append("-").append("</td>");
                }
                bodyData.append("</td>");
                if (backupFailedItemsListIterator.hasNext()) {
                    comStr = (String)backupFailedItemsListIterator.next();
                    if (!StringUtils.isEmpty((String)comStr)) {
                        comStr = comStr.trim();
                    }
                    if (StringUtils.isEmpty((String)comStr) && backupFailedItemsListIterator.hasNext()) {
                        comStr = (String)backupFailedItemsListIterator.next();
                    }
                    comStr = comStr.replaceAll("<hr>", "");
                    bodyData.append("<td style=\"border: 1px solid black;text-align: center;\">").append(comStr).append("</td>");
                } else {
                    bodyData.append("<td style=\"border: 1px solid black;text-align: center;\">").append("-").append("</td>");
                }
                bodyData.append("</td>");
                if (commentsListIterator.hasNext()) {
                    comStr = (String)commentsListIterator.next();
                    if (StringUtils.isEmpty((String)comStr)) {
                        bodyData.append("<td style=\"border: 1px solid black;text-align: center;\">").append("-").append("</td>");
                    } else {
                        comStr = comStr.trim();
                        comStr = comStr.replaceAll("<hr>", "");
                        bodyData.append("<td style=\"border: 1px solid black;text-align: center;\">").append(comStr).append("</td>");
                    }
                } else {
                    bodyData.append("<td style=\"border: 1px solid black;text-align: center;\">").append("-").append("</td>");
                }
                bodyData.append("</tr>");
            }
            bodyData.append("</tr>");
        }
        bodyData.append("</tbody>").append("</table>").append("<br>");
        this.logger.debug("....bodydatamy...." + bodyData.toString());
        return bodyData.toString();
    }

    private void setDate(EmailProps email, int dayValue, String date) {
        switch (dayValue) {
            case 1: {
                email.setSundayDate(date);
                break;
            }
            case 2: {
                email.setMondayDate(date);
                break;
            }
            case 3: {
                email.setTuesdayDate(date);
                break;
            }
            case 4: {
                email.setWednesdayDate(date);
                break;
            }
            case 5: {
                email.setThursdayDate(date);
                break;
            }
            case 6: {
                email.setFridayDate(date);
                break;
            }
            case 7: {
                email.setSaturdayDate(date);
                break;
            }
            default: {
                this.logger.debug(INVALID_DAY_VALUE);
            }
        }
    }

    private String getMultipleStatusTemplateRemarks(List<String> statusList) {
        StringBuilder statusTemplate = new StringBuilder();
        if (!CollectionUtils.isEmpty(statusList)) {
            statusList.forEach(status -> {
                if (!StringUtils.isEmpty((String)status) && !StringUtils.isEmpty((String)status.trim())) {
                    statusTemplate.append("<p style=\"height:100px;\">").append((String)status).append("</p>");
                }
                this.logger.debug("...........statusTemplate........" + statusTemplate.toString());
            });
        }
        return statusTemplate.toString();
    }

    private String getCompletionPercentageString(List<String> statusList) {
        StringBuilder statusTemplate = new StringBuilder();
        if (!CollectionUtils.isEmpty(statusList)) {
            statusList.forEach(status -> {
                if (!StringUtils.isEmpty((String)status) && !StringUtils.isEmpty((String)status.trim())) {
                    statusTemplate.append("<p style=\"height:100px;\">").append((String)status).append("</p>");
                }
            });
        }
        return statusTemplate.toString();
    }

    private List<String> getCompletionPercentage(int day, EmailProps email) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -day);
        int dayValue = cal.get(7);
        switch (dayValue) {
            case 7: {
                return email.getSaturdayComplitionDetails();
            }
            case 6: {
                return email.getFridayComplitionDetails();
            }
            case 5: {
                return email.getThursdayComplitionDetails();
            }
            case 4: {
                return email.getWednesdayComplitionDetails();
            }
            case 3: {
                return email.getTuesdayComplitionDetails();
            }
            case 2: {
                return email.getMondayComplitionDetails();
            }
            case 1: {
                return email.getSundayComplitionDetails();
            }
        }
        return null;
    }

    private void setBackupStatusForPreviousDays(EmailProps email, List<Integer> batchStartDayValue, String batchId) {
        String status = "In progress";
        batchStartDayValue.stream().forEach(dayValue -> {
            switch (dayValue) {
                case 7: {
                    email.setSaturdayStatus(status);
                    break;
                }
                case 6: {
                    email.setFridayStatus(status);
                    break;
                }
                case 5: {
                    email.setThursdayStatus(status);
                    break;
                }
                case 4: {
                    email.setWednesdayStatus(status);
                    break;
                }
                case 3: {
                    email.setTuesdayStatus(status);
                    break;
                }
                case 2: {
                    email.setMondayStatus(status);
                    break;
                }
                case 1: {
                    email.setSundayStatus(status);
                    break;
                }
                default: {
                    this.logger.debug(INVALID_DAY_VALUE);
                }
            }
        });
    }

    private String getWeekDay(int day) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat simpleDateformat = new SimpleDateFormat("EEEE");
        if (day != 0) {
            cal.add(5, -day);
        }
        return simpleDateformat.format(cal.getTime());
    }

    private String getWeekDate(int day) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat simpleDateformat = new SimpleDateFormat("dd/MM/yyyy");
        if (day != 0) {
            cal.add(5, -day);
        }
        return simpleDateformat.format(cal.getTime());
    }

    private List<String> getStatus(int day, EmailProps email) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -day);
        int dayValue = cal.get(7);
        this.logger.debug("getStatus : : :" + dayValue);
        switch (dayValue) {
            case 7: {
                return email.getSaturdayStatus();
            }
            case 6: {
                return email.getFridayStatus();
            }
            case 5: {
                return email.getThursdayStatus();
            }
            case 4: {
                return email.getWednesdayStatus();
            }
            case 3: {
                return email.getTuesdayStatus();
            }
            case 2: {
                return email.getMondayStatus();
            }
            case 1: {
                return email.getSundayStatus();
            }
        }
        this.logger.debug(INVALID_DAY_VALUE);
        return null;
    }

    private List<String> getComments(int day, EmailProps email) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -day);
        int dayValue = cal.get(7);
        this.logger.debug("getComments : : :" + dayValue);
        switch (dayValue) {
            case 7: {
                return email.getSaturdayComments();
            }
            case 6: {
                return email.getFridayComments();
            }
            case 5: {
                return email.getThursdayComments();
            }
            case 4: {
                return email.getWednesdayComments();
            }
            case 3: {
                this.logger.debug("..tuesday comments ..." + email.getTuesdayComments());
                return email.getTuesdayComments();
            }
            case 2: {
                return email.getMondayComments();
            }
            case 1: {
                return email.getSundayComments();
            }
        }
        this.logger.debug(INVALID_DAY_VALUE);
        return null;
    }

    private List<String> getBackupStartTime(int day, EmailProps email) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -day);
        int dayValue = cal.get(7);
        this.logger.debug("getBackupStartTime : : :" + dayValue);
        switch (dayValue) {
            case 7: {
                return email.getSaturdayStartTime();
            }
            case 6: {
                return email.getFridayStartTime();
            }
            case 5: {
                return email.getThursdayStartTime();
            }
            case 4: {
                return email.getWednesdayStartTime();
            }
            case 3: {
                return email.getTuesdayStartTime();
            }
            case 2: {
                return email.getMondayStartTime();
            }
            case 1: {
                return email.getSundayStartTime();
            }
        }
        this.logger.debug(INVALID_DAY_VALUE);
        return null;
    }

    private List<String> getBackupEndTime(int day, EmailProps email) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -day);
        int dayValue = cal.get(7);
        this.logger.debug("getBackupEndTime : : :" + dayValue);
        switch (dayValue) {
            case 7: {
                return email.getSaturdayEndTime();
            }
            case 6: {
                return email.getFridayEndTime();
            }
            case 5: {
                return email.getThursdayEndTime();
            }
            case 4: {
                return email.getWednesdayEndTime();
            }
            case 3: {
                return email.getTuesdayEndTime();
            }
            case 2: {
                return email.getMondayEndTime();
            }
            case 1: {
                return email.getSundayEndTime();
            }
        }
        this.logger.debug(INVALID_DAY_VALUE);
        return null;
    }

    private List<String> getBackupAttempted(int day, EmailProps email) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -day);
        int dayValue = cal.get(7);
        this.logger.debug("getBackupAttempted : : :" + dayValue);
        switch (dayValue) {
            case 7: {
                return email.getSaturdayAttempted();
            }
            case 6: {
                return email.getFridayAttempted();
            }
            case 5: {
                return email.getThursdayAttempted();
            }
            case 4: {
                return email.getWednesdayAttempted();
            }
            case 3: {
                return email.getTuesdayAttempted();
            }
            case 2: {
                return email.getMondayAttempted();
            }
            case 1: {
                return email.getSundayAttempted();
            }
        }
        this.logger.debug(INVALID_DAY_VALUE);
        return null;
    }

    private List<String> getBackupTotalItems(int day, EmailProps email) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -day);
        int dayValue = cal.get(7);
        this.logger.debug("getBackupTotalItems : : :" + dayValue);
        switch (dayValue) {
            case 7: {
                return email.getSaturdayTotalItems();
            }
            case 6: {
                return email.getFridayTotalItems();
            }
            case 5: {
                return email.getThursdayTotalItems();
            }
            case 4: {
                return email.getWednesdayTotalItems();
            }
            case 3: {
                return email.getTuesdayTotalItems();
            }
            case 2: {
                return email.getMondayTotalItems();
            }
            case 1: {
                return email.getSundayTotalItems();
            }
        }
        this.logger.debug(INVALID_DAY_VALUE);
        return null;
    }

    private List<String> getBackupSuccess(int day, EmailProps email) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -day);
        int dayValue = cal.get(7);
        this.logger.debug("getBackupSuccess : : :" + dayValue);
        switch (dayValue) {
            case 7: {
                return email.getSaturdaySuccess();
            }
            case 6: {
                return email.getFridaySuccess();
            }
            case 5: {
                return email.getThursdaySuccess();
            }
            case 4: {
                return email.getWednesdaySuccess();
            }
            case 3: {
                return email.getTuesdaySuccess();
            }
            case 2: {
                return email.getMondaySuccess();
            }
            case 1: {
                return email.getSundaySuccess();
            }
        }
        this.logger.debug(INVALID_DAY_VALUE);
        return null;
    }

    private List<String> getBackupFailed(int day, EmailProps email) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -day);
        int dayValue = cal.get(7);
        this.logger.debug("getBackupFailed : : :" + dayValue);
        switch (dayValue) {
            case 7: {
                return email.getSaturdayFailed();
            }
            case 6: {
                return email.getFridayFailed();
            }
            case 5: {
                return email.getThursdayFailed();
            }
            case 4: {
                return email.getWednesdayFailed();
            }
            case 3: {
                return email.getTuesdayFailed();
            }
            case 2: {
                return email.getMondayFailed();
            }
            case 1: {
                return email.getSundayFailed();
            }
        }
        this.logger.debug(INVALID_DAY_VALUE);
        return null;
    }

    private List<String> getRemarks(int day, EmailProps email) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -day);
        int dayValue = cal.get(7);
        switch (dayValue) {
            case 7: {
                return email.getSaturdayRemarks();
            }
            case 6: {
                return email.getFridayRemarks();
            }
            case 5: {
                return email.getThursdayRemarks();
            }
            case 4: {
                return email.getWednesdayRemarks();
            }
            case 3: {
                return email.getTuesdayRemarks();
            }
            case 2: {
                return email.getMondayRemarks();
            }
            case 1: {
                return email.getSundayRemarks();
            }
        }
        this.logger.debug(INVALID_DAY_VALUE);
        return null;
    }

    private List<Integer> getDaysOfBatch(String activityStartDateString, int currentDayTemp) {
        int currentDay = currentDayTemp;
        String batchStartDateString = this.getDateForApproprioteDay(0);
        Date activityStartTime = null;
        Date batchStartTime = null;
        SimpleDateFormat format = new SimpleDateFormat(MM_DD_YYYY);
        try {
            activityStartTime = format.parse(activityStartDateString);
            batchStartTime = format.parse(batchStartDateString);
        }
        catch (ParseException e) {
            this.logger.debug(PARSE_EXCEPTION + e);
            this.logger.error(PARSE_EXCEPTION + e.getMessage());
        }
        this.logger.debug("Activity Start Date : " + activityStartTime);
        this.logger.debug("Batch Start Date : " + batchStartTime);
        Date date = activityStartTime != null && activityStartTime.before(batchStartTime) ? batchStartTime : activityStartTime;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int startDay = calendar.get(7);
        ArrayList<Integer> days = new ArrayList<Integer>();
        if (startDay > currentDay) {
            currentDay += 7;
        }
        if (activityStartTime != null && !activityStartTime.before(batchStartTime)) {
            ++startDay;
        }
        for (int i = startDay; i < currentDay; ++i) {
            int day = i % 7;
            if (day == 0) {
                day = 7;
            }
            days.add(day);
        }
        return days;
    }

    private String getMultipleStatusTemplate(List<String> statusList) {
        StringBuilder statusTemplate = new StringBuilder();
        int count = 2;
        if (!CollectionUtils.isEmpty(statusList)) {
            for (String status : statusList) {
                this.logger.debug("....status......" + status);
                if (count % 2 != 0) {
                    statusTemplate.append("<br>").append(status.replaceAll("<hr>", "")).append("</p><hr>");
                } else {
                    statusTemplate.append("<p style=\"height:100px;\">").append(status);
                }
                ++count;
            }
        }
        this.logger.debug("Returned : " + statusTemplate.toString());
        return statusTemplate.toString();
    }

    private void setNoAttemptForSendmail(EmailProps email, List<BackupActivityHistoryElement> backupHistoryElements, DeviceBackupOverView deviceBkpOverview) {
        if (CollectionUtils.isEmpty((Collection)email.getMondayStatus())) {
            if (this.checkIsBkpRunning(backupHistoryElements)) {
                email.setMondayStatus("In progress");
            } else if (!this.checkDeviceRegisterIsAfter(deviceBkpOverview, email.getMondayDate())) {
                email.setMondayStatus("Not Applicable");
            } else {
                email.setMondayStatus(NO_ATTEMPT);
            }
        }
        if (CollectionUtils.isEmpty((Collection)email.getTuesdayStatus())) {
            if (this.checkIsBkpRunning(backupHistoryElements)) {
                email.setTuesdayStatus("In progress");
            } else if (!this.checkDeviceRegisterIsAfter(deviceBkpOverview, email.getTuesdayDate())) {
                email.setTuesdayStatus("Not Applicable");
            } else {
                email.setTuesdayStatus(NO_ATTEMPT);
            }
        }
        if (CollectionUtils.isEmpty((Collection)email.getWednesdayStatus())) {
            if (this.checkIsBkpRunning(backupHistoryElements)) {
                email.setWednesdayStatus("In progress");
            } else if (!this.checkDeviceRegisterIsAfter(deviceBkpOverview, email.getWednesdayDate())) {
                email.setWednesdayStatus("Not Applicable");
            } else {
                email.setWednesdayStatus(NO_ATTEMPT);
            }
        }
        if (CollectionUtils.isEmpty((Collection)email.getThursdayStatus())) {
            if (this.checkIsBkpRunning(backupHistoryElements)) {
                email.setThursdayStatus("In progress");
            } else if (!this.checkDeviceRegisterIsAfter(deviceBkpOverview, email.getThursdayDate())) {
                email.setThursdayStatus("Not Applicable");
            } else {
                email.setThursdayStatus(NO_ATTEMPT);
            }
        }
        if (CollectionUtils.isEmpty((Collection)email.getFridayStatus())) {
            if (this.checkIsBkpRunning(backupHistoryElements)) {
                email.setFridayStatus("In progress");
            } else if (!this.checkDeviceRegisterIsAfter(deviceBkpOverview, email.getFridayDate())) {
                email.setFridayStatus("Not Applicable");
            } else {
                email.setFridayStatus(NO_ATTEMPT);
            }
        }
        if (CollectionUtils.isEmpty((Collection)email.getSaturdayStatus())) {
            if (this.checkIsBkpRunning(backupHistoryElements)) {
                email.setSaturdayStatus("In progress");
            } else if (!this.checkDeviceRegisterIsAfter(deviceBkpOverview, email.getSaturdayDate())) {
                email.setSaturdayStatus("Not Applicable");
            } else {
                email.setSaturdayStatus(NO_ATTEMPT);
            }
        }
        if (CollectionUtils.isEmpty((Collection)email.getSundayStatus())) {
            if (this.checkIsBkpRunning(backupHistoryElements)) {
                email.setSundayStatus("In progress");
            } else if (!this.checkDeviceRegisterIsAfter(deviceBkpOverview, email.getSundayDate())) {
                email.setSundayStatus("Not Applicable");
            } else {
                email.setSundayStatus(NO_ATTEMPT);
            }
        }
    }

    private boolean checkIsBkpRunning(List<BackupActivityHistoryElement> backupHistoryElements) {
        boolean result = false;
        if (!CollectionUtils.isEmpty(backupHistoryElements) && backupHistoryElements.size() == 1 && backupHistoryElements.get(0) != null) {
            try {
                Date batchStartDate = new SimpleDateFormat(MM_DD_YYYY).parse(backupHistoryElements.get(0).getStartTime());
                Date batchEndDate = new SimpleDateFormat(MM_DD_YYYY).parse(backupHistoryElements.get(0).getStartTime());
                Calendar cal = Calendar.getInstance();
                cal.add(5, -8);
                Date mailStartDate = cal.getTime();
                boolean isBefore = mailStartDate.before(batchStartDate);
                cal = Calendar.getInstance();
                cal.add(5, -1);
                Date mailEndDate = cal.getTime();
                boolean isAfter = batchEndDate.after(mailEndDate);
                if (isAfter && isBefore) {
                    result = true;
                }
            }
            catch (ParseException e) {
                this.logger.debug(NUMBER_FORMAT_EXCEPTION + e);
                this.logger.error(NUMBER_FORMAT_EXCEPTION + e.getMessage());
            }
        }
        return result;
    }

    private boolean checkDeviceRegisterIsAfter(DeviceBackupOverView device, String daysDate) {
        boolean result = false;
        if (device != null && StringUtils.isNotEmpty((String)device.getEpaInstallationDate()) && !StringUtils.isEmpty((String)daysDate)) {
            try {
                Date date = new SimpleDateFormat(MM_DD_YYYY).parse(daysDate);
                SimpleDateFormat df2 = new SimpleDateFormat(MM_DD_YYYY);
                Date dateD = new Date(Long.parseLong(device.getEpaInstallationDate()));
                df2.format(dateD);
                Date dateD1 = new SimpleDateFormat(MM_DD_YYYY).parse(df2.format(dateD));
                boolean isAfter = date.after(dateD1);
                if (isAfter) {
                    result = true;
                }
            }
            catch (ParseException e) {
                this.logger.debug(NUMBER_FORMAT_EXCEPTION + e);
                this.logger.error(NUMBER_FORMAT_EXCEPTION + e.getMessage());
            }
        }
        return result;
    }

    private String getStatusWithTime(String time, String status) {
        String formatedTime = this.getTime(time);
        return status + " - " + formatedTime;
    }

    private String getTime(String startDate) {
        String date = "";
        try {
            SimpleDateFormat df2 = new SimpleDateFormat("HH:mm");
            Date dateD = new Date(startDate);
            date = df2.format(dateD);
            this.logger.debug("Time : : :" + date);
        }
        catch (NumberFormatException e) {
            this.logger.debug(NUMBER_FORMAT_EXCEPTION + e);
            this.logger.error(NUMBER_FORMAT_EXCEPTION + e.getMessage());
        }
        return date;
    }

    private static String getDateStr(long startDate) {
        String date = "";
        try {
            SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
            Date dateD = new Date(startDate);
            date = df2.format(dateD);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return date;
    }

    private boolean isBackupStartedinWindowPeriod(String activityStartDateString) {
        String batchStartDateString = this.getDateForApproprioteDay(0);
        Date activityStartTime = null;
        Date batchStartTime = null;
        SimpleDateFormat format = new SimpleDateFormat(MM_DD_YYYY);
        try {
            activityStartTime = format.parse(activityStartDateString);
            batchStartTime = format.parse(batchStartDateString);
        }
        catch (ParseException e) {
            this.logger.debug(PARSE_EXCEPTION + e);
            this.logger.error(PARSE_EXCEPTION + e.getMessage());
        }
        this.logger.debug("Activity Start Date : " + activityStartTime);
        this.logger.debug("Batch Start Date : " + batchStartTime);
        return activityStartTime == null || !activityStartTime.before(batchStartTime);
    }

    private boolean isdateAfter(String batchEndDate, String windowEndDate) {
        boolean isdateBefore = false;
        try {
            SimpleDateFormat format = new SimpleDateFormat(MM_DD_YYYY);
            if (StringUtils.isNotEmpty((String)batchEndDate) && StringUtils.isNotEmpty((String)windowEndDate)) {
                Date formatedBatchEndDate = format.parse(batchEndDate);
                Date formatedWindowEndDate = format.parse(windowEndDate);
                isdateBefore = formatedBatchEndDate.after(formatedWindowEndDate);
            }
        }
        catch (Exception e) {
            this.logger.debug(NUMBER_FORMAT_EXCEPTION + e);
            this.logger.error(NUMBER_FORMAT_EXCEPTION + e.getMessage());
        }
        return isdateBefore;
    }
}

