/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.UserElement;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.User;
import com.parablu.rf.service.BackupBatchService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.StatefulJob;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class BackupActivityNotifierTimer
extends QuartzJobBean
implements StatefulJob {
    private Logger logger = LogManager.getLogger(BackupActivityNotifierTimer.class);
    private BackupBatchService backupBatchService;
    private LicenseService licenseService;
    private CloudMailService cloudMailService;
    private UserManagementService userManagementService;
    private DeviceManagementService deviceManagementService;

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setBackupBatchService(BackupBatchService backupBatchService) {
        this.backupBatchService = backupBatchService;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"backupActivityNotifierTrigger")) {
            this.logger.debug("BackupActivityNotifierTimer ............ disabled");
            return;
        }
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            List adminUsers = this.userManagementService.getAllAdmins(cloud.getCloudId(), cloud.getCloudName());
            List legalHoldUserElements = this.userManagementService.getAllLegalHoldUsers(cloud.getCloudId(), cloud.getCloudName());
            for (UserElement userElement : legalHoldUserElements) {
                this.logger.debug("legal hold user>>>>>>>>>" + userElement.getUserName() + "cloud name>>>>>>" + cloud.getCloudName() + "legalHoldUserElements size" + legalHoldUserElements.size() + "deviceManagementService" + this.deviceManagementService);
                List devices = this.deviceManagementService.getAllDevicesForUser(cloud.getCloudId(), cloud.getCloudName(), userElement.getUserName());
                for (Device device : devices) {
                    Long diffTime;
                    BackupBatch lastBackupStatus;
                    User user;
                    if (device == null || device.getDeviceName() == null || device.getUserName() == null || (user = this.userManagementService.getUserDetails(cloud.getCloudId(), cloud.getCloudName(), device.getUserName())) == null || (lastBackupStatus = this.backupBatchService.getLastBackupOnly(cloud.getCloudId(), cloud.getCloudName(), user, device)) == null || (diffTime = Long.valueOf(System.currentTimeMillis() - lastBackupStatus.getBatchStartTimestamp())) < 86400000L) continue;
                    this.sendEmail(lastBackupStatus, "no-backup-activity", adminUsers);
                }
            }
        }
    }

    private void sendEmail(BackupBatch backupBatch, String action, List<User> adminUsers) {
        for (User user : adminUsers) {
            EmailProps email = new EmailProps();
            ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
            email.setAction(action);
            email.setActionBy(user.getUserName());
            email.setDeviceName(backupBatch.getDeviceName());
            email.setActionOn(backupBatch.getUserName());
            EmailRecipent emailRecipent = new EmailRecipent();
            emailRecipent.setUserName(user.getUserName());
            emailRecipent.setEmail(user.getEmailId());
            email.setStartDate(this.getDate(backupBatch.getBatchStartTimestamp()));
            emailRecipents.add(emailRecipent);
            this.logger.debug(" @@@@@@@@@@@@@@@@@@@@@@@@@@ inside send no backup activity job timer " + backupBatch.getId());
            if (emailRecipents.isEmpty()) continue;
            this.logger.debug(" @@@ Before sending mail ");
            email.setRecipents(emailRecipents);
            this.cloudMailService.sendMail(email);
        }
    }

    private String getDate(long dateVal) {
        Date date = new Date(dateVal);
        SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        return df2.format(date);
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setDeviceManagementService(DeviceManagementService deviceManagementService) {
        this.deviceManagementService = deviceManagementService;
    }
}

