/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.service.AADManagementService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.constant.ParaMailHelperConstant;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.pcbd.domain.AADAuthorizationToken;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.User;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.StatefulJob;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class AADTokenExpiryTimer
extends QuartzJobBean
implements StatefulJob {
    private static Logger logger = LogManager.getLogger(AADTokenExpiryTimer.class);
    private static final String EXCEPTION = " Exception  :";
    private LicenseService licenseService;
    private UserManagementService userManagementService;
    private CloudMailService cloudMailService;
    private AADManagementService aadManagementService;

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"aadTokenExpiryTrigger")) {
            logger.debug("AADTokenExpiryTimer ........... disabled");
            return;
        }
        logger.debug("........AADTokenExpiryTimer is started........");
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            if (this.isAADEnabled(cloud.getCloudCustomisableDetails())) {
                int cloudId = cloud.getCloudId();
                boolean isAADTokenExpired = this.aadManagementService.checkTokenExpired(cloudId);
                if (!isAADTokenExpired) continue;
                AADAuthorizationToken authorizationToken = this.aadManagementService.getAADAuthorizationToken(cloudId);
                String userName = "";
                if (!StringUtils.isEmpty((CharSequence)authorizationToken.getUser_principal())) {
                    logger.debug("...username exists for consent..." + authorizationToken.getUser_principal());
                    userName = authorizationToken.getUser_principal();
                    this.sendEmail(userName, cloud);
                }
                List users = this.userManagementService.getAllAdmins(cloudId, cloud.getCloudName());
                for (User user : users) {
                    this.sendNotifierEmail(user, cloud, userName);
                }
                continue;
            }
            logger.debug("........AAD is not enabled so return........");
        }
        logger.debug("........AADTokenExpiryTimer is started........");
    }

    private boolean isAADEnabled(List<CloudCustomisableDetails> list) {
        boolean isAADEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"AAD Enabled".equals(customisableDetails.getName())) continue;
            isAADEnabled = true;
            break;
        }
        return isAADEnabled;
    }

    private void sendEmail(String emailId, Cloud cloud) {
        try {
            String cloudName = cloud.getCloudName();
            EmailProps email = new EmailProps();
            ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
            email.setAction("aad-token-expired");
            EmailRecipent emailRecipent = new EmailRecipent();
            emailRecipent.setUserName(emailId);
            emailRecipent.setEmail(emailId);
            email.setActionBy(emailId);
            String login = "azureReauth";
            String url = ParaMailHelperConstant.getPropertyFileValueParacloudUrl() + "/portal/" + login + "?cloudName=" + cloudName + "&uEmail=" + emailId + "&isODBLogin=true&uName=" + emailId;
            logger.debug("......Re authenticate login...." + url);
            email.setDownloadLink(url);
            email.setStartDate(this.getDate(System.currentTimeMillis()));
            email.setToUser(true);
            emailRecipents.add(emailRecipent);
            if (!emailRecipents.isEmpty()) {
                logger.debug(" @@@ Before sending mail ");
                email.setRecipents(emailRecipents);
                this.cloudMailService.sendMail(email);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    private void sendNotifierEmail(User user, Cloud cloud, String userName) {
        try {
            String cloudName = cloud.getCloudName();
            EmailProps email = new EmailProps();
            ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
            email.setAction("aad-token-expired-notifier");
            EmailRecipent emailRecipent = new EmailRecipent();
            emailRecipent.setUserName(user.getUserName());
            emailRecipent.setEmail(user.getEmailId());
            email.setActionBy(user.getUserName());
            String login = "azureReauth";
            String url = ParaMailHelperConstant.getPropertyFileValueParacloudUrl() + "/portal/" + login + "?cloudName=" + cloudName + "&uEmail=" + user.getEmailId() + "&isODBLogin=true&uName=" + user.getUserName();
            logger.debug("......Re authenticate login...." + url);
            email.setDownloadLink(url);
            email.setStartDate(this.getDate(System.currentTimeMillis()));
            email.setActionOn(userName);
            email.setToUser(true);
            emailRecipents.add(emailRecipent);
            if (!emailRecipents.isEmpty()) {
                logger.debug(" @@@ Before sending mail ");
                email.setRecipents(emailRecipents);
                this.cloudMailService.sendMail(email);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    private String getDate(long dateVal) {
        Date date = new Date(dateVal);
        SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        return df2.format(date);
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    public void setAadManagementService(AADManagementService aadManagementService) {
        this.aadManagementService = aadManagementService;
    }
}

