/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.backup.service.impl;

import com.parablu.bluvault.backup.exception.ParacloudBackupException;
import com.parablu.bluvault.backup.service.BackupService;
import com.parablu.bluvault.backup.to.BackupRequestTO;
import com.parablu.bluvault.backup.util.ObjectConversionHelper;
import com.parablu.helper.constant.GeneralHelperConstant;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.httpclient.util.HttpClientUtil;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.ActionStatusElement;
import com.parablu.paracloud.element.BackupActivityHistoryElement;
import com.parablu.paracloud.element.BackupAttemptElement;
import com.parablu.paracloud.element.BackupElement;
import com.parablu.paracloud.element.BackupListElement;
import com.parablu.paracloud.element.ChunkFileInfoElement;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.paracloud.element.FileElement;
import com.parablu.paracloud.element.FileListElement;
import com.parablu.paracloud.element.KeyValueElement;
import com.parablu.paracloud.element.MailAttachmentElement;
import com.parablu.paracloud.element.MailElement;
import com.parablu.paracloud.element.PGInfoElement;
import com.parablu.paracloud.element.StatisticsElement;
import com.parablu.paracloud.element.response.BackupListResponseElement;
import com.parablu.paracloud.to.DownloadTO;
import com.parablu.paracloud.util.DateUtil;
import com.parablu.paracloud.util.DiskSpaceHelper;
import com.parablu.paracloud.util.FileTypeHelper;
import com.parablu.paracloud.util.PathConversionHelper;
import com.parablu.paracloud.util.PathGenerator;
import com.parablu.pcbd.dao.BackUpImageDao;
import com.parablu.pcbd.dao.BackupAHDao;
import com.parablu.pcbd.dao.BackupBatchDao;
import com.parablu.pcbd.dao.BackupLogsDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.dao.ExternalStorageFileImageDao;
import com.parablu.pcbd.dao.PGInfoDao;
import com.parablu.pcbd.dao.SharedFileImageDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackUpImageStatistics;
import com.parablu.pcbd.domain.BackUpImageUQ;
import com.parablu.pcbd.domain.BackupAttempt;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupFile;
import com.parablu.pcbd.domain.BackupLog;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.DeletedBackupFile;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.ExternalStorageFileImage;
import com.parablu.pcbd.domain.MailAttachment;
import com.parablu.pcbd.domain.ReBackUpImage;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.RestoreHistory;
import com.parablu.pcbd.domain.User;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.activation.MimetypesFileTypeMap;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class BackupServiceImpl
implements BackupService {
    private static final int BUFFER_CHUNK_SIZE = 1024;
    private BackUpImageDao backUpImageDao;
    private BackupAHDao backupAHDao;
    private static final String WINDOWS_OS = "win";
    private ExternalStorageFileImageDao externalStorageFileImageDao;
    private ExternalStorageBackupFileDao externalStorageBackupFileDao;
    private BackupBatchDao backupBatchDao;
    private static final String FILE_NOT_FOUND = "File not found";
    private static final String EXCEPTION = "Exception  :";
    public static final String DOWNLOAD_LOCATION = "support/failedFileslogs";
    public static final String PATH_SEPARATOR = "/";
    public static final String FILE_NAME = "failedFileslogs.zip";
    public static final String PRESCAN_COMMAND_EXECUTION = "PRESCAN_COMMAND_EXECUTION";
    private static final String MM_DD_YYYY = "MM/dd/yyyy";
    private static final String PARSE_EXCEPTION = " ParseException  :";
    private static final String PREFIX_HTTP = "http://";
    private static final String PREFIX_HTTPS = "https://";
    Logger logger = LogManager.getLogger(BackupServiceImpl.class);
    @Resource
    private PGInfoDao pgInfoDao;
    private DeviceDao deviceDao;
    @Autowired
    private UserDao userDao;
    private BackupPolicyDao backupPolicyDao;
    private BackupLogsDao backupLogsDao;
    @Resource
    SharedFileImageDao sharedFileImageDao;

    public void setBackupBatchDao(BackupBatchDao backupBatchDao) {
        this.backupBatchDao = backupBatchDao;
    }

    public void setBackupLogsDao(BackupLogsDao backupLogsDao) {
        this.backupLogsDao = backupLogsDao;
    }

    public DeviceDao getDeviceDao() {
        return this.deviceDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public void setBackUpImageDao(BackUpImageDao backUpImageDao) {
        this.backUpImageDao = backUpImageDao;
    }

    public BackUpImageDao getBackUpImageDao() {
        return this.backUpImageDao;
    }

    public ExternalStorageFileImageDao getExternalStorageFileImageDao() {
        return this.externalStorageFileImageDao;
    }

    public void setExternalStorageFileImageDao(ExternalStorageFileImageDao externalStorageFileImageDao) {
        this.externalStorageFileImageDao = externalStorageFileImageDao;
    }

    public BackupAHDao getBackupAHDao() {
        return this.backupAHDao;
    }

    public void setBackupAHDao(BackupAHDao backupAHDao) {
        this.backupAHDao = backupAHDao;
    }

    public ExternalStorageBackupFileDao getExternalStorageBackupFileDao() {
        return this.externalStorageBackupFileDao;
    }

    public void setExternalStorageBackupFileDao(ExternalStorageBackupFileDao externalStorageBackupFileDao) {
        this.externalStorageBackupFileDao = externalStorageBackupFileDao;
    }

    public BackupPolicyDao getBackupPolicyDao() {
        return this.backupPolicyDao;
    }

    public void setBackupPolicyDao(BackupPolicyDao backupPolicyDao) {
        this.backupPolicyDao = backupPolicyDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    @Override
    public List<BackUpImage> getAlldeletedResourceRevision(int cloudId, String cloudName, Device device) {
        List backUpImages = this.backUpImageDao.getLatestFiles(cloudId, cloudName, device, false);
        ArrayList<BackUpImage> backUpImages2 = new ArrayList<BackUpImage>();
        boolean readPreference = false;
        if (PCHelperConstant.isReadPreferenceFromSecondary()) {
            this.logger.debug(" Readpreference to Secondary getAlldeletedResourceRevision .......");
            readPreference = true;
        }
        for (BackUpImage backUpImage : backUpImages) {
            backUpImages2.addAll(this.backUpImageDao.getVersions(cloudId, cloudName, backUpImage.getFileName(), backUpImage.getDevicePath(), device, readPreference));
        }
        return backUpImages2;
    }

    @Override
    public List<BackupElement> getChildren(int cloudId, String cloudName, String folderPath, ObjectId deviceId, boolean isrestoreDeletedFile) {
        List backUpImages;
        Device device = this.deviceDao.getDeviceById(cloudId, deviceId);
        this.logger.debug(deviceId + "============" + device.getDeviceUUID());
        if (folderPath == null || "".equals(folderPath)) {
            this.logger.debug("============inside folde=++++++++++++++++++++++++++");
            backUpImages = this.backUpImageDao.getBaseChildrenByDevice(cloudId, cloudName, device, isrestoreDeletedFile);
        } else {
            this.logger.debug("**************************************************************");
            backUpImages = this.backUpImageDao.getChildrenByFolder(cloudId, cloudName, folderPath, device, isrestoreDeletedFile);
        }
        if (backUpImages == null || backUpImages.isEmpty()) {
            this.logger.debug("NO FILES FOR PATH ...." + folderPath + " device ID " + deviceId);
            return null;
        }
        this.logger.debug("new backup images from DB : " + backUpImages.size());
        return this.getBackupElementsFromBackupImg(backUpImages);
    }

    @Override
    public List<BackupElement> getVersions(int cloudId, String cloudName, String fileName, String folderPath, Device device, String serverModifiedTime) {
        boolean readPreference = false;
        if (PCHelperConstant.isReadPreferenceFromSecondary()) {
            readPreference = true;
            this.logger.debug(" Readpreference to Secondary getVersions .......");
        }
        long modifiedTime = 0L;
        if (!org.springframework.util.StringUtils.isEmpty((Object)serverModifiedTime)) {
            modifiedTime = Long.parseLong(serverModifiedTime);
        }
        this.logger.debug("........serverModifiedTime....." + serverModifiedTime);
        List backUpImages = this.backUpImageDao.getVersions(cloudId, cloudName, fileName, folderPath, device, readPreference);
        if (backUpImages == null || backUpImages.isEmpty()) {
            return null;
        }
        ArrayList<BackupElement> backupElements = new ArrayList<BackupElement>();
        for (BackUpImage b : backUpImages) {
            this.logger.debug(".........." + b.getLastServerModifiedTime());
            if (modifiedTime != 0L && b.getLastServerModifiedTime() > modifiedTime) continue;
            BackupElement backupElement = new BackupElement();
            BeanUtils.copyProperties((Object)b, (Object)backupElement);
            if (!b.isFolder() && b.getSize() == 0L && b.getSizeInBytes() > 0L) {
                long filesizeInKB = (long)Math.ceil(b.getSizeInBytes() / 1024L);
                if (filesizeInKB <= 0L) {
                    filesizeInKB = 1L;
                }
                backupElement.setSize(filesizeInKB);
            }
            backupElement.setFileCompletePath(b.getDevicePath());
            backupElement.setFileName(b.getFileName());
            backupElement.setFileUserOwner(b.getUserName());
            Device device1 = b.getDeviceUUID() == null ? b.getDevice() : this.deviceDao.getDeviceInfoByUUID(cloudId, cloudName, b.getDeviceUUID());
            backupElement.setFileDeviceOwner(device1.getDeviceName());
            String extension = FilenameUtils.getExtension((String)b.getFileName());
            if (FileTypeHelper.isImageFile((String)extension) || FileTypeHelper.isVideoFile((String)extension)) {
                backupElement.setThumbnailPath("/t/backup" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + b.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + b.getfSPath());
            }
            ArrayList chunks = new ArrayList();
            backupElement.setChunkFiles(new ArrayList());
            backupElement.getChunkFiles().addAll(chunks);
            backupElement.setExternalStorage(b.isExternalStorage());
            backupElement.setBackupId(b.getId().toString());
            backupElements.add(backupElement);
        }
        return backupElements;
    }

    @Override
    public BackupElement getBackUpImageInfo(int cloudId, String cloudName, String fileName, String devicePath, Device device) {
        List backUpImages;
        boolean readPreference = false;
        if (PCHelperConstant.isReadPreferenceFromSecondary()) {
            readPreference = true;
            this.logger.debug(" Readpreference to Secondary getBackUpImageInfo .......");
        }
        if ((backUpImages = this.backUpImageDao.getVersions(cloudId, cloudName, fileName, devicePath, device, readPreference)) == null || backUpImages.isEmpty()) {
            return null;
        }
        BackUpImage backUpImage = (BackUpImage)backUpImages.get(0);
        BackupElement backupElement = new BackupElement();
        BeanUtils.copyProperties((Object)backUpImage, (Object)backupElement);
        backupElement.setFileCompletePath(backUpImage.getDevicePath());
        backupElement.setFileName(backUpImage.getFileName());
        backupElement.setId(backUpImage.getId().toString());
        String extension = FilenameUtils.getExtension((String)backUpImage.getFileName());
        if (FileTypeHelper.isImageFile((String)extension) || FileTypeHelper.isVideoFile((String)extension)) {
            backupElement.setThumbnailPath("/t/backup" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getfSPath());
        }
        return backupElement;
    }

    @Override
    public List<BackUpImage> getExistingFieldsComparingWithTable(int cloudId, String cloudName, List<FileElement> fileElementList, Device device) {
        ArrayList<BackUpImage> backUpImages = new ArrayList<BackUpImage>();
        ArrayList<String> md5List = new ArrayList<String>();
        for (FileElement fileElement : fileElementList) {
            if (StringUtils.isEmpty((String)fileElement.getMd5checksum()) || "null".equals(fileElement.getMd5checksum())) continue;
            md5List.add(fileElement.getMd5checksum());
        }
        this.logger.debug("Before getting the Backup file list.....md5 list size" + md5List.size());
        List list = this.backUpImageDao.getBackupImageForMd5s(cloudId, device.getUserName(), md5List);
        this.logger.debug("After getting the Backup file list sizee....." + list.size());
        for (BackUpImage backUpImage : list) {
            if (!backUpImage.getUserName().equals(device.getUserName()) || !backUpImage.isPresent()) continue;
            backUpImages.add(backUpImage);
        }
        this.logger.debug("After filtering the Backup file list size....." + backUpImages.size());
        return backUpImages;
    }

    @Override
    public List<BackUpImage> getAllBackUpDataForDevice(int cloudId, String cloudName, Device device) {
        return this.backUpImageDao.getAllBackUpDataForDevice(cloudId, cloudName, device);
    }

    @Override
    public BackupListElement getChildrenByFolder(int cloudId, String cloudName, String folderPath, Device device) {
        BackupListElement backupListElement = new BackupListElement();
        ArrayList<BackupElement> backupElements = new ArrayList<BackupElement>();
        List backUpImages = folderPath == null || "".equals(folderPath) ? this.backUpImageDao.getBaseChildrenByDevice(cloudId, cloudName, device, true) : this.backUpImageDao.getChildrenByFolder(cloudId, cloudName, folderPath, device, true);
        for (BackUpImage backUpImage : backUpImages) {
            BackupElement backupElement = new BackupElement();
            backupElement.setBaseBackup(backUpImage.isBaseBackup());
            backupElement.setFileName(backUpImage.getFileName());
            backupElement.setFileCompletePath(backUpImage.getDevicePath());
            backupElement.setFolder(backUpImage.isFolder());
            backupElement.setLastServerModifiedTime(backUpImage.getLastServerModifiedTime());
            backupElement.setLastClientModifiedTime(backUpImage.getLastClientModifiedTime());
            backupElement.setMd5Checksum(backUpImage.getMd5Checksum());
            backupElement.setStatus(backUpImage.getStatus());
            backupElement.setSize(backUpImage.getSize());
            backupElement.setPresent(backUpImage.isPresent());
            backupElement.setfSPath(backUpImage.getfSPath());
            String extension = FilenameUtils.getExtension((String)backUpImage.getFileName());
            if (FileTypeHelper.isImageFile((String)extension) || FileTypeHelper.isVideoFile((String)extension)) {
                backupElement.setThumbnailPath("/t/backup" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getfSPath());
            }
            backupElements.add(backupElement);
        }
        backupListElement.setFileElementList(backupElements);
        return backupListElement;
    }

    @Override
    public BackUpImage getBackUpImage(int cloudId, String cloudName, String fileName, String folderPath, String deviceUUID) {
        boolean readPreference = false;
        if (PCHelperConstant.isReadPreferenceFromSecondary()) {
            this.logger.debug(" Readpreference to Secondary getBackUpImage .......");
            readPreference = true;
        }
        return this.backUpImageDao.getBackUpImageForFile(cloudId, cloudName, fileName, folderPath, deviceUUID, readPreference);
    }

    @Override
    public void createParentsAndSaveEntry(int cloudId, String cloudName, BackUpImage backUpImage) {
        List<BackupElement> fileElementList;
        BackUpImage parentBackUpImage = this.getParentFile(cloudId, cloudName, backUpImage);
        Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, cloudName, backUpImage.getDeviceUUID());
        if (!(parentBackUpImage != null && parentBackUpImage.isPresent() || (fileElementList = this.getParentfolders(cloudId, cloudName, backUpImage.getDevicePath(), backUpImage.getDeviceUUID())) == null || fileElementList.isEmpty())) {
            this.createParentFolders(cloudId, cloudName, fileElementList, device);
        }
        this.backUpImageDao.saveImageToBackUpDao(cloudId, cloudName, backUpImage, device);
    }

    @Override
    public BackUpImage readFromBackUpTable(int cloudId, String cloudName, String relativePath, String fileName, Device device) {
        boolean readPreference = false;
        if (PCHelperConstant.isReadPreferenceFromSecondary()) {
            this.logger.debug(" Readpreference to Secondary readFromBackUpTable .......");
            readPreference = true;
        }
        return this.backUpImageDao.getBackUpImageForFile(cloudId, cloudName, fileName, relativePath, device.getDeviceUUID(), readPreference);
    }

    @Override
    public void createRevisionForFile(int cloudId, String cloudName, File intermediateUploadPath, BackUpImage backUpImage, long fileSize) throws IOException {
        this.createParentsAndSaveEntry(cloudId, cloudName, backUpImage);
        DiskSpaceHelper.updateCloudSize((String)cloudName, (int)2, (long)fileSize);
        String path = PCHelperConstant.getPropertyFileValueParabluBackupFolderBasePath((String)cloudName) + backUpImage.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getfSPath();
        File backupFile = new File(path);
        File parentFolderInOriginalCompleteUploadFolder = backupFile.getParentFile();
        if (!parentFolderInOriginalCompleteUploadFolder.exists()) {
            parentFolderInOriginalCompleteUploadFolder.mkdirs();
        }
        FileUtils.moveFile((File)intermediateUploadPath, (File)backupFile);
    }

    @Override
    public ObjectId createRevisionForExternalBackupFile(int cloudId, String cloudName, File intermediateUploadPath, BackUpImage backUpImage, long fileSize) throws IOException {
        ObjectId id = this.createParentsAndSaveEntryForExternalBackup(cloudId, cloudName, backUpImage);
        DiskSpaceHelper.updateCloudSize((String)cloudName, (int)2, (long)fileSize);
        return id;
    }

    public ObjectId createParentsAndSaveEntryForExternalBackup(int cloudId, String cloudName, BackUpImage backUpImage) {
        List<BackupElement> fileElementList;
        BackUpImage parentBackUpImage = this.getParentFile(cloudId, cloudName, backUpImage);
        Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, cloudName, backUpImage.getDeviceUUID());
        if (!(parentBackUpImage != null && parentBackUpImage.isPresent() || (fileElementList = this.getParentfolders(cloudId, cloudName, backUpImage.getDevicePath(), backUpImage.getDeviceUUID())) == null || fileElementList.isEmpty())) {
            this.createParentFolders(cloudId, cloudName, fileElementList, device);
        }
        backUpImage.setExternalStorage(true);
        this.backUpImageDao.saveImageToBackUpDao(cloudId, cloudName, backUpImage, device);
        return backUpImage.getId();
    }

    @Override
    public DownloadTO restoreFileForExternalStorage(int cloudId, String cloudName, String fileName, String folderPath1, Device device, String accessToken) {
        BackUpImage backUpImage;
        String folderPath = folderPath1;
        File file = null;
        BufferedInputStream inputStream = null;
        long fileSize = 0L;
        String fileMD5 = null;
        this.logger.debug(" @@@@@ Folder path for external Storage " + folderPath);
        folderPath = PathConversionHelper.getServerCompatiblePath((String)folderPath, (boolean)false);
        ExternalStorageFileImage externalStorageFileImage = this.externalStorageFileImageDao.getExternalStorageFileImage(cloudId, cloudName, folderPath, fileName, device.getId());
        if (externalStorageFileImage == null) {
            throw new ParacloudBackupException(FILE_NOT_FOUND + folderPath, 507);
        }
        boolean readPreference = false;
        if (PCHelperConstant.isReadPreferenceFromSecondary()) {
            this.logger.debug(" Readpreference to Secondary restoreFileForExternalStorage .......");
            readPreference = true;
        }
        if ((backUpImage = this.backUpImageDao.getBackUpImageForFile(cloudId, cloudName, fileName, folderPath, device.getDeviceUUID(), readPreference)) != null) {
            String completeServerPath = PCHelperConstant.getPropertyFileValueParabluBackupFolderBasePath((String)cloudName) + device.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getfSPath();
            fileMD5 = backUpImage.getMd5Checksum();
            file = new File(completeServerPath);
        }
        inputStream = this.getInputStreamFromExternalStorage(accessToken, inputStream, externalStorageFileImage);
        File decryptedFile = this.getDecryptedFile(cloudName, device, file, inputStream);
        String mimeType = new MimetypesFileTypeMap().getContentType(file);
        BufferedInputStream decryptedStream = null;
        if (file != null) {
            fileSize = file.length();
            try {
                decryptedStream = new BufferedInputStream(new FileInputStream(decryptedFile), 1024);
            }
            catch (FileNotFoundException e) {
                this.logger.trace(" Unable to get decrypt file stream " + e);
                this.logger.error(" Unable to get decrypt file stream " + file.getName(), (Throwable)e);
            }
        } else {
            this.logger.debug("The file is not exist");
        }
        DownloadTO downloadTO = new DownloadTO(mimeType, decryptedStream, fileSize, fileMD5);
        ArrayList<Object> downloadReturnList = new ArrayList<Object>();
        downloadReturnList.add(decryptedStream);
        downloadReturnList.add(mimeType);
        downloadReturnList.add(String.valueOf(fileSize));
        downloadReturnList.add(fileMD5);
        return downloadTO;
    }

    private File getDecryptedFile(String cloudName, Device device, File file, BufferedInputStream inputStream) {
        String path = PCHelperConstant.getPropertyFileValueParabluBackupFolderBasePath((String)cloudName) + device.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File decryptedDir = new File(path + "decrypted");
        if (!decryptedDir.exists()) {
            decryptedDir.mkdir();
        }
        return new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + file.getName());
    }

    private BufferedInputStream getInputStreamFromExternalStorage(String accessToken, BufferedInputStream inputStream1, ExternalStorageFileImage externalStorageFileImage) {
        BufferedInputStream inputStream = inputStream1;
        try {
            inputStream = !accessToken.isEmpty() ? new BufferedInputStream(this.downloadFile(externalStorageFileImage.getFileSource(), accessToken)) : new BufferedInputStream(new URL(externalStorageFileImage.getFileSource()).openStream(), 1024);
        }
        catch (Exception ex) {
            this.logger.trace(EXCEPTION + ex);
            this.logger.error(EXCEPTION + ex.getMessage());
            throw new ParacloudBackupException("Error trying to Open file " + ex.getMessage(), 507);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private InputStream downloadFile(String source, String accessToken) {
        InputStream inputStream;
        Throwable throwable;
        DefaultHttpClient httpclient;
        HttpGet get;
        CloseableHttpResponse response;
        block16: {
            block17: {
                response = null;
                get = null;
                httpclient = new DefaultHttpClient();
                throwable = null;
                get = new HttpGet(source);
                get.addHeader("Authorization", "Bearer " + accessToken);
                response = httpclient.execute((HttpUriRequest)get);
                HttpEntity entity = response.getEntity();
                httpclient.close();
                inputStream = entity.getContent();
                if (httpclient == null) break block16;
                if (throwable == null) break block17;
                try {
                    httpclient.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block16;
            }
            httpclient.close();
        }
        get.releaseConnection();
        this.closeResponse(response);
        return inputStream;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (httpclient != null) {
                                if (throwable != null) {
                                    try {
                                        httpclient.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    httpclient.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (IOException e) {
                        this.logger.trace(" Download File file " + e);
                        this.logger.error(" Download File file " + e.getMessage());
                        throwable = null;
                        get.releaseConnection();
                        this.closeResponse(response);
                        return throwable;
                    }
                }
                catch (Throwable throwable6) {
                    get.releaseConnection();
                    this.closeResponse(response);
                    throw throwable6;
                }
            }
        }
    }

    private void closeResponse(CloseableHttpResponse result) {
        if (result != null) {
            try {
                result.close();
            }
            catch (IOException e) {
                this.logger.error("error in closing http client:" + e.getMessage());
            }
        }
    }

    @Override
    public DownloadTO restoreFile(int cloudId, String cloudName, String fileName, String folderPath1, Device device) {
        BackUpImage backUpImage;
        String folderPath = folderPath1;
        InputStream inputStream = null;
        folderPath = PathConversionHelper.getServerCompatiblePath((String)folderPath, (boolean)false);
        boolean readPreference = false;
        if (PCHelperConstant.isReadPreferenceFromSecondary()) {
            this.logger.debug(" Readpreference to Secondary restoreFile .......");
            readPreference = true;
        }
        if ((backUpImage = this.backUpImageDao.getBackUpImageForFile(cloudId, cloudName, fileName, folderPath, device.getDeviceUUID(), readPreference)) == null) {
            throw new ParacloudBackupException(FILE_NOT_FOUND, 507);
        }
        boolean isFilePresent = backUpImage.isPresent();
        String fileMD5 = backUpImage.getMd5Checksum();
        String completeServerPath = PCHelperConstant.getPropertyFileValueParabluBackupFolderBasePath((String)cloudName) + device.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getfSPath();
        File file = new File(completeServerPath);
        if (!file.exists() || !isFilePresent) {
            throw new ParacloudBackupException(FILE_NOT_FOUND, 507);
        }
        String mimeType = new MimetypesFileTypeMap().getContentType(file);
        long fileSize = file.length();
        DownloadTO downloadTO = new DownloadTO(mimeType, inputStream, fileSize, fileMD5);
        ArrayList<Object> downloadReturnList = new ArrayList<Object>();
        downloadReturnList.add(inputStream);
        downloadReturnList.add(mimeType);
        downloadReturnList.add(String.valueOf(fileSize));
        downloadReturnList.add(fileMD5);
        return downloadTO;
    }

    @Override
    public void saveBatchEntry(int cloudId, String cloudName, List<BackUpImage> backUpImages, String deviceDest) {
        this.logger.debug(" Delay time  added ......... " + PCHelperConstant.getPGWriteDelayTime() + " for number of files ... " + backUpImages.size());
        this.backUpImageDao.saveBackupImageInBatch(cloudId, backUpImages, deviceDest);
    }

    @Override
    public void createParentFolders(int cloudId, String cloudName, List<BackupElement> fileElementList, Device device) {
        for (BackupElement fileElement : fileElementList) {
            BackUpImage oldBckupImage;
            if (fileElement.getFileCompletePath() == null) {
                oldBckupImage = this.backUpImageDao.getBackUpImageForFileWithNullPath(cloudId, cloudName, fileElement.getFileName(), device.getDeviceUUID());
            } else {
                boolean readPreference = false;
                if (PCHelperConstant.isReadPreferenceFromSecondary()) {
                    readPreference = true;
                }
                oldBckupImage = this.backUpImageDao.getBackUpImageForFile(cloudId, cloudName, fileElement.getFileName(), fileElement.getFileCompletePath(), device.getDeviceUUID(), readPreference);
            }
            if (oldBckupImage != null && oldBckupImage.isPresent()) continue;
            BackUpImage backUpImage = new BackUpImage();
            ObjectConversionHelper.convertToBackUpImage(fileElement, device.getDeviceUUID(), backUpImage, device, false, PathGenerator.getFsPath((String)fileElement.getMd5Checksum()), PCHelperConstant.REVISION_STATUS.ADDED.toString());
            this.backUpImageDao.saveImageToBackUpDao(cloudId, cloudName, backUpImage, device);
        }
    }

    @Override
    public BackupRequestTO checkIfBaseFolderExists(int cloudId, String cloudName, Device device, BackupElement fileElement) {
        fileElement.setFileCompletePath(PathConversionHelper.getServerCompatiblePath((String)fileElement.getFileCompletePath(), (boolean)false));
        BackUpImage backUpImage = this.getBackUpImage(cloudId, cloudName, fileElement.getFileName(), fileElement.getFileCompletePath(), device.getDeviceUUID());
        if (backUpImage == null || !backUpImage.isPresent()) {
            List<BackupElement> fileElementList = this.getParentfolders(cloudId, cloudName, fileElement.getFileCompletePath(), device.getDeviceUUID());
            if (fileElementList != null) {
                this.createParentFolders(cloudId, cloudName, fileElementList, device);
            }
            backUpImage = new BackUpImage();
            BackUpImageUQ backUpImageUQ = new BackUpImageUQ();
            backUpImageUQ.setDevice(device);
            String devicePath = fileElement.getFileCompletePath();
            if (devicePath.endsWith(PATH_SEPARATOR)) {
                devicePath = devicePath.substring(0, devicePath.lastIndexOf(47));
            }
            backUpImageUQ.setDevicePath(devicePath);
            backUpImageUQ.setFileName(fileElement.getFileName());
            backUpImage.setBaseBackup(true);
            backUpImage.setFolder(true);
            backUpImage.setStatus(PCHelperConstant.REVISION_STATUS.ADDED.toString());
            backUpImage.setLastClientModifiedTime(fileElement.getLastClientModifiedTime());
            backUpImage.setLastServerModifiedTime(System.currentTimeMillis());
            backUpImage.setMd5Checksum(fileElement.getMd5Checksum());
            backUpImage.setSize(fileElement.getSize());
            backUpImage.setPresent(true);
            backUpImage.setUserName(device.getUserName());
            this.createParentsAndSaveEntry(cloudId, cloudName, backUpImage);
            return new BackupRequestTO(ObjectConversionHelper.convertBackUpImageToBackupElement(backUpImage, !device.getOsType().toLowerCase().contains(WINDOWS_OS)), false);
        }
        if (!backUpImage.isBaseBackup()) {
            backUpImage.setBaseBackup(true);
            backUpImage.setUserName(device.getUserName());
            this.createParentsAndSaveEntry(cloudId, cloudName, backUpImage);
            return new BackupRequestTO(ObjectConversionHelper.convertBackUpImageToBackupElement(backUpImage, !device.getOsType().toLowerCase().contains(WINDOWS_OS)), false);
        }
        return new BackupRequestTO(ObjectConversionHelper.convertBackUpImageToBackupElement(backUpImage, !device.getOsType().toLowerCase().contains(WINDOWS_OS)), true);
    }

    private List<BackupElement> getParentfolders(int cloudId, String cloudName, String parentFilePath1, String deviceUUID) {
        BackUpImage backUpImage;
        String fileName;
        Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, cloudName, deviceUUID);
        String parentFilePath = parentFilePath1;
        ArrayList<BackupElement> elements = new ArrayList<BackupElement>();
        BackupElement fileElement = new BackupElement();
        if (parentFilePath == null) {
            return null;
        }
        int lastIndex = parentFilePath.lastIndexOf(47);
        if (lastIndex == -1 && "".equals(parentFilePath)) {
            return null;
        }
        if (parentFilePath.endsWith(PATH_SEPARATOR)) {
            parentFilePath = parentFilePath.substring(0, lastIndex);
            lastIndex = parentFilePath.lastIndexOf(47);
            fileName = parentFilePath;
        } else {
            fileName = parentFilePath.substring(lastIndex + 1);
        }
        String filePath = null;
        if (lastIndex != -1) {
            filePath = parentFilePath.substring(0, parentFilePath.length() - fileName.length() - 1);
        }
        if ((backUpImage = this.getBackUpImage(cloudId, cloudName, fileName, filePath, device.getDeviceUUID())) != null && backUpImage.isPresent()) {
            return null;
        }
        fileElement.setFileName(fileName);
        fileElement.setFolder(true);
        if (filePath != null && filePath.isEmpty()) {
            filePath = "ROOT";
        }
        fileElement.setFileCompletePath(filePath);
        fileElement.setMd5Checksum("null");
        fileElement.setPresent(true);
        fileElement.setSize(0L);
        elements.add(fileElement);
        List<BackupElement> elements2 = this.getParentfolders(cloudId, cloudName, fileElement.getFileCompletePath(), device.getDeviceUUID());
        if (elements2 != null) {
            elements.addAll(elements2);
        }
        return elements;
    }

    @Override
    public FileListElement getLatestFileList(int cloudId, String cloudName, Device device, boolean isExternalStorage) {
        int externalStorage = 0;
        if (isExternalStorage) {
            externalStorage = 1;
        }
        List backUpImages = this.backUpImageDao.getLatestFiles(cloudId, cloudName, device.getId(), externalStorage);
        return this.getFileListElement(device, backUpImages);
    }

    private FileListElement getFileListElement(Device device, List<BackUpImage> backUpImages) {
        FileListElement fileListElement = new FileListElement();
        List<FileElement> fileElements = ObjectConversionHelper.convertBackUpImageListToFileElementList(backUpImages, !device.getOsType().toLowerCase().contains(WINDOWS_OS), true);
        fileListElement.setFileElementList(fileElements);
        return fileListElement;
    }

    @Override
    public FileListElement getBaseFolders(int cloudId, String cloudName, Device device, boolean backupIdEnabled) {
        FileListElement fileListElement = new FileListElement();
        List baseBackUpImages = this.backUpImageDao.getBaseFolders(cloudId, cloudName, device.getId());
        List<FileElement> fileElements = ObjectConversionHelper.convertBackUpImageListToFileElementList(baseBackUpImages, !device.getOsType().toLowerCase().contains(WINDOWS_OS), backupIdEnabled);
        fileListElement.setFileElementList(fileElements);
        return fileListElement;
    }

    @Override
    public FileListElement getBackedUpFolders(int cloudId, String cloudName, Device device) {
        FileListElement fileListElement = new FileListElement();
        List baseBackUpImages = this.backUpImageDao.getBackedUpFolders(cloudId, cloudName, device.getId());
        this.logger.debug(device.getId() + " ^^^^^^^^^^^^^^^^^ " + baseBackUpImages.isEmpty());
        if (!baseBackUpImages.isEmpty()) {
            this.logger.debug(" ^^********************************************^^^^^^^^^^^^^^^ " + baseBackUpImages.size());
        }
        List<FileElement> fileElements = ObjectConversionHelper.convertBackUpImageListToFileElementList(baseBackUpImages, !device.getOsType().toLowerCase().contains(WINDOWS_OS), false);
        fileListElement.setFileElementList(fileElements);
        return fileListElement;
    }

    @Override
    public List<DeviceElement> getAllBackedUpDevice(int cloudId, String cloudName) {
        List devices = this.deviceDao.getAllDevices(cloudId);
        ArrayList<DeviceElement> deviceElements = new ArrayList<DeviceElement>();
        this.logger.debug(" ^^************");
        for (Device device : devices) {
            DeviceElement deviceElement = new DeviceElement();
            BeanUtils.copyProperties((Object)device, (Object)deviceElement);
            deviceElement.setDeviceId(device.getId().toString());
            deviceElement.setUserName(device.getUserName());
            this.logger.debug(" ^^************************ " + device.isCanAdminRestore());
            this.logger.debug(" ^^************************ " + deviceElement.isCanAdminRestore());
            deviceElements.add(deviceElement);
        }
        return deviceElements;
    }

    private BackUpImage getParentFile(int cloudId, String cloudName, BackUpImage childBackUpImage) {
        String fileName;
        String parentFilePath = childBackUpImage.getDevicePath();
        if (parentFilePath == null) {
            return null;
        }
        int lastIndex = parentFilePath.lastIndexOf(47);
        if (lastIndex == -1 && "".equals(parentFilePath)) {
            return null;
        }
        if (parentFilePath.endsWith(PATH_SEPARATOR)) {
            parentFilePath = parentFilePath.substring(0, lastIndex);
            lastIndex = parentFilePath.lastIndexOf(47);
            fileName = parentFilePath;
        } else {
            fileName = parentFilePath.substring(lastIndex + 1);
        }
        String filePath = null;
        if (lastIndex != -1) {
            filePath = parentFilePath.substring(0, parentFilePath.length() - fileName.length() - 1);
        }
        return this.getBackUpImage(cloudId, cloudName, fileName, filePath, childBackUpImage.getDeviceUUID());
    }

    @Override
    public List<BackUpImage> getAllFilesForDeviceId(int cloudId, String cloudName, ObjectId deviceId) {
        return this.backUpImageDao.getAllFilesForDeviceId(cloudId, cloudName, deviceId);
    }

    @Override
    public List<BackUpImage> getAllFilesForExternalStorageUpload(int cloudId, String cloudName, ObjectId deviceId) {
        List backupIdList = this.externalStorageFileImageDao.getBackupIdForExternalStorageFileImages(cloudId, cloudName, deviceId);
        return this.backUpImageDao.getAllFilesForExternalStorageUpload(cloudId, cloudName, deviceId, backupIdList);
    }

    @Override
    public FileListElement getLatestFileList(int cloudId, String cloudName, Device device, String path, String fileName, boolean isExternalStorage) {
        String folderPath = PathConversionHelper.getServerCompatiblePath((String)path, (boolean)false);
        List backUpImages = this.backUpImageDao.getLatestFiles(cloudId, cloudName, device.getId(), folderPath, fileName, isExternalStorage);
        return this.getFileListElement(device, backUpImages);
    }

    @Override
    public void deleteBackupFile(int cloudId, String cloudName, ObjectId backupId) {
        this.backUpImageDao.deleteBackupFile(cloudId, cloudName, backupId);
    }

    @Override
    public ObjectId getBackupIDForDedupifiedFile(int cloudId, String cloudName, String userName, String md5checksum) {
        return this.backUpImageDao.getBackupIDForDedupifiedFile(cloudId, cloudName, userName, md5checksum);
    }

    @Override
    public BackUpImage getBackupImageForDeviceUUID(int cloudId, String cloudName, String fileName, String devicePath, String deviceUUID) {
        return this.backUpImageDao.getBackupImageForDeviceUUID(cloudId, cloudName, fileName, devicePath, deviceUUID);
    }

    @Override
    public void saveBackupStatistics(int cloudId, String cloudName, BackUpImageStatistics imageStatistics) {
        this.backUpImageDao.saveBackupStatistics(cloudId, cloudName, imageStatistics);
    }

    @Override
    public void deleteStatisticsForUser(int cloudId, String cloudName, String userName) {
        this.backUpImageDao.deleteStatisticsForUser(cloudId, cloudName, userName);
    }

    @Override
    public List<StatisticsElement> getStatistics(int cloudId, String cloudName, String userName, String deviceName) {
        List objects = this.backUpImageDao.getStatisticsForBackup(cloudId, cloudName, userName, deviceName);
        ArrayList<StatisticsElement> list = new ArrayList<StatisticsElement>();
        for (Object[] object : objects) {
            StatisticsElement statisticsElement = new StatisticsElement();
            statisticsElement.setUserName((String)object[0]);
            statisticsElement.setFileExtension((String)object[1]);
            statisticsElement.setDeviceName((String)object[3]);
            Long sizeLong = (Long)object[2];
            statisticsElement.setSize(BackupServiceImpl.formatFileSize(sizeLong));
            statisticsElement.setNoOfFiles(((Integer)object[4]).toString());
            list.add(statisticsElement);
        }
        return list;
    }

    @Override
    public void updateODBstatusOfFile(int cloudId, String cloudName, ObjectId backupId, String storagePlace) {
        this.backUpImageDao.updateAzureFileStatusinBackupImageTable(cloudId, cloudName, backupId, storagePlace);
    }

    public static String formatFileSize(long size) {
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : dec.format(m).concat(" MB"));
        return hrSize;
    }

    @Override
    public void saveBackupFileInfo(int cloudId, String cloudName, String userName, BackupFile backupFile) {
        this.externalStorageBackupFileDao.saveBackupFileInfo(cloudId, cloudName, userName, backupFile);
    }

    @Override
    public BackupFile getBackupFile(int cloudId, String cloudName, String userName, String id) {
        return this.externalStorageBackupFileDao.getBackupFile(cloudId, cloudName, userName, id);
    }

    @Override
    public void savePGInfo(int cloudId, String tableName, PGInfoElement pgInfoElement) {
        this.pgInfoDao.savePGInfo(cloudId, tableName, pgInfoElement);
    }

    @Override
    public void deleteRevision(int cloudId, String cloudName, BackUpImage backUpImage) {
        this.backUpImageDao.deleteRevision(cloudId, cloudName, backUpImage);
    }

    @Override
    public void checkAllowedRevisionsAndChange(int cloudId, String cloudName, BackUpImage backUpImage, int maxVersionsToKeep, Device device) {
        int currentNoOfVersions;
        boolean readPreference = false;
        if (PCHelperConstant.isReadPreferenceFromSecondary()) {
            readPreference = true;
        }
        List backUpImages = this.backUpImageDao.getVersions(cloudId, cloudName, backUpImage.getFileName(), backUpImage.getDevicePath(), device, readPreference);
        this.logger.debug("maxVersionsToKeep..................." + maxVersionsToKeep + "current no of versions........" + currentNoOfVersions);
        if (maxVersionsToKeep <= currentNoOfVersions && maxVersionsToKeep != 0) {
            for (currentNoOfVersions = backUpImages.size(); currentNoOfVersions >= maxVersionsToKeep; --currentNoOfVersions) {
                this.logger.debug("deleting version..................." + (currentNoOfVersions - 1));
                BackUpImage toDeleteBackupImage = (BackUpImage)backUpImages.get(currentNoOfVersions - 1);
                this.backUpImageDao.deleteRevision(cloudId, cloudName, toDeleteBackupImage);
            }
        }
    }

    @Override
    public long getStorageUtilizedAfterRevisionChange(int cloudId, String cloudName, BackUpImage backUpImage, int maxVersionsToKeep, Device device) {
        long storageUtilized = backUpImage.getSize();
        boolean readPreference = false;
        if (PCHelperConstant.isReadPreferenceFromSecondary()) {
            readPreference = true;
        }
        List backUpImages = this.backUpImageDao.getVersions(cloudId, cloudName, backUpImage.getFileName(), backUpImage.getDevicePath(), device, readPreference);
        int currentNoOfVersions = backUpImages.size();
        this.logger.debug("maxVersionsToKeep..................." + maxVersionsToKeep + "current no of versions........" + currentNoOfVersions);
        if (maxVersionsToKeep <= currentNoOfVersions && maxVersionsToKeep != 0) {
            while (currentNoOfVersions >= maxVersionsToKeep) {
                this.logger.debug("deleting version..................." + (currentNoOfVersions - 1));
                BackUpImage toDeleteBackupImage = (BackUpImage)backUpImages.get(currentNoOfVersions - 1);
                this.backUpImageDao.deleteRevision(cloudId, cloudName, toDeleteBackupImage);
                --currentNoOfVersions;
                storageUtilized -= toDeleteBackupImage.getSize();
            }
        }
        return storageUtilized;
    }

    @Override
    public List<KeyValueElement> getBackupImageForDedupifiedFiles(int cloudId, String cloudName, String userName, List<String> md5checksums) {
        return this.backUpImageDao.getBackupImageForDedupifiedFiles(cloudId, cloudName, userName, md5checksums);
    }

    @Override
    public long getStorageUsedByUser(int cloudId, String userName) {
        return this.backUpImageDao.getStorageUsedByUser(cloudId, userName);
    }

    @Override
    public void deleteBackupFiles(int cloudId, String cloudName, String userName, String backupId, String dedupedBkId) {
        try {
            this.backUpImageDao.deleteBackupFile(cloudId, cloudName, new ObjectId(backupId));
        }
        catch (Exception e) {
            this.logger.trace(EXCEPTION + e);
            this.logger.error(EXCEPTION + e.getMessage());
        }
        try {
            this.backUpImageDao.deleteBackupFile(cloudId, cloudName, new ObjectId(dedupedBkId));
        }
        catch (Exception e) {
            this.logger.trace(EXCEPTION + e);
            this.logger.error(EXCEPTION + e.getMessage());
        }
        try {
            this.externalStorageBackupFileDao.deleteBackupFile(cloudId, cloudName, userName, backupId);
        }
        catch (Exception e) {
            this.logger.trace(EXCEPTION + e);
            this.logger.error(EXCEPTION + e.getMessage());
        }
        try {
            this.externalStorageBackupFileDao.deleteBackupFile(cloudId, cloudName, userName, dedupedBkId);
        }
        catch (Exception e) {
            this.logger.trace(EXCEPTION + e);
            this.logger.error(EXCEPTION + e.getMessage());
        }
    }

    @Override
    public List<BackupElement> getChildrenForAgent(int cloudId, String cloudName, String folderPath, Device device, boolean isExternalStorage, String serverModifiedTime, boolean restoreDeletedFiles) {
        List backUpImages;
        ArrayList<BackupElement> backupElements = new ArrayList<BackupElement>();
        List rwlist = this.backupBatchDao.getRWSampleFilesList(1);
        if (folderPath == null || "".equals(folderPath)) {
            this.logger.debug("..inside device...");
            backUpImages = !StringUtils.isEmpty((String)serverModifiedTime) ? this.backUpImageDao.getBaseChildrenByDeviceandTimeStamp(cloudId, cloudName, device, serverModifiedTime) : this.backUpImageDao.getBaseChildrenByDevice(cloudId, cloudName, device, true);
        } else {
            this.logger.debug("..inside folderpath..." + serverModifiedTime);
            backUpImages = !StringUtils.isEmpty((String)serverModifiedTime) ? this.backUpImageDao.getRestBackupFilesForGivenPathfromBackupImage(cloudId, cloudName, folderPath, device, isExternalStorage, serverModifiedTime, restoreDeletedFiles) : this.backUpImageDao.getChildrenByFolderForAgent(cloudId, cloudName, folderPath, device, isExternalStorage, restoreDeletedFiles);
        }
        if (backUpImages == null || backUpImages.isEmpty()) {
            this.logger.debug("NO FILES FOR PATH ...." + folderPath + " device UUID " + device.getDeviceUUID());
            return null;
        }
        this.logger.debug("backup images from DB: " + backUpImages.size());
        for (BackUpImage b : backUpImages) {
            boolean isFileSame;
            if (b != null && b.getFileName() != null && (isFileSame = this.checkMd5(1, b.getFileName(), rwlist))) {
                this.logger.debug("md5/file name is same so skip the file...........");
                continue;
            }
            if (b == null || !b.isFolder() && StringUtils.isEmpty((String)b.getGatewayName()) && StringUtils.isEmpty((String)b.getStoragePlace())) {
                this.logger.debug("old files in pg cannot restore............");
            }
            if (b == null || !b.isFolder() && b.isPresent() && StringUtils.isEmpty((String)b.getGatewayName()) && StringUtils.isEmpty((String)b.getStoragePlace())) continue;
            BackupElement backupElement = new BackupElement();
            BeanUtils.copyProperties((Object)b, (Object)backupElement);
            if (!b.isFolder() && b.getSize() == 0L && b.getSizeInBytes() > 0L) {
                long filesizeInKB = (long)Math.ceil(b.getSizeInBytes() / 1024L);
                if (filesizeInKB <= 0L) {
                    filesizeInKB = 1L;
                }
                backupElement.setSize(filesizeInKB);
            }
            backupElement.setFileCompletePath(b.getDevicePath());
            String mailExt = "";
            if (!b.isFolder() && !StringUtils.isEmpty((String)b.getSubject())) {
                mailExt = ".eml";
            }
            backupElement.setFileName(b.getFileName() + mailExt);
            backupElement.setFileUserOwner(b.getUserName());
            ArrayList chunks = new ArrayList();
            backupElement.setChunkFiles(new ArrayList());
            backupElement.getChunkFiles().addAll(chunks);
            String extension = FilenameUtils.getExtension((String)b.getFileName());
            if (FileTypeHelper.isImageFile((String)extension) || FileTypeHelper.isVideoFile((String)extension)) {
                backupElement.setThumbnailPath("/t/backup" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + b.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + b.getfSPath());
            }
            backupElement.setBackupId(b.getId().toString());
            backupElement.setGatewayName(b.getGatewayName());
            backupElements.add(backupElement);
        }
        return backupElements;
    }

    public static String generateMD5OfString(String convertTo) {
        return new String(Hex.encodeHex((byte[])DigestUtils.md5((String)convertTo)));
    }

    @Override
    public List<ChunkFile> getChunkFileNamesForId(int cloudId, String cloudName, String userName, String backupId) {
        return this.backUpImageDao.getChunkFileNamesForId(cloudId, cloudName, userName, backupId);
    }

    @Override
    public Device getDeviceById(int cloudId, ObjectId deviceId) {
        return this.deviceDao.getDeviceById(cloudId, deviceId);
    }

    @Override
    public List<BackupElement> getChildrenForContainer(int cloudId, String cloudName, ObjectId deviceId, String containerName) {
        this.logger.debug("List<BackupElement> getChildrenForContainer > BEGIN > containerName " + containerName);
        Device device = this.deviceDao.getDeviceById(cloudId, deviceId);
        List backUpImages = this.backUpImageDao.getContainerChildren(cloudId, containerName, device);
        List<BackupElement> backupElements = this.getBackupElementsFromBackupImg(backUpImages);
        this.logger.debug("List<BackupElement> getChildrenForContainer > BEFORE RETURN > backupElements.size() " + backupElements.size());
        return backupElements;
    }

    private List<BackupElement> getBackupElementsFromBackupImg(List<BackUpImage> backUpImages) {
        ArrayList<BackupElement> backupElements = new ArrayList<BackupElement>();
        List rwlist = this.backupBatchDao.getRWSampleFilesList(1);
        for (BackUpImage b : backUpImages) {
            boolean isFileSame;
            if (b != null && b.getFileName() != null && (isFileSame = this.checkMd5(1, b.getFileName(), rwlist))) {
                this.logger.debug("md5/file name is same so skip the file...........");
                continue;
            }
            BackupElement backupElement = new BackupElement();
            BeanUtils.copyProperties((Object)b, (Object)backupElement);
            if (!b.isFolder() && b.getSize() == 0L && b.getSizeInBytes() > 0L) {
                long filesizeInKB = (long)Math.ceil(b.getSizeInBytes() / 1024L);
                if (filesizeInKB <= 0L) {
                    filesizeInKB = 1L;
                }
                backupElement.setSize(filesizeInKB);
            }
            backupElement.setFileCompletePath(b.getDevicePath());
            backupElement.setFileName(b.getFileName());
            backupElement.setFileUserOwner(b.getUserName());
            ArrayList<ChunkFileInfoElement> chunks = new ArrayList<ChunkFileInfoElement>();
            for (ChunkFile chunkFile : b.getChunkFiles()) {
                ChunkFileInfoElement file = new ChunkFileInfoElement();
                BeanUtils.copyProperties((Object)chunkFile, (Object)file);
                chunks.add(file);
            }
            backupElement.setChunkFiles(new ArrayList());
            backupElement.getChunkFiles().addAll(chunks);
            String extension = FilenameUtils.getExtension((String)b.getFileName());
            if (FileTypeHelper.isImageFile((String)extension) || FileTypeHelper.isVideoFile((String)extension)) {
                backupElement.setThumbnailPath("/t/backup" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + b.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + b.getfSPath());
            }
            backupElement.setBackupId(b.getId().toString());
            backupElements.add(backupElement);
        }
        return backupElements;
    }

    private List<MailElement> getMailElementsFromBackupImg(List<BackUpImage> backUpImages) {
        ArrayList<MailElement> backupElements = new ArrayList<MailElement>();
        for (BackUpImage b : backUpImages) {
            MailElement mailElement = new MailElement();
            BeanUtils.copyProperties((Object)b, (Object)mailElement);
            String body = "";
            try {
                if (!StringUtils.isEmpty((String)b.getBodyContent())) {
                    body = b.getBodyContent().substring(0, 10);
                }
            }
            catch (Exception e) {
                this.logger.error("..unable to get first 10 char...");
            }
            mailElement.setBodyContent(body);
            mailElement.setBackupId(b.getId().toString());
            mailElement.setDeviceUUID(b.getDeviceUUID());
            mailElement.setHasAttachments(b.isHasAttachments());
            ArrayList listAttached = new ArrayList();
            if (mailElement.isHasAttachments()) {
                // empty if block
            }
            mailElement.setAttachments(listAttached);
            try {
                if (b.getSentDate() != null) {
                    SimpleDateFormat df2 = new SimpleDateFormat(MM_DD_YYYY);
                    if (DateUtils.isSameDay((Date)new Date(), (Date)b.getSentDate())) {
                        df2 = new SimpleDateFormat("HH:mm");
                    }
                    mailElement.setSentDate(df2.format(b.getSentDate()));
                }
            }
            catch (Exception e) {
                this.logger.error("...trying to set date..." + b.getSentDate());
            }
            backupElements.add(mailElement);
        }
        return backupElements;
    }

    @Override
    public List<BackupActivityHistoryElement> getAllBackupBatchForDeviceWthPagination(int cloudId, String cloudName, String userName, String deviceUUID, int pageNo) {
        List backupBatchList = this.backupBatchDao.getAllBackupBatchForDeviceWithPagination(cloudId, cloudName, userName, deviceUUID, pageNo);
        return this.getBackupBatchElements(backupBatchList);
    }

    @Override
    public List<BackupActivityHistoryElement> getAllBackupBatchWthPagination(Cloud cloud, String cloudName, int pageNo, ReportQueryElement reportQueryElement, boolean isPagination) {
        ArrayList<BackupBatch> backupBatchList = new ArrayList();
        long startDate = 0L;
        long endDate = 0L;
        List<Object> userNames = new ArrayList();
        if (StringUtils.isNotEmpty((String)reportQueryElement.getStartDate()) && StringUtils.isNotEmpty((String)reportQueryElement.getEndDate())) {
            startDate = this.getStartOfDay(reportQueryElement.getStartDate());
            endDate = this.getEndOfDay(reportQueryElement.getEndDate());
        }
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            String productType = "backup";
            List userList = this.userDao.getAllUsersByPolicyNames(cloud.getCloudId(), reportQueryElement.getPolicyNames(), productType);
            if (!CollectionUtils.isEmpty((Collection)userList)) {
                userNames = userList.stream().filter(existingUser -> Objects.nonNull(existingUser.getUserName())).map(existingUser -> existingUser.getUserName()).collect(Collectors.toList());
                backupBatchList.addAll(this.backupBatchDao.getAllBackupBatchWithPagination(cloud.getCloudId(), cloudName, userNames, pageNo, reportQueryElement.getReason(), isPagination, startDate, endDate));
            }
        } else {
            backupBatchList = this.backupBatchDao.getAllBackupBatchWithPagination(cloud.getCloudId(), cloudName, null, pageNo, reportQueryElement.getReason(), isPagination, startDate, endDate);
        }
        return this.getBackupBatchElementsForIncompleteBkp(backupBatchList);
    }

    @Override
    public int getCountAllBackupBatchWthPagination(Cloud cloud, String cloudName, int pageNo, ReportQueryElement reportQueryElement) {
        List backupBatchList = new ArrayList();
        long startDate = 0L;
        long endDate = 0L;
        List<Object> userNames = new ArrayList();
        if (StringUtils.isNotEmpty((String)reportQueryElement.getStartDate()) && StringUtils.isNotEmpty((String)reportQueryElement.getEndDate())) {
            startDate = this.getStartOfDay(reportQueryElement.getStartDate());
            endDate = this.getEndOfDay(reportQueryElement.getEndDate());
        }
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            String productType = "backup";
            List userList = this.userDao.getAllUsersByPolicyNames(cloud.getCloudId(), reportQueryElement.getPolicyNames(), productType);
            if (!CollectionUtils.isEmpty((Collection)userList)) {
                userNames = userList.stream().filter(existingUser -> Objects.nonNull(existingUser.getUserName())).map(existingUser -> existingUser.getUserName()).collect(Collectors.toList());
                backupBatchList.addAll(this.backupBatchDao.getAllBackupBatchWithPagination(cloud.getCloudId(), cloudName, userNames, pageNo, reportQueryElement.getReason(), false, startDate, endDate));
            }
        } else {
            backupBatchList = this.backupBatchDao.getAllBackupBatchWithPagination(cloud.getCloudId(), cloudName, null, pageNo, reportQueryElement.getReason(), false, startDate, endDate);
        }
        return backupBatchList.size();
    }

    @Override
    public List<BackupBatch> getAllBackupBatchWthoutPagination(Cloud cloud, String cloudName, int pageNo, ReportQueryElement reportQueryElement) {
        ArrayList<BackupBatch> backupBatchList = new ArrayList();
        long startDate = 0L;
        long endDate = 0L;
        List<Object> userNames = new ArrayList();
        if (StringUtils.isNotEmpty((String)reportQueryElement.getStartDate()) && StringUtils.isNotEmpty((String)reportQueryElement.getEndDate())) {
            startDate = this.getStartOfDay(reportQueryElement.getStartDate());
            endDate = this.getEndOfDay(reportQueryElement.getEndDate());
        }
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            String productType = "backup";
            List userList = this.userDao.getAllUsersByPolicyNames(cloud.getCloudId(), reportQueryElement.getPolicyNames(), productType);
            if (!CollectionUtils.isEmpty((Collection)userList)) {
                userNames = userList.stream().filter(existingUser -> Objects.nonNull(existingUser.getUserName())).map(existingUser -> existingUser.getUserName()).collect(Collectors.toList());
                backupBatchList.addAll(this.backupBatchDao.getAllBackupBatchWithPagination(cloud.getCloudId(), cloudName, userNames, pageNo, reportQueryElement.getReason(), false, startDate, endDate));
            }
        } else {
            backupBatchList = this.backupBatchDao.getAllBackupBatchWithPagination(cloud.getCloudId(), cloudName, null, pageNo, reportQueryElement.getReason(), false, startDate, endDate);
        }
        return backupBatchList;
    }

    private static boolean isODBBackupEnabled(List<CloudCustomisableDetails> list) {
        boolean isODBUserLevelAcctEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"OneDrive Backup Enabled".equals(customisableDetails.getName())) continue;
            isODBUserLevelAcctEnabled = true;
            break;
        }
        return isODBUserLevelAcctEnabled;
    }

    private static boolean isExchangeBackupEnabled(List<CloudCustomisableDetails> list) {
        boolean isExchangeBackupEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"Exchange Backup Enabled".equals(customisableDetails.getName())) continue;
            isExchangeBackupEnabled = true;
            break;
        }
        return isExchangeBackupEnabled;
    }

    @Override
    public List<BackupActivityHistoryElement> getAllBackupBatchForDevice(int cloudId, String cloudName, String userName, String deviceUUID) {
        List backupBatchList = this.backupBatchDao.getAllBackupBatchForDevice(cloudId, cloudName, userName, deviceUUID);
        return this.getBackupBatchElements(backupBatchList);
    }

    private List<BackupActivityHistoryElement> getBackupBatchElementsForIncompleteBkp(List<BackupBatch> backupBatchList) {
        ArrayList<BackupActivityHistoryElement> backupHistoryElements = new ArrayList<BackupActivityHistoryElement>();
        for (BackupBatch backupBatch : backupBatchList) {
            BackupActivityHistoryElement backupActivityHistoryElement = new BackupActivityHistoryElement();
            backupActivityHistoryElement.setDeviceName(backupBatch.getDeviceName());
            backupActivityHistoryElement.setUserName(backupBatch.getUserName());
            backupActivityHistoryElement.setStartTimeLong(backupBatch.getBatchStartTimestamp());
            backupActivityHistoryElement.setEndTimeLong(backupBatch.getBatchEndTimestamp());
            backupActivityHistoryElement.setStartTime(DateUtil.getDateInddMMMyyyy((long)backupBatch.getBatchStartTimestamp()));
            backupActivityHistoryElement.setEndTime(DateUtil.getDateInddMMMyyyy((long)backupBatch.getBatchEndTimestamp()));
            backupActivityHistoryElement.setStatus(backupBatch.getStatus());
            long totalFilesParsed = Long.parseLong(backupBatch.getTotalNoOfFiles());
            backupActivityHistoryElement.setTotalNumberOfFiles(totalFilesParsed);
            backupActivityHistoryElement.setFullBackup(backupBatch.isFullBackup());
            backupActivityHistoryElement.setBatchId(backupBatch.getId().toString());
            this.setNoOfFilesUploadedAndFailed(backupBatch, backupActivityHistoryElement);
            backupHistoryElements.add(backupActivityHistoryElement);
        }
        return backupHistoryElements;
    }

    private List<BackupActivityHistoryElement> getBackupBatchElements(List<BackupBatch> backupBatchList) {
        ArrayList<BackupActivityHistoryElement> backupHistoryElements = new ArrayList<BackupActivityHistoryElement>();
        for (BackupBatch backupBatch : backupBatchList) {
            BackupActivityHistoryElement backupActivityHistoryElement = new BackupActivityHistoryElement();
            backupActivityHistoryElement.setDeviceName(backupBatch.getDeviceName());
            backupActivityHistoryElement.setUserName(backupBatch.getUserName());
            backupActivityHistoryElement.setStartTimeLong(backupBatch.getBatchStartTimestamp());
            backupActivityHistoryElement.setEndTimeLong(backupBatch.getBatchEndTimestamp());
            backupActivityHistoryElement.setStartTime(DateUtil.getDateInddMMMyyyy((long)backupBatch.getBatchStartTimestamp()));
            backupActivityHistoryElement.setEndTime(DateUtil.getDateInddMMMyyyy((long)backupBatch.getBatchEndTimestamp()));
            backupActivityHistoryElement.setStatus(backupBatch.getStatus());
            long totalFilesParsed = Long.parseLong(backupBatch.getTotalNoOfFiles());
            backupActivityHistoryElement.setTotalNumberOfFiles(totalFilesParsed);
            backupActivityHistoryElement.setFullBackup(backupBatch.isFullBackup());
            backupActivityHistoryElement.setType(backupBatch.getJobType());
            List attempts = this.backupBatchDao.getAllBackupAttemptById(1, backupBatch.getId().toString());
            if (!CollectionUtils.isEmpty((Collection)attempts)) {
                backupActivityHistoryElement.setAttemptIsThere(true);
            }
            if (!backupBatch.getDeviceName().contains("Microsoft ")) {
                if (!CollectionUtils.isEmpty((Collection)attempts)) {
                    String uploadedSize = this.getUploadedSize(attempts, backupBatch);
                    backupActivityHistoryElement.setAttemptIsThere(true);
                    if (backupBatch.getStatus().equalsIgnoreCase("COMPLETED")) {
                        backupActivityHistoryElement.setUploadedPercentage("100 %");
                    } else {
                        try {
                            String uploadedFiles = backupBatch.getUploadedFiles();
                            if (StringUtils.isEmpty((String)uploadedFiles)) {
                                uploadedFiles = "0/0";
                            }
                            long totalNoUploadedFiles = 0L;
                            String[] parts = uploadedFiles.split(PATH_SEPARATOR);
                            int actualNoOfFiles = Integer.parseInt(parts[0]);
                            totalNoUploadedFiles = Integer.parseInt(backupBatch.getTotalNoOfFiles());
                            backupActivityHistoryElement.setUploadedPercentage(String.valueOf(this.getPercentageCompleted(actualNoOfFiles, totalNoUploadedFiles)) + " %");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.logger.error(" EXCEPTION..... " + e);
                        }
                    }
                }
            } else {
                long totalNoUploadedFiles = 0L;
                try {
                    this.logger.debug(".....get percent....");
                    String uploadedFiles = backupBatch.getUploadedFiles();
                    if (StringUtils.isEmpty((String)uploadedFiles)) {
                        uploadedFiles = "0/0";
                    }
                    String[] parts = uploadedFiles.split(PATH_SEPARATOR);
                    int actualNoOfFiles = Integer.parseInt(parts[0]);
                    totalNoUploadedFiles = Integer.parseInt(backupBatch.getTotalNoOfFiles());
                    this.logger.debug(backupBatch.getUploadedFiles() + "...backupbatch update.." + backupBatch.getTotalNoOfFiles());
                    this.logger.debug("...actualNoOfFiles.." + actualNoOfFiles);
                    this.logger.debug("...totaolNoFiles......." + totalNoUploadedFiles);
                    if (totalNoUploadedFiles != 0L) {
                        backupActivityHistoryElement.setUploadedPercentage(String.valueOf(this.getPercentageCompleted(actualNoOfFiles, totalNoUploadedFiles)) + " %");
                    } else {
                        backupActivityHistoryElement.setUploadedPercentage(String.valueOf(0) + " %");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error(" EXCEPTION..... " + e);
                }
            }
            String comments = this.getCommentsForBackupBatch(backupBatch);
            this.setNoOfFilesUploadedAndFailed(backupBatch, backupActivityHistoryElement);
            if (backupBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.STARTED.name())) {
                backupActivityHistoryElement.setStatus("Data Uploading");
                backupActivityHistoryElement.setNoOfFilesFailed("");
                comments = "Data Uploading";
            }
            if (backupBatch.getStatus().equalsIgnoreCase("PAUSED") || backupBatch.getStatus().equalsIgnoreCase("ABORTED")) {
                backupActivityHistoryElement.setNoOfFilesFailed("0");
            }
            this.logger.debug(backupBatch.getErrorCode() + "..pause..." + backupActivityHistoryElement.getNoOfFilesBackedup() + "....." + backupActivityHistoryElement.getTotalNumberOfFiles());
            if (("1207".equals(backupBatch.getErrorCode()) || "1209".equals(backupBatch.getErrorCode())) && (StringUtils.isEmpty((String)backupBatch.getTotalNoOfFiles()) || backupBatch.getTotalNoOfFiles().equals("0"))) {
                if ("1209".equals(backupBatch.getErrorCode())) {
                    comments = "Admin stopped Backup manually";
                }
                if ("1207".equals(backupBatch.getErrorCode())) {
                    comments = "Admin stopped Backup manually";
                }
            }
            this.logger.debug("..comments..." + comments);
            if ("Successfully Completed".equals(comments) && backupActivityHistoryElement.getTotalNumberOfFiles() == 0L) {
                comments = "Backup successfully completed. No files found.";
            }
            backupActivityHistoryElement.setComments(comments);
            if (backupBatch.getStatus().equalsIgnoreCase("SCANNING")) {
                backupActivityHistoryElement.setComments("-");
                if ("1209".equals(backupBatch.getErrorCode())) {
                    comments = "Admin stopped Scanning manually";
                }
                if ("1207".equals(backupBatch.getErrorCode())) {
                    comments = "Admin stopped Scanning manually";
                }
            }
            if (backupBatch.getStatus().equalsIgnoreCase(PRESCAN_COMMAND_EXECUTION)) {
                backupActivityHistoryElement.setComments("-");
            }
            backupActivityHistoryElement.setBatchId(backupBatch.getId().toString());
            backupHistoryElements.add(backupActivityHistoryElement);
        }
        return backupHistoryElements;
    }

    @Override
    public List<BackupAttemptElement> getBackupAttemps(int cloudId, String batchId) {
        this.logger.debug("..batchId..." + batchId);
        List backupBatchList = this.backupBatchDao.getAllBackupAttemptById(1, batchId);
        BackupBatch backupBatch = this.backupBatchDao.getBackupBatch(cloudId, "", batchId);
        return this.getBackupAttempsElements(backupBatchList, backupBatch);
    }

    @Override
    public List<ReBackUpImage> getAllReBkpList(int cloudId, String deviceUUID) {
        return this.backUpImageDao.getFilesForReBackup(cloudId, deviceUUID);
    }

    @Override
    public void removeReBkpByIds(int cloudId, List<ObjectId> rebkpIds) {
        this.backUpImageDao.removeReBkpByIds(cloudId, rebkpIds);
    }

    private String getUploadedSize(List<BackupAttempt> backupBatchList, BackupBatch batch) {
        long totalSizeUploadedFiles = 0L;
        String uploadedSize = "0 %";
        for (BackupAttempt backupBatchAttempt : backupBatchList) {
            this.logger.debug("..attempt......" + backupBatchAttempt.getUploadedSize());
            if (StringUtils.isEmpty((String)backupBatchAttempt.getUploadedSize())) continue;
            totalSizeUploadedFiles += Long.parseLong(backupBatchAttempt.getUploadedSize());
        }
        this.logger.debug(totalSizeUploadedFiles + "..attempt......" + batch.getTotalSizeToUpload());
        uploadedSize = this.getPercentageCompleted(totalSizeUploadedFiles, batch.getTotalSizeToUpload()) + " %";
        return uploadedSize;
    }

    private List<BackupAttemptElement> getBackupAttempsElements(List<BackupAttempt> backupBatchList, BackupBatch backupBatch) {
        ArrayList<BackupAttemptElement> backupHistoryElements = new ArrayList();
        try {
            long totalNoUploadedFiles = 0L;
            long totalSizeUploadedFiles = 0L;
            for (BackupAttempt backupBatchAttempt : backupBatchList) {
                String comments;
                BackupAttemptElement backupActivityHistoryElement;
                block34: {
                    int actualNoOfFiles;
                    String[] parts;
                    String uploadedFiles;
                    backupActivityHistoryElement = new BackupAttemptElement();
                    backupActivityHistoryElement.setDeviceName(backupBatchAttempt.getDeviceName());
                    backupActivityHistoryElement.setUserName(backupBatchAttempt.getUserName());
                    backupActivityHistoryElement.setStartTimeLong(backupBatchAttempt.getBatchStartTimestamp());
                    backupActivityHistoryElement.setStartTime(DateUtil.getDateInddMMMyyyy((long)backupBatchAttempt.getBatchStartTimestamp()));
                    this.logger.debug(backupBatchAttempt.getId() + "......attempt..." + backupBatchAttempt.getUploadedSize());
                    this.logger.debug("......totalSizeUploadedFiles. befores." + totalSizeUploadedFiles);
                    if (!StringUtils.isEmpty((String)backupBatchAttempt.getUploadedSize())) {
                        totalSizeUploadedFiles += Long.parseLong(backupBatchAttempt.getUploadedSize());
                    }
                    this.logger.debug("......totalSizeUploadedFiles. after...." + totalSizeUploadedFiles);
                    if (totalSizeUploadedFiles != 0L) {
                        backupActivityHistoryElement.setUploadedSize(BackupServiceImpl.formatFileSize(totalSizeUploadedFiles / 1024L));
                    } else {
                        this.logger.debug("size..0MB");
                        backupActivityHistoryElement.setUploadedSize("0.00 MB");
                    }
                    BackupBatch backupBatch2 = new BackupBatch();
                    BeanUtils.copyProperties((Object)backupBatchAttempt, (Object)backupBatch2);
                    this.logger.debug(backupBatch2.getStatus() + "......attempt..." + backupBatch2.getErrorCode());
                    if (backupBatch2.getErrorCode().equalsIgnoreCase("1212") && backupBatch2.getStatus().equalsIgnoreCase("COMPLETED")) {
                        backupBatch2.setStatus("STOPPED");
                        backupBatchAttempt.setStatus("STOPPED");
                    }
                    comments = this.getCommentsForBackupBatch(backupBatch2);
                    if (!backupBatch.getDeviceName().contains("Microsoft ")) {
                        try {
                            uploadedFiles = backupBatch.getUploadedFiles();
                            if (StringUtils.isEmpty((String)uploadedFiles)) {
                                uploadedFiles = "0/0";
                            }
                            parts = uploadedFiles.split(PATH_SEPARATOR);
                            actualNoOfFiles = Integer.parseInt(parts[1]);
                            long noOfFilesRemaing = (long)actualNoOfFiles - (totalNoUploadedFiles += backupBatchAttempt.getTotalNoOfFiles());
                            this.logger.debug(comments + "...noOfFilesRemaing.." + noOfFilesRemaing);
                            this.logger.debug("...actualNoOfFiles.." + actualNoOfFiles);
                            this.logger.debug("...totaolNoFiles......." + totalNoUploadedFiles);
                            this.logger.debug("...backupBatchAttempt.getUploadedSize().." + backupBatchAttempt.getUploadedSize());
                            this.logger.debug("...backupBatchAttempt.backupBatchAttempt().lates." + backupBatchAttempt.getTotalSizeToUpload());
                            backupActivityHistoryElement.setTotalNoOfFiles(totalNoUploadedFiles + "");
                            if (totalNoUploadedFiles != 0L && actualNoOfFiles != 0) {
                                backupActivityHistoryElement.setUploadedPercentage(String.valueOf(this.getPercentageCompleted(totalNoUploadedFiles, actualNoOfFiles)) + " %");
                                break block34;
                            }
                            this.logger.debug(totalSizeUploadedFiles + "...backupBatchAttempt.backupBatchAttempt().lates." + backupBatchAttempt.getTotalSizeToUpload());
                            backupActivityHistoryElement.setUploadedPercentage(String.valueOf(this.getPercentageCompleted(totalSizeUploadedFiles, backupBatchAttempt.getTotalSizeToUpload())) + " %");
                        }
                        catch (Exception e) {
                            this.logger.trace(" EXCEPTION..... " + e);
                        }
                    } else {
                        this.logger.debug("new attemptobjc.....");
                        try {
                            uploadedFiles = backupBatchAttempt.getUploadedFiles();
                            if (StringUtils.isEmpty((String)uploadedFiles)) {
                                uploadedFiles = "0/0";
                            }
                            parts = uploadedFiles.split(PATH_SEPARATOR);
                            actualNoOfFiles = Integer.parseInt(parts[0]);
                            int totalFilesTobackup = Integer.parseInt(parts[1]);
                            totalNoUploadedFiles += backupBatchAttempt.getTotalNoOfFiles();
                            long totalFiles = Integer.parseInt(backupBatch.getTotalNoOfFiles());
                            this.logger.debug(backupBatch.getUploadedFiles() + "...backupbatch update.." + backupBatch.getTotalNoOfFiles());
                            backupActivityHistoryElement.setTotalNoOfFiles(actualNoOfFiles + "");
                            backupActivityHistoryElement.setUploadedFiles(actualNoOfFiles + "");
                            backupActivityHistoryElement.setNoOfFiles((long)actualNoOfFiles);
                            this.logger.debug(backupBatchAttempt.getUploadedFiles() + "...actualNoOfFiles.." + actualNoOfFiles);
                            this.logger.debug("...totaolNoFiles val......." + totalFiles);
                            this.logger.debug("...backupBatchAttempt.getTotalNoOfFiles() val......." + backupBatchAttempt.getTotalNoOfFiles());
                            if (backupBatchAttempt.getTotalNoOfFiles() != 0L || totalFilesTobackup != 0) {
                                backupActivityHistoryElement.setUploadedPercentage(String.valueOf(this.getPercentageCompleted(actualNoOfFiles, totalFilesTobackup)) + " %");
                            } else {
                                backupActivityHistoryElement.setUploadedPercentage(String.valueOf(0) + " %");
                            }
                        }
                        catch (Exception e) {
                            this.logger.trace(" EXCEPTION..... " + e);
                        }
                    }
                }
                this.logger.debug("........." + backupBatchAttempt.getStatus());
                this.logger.debug("........." + backupActivityHistoryElement.getUploadedPercentage());
                if (backupBatchAttempt.getStatus().equalsIgnoreCase("COMPLETED")) {
                    backupActivityHistoryElement.setUploadedPercentage("100 %");
                }
                if (!backupBatchAttempt.getStatus().equalsIgnoreCase("COMPLETED") && backupActivityHistoryElement.getUploadedPercentage().contains("100")) {
                    backupActivityHistoryElement.setUploadedPercentage("-");
                }
                if (comments.equals("Successfully Completed") && (backupBatchAttempt.getStatus().equalsIgnoreCase(BackupBatch.STATUS.FAILED.name()) || backupBatchAttempt.getStatus().equalsIgnoreCase("ABORTED") || backupBatchAttempt.getStatus().equalsIgnoreCase("EXITED") || backupBatchAttempt.getStatus().equalsIgnoreCase("STOPPED") || backupBatchAttempt.getStatus().equalsIgnoreCase("INTERRUPTED") || backupBatchAttempt.getStatus().equalsIgnoreCase("FAILED"))) {
                    comments = this.getCommentsForBackupBatch(backupBatch);
                }
                backupActivityHistoryElement.setComments(comments);
                if (backupBatchAttempt.getStatus().equalsIgnoreCase("STARTED")) {
                    backupActivityHistoryElement.setStatus("Data Uploading");
                    backupActivityHistoryElement.setEndTimeLong(0L);
                    backupActivityHistoryElement.setEndTime("-");
                } else if (backupBatchAttempt.getStatus().equalsIgnoreCase("SCANNING")) {
                    backupActivityHistoryElement.setStatus("SCANNING");
                    backupActivityHistoryElement.setEndTimeLong(0L);
                    backupActivityHistoryElement.setStartTimeLong(0L);
                    backupActivityHistoryElement.setEndTime("-");
                    backupActivityHistoryElement.setTotalNoOfFiles("-");
                    backupActivityHistoryElement.setUploadedPercentage("-");
                    backupActivityHistoryElement.setComments("Completed");
                    backupActivityHistoryElement.setUploadedSize("-");
                } else if (backupBatchAttempt.getStatus().equalsIgnoreCase(PRESCAN_COMMAND_EXECUTION)) {
                    backupActivityHistoryElement.setStatus(PRESCAN_COMMAND_EXECUTION);
                    backupActivityHistoryElement.setEndTimeLong(0L);
                    backupActivityHistoryElement.setStartTimeLong(0L);
                    backupActivityHistoryElement.setEndTime("-");
                    backupActivityHistoryElement.setTotalNoOfFiles("-");
                    backupActivityHistoryElement.setUploadedPercentage("-");
                    backupActivityHistoryElement.setComments("-");
                    backupActivityHistoryElement.setUploadedSize("-");
                } else if (comments.equals("OneDrive target not assigned")) {
                    backupActivityHistoryElement.setUploadedPercentage("-");
                    backupActivityHistoryElement.setStatus("Stopped");
                    backupActivityHistoryElement.setEndTime(DateUtil.getDateInddMMMyyyy((long)backupBatchAttempt.getBatchEndTimestamp()));
                } else {
                    backupActivityHistoryElement.setStatus(backupBatchAttempt.getStatus());
                    backupActivityHistoryElement.setEndTimeLong(backupBatchAttempt.getBatchEndTimestamp());
                    backupActivityHistoryElement.setEndTime(DateUtil.getDateInddMMMyyyy((long)backupBatchAttempt.getBatchEndTimestamp()));
                }
                if (!StringUtils.isEmpty((String)backupActivityHistoryElement.getComments()) && backupActivityHistoryElement.getComments().contains("paused")) {
                    backupActivityHistoryElement.setStatus("PAUSED");
                }
                if (("1207".equals(backupBatch.getErrorCode()) || "1209".equals(backupBatch.getErrorCode())) && (StringUtils.isEmpty((String)backupBatch.getTotalNoOfFiles()) || backupBatch.getTotalNoOfFiles().equals("0"))) {
                    if ("1209".equals(backupBatch.getErrorCode())) {
                        comments = "Admin stopped Scanning manually";
                    }
                    if ("1207".equals(backupBatch.getErrorCode())) {
                        comments = "Admin stopped Scanning manually";
                    }
                }
                this.logger.debug(backupActivityHistoryElement.getUploadedPercentage() + "..attempt comments..." + comments);
                this.logger.debug(backupActivityHistoryElement.getStatus() + "...status and files...." + backupActivityHistoryElement.getNoOfFiles() + "...." + backupActivityHistoryElement.getTotalNoUploadedFiles() + "..." + backupActivityHistoryElement.getTotalNoOfFiles());
                backupActivityHistoryElement.setComments(comments);
                if (backupBatch.getStatus().equals("SCANNING") && backupBatch.getStatus().equalsIgnoreCase(backupBatchAttempt.getStatus())) {
                    backupActivityHistoryElement.setComments("-");
                }
                backupActivityHistoryElement.setBatchId(backupBatchAttempt.getId().toString());
                backupHistoryElements.add(backupActivityHistoryElement);
            }
        }
        catch (Exception e) {
            this.logger.trace(" EXCEPTION..... " + e);
        }
        Comparator<BackupAttemptElement> comparator = Comparator.comparing(BackupAttemptElement::getStartTimeLong).reversed();
        backupHistoryElements = backupHistoryElements.stream().filter(Objects::nonNull).sorted(comparator).collect(Collectors.toList());
        return backupHistoryElements;
    }

    private long getPercentageCompleted(long totalNoOfFilesBackedUpSoFar, long overAllFilesToBackup) {
        long percentage = 0L;
        this.logger.debug(" totalNoOfFilesBackedUpSoFar..... " + totalNoOfFilesBackedUpSoFar);
        this.logger.debug(" overAllFilesToBackup....new. " + overAllFilesToBackup);
        if (overAllFilesToBackup != 0L) {
            percentage = totalNoOfFilesBackedUpSoFar * 100L / overAllFilesToBackup;
        }
        return percentage;
    }

    @Override
    public void saveBackupAttempt(int cloudId, String cloudName, BackupAttempt attempt) {
        this.backupBatchDao.saveBackupAttempt(cloudId, cloudName, attempt);
    }

    @Override
    public BackupAttempt getLastBackupAttemptById(int cloudId, String batchId) {
        return this.backupBatchDao.getLastBackupAttemptById(cloudId, batchId);
    }

    private String getCommentsForBackupBatch(BackupBatch backupBatch) {
        String comments = "";
        if ("STARTED".equalsIgnoreCase(backupBatch.getStatus())) {
            return comments;
        }
        if ("0".equals(backupBatch.getErrorCode())) {
            comments = "Successfully Completed";
        }
        if (PRESCAN_COMMAND_EXECUTION.equals(backupBatch.getStatus())) {
            comments = "-";
        }
        boolean officeProduct = false;
        if (backupBatch.getDeviceName().contains("Microsoft Exchange") || backupBatch.getDeviceName().contains("Microsoft OneDrive")) {
            officeProduct = true;
        }
        if ("909".equals(backupBatch.getErrorCode())) {
            comments = !officeProduct ? "Network disconnected or endpoint was shutdown during the backup" : "Network disconnected during the backup";
        }
        if ("911".equals(backupBatch.getErrorCode())) {
            comments = "User exited the agent manually or the endpoint was shutdown during the backup";
        }
        if ("912".equals(backupBatch.getErrorCode())) {
            comments = "Machine Utilization exceeded during backup";
        }
        if ("1947".equals(backupBatch.getErrorCode())) {
            comments = "Storage limit exceeded";
        }
        if ("2304".equals(backupBatch.getErrorCode())) {
            comments = "Backup temporarily suspended because server is busy.Will be retried later";
        }
        if ("1992".equals(backupBatch.getErrorCode())) {
            comments = officeProduct ? "Admin paused BackUp manually" : "User paused BackUp manually";
        }
        if ("1981".equals(backupBatch.getErrorCode())) {
            comments = "User storage limit reached.";
        }
        if ("1996".equals(backupBatch.getErrorCode())) {
            comments = "Backup Deferred.";
        }
        if ("1207".equals(backupBatch.getErrorCode())) {
            comments = officeProduct ? "Admin stopped BackUp manually" : "User stopped BackUp manually";
        }
        if ("1208".equals(backupBatch.getErrorCode())) {
            comments = "Admin paused BackUp manually";
        }
        if ("1209".equals(backupBatch.getErrorCode())) {
            comments = "Admin stopped BackUp manually";
        }
        if ("543".equals(backupBatch.getErrorCode())) {
            comments = "OneDrive target not assigned";
        }
        if ("544".equals(backupBatch.getErrorCode())) {
            comments = "MailBox permission denied";
        }
        if ("1211".equals(backupBatch.getErrorCode())) {
            comments = "Pre scan command failed.";
        }
        if ("1210".equals(backupBatch.getErrorCode())) {
            comments = "Pre backup command failed.";
        }
        if ("913".equals(backupBatch.getErrorCode())) {
            comments = "User decoupled the agent";
        }
        if ("1212".equals(backupBatch.getErrorCode())) {
            comments = "Access denied";
        }
        if ("1213".equals(backupBatch.getErrorCode())) {
            comments = "one or more databases are not set to simple recovery";
        }
        if ("1214".equals(backupBatch.getErrorCode())) {
            comments = "access denied while connecting database";
        }
        return comments;
    }

    private void setNoOfFilesUploadedAndFailed(BackupBatch backupBatch, BackupActivityHistoryElement backupActivityHistoryElement) {
        String uploadedFiles = backupBatch.getUploadedFiles();
        int noOfFilesBackedup = 0;
        int actualNoOfFiles = 0;
        int noOfFilesFailed = 0;
        try {
            String[] parts;
            if (StringUtils.isEmpty((String)uploadedFiles)) {
                uploadedFiles = "0/0";
            }
            if ((noOfFilesFailed = (actualNoOfFiles = Integer.parseInt((parts = uploadedFiles.split(PATH_SEPARATOR))[1])) - (noOfFilesBackedup = Integer.parseInt(parts[0]))) < 0) {
                noOfFilesFailed = 0;
            }
        }
        catch (Exception e) {
            this.logger.trace(" no detail for uploaded files " + e);
            this.logger.error(" no detail for uploaded files " + e.getMessage());
        }
        backupActivityHistoryElement.setNoOfFilesBackedup(String.valueOf(noOfFilesBackedup));
        backupActivityHistoryElement.setNoOfFilesFailed(String.valueOf(noOfFilesFailed));
        long totalFilesParsed = Long.parseLong(backupBatch.getTotalNoOfFiles());
        this.logger.debug(totalFilesParsed + "......parsed..." + noOfFilesBackedup + "...failed...." + noOfFilesFailed);
        if (totalFilesParsed < 0L) {
            backupActivityHistoryElement.setTotalNumberOfFiles((long)(noOfFilesBackedup + noOfFilesFailed));
        }
    }

    @Override
    public BackupBatch getLastBackupOnly(int cloudId, String cloudName, User user, Device device, boolean isLastsuccessfulBackup) {
        if (isLastsuccessfulBackup) {
            return this.backupBatchDao.getLastSuccessfullBackup(cloudId, cloudName, user.getUserName(), device.getDeviceName());
        }
        return this.backupBatchDao.getLastBackupOnly(cloudId, cloudName, user, device);
    }

    @Override
    public void updateBackupBatch(int cloudId, String userName, String deviceUUID) {
        this.backupBatchDao.updateBackupBatch(cloudId, deviceUUID, userName);
    }

    @Override
    public void updateBackupBatch(int cloudId, String objectId, String status, String errorCode, BackupBatch backupBatch) {
        this.backupBatchDao.updateBackupBatch(cloudId, objectId, status, errorCode, backupBatch);
    }

    @Override
    public BackupLog getBackupLogForBatchId(int cloudId, String cloudName, BackupBatch backupBatch, String deviceUUID) {
        return this.backupBatchDao.getBackupLog(cloudId, cloudName, backupBatch, deviceUUID);
    }

    @Override
    public void saveBackupBatch(int cloudId, String cloudName, BackupBatch backupBatch) {
        this.backupBatchDao.saveBackupBatch(cloudId, cloudName, backupBatch);
    }

    @Override
    public void saveRestoreHistory(int cloudId, String cloudName, RestoreHistory restoreHistory) {
        this.backupBatchDao.saveRestoreHistory(cloudId, cloudName, restoreHistory);
    }

    @Override
    public RestoreHistory getRestoreHistoryById(int cloudId, ObjectId objectId) {
        return this.backupBatchDao.getRestoreHistoryById(cloudId, objectId);
    }

    @Override
    public BackupBatch getBackupBatch(int cloudId, String cloudName, String backupBatchId) {
        return this.backupBatchDao.getBackupBatch(cloudId, cloudName, backupBatchId);
    }

    @Override
    public void updateBackupLog(int cloudId, String cloudName, BackupLog backupLog) {
        this.backupLogsDao.saveBackupLog(cloudId, cloudName, backupLog);
    }

    @Override
    public List<ActionStatusElement> getAllBackupBatchBetweenTimeStamps(int cloudId, String cloudName, long startTime, long endTime, int skipValue, int recordsCount, String sortParam, String sortDirection) {
        List backupBatches = this.backupBatchDao.getAllBackupBatchBtwTimestamps(cloudId, cloudName, startTime, endTime, skipValue, recordsCount, sortParam, sortDirection);
        return this.getBackupActivityHistoryElements(backupBatches);
    }

    @Override
    public long getCountofAllBackupBatchBetweenTimeStamps(int cloudId, String cloudName, long startTime, long endTime) {
        return this.backupBatchDao.getAllBackupBatchBtwTimestampsCount(cloudId, cloudName, startTime, endTime);
    }

    private List<ActionStatusElement> getBackupActivityHistoryElements(List<BackupBatch> backupBatchList) {
        ArrayList<ActionStatusElement> actionStatusElements = new ArrayList();
        for (BackupBatch backupBatch : backupBatchList) {
            if ("SYNC".equalsIgnoreCase(backupBatch.getJobType())) continue;
            ActionStatusElement actionStatusElement = new ActionStatusElement();
            actionStatusElement.setDeviceName(backupBatch.getDeviceName());
            actionStatusElement.setUserName(backupBatch.getUserName());
            actionStatusElement.setStartTime(backupBatch.getBatchStartTimestamp());
            actionStatusElement.setEndTime(backupBatch.getBatchEndTimestamp());
            actionStatusElement.setTotalNumberOfFiles(Long.parseLong(backupBatch.getTotalNoOfFiles()));
            actionStatusElement.setStatus(backupBatch.getStatus());
            actionStatusElement.setType(backupBatch.getJobType());
            String comments = this.getCommentsForBackupBatch(backupBatch);
            String uploadedFiles = StringUtils.isEmpty((String)backupBatch.getUploadedFiles()) ? "0/" + backupBatch.getTotalNoOfFiles() : backupBatch.getUploadedFiles();
            String[] parts = uploadedFiles.split(PATH_SEPARATOR);
            long noOfFilesProcessed = Integer.parseInt(parts[0]);
            actionStatusElement.setNoOfFilesProcessed(noOfFilesProcessed);
            actionStatusElement.setReason(comments);
            actionStatusElement.setBatchId(backupBatch.getId().toString());
            actionStatusElements.add(actionStatusElement);
        }
        this.logger.debug("sorting by start time");
        Comparator<ActionStatusElement> comparator = Comparator.comparing(ActionStatusElement::getStartTime);
        actionStatusElements = actionStatusElements.stream().filter(Objects::nonNull).sorted(comparator).collect(Collectors.toList());
        return actionStatusElements;
    }

    @Override
    public BackupListResponseElement getFilesForReBackup(Cloud cloud, String userName, String deviceUUID) {
        ArrayList<FileElement> list = new ArrayList<FileElement>();
        Device device = this.deviceDao.getDeviceInfoByUUID(cloud.getCloudId(), cloud.getCloudName(), deviceUUID);
        if (device != null) {
            List reBkpList = this.backUpImageDao.getFilesForReBackup(cloud.getCloudId(), device.getId().toString());
            for (ReBackUpImage reBkpImage : reBkpList) {
                FileElement fileElement = new FileElement();
                fileElement.setBackupId(reBkpImage.getId().toString());
                fileElement.setFileCompletePath(reBkpImage.getDevicePath());
                fileElement.setFileName(reBkpImage.getFileName());
                fileElement.setFileUserOwner(reBkpImage.getUserName());
                list.add(fileElement);
            }
        }
        BackupListResponseElement backupListResponseElement = new BackupListResponseElement();
        FileListElement fileToUploadListElement = new FileListElement();
        fileToUploadListElement.setFileElementList(list);
        backupListResponseElement.setFilesNotToAddList(fileToUploadListElement);
        return backupListResponseElement;
    }

    @Override
    public void deleteFileInRebackupAndBackup(int cloudId, String cloudName, ObjectId backupId) {
        this.backUpImageDao.deleteFileInRebackupAndBackup(cloudId, backupId);
    }

    @Override
    public FileListElement getLatestFolderListRecursive(int cloudId, String cloudName, Device device, String path, long serverModifiedTime) {
        String folderPath = "";
        if (!StringUtils.isEmpty((String)path)) {
            folderPath = PathConversionHelper.getServerCompatiblePath((String)path, (boolean)false);
        }
        ArrayList<BackUpImage> backUpImages = new ArrayList<BackUpImage>();
        ArrayList<BackUpImage> backUpImageList = new ArrayList<BackUpImage>();
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", "20");
        this.getImmediateFolderChildren(cloudId, cloudName, device, folderPath, backUpImages);
        this.logger.debug("After getting all folders recursive final size:" + backUpImages.size());
        if (!CollectionUtils.isEmpty(backUpImages)) {
            if (serverModifiedTime > 0L) {
                for (BackUpImage backUpImage : backUpImages) {
                    if (backUpImage.getLastServerModifiedTime() > serverModifiedTime) continue;
                    backUpImageList.add(backUpImage);
                }
            } else {
                backUpImageList.addAll(backUpImages);
            }
        } else {
            this.logger.debug("There is no file to Restore for DeviceUUID .............. " + device.getDeviceUUID());
        }
        if (!CollectionUtils.isEmpty(backUpImageList)) {
            this.logger.debug("After getting all folders recursive final size:" + backUpImageList.size());
            return this.getFileListElement(device, backUpImageList);
        }
        this.logger.debug("...empty....");
        return new FileListElement();
    }

    private void getImmediateFolderChildren(int cloudId, String cloudName, Device device, String folderPath, List<BackUpImage> backUpImages) {
        this.logger.debug("inside getting all folders in recursive manner............devicePath:" + folderPath);
        List backUpImagesTemp = this.backUpImageDao.getLatestFoldersRecursive(cloudId, cloudName, device, folderPath);
        backUpImages.addAll(backUpImagesTemp);
        if (!CollectionUtils.isEmpty((Collection)backUpImagesTemp)) {
            Stream stream = backUpImagesTemp.parallelStream();
            stream.forEach(backUpImage -> {
                String devicePath = backUpImage.getDevicePath() + PATH_SEPARATOR + backUpImage.getFileName();
                this.logger.debug("Inside loop after getting folders..bkpimages list size:" + backUpImagesTemp.size());
                if (StringUtils.isEmpty((String)backUpImage.getDevicePath())) {
                    devicePath = backUpImage.getFileName();
                }
                this.logger.debug("Inside loop to get immediate folders deevicePath:" + devicePath);
                this.getImmediateFolderChildren(cloudId, cloudName, device, devicePath, backUpImages);
            });
        }
    }

    @Override
    public DeletedBackupFile getDeletedBkpFileByUserAndDeviceUUID(int cloudId, String userName, String deviceUUID) {
        return this.backUpImageDao.getDeletedBkpFileByUserAndDeviceUUID(cloudId, userName, deviceUUID);
    }

    @Override
    public BackupPolicy getBackupPolicy(int cloudId, String cloudName, String policyName) {
        return this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, policyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeFailedFilesLogForRequestId(String devideviceUUID, String batchId, InputStream input) {
        if (input == null) {
            throw new BaseException("Input Stream is null");
        }
        File fileToDownloadFolderPath = new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + PATH_SEPARATOR + DOWNLOAD_LOCATION + PATH_SEPARATOR + devideviceUUID + PATH_SEPARATOR + batchId);
        File fileToDownload = new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + PATH_SEPARATOR + DOWNLOAD_LOCATION + PATH_SEPARATOR + devideviceUUID + PATH_SEPARATOR + batchId + PATH_SEPARATOR + FILE_NAME);
        String zipFileLocation = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + PATH_SEPARATOR + DOWNLOAD_LOCATION + PATH_SEPARATOR + devideviceUUID + PATH_SEPARATOR + batchId + PATH_SEPARATOR + FILE_NAME;
        String extractedFilesLocation = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + PATH_SEPARATOR + DOWNLOAD_LOCATION + PATH_SEPARATOR + devideviceUUID + PATH_SEPARATOR + batchId;
        if (PCHelperConstant.isAzureVM()) {
            this.logger.debug("inside azure vmm send logs.....");
            this.saveLogFileInBackbone(devideviceUUID, batchId, input);
        } else {
            this.logger.debug("Inside backbone vm send logs.....");
            try {
                if (!fileToDownloadFolderPath.exists() && !fileToDownloadFolderPath.mkdirs()) {
                    this.logger.debug("inside return");
                    return;
                }
                if (fileToDownload.exists()) {
                    this.logger.debug("file is there so delete the existing file");
                    fileToDownload.delete();
                }
                fileToDownload.createNewFile();
                try (FileOutputStream outputStreamOfFile = new FileOutputStream(fileToDownload);){
                    IOUtils.copy((InputStream)input, (OutputStream)outputStreamOfFile);
                }
                this.unZipIt(zipFileLocation, extractedFilesLocation);
            }
            catch (FileNotFoundException e) {
                this.logger.debug("FileNotFoundException ", (Throwable)e);
            }
            catch (IOException e) {
                this.logger.debug("IOException ", (Throwable)e);
            }
            catch (Exception e) {
                this.logger.debug(e + "");
            }
            finally {
                try {
                    input.close();
                    File file = new File(zipFileLocation);
                    this.logger.debug("Deleting zip file...........");
                    file.delete();
                }
                catch (IOException e1) {
                    this.logger.debug("" + e1);
                }
            }
        }
    }

    public void unZipIt(String zipFile, String outputFolder) {
        byte[] buffer = new byte[1024];
        try {
            File folder = new File(outputFolder);
            if (!folder.exists()) {
                folder.mkdir();
            }
            ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                int len;
                String fileName = ze.getName();
                File newFile = new File(outputFolder + PATH_SEPARATOR + fileName);
                this.logger.debug("file unzip : " + newFile.getAbsoluteFile());
                new File(newFile.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (IOException ex) {
            this.logger.trace("" + ex);
            this.logger.error("Exception :", (Object)ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLogFileInBackbone(String devideviceUUID, String batchId, InputStream input) {
        this.logger.debug(" call  save logs in back bone from azure via rest>>>>>>>>>>>>>>>>>>");
        HttpClient httpclient = HttpClientUtil.getSSlConnection();
        HttpPost httpPost = null;
        try {
            String url = PCHelperConstant.getPropertyFileValueParacloudUrl() + "/paracloud/save/logs/";
            if (PCHelperConstant.isHttpEnabled()) {
                url = url.replace(PREFIX_HTTPS, PREFIX_HTTP);
            }
            this.logger.debug("Paracloud url={} and is Http enabled={}", (Object)url, (Object)PCHelperConstant.isHttpEnabled());
            httpPost = new HttpPost(url);
            httpPost.setHeader("devideviceUUID", devideviceUUID);
            httpPost.setHeader("batchId", batchId);
            InputStreamEntity entity = new InputStreamEntity(input);
            httpPost.setEntity((HttpEntity)entity);
            httpclient.execute((HttpUriRequest)httpPost);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Exception ........", (Object)e.getMessage());
        }
        finally {
            httpPost.releaseConnection();
        }
    }

    @Override
    public List<MailElement> getMailChildren(int cloudId, String cloudName, String folderPath, Device device, int skipValue, int recordsCount) {
        List backUpImages;
        this.logger.debug(device.getDeviceUUID() + "============" + device.getDeviceUUID());
        if (folderPath == null || "".equals(folderPath)) {
            this.logger.debug("============inside folde=++++++++++++++++++++++++++");
            backUpImages = this.backUpImageDao.getBaseChildrenByDevice(cloudId, cloudName, device, skipValue, recordsCount, true);
        } else {
            this.logger.debug("**************************************************************");
            backUpImages = this.backUpImageDao.getChildrenByFolder(cloudId, cloudName, folderPath, device, skipValue, recordsCount, true, true);
        }
        if (backUpImages == null || backUpImages.isEmpty()) {
            this.logger.debug("NO FILES FOR PATH ...." + folderPath + " device ID " + device.getDeviceUUID());
            return null;
        }
        this.logger.debug("new backup images from DB : " + backUpImages.size());
        return this.getMailElementsFromBackupImg(backUpImages);
    }

    @Override
    public MailElement getMailBackUpImageInfo(int cloudId, Device device, ObjectId backupId) {
        SimpleDateFormat df2;
        List attachments;
        BackUpImage backUpImage = this.backUpImageDao.getMailBackUpImageInfo(cloudId, device, backupId);
        this.logger.debug(device.getId().toString() + ".....backup and device ... " + backupId);
        MailElement mailElement = new MailElement();
        BeanUtils.copyProperties((Object)backUpImage, (Object)mailElement);
        mailElement.setBackupId(backUpImage.getId().toString());
        mailElement.setDeviceUUID(backUpImage.getDeviceUUID());
        mailElement.setHasAttachments(backUpImage.isHasAttachments());
        ArrayList<MailAttachmentElement> listAttached = new ArrayList<MailAttachmentElement>();
        if (mailElement.isHasAttachments() && !CollectionUtils.isEmpty((Collection)(attachments = backUpImage.getAttachments()))) {
            for (MailAttachment attachment : attachments) {
                MailAttachmentElement attachmentElement = new MailAttachmentElement();
                BeanUtils.copyProperties((Object)attachment, (Object)attachmentElement);
                listAttached.add(attachmentElement);
            }
        }
        mailElement.setAttachments(listAttached);
        try {
            df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
            mailElement.setSentDate(df2.format(backUpImage.getSentDate()));
        }
        catch (Exception e) {
            this.logger.error("...trying to set date..." + backUpImage.getSentDate());
        }
        try {
            df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
            mailElement.setTaskDueDate(df2.format(backUpImage.getTaskDueDate()));
        }
        catch (Exception e) {
            this.logger.error("...trying to setTaskDueDate..." + backUpImage.getSentDate());
        }
        try {
            df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
            mailElement.setTaskReminderTime(df2.format(backUpImage.getTaskReminderTime()));
        }
        catch (Exception e) {
            this.logger.error("...trying to getTaskReminderTime..." + backUpImage.getSentDate());
        }
        try {
            df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
            mailElement.setTaskStartDate(df2.format(backUpImage.getTaskStartDate()));
        }
        catch (Exception e) {
            this.logger.error("...trying to setTaskStartDate .." + backUpImage.getSentDate());
        }
        return mailElement;
    }

    @Override
    public long getTotalMails(int cloudId, String devicePath, Device device) {
        return this.backUpImageDao.getTotalMails(cloudId, devicePath, device);
    }

    @Override
    public BackupBatch getLastRestoreBatch(int cloudId, String deviceUUID) {
        return this.backupBatchDao.getLastRestoreBatch(cloudId, deviceUUID);
    }

    @Override
    public void deleteRestoredFilesCollById(int cloudId, String restoreBatchId) {
        this.logger.debug("...delete restore files of batch id ....:" + restoreBatchId);
        this.backupBatchDao.deleteRestoredFilesCollById(cloudId, restoreBatchId);
    }

    @Override
    public void saveRestoreDetailsForDelFolders(int cloudId, ObjectId restoreBatchId, String deviceUUID) {
        this.backupBatchDao.saveRestoreDetailsForDelFolders(cloudId, restoreBatchId, deviceUUID);
    }

    @Override
    public BackUpImage getBackUpImageForId(int cloudId, String backupId, Device device) {
        return this.backUpImageDao.getMailBackUpImageInfo(cloudId, device, new ObjectId(backupId));
    }

    @Override
    public BackUpImage getBackupFileForID(int cloudId, ObjectId bkpId, Device device) {
        return this.backUpImageDao.getBackupFileForID(cloudId, bkpId, device);
    }

    @Override
    public BackupListElement getFilesForSearchStr(int cloudId, String cloudName, String searchStr, Device device, int recordsCount, int pageNumber) {
        BackupListElement backupListElement = new BackupListElement();
        ArrayList<BackupElement> backupElements = new ArrayList<BackupElement>();
        List rwlist = this.backupBatchDao.getRWSampleList(cloudId);
        List rwFilesList = this.backupBatchDao.getRWSampleFilesList(cloudId);
        if (searchStr == null || "".equals(searchStr)) {
            return null;
        }
        List backUpImages = this.backUpImageDao.getFilesForSearchStr(cloudId, cloudName, searchStr, device, recordsCount, pageNumber);
        for (BackUpImage backUpImage : backUpImages) {
            boolean isFileSame;
            if (backUpImage != null && backUpImage.getMd5Checksum() != null && (isFileSame = this.checkMd5(1, backUpImage.getMd5Checksum(), rwlist))) {
                this.logger.debug("md5 name is same so skip the file...........");
                continue;
            }
            if (backUpImage != null && backUpImage.getFileName() != null && (isFileSame = this.checkMd5(1, backUpImage.getFileName(), rwFilesList))) {
                this.logger.debug("md5/file name is same so skip the file...........");
                continue;
            }
            BackupElement backupElement = new BackupElement();
            backupElement.setFileName(backUpImage.getFileName());
            backupElement.setFileCompletePath(backUpImage.getDevicePath());
            backupElement.setFolder(backUpImage.isFolder());
            backupElement.setLastServerModifiedTime(backUpImage.getLastServerModifiedTime());
            backupElement.setLastClientModifiedTime(backUpImage.getLastClientModifiedTime());
            backupElement.setMd5Checksum(backUpImage.getMd5Checksum());
            backupElement.setStatus(backUpImage.getStatus());
            backupElement.setSize(backUpImage.getSize());
            backupElement.setPresent(backUpImage.isPresent());
            backupElement.setfSPath(backUpImage.getfSPath());
            backupElement.setBackupId(backUpImage.getId().toString());
            backupElement.setFileUserOwner(backUpImage.getUserName());
            backupElement.setDeviceUUID(device.getDeviceUUID());
            String extension = FilenameUtils.getExtension((String)backUpImage.getFileName());
            if (FileTypeHelper.isImageFile((String)extension) || FileTypeHelper.isVideoFile((String)extension)) {
                backupElement.setThumbnailPath("/t/backup" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getfSPath());
            }
            backupElements.add(backupElement);
        }
        backupListElement.setFileElementList(backupElements);
        return backupListElement;
    }

    @Override
    public long[] getLatestRestorableSizeRecursive(int cloudId, String cloudName, Device device, String path, String restoreTillTimestamp, boolean restoreDeletedFiles) {
        String folderPath = "";
        if (!StringUtils.isEmpty((String)path)) {
            folderPath = PathConversionHelper.getServerCompatiblePath((String)path, (boolean)false);
        }
        ArrayList<BackUpImage> backUpImages = new ArrayList<BackUpImage>();
        long totalSize = 0L;
        ArrayList<Long> sizesList = new ArrayList<Long>();
        ArrayList<Long> numberOfFilesList = new ArrayList<Long>();
        Long totalNumberOfFiles = 0L;
        long[] result = new long[2];
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", "20");
        this.getImmediateFolderChildren(cloudId, cloudName, device, folderPath, backUpImages);
        this.logger.debug("After getting all folders recursive final bkpimage size:" + backUpImages.size());
        if (!CollectionUtils.isEmpty(backUpImages)) {
            backUpImages.parallelStream().forEach(bkpImage -> {
                String devicePath = bkpImage.getDevicePath() + PATH_SEPARATOR + bkpImage.getFileName();
                this.logger.debug(backUpImages.size() + " backUpImages.parallelStream().forEach(bkpImage ->" + devicePath);
                if (StringUtils.isEmpty((String)bkpImage.getDevicePath())) {
                    devicePath = bkpImage.getFileName();
                }
                this.getBackupfilesInRecursive(cloudId, cloudName, device, devicePath, sizesList, restoreTillTimestamp, restoreDeletedFiles, numberOfFilesList);
            });
        }
        this.logger.debug("There is no file to Restore for DeviceUUID .............. " + device.getDeviceUUID());
        this.getBackupfilesInRecursive(cloudId, cloudName, device, folderPath, sizesList, restoreTillTimestamp, restoreDeletedFiles, numberOfFilesList);
        this.logger.debug(" totla no of files.sizeList size@@@@@@@@@@@@@:" + sizesList.size());
        totalSize = sizesList.stream().collect(Collectors.summingLong(Long::longValue));
        totalNumberOfFiles = numberOfFilesList.stream().collect(Collectors.summingLong(Long::longValue));
        this.logger.debug(totalNumberOfFiles + ":total no of files...totalRestorable size is:" + totalSize);
        result[0] = totalSize;
        result[1] = totalNumberOfFiles;
        return result;
    }

    private void getBackupfilesInRecursive(int cloudId, String cloudName, Device device, String folderPath, List<Long> sizeList, String restoreTillTimestamp, boolean restoreDeletedFiles, List<Long> totalNumberOfFilesList) {
        this.logger.debug("inside getting all files in recursive manner............devicePath:" + folderPath);
        List backUpImagesTemp = this.backUpImageDao.getRestBackupFilesForGivenPathfromBackupImage(cloudId, cloudName, folderPath, device, false, restoreTillTimestamp, restoreDeletedFiles);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)backUpImagesTemp)) {
            List sizeListTemp = backUpImagesTemp.parallelStream().map(bkpimage -> bkpimage.getSize()).collect(Collectors.toList());
            long totalSize = sizeListTemp.stream().collect(Collectors.summingLong(Long::longValue));
            this.logger.debug(backUpImagesTemp.size() + " size.." + sizeListTemp.size() + "..totalSize for  a particular folder@@@@@@@@@@@@@:" + totalSize);
            sizeList.add(totalSize);
            totalNumberOfFilesList.add(new Long(backUpImagesTemp.parallelStream().filter(bkpImage -> !bkpImage.isFolder()).collect(Collectors.toList()).size()));
            this.logger.debug(totalNumberOfFilesList.size() + " total number of files..sizeList size after a folder added@@@@@@@@@@@@@:" + sizeList.size());
            backUpImagesTemp = null;
        } else {
            this.logger.debug("backUpImagesTemp is empty...." + sizeList.size());
        }
    }

    @Override
    public int getSuccessFullBackupBatchCount(int cloudId, String cloudName, String deviceUUID) {
        return this.backupBatchDao.getSuccessFullBackupBatchCount(cloudId, cloudName, deviceUUID);
    }

    public long getEndOfDay(String endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(MM_DD_YYYY);
        Date date = null;
        try {
            date = sdf.parse(endDate);
        }
        catch (ParseException e) {
            this.logger.trace(PARSE_EXCEPTION + e);
            this.logger.error(PARSE_EXCEPTION + e.getMessage());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    public long getStartOfDay(String startDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(MM_DD_YYYY);
        Date date = null;
        try {
            date = sdf.parse(startDate);
        }
        catch (ParseException e) {
            this.logger.trace(PARSE_EXCEPTION + e);
            this.logger.error(PARSE_EXCEPTION + e.getMessage());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    private boolean checkMd5(int cloudId, String fileName, List<String> rwlist) {
        this.logger.debug("..........md5ofChunk........" + fileName);
        boolean isfileNamesame = false;
        if (StringUtils.isNotEmpty((String)fileName)) {
            for (String md51 : rwlist) {
                if (!fileName.equalsIgnoreCase(md51)) continue;
                isfileNamesame = true;
                break;
            }
        }
        return isfileNamesame;
    }
}

