/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.backup.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.backup.service.BackupService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.AuthorizationService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.element.ActionStatusElement;
import com.parablu.paracloud.element.BSDeviceDetailsElement;
import com.parablu.paracloud.element.BSDeviceInfoElement;
import com.parablu.paracloud.element.BackupActivityHistoryElement;
import com.parablu.paracloud.element.BluSyncPortalBackupElement;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.CloudCredentials;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.User;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BlusyncPortalDetailsController
extends BaseController {
    private static Logger logger = LogManager.getLogger(BlusyncPortalDetailsController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private AuthorizationService authorizationService1;
    @Autowired
    private BackupService backupService;
    @Autowired
    private DeviceManagementService deviceManagementService;
    @Autowired
    private UserManagementService userManagementService;
    @Autowired
    private BackupPolicyDao backupPolicyDao;
    @Autowired
    private AuditHistoryService auditHistoryService;
    private static final String EXCEPTION = "Exception  :";

    @RequestMapping(value={"cloud/{cloudName}/bsportal/backup/info"}, method={RequestMethod.GET})
    public ModelAndView getUserDevicesInfo(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("calling bsportal/backup/info ...");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            if (!this.checkIfUserIsValid(authorizationTokens.getUser(), 0, response)) {
                return null;
            }
            User user = authorizationTokens.getUser();
            List devices = this.deviceManagementService.getAllDevicesForUser(cloudId, cloudName, user.getUserName());
            BluSyncPortalBackupElement bluSyncPortalBackupElement = new BluSyncPortalBackupElement();
            bluSyncPortalBackupElement.setUserName(user.getUserName());
            bluSyncPortalBackupElement.setEmailId(user.getEmailId());
            bluSyncPortalBackupElement.setDevices(new ArrayList());
            long storageUsedForUser = 0L;
            for (Device device : devices) {
                if (device == null) continue;
                BSDeviceDetailsElement bsDeviceDetailsElement = new BSDeviceDetailsElement();
                bsDeviceDetailsElement.setDeviceName(device.getDeviceName());
                bsDeviceDetailsElement.setDeviceUUID(device.getDeviceUUID());
                bsDeviceDetailsElement.setDeviceType(device.getOsType());
                if (device.getOsType().toLowerCase().contains("window")) {
                    bsDeviceDetailsElement.setWindowsDevice(true);
                } else {
                    bsDeviceDetailsElement.setWindowsDevice(false);
                }
                bluSyncPortalBackupElement.getDevices().add(bsDeviceDetailsElement);
                DeviceBackupOverView backupOverView = this.deviceManagementService.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID());
                if (backupOverView == null) continue;
                storageUsedForUser += backupOverView.getStorageUtilized();
                bsDeviceDetailsElement.setStorageUsedByDevice(BlusyncPortalDetailsController.formatFileSize(backupOverView.getStorageUtilized()));
            }
            long storageUsedByUser = this.backupService.getStorageUsedByUser(cloudId, user.getUserName());
            bluSyncPortalBackupElement.setStorageUsed(BlusyncPortalDetailsController.formatFileSize(storageUsedByUser));
            modelAndView.addObject((Object)bluSyncPortalBackupElement);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/bsportal/backup/devices/info"}, method={RequestMethod.GET})
    public ModelAndView getUserDevicesInfoByUserName(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("calling bsportal/backup/devices/info ...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            logger.debug("calling bsportal/backup/devices/info 1...");
            User currentUser = new User();
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            userName = this.decodeBase64UTFString(userName);
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                response.setStatus(401);
                return null;
            }
            logger.debug("calling bsportal/backup/devices/info 2...");
            List devices = this.deviceManagementService.getAllBlockedAndUnblockedDeviceForUser(cloudId, cloudName, userName);
            BluSyncPortalBackupElement bluSyncPortalBackupElement = new BluSyncPortalBackupElement();
            bluSyncPortalBackupElement.setUserName(userName);
            bluSyncPortalBackupElement.setDevices(new ArrayList());
            long storageUsedForUser = 0L;
            for (Device device : devices) {
                if (device == null) continue;
                BSDeviceDetailsElement bsDeviceDetailsElement = new BSDeviceDetailsElement();
                bsDeviceDetailsElement.setDeviceName(device.getDeviceName());
                bsDeviceDetailsElement.setDeviceUUID(device.getDeviceUUID());
                bsDeviceDetailsElement.setDeviceType(device.getOsType());
                bsDeviceDetailsElement.setOsVersion(device.getOsVersion());
                bsDeviceDetailsElement.setBlocked(device.isBlocked());
                bsDeviceDetailsElement.setDecoupled(device.isDecoupled());
                bsDeviceDetailsElement.setQuarantineDevice(device.isQuarantineDevice());
                long UADcount = this.auditHistoryService.getUnusualActivityCount(cloudId, cloudName, device.getDeviceName(), device.getUserName(), true, false, true);
                if (UADcount > 0L) {
                    bsDeviceDetailsElement.setUnusualActivity(true);
                }
                logger.debug("..#####.." + device.isCanAdminRestore());
                bsDeviceDetailsElement.setCanAdminRestore(device.isCanAdminRestore());
                if (device.getOsType().toLowerCase().contains("window")) {
                    bsDeviceDetailsElement.setWindowsDevice(true);
                } else {
                    bsDeviceDetailsElement.setWindowsDevice(false);
                }
                bluSyncPortalBackupElement.getDevices().add(bsDeviceDetailsElement);
                DeviceBackupOverView backupOverView = this.deviceManagementService.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID());
                if (backupOverView == null) continue;
                storageUsedForUser += backupOverView.getStorageUtilized();
                bsDeviceDetailsElement.setStorageUsedByDevice(BlusyncPortalDetailsController.formatFileSize(backupOverView.getStorageUtilized()));
            }
            logger.debug("calling bsportal/backup/devices/info 3...");
            BackupPolicy backupPolicy = this.userManagementService.getBackupPolicy(cloudId, currentUser.getPolicyName());
            logger.debug("calling bsportal/backup/devices/info 4...");
            long storageUsedByUser = this.backupService.getStorageUsedByUser(cloudId, userName);
            logger.debug("calling bsportal/backup/devices/info 5 ...");
            bluSyncPortalBackupElement.setStorageUsed(BlusyncPortalDetailsController.formatFileSize(storageUsedByUser));
            bluSyncPortalBackupElement.setStorageUsed(BlusyncPortalDetailsController.formatFileSize(storageUsedByUser));
            if (!(backupPolicy == null || backupPolicy.getEndpointUiPreferences().isEmpty() || backupPolicy.getEndpointUiPreferences().contains("BACKUP_SETTINGS") || currentUser.isAdmin())) {
                response.setHeader("policyconfiguration", "false");
            }
            logger.debug("calling bsportal/backup/devices/info6 ...");
            modelAndView.addObject((Object)bluSyncPortalBackupElement);
            response.setStatus(200);
            logger.debug("end of calling bsportal/backup/devices/info ...");
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
        return modelAndView;
    }

    public static String formatFileSize(long size) {
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : dec.format(m).concat(" MB"));
        return hrSize;
    }

    @RequestMapping(value={"cloud/{cloudName}/bsportal/device/info"}, method={RequestMethod.GET})
    public ModelAndView getDeviceInfo(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("calling bsportal/device/info ...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            List CloudCredentialsList = cl.getCloud().getCloudCredentials();
            CloudCredentials cloudCredentials = new CloudCredentials();
            if (!CollectionUtils.isEmpty((Collection)CloudCredentialsList)) {
                cloudCredentials = (CloudCredentials)CloudCredentialsList.get(0);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return null;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            if (!this.checkIfUserIsValid(authorizationTokens.getUser(), 0, response)) {
                return null;
            }
            String deviceUUID = request.getHeader("deviceUUID");
            User user = authorizationTokens.getUser();
            boolean isServiceAcct = false;
            List cloudCustomisableDetailsList = cl.getCloud().getCloudCustomisableDetails();
            for (CloudCustomisableDetails customisableDetails : cloudCustomisableDetailsList) {
                if (!"Service Account Enabled".equals(customisableDetails.getName())) continue;
                isServiceAcct = true;
            }
            BSDeviceInfoElement bsDeviceInfoElement = this.deviceManagementService.getDeviceInfoForUserAndDeviceUUID(cloudId, cloudName, user.getUserName(), deviceUUID, isServiceAcct);
            for (CloudCustomisableDetails customisableDetails : cloudCustomisableDetailsList) {
                if ("ODB Enabled".equals(customisableDetails.getName())) {
                    bsDeviceInfoElement.setStorageMedia("OneDrive for business");
                } else if ("AzureBlob Enabled".equals(customisableDetails.getName())) {
                    bsDeviceInfoElement.setStorageMedia("Azure Blob");
                } else if ("Google Drive Enabled".equals(customisableDetails.getName()) || "GD Service Account Enabled".equals(customisableDetails.getName())) {
                    bsDeviceInfoElement.setStorageMedia("Google Drive");
                }
                if (cloudCredentials == null || !"localStorage".equalsIgnoreCase(cloudCredentials.getCloudName())) continue;
                bsDeviceInfoElement.setStorageMedia("Local Storage");
            }
            modelAndView.addObject((Object)bsDeviceInfoElement);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/bsportal/device/ah/"}, method={RequestMethod.GET})
    public ModelAndView getDeviceBackupActivityHistory(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("calling bsportal/device/ah ...");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            if (!this.checkIfUserIsValid(authorizationTokens.getUser(), 0, response)) {
                return null;
            }
            String userName = request.getHeader("userName");
            logger.debug(" username ................" + userName);
            String deviceUUID = request.getHeader("deviceUUID");
            Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
            if (device == null) {
                logger.error("...no device found for uuid ... " + deviceUUID);
                response.setStatus(500);
                return null;
            }
            User user = authorizationTokens.getUser();
            if (!StringUtils.isEmpty((String)userName) && (user = this.userManagementService.getUserDetails(cloudId, cloudName, userName)) == null) {
                logger.error(" user is null...." + userName);
                user = authorizationTokens.getUser();
            }
            List<BackupActivityHistoryElement> list = this.backupService.getAllBackupBatchForDevice(cloudId, cloudName, user.getUserName(), device.getDeviceUUID());
            this.setSummaryValues(cloudName, response, cloudId, user, device);
            modelAndView.addObject(list);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
        return modelAndView;
    }

    private void setSummaryValues(String cloudName, HttpServletResponse response, int cloudId, User user, Device device) {
        boolean isLastSuccessfullBackup = false;
        BackupBatch backupBatch = this.backupService.getLastBackupOnly(cloudId, cloudName, user, device, isLastSuccessfullBackup);
        Integer totalNoOfFiles = 0;
        Integer noOfFilesRemaining = 0;
        if (backupBatch != null) {
            String uploadedFiles;
            if (!StringUtils.isEmpty((String)backupBatch.getTotalNoOfFiles())) {
                totalNoOfFiles = Integer.parseInt(backupBatch.getTotalNoOfFiles());
            }
            if (StringUtils.isEmpty((String)(uploadedFiles = backupBatch.getUploadedFiles()))) {
                uploadedFiles = "0/0";
            }
            String[] parts = uploadedFiles.split("/");
            try {
                Integer actualNoOfFiles = Integer.parseInt(parts[1]);
                Integer noOfFilesBackedup = Integer.parseInt(parts[0]);
                noOfFilesRemaining = actualNoOfFiles - noOfFilesBackedup;
                if (noOfFilesRemaining < 0) {
                    noOfFilesRemaining = 0;
                }
                logger.debug("noOfFilesRemaining.." + noOfFilesRemaining);
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(" no detail for uploaded files " + e.getMessage());
            }
        }
        response.setHeader("totalNoOfFiles", totalNoOfFiles.toString());
        response.setHeader("noOfFilesToBeUploaded", noOfFilesRemaining.toString());
    }

    @RequestMapping(value={"/versions/{versionNumber}/clouds/{cloudName}/bsportal/actionstatus"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ActionStatusElement> getDailyBkpOverviewList(@PathVariable(value="versionNumber") String versionNumber1, @PathVariable(value="cloudName") String cloudName1, @RequestParam(value="pageNumber", required=false) Integer pageNumberInteger, @RequestParam(value="recordsPerPage", required=false) Integer recordsCountInteger, @RequestParam(value="startTime") long startDate1, @RequestParam(value="endTime") long endDate1, HttpServletRequest request, HttpServletResponse response) {
        JSONArray jsonArray = new JSONArray();
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        String cloudName = cloudName1;
        String sortParam = "";
        String sortDirection = "";
        int skipValue = 0;
        int recordsCount = 0;
        long startTime = startDate1;
        long endTime = endDate1;
        int pageNumber = 0;
        logger.debug("calling load cloud/{cloudName}/bsportal/actionstatus... ");
        try {
            CloudLicenseTo cl;
            if (pageNumberInteger != null) {
                pageNumber = pageNumberInteger;
                skipValue = pageNumber - 1;
            }
            if (recordsCountInteger != null) {
                recordsCount = recordsCountInteger;
            }
            if (!this.checkLicense(cl = this.licenseService.validateLicense(cloudName), response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            ArrayList<ActionStatusElement> actionStatusElementElementList = new ArrayList();
            try {
                actionStatusElementElementList = this.backupService.getAllBackupBatchBetweenTimeStamps(cloudId, cloudName, startTime, endTime, skipValue, recordsCount, sortParam, sortDirection);
                this.backupService.getCountofAllBackupBatchBetweenTimeStamps(cloudId, cloudName, startTime, endTime);
            }
            catch (Exception e) {
                logger.trace("Error failed to load cloud/{cloudName}/bsportal/actionstatus ..." + e);
                logger.error("Error failed to load cloud/{cloudName}/bsportal/actionstatus ..." + e.getMessage());
            }
            response.setStatus(200);
            jsonArray.put(actionStatusElementElementList);
            logger.debug("jsonArray" + jsonArray.length());
            return actionStatusElementElementList;
        }
        catch (BaseException e) {
            response.setStatus(204);
            logger.error("Base Exception :" + e.getMessage());
            logger.trace("", (Throwable)e);
            return null;
        }
    }
}

