/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.backup.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.backup.delegate.BackupDelegate;
import com.parablu.bluvault.backup.delegate.BackupUploadDelegate;
import com.parablu.bluvault.backup.delegate.ChunkableBackupUploadDelegate;
import com.parablu.bluvault.backup.exception.ResourceFunnelException;
import com.parablu.bluvault.backup.mem.MemoryStore;
import com.parablu.bluvault.backup.service.BackupBatchAHService;
import com.parablu.bluvault.backup.service.BackupDeleteTimerService;
import com.parablu.bluvault.backup.service.BackupService;
import com.parablu.bluvault.backup.to.BackupRequestTO;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.CloudSettingsService;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.AuthorizationService;
import com.parablu.cloud.security.service.DeviceAndUserSecurityService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.cloud.security.to.DeviceStatusTo;
import com.parablu.helper.element.ErrorElement;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.BackupBatchElement;
import com.parablu.paracloud.element.BackupElement;
import com.parablu.paracloud.element.BackupFileElement;
import com.parablu.paracloud.element.BackupHistoryFileElement;
import com.parablu.paracloud.element.BackupListElement;
import com.parablu.paracloud.element.BackupValidationElement;
import com.parablu.paracloud.element.BluKryptBackupFileElement;
import com.parablu.paracloud.element.ChunkFileInfoElement;
import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.paracloud.element.FileElement;
import com.parablu.paracloud.element.FileListElement;
import com.parablu.paracloud.element.FoldersListElement;
import com.parablu.paracloud.element.MailElement;
import com.parablu.paracloud.element.MailListElement;
import com.parablu.paracloud.element.PGInfoElement;
import com.parablu.paracloud.element.UserElement;
import com.parablu.paracloud.element.response.BackupListResponseElement;
import com.parablu.paracloud.element.response.DeviceElementResponse;
import com.parablu.paracloud.element.response.ResponseMetadataElement;
import com.parablu.paracloud.util.PathConversionHelper;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupFile;
import com.parablu.pcbd.domain.BackupLog;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.Policy;
import com.parablu.pcbd.domain.User;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BackupController
extends BaseController {
    public static final String NOT_VALID_CLOUD_LICENSE_INSIDE_FILES_CHUNK_ALL = " NOT VALID CLOUD LICENSE  inside /files/chunk/all ";
    public static final String NOT_A_VALID_TOKEN_INSIDE_FILES_CHUNK = " NOT A VALID TOKEN  inside /files/chunk ";
    private static Logger logger = LogManager.getLogger(BackupController.class);
    @Autowired
    private BackupDelegate backupDelegate;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private DeviceAndUserSecurityService deviceAndUserSecurityService;
    @Autowired
    private AuthorizationService authorizationService1;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Autowired
    private BackupUploadDelegate backupUploadDelegate;
    @Autowired
    private ChunkableBackupUploadDelegate chunkableBackupUploadDelegate;
    @Autowired
    private BackupService backupService;
    @Autowired
    private DeviceManagementService deviceManagementService;
    @Autowired
    private BackupDeleteTimerService backupDeleteTimerService;
    @Autowired
    private UserManagementService managementService;
    @Autowired
    private CloudSettingsService cloudSettingsService;
    @Autowired
    private BackupBatchAHService backupBatchAHService;
    private static final String STOP_BACKUP_ERROR_CODE = "1207";
    private static final String XML_VIEW1 = "xmlview";
    private static final String USER_NAME = "userName";
    private static final String INVALID_REQUEST = "Invalid request.";
    private static final String DATA_ACCESS_EXCEPTION = "DataAccessException  :";
    private static final String BASE_EXCEPTION = "BaseException  :";
    private static final String CRAWL_LIMIT = "crawlLimit";
    private static final String FILE_PATH = "filePath";
    private static final String NUM54CBD580E4B03356FB13A6E4 = "54cbd580e4b03356fb13a6e4";
    private static final String DEVICE_ID = "deviceId";
    private static final String DEVICE_ID_EMPTY = " DEVICEID empty ........";
    private static final String BEFORE_CHECK_LICENSE = "Befor checkLicense  ... ";
    private static final String AFTER_CHECK_LICENSE_1 = "after checkLicense 1 ... ";
    private static final String CHECK_LICENSE_FAILED = "checkLicense failed ... ";
    private static final String AFTER_CHECK_LICENSE_2 = "after checkLicense 2  ... ";
    private static final String BEFORE_AUTHORIZATION_TOKEN = "before authorizationTokens  ... ";
    private static final String CHECK_IF_USER_IS_VALID_FAILED = "checkIfUserIsValid failed ... ";
    private static final String AFTER_VALIDATION = "after validation  ... ";
    private static final String EXCEPTION = "Exception  :";
    private static final String CALLING_BACKUP_FILES_VERSION = "calling backup/files/version ...";
    private static final String FILE_NAME = "fileName";
    private static final String PATH = "..path...";
    private static final String CALLING_BACKUP_FILES_VERSION_BEFORE_GET_VERSIONS = "calling backup/files/version before getVersions ...";
    private static final String ERROR_MESSAGE = "errorMessage";
    private static final String IO_EXCEPTION = "IOException ";
    private static final String DEVICE_UUID = "deviceUUID";
    private static final String RESOURCE_FUNNEL_EXCEPTION = "ResourceFunnelException ";
    private static final String INVALID_CLOUD_NAME = "Invalid cloud name ....";
    private static final String BACKUP_ID = "backupId";
    private static final String CALLING_SAVE_BACKUP_FILE_INFO_IN_COUCH_DB = "calling save backup file info in couch DB ...";
    private static final String ERROR_FAILED_TO_SAVE_BACKUP_FILE_INFO = "Error failed to save backup file info ...";
    private static final String END_OF_CALLING_AUTHENTICATE_ONEDRIVE = "end of calling /authenticateOneDrive ...";
    private static final String GZIP_VIEW1 = "gzipview";
    private static final String ERROR_CHANGES_DURING_VALIDATE = " Error changes during validate ............ ";
    private static final String PAGE_NUMBER = "pageNumber";
    private static final String RECORDS_COUNT = "recordsPerPage";
    private static final String EQUALS_SIGN = "=";
    private static final String PARAM_SEPERATOR = "&";

    @RequestMapping(value={"cloud/{cloudName}/backup/device/all"}, method={RequestMethod.GET})
    public ModelAndView getAllRegisteredBackupDevices(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        DeviceElementResponse devices = new DeviceElementResponse();
        modelAndView.setViewName(XML_VIEW1);
        logger.debug("calling backup/device/all...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            DeviceStatusTo code = this.deviceAndUserSecurityService.validateDeviceForBackup(cloudId, cloudName, token, cl.getCloud());
            CloudPropertyElement cloudPropertyElement = this.cloudSettingsService.getCloudPropertyElement(cloudId);
            if (!this.checkLicense(code.getStatus(), response)) {
                return null;
            }
            User user = new User();
            if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
                return null;
            }
            if (!this.checkIfUserIsValid(user, 0, response)) {
                return null;
            }
            if (user.isAdmin()) {
                ArrayList<DeviceElement> deviceElements = new ArrayList<DeviceElement>();
                List<DeviceElement> devList = this.backupService.getAllBackedUpDevice(cloudId, cloudName);
                this.getValidDevices(cloudName, cl, cloudId, user, deviceElements, devList);
                logger.debug("device list " + deviceElements.size());
                List blockedAssignedDevices = this.deviceManagementService.getAllUserDeviceAccessControl(cloudId);
                if (!CollectionUtils.isEmpty((Collection)blockedAssignedDevices)) {
                    deviceElements.addAll(blockedAssignedDevices);
                }
                devices.setDevices(deviceElements);
            } else if (user.isReadOnlyAdmin() && !user.isDelegatedAdmin() && PCHelperConstant.getPropertyFileValueAllowAdminToRestoreAll()) {
                ArrayList<DeviceElement> policyAdminDevices = new ArrayList<DeviceElement>();
                List<String> userNamesFromBackupPoliciesAdmin = new ArrayList();
                List backupPoliciesAdmin = new ArrayList();
                if (!CollectionUtils.isEmpty((Collection)user.getBackupPoliciesAdmin())) {
                    List devicesByUserNames;
                    backupPoliciesAdmin = user.getBackupPoliciesAdmin();
                    userNamesFromBackupPoliciesAdmin = this.managementService.getUserNamesByBackupPoliciesAdmin(cloudId, backupPoliciesAdmin);
                    if (!backupPoliciesAdmin.contains(user.getPolicyName())) {
                        userNamesFromBackupPoliciesAdmin.add(user.getUserName());
                    }
                    if (!CollectionUtils.isEmpty((Collection)(devicesByUserNames = this.deviceManagementService.getDevicesByUserNames(cloudId, userNamesFromBackupPoliciesAdmin)))) {
                        policyAdminDevices.addAll(devicesByUserNames);
                    }
                    logger.debug("device list " + policyAdminDevices.size());
                }
                if (!CollectionUtils.isEmpty((Collection)user.getOdbPoliciesAdmin())) {
                    List devicesByUserNames;
                    List officePoliciesAdmin = new ArrayList();
                    List userNamesFromOfficePoliciesAdmin = new ArrayList();
                    officePoliciesAdmin = user.getOdbPoliciesAdmin();
                    userNamesFromOfficePoliciesAdmin = this.managementService.getUserNamesByOfficePoliciesAdmin(cloudId, officePoliciesAdmin);
                    if (!officePoliciesAdmin.contains(user.getOneDrivePolicyName())) {
                        userNamesFromBackupPoliciesAdmin.add(user.getUserName());
                    }
                    if (!CollectionUtils.isEmpty((Collection)(devicesByUserNames = this.deviceManagementService.getDevicesByUserNames(cloudId, userNamesFromOfficePoliciesAdmin)))) {
                        policyAdminDevices.addAll(devicesByUserNames);
                    }
                }
                ArrayList<DeviceElement> deviceElements = new ArrayList<DeviceElement>();
                this.getValidDevices(cloudName, cl, cloudId, user, deviceElements, policyAdminDevices);
                logger.debug("device list " + deviceElements.size());
                devices.setDevices(deviceElements);
            } else {
                List devList = this.deviceManagementService.getDevicesForUser(cloudId, cloudName, user.getUserName());
                ArrayList<DeviceElement> activeUserDevices = new ArrayList<DeviceElement>();
                for (DeviceElement deviceElement : devList) {
                    if (cloudPropertyElement.isRestoreBlockedDevices()) {
                        activeUserDevices.add(deviceElement);
                        continue;
                    }
                    if (deviceElement.isBlocked()) continue;
                    activeUserDevices.add(deviceElement);
                }
                if (user != null) {
                    List devByOwner = this.deviceManagementService.getUserDeviceAccessControlByUserName(cloudId, user.getUserName());
                    logger.debug(".....devByOwner...." + devByOwner.size());
                    if (!CollectionUtils.isEmpty((Collection)devByOwner)) {
                        activeUserDevices.addAll(devByOwner);
                    }
                }
                logger.debug("device list " + activeUserDevices.size());
                devices.setDevices(activeUserDevices);
            }
            modelAndView.addObject((Object)devices);
            response.setStatus(200);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug(BASE_EXCEPTION + e.getMessage());
            logger.trace(BASE_EXCEPTION + e);
            ErrorElement err = this.createErrorElement();
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        return modelAndView;
    }

    private void getValidDevices(String cloudName, CloudLicenseTo cl, int cloudId, User user, List<DeviceElement> deviceElements, List<DeviceElement> devList) {
        logger.debug("inside get valid devices.....");
        List backupPolicies = this.managementService.getAllBackupPolicies(cloudId);
        Map result = backupPolicies.stream().collect(Collectors.toMap(Policy::getPolicyName, Function.identity()));
        List allActiveUsers = this.managementService.getAllActiveUsers(cloudId);
        Map<String, String> userPolicyMap = allActiveUsers.stream().filter(p -> p.getPolicyName() != null).filter(u -> u.getPolicyName() != null).collect(Collectors.toMap(User::getUserName, User::getPolicyName, (u1, u2) -> u1));
        logger.debug(backupPolicies.size() + "....START getValidDevices.....");
        CloudPropertyElement cloudPropertyElement = this.cloudSettingsService.getCloudPropertyElement(cloudId);
        for (DeviceElement devElement : devList) {
            boolean isValidDevice = false;
            if (user.getUserName().equalsIgnoreCase(devElement.getUserName())) {
                isValidDevice = true;
                logger.debug("...setCanAdminRestore.....");
                devElement.setCanAdminRestore(true);
            } else {
                String policyForUser;
                UserElement userByUserName = this.managementService.getUserElementByUserName(cl.getCloud(), devElement.getUserName());
                if (userPolicyMap != null && !StringUtils.isEmpty((String)(policyForUser = userPolicyMap.get(devElement.getUserName())))) {
                    BackupPolicy backupPolicy = (BackupPolicy)result.get(policyForUser);
                    if (cloudPropertyElement.isOverridePolicySettings() && cloudPropertyElement.getCanAdminRestoreAll()) {
                        if (cloudPropertyElement.isAllowEndUserTocontrolRestore() && devElement.isCanAdminRestore()) {
                            isValidDevice = true;
                            logger.debug("...setCanAdminRestore.....");
                        } else if (!cloudPropertyElement.isAllowEndUserTocontrolRestore()) {
                            isValidDevice = true;
                            logger.debug("...setCanAdminRestore.....");
                        }
                    } else if (!cloudPropertyElement.isOverridePolicySettings() && backupPolicy != null && backupPolicy.isCanAdminRestore()) {
                        if (!backupPolicy.isAllowEndUserTocontrolRestore()) {
                            logger.debug("...setCanAdminRestore.....");
                            isValidDevice = true;
                        } else if (backupPolicy.isAllowEndUserTocontrolRestore() && devElement.isCanAdminRestore()) {
                            logger.debug("...setCanAdminRestore.....");
                            isValidDevice = true;
                        }
                    }
                }
                if (!userByUserName.isActive()) {
                    isValidDevice = false;
                } else if ((devElement.getDeviceType() == null || devElement.getDeviceType().equalsIgnoreCase("BACKUP")) && !userByUserName.isBackupEnabled()) {
                    isValidDevice = false;
                } else if (devElement.getDeviceType().equalsIgnoreCase("ONEDRIVE") && !userByUserName.isOnedriveBkpEnabled()) {
                    isValidDevice = false;
                } else if (devElement.getDeviceType().equalsIgnoreCase("OUTLOOK") && !userByUserName.isExchangeBkpEnabled()) {
                    isValidDevice = false;
                }
            }
            if (isValidDevice) {
                deviceElements.add(devElement);
                continue;
            }
            logger.debug(devElement.getDeviceName() + " backuppolicy ");
        }
        logger.debug("....END getValidDevices.....");
    }

    @RequestMapping(value={"cloud/{cloudName}/backup/thrash/all"}, method={RequestMethod.DELETE})
    public void deleteThrashResources(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(XML_VIEW1);
        logger.debug("calling /files/thrash/all ...");
        String userName = request.getHeader(USER_NAME);
        String deviceUUID = request.getHeader("device");
        logger.debug("calling /files/thrash/all ...");
        try {
            User user;
            String token;
            logger.debug("username:" + userName);
            if (StringUtils.isBlank((String)userName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            logger.debug("Calling thrash for all files ");
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token = request.getHeader("token"), user = new User(), response)) {
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
            if (!authorizationTokens.getUser().isAdmin() && !user.getUserId().equals((Object)authorizationTokens.getUser().getUserId())) {
                response.setStatus(401);
                return;
            }
            List<BackUpImage> backImages = this.backupService.getAlldeletedResourceRevision(cloudId, cloudName, device);
            this.backupDeleteTimerService.deleteBackUpEntryFromTrashDirectly(cloudId, cloudName, cl.getCloud(), backImages);
            logger.debug("status: 200");
            response.setStatus(200);
        }
        catch (DataAccessException e) {
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            response.setStatus(400);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/backup/thrash"}, method={RequestMethod.DELETE})
    public void deleteThrashResource(@PathVariable(value="cloudName") String cloudName1, @RequestBody FileElement fileElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(XML_VIEW1);
        String userName = request.getHeader(USER_NAME);
        String deviceUUID = request.getHeader("device");
        logger.debug(userName + "calling /backup/thrash ..." + deviceUUID);
        try {
            if (StringUtils.isBlank((String)userName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.debug("Invalid license ......");
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            logger.debug("before performAuthorization ......" + token);
            User user = new User();
            if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
            ObjectId deviceUserId = user.getUserId();
            ObjectId tokenUserId = authorizationTokens.getUser().getUserId();
            logger.debug(deviceUserId + " userId ......" + tokenUserId);
            if (!deviceUserId.equals((Object)tokenUserId)) {
                logger.debug("Invalid userId ......");
                response.setStatus(401);
                return;
            }
            this.backupDeleteTimerService.deleteBackUpEntryFromTrashDirectly(cloudId, cloudName, cl.getCloud(), fileElement, device);
            response.setStatus(200);
        }
        catch (DataAccessException e) {
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            response.setStatus(400);
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/crawl/backup"}, method={RequestMethod.POST})
    public ModelAndView validateBackup(@PathVariable(value="cloudName") String cloudName, @RequestBody BackupValidationElement backupListElement, HttpServletRequest request, HttpServletResponse response) {
        response.setStatus(400);
        return null;
    }

    private synchronized int getCurrentCrawlLimit() {
        int crawlLimit = 0;
        if (MemoryStore.get(CRAWL_LIMIT) != null) {
            crawlLimit = (Integer)MemoryStore.get(CRAWL_LIMIT);
        }
        logger.debug("@@@CURRENT-Crawl count ............. " + crawlLimit);
        return crawlLimit;
    }

    private synchronized void incrementCrawlLimit() {
        int crawlLimit = this.getCurrentCrawlLimit();
        MemoryStore.delete(CRAWL_LIMIT);
        MemoryStore.add(CRAWL_LIMIT, ++crawlLimit);
        logger.debug("@@@INCREMENT Crawl count ............. " + crawlLimit);
    }

    private synchronized void decrementCrawlLimit() {
        int crawlLimit = this.getCurrentCrawlLimit();
        if (crawlLimit > 0) {
            --crawlLimit;
        }
        MemoryStore.delete(CRAWL_LIMIT);
        MemoryStore.add(CRAWL_LIMIT, crawlLimit);
        logger.debug("@@@DECREMENT Crawl count ............. " + crawlLimit);
    }

    @RequestMapping(value={"cloud/{cloudName}/backup/files/name"}, method={RequestMethod.GET})
    public ModelAndView getChildrenForFolder(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(XML_VIEW1);
        logger.trace("calling /files/child ...");
        String devicePath = request.getHeader(FILE_PATH);
        try {
            List<BackupElement> backupElements = this.getBackupElements(cloudName, request, response, devicePath);
            ArrayList<String> fileNamesList = new ArrayList<String>();
            for (BackupElement backupElement : backupElements) {
                if (!backupElement.isFolder()) continue;
                fileNamesList.add(backupElement.getFileName());
            }
            FoldersListElement strList = new FoldersListElement();
            strList.setFolderNames(fileNamesList);
            modelAndView.addObject((Object)strList);
            response.setStatus(200);
            return modelAndView;
        }
        catch (DataAccessException e) {
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            response.setStatus(400);
        }
        return null;
    }

    private List<BackupElement> getBackupElements(String cloudName1, HttpServletRequest request, HttpServletResponse response, String devicePath) {
        String cloudName = cloudName1;
        if (StringUtils.isEmpty((String)request.getHeader(DEVICE_ID))) {
            logger.debug(DEVICE_ID_EMPTY);
            response.setStatus(400);
            return null;
        }
        logger.debug(DEVICE_ID + request.getHeader(DEVICE_ID));
        ObjectId deviceId = new ObjectId(request.getHeader(DEVICE_ID));
        logger.debug(BEFORE_CHECK_LICENSE + cloudName);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        logger.debug(AFTER_CHECK_LICENSE_1);
        if (!this.checkLicense(cl, response)) {
            logger.debug(CHECK_LICENSE_FAILED);
            return null;
        }
        logger.debug(AFTER_CHECK_LICENSE_2);
        boolean isrestoreDeletedFile = false;
        String restoreDeletedFileStr = request.getHeader("restoreDeletedFile");
        if (!StringUtils.isEmpty((String)restoreDeletedFileStr)) {
            isrestoreDeletedFile = Boolean.valueOf(restoreDeletedFileStr);
        }
        logger.debug("...isrestoreDeletedFile..." + isrestoreDeletedFile);
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        String token = request.getHeader("token");
        if (!this.performAuthorization(cloudId, cloudName, token, response)) {
            logger.debug("performAuthorization failed ... ");
            return null;
        }
        logger.debug(BEFORE_AUTHORIZATION_TOKEN);
        AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
        if (!this.checkIfUserIsValid(authorizationTokens.getUser(), 0, response)) {
            logger.debug(CHECK_IF_USER_IS_VALID_FAILED);
            return null;
        }
        logger.debug(AFTER_VALIDATION);
        return this.backupService.getChildren(cloudId, cloudName, devicePath, deviceId, isrestoreDeletedFile);
    }

    private List<MailElement> getMailBackupElements(String cloudName1, HttpServletRequest request, HttpServletResponse response, String devicePath, int skipValue, int recordsCount, Device device) {
        String cloudName = cloudName1;
        logger.debug(BEFORE_CHECK_LICENSE + cloudName);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        logger.debug(AFTER_CHECK_LICENSE_1);
        if (!this.checkLicense(cl, response)) {
            logger.debug(CHECK_LICENSE_FAILED);
            return null;
        }
        logger.debug(AFTER_CHECK_LICENSE_2);
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        String token = request.getHeader("token");
        if (!this.performAuthorization(cloudId, cloudName, token, response)) {
            logger.debug("performAuthorization failed ... ");
            return null;
        }
        logger.debug(BEFORE_AUTHORIZATION_TOKEN);
        AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
        if (!this.checkIfUserIsValid(authorizationTokens.getUser(), 0, response)) {
            logger.debug(CHECK_IF_USER_IS_VALID_FAILED);
            return null;
        }
        logger.debug(AFTER_VALIDATION);
        return this.backupService.getMailChildren(cloudId, cloudName, devicePath, device, skipValue, recordsCount);
    }

    @RequestMapping(value={"cloud/{cloudName}/backup/files/child"}, method={RequestMethod.GET})
    public ModelAndView getFileNamesOfFolder(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(XML_VIEW1);
        logger.debug("calling /backup/files/child ...");
        String devicePath = request.getHeader(FILE_PATH);
        if (StringUtils.isNotEmpty((String)devicePath)) {
            devicePath = this.decodeBase64UTFString(request.getHeader(FILE_PATH));
        }
        try {
            List<BackupElement> backupElements = this.getBackupElements(cloudName, request, response, devicePath);
            BackupListElement backupListElement = new BackupListElement();
            backupListElement.setFileElementList(backupElements);
            modelAndView.addObject((Object)backupListElement);
            response.setStatus(200);
            return modelAndView;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(400);
            return null;
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/backup/mail/msgs/child"}, method={RequestMethod.GET})
    @ResponseBody
    public Object getMailMsgsOfFolder(@PathVariable(value="cloudName") String cloudName1, @RequestParam(value="pageNumber", required=false) Integer pageNumberInteger, @RequestParam(value="recordsPerPage", required=false) Integer recordsCountInteger, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(XML_VIEW1);
        int pageNumber = 0;
        logger.debug("calling /backup/mail/msgs/child ..." + request.getHeader(FILE_PATH));
        String devicePath = request.getHeader(FILE_PATH);
        if (StringUtils.isNotEmpty((String)devicePath)) {
            devicePath = this.decodeBase64UTFString(request.getHeader(FILE_PATH));
        }
        int skipValue = 0;
        int recordsCount = 0;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            logger.debug(AFTER_CHECK_LICENSE_1);
            if (!this.checkLicense(cl, response)) {
                logger.debug(CHECK_LICENSE_FAILED);
                return null;
            }
            logger.debug(".....skip and record count .." + skipValue + ".." + recordsCount);
            if (pageNumberInteger != null) {
                pageNumber = pageNumberInteger;
                skipValue = pageNumber - 1;
            }
            if (recordsCountInteger != null) {
                recordsCount = recordsCountInteger;
                recordsCount = 50;
            }
            recordsCount = PCHelperConstant.getReportDisplayRecords();
            logger.debug(".....skip and record count1 .." + skipValue + ".." + recordsCount);
            if (StringUtils.isEmpty((String)request.getHeader(DEVICE_ID))) {
                logger.debug(DEVICE_ID_EMPTY);
                response.setStatus(400);
                return null;
            }
            logger.debug(DEVICE_ID + request.getHeader(DEVICE_ID));
            ObjectId deviceId = new ObjectId(request.getHeader(DEVICE_ID));
            Device device = this.backupService.getDeviceById(cl.getCloud().getCloudId(), deviceId);
            List<MailElement> mailElements = this.getMailBackupElements(cloudName, request, response, devicePath, skipValue, recordsCount, device);
            if (CollectionUtils.isEmpty(mailElements)) {
                mailElements = new ArrayList<MailElement>();
            }
            MailListElement mailElementList = new MailListElement();
            mailElementList.setMailElementList(mailElements);
            modelAndView.addObject((Object)mailElementList);
            response.setStatus(200);
            Map paramSet = request.getParameterMap();
            logger.debug(mailElements.size() + "start of calling count for /backup/mail/msgs/child ..." + device.getDeviceUUID() + "..." + devicePath);
            long totalRecordsCount = this.backupService.getTotalMails(cl.getCloud().getCloudId(), devicePath, device);
            logger.debug("end of calling /backup/mail/msgs/child ..." + totalRecordsCount);
            return this.toJSON(200, this.getMetadataElement(recordsCount, pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), mailElementList);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(400);
            return this.toJSON(400);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/backup/mail/msg/"}, method={RequestMethod.GET})
    public ModelAndView getMessageInfo(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug(request.getHeader(BACKUP_ID) + ".. start of cloud/{cloudName}/backup/mail/msg/..." + request.getHeader(DEVICE_ID));
        ObjectId deviceId = new ObjectId(NUM54CBD580E4B03356FB13A6E4);
        ObjectId backupId = new ObjectId(NUM54CBD580E4B03356FB13A6E4);
        try {
            String token;
            if (StringUtils.isEmpty((String)request.getHeader(DEVICE_ID)) && StringUtils.isEmpty((String)request.getHeader(BACKUP_ID))) {
                logger.error("...deviceid or backupId is not sent....");
                response.setStatus(400);
                return null;
            }
            deviceId = new ObjectId(request.getHeader(DEVICE_ID));
            backupId = new ObjectId(request.getHeader(BACKUP_ID));
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            if (!this.checkIfUserIsValid(authorizationTokens.getUser(), 0, response)) {
                return null;
            }
            Device device = this.backupService.getDeviceById(cloudId, deviceId);
            MailElement mailElement = this.backupService.getMailBackUpImageInfo(cloudId, device, backupId);
            modelAndView.addObject((Object)mailElement);
            response.setStatus(200);
            logger.debug("...end cloud/{cloudName}/backup/mail/msg/ ...." + mailElement.getTaskSubject() + "...." + mailElement.getTaskDueDate());
            logger.debug("...end of calling cloud/{cloudName}/backup/mail/msg/ ...." + mailElement.getBackupId() + "...." + mailElement.getUserName());
        }
        catch (Exception e) {
            logger.trace(BASE_EXCEPTION + e);
            logger.error(BASE_EXCEPTION + e.getMessage());
            response.setStatus(400);
            return null;
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/backup/files/version"}, method={RequestMethod.GET})
    public ModelAndView getVersions(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug(CALLING_BACKUP_FILES_VERSION);
        String devicePath = request.getHeader(FILE_PATH);
        String fileName = request.getHeader(FILE_NAME);
        if (StringUtils.isNotEmpty((String)devicePath)) {
            devicePath = this.decodeBase64UTFString(request.getHeader(FILE_PATH));
        }
        if (StringUtils.isNotEmpty((String)fileName)) {
            fileName = this.decodeBase64UTFString(request.getHeader(FILE_NAME));
        }
        ObjectId deviceId = new ObjectId(NUM54CBD580E4B03356FB13A6E4);
        try {
            if (StringUtils.isEmpty((String)request.getHeader(DEVICE_ID))) {
                response.setStatus(400);
                return null;
            }
            deviceId = new ObjectId(request.getHeader(DEVICE_ID));
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            logger.debug("calling backup/files/version before json view getVersions ..." + deviceId + FILE_NAME + fileName + PATH + devicePath);
            Device device = this.backupService.getDeviceById(cloudId, deviceId);
            logger.debug(CALLING_BACKUP_FILES_VERSION_BEFORE_GET_VERSIONS);
            List<BackupElement> backupElements = this.backupService.getVersions(cloudId, cloudName, fileName, devicePath, device, "");
            logger.debug("calling backup/files/version after getVersions ...");
            BackupListElement backupListElement = new BackupListElement();
            backupListElement.setFileElementList(backupElements);
            modelAndView.addObject((Object)backupListElement);
            response.setStatus(200);
            logger.debug("end of backup/files/version after getVersions ...");
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            response.setStatus(400);
            return null;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/cloud/{cloudName}/backup/agent/files/version"}, method={RequestMethod.GET})
    public ModelAndView getVersionsForAgent(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(XML_VIEW1);
        logger.debug("calling backup/agent/files/version ...");
        String devicePath = request.getHeader(FILE_PATH);
        String fileName = request.getHeader(FILE_NAME);
        response.setContentType("text/html; charset=UTF-8");
        String headerEncoding = request.getHeader("header-encoding");
        if (StringUtils.isNotEmpty((String)headerEncoding) && "base64".equalsIgnoreCase(headerEncoding) && StringUtils.isNotEmpty((String)devicePath)) {
            devicePath = this.decodeBase64UTFString(request.getHeader(FILE_PATH));
            logger.debug(devicePath + ".................");
        }
        String serverModifiedTime = "";
        if (!StringUtils.isEmpty((String)request.getHeader("pointIntimeRestoreTimeStamp"))) {
            serverModifiedTime = request.getHeader("pointIntimeRestoreTimeStamp");
        }
        logger.debug(".....serverModifiedTime...." + serverModifiedTime);
        if (StringUtils.isNotEmpty((String)headerEncoding) && "base64".equalsIgnoreCase(headerEncoding) && StringUtils.isNotEmpty((String)fileName)) {
            fileName = this.decodeBase64UTFString(request.getHeader(FILE_NAME));
            logger.debug(fileName + ".................");
        }
        try {
            if (StringUtils.isEmpty((String)request.getHeader(DEVICE_ID))) {
                response.setStatus(400);
                return null;
            }
            ObjectId deviceId = new ObjectId(request.getHeader(DEVICE_ID));
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            logger.debug("calling backup/agent/files/version before json view getVersions ..." + deviceId + FILE_NAME + fileName + PATH + devicePath);
            Device device = this.backupService.getDeviceById(cloudId, deviceId);
            logger.debug(CALLING_BACKUP_FILES_VERSION_BEFORE_GET_VERSIONS);
            List<BackupElement> backupElements = this.backupService.getVersions(cloudId, cloudName, fileName, devicePath, device, serverModifiedTime);
            logger.debug("calling backup/agent/files/version after getVersions ...");
            BackupListElement backupListElement = new BackupListElement();
            backupListElement.setFileElementList(backupElements);
            modelAndView.addObject((Object)backupListElement);
            response.setStatus(200);
            logger.debug("end of backup/agent/files/version after getVersions ...");
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            response.setStatus(400);
            return null;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/backup/agent/files/version"}, method={RequestMethod.GET})
    public ModelAndView getVersionsForAgentforUPL(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(XML_VIEW1);
        logger.debug("calling backup/agent/files/version ...");
        String devicePath = request.getHeader(FILE_PATH);
        String fileName = request.getHeader(FILE_NAME);
        ObjectId deviceId = new ObjectId(NUM54CBD580E4B03356FB13A6E4);
        try {
            if (StringUtils.isEmpty((String)request.getHeader(DEVICE_ID))) {
                response.setStatus(400);
                return null;
            }
            deviceId = new ObjectId(request.getHeader(DEVICE_ID));
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            String serverModifiedTime = "";
            if (!StringUtils.isEmpty((String)request.getHeader("pointIntimeRestoreTimeStamp"))) {
                serverModifiedTime = request.getHeader("pointIntimeRestoreTimeStamp");
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            logger.debug("calling backup/agent/files/version before json view getVersions ..." + deviceId + FILE_NAME + fileName + PATH + devicePath);
            Device device = this.backupService.getDeviceById(cloudId, deviceId);
            logger.debug(CALLING_BACKUP_FILES_VERSION_BEFORE_GET_VERSIONS);
            List<BackupElement> backupElements = this.backupService.getVersions(cloudId, cloudName, fileName, devicePath, device, serverModifiedTime);
            logger.debug("calling backup/agent/files/version after getVersions ...");
            BackupListElement backupListElement = new BackupListElement();
            backupListElement.setFileElementList(backupElements);
            modelAndView.addObject((Object)backupListElement);
            response.setStatus(200);
            logger.debug("end of backup/agent/files/version after getVersions ...");
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            response.setStatus(400);
            return null;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/backup/portal/files/version"}, method={RequestMethod.GET})
    public ModelAndView getVersionsForPortal(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("calling backup/portal/files/version ...");
        String devicePath = request.getHeader(FILE_PATH);
        String fileName = request.getHeader(FILE_NAME);
        ObjectId deviceId = new ObjectId(NUM54CBD580E4B03356FB13A6E4);
        try {
            logger.debug("DEVICE ::::::::::: " + request.getHeader(DEVICE_ID));
            if (StringUtils.isEmpty((String)request.getHeader(DEVICE_ID))) {
                response.setStatus(400);
                return null;
            }
            deviceId = new ObjectId(request.getHeader(DEVICE_ID));
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            logger.debug("calling backup/portal/files/version before json view getVersions ..." + deviceId + FILE_NAME + fileName + PATH + devicePath);
            Device device = this.backupService.getDeviceById(cloudId, deviceId);
            logger.debug(CALLING_BACKUP_FILES_VERSION_BEFORE_GET_VERSIONS);
            List<BackupElement> backupElements = this.backupService.getVersions(cloudId, cloudName, fileName, devicePath, device, "");
            logger.debug("calling backup/portal/files/version after getVersions ...");
            BackupListElement backupListElement = new BackupListElement();
            backupListElement.setFileElementList(backupElements);
            modelAndView.addObject((Object)backupListElement);
            response.setStatus(200);
            logger.debug("end of backup/portal/files/version after getVersions ...");
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/backup/files/info"}, method={RequestMethod.GET})
    public ModelAndView getBackUpFileInfo(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(XML_VIEW1);
        logger.trace(CALLING_BACKUP_FILES_VERSION);
        String devicePath = request.getHeader(FILE_PATH);
        String fileName = request.getHeader(FILE_NAME);
        ObjectId deviceId = new ObjectId(NUM54CBD580E4B03356FB13A6E4);
        try {
            String token;
            if (StringUtils.isEmpty((String)request.getHeader(DEVICE_ID))) {
                response.setStatus(400);
                return null;
            }
            deviceId = new ObjectId(request.getHeader(DEVICE_ID));
            if (StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)devicePath)) {
                response.setStatus(400);
                return null;
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            if (!this.checkIfUserIsValid(authorizationTokens.getUser(), 0, response)) {
                return null;
            }
            Device device = this.backupService.getDeviceById(cloudId, deviceId);
            BackupElement backupElement = this.backupService.getBackUpImageInfo(cloudId, cloudName, fileName, devicePath, device);
            modelAndView.addObject((Object)backupElement);
            response.setStatus(200);
        }
        catch (DataAccessException e) {
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            response.setStatus(400);
            return null;
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/backup/addfolder"}, method={RequestMethod.POST})
    public ModelAndView addFolderToBackup(@PathVariable(value="cloudName") String cloudName1, @RequestBody BackupElement backupElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling /backup/addfolder ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(XML_VIEW1);
        String token = request.getHeader("token");
        try {
            User user;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.error("INVALID CloudLicense CODE ...." + cl.getCloudLicenseStatus());
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token, user = new User(), response)) {
                return null;
            }
            DeviceStatusTo code = this.deviceAndUserSecurityService.validateDeviceForBackup(cloudId, cloudName, token, cl.getCloud());
            if (!this.checkLicense(code.getStatus(), response)) {
                logger.error("INVALID DEVICE CODE ...." + code.getStatus());
                return null;
            }
            if (!this.checkIfUserIsValid(user, 0, response)) {
                logger.error("INVALID USER CODE ...." + code.getStatus());
                return null;
            }
            BackupRequestTO backupRequestTO = this.backupService.checkIfBaseFolderExists(cloudId, cloudName, code.getDevice(), backupElement);
            if (backupRequestTO.isConflict()) {
                response.setStatus(200);
                modelAndView.addObject((Object)backupRequestTO.getBackupElement());
            } else {
                response.setStatus(201);
                modelAndView.addObject((Object)backupRequestTO.getBackupElement());
            }
        }
        catch (DataAccessException e) {
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            response.setStatus(500);
            response.setHeader(ERROR_MESSAGE, e.getMessage());
            return null;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            response.setHeader(ERROR_MESSAGE, e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/backup/roots"}, method={RequestMethod.GET})
    public ModelAndView getRootBackups(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.trace("calling /backup/roots ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(XML_VIEW1);
        String token = request.getHeader("token");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudName = cl.getCloud().getCloudName(), token, cl.getCloud());
            if (!this.checkLicense(code.getStatus(), response)) {
                return null;
            }
            User user = new User();
            if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
                return null;
            }
            if (!this.checkIfUserIsValid(user, 0, response)) {
                return null;
            }
            BackupListElement backupElementList = this.backupDelegate.getChildrenByFolder(cloudId, cloudName, null, code.getDevice().getId());
            response.setStatus(200);
            modelAndView.addObject((Object)backupElementList);
        }
        catch (DataAccessException e) {
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            response.setStatus(500);
            response.setHeader(ERROR_MESSAGE, e.getMessage());
            return null;
        }
        return modelAndView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cloud/{cloudName}/backup/upload"}, method={RequestMethod.PUT})
    public void uploadBackUpFile(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        BackupElement fileElement = null;
        boolean requestSuccess = false;
        InputStream inputStream = null;
        String token = request.getHeader("token");
        CloudLicenseTo cl = this.licenseService.validateLicenseAndStorageRestrictions(cloudName);
        if (!this.checkLicense(cl, response)) {
            this.closeInputStreamIfExists(request);
            return;
        }
        int cloudId = cl.getCloud().getCloudId();
        cloudName = cl.getCloud().getCloudName();
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDeviceForBackup(cloudId, cloudName, token, cl.getCloud());
        logger.debug(" !@!@#!@#!@# backup/upload ");
        if (!this.checkLicense(code.getStatus(), response)) {
            this.closeInputStreamIfExists(request);
            return;
        }
        logger.debug(" !@!@#!@#!@# backup/upload checkIfDeviceIsAttached");
        if (!this.checkIfDeviceIsAttached(cl.getCloud().getCloudName(), response)) {
            return;
        }
        User user = new User();
        if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
            return;
        }
        logger.debug(" !@!@#!@#!@# backup/upload checkIfUserIsValid");
        if (!this.checkIfUserIsValid(user, 0, response)) {
            this.closeInputStreamIfExists(request);
            return;
        }
        try {
            fileElement = new BackupElement();
            logger.debug(" !@!@#!@#!@# backup/upload uploadBackUpFile");
            String headerEncoding = request.getHeader("header-encoding");
            if (StringUtils.isNotEmpty((String)headerEncoding) && "base64".equalsIgnoreCase(headerEncoding)) {
                fileElement.setFileName(this.decodeBase64UTFString(request.getHeader("file-name")));
                fileElement.setFileCompletePath(this.decodeBase64UTFString(request.getHeader("file-path")));
            } else {
                fileElement.setFileName(request.getHeader("file-name"));
                fileElement.setFileCompletePath(request.getHeader("file-path"));
            }
            fileElement.setPresent(Boolean.valueOf(request.getHeader("is-exists")).booleanValue());
            fileElement.setFolder(Boolean.valueOf(request.getHeader("is-folder")).booleanValue());
            fileElement.setMd5Checksum(request.getHeader("fileMD5"));
            fileElement.setSize(Long.valueOf(request.getHeader("file-size")).longValue());
            String fileModifiedTimestamp = request.getHeader("modified");
            fileElement.setLastClientModifiedTime(Long.valueOf(fileModifiedTimestamp).longValue());
            fileElement.setBaseBackup(Boolean.valueOf(request.getHeader("is-base-folder")).booleanValue());
            long cloudSizeAllowedInBytes = (long)((float)(this.licenseService.getCloudDiskSpaceLimit(cloudName) * 1024L * 1024L) * 1.01f);
            if (fileElement.isFolder()) {
                this.backupUploadDelegate.uploadFileToBackUp(cloudId, cloudName, null, fileElement, cloudSizeAllowedInBytes, code.getDevice());
                response.setStatus(200);
            } else {
                inputStream = request.getInputStream();
                this.backupUploadDelegate.uploadFileToBackUp(cloudId, cloudName, inputStream, fileElement, cloudSizeAllowedInBytes, code.getDevice());
            }
            response.setStatus(200);
            requestSuccess = true;
        }
        catch (ResourceFunnelException e) {
            logger.trace("ResourceFunnelException  :" + (Object)((Object)e));
            logger.error("ResourceFunnelException  :" + e.getMessage());
            response.setHeader(ERROR_MESSAGE, e.getErrMsg());
            response.setStatus(e.getResponseCode());
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader(ERROR_MESSAGE, e.getMessage());
            response.setStatus(500);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.trace(IO_EXCEPTION + e);
                    logger.error(IO_EXCEPTION + e.getMessage());
                }
            }
            try {
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
            catch (IOException e) {
                logger.trace(IO_EXCEPTION + e);
                logger.error(IO_EXCEPTION + e.getMessage());
            }
        }
        if (requestSuccess) {
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "backed up", user.getUserName(), fileElement.getFileName(), code.getDevice().getDeviceName(), System.currentTimeMillis(), PCActionTypes.FILE_BACKUP.getActionTypeValue());
        }
    }

    /*
     * Exception decompiling
     */
    @RequestMapping(value={"/cloud/{cloudName}/backup/download/file"}, method={RequestMethod.GET})
    public void downloadFile(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @RequestMapping(value={"/cloud/{cloudName}/backup/download/mobile/delete/file"}, method={RequestMethod.GET})
    public void deletedDownloadedFileForMobile(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        String fileName = request.getHeader("file-name");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        String token = request.getHeader("token");
        int cloudId = cl.getCloud().getCloudId();
        cloudName = cl.getCloud().getCloudName();
        String deviceUUID = request.getHeader(DEVICE_UUID);
        AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
        User user = authorizationTokens.getUser();
        File deleteFile = new File("/var/www/portal/public/mobile/" + fileName);
        if (deleteFile.delete()) {
            response.setStatus(200);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "downloaded successfully from mobile", user.getUserName(), deleteFile.getName(), deviceUUID, System.currentTimeMillis(), PCActionTypes.AGENT_FILE_DELETE.getActionTypeValue());
        } else {
            response.setStatus(400);
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/backup/files/all"}, method={RequestMethod.POST})
    public ModelAndView getAllCurrentVersionFiles(@PathVariable(value="cloudName") String cloudName1, @RequestBody DeviceElement deviceElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = null;
        String token = request.getHeader("token");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return null;
        }
        int cloudId = cl.getCloud().getCloudId();
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudName = cl.getCloud().getCloudName(), token, cl.getCloud());
        if (!this.checkLicense(code.getStatus(), response)) {
            return null;
        }
        User user = new User();
        if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
            return null;
        }
        if (!this.checkIfUserIsValid(user, 0, response)) {
            return null;
        }
        Device device2 = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceElement.getDeviceUUID());
        if (!(user.isAdmin() || device2 != null && device2.getUserName().equalsIgnoreCase(user.getUserName()))) {
            response.setStatus(401);
            return null;
        }
        try {
            boolean isExternalStorage = false;
            if (cl.getCloud().getExternalStorageAllowed() == 1) {
                isExternalStorage = true;
            }
            FileListElement fileListElement = this.backupService.getLatestFileList(cloudId, cloudName, device2, isExternalStorage);
            response.setStatus(200);
            modelAndView = new ModelAndView();
            modelAndView.setViewName(XML_VIEW1);
            modelAndView.addObject((Object)fileListElement);
        }
        catch (ResourceFunnelException e) {
            logger.trace(RESOURCE_FUNNEL_EXCEPTION + (Object)((Object)e));
            logger.error(RESOURCE_FUNNEL_EXCEPTION + e.getMessage());
            response.setHeader(ERROR_MESSAGE, e.getErrMsg());
            response.setStatus(e.getResponseCode());
        }
        catch (Exception ex) {
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
            response.setHeader(ERROR_MESSAGE, EXCEPTION);
            response.setStatus(500);
        }
        return modelAndView;
    }

    @RequestMapping(value={"/cloud/{cloudName}/backup/folder/files/all"}, method={RequestMethod.POST})
    public ModelAndView getAllCurrentVersionFilesForFolder(@PathVariable(value="cloudName") String cloudName1, @RequestBody FileElement fileElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("@@start of folder level restore .......... ");
        ModelAndView modelAndView = null;
        String token = request.getHeader("token");
        String deviceUUID = request.getHeader(DEVICE_UUID);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return null;
        }
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudName, token, cl.getCloud());
        if (!this.checkLicense(code.getStatus(), response)) {
            logger.error(" Device license failed inside backup/folder/files/all -- checkLicense ");
            return null;
        }
        User user = new User();
        if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
            return null;
        }
        if (!this.checkIfUserIsValid(user, 0, response)) {
            logger.error(user.isSyncEnabled() + " Device license failed inside backup/folder/files/all -- checkIfUserIsValid " + user.isBackupEnabled());
            return null;
        }
        Device device2 = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
        if (!user.isAdmin() && device2 == null || !device2.getUserName().equals(user.getUserName())) {
            response.setStatus(401);
            return null;
        }
        try {
            boolean isExternalStorage = false;
            if (cl.getCloud().getExternalStorageAllowed() == 1) {
                isExternalStorage = true;
            }
            logger.debug(" getLatestFileList  &&&&&&&&  " + fileElement.getFileCompletePath());
            FileListElement fileListElement = this.backupService.getLatestFileList(cloudId, cloudName, device2, fileElement.getFileCompletePath(), fileElement.getFileName(), isExternalStorage);
            response.setStatus(200);
            modelAndView = new ModelAndView();
            modelAndView.setViewName(XML_VIEW1);
            modelAndView.addObject((Object)fileListElement);
        }
        catch (ResourceFunnelException e) {
            logger.trace(RESOURCE_FUNNEL_EXCEPTION + (Object)((Object)e));
            logger.error(RESOURCE_FUNNEL_EXCEPTION + e.getMessage());
            response.setHeader(ERROR_MESSAGE, e.getErrMsg());
            response.setStatus(e.getResponseCode());
        }
        catch (Exception ex) {
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
            response.setHeader(ERROR_MESSAGE, EXCEPTION);
            response.setStatus(500);
        }
        logger.debug("@@End of folder level restore .......... ");
        return modelAndView;
    }

    @RequestMapping(value={"/cloud/{cloudName}/backup/base/all"}, method={RequestMethod.GET})
    public ModelAndView getBackupupFolderhistoryForDevice(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = null;
        String token = request.getHeader("token");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        logger.debug("INSIDE getBackupupFolderhistoryForDevice ..... ");
        if (!this.checkLicense(cl, response)) {
            logger.debug("INSIDE getBackupupFolderhistoryForDevice check cloud license failed .... ");
            return null;
        }
        int cloudId = cl.getCloud().getCloudId();
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudName = cl.getCloud().getCloudName(), token, cl.getCloud());
        if (!this.checkLicense(code.getStatus(), response)) {
            logger.debug("INSIDE getBackupupFolderhistoryForDevice DeviceStatus code license failed .... ");
            return null;
        }
        User user = new User();
        if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
            return null;
        }
        if (!this.checkIfUserIsValid(user, 0, response)) {
            logger.debug("INSIDE getBackupupFolderhistoryForDevice User license failed .... ");
            return null;
        }
        String backupId = request.getHeader("backupIdEnabled");
        try {
            boolean backupIdEnabled = false;
            if (!StringUtils.isEmpty((String)backupId)) {
                backupIdEnabled = true;
            }
            FileListElement fileListElement = this.backupService.getBaseFolders(cloudId, cloudName, code.getDevice(), backupIdEnabled);
            response.setStatus(200);
            modelAndView = new ModelAndView();
            modelAndView.setViewName(XML_VIEW1);
            modelAndView.addObject((Object)fileListElement);
        }
        catch (ResourceFunnelException e) {
            logger.trace(" ResourceFunnelException ...  " + (Object)((Object)e));
            response.setHeader(ERROR_MESSAGE, e.getErrMsg());
            response.setStatus(e.getResponseCode());
        }
        catch (Exception ex) {
            logger.trace(" Exception ...  " + ex);
            response.setHeader(ERROR_MESSAGE, EXCEPTION);
            response.setStatus(500);
        }
        return modelAndView;
    }

    @RequestMapping(value={"/cloud/{cloudName}/backup/device/{deviceUUID}/"}, method={RequestMethod.GET})
    public ModelAndView getBackupFoldersForDevice(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = null;
        String token = request.getHeader("token");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return null;
        }
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cl.getCloud().getCloudId(), cloudName, token, cl.getCloud());
        if (!this.checkLicense(code.getStatus(), response)) {
            logger.debug("Invalid token ....");
            return null;
        }
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
        if (device == null) {
            logger.debug("Invalid deviceUUId :" + deviceUUID);
            response.setStatus(400);
            return null;
        }
        try {
            FileListElement fileListElement = this.backupService.getBackedUpFolders(cloudId, cloudName, device);
            response.setStatus(200);
            modelAndView = new ModelAndView();
            modelAndView.setViewName(XML_VIEW1);
            modelAndView.addObject((Object)fileListElement);
        }
        catch (ResourceFunnelException e) {
            logger.trace(RESOURCE_FUNNEL_EXCEPTION + (Object)((Object)e));
            logger.error(RESOURCE_FUNNEL_EXCEPTION + e.getMessage());
            response.setHeader(ERROR_MESSAGE, e.getErrMsg());
            response.setStatus(e.getResponseCode());
        }
        catch (Exception ex) {
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
            response.setHeader(ERROR_MESSAGE, EXCEPTION);
            response.setStatus(500);
        }
        return modelAndView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cloud/{cloudName}/files/chunk"}, method={RequestMethod.POST})
    public void uploadChunkFile(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("Inside files/chunk ...." + request);
        String token = request.getParameter("token");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(" NOT VALID CLOUD LICENSE  inside /files/chunk ");
            return;
        }
        int cloudId = cl.getCloud().getCloudId();
        if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token, response)) {
            logger.debug(NOT_A_VALID_TOKEN_INSIDE_FILES_CHUNK);
            return;
        }
        try {
            Object inputStream = null;
            response.setStatus(500);
        }
        catch (ResourceFunnelException e) {
            logger.trace(RESOURCE_FUNNEL_EXCEPTION + (Object)((Object)e));
            logger.error(RESOURCE_FUNNEL_EXCEPTION + e.getMessage());
            response.setHeader(ERROR_MESSAGE, e.getErrMsg());
            response.setStatus(e.getResponseCode());
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader(ERROR_MESSAGE, e.getMessage());
            response.setStatus(500);
        }
        finally {
            try {
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
            catch (IOException e) {
                logger.trace("IOException outputstream inside /files/chunk " + e);
                logger.error("IOException outputstream inside /files/chunk " + e.getMessage());
            }
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/files/chunk/all"}, method={RequestMethod.POST})
    public void uploadChunkAllFile(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        try {
            User user;
            logger.debug(" Inside /files/chunk/all ..... ");
            String token = request.getParameter("token");
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.debug(NOT_VALID_CLOUD_LICENSE_INSIDE_FILES_CHUNK_ALL);
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token, user = new User(), response)) {
                logger.debug(NOT_VALID_CLOUD_LICENSE_INSIDE_FILES_CHUNK_ALL);
                return;
            }
            String deviceUUID = request.getParameter(DEVICE_UUID);
            Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
            logger.debug(device.getDeviceUUID() + "MERGE1 ..........  " + deviceUUID);
            BackupElement fileElement = new BackupElement();
            this.setBackupElementFromRequest(request, fileElement);
            this.chunkableBackupUploadDelegate.mergeAllChunksAndUploadFileToBackUp(cloudId, cloudName, fileElement, device);
            response.setStatus(200);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "backed up", user.getUserName(), fileElement.getFileName(), device.getDeviceName(), System.currentTimeMillis(), PCActionTypes.FILE_BACKUP.getActionTypeValue());
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader(ERROR_MESSAGE, e.getMessage());
            response.setStatus(500);
        }
    }

    private void setBackupElementFromRequest(HttpServletRequest request, BackupElement fileElement) {
        String fileName = request.getParameter("file-name");
        fileElement.setFileName(fileName);
        fileElement.setFileCompletePath(request.getParameter("file-path"));
        fileElement.setPresent(Boolean.valueOf(request.getParameter("is-exists")).booleanValue());
        fileElement.setMd5Checksum(request.getParameter("fileMD5"));
        Long size = Long.valueOf(request.getParameter("file-size"));
        long filesizeInKB = (long)Math.ceil((double)size.longValue() / 1024.0);
        fileElement.setSize(filesizeInKB);
        String fileModifiedTimestamp = request.getParameter("modified");
        fileElement.setLastClientModifiedTime(Long.valueOf(fileModifiedTimestamp).longValue());
        fileElement.setBaseBackup(Boolean.valueOf(request.getParameter("is-base-folder")).booleanValue());
    }

    @RequestMapping(value={"/cloud/{cloudName}/externalbackup/{userName}/delete/"}, method={RequestMethod.POST})
    public void deleteExternalBackUpFile(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("@@@@@@@@@@@@@@INSIDE delete external BackUpFile ...............");
        String backupId = request.getParameter(BACKUP_ID);
        String dedupedBkId = request.getParameter("dedupedBkId");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        Cloud cloud = cl.getCloud();
        int cloudId = cloud.getCloudId();
        try {
            this.backupService.deleteBackupFiles(cloudId, cloudName, userName, backupId, dedupedBkId);
            response.setStatus(200);
            response.setHeader("isFileDeleted", Boolean.TRUE.toString());
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader("isFileDeleted", Boolean.FALSE.toString());
            response.setHeader(ERROR_MESSAGE, e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/userStorage/limitReached/{userName}/"}, method={RequestMethod.POST})
    public void checkUserStorageLimitReached(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        String token = request.getParameter("token");
        CloudLicenseTo cl = this.licenseService.validateLicenseAndStorageRestrictions(cloudName);
        Cloud cloud = cl.getCloud();
        cloudName = cloud.getCloudName();
        int cloudId = cloud.getCloudId();
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDeviceForBackup(cloudId, cloudName, token, cloud);
        try {
            Device device;
            long fileSizeInBytes = Long.parseLong(request.getParameter("file-size"));
            long filesizeInKB = (long)Math.ceil((double)fileSizeInBytes / 1024.0);
            double fileSizeInMb = BackupController.getSizeinMb(filesizeInKB);
            DeviceBackupOverView deviceBackupOverView = null;
            if (code != null && (device = code.getDevice()) != null) {
                deviceBackupOverView = this.deviceManagementService.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID());
            }
            logger.debug(fileSizeInMb + "@@@@@@####  checkUserStorageLimitReached  ...............");
            boolean isUserStorageLimitReached = this.licenseService.isUserStorageLimitReached(cloudId, fileSizeInMb, userName, deviceBackupOverView);
            logger.debug("@@@@@@@@@@@@@@  checkUserStorageLimitReached completed ..............." + isUserStorageLimitReached);
            response.setStatus(200);
            response.setHeader("isUserStorageLimitReached", String.valueOf(isUserStorageLimitReached));
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader(ERROR_MESSAGE, e.getMessage());
            response.setStatus(500);
            response.setHeader("isUserStorageLimitReached", String.valueOf(false));
        }
    }

    public static double getSizeinMb(long size) {
        double m = (double)size / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        return Double.parseDouble(dec.format(m));
    }

    @RequestMapping(value={"cloud/{cloudName}/backup/files/element"}, method={RequestMethod.GET})
    public void getBackUpFileInfoElement(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.trace(CALLING_BACKUP_FILES_VERSION);
        String devicePath = request.getHeader(FILE_PATH);
        String fileName = request.getHeader(FILE_NAME);
        try {
            String token;
            String deviceUUID = request.getHeader(DEVICE_UUID);
            if (StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)devicePath)) {
                response.setStatus(400);
                return;
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            User user = authorizationTokens.getUser();
            if (!this.checkIfUserIsValid(user, 0, response)) {
                return;
            }
            Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
            if (device == null || !device.getUserName().equalsIgnoreCase(user.getUserName())) {
                response.setStatus(401);
                return;
            }
            boolean type = device.getOsType().equals("Android");
            BackupElement backupElement = this.backupService.getBackUpImageInfo(cloudId, cloudName, fileName, devicePath = PathConversionHelper.getServerCompatiblePath((String)devicePath, (boolean)type), device);
            if (backupElement == null) {
                response.setHeader(BACKUP_ID, "");
            } else {
                response.setHeader(BACKUP_ID, backupElement.getId());
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            response.setStatus(500);
            logger.error(" Error trying to get the file information ..... " + e.getMessage());
        }
    }

    @RequestMapping(value={"/delete/extbackup/file"}, method={RequestMethod.GET})
    public ResponseEntity<BackupFileElement[]> getAllBackupIds(HttpServletRequest request, HttpServletResponse response) {
        List clouds = this.licenseService.getClouds();
        ArrayList backupIdsList = new ArrayList();
        for (Cloud cloud : clouds) {
        }
        for (Cloud cloud : clouds) {
        }
        logger.debug("******************************************************" + backupIdsList.size());
        BackupFileElement[] strArr = new BackupFileElement[backupIdsList.size()];
        int i = 0;
        Iterator iterator = backupIdsList.iterator();
        while (iterator.hasNext()) {
            BackupFileElement val;
            strArr[i] = val = (BackupFileElement)iterator.next();
            ++i;
        }
        return new ResponseEntity((Object)strArr, HttpStatus.OK);
    }

    @RequestMapping(value={"/cloud/{cloudName}/revert/backup/"}, method={RequestMethod.POST})
    public void revertBackupForPrivacyGateway(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        String token = request.getHeader("token");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return;
        }
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        if (!this.performAuthorization(cloudId, cloudName, token, response)) {
            return;
        }
        String backupId = request.getHeader(BACKUP_ID);
        try {
            this.backupService.deleteBackupFile(cloudId, cloudName, new ObjectId(backupId));
            response.setStatus(200);
        }
        catch (Exception ex) {
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
            response.setHeader(ERROR_MESSAGE, EXCEPTION);
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/file/check/dedup/"}, method={RequestMethod.GET})
    public void checkDedupification(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(XML_VIEW1);
        logger.debug("calling /checkDedupification...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String md5checksum = request.getHeader("md5checksum");
            cloudName = cl.getCloud().getCloudName();
            DeviceStatusTo code = this.deviceAndUserSecurityService.validateDeviceForBackup(cloudId, cloudName, token, cl.getCloud());
            if (!this.checkLicense(code.getStatus(), response)) {
                return;
            }
            User user = new User();
            if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
                logger.debug(NOT_VALID_CLOUD_LICENSE_INSIDE_FILES_CHUNK_ALL);
                return;
            }
            if (!this.checkIfUserIsValid(user, 0, response)) {
                return;
            }
            ObjectId backupId = this.backupService.getBackupIDForDedupifiedFile(cloudId, cloudName, user.getUserName(), md5checksum);
            if (backupId == null) {
                response.setHeader("dedupifiedBackupId", "");
            } else {
                response.setHeader("dedupifiedBackupId", backupId.toString());
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            logger.debug("Exception inside checkDedupification   .... " + e);
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/save/statistics/"}, method={RequestMethod.POST})
    public void saveStatisticsCollector(@PathVariable(value="cloudName") String cloudName1, @RequestBody BackupValidationElement backupListElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("BackupController . saveStatisticsCollector");
        String token = request.getHeader("token");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        String firstCrawlReq = request.getHeader("firstCrawl");
        boolean firstCrawl = StringUtils.isEmpty((String)firstCrawlReq) ? false : Boolean.parseBoolean(firstCrawlReq);
        logger.debug(firstCrawl + " first crawl ..... " + firstCrawlReq);
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDeviceForBackup(cloudId, cloudName, token, cl.getCloud());
        if (!this.checkLicense(code.getStatus(), response)) {
            return;
        }
        User user = new User();
        if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
            logger.debug(NOT_VALID_CLOUD_LICENSE_INSIDE_FILES_CHUNK_ALL);
            return;
        }
        if (!this.checkIfUserIsValid(user, 0, response)) {
            return;
        }
        try {
            this.backupDelegate.saveStatisticsForBackup(cloudId, cloudName, backupListElement, code.getDevice(), firstCrawl);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader(ERROR_MESSAGE, e.toString());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/update/currentBkp/file/"}, method={RequestMethod.POST})
    public void updateCurrentBackupFile(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return;
        }
        try {
            String deviceUUID = request.getHeader(DEVICE_UUID);
            String currentFile = request.getHeader("currentFile");
            String key = cloudName + "_" + deviceUUID;
            MemoryStore.delete(key);
            if (!StringUtils.isEmpty((String)currentFile)) {
                logger.debug("Current file *******  ...." + currentFile);
                MemoryStore.add(key, currentFile);
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/load/currentBkp/file/"}, method={RequestMethod.GET})
    public void getCurrentBackupFile(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        response.setStatus(403);
    }

    @RequestMapping(value={"/cloud/{cloudName}/save/files/ah/"}, method={RequestMethod.POST})
    public void saveBackupBatch(@RequestBody BackupBatchElement backupBatchElement, @PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return;
        }
        try {
            String token = request.getHeader("token");
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            String userName = request.getHeader(USER_NAME);
            this.backupBatchAHService.saveBackupActivityHistory(cloudId, cloudName, userName, backupBatchElement);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/bsportal/load/backup/ah/"}, method={RequestMethod.GET})
    public ModelAndView loadBackupBatch(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("inside   loadBackupBatch /bsportal/load/backup/ah/ ");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return null;
        }
        String token = request.getHeader("token");
        if (!this.performAuthorization(cl.getCloud().getCloudId(), cloudName, token, response)) {
            return null;
        }
        try {
            String batchId = request.getHeader("batchId");
            String userName = request.getHeader(USER_NAME);
            logger.debug(batchId + "   loadBackupBatch /bsportal/load/backup/ah/ " + userName);
            List<BackupHistoryFileElement> list = this.backupBatchAHService.loadAllFilesForBatch(cl.getCloud().getCloudId(), batchId, cloudName, userName);
            modelAndView.addObject(list);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(" Error during load of files for activity history .... " + e);
            logger.error(" Error during load of files for activity history .... " + e.getMessage());
            response.setStatus(500);
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/update/backup/table"}, method={RequestMethod.POST})
    public void updateUploadStatusBackupTable(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(XML_VIEW1);
        logger.debug("calling /update/backup/table ...");
        logger.debug("calling /update/backup/table ...");
        try {
            logger.debug("cloudName:" + cloudName);
            if (StringUtils.isBlank((String)cloudName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            cloudName = cl.getCloud().getCloudName();
            String backupId = request.getHeader("backup-id");
            String storagePlace = request.getHeader("storage-place");
            logger.debug("Backup ID from header:" + backupId + "storag place:" + storagePlace);
            this.backupService.updateODBstatusOfFile(cloudId, cloudName, new ObjectId(backupId), storagePlace);
            logger.debug("status: 200 For Update azure file status");
            response.setStatus(200);
        }
        catch (DataAccessException e) {
            logger.trace("DataAccessException  " + (Object)((Object)e));
            logger.error("DataAccessException  " + e.getMessage());
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace("BaseException  " + (Object)((Object)e));
            logger.error("BaseException  " + e.getMessage());
            response.setStatus(400);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/save/backupfile/user/{userName}/"}, method={RequestMethod.PUT})
    public void saveBackupFileInfo(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="userName") String userName, @RequestBody BluKryptBackupFileElement bluKryptBackupFileElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(CALLING_SAVE_BACKUP_FILE_INFO_IN_COUCH_DB);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            BackupFile backupFile = new BackupFile();
            BeanUtils.copyProperties((Object)bluKryptBackupFileElement, (Object)backupFile);
            backupFile.setId(new ObjectId(bluKryptBackupFileElement.getBackupId()));
            this.backupService.saveBackupFileInfo(cloudId, cloudName, userName, backupFile);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace("Exception  " + e);
            logger.error("Exception  " + e.getMessage());
            response.setStatus(500);
            logger.error(ERROR_FAILED_TO_SAVE_BACKUP_FILE_INFO + e.getMessage());
        }
        logger.debug(END_OF_CALLING_AUTHENTICATE_ONEDRIVE);
    }

    @RequestMapping(value={"cloud/{cloudName}/get/backupfile/"}, method={RequestMethod.GET})
    public ResponseEntity<BluKryptBackupFileElement> getExternalBackupFile(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling BluKryptBackupFileElement get backup file info in couch DB ...");
        BackupFile backupFile = null;
        BluKryptBackupFileElement element = new BluKryptBackupFileElement();
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String userName = request.getHeader(USER_NAME);
            String id = request.getHeader("backup-file-id");
            backupFile = this.backupService.getBackupFile(cloudId, cloudName, userName, id);
            ArrayList<ChunkFileInfoElement> chunkList = new ArrayList<ChunkFileInfoElement>();
            if (backupFile != null) {
                for (ChunkFile chunkFile : backupFile.getChunkFiles()) {
                    ChunkFileInfoElement file = new ChunkFileInfoElement();
                    BeanUtils.copyProperties((Object)chunkFile, (Object)file);
                    chunkList.add(file);
                }
                BeanUtils.copyProperties((Object)backupFile, (Object)element);
                element.setBackupId(backupFile.getId().toString());
                element.getChunkFiles().clear();
                element.getChunkFiles().addAll(chunkList);
            } else {
                logger.debug("BACKUP FILE NOT AVAILABLE ......." + id);
            }
            response.setStatus(200);
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            response.setStatus(500);
            logger.error("Error failed to get backup file info ..." + e.getMessage());
        }
        logger.debug("end of calling /get External BackupFile Info ...");
        return new ResponseEntity((Object)element, HttpStatus.OK);
    }

    @RequestMapping(value={"cloud/{cloudName}/save/pginfo/"}, method={RequestMethod.PUT})
    public void saveBackupPgInfo(@PathVariable(value="cloudName") String cloudName, @RequestBody PGInfoElement pgInfoElement, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(CALLING_SAVE_BACKUP_FILE_INFO_IN_COUCH_DB);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String tableName = request.getHeader("tableName");
            this.backupService.savePGInfo(cloudId, tableName, pgInfoElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            response.setStatus(500);
            logger.error(ERROR_FAILED_TO_SAVE_BACKUP_FILE_INFO + e.getMessage());
        }
        logger.debug(END_OF_CALLING_AUTHENTICATE_ONEDRIVE);
    }

    @RequestMapping(value={"cloud/{cloudName}/save/external/pginfo/"}, method={RequestMethod.PUT})
    public void saveExternalBackupPgInfo(@PathVariable(value="cloudName") String cloudName, @RequestBody PGInfoElement pgInfoElement, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(CALLING_SAVE_BACKUP_FILE_INFO_IN_COUCH_DB);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String tableName = request.getHeader("tableName");
            this.backupService.savePGInfo(cloudId, tableName, pgInfoElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_SAVE_BACKUP_FILE_INFO + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_SAVE_BACKUP_FILE_INFO + e.getMessage());
        }
        logger.debug(END_OF_CALLING_AUTHENTICATE_ONEDRIVE);
    }

    @RequestMapping(value={"cloud/{cloudName}/backup/files/child/agent"}, method={RequestMethod.GET}, produces={"text/xml; charset=utf-8"})
    public ModelAndView getFileNamesOfFolderForAgent(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(XML_VIEW1);
        response.setContentType("text/html; charset=UTF-8");
        logger.debug("calling /backup/files/child/agent ...");
        String devicePath = request.getHeader(FILE_PATH);
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
                return null;
            }
            List<BackupElement> backupElements = this.getBackupElementsForAgent(cloudName, request, response, devicePath, true);
            BackupListElement backupListElement = new BackupListElement();
            backupListElement.setFileElementList(backupElements);
            modelAndView.addObject((Object)backupListElement);
            response.setStatus(200);
            return modelAndView;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(400);
            return null;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/cloud/{cloudName}/backup/files/child/agent"}, method={RequestMethod.GET}, produces={"text/xml; charset=utf-8"})
    public ModelAndView getFileNamesOfFolderForAgenttoUPL(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(XML_VIEW1);
        response.setContentType("text/html; charset=UTF-8");
        logger.debug("calling /backup/files/child/agent ...");
        boolean isrestoreDeletedFile = true;
        String devicePath = request.getHeader(FILE_PATH);
        String restoreDeletedFileStr = request.getHeader("restoreDeletedFile");
        if (!StringUtils.isEmpty((String)restoreDeletedFileStr)) {
            isrestoreDeletedFile = Boolean.valueOf(restoreDeletedFileStr);
        }
        logger.debug("...isrestoreDeletedFile..." + isrestoreDeletedFile);
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
                return null;
            }
            String headerEncoding = request.getHeader("header-encoding");
            if (StringUtils.isNotEmpty((String)headerEncoding) && "base64".equalsIgnoreCase(headerEncoding) && StringUtils.isNotEmpty((String)devicePath)) {
                devicePath = this.decodeBase64UTFString(request.getHeader(FILE_PATH));
            }
            List<BackupElement> backupElements = this.getBackupElementsForAgent(cloudName, request, response, devicePath, isrestoreDeletedFile);
            BackupListElement backupListElement = new BackupListElement();
            backupListElement.setFileElementList(backupElements);
            modelAndView.addObject((Object)backupListElement);
            response.setStatus(200);
            return modelAndView;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(400);
            return null;
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/crawl/backup/validate"}, method={RequestMethod.POST})
    public ModelAndView validateBackupDedup(@PathVariable(value="cloudName") String cloudName1, @RequestBody BackupValidationElement backupListElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("CrawlController /crawl/backup/validate  .... " + this.getCurrentCrawlLimit());
        this.incrementCrawlLimit();
        String token = request.getHeader("token");
        boolean completeBackUpcheckForFirstTimeCrawl = Boolean.parseBoolean(request.getHeader("complete-backup"));
        ModelAndView modelAndView = null;
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            this.decrementCrawlLimit();
            logger.debug("DECREMENTING Crawl limit after checkLicense .........." + this.getCurrentCrawlLimit());
            return null;
        }
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        logger.debug(" Before  validateDeviceForBackup  ........... ");
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDeviceForBackup(cloudId, cloudName, token, cl.getCloud());
        logger.debug(" after  validateDeviceForBackup  ........... ");
        if (!this.checkLicense(code.getStatus(), response)) {
            this.decrementCrawlLimit();
            logger.debug("DECREMENTING Crawl limit after validateDeviceForBackup .........." + this.getCurrentCrawlLimit());
            return null;
        }
        User user = new User();
        if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
            logger.debug(NOT_VALID_CLOUD_LICENSE_INSIDE_FILES_CHUNK_ALL);
            return null;
        }
        Device device = code.getDevice();
        if (!this.checkIfUserIsValid(user, 0, response)) {
            this.decrementCrawlLimit();
            logger.debug("DECREMENTING Crawl limit after checkIfUserIsValid .........." + this.getCurrentCrawlLimit());
            return null;
        }
        try {
            DeviceBackupOverView deviceBackupOverView = this.deviceManagementService.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID());
            if (deviceBackupOverView == null || StringUtils.isEmpty((String)deviceBackupOverView.getLastSuccessfulBkp())) {
                logger.debug("###INITIATE new device backup..........returning empty for device ....." + device.getDeviceUUID());
                BackupListResponseElement serverResponse = new BackupListResponseElement();
                response.setStatus(200);
                modelAndView = new ModelAndView();
                modelAndView.setViewName(GZIP_VIEW1);
                modelAndView.addObject((Object)serverResponse);
                this.decrementCrawlLimit();
                logger.debug("###ENDOFINITIATE new device backup..........returning empty");
                return modelAndView;
            }
            logger.debug(" Before  validateBackUpFiles  ........... ");
            BackupListResponseElement serverResponse = this.backupDelegate.validateBackUpFilesNew(cloudId, cloudName, device.getDeviceUUID(), backupListElement, completeBackUpcheckForFirstTimeCrawl, device);
            logger.debug(" After  validateBackUpFiles  ........... ");
            response.setStatus(200);
            modelAndView = new ModelAndView();
            modelAndView.setViewName(GZIP_VIEW1);
            modelAndView.addObject((Object)serverResponse);
        }
        catch (ResourceFunnelException e) {
            response.setHeader(ERROR_MESSAGE, e.getErrMsg());
            response.setStatus(e.getResponseCode());
            logger.trace(ERROR_CHANGES_DURING_VALIDATE + (Object)((Object)e));
            logger.error(ERROR_CHANGES_DURING_VALIDATE + e.getMessage());
        }
        catch (Exception e) {
            response.setHeader(ERROR_MESSAGE, e.toString());
            response.setStatus(500);
            logger.trace(ERROR_CHANGES_DURING_VALIDATE + e);
            logger.error(ERROR_CHANGES_DURING_VALIDATE + e.getMessage());
        }
        this.decrementCrawlLimit();
        logger.debug("End of /crawl/backup/validate >>>>>>>>>>>>>>>>:" + this.getCurrentCrawlLimit());
        return modelAndView;
    }

    private List<BackupElement> getBackupElementsForAgent(String cloudName1, HttpServletRequest request, HttpServletResponse response, String devicePath, boolean restoreDeletedFile) {
        String cloudName = cloudName1;
        if (StringUtils.isEmpty((String)request.getHeader(DEVICE_ID))) {
            logger.debug(DEVICE_ID_EMPTY);
            response.setStatus(400);
            return null;
        }
        logger.debug(DEVICE_ID + request.getHeader(DEVICE_ID));
        ObjectId deviceId = new ObjectId(request.getHeader(DEVICE_ID));
        logger.debug(BEFORE_CHECK_LICENSE + cloudName);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        logger.debug(AFTER_CHECK_LICENSE_1);
        if (!this.checkLicense(cl, response)) {
            logger.debug(CHECK_LICENSE_FAILED);
            return null;
        }
        logger.debug(AFTER_CHECK_LICENSE_2);
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        String token = request.getHeader("token");
        String serverModifiedTime = "";
        if (!StringUtils.isEmpty((String)request.getHeader("pointIntimeRestoreTimeStamp"))) {
            serverModifiedTime = request.getHeader("pointIntimeRestoreTimeStamp");
        }
        boolean isExternalStorage = false;
        if (cl.getCloud().getExternalStorageAllowed() == 1) {
            isExternalStorage = true;
        }
        logger.debug(BEFORE_AUTHORIZATION_TOKEN);
        AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
        if (!this.checkIfUserIsValid(authorizationTokens.getUser(), 0, response)) {
            logger.debug(CHECK_IF_USER_IS_VALID_FAILED);
            return null;
        }
        logger.debug(AFTER_VALIDATION);
        Device device = this.deviceManagementService.getDeviceByObjectId(cloudId, cloudName, deviceId);
        return this.backupService.getChildrenForAgent(cloudId, cloudName, devicePath, device, isExternalStorage, serverModifiedTime, restoreDeletedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cloud/{cloudName}/testmp"}, method={RequestMethod.POST})
    public void testMultipart(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(" test mp1 ...");
        logger.debug(" ................ " + request.getParameter("token"));
        MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
        logger.debug(" %%%%%%%%%%%%%%%%%%% " + multipartHttpServletRequest);
        InputStream inputStream = null;
        for (Map.Entry entry : multipartHttpServletRequest.getFileMap().entrySet()) {
            logger.debug(" !!!!!............. " + (String)entry.getKey());
            MultipartFile fileq = (MultipartFile)entry.getValue();
            File tempUploadFile = new File((String)entry.getKey());
            try (FileOutputStream outstream = new FileOutputStream(tempUploadFile);){
                inputStream = fileq.getInputStream();
                byte[] b = new byte[4096];
                MessageDigest md = MessageDigest.getInstance("MD5");
                tempUploadFile.createNewFile();
                int buff = -1;
                while ((buff = inputStream.read(b)) != -1) {
                    outstream.write(b, 0, buff);
                    md.update(b, 0, buff);
                }
            }
            catch (Exception e) {
                try {
                    logger.trace(EXCEPTION + e);
                    logger.error(EXCEPTION + e.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                continue;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/restore"}, method={RequestMethod.GET})
    public void restoreFiles(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        BackupBatchElement backupBatchElement = new BackupBatchElement();
        backupBatchElement.setBatchId("122");
        ArrayList<File> files = new ArrayList<File>();
        files.add(new File("/home/paracloud-support/123.sh"));
        try {
            ServletOutputStream out = response.getOutputStream();
            for (File file : files) {
                int data;
                if (!file.exists()) continue;
                BufferedInputStream fif = new BufferedInputStream(new FileInputStream(file));
                out.println();
                logger.debug("Sending file " + file.getName());
                while ((data = fif.read()) != -1) {
                    out.write(data);
                }
                fif.close();
                out.flush();
                logger.debug("Finished file " + file.getName());
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            logger.trace("Exception   " + e);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/files/chunk/"}, method={RequestMethod.GET})
    public ModelAndView getBackUpFileChunkElement(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling get files/chunk/ ...");
        String devicePath = request.getHeader(FILE_PATH);
        String fileName = request.getHeader(FILE_NAME);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(XML_VIEW1);
        try {
            String token;
            String deviceUUID = request.getHeader(DEVICE_UUID);
            if (StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)devicePath)) {
                response.setStatus(400);
                return null;
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            User user = authorizationTokens.getUser();
            if (!this.checkIfUserIsValid(user, 0, response)) {
                return null;
            }
            Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
            if (device == null || !device.getUserName().equalsIgnoreCase(user.getUserName())) {
                response.setStatus(401);
                return null;
            }
            boolean type = device.getOsType().equals("Android");
            BackupElement backupElement = this.backupService.getBackUpImageInfo(cloudId, cloudName, fileName, devicePath = PathConversionHelper.getServerCompatiblePath((String)devicePath, (boolean)type), device);
            if (backupElement == null) {
                response.setHeader(BACKUP_ID, "");
                response.setStatus(404);
                return null;
            }
            logger.debug("Inside get backup element  is not null&&&&&&" + backupElement.getBackupId());
            BackupFile backupFile = this.backupService.getBackupFile(cloudId, cloudName, user.getUserName(), backupElement.getId());
            if (backupFile != null) {
                logger.debug("Inside get backup file is not null&&&&&&");
                response.setStatus(200);
                ArrayList<ChunkFileInfoElement> chunkFiles = new ArrayList<ChunkFileInfoElement>();
                for (ChunkFile chunkFile : backupFile.getChunkFiles()) {
                    ChunkFileInfoElement chunkFile2 = new ChunkFileInfoElement();
                    BeanUtils.copyProperties((Object)chunkFile, (Object)chunkFile2);
                    chunkFiles.add(chunkFile2);
                }
                backupElement.setChunkFiles(chunkFiles);
            }
            response.setHeader(BACKUP_ID, backupElement.getId());
            modelAndView.addObject((Object)backupElement);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(" Error trying to get the file information ... " + e);
            logger.error(" Error trying to get the file information ..... " + e.getMessage());
        }
        return modelAndView;
    }

    public static String createXmlForBackupStatElement(BackupBatchElement backupBatchElement) throws IOException {
        String outputXml = null;
        try (StringWriter stringwriter = new StringWriter();){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{BackupBatchElement.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)backupBatchElement, (Writer)stringwriter);
            outputXml = stringwriter.toString();
        }
        catch (JAXBException e) {
            logger.trace("Exception", (Throwable)e);
            return null;
        }
        return outputXml;
    }

    @RequestMapping(value={"cloud/{cloudName}/get/chunks/"}, method={RequestMethod.GET})
    public ModelAndView getchunks(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            String userName = request.getHeader(USER_NAME);
            String backupId = request.getHeader(BACKUP_ID);
            List<ChunkFile> chunkElements = this.backupService.getChunkFileNamesForId(cloudId, cloudName, userName, backupId);
            modelAndView.addObject(chunkElements);
            response.setStatus(200);
        }
        catch (Exception e) {
            ErrorElement err = this.createErrorElement(null, e.getMessage());
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/serverbackup/files/child"}, method={RequestMethod.GET})
    public ModelAndView getFileNamesOfFolderForServerBackup(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(XML_VIEW1);
        logger.debug("calling serverbackup/files/child");
        String devicePath = request.getHeader(FILE_PATH);
        ObjectId deviceId = new ObjectId(NUM54CBD580E4B03356FB13A6E4);
        String containerName = request.getHeader("containerName");
        logger.debug("calling serverbackup/files/child > containerName " + containerName);
        try {
            List<BackupElement> backupElements = !StringUtils.isEmpty((String)containerName) ? this.getBackupContainerElements(cloudName, request, response, devicePath, deviceId, containerName) : this.getBackupElements(cloudName, request, response, devicePath);
            BackupListElement backupListElement = new BackupListElement();
            backupListElement.setFileElementList(backupElements);
            modelAndView.addObject((Object)backupListElement);
            response.setStatus(200);
            return modelAndView;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(400);
            return null;
        }
    }

    private List<BackupElement> getBackupContainerElements(String cloudName1, HttpServletRequest request, HttpServletResponse response, String devicePath, ObjectId deviceId1, String containerName) {
        String cloudName = cloudName1;
        if (StringUtils.isEmpty((String)request.getHeader(DEVICE_ID))) {
            logger.debug(DEVICE_ID_EMPTY);
            response.setStatus(400);
            return null;
        }
        logger.debug(DEVICE_ID + request.getHeader(DEVICE_ID));
        ObjectId deviceId = new ObjectId(request.getHeader(DEVICE_ID));
        logger.debug(BEFORE_CHECK_LICENSE + cloudName);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        logger.debug(AFTER_CHECK_LICENSE_1);
        if (!this.checkLicense(cl, response)) {
            logger.debug(CHECK_LICENSE_FAILED);
            return null;
        }
        logger.debug(AFTER_CHECK_LICENSE_2);
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        String token = request.getHeader("token");
        if (!this.performAuthorization(cloudId, cloudName, token, response)) {
            logger.debug("performAuthorization failed ... ");
            return null;
        }
        logger.debug(BEFORE_AUTHORIZATION_TOKEN);
        AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
        if (!this.checkIfUserIsValid(authorizationTokens.getUser(), 0, response)) {
            logger.debug(CHECK_IF_USER_IS_VALID_FAILED);
            return null;
        }
        logger.debug(AFTER_VALIDATION);
        return this.backupService.getChildrenForContainer(cloudId, cloudName, deviceId, containerName);
    }

    @RequestMapping(value={"/update/restartid"}, method={RequestMethod.POST})
    public void updateRestartID(HttpServletRequest request, HttpServletResponse httpResponse) {
        String restartId = request.getHeader("restartId");
        String batchId = request.getHeader("backupBatchId");
        String cloudName = request.getHeader("cloudName");
        String deviceUUID = request.getHeader(DEVICE_UUID);
        BackupLog backupLog = new BackupLog();
        backupLog.setId(new ObjectId(batchId));
        backupLog.setRestartId(Integer.valueOf(restartId).intValue());
        backupLog.setDeviceUUID(deviceUUID);
        logger.debug(" Before updating backupLog...........");
        this.backupService.updateBackupLog(1, cloudName, backupLog);
        logger.debug(" After updating backupLog...........");
        httpResponse.setStatus(200);
    }

    @RequestMapping(value={"cloud/{cloudName}/rebackup/files"}, method={RequestMethod.GET})
    public ModelAndView getFilesForReBackup(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(XML_VIEW1);
        logger.debug("calling /rebackup/files ...");
        String userName = request.getHeader(USER_NAME);
        String deviceUUID = request.getHeader(DEVICE_UUID);
        try {
            this.incrementCrawlLimit();
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.error("... invalid license...");
                this.decrementCrawlLimit();
                return null;
            }
            BackupListResponseElement serverResponse = new BackupListResponseElement();
            response.setStatus(200);
            modelAndView.setViewName(GZIP_VIEW1);
            modelAndView.addObject((Object)serverResponse);
            logger.debug("end of calling /rebackup/files ...");
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            BackupListResponseElement serverResponse = new BackupListResponseElement();
            response.setStatus(500);
            modelAndView.setViewName(GZIP_VIEW1);
            modelAndView.addObject((Object)serverResponse);
        }
        this.decrementCrawlLimit();
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/rebackup/files/delete"}, method={RequestMethod.POST})
    public void deleteResendBackupFiles(HttpServletRequest request, HttpServletResponse httpResponse, @RequestBody BackupElement bkpElement, @PathVariable(value="cloudName") String cloudName) {
        String token;
        logger.debug(".........cloud/{cloudName}/rebackup/files/delete....");
        String backupIdListString = bkpElement.getBackupId();
        logger.debug("...." + backupIdListString);
        httpResponse.setStatus(400);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, httpResponse)) {
            return;
        }
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), httpResponse)) {
            return;
        }
        if (StringUtils.isEmpty((String)backupIdListString)) {
            return;
        }
        ArrayList<String> backupIdList = new ArrayList<String>(Arrays.asList(backupIdListString.split(",")));
        for (String backupId : backupIdList) {
            this.backupService.deleteFileInRebackupAndBackup(cloudId, cloudName, new ObjectId(backupId));
            logger.debug("After deleting file from backup image and rebackup image....");
        }
        httpResponse.setStatus(200);
    }

    @RequestMapping(value={"/cloud/{cloudName}/backup/folder/all"}, method={RequestMethod.POST})
    public ModelAndView getAllFoldersForGivenPath(@PathVariable(value="cloudName") String cloudName1, @RequestBody FileElement fileElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("@@start of get all folders for given path .......... ");
        ModelAndView modelAndView = null;
        String token = request.getHeader("token");
        String deviceUUID = request.getHeader(DEVICE_UUID);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return null;
        }
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudName, token, cl.getCloud());
        if (!this.checkLicense(code.getStatus(), response)) {
            logger.error(" Device license failed inside backup/folder/all -- checkLicense ");
            return null;
        }
        User user = new User();
        if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
            logger.debug(NOT_VALID_CLOUD_LICENSE_INSIDE_FILES_CHUNK_ALL);
            return null;
        }
        if (!this.checkIfUserIsValid(user, 0, response)) {
            logger.error(user.isSyncEnabled() + " Device license failed inside backup/folder/all -- checkIfUserIsValid " + user.isBackupEnabled());
            return null;
        }
        String serverModifiedTime = "";
        long modifiedTimeStamp = 0L;
        if (!StringUtils.isEmpty((String)request.getHeader("pointIntimeRestoreTimeStamp"))) {
            serverModifiedTime = request.getHeader("pointIntimeRestoreTimeStamp");
            modifiedTimeStamp = Long.parseLong(serverModifiedTime);
        }
        Device device2 = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
        try {
            logger.debug(request.getHeader("pointIntimeRestoreTimeStamp") + " getLatestFileList  &&&&&&&&  " + fileElement.getFileCompletePath());
            FileListElement fileListElement = this.backupService.getLatestFolderListRecursive(cloudId, cloudName, device2, fileElement.getFileCompletePath(), modifiedTimeStamp);
            response.setStatus(200);
            modelAndView = new ModelAndView();
            modelAndView.setViewName(XML_VIEW1);
            response.setContentType("text/html; charset=UTF-8");
            modelAndView.addObject((Object)fileListElement);
        }
        catch (ResourceFunnelException e) {
            logger.trace(RESOURCE_FUNNEL_EXCEPTION + (Object)((Object)e));
            logger.error(RESOURCE_FUNNEL_EXCEPTION + e.getMessage());
            response.setHeader(ERROR_MESSAGE, e.getErrMsg());
            response.setStatus(e.getResponseCode());
        }
        catch (Exception ex) {
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION, (Throwable)ex);
            response.setHeader(ERROR_MESSAGE, EXCEPTION);
            response.setStatus(500);
        }
        logger.debug("@@End of get all folders for given path .......... ");
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/backup/files/delete"}, method={RequestMethod.DELETE})
    public void deleteBackupFiles(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, FileElement fileElement, HttpServletResponse response) {
        logger.debug("......start of versions/{versionNumber}/clouds/{cloudName}/backup/files/delete .... ");
        String cloudName1 = cloudName;
        String token = request.getHeader("token");
        String userName = request.getHeader(USER_NAME);
        String deviceUUID = request.getHeader("device");
        if (!StringUtils.isEmpty((String)fileElement.getFileCompletePath())) {
            String fileCompletePath = this.decodeBase64UTFString(fileElement.getFileCompletePath());
            fileElement.setFileCompletePath(fileCompletePath);
        }
        if (!StringUtils.isEmpty((String)fileElement.getFileName())) {
            String fileName = this.decodeBase64UTFString(fileElement.getFileName());
            fileElement.setFileName(fileName);
        }
        logger.debug("...trying to deleted ... " + fileElement.getBackupId());
        try {
            User user;
            logger.debug("fileElement detailsisFolder:" + fileElement.isFolder() + "...FileName:" + fileElement.getFileName() + "...File complete path:" + fileElement.getFileCompletePath());
            logger.debug("Cloud name" + cloudName1);
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName1);
            if (!this.checkLicense(cl, response)) {
                logger.debug("Invalid license ......");
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName1, token, user = new User(), response)) {
                logger.debug("invalid cloud name");
                return;
            }
            Device device = this.deviceManagementService.getDeviceByDeviceUUID(cloudId, cloudName1, deviceUUID);
            Cloud cloud = cl.getCloud();
            boolean isSearchEnabled = false;
            if (cloud.getContentSearchEnabled() == 1) {
                BackupPolicy backupPolicy;
                if (!StringUtils.isEmpty((String)device.getDeviceType()) && (device.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name()) || device.getDeviceType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.name()))) {
                    backupPolicy = this.managementService.getOfficeBackupPolicy(cloudId, user.getOneDrivePolicyName());
                    if (backupPolicy != null && backupPolicy.isContentIndexEnabled()) {
                        isSearchEnabled = true;
                    }
                } else {
                    backupPolicy = this.managementService.getBackupPolicy(cloudId, user.getPolicyName());
                    if (backupPolicy != null && backupPolicy.isContentIndexEnabled()) {
                        isSearchEnabled = true;
                    }
                }
            }
            if (!StringUtils.isEmpty((String)device.getDeviceType()) && device.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name()) && !StringUtils.isEmpty((String)fileElement.getBackupId())) {
                try {
                    BackUpImage backUpImage = this.backupService.getBackUpImageForId(cloudId, fileElement.getBackupId(), device);
                    if (backUpImage != null) {
                        fileElement.setFileCompletePath(backUpImage.getDevicePath());
                        fileElement.setFileName(backUpImage.getFileName());
                    }
                }
                catch (IllegalArgumentException argumentException) {
                    logger.error("...invalid objectid...." + fileElement.getBackupId());
                }
            }
            this.backupDeleteTimerService.deleteBackupFilesFromDB(cloudId, cloudName1, deviceUUID, userName, fileElement, device, isSearchEnabled);
        }
        catch (Exception e) {
            logger.debug(EXCEPTION + e);
            logger.debug(ERROR_MESSAGE + e.getMessage());
        }
        logger.debug("......end of versions/{versionNumber}/clouds/{cloudName}/backup/files/delete .... ");
    }

    @RequestMapping(value={"cloud/{cloudName}/search/backup/file"}, method={RequestMethod.GET})
    @ResponseBody
    public Object searchDevices(@PathVariable(value="cloudName") String cloudName1, @RequestParam(value="pageNumber", required=false) Integer pageNumberInteger, @RequestParam(value="recordsPerPage", required=false) Integer recordsCountInteger, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        BackupListElement fileListElement = new BackupListElement();
        logger.debug("calling cloud/{cloudName}/search/backup/file");
        try {
            Device device;
            String userNameDecoded;
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            int recordsCount = 0;
            int pageNumber = 0;
            if (recordsCountInteger != null) {
                recordsCount = recordsCountInteger;
            }
            if (pageNumberInteger != null) {
                pageNumber = pageNumberInteger - 1;
            }
            recordsCount = PCHelperConstant.getReportDisplayRecords();
            String encodedSearchString = request.getHeader("searchString");
            String deviceName = request.getHeader("deviceName");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isEmpty((String)deviceName) && !StringUtils.isEmpty((String)userName) && (user = this.managementService.getUserDetails(cloudId, "", userNameDecoded = this.decodeBase64UTFString(userName))) != null && (device = this.deviceManagementService.getSPDeviceForUserName(cloudId, userNameDecoded)) != null) {
                deviceName = this.encodeBase64UTFString(device.getDeviceName());
            }
            if (StringUtils.isEmpty((String)encodedSearchString) || StringUtils.isEmpty((String)deviceName) || StringUtils.isEmpty((String)userName)) {
                logger.error("received empty inputs..");
                return this.toJSON(400);
            }
            String searchString = this.decodeBase64UTFString(encodedSearchString);
            deviceName = this.decodeBase64UTFString(deviceName);
            userName = this.decodeBase64UTFString(userName);
            logger.debug(searchString + "....." + deviceName + "..." + userName + ".....pageNumberInteger skip and record count1 .." + pageNumberInteger + ".." + recordsCount);
            Device device2 = this.deviceManagementService.getDeviceByName(cloudId, deviceName, userName);
            if (device2 == null) {
                logger.error("device is null......");
                return this.toJSON(400);
            }
            if (device2 != null && device2.isQuarantineDevice()) {
                logger.error("device is QuarantineDevice......");
                return this.toJSON(510);
            }
            fileListElement = this.backupService.getFilesForSearchStr(cloudId, cloudName, searchString, device2, recordsCount, pageNumber);
            Map paramSet = request.getParameterMap();
            int totalRecordsCount = fileListElement.getFileElementList().size();
            return this.toJSON(200, this.getMetadataElement(recordsCount, pageNumberInteger, totalRecordsCount, request.getRequestURI(), paramSet), fileListElement);
        }
        catch (Exception e) {
            logger.error("Exception searching files..", (Throwable)e);
            return this.toJSON(1203);
        }
    }

    public ResponseMetadataElement getMetadataElement(int recordsCount, int currentPage, long totalRecords, String link, Map<String, String[]> queryMap) {
        ResponseMetadataElement metadata = new ResponseMetadataElement();
        metadata.setRecordsPerPage(recordsCount);
        metadata.setPageNumber(currentPage);
        metadata.setTotalCount(totalRecords);
        String queryParams = this.getQueryParametersAsString(queryMap);
        long lastPageNumber = totalRecords % (long)recordsCount == 0L ? totalRecords / (long)recordsCount : totalRecords / (long)recordsCount + 1L;
        HashMap<String, String> links = new HashMap<String, String>();
        links.put("self", link + "?" + PAGE_NUMBER + EQUALS_SIGN + currentPage + PARAM_SEPERATOR + RECORDS_COUNT + EQUALS_SIGN + recordsCount + queryParams);
        links.put("first", link + "?" + PAGE_NUMBER + EQUALS_SIGN + 1 + PARAM_SEPERATOR + RECORDS_COUNT + EQUALS_SIGN + recordsCount + queryParams);
        logger.debug("..currentPAge..." + currentPage);
        long prev = 1L;
        long next = 1L;
        if (currentPage > 1) {
            prev = currentPage - 1;
        }
        next = (long)currentPage == lastPageNumber ? lastPageNumber : (long)(currentPage + 1);
        logger.debug(prev + "...prev and next" + next);
        links.put("previous", link + "?" + PAGE_NUMBER + EQUALS_SIGN + prev + PARAM_SEPERATOR + RECORDS_COUNT + EQUALS_SIGN + recordsCount + queryParams);
        links.put("next", link + "?" + PAGE_NUMBER + EQUALS_SIGN + next + PARAM_SEPERATOR + RECORDS_COUNT + EQUALS_SIGN + recordsCount + queryParams);
        logger.debug(totalRecords + "..totalrec/recordsCount..." + recordsCount);
        links.put("last", link + "?" + PAGE_NUMBER + EQUALS_SIGN + lastPageNumber + PARAM_SEPERATOR + RECORDS_COUNT + EQUALS_SIGN + recordsCount + queryParams);
        metadata.setLinks(links);
        return metadata;
    }

    public String getQueryParametersAsString(Map<String, String[]> queryMap) {
        StringBuilder queryParams = new StringBuilder();
        if (!CollectionUtils.isEmpty(queryMap)) {
            for (String key : queryMap.keySet()) {
                if (key.equalsIgnoreCase(PAGE_NUMBER) || key.equalsIgnoreCase(RECORDS_COUNT)) continue;
                queryParams.append(PARAM_SEPERATOR).append(key).append(EQUALS_SIGN).append(queryMap.get(key)[0]);
            }
        }
        return queryParams.toString();
    }

    @RequestMapping(value={"cloud/{cloudName}/backup/device/calculate/restorablesize"}, method={RequestMethod.GET})
    public void calculateRestorableSizeForADevice(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(XML_VIEW1);
        logger.debug("calling cloud/{cloudName}/backup/device/{deviceName}/calculate/restorablesize ...");
        String deviceUUID = request.getHeader(DEVICE_UUID);
        try {
            User user;
            logger.debug("Calling calculate/restorablesize ");
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            cloudName = cl.getCloud().getCloudName();
            String token = request.getHeader("token");
            String path = request.getHeader("folder-path");
            String restoreDeletedFilesStr = request.getHeader("restore-deleted-files");
            String restoreTillTimeStamp = request.getHeader("restore-till-timestamp");
            boolean restoreDeletedFiles = false;
            logger.debug(restoreTillTimeStamp + "restore timestamp...restore deleted files...Calling calculate/restorablesize " + restoreDeletedFilesStr);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)restoreDeletedFilesStr)) {
                restoreDeletedFiles = Boolean.valueOf(restoreDeletedFilesStr);
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)path)) {
                path = this.decodeBase64UTFString(path);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, user = new User(), response)) {
                return;
            }
            Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
            long[] result = this.backupService.getLatestRestorableSizeRecursive(cloudId, cloudName, device, path, restoreTillTimeStamp, restoreDeletedFiles);
            logger.debug("totalRestorableSize:" + result[0]);
            logger.debug("totalNumber of files:" + result[1]);
            response.setHeader("total-restorable-size", this.formatFileSize(result[0]));
            response.setHeader("total-number-of-files", String.valueOf(result[1]));
            response.setHeader("total-restorable-size-long", String.valueOf(result[0]));
            response.setStatus(200);
        }
        catch (DataAccessException e) {
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            response.setStatus(400);
        }
    }

    private String formatFileSize(long size) {
        String hrSize;
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        if (t > 1.0) {
            hrSize = dec.format(t).concat(" TB");
        } else if (g > 1.0) {
            hrSize = dec.format(g).concat(" GB");
        } else {
            if (m <= 0.0) {
                m = 0.0;
            }
            hrSize = dec.format(m).concat(" MB");
        }
        return hrSize;
    }

    @RequestMapping(value={"cloud/{cloudName}/download/files"}, method={RequestMethod.GET})
    public ModelAndView downloadFiles(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(XML_VIEW1);
        logger.debug("calling cloud/{cloudName}/download/files ...");
        ArrayList<BackupElement> backupElements = new ArrayList<BackupElement>();
        try {
            File downloadDir = new File("/parablu/Downloads");
            if (downloadDir.exists()) {
                File[] files = downloadDir.listFiles();
                if (files != null) {
                    for (File file : files) {
                        String name = file.getName();
                        logger.debug("...files in download dir..." + name);
                        BackupElement backupElement = new BackupElement();
                        backupElement.setFileName(name);
                        backupElement.setSize(file.length());
                        backupElement.setLastServerModifiedTime(file.lastModified());
                        backupElements.add(backupElement);
                    }
                }
            } else {
                logger.debug("....no dir exists....");
            }
            BackupListElement backupListElement = new BackupListElement();
            backupListElement.setFileElementList(backupElements);
            modelAndView.addObject((Object)backupListElement);
            response.setStatus(200);
            logger.debug("end  cloud/{cloudName}/download/files ...");
            return modelAndView;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(400);
            logger.debug("end calling cloud/{cloudName}/download/files ...");
            return null;
        }
    }
}

