/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.service.impl;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.sync.element.SyncOverviewElement;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.impl.UserValidateService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.helper.exceptions.UserLimitReachedException;
import com.parablu.helper.utils.MD5Generator;
import com.parablu.mail.service.CloudMailService;
import com.parablu.mt.service.LdapService;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.AADUserElement;
import com.parablu.paracloud.element.BackupFolderElement;
import com.parablu.paracloud.element.BackupPoliciesAdminList;
import com.parablu.paracloud.element.BackupPolicyElement;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.LdapUserElement;
import com.parablu.paracloud.element.MiniCloudElement;
import com.parablu.paracloud.element.MiniCloudElementList;
import com.parablu.paracloud.element.OdbPolicesAdminList;
import com.parablu.paracloud.element.OfficeBackupPolicyElement;
import com.parablu.paracloud.element.PrivacyGatewayMappingElement;
import com.parablu.paracloud.element.SearchUserElement;
import com.parablu.paracloud.element.SyncPoliciesAdminList;
import com.parablu.paracloud.element.SyncPolicyElement;
import com.parablu.paracloud.element.UserElement;
import com.parablu.paracloud.element.UserGroupElement;
import com.parablu.paracloud.element.UserListElement;
import com.parablu.paracloud.element.bp.ExcludedFolderElement;
import com.parablu.paracloud.element.response.UserErrorReponse;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.AuthorizationDao;
import com.parablu.pcbd.dao.BackupBatchDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.dao.DeletedUserDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.FileRevisionDao;
import com.parablu.pcbd.dao.MigrationStatusDao;
import com.parablu.pcbd.dao.MiniCloudDao;
import com.parablu.pcbd.dao.PciAuthorizationTokensDao;
import com.parablu.pcbd.dao.PersonDao;
import com.parablu.pcbd.dao.PortalPropertiesDao;
import com.parablu.pcbd.dao.SearchIndexDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.dao.UserGroupDao;
import com.parablu.pcbd.dao.UserMiniCloudMappingDao;
import com.parablu.pcbd.domain.AdCredentials;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.CloudProperties;
import com.parablu.pcbd.domain.DailySyncOverView;
import com.parablu.pcbd.domain.DeletedSearchIndex;
import com.parablu.pcbd.domain.DeletedUser;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.ExcludedFolders;
import com.parablu.pcbd.domain.FailedLogin;
import com.parablu.pcbd.domain.Group;
import com.parablu.pcbd.domain.MigrationStatus;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.NetworkThrottling;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PciAuthorizationTokens;
import com.parablu.pcbd.domain.Person;
import com.parablu.pcbd.domain.PortalProperties;
import com.parablu.pcbd.domain.PrivacyGateway;
import com.parablu.pcbd.domain.Schedule;
import com.parablu.pcbd.domain.SyncOverView;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserCloudAccessControl;
import com.parablu.pcbd.domain.UserGroup;
import com.parablu.pcsd.dao.SyncPolicyDao;
import com.parablu.pcsd.domain.SyncPolicy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bson.types.ObjectId;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.util.CollectionUtils;

public class UserManagementServiceImpl
extends UserValidateService
implements UserManagementService {
    public static final String DD_MMM_YYYY_HH_MM_SS = "dd-MMM-yyyy HH:mm:ss";
    private static Logger logger = LogManager.getLogger(UserManagementServiceImpl.class);
    private UserDao userDao;
    private MiniCloudDao miniCloudDao;
    private UserMiniCloudMappingDao userMiniCloudMappingDao;
    private DeviceDao deviceDao;
    private AuthorizationDao authorizationDao;
    private PciAuthorizationTokensDao pciAuthorizationTokensDao;
    private BackupPolicyDao backupPolicyDao;
    private SyncPolicyDao syncPolicyDao;
    private DeletedUserDao deletedUserDao;
    private UserGroupDao userGroupDao;
    private FileRevisionDao fileRevisionDao;
    private PersonDao personDao;
    private MigrationStatusDao migrationStatusDao;
    @Autowired
    private CloudMailService cloudMailService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    @Autowired
    private LdapService ldapService;
    @Autowired
    private CloudDao cloudDao;
    @Autowired
    private BackupBatchDao backupBatchDao;
    @Autowired
    private PortalPropertiesDao portalPropertiesDao;
    private SearchIndexDao searchIndexDao;
    private static final int NO_OF_HASHES = 5;
    private static final String USER_NOT_FOUND = "User not found.";
    private static final String BASE_EXCEPTION = " BaseException  :";
    private static final String EXCEPTION = " Exception  :";
    private static final String NUMBER_FORMAT_EXCEPTION = "NumberFormatException  ";
    private static final String MM_DD_YYYY_HH_MM_SS = "MM/dd/yyyy HH:mm:ss";
    private static final String SYNC_ENABLED = "Sync Enabled";
    private static final String BACKUP_ENABLED = "Backup Enabled";
    private static final int AD_CONNECTION_FAILED = 400;
    private static final String SECRET_KEY = "a9985ebcae81";

    public PortalPropertiesDao getPortalPropertiesDao() {
        return this.portalPropertiesDao;
    }

    public void setPortalPropertiesDao(PortalPropertiesDao portalPropertiesDao) {
        this.portalPropertiesDao = portalPropertiesDao;
    }

    public void setBackupBatchDao(BackupBatchDao backupBatchDao) {
        this.backupBatchDao = backupBatchDao;
    }

    public void setCloudDao(CloudDao cloudDao) {
        this.cloudDao = cloudDao;
    }

    public void setSearchIndexDao(SearchIndexDao searchIndexDao) {
        this.searchIndexDao = searchIndexDao;
    }

    public void setLdapService(LdapService ldapService) {
        this.ldapService = ldapService;
    }

    public SyncPolicyDao getSyncPolicyDao() {
        return this.syncPolicyDao;
    }

    public void setSyncPolicyDao(SyncPolicyDao syncPolicyDao) {
        this.syncPolicyDao = syncPolicyDao;
    }

    public void setFileRevisionDao(FileRevisionDao fileRevisionDao) {
        this.fileRevisionDao = fileRevisionDao;
    }

    public void setUserGroupDao(UserGroupDao userGroupDao) {
        this.userGroupDao = userGroupDao;
    }

    public MiniCloudDao getMiniCloudDao() {
        return this.miniCloudDao;
    }

    public void setMiniCloudDao(MiniCloudDao miniCloudDao) {
        this.miniCloudDao = miniCloudDao;
    }

    public UserMiniCloudMappingDao getUserMiniCloudMappingDao() {
        return this.userMiniCloudMappingDao;
    }

    public void setUserMiniCloudMappingDao(UserMiniCloudMappingDao userMiniCloudMappingDao) {
        this.userMiniCloudMappingDao = userMiniCloudMappingDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public void setAuthorizationDao(AuthorizationDao authorizationDao) {
        this.authorizationDao = authorizationDao;
    }

    public PciAuthorizationTokensDao getPciAuthorizationTokensDao() {
        return this.pciAuthorizationTokensDao;
    }

    public void setPciAuthorizationTokensDao(PciAuthorizationTokensDao pciAuthorizationTokensDao) {
        this.pciAuthorizationTokensDao = pciAuthorizationTokensDao;
    }

    public void setBackupPolicyDao(BackupPolicyDao backupPolicyDao) {
        this.backupPolicyDao = backupPolicyDao;
    }

    public void setPersonDao(PersonDao personDao) {
        this.personDao = personDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    @Override
    public UserElement createUser(int cloudId, String cloudName, UserElement userElement, String currentUserName, String encryptedPassword, boolean ispswdencrypted, boolean sendMail) {
        UserElement createdUser;
        String recoveryKey;
        UserElement userResponse;
        block8: {
            userResponse = new UserElement();
            UUID uuid = UUID.randomUUID();
            recoveryKey = String.valueOf(uuid);
            createdUser = null;
            try {
                User user = new User();
                createdUser = this.createUser(cloudId, cloudName, userElement, false, this.userDao);
                if (createdUser != null) {
                    BeanUtils.copyProperties((Object)createdUser, (Object)userResponse);
                    userResponse.setShareEnabled(createdUser.isShareEnabled());
                    BeanUtils.copyProperties((Object)createdUser, (Object)user);
                    this.deviceDao.updateUserInfoInDeviceBkpOverview(cloudId, user);
                } else {
                    logger.debug("user  creation failed....");
                }
            }
            catch (BaseException e) {
                logger.trace(BASE_EXCEPTION + (Object)((Object)e));
                logger.error(BASE_EXCEPTION + e.getMessage());
                if (e.getErrorStatus() != 1200) break block8;
                throw new DataIntegrityViolationException(e.getMessage());
            }
        }
        String recoveryKeyHash = recoveryKey;
        for (int i = 0; i < 5; ++i) {
            recoveryKeyHash = MD5Generator.generateMD5OfString((String)recoveryKeyHash);
        }
        if (StringUtils.isNotEmpty((String)createdUser.getSecurityRecoveryKey())) {
            recoveryKey = createdUser.getSecurityRecoveryKey();
        }
        String password = encryptedPassword;
        if (ispswdencrypted) {
            password = this.getDecryptePassword(encryptedPassword);
        }
        if (sendMail) {
            this.sendCreateUserMail(cloudName, currentUserName, userElement.getUserName(), userElement.getEmailId(), recoveryKey, password);
        }
        userResponse.setSecurityRecoveryKey(recoveryKey);
        return userResponse;
    }

    @Override
    public List<UserErrorReponse> createMultipleUsers(Cloud cloud, UserListElement usersListElement, String currentUserName) throws Exception {
        String cloudName = cloud.getCloudName();
        int cloudId = cloud.getCloudId();
        List userListElement = usersListElement.getUserList();
        ArrayList<UserErrorReponse> responseUserElementList = new ArrayList<UserErrorReponse>();
        UserErrorReponse errorReponse = new UserErrorReponse();
        Pattern pattern = Pattern.compile("^.+@.+\\..+$");
        Pattern userNamePattern = Pattern.compile("^[!\\._\\'A-Za-z0-9@.]{3,104}$");
        ArrayList<String> unsupportedEmailIdCharacters = new ArrayList<String>();
        unsupportedEmailIdCharacters.add("/");
        unsupportedEmailIdCharacters.add("|");
        unsupportedEmailIdCharacters.add("=");
        unsupportedEmailIdCharacters.add("+");
        unsupportedEmailIdCharacters.add("*");
        unsupportedEmailIdCharacters.add("?");
        boolean syncEnabled = false;
        boolean odbBkpEnabled = false;
        boolean exchangeBkpEnabled = false;
        boolean backupEnabled = false;
        boolean sendSetPasswordLink = false;
        List list = cloud.getCloudCustomisableDetails();
        List users = this.userDao.getAllUsers(cloudId);
        List<Object> userNames = new ArrayList();
        List<Object> emailIds = new ArrayList();
        for (CloudCustomisableDetails customisableDetails : list) {
            if (SYNC_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                syncEnabled = true;
            }
            if (BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                backupEnabled = true;
            }
            if ("OneDrive Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                odbBkpEnabled = true;
            }
            if (!"Exchange Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) continue;
            exchangeBkpEnabled = true;
        }
        if (!CollectionUtils.isEmpty((Collection)users)) {
            userNames = users.stream().filter(existingUser -> Objects.nonNull(existingUser.getUserName())).map(existingUser -> existingUser.getUserName()).collect(Collectors.toList());
            emailIds = users.stream().filter(existingUser -> Objects.nonNull(existingUser.getEmailId())).map(existingUser -> existingUser.getEmailId()).collect(Collectors.toList());
        }
        for (UserElement ue : userListElement) {
            UserElement createUserElement;
            String recoveryKey;
            String password;
            User user;
            block58: {
                User userFromDB;
                Matcher matcher = pattern.matcher(ue.getEmailId());
                Matcher userNameMatcher = userNamePattern.matcher(ue.getUserName());
                errorReponse = new UserErrorReponse();
                sendSetPasswordLink = false;
                boolean skip = false;
                if ((long)cloud.getNoOfBackupUsersAllowed() <= this.userDao.countOfPresentBackupUsers(cloudId, cloudName, true)) {
                    backupEnabled = false;
                }
                if ((long)cloud.getNoOfSyncUsersAllowed() <= this.userDao.countOfPresentSyncUsers(cloudId, cloudName, true)) {
                    syncEnabled = false;
                }
                if ((long)cloud.getNoOfOneDriveUsersAllowed() <= this.userDao.countOfPresentOnedriveUsers(cloudId, true)) {
                    odbBkpEnabled = false;
                }
                if ((long)cloud.getNoOfExchangeUsersAllowed() <= this.userDao.countOfPresentExchangeUsers(cloudId, true)) {
                    exchangeBkpEnabled = false;
                }
                if (!(backupEnabled || syncEnabled || odbBkpEnabled || exchangeBkpEnabled)) {
                    logger.debug("....no licenses are enabled.. user limit reached...");
                    errorReponse.setUserName(ue.getUserName());
                    errorReponse.setEmailId(ue.getEmailId());
                    errorReponse.setErrorMessage("user limit reached");
                    responseUserElementList.add(errorReponse);
                    continue;
                }
                if (StringUtils.isEmpty((String)ue.getUserName()) || StringUtils.isEmpty((String)ue.getEmailId())) {
                    errorReponse.setUserName(ue.getUserName());
                    errorReponse.setEmailId(ue.getEmailId());
                    errorReponse.setErrorMessage("User name / Email Id empty");
                    responseUserElementList.add(errorReponse);
                    continue;
                }
                if (!matcher.find()) {
                    errorReponse.setUserName(ue.getUserName());
                    errorReponse.setEmailId(ue.getEmailId());
                    errorReponse.setErrorMessage("Invalid Email Id");
                    responseUserElementList.add(errorReponse);
                    continue;
                }
                for (String unsupportedEmailIdCharacter : unsupportedEmailIdCharacters) {
                    if (!ue.getEmailId().contains(unsupportedEmailIdCharacter)) continue;
                    errorReponse.setUserName(ue.getUserName());
                    errorReponse.setEmailId(ue.getEmailId());
                    errorReponse.setErrorMessage("Unsupported character found in email ID");
                    responseUserElementList.add(errorReponse);
                    skip = true;
                    break;
                }
                if (skip) continue;
                if (!EmailValidator.getInstance().isValid(ue.getEmailId())) {
                    errorReponse.setUserName(ue.getUserName());
                    errorReponse.setEmailId(ue.getEmailId());
                    errorReponse.setErrorMessage("Unsupported character found in email ID");
                    responseUserElementList.add(errorReponse);
                    continue;
                }
                if (!userNameMatcher.find()) {
                    errorReponse.setUserName(ue.getUserName());
                    errorReponse.setEmailId(ue.getEmailId());
                    errorReponse.setErrorMessage("Unsupported character found in user name");
                    responseUserElementList.add(errorReponse);
                    continue;
                }
                boolean isGuestUserRemoved = false;
                if (userNames.contains(ue.getUserName())) {
                    userFromDB = this.userDao.getUserByUserNameOrEmail(cloudId, ue.getUserName());
                    if (userFromDB == null) {
                        userFromDB = this.userDao.getUserByUserNameOrEmail(cloudId, ue.getEmailId());
                    }
                    if (userFromDB != null && userFromDB.isGuest()) {
                        isGuestUserRemoved = true;
                        this.userDao.removeUserbyID(cloudId, userFromDB.getUserId().toString());
                    } else {
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("UserName already exist");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                }
                if (emailIds.contains(ue.getEmailId())) {
                    userFromDB = this.userDao.getUserByUserNameOrEmail(cloudId, ue.getUserName());
                    if (userFromDB == null) {
                        userFromDB = this.userDao.getUserByUserNameOrEmail(cloudId, ue.getEmailId());
                    }
                    if (userFromDB != null && userFromDB.isGuest()) {
                        isGuestUserRemoved = true;
                        this.userDao.removeUserbyID(cloudId, userFromDB.getUserId().toString());
                    } else if (!isGuestUserRemoved) {
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("Email Id already in use");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                }
                if (userNames.contains(ue.getUserName())) {
                    userFromDB = this.userDao.getUserByUserNameOrEmail(cloudId, ue.getUserName());
                    if (userFromDB == null) {
                        userFromDB = this.userDao.getUserByUserNameOrEmail(cloudId, ue.getEmailId());
                    }
                    if (userFromDB != null && userFromDB.isGuest()) {
                        this.userDao.removeUserbyID(cloudId, userFromDB.getUserId().toString());
                        isGuestUserRemoved = true;
                    } else if (!isGuestUserRemoved) {
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("Email Id already in use");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                }
                if (!StringUtils.isEmpty((String)ue.getPasswdHash()) && ue.getPasswdHash().length() < 6) {
                    errorReponse.setUserName(ue.getUserName());
                    errorReponse.setEmailId(ue.getEmailId());
                    errorReponse.setErrorMessage("Invalid password");
                    responseUserElementList.add(errorReponse);
                    continue;
                }
                if (backupEnabled && !StringUtils.isEmpty((String)ue.getPolicyName()) && !this.backupPolicyDao.checkIfBackupPolicyNameExists(cloudId, ue.getPolicyName())) {
                    errorReponse.setUserName(ue.getUserName());
                    errorReponse.setEmailId(ue.getEmailId());
                    errorReponse.setErrorMessage("Backup policy doesn\u2019t exist");
                    responseUserElementList.add(errorReponse);
                    continue;
                }
                if (syncEnabled && !StringUtils.isEmpty((String)ue.getSyncPolicyName()) && !this.syncPolicyDao.checkIfSyncPolicyNameExists(cloudId, ue.getSyncPolicyName())) {
                    errorReponse.setUserName(ue.getUserName());
                    errorReponse.setEmailId(ue.getEmailId());
                    errorReponse.setErrorMessage("Sync policy doesn\u2019t exist");
                    responseUserElementList.add(errorReponse);
                    continue;
                }
                if ((odbBkpEnabled || exchangeBkpEnabled) && !StringUtils.isEmpty((String)ue.getOdbPolicyName()) && !this.backupPolicyDao.checkIfODBBackupPolicyNameExists(cloudId, ue.getOdbPolicyName())) {
                    errorReponse.setUserName(ue.getUserName());
                    errorReponse.setEmailId(ue.getEmailId());
                    errorReponse.setErrorMessage("Office 365 policy doesn\u2019t exist");
                    responseUserElementList.add(errorReponse);
                    continue;
                }
                user = new User();
                user.setMigratedBy(currentUserName);
                user.setActive(true);
                password = null;
                if (StringUtils.isEmpty((String)ue.getPasswdHash())) {
                    sendSetPasswordLink = true;
                    password = this.generaterandompswd();
                    user.setPasswdHash(this.generatePassWordhash(password));
                } else {
                    password = ue.getPasswdHash();
                    String passwdHash = this.generatePassWordhash(ue.getPasswdHash());
                    user.setPasswdHash(passwdHash);
                }
                user.setUserName(ue.getUserName());
                user.setEmailId(ue.getEmailId());
                user.setBackupEnabled(backupEnabled);
                user.setSyncEnabled(syncEnabled);
                user.setOnedriveBkpEnabled(odbBkpEnabled);
                user.setExchangeBkpEnabled(exchangeBkpEnabled);
                user.setGoogleSecretKey(ue.getGoogleSecretKey());
                if (backupEnabled) {
                    if (StringUtils.isEmpty((String)ue.getPolicyName())) {
                        user.setPolicyName(PCHelperConstant.getPropertyFileValueDefaultBkpPolicy());
                    } else {
                        user.setPolicyName(ue.getPolicyName());
                    }
                }
                if (syncEnabled) {
                    if (StringUtils.isEmpty((String)ue.getSyncPolicyName())) {
                        user.setSyncPolicyName(PCHelperConstant.getPropertyFileValueDefaultSyncPolicy());
                    } else {
                        user.setSyncPolicyName(ue.getSyncPolicyName());
                    }
                }
                logger.debug(ue.getOdbPolicyName() + "....odbpolicyname.... " + PCHelperConstant.getPropertyFileValueDefaultO365PolicyName());
                if (odbBkpEnabled || exchangeBkpEnabled) {
                    if (StringUtils.isEmpty((String)ue.getOdbPolicyName())) {
                        user.setOdbPolicyName(PCHelperConstant.getPropertyFileValueDefaultO365PolicyName());
                    } else {
                        user.setOdbPolicyName(ue.getOdbPolicyName());
                    }
                }
                UUID uuid = UUID.randomUUID();
                recoveryKey = String.valueOf(uuid);
                user.setSecurityRecoveryKey(recoveryKey);
                if (!StringUtils.isEmpty((String)ue.getDepartment())) {
                    user.setDepartment(ue.getDepartment());
                }
                if (!StringUtils.isEmpty((String)ue.getLocation())) {
                    user.setLocation(ue.getLocation());
                }
                if (!StringUtils.isEmpty((String)ue.getDisplayName())) {
                    user.setDisplayName(ue.getDisplayName());
                }
                if (!StringUtils.isEmpty((String)ue.getOdbLoginId())) {
                    user.setOdbLoginId(ue.getOdbLoginId());
                }
                user.setFirstLogin(true);
                user.setCreatedTimestamp(String.valueOf(System.currentTimeMillis()));
                user.setUserNameLowerCase(ue.getUserName().toLowerCase());
                UserElement userElement = new UserElement();
                BeanUtils.copyProperties((Object)user, (Object)userElement);
                createUserElement = null;
                try {
                    createUserElement = this.createUser(cloudId, cloudName, userElement, false, this.userDao);
                }
                catch (BaseException e) {
                    logger.trace(BASE_EXCEPTION + (Object)((Object)e));
                    logger.error(BASE_EXCEPTION + e.getMessage());
                    if (e.getErrorStatus() != 1200) break block58;
                    errorReponse.setUserName(ue.getUserName());
                    errorReponse.setEmailId(ue.getEmailId());
                    errorReponse.setErrorMessage("UserName already exist");
                    responseUserElementList.add(errorReponse);
                    continue;
                }
            }
            if (createUserElement == null) {
                errorReponse.setUserName(ue.getUserName());
                errorReponse.setEmailId(ue.getEmailId());
                errorReponse.setErrorMessage("Unable to create");
                responseUserElementList.add(errorReponse);
                continue;
            }
            User createdUser = new User();
            BeanUtils.copyProperties((Object)createUserElement, (Object)createdUser);
            try {
                this.sendCreateUserMail(cloudName, currentUserName, user.getUserName(), user.getEmailId(), recoveryKey, password);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.debug("Exception " + e);
                errorReponse.setUserName(ue.getUserName());
                errorReponse.setEmailId(ue.getEmailId());
                errorReponse.setErrorMessage("Unable to create");
                responseUserElementList.add(errorReponse);
                this.userDao.deleteUser(cloudId, cloudName, user);
                continue;
            }
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "created  a new user", currentUserName, user.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.USER_CREATE.getActionTypeValue());
            errorReponse.setUserName(ue.getUserName());
            errorReponse.setEmailId(ue.getEmailId());
            errorReponse.setErrorMessage("User created");
            responseUserElementList.add(errorReponse);
            if (!userNames.contains(ue.getUserName())) {
                userNames.add(ue.getUserName());
            }
            if (emailIds.contains(ue.getEmailId())) continue;
            emailIds.add(ue.getEmailId());
        }
        if (!CollectionUtils.isEmpty(responseUserElementList)) {
            ArrayList<UserElement> failedElements = new ArrayList<UserElement>();
            for (UserErrorReponse userError : responseUserElementList) {
                if (StringUtils.isEmpty((String)userError.getErrorMessage()) || userError.getErrorMessage().equalsIgnoreCase("User created")) continue;
                UserElement element = new UserElement();
                element.setUserName(userError.getUserName());
                element.setStatus(userError.getErrorMessage());
                logger.debug(userError.getUserName() + "..report..." + userError.getErrorMessage());
                failedElements.add(element);
            }
            if (!CollectionUtils.isEmpty(failedElements)) {
                this.createUsersExcelBlockFail(cloudId, failedElements);
            }
        }
        return responseUserElementList;
    }

    @Override
    public long countOfPresentUsers(int cloudId) {
        return this.userDao.countOfPresentUsers(cloudId, "", true);
    }

    @Override
    public void sendCreateUserMail(String cloudName, String actionBy, String actionOn, String emailId, String recoveryKey, String password) {
        if (!StringUtils.isEmpty((String)actionBy)) {
            EmailProps email = new EmailProps();
            email.setAction("create-user");
            email.setActionOn(actionOn);
            email.setActionBy(actionBy);
            email.setCloudName(cloudName);
            email.setCloudURL(PCHelperConstant.getPropertyFileValueParacloudUrl() + "/portal/locallogin");
            email.setPassword(password);
            EmailRecipent emailRecipent = new EmailRecipent();
            emailRecipent.setUserName(actionOn);
            emailRecipent.setEmail(emailId);
            ArrayList<EmailRecipent> recipentsList = new ArrayList<EmailRecipent>();
            recipentsList.add(emailRecipent);
            logger.debug("calling email..");
            email.setRecipents(recipentsList);
            this.cloudMailService.sendMail(email);
        }
    }

    public void sendMail(String cloudName, String currentUserName, String userName, String emailId, String recoveryKey) {
        EmailProps email = new EmailProps();
        email.setAction("new-user-first-time-password-set");
        email.setActionOn(userName);
        email.setDownloadLink(PCHelperConstant.getPropertyFileValueParacloudUrl() + "/portal/restPassword?tok=" + recoveryKey + "&user=" + userName + "&cloudname=" + cloudName + "&setpassword=true");
        email.setActionBy(currentUserName);
        email.setCloudName(cloudName);
        email.setToAdmins(false);
        email.setCloudURL(PCHelperConstant.getPropertyFileValueParacloudUrl());
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(userName);
        emailRecipent.setEmail(emailId);
        ArrayList<EmailRecipent> recipentsList = new ArrayList<EmailRecipent>();
        recipentsList.add(emailRecipent);
        logger.debug("calling email..");
        email.setRecipents(recipentsList);
        this.cloudMailService.sendMail(email);
    }

    @Override
    public void multipleUserBlockOrDeleteMail(String cloudName, int cloudId, String blockOrDeletedBy, String userName, String emailId, String action) {
        EmailProps email = new EmailProps();
        email.setAction(action);
        email.setActionOn(userName);
        email.setActionBy(blockOrDeletedBy);
        email.setCloudName(cloudName);
        email.setToAdmins(false);
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(userName);
        emailRecipent.setEmail(emailId);
        ArrayList<EmailRecipent> recipentsList = new ArrayList<EmailRecipent>();
        recipentsList.add(emailRecipent);
        logger.debug("calling email..");
        email.setRecipents(recipentsList);
        this.cloudMailService.sendMail(email);
    }

    @Override
    public List<UserElement> getAllUsers(int cloudId, String cloudName) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        List usersList = this.userDao.getAllUsers(cloudId, cloudName);
        for (User user : usersList) {
            if (user == null) continue;
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            BackupPoliciesAdminList backupPolicyList = new BackupPoliciesAdminList();
            if (user.getBackupPoliciesAdmin() != null) {
                backupPolicyList.setBackupPoliciesAdmin(user.getBackupPoliciesAdmin());
                ue.setBackupPoliciesAdminList(backupPolicyList);
            }
            SyncPoliciesAdminList syncPolicyList = new SyncPoliciesAdminList();
            if (user.getSyncPoliciesAdmin() != null) {
                syncPolicyList.setSyncPoliciesAdmin(user.getSyncPoliciesAdmin());
                ue.setSyncPoliciesAdminList(syncPolicyList);
            }
            if (user.isGuest()) continue;
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public List<UserElement> getAllUsersIncludingGuest(int cloudId, String cloudName) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        List usersList = this.userDao.getAllUsers(cloudId, cloudName);
        for (User user : usersList) {
            if (user == null) continue;
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            BackupPoliciesAdminList backupPolicyList = new BackupPoliciesAdminList();
            if (user.getBackupPoliciesAdmin() != null) {
                backupPolicyList.setBackupPoliciesAdmin(user.getBackupPoliciesAdmin());
                ue.setBackupPoliciesAdminList(backupPolicyList);
            }
            SyncPoliciesAdminList syncPolicyList = new SyncPoliciesAdminList();
            if (user.getSyncPoliciesAdmin() != null) {
                syncPolicyList.setSyncPoliciesAdmin(user.getSyncPoliciesAdmin());
                ue.setSyncPoliciesAdminList(syncPolicyList);
            }
            ue.setUserId(user.getUserId());
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public UserElement getUserInfo(int cloudId, String cloudName, String userName) {
        ArrayList<MiniCloudElement> cloudElements = new ArrayList<MiniCloudElement>();
        UserElement usrElement = new UserElement();
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        if (user != null) {
            logger.debug(userName + "&&@@@$$$$$$@@..sync disabled.....");
            List ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, user.getUserId());
            if (!CollectionUtils.isEmpty((Collection)ucacList)) {
                for (UserCloudAccessControl ucac : ucacList) {
                    MiniCloudElement cloudElement = new MiniCloudElement();
                    MiniCloud cloud = this.miniCloudDao.getMiniCloudByID(cloudId, cloudName, ucac.getMiniCloudFK());
                    if (cloud == null) continue;
                    BeanUtils.copyProperties((Object)cloud, (Object)cloudElement);
                    cloudElements.add(cloudElement);
                }
            }
            if (StringUtils.isEmpty((String)user.getLastModifiedTimestamp())) {
                usrElement.setLastModifiedTimestamp(user.getCreatedTimestamp());
            }
            MiniCloudElementList miniCloudElementList = new MiniCloudElementList();
            miniCloudElementList.setMiniClouds(cloudElements);
            usrElement.setMiniCloudElementList(miniCloudElementList);
            BeanUtils.copyProperties((Object)user, (Object)usrElement);
            usrElement.setShareEnabled(user.isShareEnabled());
            PciAuthorizationTokens authorizationTokens = this.pciAuthorizationTokensDao.getPciAuthorizationTokensForUserId(cloudId, cloudName, user.getUserId());
            if (authorizationTokens != null) {
                usrElement.setExternalStorageAuthorized(true);
            } else {
                usrElement.setExternalStorageAuthorized(false);
            }
            logger.debug(".....policy name.... " + usrElement.getPolicyName() + "...sync..." + usrElement.getSyncPolicyName());
            if (StringUtils.isEmpty((String)usrElement.getPolicyName()) && StringUtils.isEmpty((String)usrElement.getSyncPolicyName())) {
                usrElement.setSyncPolicyName(usrElement.getSyncPolicyName());
                usrElement.setPolicyName(usrElement.getPolicyName());
            }
        } else {
            throw new EmptyResultDataAccessException(1);
        }
        return usrElement;
    }

    @Override
    public UserElement getUserInfoLatest(Cloud cloud, String userName) {
        ArrayList<MiniCloudElement> cloudElements = new ArrayList<MiniCloudElement>();
        UserElement usrElement = new UserElement();
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        List list = cloud.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        boolean isCloudLevelSyncEnabled = this.isCloudLevelSyncEnabled(list);
        if (user != null) {
            List ucacList;
            if (user.isReadOnlyAdmin()) {
                BackupPoliciesAdminList backupPolicyAdminList = new BackupPoliciesAdminList();
                backupPolicyAdminList.setBackupPoliciesAdmin(user.getBackupPoliciesAdmin());
                usrElement.setBackupPoliciesAdminList(backupPolicyAdminList);
                SyncPoliciesAdminList syncPolicyAdminList = new SyncPoliciesAdminList();
                syncPolicyAdminList.setSyncPoliciesAdmin(user.getSyncPoliciesAdmin());
                usrElement.setSyncPoliciesAdminList(syncPolicyAdminList);
                OdbPolicesAdminList odbPolicesAdminList = new OdbPolicesAdminList();
                odbPolicesAdminList.setOdbPoliciesAdminForUser(user.getOdbPoliciesAdmin());
                usrElement.setOdbPoliciesAdminList(odbPolicesAdminList);
            }
            logger.debug(userName + "&&@@@$$$$$$@@..sync ....." + isCloudLevelSyncEnabled);
            if (isCloudLevelSyncEnabled && !CollectionUtils.isEmpty((Collection)(ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, user.getUserId())))) {
                for (UserCloudAccessControl ucac : ucacList) {
                    MiniCloudElement cloudElement = new MiniCloudElement();
                    MiniCloud mc = this.miniCloudDao.getMiniCloudByID(cloudId, cloudName, ucac.getMiniCloudFK());
                    if (mc == null) continue;
                    BeanUtils.copyProperties((Object)mc, (Object)cloudElement);
                    cloudElements.add(cloudElement);
                }
            }
            if (StringUtils.isEmpty((String)user.getLastModifiedTimestamp())) {
                usrElement.setLastModifiedTimestamp(user.getCreatedTimestamp());
            }
            MiniCloudElementList miniCloudElementList = new MiniCloudElementList();
            miniCloudElementList.setMiniClouds(cloudElements);
            usrElement.setMiniCloudElementList(miniCloudElementList);
            BeanUtils.copyProperties((Object)user, (Object)usrElement);
            usrElement.setShareEnabled(user.isShareEnabled());
            PciAuthorizationTokens authorizationTokens = this.pciAuthorizationTokensDao.getPciAuthorizationTokensForUserId(cloudId, cloudName, user.getUserId());
            if (authorizationTokens != null) {
                usrElement.setExternalStorageAuthorized(true);
            } else {
                usrElement.setExternalStorageAuthorized(false);
            }
        } else {
            throw new EmptyResultDataAccessException(1);
        }
        logger.debug(".....policy name.... " + usrElement.getPolicyName() + "...sync..." + usrElement.getSyncPolicyName());
        usrElement.setSyncPolicyName(user.getSyncPolicyName());
        usrElement.setPolicyName(user.getPolicyName());
        return usrElement;
    }

    private boolean isCloudLevelSyncEnabled(List<CloudCustomisableDetails> list) {
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!SYNC_ENABLED.equalsIgnoreCase(customisableDetails.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public UserElement getUserByUserNameOrEmail(Cloud cloud, String userName) {
        ArrayList<MiniCloudElement> cloudElements = new ArrayList<MiniCloudElement>();
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        UserElement usrElement = new UserElement();
        User user = this.userDao.getUserByUserNameOrEmail(cloud.getCloudId(), userName);
        if (user == null && this.isAADEnabled(cloud.getCloudCustomisableDetails())) {
            user = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
        }
        if (user != null) {
            OfficeBackupPolicyElement officeBackupPolicyElement;
            SyncPolicyElement syncPolicyElement;
            BackupPolicyElement backupPolicyElement;
            logger.debug("...................." + user.isSyncEnabled());
            logger.debug("USer not null :" + user.getUserName());
            List ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloud.getCloudName(), user.getUserId());
            if (!CollectionUtils.isEmpty((Collection)ucacList)) {
                for (UserCloudAccessControl ucac : ucacList) {
                    MiniCloudElement cloudElement = new MiniCloudElement();
                    MiniCloud miniCloud = this.miniCloudDao.getMiniCloudByID(cloudId, cloudName, ucac.getMiniCloudFK());
                    if (miniCloud == null) continue;
                    BeanUtils.copyProperties((Object)miniCloud, (Object)cloudElement);
                    cloudElements.add(cloudElement);
                }
            }
            logger.debug(user.getUserName() + ".....loading policy......." + user.isBackupTargetAssigned());
            if (StringUtils.isEmpty((String)user.getLastModifiedTimestamp())) {
                usrElement.setLastModifiedTimestamp(user.getCreatedTimestamp());
            }
            MiniCloudElementList miniCloudElementList = new MiniCloudElementList();
            miniCloudElementList.setMiniClouds(cloudElements);
            usrElement.setMiniCloudElementList(miniCloudElementList);
            BeanUtils.copyProperties((Object)user, (Object)usrElement);
            usrElement.setShareEnabled(user.isShareEnabled());
            usrElement.setBackupTargetAssigned(user.isBackupTargetAssigned());
            PciAuthorizationTokens authorizationTokens = this.pciAuthorizationTokensDao.getPciAuthorizationTokensForUserId(cloudId, cloudName, user.getUserId());
            if (!StringUtils.isEmpty((String)usrElement.getPolicyName()) && (backupPolicyElement = this.getBackupPolicyElement(cloudId, this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, user.getPolicyName()))) != null) {
                usrElement.setBackupPolicyElement(this.getBackupPolicyElement(cloudId, this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, user.getPolicyName())));
            }
            if (!StringUtils.isEmpty((String)usrElement.getSyncPolicyName()) && (syncPolicyElement = this.getSyncPolicyElement(cloudId, this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, user.getSyncPolicyName()))) != null) {
                usrElement.setSyncPolicyElement(this.getSyncPolicyElement(cloudId, this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, user.getSyncPolicyName())));
            }
            if ((user.isOnedriveBkpEnabled() || user.isExchangeBkpEnabled()) && !StringUtils.isEmpty((String)user.getOdbPolicyName()) && (officeBackupPolicyElement = this.getOfficeBackupPolicyElement(cloudId, this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, user.getOdbPolicyName()))) != null) {
                usrElement.setOfficeBackupPolicyElement(officeBackupPolicyElement);
            }
            if (user.isReadOnlyAdmin()) {
                BackupPoliciesAdminList backupPolicyAdminList = new BackupPoliciesAdminList();
                backupPolicyAdminList.setBackupPoliciesAdmin(user.getBackupPoliciesAdmin());
                usrElement.setBackupPoliciesAdminList(backupPolicyAdminList);
                SyncPoliciesAdminList syncPolicyAdminList = new SyncPoliciesAdminList();
                syncPolicyAdminList.setSyncPoliciesAdmin(user.getSyncPoliciesAdmin());
                usrElement.setSyncPoliciesAdminList(syncPolicyAdminList);
                OdbPolicesAdminList odbPolicesAdminList = new OdbPolicesAdminList();
                odbPolicesAdminList.setOdbPoliciesAdminForUser(user.getOdbPoliciesAdmin());
                usrElement.setOdbPoliciesAdminList(odbPolicesAdminList);
            }
            if (authorizationTokens != null) {
                usrElement.setExternalStorageAuthorized(true);
            } else {
                usrElement.setExternalStorageAuthorized(false);
            }
            if (!StringUtils.isEmpty((String)user.getMigrationStatus()) && User.MIGRATION_STATUS.IN_PROGRESS.toString().equalsIgnoreCase(user.getMigrationStatus())) {
                usrElement.setUserUnderOdbMigration(true);
            }
        } else {
            return null;
        }
        usrElement.setGoogleSecretKey(user.getGoogleSecretKey());
        usrElement.setConsentGiven(user.getConsentGiven());
        logger.debug(".....loading getUserByUserNameOrEmail......." + usrElement.isSyncEnabled());
        return usrElement;
    }

    private BackupPolicyElement getBackupPolicyElement(int cloudId, BackupPolicy backupPolicy) {
        BackupPolicyElement element = null;
        ArrayList<String> folderPaths = new ArrayList<String>();
        ArrayList<String> scheduleNames = new ArrayList<String>();
        ArrayList<String> networkThrottlingNames = new ArrayList<String>();
        ArrayList calloutScriptStrs = new ArrayList();
        if (backupPolicy == null) {
            return null;
        }
        for (Schedule schedule : backupPolicy.getSchedules()) {
            scheduleNames.add(schedule.getScheduleName());
        }
        for (NetworkThrottling networkThrottling : backupPolicy.getNetworkThrottlings()) {
            networkThrottlingNames.add(networkThrottling.getNetworkThrottlingName());
        }
        for (BackupFolders backupFolder : backupPolicy.getBackupFolders()) {
            BackupFolderElement backupFolderElement = new BackupFolderElement();
            if (backupFolder == null) continue;
            backupFolderElement.setFolderPath(backupFolder.getFolderPath());
            backupFolderElement.setOsType(backupFolder.getOs());
            folderPaths.add(backupFolder.getFolderPath());
        }
        if (backupPolicy != null) {
            element = new BackupPolicyElement();
            BeanUtils.copyProperties((Object)backupPolicy, (Object)element);
            element.setPolicygroupName(backupPolicy.getPolicyName());
            element.setExceptionsToExclusions(new ArrayList());
            element.setBackupFolderPaths(new ArrayList());
            element.getBackupFolderPaths().addAll(folderPaths);
            if (element.getNwFromClientToPGMB() <= 0.0) {
                element.setNwFromClientToPGMB((double)element.getNwFromClientToPG().longValue());
            }
            element.setCalloutScripts(calloutScriptStrs);
            List filters = backupPolicy.getInclusionFilter();
            List<Object> filterNames = new ArrayList();
            if (filters != null) {
                filterNames = filters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList());
                element.setFilterInclusionName(filterNames);
            }
            element.setNetworkThrottlingNames(new ArrayList());
            element.setScheduleNames(new ArrayList());
            element.getNetworkThrottlingNames().addAll(networkThrottlingNames);
            element.getScheduleNames().addAll(scheduleNames);
            element.setEndpointUiPreferences((List)backupPolicy.getEndpointUiPreferences());
            element.setEndpointDisabledUiPreferences(backupPolicy.getEndpointDisabledUiPreferences());
            ArrayList list = backupPolicy.getPrivacyGateways();
            PrivacyGatewayMappingElement mappingElement = new PrivacyGatewayMappingElement();
            ArrayList<String> pgList = new ArrayList<String>();
            for (PrivacyGateway privacyGateway : list) {
                if (privacyGateway == null) continue;
                mappingElement.setGatewayNwThrottlingName("PGThrottle-name");
                pgList.add(privacyGateway.getGatewayName());
            }
            mappingElement.setPrivacyGatewayNames(new ArrayList());
            mappingElement.setPrivacyGatewayNames(pgList);
            element.setPrivacyGatewayMappingElement(mappingElement);
            element.setSearchAlgoForPg(backupPolicy.getSearchAlgoForPg());
            if (backupPolicy.getCloudCredentials() != null) {
                element.setCloudCredential(backupPolicy.getCloudCredentials().getIdentity());
            }
        }
        return element;
    }

    public SyncPolicyElement getSyncPolicyElement(int cloudId, SyncPolicy syncPolicy) {
        ArrayList<String> netWorkThrottlingNames = new ArrayList<String>();
        if (syncPolicy == null) {
            return null;
        }
        for (NetworkThrottling netWorkThrottling : syncPolicy.getNetworkThrottlings()) {
            netWorkThrottlingNames.add(netWorkThrottling.getNetworkThrottlingName());
        }
        SyncPolicyElement element = new SyncPolicyElement();
        BeanUtils.copyProperties((Object)syncPolicy, (Object)element);
        element.setPolicygroupName(syncPolicy.getPolicyName());
        element.setNetworkThrottlingNames(new ArrayList());
        element.getNetworkThrottlingNames().addAll(netWorkThrottlingNames);
        List filters = syncPolicy.getInclusionFilter();
        List<Object> filterNames = new ArrayList();
        if (filters != null) {
            filterNames = filters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList());
            element.setFilterInclusionName(filterNames);
        }
        ArrayList list = syncPolicy.getPrivacyGateways();
        PrivacyGatewayMappingElement mappingElement = new PrivacyGatewayMappingElement();
        if (element.getNwFromClientToPGMB() <= 0.0) {
            element.setNwFromClientToPGMB((double)element.getNwFromClientToPG().longValue());
        }
        if (!CollectionUtils.isEmpty((Collection)list)) {
            ArrayList<String> pgList = new ArrayList<String>();
            for (PrivacyGateway privacyGateway : list) {
                if (privacyGateway == null) continue;
                mappingElement.setGatewayNwThrottlingName("PGThrottle-name");
                pgList.add(privacyGateway.getGatewayName());
            }
            mappingElement.setPrivacyGatewayNames(new ArrayList());
            mappingElement.setPrivacyGatewayNames(pgList);
            element.setPrivacyGatewayMappingElement(mappingElement);
        } else {
            element.setPrivacyGatewayMappingElement(mappingElement);
        }
        if (syncPolicy.getCloudCredentials() != null) {
            element.setCloudCredential(syncPolicy.getCloudCredentials().getIdentity());
        }
        element.setSearchAlgoForPg(syncPolicy.getSearchAlgoForPg());
        element.setEndpointUiPreferences((List)syncPolicy.getEndpointUiPreferences());
        element.setEndpointDisabledUiPreferences(syncPolicy.getEndpointDisabledUiPreferences());
        return element;
    }

    @Override
    public UserElement updateUserInfo(int cloudId, String cloudName, UserElement userElement) {
        OdbPolicesAdminList odbPolicyAdminList;
        SyncPoliciesAdminList syncPolicyAdminList;
        BackupPolicy bkpPolicy;
        UserElement usrResponse = new UserElement();
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userElement.getUserName());
        boolean softBlockEnabled = user.isSoftBlockEnabled();
        ObjectId userId = user.getUserId();
        BeanUtils.copyProperties((Object)userElement, (Object)user);
        user.setSoftBlockEnabled(softBlockEnabled);
        user.setShareEnabled(userElement.isShareEnabled());
        user.setServerBackupEnabled(userElement.isServerBackupEnabled());
        user.setUserId(userId);
        user.setLastModifiedTimestamp(String.valueOf(System.currentTimeMillis()));
        if (StringUtils.isNotEmpty((String)user.getPolicyName()) && (bkpPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName())) != null && bkpPolicy.isLegalHoldEnabled()) {
            user.setAdmin(false);
        }
        logger.debug(" @@@@@@@@@@@@@@@ before updated USER .... " + userId);
        BackupPoliciesAdminList backupPolicyAdminList = userElement.getBackupPoliciesAdminList();
        if (backupPolicyAdminList != null) {
            List backupPoliciesAdmin = backupPolicyAdminList.getBackupPoliciesAdmin();
            user.setBackupPoliciesAdmin(backupPoliciesAdmin);
        }
        if ((syncPolicyAdminList = userElement.getSyncPoliciesAdminList()) != null) {
            List syncPoliciesAdmin = syncPolicyAdminList.getSyncPoliciesAdmin();
            user.setSyncPoliciesAdmin(syncPoliciesAdmin);
        }
        if ((odbPolicyAdminList = userElement.getOdbPoliciesAdminList()) != null) {
            List odbPoliciesAdmin = odbPolicyAdminList.getOdbPoliciesAdminForUser();
            logger.debug("odbpolicies for admin..." + odbPoliciesAdmin);
            user.setOdbPoliciesAdmin(odbPoliciesAdmin);
        }
        user.setPolicyModifiedTime(System.currentTimeMillis());
        User updatedUser = this.userDao.updateUser(cloudId, cloudName, user);
        this.deviceDao.updateUserInfoInDeviceBkpOverview(cloudId, updatedUser);
        logger.debug(" @@@@@@@@@@@@@@@ updated USER .... " + updatedUser);
        if (updatedUser != null) {
            List ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, updatedUser.getUserId());
            logger.debug("mapping found: " + ucacList.size());
            for (UserCloudAccessControl ucac : ucacList) {
                this.userMiniCloudMappingDao.deleteUserCloudAccessControlMapping(cloudId, cloudName, ucac);
            }
            MiniCloudElementList cloudElementLists = userElement.getMiniCloudElementList();
            List cloudElements = cloudElementLists.getMiniClouds();
            ArrayList<MiniCloudElement> cloudElementsForResp = new ArrayList<MiniCloudElement>();
            for (MiniCloudElement cloudElement : cloudElements) {
                MiniCloud miniCloud = this.miniCloudDao.getMiniCloudByName(cloudId, cloudName, cloudElement.getMiniCloudName());
                if (miniCloud == null) continue;
                UserCloudAccessControl accessControl = new UserCloudAccessControl();
                accessControl.setMiniCloudFK(miniCloud.getId());
                accessControl.setUserFK(updatedUser.getUserId());
                this.userMiniCloudMappingDao.saveMiniCloud(cloudId, cloudName, accessControl);
                MiniCloudElement miniCloudForResp = new MiniCloudElement();
                BeanUtils.copyProperties((Object)miniCloud, (Object)miniCloudForResp);
                cloudElementsForResp.add(miniCloudForResp);
            }
            cloudElements.clear();
            cloudElements.addAll(cloudElementsForResp);
            cloudElementLists.setMiniClouds(cloudElements);
            BeanUtils.copyProperties((Object)updatedUser, (Object)usrResponse);
            usrResponse.setShareEnabled(updatedUser.isShareEnabled());
            usrResponse.setMiniCloudElementList(cloudElementLists);
        }
        return usrResponse;
    }

    @Override
    public UserElement updateUserInfoFromGuestToUser(int cloudId, String cloudName, UserElement userElement) {
        UserElement usrResponse = new UserElement();
        try {
            OdbPolicesAdminList odbPolicyAdminList;
            SyncPoliciesAdminList syncPolicyAdminList;
            BackupPolicy bkpPolicy;
            User user = this.userDao.getUserByUserNameOrEmail(cloudId, userElement.getUserName());
            if (user == null) {
                user = this.userDao.getUserByUserNameOrEmail(cloudId, userElement.getEmailId());
            }
            boolean softBlockEnabled = user.isSoftBlockEnabled();
            ObjectId userId = user.getUserId();
            BeanUtils.copyProperties((Object)userElement, (Object)user);
            user.setSoftBlockEnabled(softBlockEnabled);
            user.setShareEnabled(userElement.isShareEnabled());
            user.setServerBackupEnabled(userElement.isServerBackupEnabled());
            user.setUserId(userId);
            user.setActive(true);
            user.setLastModifiedTimestamp(String.valueOf(System.currentTimeMillis()));
            if (StringUtils.isNotEmpty((String)user.getPolicyName()) && (bkpPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName())) != null && bkpPolicy.isLegalHoldEnabled()) {
                user.setAdmin(false);
            }
            logger.debug(" @@@@@@@@@@@@@@@ before updated USER .... " + userId);
            BackupPoliciesAdminList backupPolicyAdminList = userElement.getBackupPoliciesAdminList();
            if (backupPolicyAdminList != null) {
                List backupPoliciesAdmin = backupPolicyAdminList.getBackupPoliciesAdmin();
                user.setBackupPoliciesAdmin(backupPoliciesAdmin);
            }
            if ((syncPolicyAdminList = userElement.getSyncPoliciesAdminList()) != null) {
                List syncPoliciesAdmin = syncPolicyAdminList.getSyncPoliciesAdmin();
                user.setSyncPoliciesAdmin(syncPoliciesAdmin);
            }
            if ((odbPolicyAdminList = userElement.getOdbPoliciesAdminList()) != null) {
                List odbPoliciesAdmin = odbPolicyAdminList.getOdbPoliciesAdminForUser();
                logger.debug("odbpolicies for admin..." + odbPoliciesAdmin);
                user.setOdbPoliciesAdmin(odbPoliciesAdmin);
            }
            user.setPolicyModifiedTime(System.currentTimeMillis());
            user.setUserNameLowerCase(user.getUserName().toLowerCase());
            User updatedUser = this.userDao.updateUser(cloudId, cloudName, user);
            this.deviceDao.updateUserInfoInDeviceBkpOverview(cloudId, updatedUser);
            logger.debug(" @@@@@@@@@@@@@@@ updated USER .... " + updatedUser);
            if (updatedUser != null) {
                List ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, updatedUser.getUserId());
                logger.debug("mapping found: " + ucacList.size());
                for (UserCloudAccessControl ucac : ucacList) {
                    this.userMiniCloudMappingDao.deleteUserCloudAccessControlMapping(cloudId, cloudName, ucac);
                }
                MiniCloudElementList cloudElementLists = userElement.getMiniCloudElementList();
                if (cloudElementLists != null) {
                    List cloudElements = cloudElementLists.getMiniClouds();
                    ArrayList<MiniCloudElement> cloudElementsForResp = new ArrayList<MiniCloudElement>();
                    for (MiniCloudElement cloudElement : cloudElements) {
                        MiniCloud miniCloud = this.miniCloudDao.getMiniCloudByName(cloudId, cloudName, cloudElement.getMiniCloudName());
                        if (miniCloud == null) continue;
                        UserCloudAccessControl accessControl = new UserCloudAccessControl();
                        accessControl.setMiniCloudFK(miniCloud.getId());
                        accessControl.setUserFK(updatedUser.getUserId());
                        this.userMiniCloudMappingDao.saveMiniCloud(cloudId, cloudName, accessControl);
                        MiniCloudElement miniCloudForResp = new MiniCloudElement();
                        BeanUtils.copyProperties((Object)miniCloud, (Object)miniCloudForResp);
                        cloudElementsForResp.add(miniCloudForResp);
                    }
                    cloudElements.clear();
                    cloudElements.addAll(cloudElementsForResp);
                    cloudElementLists.setMiniClouds(cloudElements);
                }
                BeanUtils.copyProperties((Object)updatedUser, (Object)usrResponse);
                usrResponse.setShareEnabled(updatedUser.isShareEnabled());
                usrResponse.setMiniCloudElementList(cloudElementLists);
            }
            return usrResponse;
        }
        catch (BeansException e) {
            logger.error("error.....", (Object)e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            logger.error("error.....", (Object)e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public UserElement deleteUser(int cloudId, String cloudName, String userId) {
        UserElement usrResponse = new UserElement();
        User user = this.userDao.getUserInfo(cloudId, userId);
        if (user == null) {
            throw new BaseException(USER_NOT_FOUND);
        }
        List ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, user.getUserId());
        logger.debug("mapping found: " + ucacList.size());
        for (UserCloudAccessControl ucac : ucacList) {
            this.userMiniCloudMappingDao.deleteUserCloudAccessControlMapping(cloudId, cloudName, ucac);
        }
        this.deviceDao.deleteAllDeviceByUser(cloudId, cloudName, user);
        this.deviceDao.deleteAllDeviceBkpoverviewByUser(cloudId, user);
        this.authorizationDao.deleteAllTokensForUser(cloudId, cloudName, user);
        BeanUtils.copyProperties((Object)user, (Object)usrResponse);
        usrResponse.setShareEnabled(user.isShareEnabled());
        this.userDao.deleteUser(cloudId, cloudName, user);
        return usrResponse;
    }

    @Override
    public List<Device> blockUnblockDevicebyUserName(int cloudId, String cloudName, String userName, boolean toBlock) {
        List devices = new ArrayList();
        ArrayList<Device> blockedDevice = new ArrayList<Device>();
        devices = this.deviceDao.getDeviceByUserName(cloudId, userName);
        if (!CollectionUtils.isEmpty(devices)) {
            for (Device device : devices) {
                if (device.isBlocked()) continue;
                this.deviceDao.blockUnblockDevice(cloudId, cloudName, device, toBlock);
                this.deviceDao.updateDeviceStatusInOverview(cloudId, device.getDeviceUUID(), toBlock);
                if (toBlock) {
                    User user = this.userDao.getUserByName(cloudId, device.getUserName());
                    this.authorizationDao.deleteAuthTokenByUserAndUniqueID(cloudId, user, device.getDeviceUUID());
                }
                blockedDevice.add(device);
            }
        }
        return blockedDevice;
    }

    @Override
    public User authenticate(int cloudId, String cloudName, String username, String passowrd) {
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, username);
        if (user == null) {
            throw new BaseException(USER_NOT_FOUND, 401);
        }
        if (StringUtils.isEmpty((String)user.getPasswdHash()) || !user.getPasswdHash().equals(passowrd)) {
            throw new BaseException("Bad Credentials.", 401);
        }
        if (!user.isActive()) {
            throw new BaseException("User is not active", 403);
        }
        return user;
    }

    @Override
    public User authenticateV2(int cloudId, String cloudName, String username) {
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, username);
        if (user == null) {
            throw new BaseException(USER_NOT_FOUND, 401);
        }
        if (!user.isActive()) {
            throw new BaseException("User is not active", 403);
        }
        return user;
    }

    @Override
    public void verifyRecoveryKey(int cloudId, String cloudName, String userName, String key) {
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        if (user == null) {
            throw new BaseException(USER_NOT_FOUND);
        }
        String recoveryKey = user.getSecurityRecoveryKey();
        for (int i = 0; i < 5; ++i) {
            recoveryKey = MD5Generator.generateMD5OfString((String)recoveryKey);
        }
        if (recoveryKey.equals(key)) {
            return;
        }
        throw new BaseException("Bad Credentials.");
    }

    @Override
    public User updateUserInfo(int cloudId, String cloudName, User user) {
        this.deviceDao.updateUserInfoInDeviceBkpOverview(cloudId, user);
        return this.userDao.updateUser(cloudId, cloudName, user);
    }

    @Override
    public UserElement validateRecoveryParams(int cloudId, String cloudName, UserElement userElement) {
        String userName = userElement.getUserName();
        String email = userElement.getEmailId();
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        if (user != null && userName.equalsIgnoreCase(user.getUserName()) && email.equalsIgnoreCase(user.getEmailId()) && user.isActive()) {
            BeanUtils.copyProperties((Object)user, (Object)userElement);
            userElement.setShareEnabled(user.isShareEnabled());
            return userElement;
        }
        return null;
    }

    @Override
    public User getUserDetails(int cloudId, String cloudName, String userName) {
        return this.userDao.getUserInfoByName(cloudId, cloudName, userName);
    }

    @Override
    public List<User> getAllActiveUsers(int cloudId) {
        return this.userDao.getAllActiveUsers(cloudId);
    }

    @Override
    public List<User> getAllUsersDetails(int cloudId, String cloudName) {
        return this.userDao.getAllUsers(cloudId, cloudName);
    }

    @Override
    public List<User> getAllAdmins(int cloudId, String cloudName) {
        return this.userDao.getAllAdmins(cloudId, cloudName);
    }

    @Override
    public UserElement createUser(int cloudId, String cloudName, User user) {
        UserElement userResponse = new UserElement();
        UUID uuid = UUID.randomUUID();
        String recoveryKey = String.valueOf(uuid);
        user.setSecurityRecoveryKey(recoveryKey);
        user.setActive(true);
        user.setFirstLogin(true);
        user.setUserNameLowerCase(user.getUserName().toLowerCase());
        user.setCreatedTimestamp(String.valueOf(System.currentTimeMillis()));
        UserElement userElement = new UserElement();
        BeanUtils.copyProperties((Object)user, (Object)userElement);
        UserElement createduserElement = this.createUser(cloudId, cloudName, userElement, false, this.userDao);
        if (createduserElement != null) {
            logger.debug(user.isShareEnabled() + "&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&" + createduserElement.isShareEnabled());
            userResponse.setShareEnabled(createduserElement.isShareEnabled());
            BeanUtils.copyProperties((Object)createduserElement, (Object)userResponse);
        }
        String recoveryKeyHash = recoveryKey;
        for (int i = 0; i < 5; ++i) {
            recoveryKeyHash = MD5Generator.generateMD5OfString((String)recoveryKeyHash);
        }
        userResponse.setSecurityRecoveryKey(recoveryKeyHash);
        return userResponse;
    }

    @Override
    public boolean createUserFromLdap(int cloudId, String cloudName, LdapUserElement ldapUserElement, String migratedBy, boolean isSyncEnabled, boolean isBackupEnabled, boolean odbBkpEnabled, boolean exchangeBkpEnabled) throws Exception {
        boolean userMigrated = false;
        try {
            User userFromDB = this.userDao.getUserByUserNameOrAADLoginId(cloudId, ldapUserElement.getUserName());
            if (userFromDB == null) {
                userFromDB = this.userDao.getUserByUserNameOrEmail(cloudId, ldapUserElement.getEmailId());
            }
            if (userFromDB != null && userFromDB.isGuest()) {
                this.userDao.removeUserbyID(cloudId, userFromDB.getUserId().toString());
            }
            User user = new User();
            UUID uuid = UUID.randomUUID();
            String recoveryKey = String.valueOf(uuid);
            user.setSecurityRecoveryKey(recoveryKey);
            user.setActive(true);
            user.setAdmin(false);
            user.setBackupEnabled(isBackupEnabled);
            user.setSyncEnabled(isSyncEnabled);
            user.setOnedriveBkpEnabled(odbBkpEnabled);
            user.setExchangeBkpEnabled(exchangeBkpEnabled);
            user.setFirstLogin(true);
            user.setShareEnabled(true);
            user.setUserName(ldapUserElement.getUserName());
            user.setEmailId(ldapUserElement.getEmailId());
            user.setCreatedTimestamp(String.valueOf(System.currentTimeMillis()));
            user.setDisplayName(ldapUserElement.getDisplayName());
            user.setMigratedBy(migratedBy);
            user.setlocalUser(false);
            user.setLocation(ldapUserElement.getLocation());
            user.setDepartment(ldapUserElement.getDepartment());
            user.setAccountStatus(ldapUserElement.isAccountStatus());
            user.setUserNameLowerCase(ldapUserElement.getUserName().toLowerCase());
            if (!StringUtils.isEmpty((String)ldapUserElement.getDefaultPolicy())) {
                user.setPolicyName(ldapUserElement.getDefaultPolicy());
            }
            if (!StringUtils.isEmpty((String)ldapUserElement.getDefaultSyncPolicy())) {
                user.setSyncPolicyName(ldapUserElement.getDefaultSyncPolicy());
            }
            if (!StringUtils.isEmpty((String)ldapUserElement.getDefaultO365Policy())) {
                user.setOdbPolicyName(ldapUserElement.getDefaultO365Policy());
            }
            String googleSecretKey = this.getGoogleSecurityKey();
            logger.debug("googleSecretKey for AAD ....." + googleSecretKey);
            user.setGoogleSecretKey(googleSecretKey);
            UserElement userElement = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)userElement);
            UserElement createduserElement = this.createUser(cloudId, cloudName, userElement, false, this.userDao);
            if (createduserElement != null) {
                userMigrated = true;
                MigrationStatus migrationStatus = new MigrationStatus();
                migrationStatus.setMigratedBy(migratedBy);
                migrationStatus.setMigratededTimestamp(System.currentTimeMillis());
                migrationStatus.setMigrated(true);
                migrationStatus.setUserName(user.getUserName());
                migrationStatus.setEmailId(user.getEmailId());
                this.migrationStatusDao.saveMigrationStatus(cloudId, migrationStatus);
            }
        }
        catch (Exception e) {
            logger.error(EXCEPTION + e);
            logger.debug(EXCEPTION + e.getMessage());
            throw new Exception(e);
        }
        return userMigrated;
    }

    @Override
    public List<User> getAllShareEnabledActiveUsers(int cloudId, String cloudName) {
        return this.userDao.getAllShareEnabledActiveUsers(cloudId, cloudName);
    }

    @Override
    public void saveFailedLogin(int cloudId, String cloudName, FailedLogin failedLogin) {
        this.userDao.saveFailedLogin(cloudId, cloudName, failedLogin);
    }

    @Override
    public User getUserInfoById(int cloudId, String cloudName, String userId) {
        return this.userDao.getUserInfo(cloudId, userId);
    }

    @Override
    public List<UserElement> searchUsers(int cloudId, String userName) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(userName.split(",")));
        HashSet<String> removeSet = new HashSet<String>();
        removeSet.addAll(list);
        list.clear();
        list.addAll(removeSet);
        List users = this.userDao.searchUsers(cloudId, list);
        for (User user : users) {
            if (user == null) continue;
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            if (ue.isGuest()) continue;
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public List<UserElement> searchUserbyUsernameOrDisplaynameOrEmailId(int cloudId, String userName) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(userName.split(",")));
        HashSet<String> removeSet = new HashSet<String>();
        removeSet.addAll(list);
        list.clear();
        list.addAll(removeSet);
        List users = this.userDao.searchUserbyUsernameOrDisplaynameOrEmailId(cloudId, list);
        for (User user : users) {
            if (user == null) continue;
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            BackupPoliciesAdminList backupPolicyList = new BackupPoliciesAdminList();
            if (user.getBackupPoliciesAdmin() != null) {
                backupPolicyList.setBackupPoliciesAdmin(user.getBackupPoliciesAdmin());
                ue.setBackupPoliciesAdminList(backupPolicyList);
            }
            SyncPoliciesAdminList syncPolicyList = new SyncPoliciesAdminList();
            if (user.getSyncPoliciesAdmin() != null) {
                syncPolicyList.setSyncPoliciesAdmin(user.getSyncPoliciesAdmin());
                ue.setSyncPoliciesAdminList(syncPolicyList);
            }
            if (user.isGuest()) continue;
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public List<UserElement> getAllUsers(int cloudId, int skipValue) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        List usersList = this.userDao.getAllUsers(cloudId, "", skipValue);
        logger.debug(" user names list ... " + usersList.size());
        for (User user : usersList) {
            logger.debug(" user names ... " + user.getUserName());
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            if (!StringUtils.isEmpty((String)user.getMigrationStatus()) && User.MIGRATION_STATUS.IN_PROGRESS.toString().equalsIgnoreCase(user.getMigrationStatus())) {
                ue.setUserUnderOdbMigration(true);
            }
            if (ue.isGuest()) continue;
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public long getAllUsersCount(int cloudId, List<String> policyNames) {
        return this.userDao.getAllUsersCount(cloudId, policyNames);
    }

    @Override
    public List<UserElement> getAllUsers(int cloudId, int skipValue, User logedInUser) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        List usersList = this.userDao.getAllUsers(cloudId, "", skipValue);
        logger.debug(" user names list ... " + usersList.size());
        for (User user : usersList) {
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            if (user.isGuest()) continue;
            userElementList.add(ue);
        }
        this.getValidUsers(logedInUser, userElementList);
        return userElementList;
    }

    @Override
    public List<UserElement> getAllUsersWithoutdevice(int cloudId, int skipValue, List<String> policyNames, boolean showBlockedDevicesBol, String productType) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        List loadAllDeviceUserIds = new ArrayList();
        loadAllDeviceUserIds = this.deviceDao.getAllDevices(cloudId);
        boolean backup = true;
        boolean onedrive = true;
        boolean exchange = true;
        if (!StringUtils.isEmpty((String)productType)) {
            if ("BACKUP".equalsIgnoreCase(productType)) {
                onedrive = false;
                exchange = false;
            }
            if ("ONEDRIVE".equalsIgnoreCase(productType)) {
                backup = false;
                exchange = false;
            }
            if ("MAIL".equalsIgnoreCase(productType)) {
                onedrive = false;
                backup = false;
            }
        }
        logger.debug(productType + "..show blocked devices ..." + showBlockedDevicesBol);
        logger.debug(productType + "..show devices ..." + backup + ".." + onedrive + "..." + exchange);
        ArrayList<ObjectId> userIds = new ArrayList<ObjectId>();
        for (Device dev : loadAllDeviceUserIds) {
            boolean allowDevices = true;
            if (dev == null || dev.isDeleted()) continue;
            if (dev.isBlocked() && showBlockedDevicesBol) {
                allowDevices = false;
            }
            logger.debug("...... " + dev.getDeviceName() + "..." + allowDevices);
            if (!allowDevices) continue;
            logger.debug("...devdevice...." + dev.getDeviceName());
            if (onedrive && "ONEDRIVE".equalsIgnoreCase(dev.getDeviceType())) {
                userIds.add(dev.getUserId());
            }
            if (exchange && "OUTLOOK".equalsIgnoreCase(dev.getDeviceType())) {
                userIds.add(dev.getUserId());
            }
            if (!backup || !"BACKUP".equalsIgnoreCase(dev.getDeviceType())) continue;
            userIds.add(dev.getUserId());
            logger.debug("...backupdevice...." + dev.getDeviceName());
        }
        logger.debug("....userIds....." + userIds.size());
        List usersNotConnectedToDevice = new ArrayList();
        usersNotConnectedToDevice = backup ? this.userDao.getUsersNotConnectedToDevice(cloudId, userIds, true) : this.userDao.getODBUsersNotConnectedToDevice(cloudId, userIds);
        logger.debug(policyNames.size() + " user names list ... " + usersNotConnectedToDevice.size());
        for (User user : usersNotConnectedToDevice) {
            logger.debug(user.getPolicyName() + " user names ... " + user.getUserName());
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            if (backup && !user.isBackupEnabled() || onedrive && !user.isOnedriveBkpEnabled() || exchange && !user.isExchangeBkpEnabled()) continue;
            if (!CollectionUtils.isEmpty(policyNames)) {
                if (StringUtils.isEmpty((String)user.getPolicyName()) || !policyNames.contains(user.getPolicyName()) || user.isGuest()) continue;
                userElementList.add(ue);
                continue;
            }
            if (user.isGuest()) continue;
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public void markUserAsDelete(int cloudId, String cloudName, String userName, String deletedBy) {
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        if (user == null) {
            throw new BaseException(USER_NOT_FOUND);
        }
        this.userMiniCloudMappingDao.deleteUserCloudAccessControlMappingWithUserFK(cloudId, cloudName, user.getUserId());
        this.deviceDao.markAllDevicesAsDeletedForUser(cloudId, cloudName, user);
        this.authorizationDao.deleteAllTokensForUser(cloudId, cloudName, user);
        user.setDeleted(true);
        this.userDao.updateUser(cloudId, cloudName, user);
        this.deviceDao.markUserAndDeviceAsDeleteInDeviceBkpOverview(cloudId, user);
        this.saveDeletedUser(cloudId, cloudName, userName, user);
        this.multipleUserBlockOrDeleteMail(cloudName, cloudId, deletedBy, user.getUserName(), user.getEmailId(), "user-delete");
    }

    public void saveDeletedUser(int cloudId, String cloudName, String userName, User user) {
        logger.debug("saving deleted user on database");
        DeletedUser deletedUser = new DeletedUser();
        ArrayList<String> deviceUUIDs = new ArrayList<String>();
        List allDevicesForUser = this.deviceDao.getAllDevicesByUser(cloudId, user);
        boolean oneDriveDevice = false;
        if (allDevicesForUser != null) {
            for (Device device : allDevicesForUser) {
                if (device == null || device.getDeviceUUID() == null) continue;
                deviceUUIDs.add(device.getDeviceUUID());
                if (StringUtils.isEmpty((String)device.getDeviceType()) || !device.getDeviceType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.name())) continue;
                oneDriveDevice = true;
            }
        }
        deletedUser.setUserName(userName);
        deletedUser.setLastModifiedTimestamp(String.valueOf(System.currentTimeMillis()));
        deletedUser.setDeviceUUIDs(deviceUUIDs);
        deletedUser.setUserId(user.getUserId());
        this.deletedUserDao.saveDeletedUser(cloudId, cloudName, deletedUser);
        DeletedSearchIndex deletedSearchIndex = new DeletedSearchIndex();
        deletedSearchIndex.setId(new ObjectId());
        deletedSearchIndex.setCloudId(cloudId);
        deletedSearchIndex.setCloudName(cloudName);
        deletedSearchIndex.setUserDelete(true);
        deletedSearchIndex.setUserName(user.getUserName());
        if (oneDriveDevice) {
            deletedSearchIndex.setOneDrive(true);
        }
        this.searchIndexDao.addDeleteIndex(deletedSearchIndex);
        logger.debug("saved deleted user on database");
    }

    @Override
    public List<DeletedUser> getAllDeletedUsers(int cloudId, String cloudName) {
        return this.deletedUserDao.getAllDeletedUsers(cloudId, cloudName);
    }

    @Override
    public List<User> getAllDeletedUsers(int cloudId) {
        return this.userDao.getAllDeletedUsers(cloudId);
    }

    @Override
    public List<UserElement> getAllDeletedUsersById(int cloudId, String cloudName, List<ObjectId> userIds) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        List usersList = this.userDao.getAllDeletedUsersById(cloudId, cloudName, userIds);
        for (User user : usersList) {
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            userElementList.add(ue);
        }
        return userElementList;
    }

    public void setDeletedUserDao(DeletedUserDao deletedUserDao) {
        this.deletedUserDao = deletedUserDao;
    }

    @Override
    public boolean isUserUnderLegalHold(int cloudId, String userId) {
        User user = this.userDao.getUserInfo(cloudId, userId);
        BackupPolicy backupPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName());
        return backupPolicy != null && backupPolicy.isLegalHoldEnabled();
    }

    @Override
    public boolean isUserUnderLegalHoldForUserName(int cloudId, String userName) {
        boolean userUnderLegalHold = false;
        User user = this.userDao.getUserByName(cloudId, userName);
        BackupPolicy backupPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName());
        if (backupPolicy != null && backupPolicy.isLegalHoldEnabled()) {
            logger.debug("User cannot be admin He/She is under legal hold .......");
            userUnderLegalHold = true;
            return userUnderLegalHold;
        }
        OfficeBackupPolicy officeBackupPolicy = this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, user.getOdbPolicyName());
        if (officeBackupPolicy != null && officeBackupPolicy.isLegalHoldEnabled()) {
            logger.debug("User cannot be admin He/She is under legal hold ......." + officeBackupPolicy.getPolicyName());
            userUnderLegalHold = true;
            return userUnderLegalHold;
        }
        return userUnderLegalHold;
    }

    @Override
    public List<UserElement> getAllLegalHoldUsers(int cloudId, String cloudName) {
        List legalHoldPolicies = this.backupPolicyDao.getAllLegalHoldBackupPolicies(cloudId, cloudName);
        ArrayList<UserElement> legalHoldUserElements = new ArrayList<UserElement>();
        for (BackupPolicy backupPolicy : legalHoldPolicies) {
            List userList = this.userDao.getUsersByBackupPolicyName(cloudId, backupPolicy.getPolicyName());
            for (User user : userList) {
                UserElement element = new UserElement();
                if (user == null) continue;
                BeanUtils.copyProperties((Object)user, (Object)element);
                legalHoldUserElements.add(element);
            }
        }
        return legalHoldUserElements;
    }

    @Override
    public boolean isUserOwnerOfAnyMiniCloud(int cloudId, String userName) {
        List list = this.miniCloudDao.getAllMiniCloudForUser(cloudId, userName);
        return !CollectionUtils.isEmpty((Collection)list);
    }

    @Override
    public boolean checkIfEmailAlreadyExists(int cloudId, String emailId) {
        return this.userDao.checkIfEmailAlreadyExists(cloudId, emailId);
    }

    @Override
    public boolean checkIfEmailAlreadyExistsAsUserName(int cloudId, String emailId) {
        return this.userDao.checkIfEmailAlreadyExistsAsUserName(cloudId, emailId);
    }

    @Override
    public List<User> getAllUsersForNames(int cloudId, List<String> usersNames) {
        return this.userDao.getAllUsersForNames(cloudId, usersNames);
    }

    @Override
    public Group getGroupByName(int cloudId, String groupName) {
        return this.userGroupDao.getGroupByName(cloudId, groupName);
    }

    @Override
    public List<UserGroup> getAllUsersForGroup(int cloudId, String groupName, String groupId) {
        return this.userGroupDao.getAllUsersForGroup(cloudId, null, groupId);
    }

    @Override
    public void saveGroup(int cloudId, List<String> list, String groupName) {
        Group group = this.getGroupByName(cloudId, groupName);
        if (group == null) {
            group = new Group();
            group.setGroupName(groupName);
            this.userGroupDao.saveGroup(cloudId, group, list);
        }
    }

    @Override
    public List<Group> getAllGroups(int cloudId) {
        return this.userGroupDao.getAllGroups(cloudId);
    }

    @Override
    public UserGroupElement getGroupElement(int cloudId, String groupName) {
        UserGroupElement groupElement = new UserGroupElement();
        Group group = this.userGroupDao.getGroupByName(cloudId, groupName);
        StringBuilder userNames = new StringBuilder("");
        if (group != null) {
            groupElement.setGroupName(group.getGroupName());
            List<UserGroup> allUserGroups = this.getAllUsersForGroup(cloudId, null, group.getId().toString());
            for (UserGroup userGroup : allUserGroups) {
                userNames.append(userGroup.getUser().getUserName() + ",");
            }
            if (userNames.length() > 0) {
                userNames.append(userNames.substring(0, userNames.length() - 1));
                groupElement.setAssignedUsers(userNames.toString());
            }
        }
        return groupElement;
    }

    @Override
    public void deleteGroup(int cloudId, Group group) {
        this.userGroupDao.deleteGroup(cloudId, group);
    }

    @Override
    public List<Group> getAllGroups(int cloudId, int skipValue) {
        return this.userGroupDao.getAllGroups(cloudId, skipValue);
    }

    @Override
    public List<Group> searchGroups(int cloudId, String groupName) {
        return this.userGroupDao.searchGroups(cloudId, groupName);
    }

    @Override
    public Group getUserGroup(int cloudId, User user) {
        logger.debug("Group getUserGroup(int cloudId, User user) > BEGIN");
        Group group = this.userGroupDao.getUserGroup(cloudId, user);
        logger.debug("Group getUserGroup(int cloudId, User user) > BEFORE RETURN");
        return group;
    }

    @Override
    public User getAdminUserWithServerBackupEnabled(int cloudId) {
        logger.debug("User getAdminUserWithServerBackupEnableerd(int cloudId) > BEGIN");
        User user = this.userDao.getAdminUserWithServerBackupEnabled(cloudId);
        logger.debug("User getAdminUserWithServerBackupEnableerd(int cloudId) > BEFORE");
        return user;
    }

    @Override
    public User getUserDetailsForEmail(int cloudId, String email) {
        return this.userDao.getUserDetailsForEmail(cloudId, email);
    }

    @Override
    public SyncOverviewElement getSyncOverview(int cloudId) {
        SyncOverView syncOverview = this.fileRevisionDao.getSyncOverview(cloudId);
        SyncOverviewElement syncOverviewElement = new SyncOverviewElement();
        long noOfUsers = this.userDao.countOfPresentSyncUsers(cloudId, "", true);
        syncOverviewElement.setTotalUsers(Long.toString(noOfUsers));
        if (syncOverview != null) {
            syncOverviewElement.setTotalFilesShared(Long.toString(syncOverview.getTotalFilesShared()));
            syncOverviewElement.setTotalFilesDownloaded(Long.toString(syncOverview.getTotalFilesDownloaded()));
            syncOverviewElement.setTotalSizeUploaded(UserManagementServiceImpl.formatFileSize(syncOverview.getTotalSizeUploaded()));
            syncOverviewElement.setTotalSizeDownloaded(UserManagementServiceImpl.formatFileSize(syncOverview.getTotalSizeDownloaded()));
        }
        return syncOverviewElement;
    }

    @Override
    public void saveSyncOverview(int cloudId, long totalSizeUploaded, long totalSizeDownloaded, long filesShared, long filesDownloaded) {
        SyncOverView syncOverview = this.fileRevisionDao.getSyncOverview(cloudId);
        if (syncOverview == null) {
            syncOverview = new SyncOverView();
            syncOverview.setTotalFilesShared(filesShared);
            syncOverview.setTotalSizeUploaded(totalSizeUploaded);
            syncOverview.setTotalFilesDownloaded(totalSizeDownloaded);
            syncOverview.setTotalSizeUploaded(totalSizeUploaded);
        } else {
            syncOverview.setTotalFilesShared(syncOverview.getTotalFilesShared() + filesShared);
            syncOverview.setTotalSizeUploaded(syncOverview.getTotalSizeUploaded() + totalSizeUploaded);
            syncOverview.setTotalFilesDownloaded(syncOverview.getTotalFilesDownloaded() + totalSizeDownloaded);
            syncOverview.setTotalSizeUploaded(syncOverview.getTotalSizeUploaded() + totalSizeUploaded);
        }
        this.fileRevisionDao.saveSyncOverview(cloudId, syncOverview);
        long currentTimeMillis = UserManagementServiceImpl.getStartofDay(System.currentTimeMillis());
        DailySyncOverView dailySyncOverview = this.fileRevisionDao.getDailySyncOverview(cloudId, currentTimeMillis);
        if (dailySyncOverview == null) {
            dailySyncOverview = new DailySyncOverView();
            dailySyncOverview.setTotalFilesShared(filesShared);
            dailySyncOverview.setTotalFilesDownloaded(totalSizeDownloaded);
            dailySyncOverview.setTotalSizeUploaded(totalSizeUploaded);
            dailySyncOverview.setTotalSizeDownloaded(totalSizeDownloaded);
            dailySyncOverview.setOverViewDate(UserManagementServiceImpl.getStartofDay(currentTimeMillis));
        } else {
            dailySyncOverview.setTotalFilesShared(dailySyncOverview.getTotalFilesShared() + filesShared);
            dailySyncOverview.setTotalFilesDownloaded(dailySyncOverview.getTotalFilesDownloaded() + filesDownloaded);
            dailySyncOverview.setTotalSizeUploaded(dailySyncOverview.getTotalSizeUploaded() + totalSizeUploaded);
            dailySyncOverview.setTotalSizeDownloaded(dailySyncOverview.getTotalSizeDownloaded() + totalSizeDownloaded);
            dailySyncOverview.setOverViewDate(UserManagementServiceImpl.getStartofDay(currentTimeMillis));
        }
        this.fileRevisionDao.saveDailySyncOverview(cloudId, dailySyncOverview);
    }

    private static long getStartofDay(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static String formatFileSize(long size) {
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : dec.format(m).concat(" MB"));
        return hrSize;
    }

    @Override
    public void deleteOldSyncOverView(int cloudId) {
        this.fileRevisionDao.deleteOldSyncOverView(cloudId);
    }

    @Override
    public void updateUserLoggedInTime(int cloudId, String userName) {
        this.userDao.updateUserLoggedInTime(cloudId, userName);
    }

    @Override
    public void syncExistingUsersAttributes(Cloud cloud) {
        block33: {
            int cloudId = cloud.getCloudId();
            List allAdcredentials = this.personDao.getAllAdCredentials(cloudId);
            boolean result = this.checkADCredentialsHaveGroupName(allAdcredentials);
            if (!CollectionUtils.isEmpty((Collection)allAdcredentials) && result) {
                logger.debug("allAdcredentials is empty Ad creadentails have no group name don't sync");
                return;
            }
            boolean backupGroup = false;
            boolean syncGroup = false;
            for (AdCredentials adCredentail : allAdcredentials) {
                if (!StringUtils.isEmpty((String)adCredentail.getAdGroupName()) && "sync".equalsIgnoreCase(adCredentail.getAdProductType())) {
                    syncGroup = true;
                }
                if (StringUtils.isEmpty((String)adCredentail.getAdGroupName()) || !"backup".equalsIgnoreCase(adCredentail.getAdProductType())) continue;
                backupGroup = true;
            }
            logger.debug("...group exists..." + backupGroup + ".." + syncGroup);
            List ldapUsers = this.userDao.getAllLdapUser(cloud.getCloudId());
            String cloudName = cloud.getCloudName();
            boolean isSoftBlockEnabled = false;
            CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
            if (cloudProperties != null && cloudProperties.isSoftBlockEnabled()) {
                isSoftBlockEnabled = true;
            }
            try {
                boolean isBackupEnabled = false;
                boolean isSyncEnabled = false;
                for (CloudCustomisableDetails customisableDetails : cloud.getCloudCustomisableDetails()) {
                    if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                        isSyncEnabled = true;
                    }
                    if (!customisableDetails.getName().equalsIgnoreCase(BACKUP_ENABLED)) continue;
                    isBackupEnabled = true;
                }
                boolean isOrgBackupEnabled = isBackupEnabled;
                boolean isOrgSyncEnabled = isSyncEnabled;
                for (User userObj : ldapUsers) {
                    boolean active;
                    boolean softBlockEnabled;
                    isBackupEnabled = isOrgBackupEnabled;
                    isSyncEnabled = isOrgSyncEnabled;
                    String userName = userObj.getUserName();
                    Person userInAD = null;
                    userInAD = StringUtils.isNotEmpty((String)userObj.getAadLoginId()) ? this.ldapService.getPersonByUserNameForSync(userObj.getAadLoginId()) : this.ldapService.getPersonByUserNameForSync(userName);
                    User existingUser = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
                    if (userInAD != null) {
                        if (isBackupEnabled && "sync".equalsIgnoreCase(userInAD.getAdGroupType())) {
                            isBackupEnabled = false;
                        }
                        if (isSyncEnabled && "backup".equalsIgnoreCase(userInAD.getAdGroupType())) {
                            isSyncEnabled = false;
                        }
                        logger.debug(userName + "...." + userInAD.getAdGroupType() + "...group and licens..." + isBackupEnabled + ".." + isSyncEnabled);
                        boolean isUserLimitReached = this.isUserLimitReached(cloud, cloudId, cloudName);
                        logger.debug("....license check ..... " + isBackupEnabled + "..." + isSyncEnabled + "...." + isUserLimitReached);
                        if ((long)cloud.getNoOfBackupUsersAllowed() <= this.countOfPresentBackupUsers(cloudId, cloudName, true)) {
                            isBackupEnabled = false;
                        }
                        if ((long)cloud.getNoOfSyncUsersAllowed() <= this.countOfPresentSyncUsers(cloudId, cloudName, true)) {
                            isSyncEnabled = false;
                        }
                        if (!(isBackupEnabled || isSyncEnabled || existingUser.isSoftBlockEnabled())) {
                            logger.error("...user limit reached.....");
                            continue;
                        }
                        if (isUserLimitReached && existingUser.isActive() && !existingUser.isBackupEnabled()) {
                            logger.debug("...user limit reached and user is active but license disabled so do not update for user contiue... " + userName);
                            continue;
                        }
                        if (isUserLimitReached && !existingUser.isActive()) {
                            logger.debug("...user limit reached and so do not update for user contiue... " + userName);
                            continue;
                        }
                        boolean accountStatus = userInAD.isAccountStatus();
                        logger.debug(userName + "...UserName : " + userInAD.getFullName() + " acount status " + accountStatus);
                        String department = userInAD.getDepartment();
                        String displayName = userInAD.getDisplayName();
                        String location = userInAD.getLocation();
                        this.updateAdInfoForUser(cloudId, userName, accountStatus, department, displayName, location);
                        if (!accountStatus) {
                            logger.debug("...UserName : " + userInAD.getFullName() + " acount status " + accountStatus + " setting false");
                            if (existingUser.isActive()) {
                                logger.debug("In AD user is not active but user is active so change the status");
                                if (isSoftBlockEnabled) {
                                    this.updateUserInfo(cloudId, isBackupEnabled, isSyncEnabled, userName, true, true);
                                } else {
                                    this.updateUserInfo(cloudId, isBackupEnabled, isSyncEnabled, userName, false, false);
                                }
                                if (!isSoftBlockEnabled) {
                                    this.saveAuditHistory(cloud, cloudId, userName);
                                }
                            }
                        } else if (!existingUser.isActive()) {
                            logger.debug("In AD user is active but user is not active in db so change the status");
                            this.updateUserInfo(cloudId, isBackupEnabled, isSyncEnabled, userName, false, true);
                            this.saveStatisticToDatabase(cloud, "unblocked", "AUTO", userName, "AD Sync", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
                        }
                        this.updateUserInfoLicense(cloudId, userName, isBackupEnabled, isSyncEnabled);
                        if (!isBackupEnabled && !isSyncEnabled && existingUser.isActive()) {
                            if (isSoftBlockEnabled) {
                                this.updateUserInfo(cloudId, isBackupEnabled, isSyncEnabled, userName, true, true);
                            } else {
                                this.updateUserInfo(cloudId, isBackupEnabled, isSyncEnabled, userName, false, false);
                            }
                            if (!isSoftBlockEnabled) {
                                this.saveAuditHistory(cloud, cloudId, userName);
                            }
                        }
                        if (!existingUser.isActive() || isBackupEnabled || isSyncEnabled || !existingUser.isSoftBlockEnabled()) continue;
                        existingUser = this.userDao.getUserByUserNameOrEmail(cloudId, userName);
                        this.updateUserInfo(cloudId, isBackupEnabled, isSyncEnabled, userName, false, true);
                        logger.debug("update ... softblock...");
                        continue;
                    }
                    logger.debug(userName + "...User not found in ad and no exception also so bloc the user.." + isSoftBlockEnabled);
                    if (existingUser.isActive()) {
                        softBlockEnabled = false;
                        active = true;
                        if (isSoftBlockEnabled) {
                            softBlockEnabled = true;
                        } else {
                            active = false;
                            isBackupEnabled = false;
                            isSyncEnabled = false;
                            logger.debug(userName + "...disable license...." + isBackupEnabled + "..." + isSyncEnabled);
                        }
                        this.updateUserInfo(cloud.getCloudId(), isBackupEnabled, isSyncEnabled, userName, softBlockEnabled, active);
                        if (isSoftBlockEnabled) continue;
                        this.saveAuditHistory(cloud, cloudId, userName);
                        continue;
                    }
                    logger.debug(userName + "......user inactive....");
                    softBlockEnabled = false;
                    active = true;
                    if (isSoftBlockEnabled) {
                        softBlockEnabled = true;
                        active = false;
                    } else {
                        active = false;
                        isBackupEnabled = false;
                        isSyncEnabled = false;
                        logger.debug("...disable license...." + isBackupEnabled + "..." + isSyncEnabled);
                    }
                    this.updateUserInfo(cloud.getCloudId(), isBackupEnabled, isSyncEnabled, userName, softBlockEnabled, active);
                }
            }
            catch (BaseException e) {
                logger.trace(BASE_EXCEPTION + (Object)((Object)e));
                logger.error(BASE_EXCEPTION + e.getMessage());
                if (e == null || e.getErrorStatus() != 400) break block33;
                logger.debug("Ad connection so stop sync failed reason :" + e.getMessage());
                throw e;
            }
        }
    }

    private void updateUserInfoLicense(int cloudId, String userName, boolean isBackupEnabled, boolean isSyncEnabled) {
        this.userDao.updateUserInfoLicense(cloudId, userName, isBackupEnabled, isSyncEnabled);
    }

    private void updateUserInfo(int cloudId, boolean isBackup, boolean isSync, String userName, boolean softBlockEnabled, boolean active) {
        this.userDao.updateUserInfo(cloudId, isBackup, isSync, userName, softBlockEnabled, active);
    }

    private void updateAdInfoForUser(int cloudId, String userName, boolean accountStatus, String department, String displayName, String location) {
        this.userDao.updateAdInfoForUser(cloudId, userName, accountStatus, department, displayName, location);
    }

    private boolean isUserLimitReached(Cloud cloud, int cloudId, String cloudName) {
        boolean backupLimitReached = false;
        boolean syncLimitReached = false;
        boolean isUserLimitReached = false;
        long countOfPresentBackupUsers = this.countOfPresentBackupUsers(cloudId, cloudName, true);
        if ((long)cloud.getNoOfBackupUsersAllowed() <= countOfPresentBackupUsers) {
            backupLimitReached = true;
        }
        long countOfPresentSyncUsers = this.countOfPresentSyncUsers(cloudId, cloudName, true);
        if ((long)cloud.getNoOfSyncUsersAllowed() <= countOfPresentSyncUsers) {
            syncLimitReached = true;
        }
        if (backupLimitReached && syncLimitReached) {
            isUserLimitReached = true;
        }
        logger.debug(".....license numbers....." + countOfPresentBackupUsers + "...." + countOfPresentSyncUsers + "...." + isUserLimitReached);
        return isUserLimitReached;
    }

    private boolean checkADCredentialsHaveGroupName(List<AdCredentials> adCredentials) {
        boolean results = false;
        for (AdCredentials adCredentail : adCredentials) {
            if (!StringUtils.isEmpty((String)adCredentail.getAdGroupName())) continue;
            logger.debug("In adcredntials " + adCredentail.getAdUrl() + " group name is empty so checkADCredentialsHaveGroupName return true");
            results = true;
            break;
        }
        return results;
    }

    private void saveAuditHistory(Cloud cloud, int cloudId, String userName) {
        this.saveStatisticToDatabase(cloud, "Blocked", "AUTO", userName, "AD Sync", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
        List<Device> blockedDevices = this.blockUnblockDevicebyUserName(cloudId, cloud.getCloudName(), userName, true);
        if (blockedDevices != null) {
            for (Device device : blockedDevices) {
                logger.debug("....blocking devices....");
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloud.getCloudName(), "blocked Device:" + device.getDeviceName() + " of User:", "AUTO", userName, "AD Sync", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
            }
        }
    }

    private void blockDeviceByUserAndAudit(Cloud cloud, Device device, User user, DateTime dt1) {
        logger.debug("...blockDeviceByUserAndAudit.........");
        this.deviceDao.blockUnblockDevice(cloud.getCloudId(), cloud.getCloudName(), device, true);
        this.deviceDao.updateDeviceStatusInOverview(cloud.getCloudId(), device.getDeviceUUID(), true);
        this.authorizationDao.deleteAuthTokenByUserAndUniqueID(cloud.getCloudId(), user, device.getDeviceUUID());
        this.auditHistoryService.saveStatisticToDatabase(cloud.getCloudId(), cloud.getCloudName(), "blocked Device:" + device.getDeviceName() + " owned by User:", "AUTO", user.getUserName(), "which was Last heard from on: " + dt1, System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
    }

    private void changeUserStatusByADStatus(Cloud cloud, int cloudId, User user, Person userInAD) {
        if (!userInAD.isAccountStatus()) {
            if (user.isActive()) {
                user.setActive(false);
                logger.debug("In AD user is not active but user is active in DB so change the status" + user.isActive());
                this.updateStatusInDevice(cloud, cloudId, user);
            }
        } else if (!user.isActive()) {
            logger.debug("In AD user is active but user is in active so change the status");
            user.setActive(true);
            this.saveStatisticToDatabase(cloud, "unblocked", "AUTO", user.getUserName(), "AD Sync", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
        }
    }

    private void updateStatusInDevice(Cloud cloud, int cloudId, User user) {
        this.saveStatisticToDatabase(cloud, "Blocked", "AUTO", user.getUserName(), "AD Sync", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
        List<Device> blockedDevices = this.blockUnblockDevicebyUserName(cloudId, cloud.getCloudName(), user.getUserName(), true);
        if (blockedDevices != null) {
            for (Device device : blockedDevices) {
                logger.debug("....blocking devices....");
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloud.getCloudName(), "blocked Device:" + device.getDeviceName() + " of User:", "AUTO", user.getUserName(), "AD Sync", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
            }
        }
    }

    private void saveStatisticToDatabase(Cloud cloud, String action, String actionByUser, String actionOnUser, String actionUsingObject, long timeStamp, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(timeStamp);
        audit.setActionUsingObject(actionUsingObject);
        audit.setActionType(actionType);
        this.auditHistoryDao.saveAudit(cloud.getCloudId(), cloud.getCloudName(), audit);
    }

    @Override
    public List<SearchUserElement> searchUsersWithDevices(int cloudId, String userName, User currentUser) {
        ArrayList<SearchUserElement> userElementList = new ArrayList<SearchUserElement>();
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(userName.split(",")));
        HashSet<String> removeSet = new HashSet<String>();
        removeSet.addAll(list);
        list.clear();
        list.addAll(removeSet);
        List users = null;
        users = this.userDao.searchUsers(cloudId, list);
        this.getValidUsersByUserList(currentUser, users);
        for (User user : users) {
            if (user == null) continue;
            List devicesList = this.deviceDao.getAllDeviceByUserName(cloudId, user.getUserName());
            ArrayList<String> deviceNameList = new ArrayList<String>();
            if (devicesList != null) {
                for (Device device : devicesList) {
                    deviceNameList.add(device.getDeviceName());
                }
            }
            SearchUserElement ue = new SearchUserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            ue.setDeviceNameList(deviceNameList);
            if (user.isGuest()) continue;
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public List<UserElement> getUserListByNames(Cloud cloud, List<String> userNames, String currentUserName, HttpServletResponse response, CloudLicenseTo cl, String oppType) throws Exception {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        int cloudId = cloud.getCloudId();
        ArrayList<UserElement> userListWithBlockFail = new ArrayList<UserElement>();
        for (String userName : userNames) {
            if (StringUtils.isEmpty((String)userName)) continue;
            User user2 = this.userDao.getUserByName(cloudId, userName);
            UserElement ue = new UserElement();
            if (userName.equalsIgnoreCase(currentUserName)) {
                ue.setUserName(userName);
                ue.setStatus("CurrentUser");
            } else if (user2 != null) {
                ue.setUserName(user2.getUserName());
                ue.setEmailId(user2.getEmailId());
                ue.setActive(user2.isActive());
                ue.setDeleted(user2.isDeleted());
                ue.setLocalUser(user2.getlocalUser());
                ue.setLastModifiedTimestamp(user2.getLastModifiedTimestamp());
                if (ue.isActive()) {
                    ue.setStatus(PCHelperConstant.USER_STATUS.ACTIVE.toString());
                } else if (!ue.isActive() && !ue.isDeleted()) {
                    ue.setStatus(PCHelperConstant.USER_STATUS.BLOCKED.toString());
                } else {
                    ue.setStatus(PCHelperConstant.USER_STATUS.DELETED.toString());
                }
            } else {
                ue.setUserName(userName);
                ue.setStatus("User does not exist or invalid");
                userListWithBlockFail.add(ue);
            }
            userElementList.add(ue);
        }
        userElementList.removeAll(Collections.singleton(null));
        Collections.sort(userElementList, new Comparator<UserElement>(){

            @Override
            public int compare(UserElement u1, UserElement u2) {
                if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                    return -1;
                }
                return new CompareToBuilder().append((Object)u1.getStatus(), (Object)u2.getStatus()).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
            }
        });
        if (StringUtils.isNotEmpty((String)oppType) && oppType.equals("block")) {
            userListWithBlockFail.addAll(userElementList.stream().filter(user -> Objects.nonNull(user.getUserName()) && Objects.nonNull(user.getStatus()) && user.getStatus().equals(PCHelperConstant.USER_STATUS.ACTIVE.toString())).collect(Collectors.toList()));
        } else {
            userListWithBlockFail.addAll(userElementList.stream().filter(user -> Objects.nonNull(user.getUserName()) && Objects.nonNull(user.getStatus()) && !user.getStatus().equals(PCHelperConstant.USER_STATUS.BLOCKED.toString())).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(userListWithBlockFail)) {
            logger.debug("...userListWithBlockFail is exists..." + userListWithBlockFail.size());
            this.createUsersExcelBlockFail(cloudId, userListWithBlockFail);
        }
        return userElementList;
    }

    @Override
    public boolean createUserWithoutExcel(CloudLicenseTo cl, int cloudId, int skipValue, List<String> policyNames, boolean incloudBlockedDevices, String productType) {
        List<Object> userList = new ArrayList();
        userList = this.getAllUsersWithoutdevice(cloudId, skipValue, policyNames, incloudBlockedDevices, productType);
        if (CollectionUtils.isEmpty(userList)) {
            logger.debug("Invalid users.....");
            return false;
        }
        this.createUsersExcelForXlsx(cl, cloudId, userList);
        return true;
    }

    @Override
    public User getOneADUser(int cloudId, String cloudName) {
        return this.userDao.getOneADUser(cloudId, cloudName);
    }

    @Override
    public void saveMigrationStatus(int cloudId, MigrationStatus migrationStatus) {
        this.migrationStatusDao.saveMigrationStatus(cloudId, migrationStatus);
    }

    public MigrationStatusDao getMigrationStatusDao() {
        return this.migrationStatusDao;
    }

    public void setMigrationStatusDao(MigrationStatusDao migrationStatusDao) {
        this.migrationStatusDao = migrationStatusDao;
    }

    @Override
    public List<String> getUserNamesByBackupPoliciesAdmin(int cloudId, List<String> backupPoliciesAdmin) {
        return this.userDao.getUserNamesByBackupPoliciesAdmin(cloudId, backupPoliciesAdmin);
    }

    @Override
    public List<String> getUserNamesByOfficePoliciesAdmin(int cloudId, List<String> officePoliciesAdmin) {
        return this.userDao.getUserNamesByOfficePoliciesAdmin(cloudId, officePoliciesAdmin);
    }

    @Override
    public boolean createExcelForUsers(CloudLicenseTo cl, int cloudId, String userName, User user) {
        ArrayList<UserElement> userList = new ArrayList();
        if (StringUtils.isEmpty((String)userName)) {
            userList = this.getAllUsers(cloudId, cl.getCloud().getCloudName());
        } else {
            userList = this.searchUserbyUsernameOrDisplaynameOrEmailId(cloudId, userName);
            logger.debug(userName);
        }
        if (CollectionUtils.isEmpty(userList)) {
            logger.debug("Invalid users.....");
            return false;
        }
        this.getValidUsers(user, userList);
        this.createUsersExcelForXlsx(cl, cloudId, userList);
        return true;
    }

    private void getValidUsers(User user, List<UserElement> userList) {
        if (user != null && user.isReadOnlyAdmin()) {
            ArrayList<UserElement> inValidUsers = new ArrayList<UserElement>();
            for (UserElement userElement : userList) {
                boolean isValidUser = false;
                if (!CollectionUtils.isEmpty((Collection)user.getBackupPoliciesAdmin()) && !StringUtils.isEmpty((String)userElement.getPolicyName()) && user.getBackupPoliciesAdmin().contains(userElement.getPolicyName())) {
                    isValidUser = true;
                    logger.debug("...userName..." + userElement.getUserName() + "...backuppolicy have access to readonly admin..");
                }
                if (!CollectionUtils.isEmpty((Collection)user.getSyncPoliciesAdmin()) && !StringUtils.isEmpty((String)userElement.getSyncPolicyName()) && user.getSyncPoliciesAdmin().contains(userElement.getSyncPolicyName())) {
                    isValidUser = true;
                    logger.debug("...userName..." + userElement.getUserName() + "...SyncPolicy have access to readonly admin..");
                }
                if (!CollectionUtils.isEmpty((Collection)user.getOdbPoliciesAdmin()) && !StringUtils.isEmpty((String)userElement.getOdbPolicyName()) && user.getOdbPoliciesAdmin().contains(userElement.getOdbPolicyName())) {
                    isValidUser = true;
                    logger.debug("...userName..." + userElement.getUserName() + "...OdbPolicy have access to readonly admin..");
                }
                if (isValidUser) continue;
                inValidUsers.add(userElement);
            }
            logger.debug(".......Users list count..." + userList.size() + "...inValidUsers.." + inValidUsers.size());
            userList.removeAll(inValidUsers);
            logger.debug(".......Users list count after..." + userList.size());
        }
    }

    private void getValidUsersByUserList(User user, List<User> userList) {
        if (user != null && user.isReadOnlyAdmin()) {
            ArrayList<User> inValidUsers = new ArrayList<User>();
            for (User userElement : userList) {
                boolean isValidUser = false;
                if (!CollectionUtils.isEmpty((Collection)user.getBackupPoliciesAdmin()) && !StringUtils.isEmpty((String)userElement.getPolicyName()) && user.getBackupPoliciesAdmin().contains(userElement.getPolicyName())) {
                    isValidUser = true;
                    logger.debug("...userName..." + userElement.getUserName() + "...backuppolicy have access to readonly admin..");
                }
                if (!CollectionUtils.isEmpty((Collection)user.getSyncPoliciesAdmin()) && !StringUtils.isEmpty((String)userElement.getSyncPolicyName()) && user.getSyncPoliciesAdmin().contains(userElement.getSyncPolicyName())) {
                    isValidUser = true;
                    logger.debug("...userName..." + userElement.getUserName() + "...SyncPolicy have access to readonly admin..");
                }
                if (!CollectionUtils.isEmpty((Collection)user.getOdbPoliciesAdmin()) && !StringUtils.isEmpty((String)userElement.getOdbPolicyName()) && user.getOdbPoliciesAdmin().contains(userElement.getOdbPolicyName())) {
                    isValidUser = true;
                    logger.debug("...userName..." + userElement.getUserName() + "...OdbPolicy have access to readonly admin..");
                }
                if (isValidUser) continue;
                inValidUsers.add(userElement);
            }
            logger.debug(".......Users list count..." + userList.size() + "...inValidUsers.." + inValidUsers.size());
            userList.removeAll(inValidUsers);
            logger.debug(".......Users list count after..." + userList.size());
        }
    }

    private boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"ODB Enabled".equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }

    private boolean isBackupEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isBackupEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !BACKUP_ENABLED.equalsIgnoreCase(license.getName())) continue;
            isBackupEnabled = true;
            break;
        }
        return isBackupEnabled;
    }

    private boolean isO365Enabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isO365Enabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"OneDrive Backup Enabled".equalsIgnoreCase(license.getName())) continue;
            isO365Enabled = true;
            break;
        }
        return isO365Enabled;
    }

    private boolean isSyncEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isSyncEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !SYNC_ENABLED.equalsIgnoreCase(license.getName())) continue;
            isSyncEnabled = true;
            break;
        }
        return isSyncEnabled;
    }

    private void createUsersExcelForXlsx(CloudLicenseTo cl, int cloudId, List<UserElement> userList) {
        if (!userList.isEmpty()) {
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                List<List> recordToAdd = this.updateUserElementValuesToExcel(cl, userList);
                this.createExcelForUserXlsx(recordToAdd, workbook);
                this.writeExcelForUserXlsx(workbook);
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
            }
        }
    }

    private List<List> updateUserElementValuesToExcel(CloudLicenseTo cl, List<UserElement> userList) {
        List list = cl.getCloud().getCloudCustomisableDetails();
        boolean isODBEnabled = this.isODBEnabled(list);
        boolean isBackupEnabled = this.isBackupEnabled(list);
        boolean isSyncEnabled = this.isSyncEnabled(list);
        boolean isOdbBkpEnabled = this.isOneDriveForBusinessBackupEnabled(list);
        boolean isExchangeBackupEnabled = this.isExchangeBackupEnabled(list);
        List<BackupPolicy> backupPolicies = this.getAllBackupPolicies(1);
        List policyWithConsentEnabled = backupPolicies.stream().filter(policy -> policy.isUserConsentEnabled()).map(policyNameM -> policyNameM.getPolicyName()).collect(Collectors.toList());
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(1);
        Boolean isShowUserConsentFieldInPolicies = cloudProperties.isShowUserConsentFieldInPolicies();
        ArrayList<List> recordToAdd = new ArrayList<List>();
        List<String> headerRow = this.createHeaderRowForUserXlsx(isODBEnabled, isBackupEnabled, isSyncEnabled, isOdbBkpEnabled, isExchangeBackupEnabled, isShowUserConsentFieldInPolicies);
        recordToAdd.add(headerRow);
        for (UserElement userElement : userList) {
            String consentGiven = "";
            String consentGivenTime = "";
            if (userElement.getPolicyName() != null && policyWithConsentEnabled.contains(userElement.getPolicyName())) {
                if (StringUtils.isNotEmpty((String)userElement.getConsentGiven()) && userElement.getConsentGiven().equals("yes")) {
                    consentGiven = "Y";
                    if (userElement.getConsentGivenTime() != 0L) {
                        consentGivenTime = UserManagementServiceImpl.getDateInFormat(userElement.getConsentGivenTime());
                    }
                } else {
                    consentGiven = "NA";
                }
            }
            List<String> firstRow = this.loadDataOnRowForUserXlsx(userElement, isODBEnabled, isBackupEnabled, isSyncEnabled, isOdbBkpEnabled, isExchangeBackupEnabled, consentGiven, isShowUserConsentFieldInPolicies, consentGivenTime);
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private boolean isExchangeBackupEnabled(List<CloudCustomisableDetails> list) {
        boolean isExpiredFileDeleteEnabled = false;
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty(list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"Exchange Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    private boolean isOneDriveForBusinessBackupEnabled(List<CloudCustomisableDetails> list) {
        boolean isExpiredFileDeleteEnabled = false;
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty(list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"OneDrive Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    List<String> createHeaderRowForUserXlsx(boolean isODBEnabled, boolean isBackupEnabled, boolean isSyncEnabled, boolean isOdbBkpEnabled, boolean isExchangeBkpEnabled, boolean isShowUserConsentFieldInPolicies) {
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add("User ID");
        headerRow.add("Display Name");
        headerRow.add("Email ID");
        headerRow.add("Department");
        headerRow.add("Location");
        headerRow.add("User Type");
        headerRow.add("User Status");
        headerRow.add("Is Local User");
        headerRow.add("Created Timestamp");
        headerRow.add("Last Logged In Time");
        if (isShowUserConsentFieldInPolicies) {
            headerRow.add("Consent Given");
            headerRow.add("Consent Given Time");
        }
        if (isODBEnabled) {
            headerRow.add("Odb Login Id");
            headerRow.add("Backup Target Assigned");
            headerRow.add("Reason");
        }
        if (isBackupEnabled) {
            headerRow.add("Backup Policy Name");
            headerRow.add("Is Backup Enabled");
            headerRow.add("Backup Policies Admin");
        }
        if (isSyncEnabled) {
            headerRow.add("Sync Policy Name");
            headerRow.add("Is Sync Enabled");
            headerRow.add("Sync Policies Admin");
        }
        if (isOdbBkpEnabled || isExchangeBkpEnabled) {
            headerRow.add("O365 Policy Name");
        }
        if (isOdbBkpEnabled) {
            headerRow.add("Is OneDrive Backup Enabled");
        }
        if (isExchangeBkpEnabled) {
            headerRow.add("Is Exchange Backup Enabled");
        }
        return headerRow;
    }

    List<String> loadDataOnRowForUserXlsx(UserElement userElement, boolean isODBEnabled, boolean isBackupEnabled, boolean isSyncEnabled, boolean isOdbBkpEnabled, boolean isExchangeBackupEnabled, String consentGiven, boolean isShowUserConsentFieldInPolicies, String consentGivenTime) {
        long dateLong;
        ArrayList<String> firstRow = new ArrayList<String>();
        firstRow.add(userElement.getUserName());
        if (!StringUtils.isEmpty((String)userElement.getDisplayName())) {
            firstRow.add(userElement.getDisplayName());
        } else {
            firstRow.add("");
        }
        if (!StringUtils.isEmpty((String)userElement.getEmailId())) {
            firstRow.add(userElement.getEmailId());
        } else {
            firstRow.add("");
        }
        if (!StringUtils.isEmpty((String)userElement.getDepartment())) {
            firstRow.add(userElement.getDepartment());
        } else {
            firstRow.add("");
        }
        try {
            if (!StringUtils.isEmpty((String)userElement.getLocation())) {
                firstRow.add(userElement.getLocation());
            } else {
                firstRow.add("");
            }
        }
        catch (Exception e) {
            logger.error(EXCEPTION + e.getMessage());
            logger.error(EXCEPTION + e);
        }
        if (userElement.isAdmin()) {
            firstRow.add("Admin");
        } else if (userElement.isReadOnlyAdmin()) {
            firstRow.add("Read Only Admin");
        } else if (userElement.isGuest()) {
            firstRow.add("Guest User");
        } else {
            firstRow.add("User");
        }
        if (!userElement.isDeleted()) {
            if (userElement.isActive()) {
                firstRow.add("Active");
            } else {
                firstRow.add("Blocked");
            }
        } else {
            firstRow.add("Deleted");
        }
        if (userElement.isLocalUser()) {
            firstRow.add("Y");
        } else {
            firstRow.add("N");
        }
        try {
            String createdTimeDate = userElement.getCreatedTimestamp();
            if (!StringUtils.isEmpty((String)createdTimeDate)) {
                dateLong = Long.parseLong(createdTimeDate);
                firstRow.add(this.getDate(dateLong));
            } else {
                firstRow.add("");
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        try {
            String lastLoggedInDateInString = userElement.getLastLoggedInTime();
            if (!StringUtils.isEmpty((String)lastLoggedInDateInString)) {
                dateLong = Long.parseLong(lastLoggedInDateInString);
                firstRow.add(this.getDate(dateLong));
            } else {
                firstRow.add("");
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        if (isShowUserConsentFieldInPolicies) {
            firstRow.add(consentGiven);
            firstRow.add(consentGivenTime);
        }
        if (isODBEnabled) {
            firstRow.add(userElement.getOdbLoginId());
            if (userElement.isBackupTargetAssigned()) {
                firstRow.add("Yes");
            } else {
                firstRow.add("No");
            }
            if (!userElement.isBackupTargetAssigned()) {
                firstRow.add(this.getCommentsForErrorCode(userElement.getBackupTargetErrorCode()));
            } else {
                firstRow.add("");
            }
        }
        if (isBackupEnabled) {
            firstRow.add(userElement.getPolicyName());
            if (userElement.isBackupEnabled()) {
                firstRow.add("Y");
            } else {
                firstRow.add("N");
            }
            BackupPoliciesAdminList backupPolicyAdminList = userElement.getBackupPoliciesAdminList();
            if (backupPolicyAdminList != null) {
                List backupPoliciesAdmin = backupPolicyAdminList.getBackupPoliciesAdmin();
                String backupPolicies = backupPoliciesAdmin.stream().collect(Collectors.joining(","));
                firstRow.add(backupPolicies);
            } else {
                firstRow.add("");
            }
        }
        if (isSyncEnabled) {
            firstRow.add(userElement.getSyncPolicyName());
            if (userElement.isSyncEnabled()) {
                firstRow.add("Y");
            } else {
                firstRow.add("N");
            }
            SyncPoliciesAdminList syncPolicyAdminList = userElement.getSyncPoliciesAdminList();
            if (syncPolicyAdminList != null) {
                List syncPoliciesAdmin = syncPolicyAdminList.getSyncPoliciesAdmin();
                String syncPolicies = syncPoliciesAdmin.stream().collect(Collectors.joining(","));
                firstRow.add(syncPolicies);
            } else {
                firstRow.add("");
            }
        }
        if (isOdbBkpEnabled || isExchangeBackupEnabled) {
            firstRow.add(userElement.getOdbPolicyName());
        }
        if (isOdbBkpEnabled) {
            if (userElement.isOnedriveBkpEnabled()) {
                firstRow.add("Y");
            } else {
                firstRow.add("N");
            }
        }
        if (isExchangeBackupEnabled) {
            if (userElement.isExchangeBkpEnabled()) {
                firstRow.add("Y");
            } else {
                firstRow.add("N");
            }
        }
        return firstRow;
    }

    void createExcelForUserXlsx(List<List> l1, XSSFWorkbook workbook) throws Exception {
        XSSFSheet firstSheet = workbook.createSheet("FIRST SHEET");
        int rownum = 0;
        try {
            for (int j = 0; j < l1.size(); ++j) {
                XSSFRow row = firstSheet.createRow(rownum);
                List l2 = l1.get(j);
                for (int k = 0; k < l2.size(); ++k) {
                    Cell cell = row.createCell(k);
                    cell.setCellValue((String)l2.get(k));
                    if (rownum != 0) continue;
                    XSSFCellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor((short)51);
                    cellStyle.setFillPattern((short)1);
                    XSSFFont font = workbook.createFont();
                    font.setFontName("Arial");
                    font.setFontHeightInPoints((short)10);
                    font.setBoldweight((short)10);
                    cellStyle.setFont((Font)font);
                    cell.setCellStyle((CellStyle)cellStyle);
                }
                ++rownum;
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    void writeExcelForUserXlsx(XSSFWorkbook workbook) {
        try (FileOutputStream fos = new FileOutputStream(new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/Users.xlsx"));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    private String getDate(long dateVal) {
        String date = "";
        try {
            SimpleDateFormat df2 = new SimpleDateFormat(MM_DD_YYYY_HH_MM_SS);
            Date dateD = new Date(dateVal);
            date = df2.format(dateD);
        }
        catch (NumberFormatException e) {
            logger.trace(NUMBER_FORMAT_EXCEPTION + e);
            logger.error(NUMBER_FORMAT_EXCEPTION + e.getMessage());
        }
        return date;
    }

    private String generatePassWordhash(String passHash) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] digesta = null;
        try {
            MessageDigest mda = MessageDigest.getInstance("SHA-512", "BC");
            digesta = mda.digest(passHash.getBytes());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            logger.trace("getSHA512hash : " + e);
            logger.trace(e.getMessage());
        }
        return Hex.encodeHexString((byte[])digesta);
    }

    @Override
    public void removeUsersByName(int cloudId, List<String> userNames) {
        this.userDao.deleteUsersByName(cloudId, userNames);
        this.deletedUserDao.removeDeletedUser(cloudId, userNames);
    }

    @Override
    public boolean createUserFromAAD(int cloudId, String cloudName, AADUserElement aadUserElement, String migratedBy, boolean isSyncEnabled, boolean isBackupEnabled, boolean isO365BackupEnabled, Cloud cloud) throws Exception {
        boolean userMigrated = false;
        try {
            User userFromDB = this.userDao.getUserByUserNameOrEmail(cloudId, aadUserElement.getUserPrincipalName());
            if (userFromDB == null && aadUserElement.getMail() != null) {
                userFromDB = this.userDao.getUserByUserNameOrEmail(cloudId, aadUserElement.getMail());
            }
            if (userFromDB != null && userFromDB.isGuest()) {
                this.userDao.removeUserbyID(cloudId, userFromDB.getUserId().toString());
            }
            User existingUser = this.userDao.getUserByUserNameOrEmail(cloudId, aadUserElement.getUserName());
            if ((long)cloud.getNoOfBackupUsersAllowed() <= this.countOfPresentBackupUsers(cloudId, cloudName, true)) {
                isBackupEnabled = false;
            }
            if ((long)cloud.getNoOfSyncUsersAllowed() <= this.countOfPresentSyncUsers(cloudId, cloudName, true)) {
                isSyncEnabled = false;
            }
            boolean odbBkpEnabled = false;
            boolean exchangeBkpEnabled = false;
            if (isO365BackupEnabled) {
                odbBkpEnabled = true;
                exchangeBkpEnabled = true;
            }
            if ((long)cloud.getNoOfOneDriveUsersAllowed() <= this.userDao.countOfPresentOnedriveUsers(cloudId, true)) {
                odbBkpEnabled = false;
            }
            if ((long)cloud.getNoOfExchangeUsersAllowed() <= this.userDao.countOfPresentExchangeUsers(cloudId, true)) {
                exchangeBkpEnabled = false;
            }
            if (!(isBackupEnabled || isSyncEnabled || odbBkpEnabled || exchangeBkpEnabled)) {
                throw new UserLimitReachedException("user limit reached");
            }
            PortalProperties portalProperties = this.portalPropertiesDao.getPortalProperties(cloudId, PCHelperConstant.getPropertyValueComponentName());
            User user = new User();
            UUID uuid = UUID.randomUUID();
            String recoveryKey = String.valueOf(uuid);
            user.setSecurityRecoveryKey(recoveryKey);
            user.setActive(true);
            user.setAdmin(false);
            user.setBackupEnabled(isBackupEnabled);
            user.setSyncEnabled(isSyncEnabled);
            user.setOnedriveBkpEnabled(odbBkpEnabled);
            user.setExchangeBkpEnabled(exchangeBkpEnabled);
            user.setFirstLogin(true);
            user.setShareEnabled(true);
            user.setUserName(aadUserElement.getUserPrincipalName());
            if (StringUtils.isEmpty((String)aadUserElement.getMail())) {
                user.setEmailId(aadUserElement.getUserPrincipalName());
            } else {
                user.setEmailId(aadUserElement.getMail());
            }
            user.setCreatedTimestamp(String.valueOf(System.currentTimeMillis()));
            user.setDisplayName(aadUserElement.getDisplayName());
            user.setMigratedBy(migratedBy);
            user.setlocalUser(false);
            user.setLocation(aadUserElement.getOfficeLocation());
            user.setDepartment(aadUserElement.getDepartment());
            user.setAccountStatus(true);
            user.setUserNameLowerCase(aadUserElement.getUserPrincipalName().toLowerCase());
            user.setAadLoginId(aadUserElement.getUserPrincipalName());
            if (!StringUtils.isEmpty((String)aadUserElement.getDefaultPolicy())) {
                user.setPolicyName(aadUserElement.getDefaultPolicy());
            }
            if (!StringUtils.isEmpty((String)aadUserElement.getDefaultSyncPolicy())) {
                user.setSyncPolicyName(aadUserElement.getDefaultSyncPolicy());
            }
            if (!StringUtils.isEmpty((String)aadUserElement.getDefaultOdbPolicy())) {
                user.setOdbPolicyName(aadUserElement.getDefaultOdbPolicy());
            }
            String googleSecretKey = this.getGoogleSecurityKey();
            logger.debug("googleSecretKey for AAD ....." + googleSecretKey);
            user.setGoogleSecretKey(googleSecretKey);
            UserElement userElement = new UserElement();
            if (portalProperties.getComponentsProperties().get("BLUDRIVE_MODE").toString().equals("false")) {
                user.setSyncAccessType("WEBANDENDPOINT");
                logger.debug("....BLUDRIVE_MODE is false so set ..WEBANDENDPOINT");
            } else {
                user.setSyncAccessType("WEBONLY");
                logger.debug("....BLUDRIVE_MODE is true so set ..WEBONLY");
            }
            BeanUtils.copyProperties((Object)user, (Object)userElement);
            UserElement createduserElement = this.createUser(cloudId, cloudName, userElement, true, this.userDao);
            if (createduserElement != null) {
                userMigrated = true;
                MigrationStatus migrationStatus = new MigrationStatus();
                migrationStatus.setMigratedBy(migratedBy);
                migrationStatus.setMigratededTimestamp(System.currentTimeMillis());
                migrationStatus.setMigrated(true);
                migrationStatus.setUserName(user.getUserName());
                migrationStatus.setEmailId(user.getEmailId());
                this.migrationStatusDao.saveMigrationStatus(cloudId, migrationStatus);
            }
        }
        catch (UserLimitReachedException e) {
            throw new UserLimitReachedException("user limit reached");
        }
        catch (Exception e) {
            logger.error(EXCEPTION + e);
            logger.debug(EXCEPTION + e.getMessage());
            throw new Exception(e);
        }
        return userMigrated;
    }

    private String getGoogleSecurityKey() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        Base32 base32 = new Base32();
        String googleSecretKey = base32.encodeToString(bytes);
        return googleSecretKey;
    }

    @Override
    public SyncPolicyElement getSyncPolicyElement(int cloudId, String cloudName, String syncPolicyName) {
        SyncPolicyElement syncPolicyElement = this.getSyncPolicyElement(cloudId, this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, syncPolicyName));
        return syncPolicyElement;
    }

    @Override
    public List<User> getUsersWithoutDevices(int cloudId) {
        List users = this.userDao.getAllOneDriveBkpEnabledUsers(cloudId);
        if (CollectionUtils.isEmpty((Collection)users)) {
            logger.debug("...no users found for odbBkp........");
            return new ArrayList<User>();
        }
        ArrayList<User> usersWithoutDrive = new ArrayList<User>();
        for (User user : users) {
            Device device = this.deviceDao.getOneDriveDeviceforUser(cloudId, user.getUserName());
            if (device != null) continue;
            usersWithoutDrive.add(user);
            if (usersWithoutDrive.size() < 100) continue;
            return usersWithoutDrive;
        }
        return usersWithoutDrive;
    }

    @Override
    public boolean createTextForBlackListAndMappedUser(int cloudId, String cloudName, boolean isAllUser, boolean secAdmin, boolean newOdbUser, boolean failedMailBox) {
        try {
            Object userList;
            AbstractCollection blackListUsersNames;
            List blackListUsers;
            logger.debug("...isAllUser..." + isAllUser + "....secAdmin..." + secAdmin);
            logger.debug("...newOdbUser..." + newOdbUser + "....failedMailBox..." + failedMailBox);
            List allUsersList = this.userDao.getAllUsers(cloudId, cloudName);
            HashSet<String> userSet = new HashSet<String>();
            for (User user : allUsersList) {
                List deviceBackupOverViews = this.deviceDao.getDeviceBkpOverviewForUserName(cloudId, user.getUserName());
                if (!user.isActive() || CollectionUtils.isEmpty((Collection)deviceBackupOverViews)) continue;
                Iterator iterator = deviceBackupOverViews.iterator();
                while (iterator.hasNext()) {
                    DeviceBackupOverView overView = (DeviceBackupOverView)iterator.next();
                    if (!overView.getOsType().equalsIgnoreCase("OUTLOOK") && !overView.getOsType().equalsIgnoreCase("ONEDRIVE")) continue;
                    boolean userEligible = false;
                    if (overView.getStorageUtilized() <= 0L) {
                        this.deviceDao.updatedeviceToken(cloudId, overView.getDeviceUUID());
                        logger.debug(".....0mb device user..." + overView.getUserName() + "....device...." + overView.getDeviceName());
                        userEligible = true;
                    } else {
                        BackupBatch backupBatch = this.backupBatchDao.getLastSuccessfullBackup(cloudId, overView.getDeviceUUID());
                        if (backupBatch != null && "0".equals(backupBatch.getTotalNoOfFiles())) {
                            userEligible = true;
                            logger.debug(".....last backup was 0 files for user..." + overView.getUserName() + "....device...." + overView.getDeviceName());
                        }
                    }
                    if (!userEligible) continue;
                    logger.debug("....useradded...." + user.getEmailId());
                    userSet.add(user.getEmailId());
                }
            }
            if (failedMailBox) {
                List userList2 = this.userDao.getAllFailedMailBox(cloudId);
                HashSet<String> emaildIds = new HashSet<String>();
                for (User user : userList2) {
                    emaildIds.add(user.getEmailId());
                }
                emaildIds.addAll(userSet);
                return this.createTextFileForOdb(emaildIds, "Failed MailBox");
            }
            if (secAdmin) {
                Object blackListUserData2;
                if (isAllUser) {
                    Iterator users;
                    HashSet<String> mappedUserList = new HashSet<String>();
                    ArrayList usersList = new ArrayList();
                    int i = 0;
                    while (!CollectionUtils.isEmpty((Collection)((Object)(users = this.userDao.getAllUsers(cloudId, cloudName, i))))) {
                        usersList.addAll(users);
                        ++i;
                    }
                    for (User userData : usersList) {
                        this.getListOfUserName(mappedUserList, userData);
                    }
                    mappedUserList.addAll(userSet);
                    return this.createTextFileForOdb(mappedUserList, "Mapped Users");
                }
                HashSet<String> blackListUserList = new HashSet<String>();
                blackListUsers = this.userDao.getAllO365BlockedListUser(cloudId);
                logger.debug("........" + blackListUsers.size());
                blackListUsersNames = new ArrayList();
                for (Object blackListUserData2 : blackListUsers) {
                    blackListUsersNames.add(blackListUserData2.getUserName());
                }
                userList = this.userDao.getAllUsersForNames(cloudId, blackListUsersNames);
                blackListUserData2 = userList.iterator();
                while (blackListUserData2.hasNext()) {
                    User user = (User)blackListUserData2.next();
                    this.getListOfUserName(blackListUserList, user);
                }
                blackListUserList.addAll(userSet);
                return this.createTextFileForOdb(blackListUserList, "Black List Users");
            }
            boolean muxedEnabled = PCHelperConstant.isMuxedEnabled();
            logger.debug(".muxedEnabled..." + muxedEnabled);
            blackListUsers = this.userDao.getAllBackupTargetNotAssignedUser(cloudId);
            blackListUsersNames = new HashSet();
            for (Object blackListUserData2 : blackListUsers) {
                if (blackListUserData2 == null) continue;
                if (!muxedEnabled) {
                    if (blackListUsersNames.contains(blackListUserData2.getEmailId())) continue;
                    blackListUsersNames.add(blackListUserData2.getEmailId());
                    continue;
                }
                if (StringUtils.isNotEmpty((String)blackListUserData2.getOdbLoginId()) && !blackListUsersNames.contains(blackListUserData2.getOdbLoginId())) {
                    blackListUsersNames.add(blackListUserData2.getOdbLoginId());
                }
                if (blackListUserData2.getBackupTargetErrorCode() != 0) continue;
                blackListUserData2.setBackupTargetErrorCode(204);
                this.userDao.saveUser(cloudId, cloudName, (User)blackListUserData2);
            }
            userList = this.userDao.getAllFailedMailBox(cloudId);
            Iterator iterator = userList.iterator();
            while (iterator.hasNext()) {
                User user = (User)iterator.next();
                if (!user.isNewOdbUser()) continue;
                blackListUsersNames.add(user.getEmailId());
            }
            blackListUsersNames.addAll(userSet);
            return this.createTextFileForOdb((Set<String>)((Object)blackListUsersNames), "size=50000");
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            return false;
        }
    }

    private void getListOfOdbOrEmailIdFromUser(List<String> odbOrEmailIdList, User userData) {
        odbOrEmailIdList.add(userData.getEmailId());
    }

    private void getListOfUserName(Set<String> odbOrEmailIdList, User userData) {
        if (!StringUtils.isEmpty((String)userData.getOdbLoginId())) {
            odbOrEmailIdList.add(userData.getOdbLoginId());
        } else {
            odbOrEmailIdList.add(userData.getEmailId());
        }
    }

    private boolean createTextFileForOdb(Set<String> odbOrEmailIdList, String excelHeader) {
        boolean result = false;
        if (!CollectionUtils.isEmpty(odbOrEmailIdList)) {
            try {
                FileWriter fileWriter = new FileWriter("/var/www/odbInfo/BlackList_And_Active_User.txt");
                fileWriter.write(excelHeader);
                for (String emailId : odbOrEmailIdList) {
                    fileWriter.write("\n" + emailId);
                }
                fileWriter.close();
                result = true;
            }
            catch (IOException e1) {
                logger.error(EXCEPTION + e1);
                logger.debug(EXCEPTION + e1.getMessage());
            }
        }
        return result;
    }

    @Override
    public BackupPolicy getBackupPolicy(int cloudId, String policyName) {
        return this.userDao.getBackupPolicyByPolicyName(cloudId, policyName);
    }

    @Override
    public SyncPolicy getSyncPolicyByPolicyName(int cloudId, String policyName) {
        return this.userDao.getSyncPolicyByPolicyName(cloudId, policyName);
    }

    @Override
    public long getSyncPolicyMappedUserCountbyPolicyName(int cloudId, String policyName) {
        return this.userDao.getSyncPolicyMappedUserCountbyPolicyName(cloudId, policyName);
    }

    @Override
    public void mapODBIdsByFilePath(UserListElement userListElement) {
        if (userListElement != null && !CollectionUtils.isEmpty((Collection)userListElement.getUserList())) {
            for (UserElement userElement : userListElement.getUserList()) {
                try {
                    User userByUserNameOrEmail = this.userDao.getUserByUserNameOrEmail(1, userElement.getEmailId());
                    if (userByUserNameOrEmail == null) continue;
                    userByUserNameOrEmail.setOdbLoginId(userElement.getOdbLoginId());
                    logger.debug("Updating " + userElement.getEmailId() + " ODB Id as :" + userElement.getOdbLoginId());
                }
                catch (Exception e) {
                    logger.trace(EXCEPTION + e);
                    logger.error(EXCEPTION + e.getMessage());
                }
            }
        } else {
            logger.debug("userListElement is empty......");
        }
    }

    private boolean isAADEnabled(List<CloudCustomisableDetails> list) {
        boolean isAADEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"AAD Enabled".equals(customisableDetails.getName())) continue;
            isAADEnabled = true;
            break;
        }
        return isAADEnabled;
    }

    @Override
    public UserElement getUserByUserName(Cloud cloud, String userName) {
        ArrayList<MiniCloudElement> cloudElements = new ArrayList<MiniCloudElement>();
        UserElement usrElement = new UserElement();
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        User user = this.userDao.getUserByUserName(cloudId, userName);
        if (user == null && this.isAADEnabled(cloud.getCloudCustomisableDetails())) {
            user = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
        }
        if (user != null) {
            OfficeBackupPolicyElement officeBackupPolicyElement;
            SyncPolicyElement syncPolicyElement;
            BackupPolicyElement backupPolicyElement;
            BaseController.printLogs("USer not null :" + user.getUserName() + " user active:" + user.isActive(), PCHelperConstant.isBrevityLogging());
            List ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, user.getUserId());
            if (!CollectionUtils.isEmpty((Collection)ucacList)) {
                for (UserCloudAccessControl ucac : ucacList) {
                    MiniCloudElement cloudElement = new MiniCloudElement();
                    MiniCloud cloud1 = this.miniCloudDao.getMiniCloudByID(cloudId, cloudName, ucac.getMiniCloudFK());
                    if (cloud1 == null) continue;
                    BeanUtils.copyProperties((Object)cloud1, (Object)cloudElement);
                    cloudElements.add(cloudElement);
                }
            }
            if (StringUtils.isEmpty((String)user.getLastModifiedTimestamp())) {
                usrElement.setLastModifiedTimestamp(user.getCreatedTimestamp());
            }
            MiniCloudElementList miniCloudElementList = new MiniCloudElementList();
            miniCloudElementList.setMiniClouds(cloudElements);
            usrElement.setMiniCloudElementList(miniCloudElementList);
            BeanUtils.copyProperties((Object)user, (Object)usrElement);
            usrElement.setShareEnabled(user.isShareEnabled());
            PciAuthorizationTokens authorizationTokens = this.pciAuthorizationTokensDao.getPciAuthorizationTokensForUserId(cloudId, cloudName, user.getUserId());
            if (!StringUtils.isEmpty((String)usrElement.getPolicyName()) && (backupPolicyElement = this.getBackupPolicyElement(cloudId, this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, user.getPolicyName()))) != null) {
                usrElement.setBackupPolicyElement(this.getBackupPolicyElement(cloudId, this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, user.getPolicyName())));
            }
            if (!StringUtils.isEmpty((String)usrElement.getSyncPolicyName()) && (syncPolicyElement = this.getSyncPolicyElement(cloudId, this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, user.getSyncPolicyName()))) != null) {
                usrElement.setSyncPolicyElement(this.getSyncPolicyElement(cloudId, this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, user.getSyncPolicyName())));
            }
            if (!StringUtils.isEmpty((String)usrElement.getOdbPolicyName()) && (officeBackupPolicyElement = this.getOfficeBackupPolicyElement(cloudId, this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, user.getOdbPolicyName()))) != null) {
                usrElement.setOfficeBackupPolicyElement(officeBackupPolicyElement);
            }
            if (user.isReadOnlyAdmin()) {
                BackupPoliciesAdminList backupPolicyAdminList = new BackupPoliciesAdminList();
                backupPolicyAdminList.setBackupPoliciesAdmin(user.getBackupPoliciesAdmin());
                usrElement.setBackupPoliciesAdminList(backupPolicyAdminList);
                SyncPoliciesAdminList syncPolicyAdminList = new SyncPoliciesAdminList();
                syncPolicyAdminList.setSyncPoliciesAdmin(user.getSyncPoliciesAdmin());
                usrElement.setSyncPoliciesAdminList(syncPolicyAdminList);
                OdbPolicesAdminList odbPolicesAdminList = new OdbPolicesAdminList();
                odbPolicesAdminList.setOdbPoliciesAdminForUser(user.getOdbPoliciesAdmin());
                usrElement.setOdbPoliciesAdminList(odbPolicesAdminList);
            }
            if (authorizationTokens != null) {
                usrElement.setExternalStorageAuthorized(true);
            } else {
                usrElement.setExternalStorageAuthorized(false);
            }
        } else {
            return null;
        }
        return usrElement;
    }

    @Override
    public UserElement getUserByAADLoginId(Cloud cloud, String aadLoginId) {
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        ArrayList<MiniCloudElement> cloudElements = new ArrayList<MiniCloudElement>();
        UserElement usrElement = new UserElement();
        User user = this.userDao.getUserByAADLoginId(cloudId, aadLoginId);
        if (user != null) {
            OfficeBackupPolicyElement officeBackupPolicyElement;
            SyncPolicyElement syncPolicyElement;
            BackupPolicyElement backupPolicyElement;
            BaseController.printLogs("USer not null :" + user.getUserName(), PCHelperConstant.isBrevityLogging());
            List ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, user.getUserId());
            if (!CollectionUtils.isEmpty((Collection)ucacList)) {
                for (UserCloudAccessControl ucac : ucacList) {
                    MiniCloudElement cloudElement = new MiniCloudElement();
                    MiniCloud cloud1 = this.miniCloudDao.getMiniCloudByID(cloudId, cloudName, ucac.getMiniCloudFK());
                    if (cloud == null) continue;
                    BeanUtils.copyProperties((Object)cloud1, (Object)cloudElement);
                    cloudElements.add(cloudElement);
                }
            }
            if (StringUtils.isEmpty((String)user.getLastModifiedTimestamp())) {
                usrElement.setLastModifiedTimestamp(user.getCreatedTimestamp());
            }
            MiniCloudElementList miniCloudElementList = new MiniCloudElementList();
            miniCloudElementList.setMiniClouds(cloudElements);
            usrElement.setMiniCloudElementList(miniCloudElementList);
            BeanUtils.copyProperties((Object)user, (Object)usrElement);
            usrElement.setShareEnabled(user.isShareEnabled());
            PciAuthorizationTokens authorizationTokens = this.pciAuthorizationTokensDao.getPciAuthorizationTokensForUserId(cloudId, cloudName, user.getUserId());
            if (!StringUtils.isEmpty((String)usrElement.getPolicyName()) && (backupPolicyElement = this.getBackupPolicyElement(cloudId, this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, user.getPolicyName()))) != null) {
                usrElement.setBackupPolicyElement(this.getBackupPolicyElement(cloudId, this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, user.getPolicyName())));
            }
            if (!StringUtils.isEmpty((String)usrElement.getSyncPolicyName()) && (syncPolicyElement = this.getSyncPolicyElement(cloudId, this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, user.getSyncPolicyName()))) != null) {
                usrElement.setSyncPolicyElement(this.getSyncPolicyElement(cloudId, this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, user.getSyncPolicyName())));
            }
            if (user.isOnedriveBkpEnabled() && !StringUtils.isEmpty((String)user.getOdbPolicyName()) && (officeBackupPolicyElement = this.getOfficeBackupPolicyElement(cloudId, this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, user.getOdbPolicyName()))) != null) {
                usrElement.setOfficeBackupPolicyElement(officeBackupPolicyElement);
            }
            if (user.isReadOnlyAdmin()) {
                BackupPoliciesAdminList backupPolicyAdminList = new BackupPoliciesAdminList();
                backupPolicyAdminList.setBackupPoliciesAdmin(user.getBackupPoliciesAdmin());
                usrElement.setBackupPoliciesAdminList(backupPolicyAdminList);
                SyncPoliciesAdminList syncPolicyAdminList = new SyncPoliciesAdminList();
                syncPolicyAdminList.setSyncPoliciesAdmin(user.getSyncPoliciesAdmin());
                usrElement.setSyncPoliciesAdminList(syncPolicyAdminList);
                OdbPolicesAdminList odbPolicesAdminList = new OdbPolicesAdminList();
                odbPolicesAdminList.setOdbPoliciesAdminForUser(user.getOdbPoliciesAdmin());
                usrElement.setOdbPoliciesAdminList(odbPolicesAdminList);
            }
            if (authorizationTokens != null) {
                usrElement.setExternalStorageAuthorized(true);
            } else {
                usrElement.setExternalStorageAuthorized(false);
            }
        } else {
            return null;
        }
        return usrElement;
    }

    @Override
    public void autoDeviceBlockBasedOnPolicy(Cloud cloud) {
        int cloudId = cloud.getCloudId();
        List allActiveUsers = this.userDao.getAllActiveUsers(cloudId);
        for (User user : allActiveUsers) {
            try {
                BackupPolicy backupPolicy;
                boolean userUnderLegalHold;
                if (user == null || (userUnderLegalHold = this.isUserUnderLegalHoldForUserName(cloudId, user.getUserName())) || user == null || !user.isBackupEnabled() || StringUtils.isEmpty((String)user.getPolicyName()) || (backupPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName())) == null || backupPolicy.getNoOfDaysToKeepDeviceNotHeard() == 0L || backupPolicy.getNoOfDaysToKeepDeviceNotHeard() == -1L) continue;
                List allOverviews = this.deviceDao.getAllOverviews(cloudId, user.getUserName());
                for (DeviceBackupOverView bkpOverview : allOverviews) {
                    if (bkpOverview == null || bkpOverview.isDeviceBolcked() || bkpOverview.getLastHeardTime() == 0L) continue;
                    SimpleDateFormat format = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
                    Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, "", bkpOverview.getDeviceUUID());
                    long deviceLastModifiedTime = device.getLastModifiedTimestamp();
                    long lastHeardTimeProxy = bkpOverview.getLastHeardTime();
                    if (deviceLastModifiedTime > bkpOverview.getLastHeardTime()) {
                        lastHeardTimeProxy = deviceLastModifiedTime;
                    }
                    Date yourDate = format.parse(UserManagementServiceImpl.getDateInFormat(lastHeardTimeProxy));
                    yourDate.setHours(0);
                    yourDate.setMinutes(0);
                    DateTime dt1 = new DateTime((Object)yourDate);
                    DateTime dt2 = new DateTime();
                    int daysDifference = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    if (daysDifference == 0 || (long)daysDifference <= backupPolicy.getNoOfDaysToKeepDeviceNotHeard()) continue;
                    this.blockDeviceByUserAndAudit(cloud, device, user, dt1);
                }
            }
            catch (Exception e) {
                logger.error("Failed to block" + e.getMessage());
                logger.trace("Failed to block" + e);
            }
        }
    }

    @Override
    public List<User> getUsersForDataMigration(int cloudId) {
        return this.userDao.getUsersForDataMigration(cloudId);
    }

    private static String getDateInFormat(Long deviceCreatedDate) {
        String dateStringFormat = "";
        if (deviceCreatedDate == null || deviceCreatedDate == 0L) {
            return dateStringFormat;
        }
        try {
            SimpleDateFormat df2 = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
            Date dateD = new Date(deviceCreatedDate);
            dateStringFormat = df2.format(dateD);
        }
        catch (Exception e) {
            logger.error("Invalid date value ...." + deviceCreatedDate);
            logger.trace("Invalid date value ...." + e);
            logger.error("Invalid date value ...." + e.getMessage());
        }
        return dateStringFormat;
    }

    @Override
    public List<UserElement> getAllBlockedUsersForDataMigration(int cloudId, int skipValue) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        List usersList = this.userDao.getUsersForDataMigration(cloudId, skipValue);
        ArrayList<String> userNamesWithoutDevices = new ArrayList<String>();
        List<UserElement> userElementWithoutDevicesList = this.getAllUsersWithoutdevice(cloudId, skipValue, new ArrayList<String>(), false, null);
        for (UserElement userElement : userElementWithoutDevicesList) {
            userNamesWithoutDevices.add(userElement.getUserName());
        }
        logger.debug(" user names list ... " + usersList.size());
        for (User user : usersList) {
            logger.debug(" user names ... " + user.getUserName());
            if (userNamesWithoutDevices.contains(user.getUserName())) {
                logger.debug("user does not have any device:" + user.getUserName());
                continue;
            }
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public boolean startMigration(int cloudId, String userName, String destOdbId) {
        return this.userDao.startMigration(cloudId, userName, destOdbId);
    }

    @Override
    public List<User> getUsersWithoutOutlookDevices(int cloudId) {
        List users = this.userDao.getAllExchangeBkpEnabledUsers(cloudId);
        if (CollectionUtils.isEmpty((Collection)users)) {
            logger.debug("...no users found for odbBkp........");
            return new ArrayList<User>();
        }
        ArrayList<User> usersWithoutDrive = new ArrayList<User>();
        for (User user : users) {
            Device device = this.deviceDao.getUsersWithoutOutlookDevices(cloudId, user.getUserName());
            if (device != null) continue;
            usersWithoutDrive.add(user);
            if (usersWithoutDrive.size() < 100) continue;
            return usersWithoutDrive;
        }
        return usersWithoutDrive;
    }

    @Override
    public List<User> getAllOneDriveBkpEnabledUsers(int cloudId) {
        List users = this.userDao.getAllOneDriveBkpEnabledUsers(cloudId);
        if (CollectionUtils.isEmpty((Collection)users)) {
            logger.debug("...no users found for odbBkp........");
            return new ArrayList<User>();
        }
        return users;
    }

    @Override
    public void updateMigrationStatusAndFolderName(int cloudId, String userName, String migratedFolderName) {
        this.userDao.updateMigrationStatusAndFolderName(cloudId, userName, migratedFolderName);
    }

    private OfficeBackupPolicyElement getOfficeBackupPolicyElement(int cloudId, OfficeBackupPolicy backupPolicy) {
        BackupFolderElement backupFolderElement;
        OfficeBackupPolicyElement element = null;
        ArrayList<String> odfolderPaths = new ArrayList<String>();
        ArrayList<String> mailfolderPaths = new ArrayList<String>();
        ArrayList<String> oduserExcludedFolderPaths = new ArrayList<String>();
        ArrayList<String> mailuserExcludedFolderPaths = new ArrayList<String>();
        ArrayList<String> odScheduleNames = new ArrayList<String>();
        ArrayList<String> mailScheduleNames = new ArrayList<String>();
        ArrayList calloutScriptStrs = new ArrayList();
        if (backupPolicy == null) {
            return null;
        }
        for (Schedule schedule : backupPolicy.getOdSchedules()) {
            odScheduleNames.add(schedule.getScheduleName());
        }
        for (Schedule schedule : backupPolicy.getMailSchedules()) {
            mailScheduleNames.add(schedule.getScheduleName());
        }
        for (BackupFolders backupFolder : backupPolicy.getOdBackupFolders()) {
            backupFolderElement = new BackupFolderElement();
            if (backupFolder == null) continue;
            backupFolderElement.setFolderPath(backupFolder.getFolderPath());
            backupFolderElement.setOsType(backupFolder.getOs());
            odfolderPaths.add(backupFolder.getFolderPath());
        }
        for (BackupFolders backupFolder : backupPolicy.getMailBackupFolders()) {
            backupFolderElement = new BackupFolderElement();
            if (backupFolder == null) continue;
            backupFolderElement.setFolderPath(backupFolder.getFolderPath());
            backupFolderElement.setOsType(backupFolder.getOs());
            mailfolderPaths.add(backupFolder.getFolderPath());
        }
        if (backupPolicy != null) {
            List mailsearchFlterNames;
            ArrayList mailsearchFilters;
            ArrayList mailfilters;
            List mailfilterNames;
            List searchFlterNames;
            ArrayList searchFilters;
            ExcludedFolderElement userExcludedFolderElement;
            element = new OfficeBackupPolicyElement();
            BeanUtils.copyProperties((Object)backupPolicy, (Object)element);
            element.setPolicygroupName(backupPolicy.getPolicyName());
            element.setOdBackupFolderPaths(new ArrayList());
            element.getOdBackupFolderPaths().addAll(odfolderPaths);
            element.setMailBackupFolderPaths(new ArrayList());
            element.getMailBackupFolderPaths().addAll(mailfolderPaths);
            if (!org.springframework.util.StringUtils.isEmpty((Object)backupPolicy.getOdExcludedFolders())) {
                for (ExcludedFolders userExcludedFolders : backupPolicy.getOdExcludedFolders()) {
                    userExcludedFolderElement = new ExcludedFolderElement();
                    if (userExcludedFolders == null) continue;
                    userExcludedFolderElement.setFolderPath(userExcludedFolders.getFolderPath());
                    oduserExcludedFolderPaths.add(userExcludedFolders.getFolderPath());
                }
                if (!oduserExcludedFolderPaths.isEmpty()) {
                    element.setExcludedOdFolderpaths(oduserExcludedFolderPaths);
                }
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)backupPolicy.getMailExcludedFolders())) {
                for (ExcludedFolders userExcludedFolders : backupPolicy.getMailExcludedFolders()) {
                    userExcludedFolderElement = new ExcludedFolderElement();
                    if (userExcludedFolders == null) continue;
                    userExcludedFolderElement.setFolderPath(userExcludedFolders.getFolderPath());
                    mailuserExcludedFolderPaths.add(userExcludedFolders.getFolderPath());
                }
                if (!mailuserExcludedFolderPaths.isEmpty()) {
                    element.setExcludedMailFolderpaths(mailuserExcludedFolderPaths);
                }
            }
            element.setCalloutScripts(calloutScriptStrs);
            ArrayList filters = backupPolicy.getOdInclusionFilter();
            List filterNames = filters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterNames)) {
                element.setOdFilterInclusionName(filterNames);
            }
            if (!CollectionUtils.isEmpty((Collection)(searchFilters = backupPolicy.getOdSearchInclusionFilter())) && !CollectionUtils.isEmpty(searchFlterNames = searchFilters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList()))) {
                element.setSearchFilterInclusionName(searchFlterNames);
            }
            if (!CollectionUtils.isEmpty(mailfilterNames = (mailfilters = backupPolicy.getMailInclusionFilter()).stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList()))) {
                element.setMailFilterInclusionName(mailfilterNames);
            }
            if (!CollectionUtils.isEmpty((Collection)(mailsearchFilters = backupPolicy.getMailSearchInclusionFilter())) && !CollectionUtils.isEmpty(mailsearchFlterNames = mailsearchFilters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList()))) {
                element.setSearchFilterInclusionName(mailsearchFlterNames);
            }
            element.setOdScheduleNames(new ArrayList());
            element.getOdScheduleNames().addAll(odScheduleNames);
            element.setMailScheduleNames(new ArrayList());
            element.getMailScheduleNames().addAll(mailScheduleNames);
            element.setEndpointUiPreferences((List)backupPolicy.getEndpointUiPreferences());
            ArrayList list = backupPolicy.getOdPrivacyGateways();
            PrivacyGatewayMappingElement mappingElement = new PrivacyGatewayMappingElement();
            ArrayList<String> pgList = new ArrayList<String>();
            for (PrivacyGateway privacyGateway : list) {
                if (privacyGateway == null) continue;
                mappingElement.setGatewayNwThrottlingName("PGThrottle-name");
                pgList.add(privacyGateway.getGatewayName());
            }
            mappingElement.setPrivacyGatewayNames(new ArrayList());
            mappingElement.setPrivacyGatewayNames(pgList);
            element.setOdPrivacyGatewayMappingElement(mappingElement);
            list = backupPolicy.getMailPrivacyGateways();
            mappingElement = new PrivacyGatewayMappingElement();
            pgList = new ArrayList();
            for (PrivacyGateway privacyGateway : list) {
                if (privacyGateway == null) continue;
                mappingElement.setGatewayNwThrottlingName("PGThrottle-name");
                pgList.add(privacyGateway.getGatewayName());
            }
            mappingElement.setPrivacyGatewayNames(new ArrayList());
            mappingElement.setPrivacyGatewayNames(pgList);
            element.setMailPrivacyGatewayMappingElement(mappingElement);
            element.setSearchAlgoForPg(backupPolicy.getSearchAlgoForPg());
            element.setContentIndexEnabled(backupPolicy.isContentIndexEnabled());
        }
        logger.debug(element.isContentIndexEnabled() + "...content index enabled ... " + backupPolicy.isContentIndexEnabled());
        return element;
    }

    @Override
    public void updateMailBoxFailStatus(int cloudId, String userName, boolean failMailBox) {
        this.userDao.updateMailBoxFailStatus(cloudId, userName, failMailBox);
    }

    private String getCommentsForErrorCode(int errorCode) {
        String comments = "";
        if (errorCode == 0) {
            return "Newly created user";
        }
        if (errorCode == 201) {
            comments = "User not present in SharePoint";
        }
        if (errorCode == 202) {
            comments = "User OneDrive license invalid";
        }
        if (errorCode == 203) {
            comments = "Insufficient space in OneDrive subscription to use for backup";
        }
        if (errorCode == 404) {
            comments = "User site not found. Make sure the email ID provided is valid";
        }
        if (errorCode == 403) {
            comments = "OneDrive permission denied";
        }
        if (errorCode == 204) {
            comments = "OneDrive target not assigned";
        }
        return comments;
    }

    @Override
    public void mapODBIdAndErrorCode(UserListElement userListElement, Cloud cloud) {
        if (userListElement != null && !CollectionUtils.isEmpty((Collection)userListElement.getUserList())) {
            for (UserElement userElement : userListElement.getUserList()) {
                try {
                    boolean muxedEnabled = PCHelperConstant.isMuxedEnabled();
                    logger.debug(muxedEnabled + ":mux enabled................odb-login-id:" + userElement.getOdbLoginId());
                    String emailId = userElement.getEmailId();
                    logger.debug(emailId + ".....email and odb..." + userElement.getOdbLoginId());
                    if (StringUtils.isEmpty((String)emailId)) {
                        emailId = userElement.getOdbLoginId();
                    }
                    logger.debug(emailId + ".....email and odb1..." + userElement.getOdbLoginId());
                    List userList = !muxedEnabled ? this.userDao.getUserByODBLoginIdOrEmailId(1, emailId) : this.userDao.getUserByODBLoginId(1, emailId);
                    for (User userByUserNameOrEmail : userList) {
                        if (userByUserNameOrEmail == null) continue;
                        if (cloud.getGraphApiEnabled() != 1 && !muxedEnabled && StringUtils.isNotEmpty((String)userElement.getOdbLoginId())) {
                            userByUserNameOrEmail.setOdbLoginId(userElement.getOdbLoginId());
                        }
                        this.updateUserBkpTargetStatus(userElement, userByUserNameOrEmail);
                    }
                }
                catch (Exception e) {
                    logger.trace(EXCEPTION + e);
                    logger.error(EXCEPTION + e.getMessage());
                }
            }
        } else {
            logger.debug("userListElement is empty......");
        }
    }

    private void updateUserBkpTargetStatus(UserElement userElement, User userByUserNameOrEmail) {
        int backupTargetErrorCode = userElement.getBackupTargetErrorCode();
        boolean backupTargetAssigned = false;
        if (userElement.getBackupTargetErrorCode() == 0) {
            backupTargetAssigned = true;
            logger.debug("Updating " + userElement.getEmailId() + " ODB Id as :" + userElement.getOdbLoginId());
        }
        boolean failedMailBox = true;
        if (userElement.getBackupTargetErrorCode() == 444) {
            failedMailBox = false;
            logger.debug("userByUserNameOrEmail..." + userByUserNameOrEmail.getUserName());
            logger.debug("Updating " + userElement.getEmailId() + " failedMailBox :" + userElement.getOdbLoginId());
            this.userDao.updateUserfailedMailBox(1, userByUserNameOrEmail.getUserName(), failedMailBox);
            this.deviceDao.removeO365BlackListUser(1, userByUserNameOrEmail.getUserName());
        }
        if (backupTargetErrorCode == 450) {
            this.deviceDao.removeO365BlackListUser(1, userByUserNameOrEmail.getUserName());
        } else {
            this.userDao.updateUserBkpTargetStatus(1, userByUserNameOrEmail.getUserName(), backupTargetErrorCode, backupTargetAssigned, userByUserNameOrEmail.getOdbLoginId());
        }
        logger.debug(userByUserNameOrEmail.getUserName() + "......target errorcode....." + backupTargetErrorCode);
    }

    private void createUsersExcelBlockFail(int cloudId, List<UserElement> userList) {
        if (!CollectionUtils.isEmpty(userList)) {
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                List<List> recordToAdd = this.updateUserElementValuesToExcelForBlockFail(userList);
                this.createExcelForUserXlsx(recordToAdd, workbook);
                this.writeExcelForUserXlsxForBlackFail(workbook);
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
            }
        }
    }

    private List<List> updateUserElementValuesToExcelForBlockFail(List<UserElement> userList) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        List<String> headerRow = this.createHeaderRowForUserXlsxForBlockFail();
        recordToAdd.add(headerRow);
        for (UserElement userElement : userList) {
            List<String> firstRow = this.loadDataOnRowForUserXlsxForBlackFail(userElement);
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    List<String> createHeaderRowForUserXlsxForBlockFail() {
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add("User ID");
        headerRow.add("Reason");
        return headerRow;
    }

    List<String> loadDataOnRowForUserXlsxForBlackFail(UserElement userElement) {
        ArrayList<String> firstRow = new ArrayList<String>();
        firstRow.add(userElement.getUserName());
        if (!userElement.isLocalUser()) {
            firstRow.add("Not a Local User. Please remove from in AD or AAD group or Disable the user from AD or AAD");
        } else {
            firstRow.add(userElement.getStatus());
        }
        return firstRow;
    }

    void writeExcelForUserXlsxForBlackFail(XSSFWorkbook workbook) {
        try (FileOutputStream fos = new FileOutputStream(new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/Users_Block_Fail.xlsx"));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    @Override
    public boolean mapODBIds(int cloudId, String userName, String odbId) {
        return this.userDao.updateODBId(cloudId, userName, odbId);
    }

    @Override
    public List<UserElement> loadAllUsersEmailIds(int cloudId) {
        List loadAllUsersEmailIds = this.userDao.loadAllUsersEmailIds(cloudId);
        ArrayList<UserElement> elements = new ArrayList<UserElement>();
        for (String emailId : loadAllUsersEmailIds) {
            UserElement element = new UserElement();
            element.setEmailId(emailId);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public List<UserElement> getAllUnMapedUsers(int cloudId) {
        List userNames = this.userDao.getAllUnMapedUserNames(cloudId);
        ArrayList<UserElement> elements = new ArrayList<UserElement>();
        for (String emailId : userNames) {
            UserElement element = new UserElement();
            element.setUserName(emailId);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public List<UserElement> searchUsersForReport(int cloudId, String userName) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(userName.split(",")));
        HashSet<String> removeSet = new HashSet<String>();
        removeSet.addAll(list);
        list.clear();
        list.addAll(removeSet);
        List users = this.userDao.searchUsersForReport(cloudId, list);
        for (User user : users) {
            if (user == null) continue;
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public List<User> getAllExchangeBkpEnabledUsers(int cloudId) {
        List users = this.userDao.getAllExchangeBkpEnabledUsers(cloudId);
        if (CollectionUtils.isEmpty((Collection)users)) {
            logger.debug("...no users found for odbBkp........");
            return new ArrayList<User>();
        }
        return users;
    }

    @Override
    public long countOfPresentBackupUsers(int cloudId, String cloudName, boolean active) {
        return this.userDao.countOfPresentBackupUsers(cloudId, cloudName, active);
    }

    @Override
    public long countOfPresentSyncUsers(int cloudId, String cloudName, boolean active) {
        return this.userDao.countOfPresentSyncUsers(cloudId, cloudName, active);
    }

    @Override
    public long countOfPresentODBBackupUsers(int cloudId, String cloudName, boolean active) {
        return this.userDao.countOfPresentODBBackupUsers(cloudId, cloudName, active);
    }

    @Override
    public OfficeBackupPolicy getOfficeBackupPolicy(int cloudId, String policyName) {
        return this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, policyName);
    }

    @Override
    public List<UserElement> getAllSoftBlockUsers(int cloudId, int skipValue, User logedInUser) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        List usersList = this.userDao.getAllSoftBlockUsers(cloudId, "", skipValue);
        logger.debug(" user names list ... " + usersList.size());
        for (User user : usersList) {
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            userElementList.add(ue);
        }
        this.getValidUsers(logedInUser, userElementList);
        return userElementList;
    }

    @Override
    public long getAllSoftBlockUsersCount(int cloudId, List<String> policyNames) {
        return this.userDao.getAllSoftBlockUsersCount(cloudId, policyNames);
    }

    @Override
    public List<UserElement> getAllUsersForReadOnlyWithPagination(int cloudId, int pagNum, List<String> policyNames) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        List usersList = this.userDao.getAllUsersForReadOnlyWithPagination(cloudId, policyNames, pagNum);
        logger.debug(" user names list ... " + usersList.size());
        for (User user : usersList) {
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            if (user.isGuest()) continue;
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public List<BackupPolicy> getAllBackupPolicies(int cloudId) {
        return this.backupPolicyDao.getAllBackupPolicies(cloudId);
    }

    private String getDecryptePassword(String ldapPwdEnc) {
        String decryptedPwd = null;
        if (!StringUtils.isEmpty((String)ldapPwdEnc)) {
            try {
                decryptedPwd = this.decrypt(ldapPwdEnc, SECRET_KEY);
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error("ERROR in decryption ... " + e.getMessage());
                e.printStackTrace();
            }
        }
        return decryptedPwd;
    }

    public String decrypt(String encryptedPassword, String key) throws Exception {
        int ivSize = 16;
        int keySize = 16;
        logger.info(" encrypted password is " + encryptedPassword);
        byte[] payload = Base64.getDecoder().decode(encryptedPassword);
        byte[] iv = new byte[ivSize];
        System.arraycopy(payload, 0, iv, 0, iv.length);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        int encryptedSize = payload.length - ivSize;
        byte[] encryptedBytes = new byte[encryptedSize];
        System.arraycopy(payload, ivSize, encryptedBytes, 0, encryptedSize);
        byte[] keyBytes = new byte[keySize];
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(key.getBytes());
        System.arraycopy(md.digest(), 0, keyBytes, 0, keyBytes.length);
        SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "AES");
        Cipher cipherDecrypt = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipherDecrypt.init(2, (Key)secretKeySpec, ivParameterSpec);
        byte[] decrypted = cipherDecrypt.doFinal(encryptedBytes);
        return new String(decrypted);
    }

    private String generaterandompswd() {
        String characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789@.";
        String pwd = RandomStringUtils.random((int)8, (String)characters);
        return pwd;
    }

    @Override
    public UserElement getUserElementByUserName(Cloud cloud, String userName) {
        UserElement usrElement = new UserElement();
        int cloudId = cloud.getCloudId();
        User user = this.userDao.getUserByUserName(cloudId, userName);
        if (user == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)user, (Object)usrElement);
        return usrElement;
    }

    @Override
    public void autoDeleteUser(Cloud cloud) {
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        List allUsers = this.userDao.getAllUsers(cloudId, cloudName);
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        String autoExpireUsers = cloudProperties.getAutoExpireUsers();
        boolean autoExpireFeautreDisabled = false;
        if (StringUtils.isEmpty((String)autoExpireUsers) || "DISABLED".equals(autoExpireUsers)) {
            autoExpireFeautreDisabled = true;
        }
        if (!autoExpireFeautreDisabled) {
            boolean expireAllUsers = false;
            boolean expireLocalUsers = false;
            if (!StringUtils.isEmpty((String)autoExpireUsers)) {
                if ("ALL USERS".equals(autoExpireUsers)) {
                    expireAllUsers = true;
                }
                if ("LOCAL USERS".equals(autoExpireUsers)) {
                    expireLocalUsers = true;
                }
            }
            for (User user : allUsers) {
                long diff;
                long days;
                String autoExpireType = user.getAutoExpireType();
                boolean autoExpireTypeDisabled = false;
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)autoExpireType) || "DISABLED".equals(autoExpireType)) {
                    autoExpireTypeDisabled = true;
                }
                if (autoExpireTypeDisabled || expireLocalUsers && !user.isLocalUser() || user.getNoOfDaysForAutoBlock() <= 0L) continue;
                long noOfDays = 0L;
                if (StringUtils.isEmpty((String)user.getLastLoggedInTime())) {
                    user.setLastLoggedInTime(user.getCreatedTimestamp());
                }
                if ("EXPIRE_CREATED_TIME".equals(autoExpireType) && !StringUtils.isEmpty((String)user.getCreatedTimestamp())) {
                    noOfDays = Long.parseLong(user.getCreatedTimestamp());
                }
                if ("EXPIRE_IDLE_TIME".equals(autoExpireType) && !StringUtils.isEmpty((String)user.getLastLoggedInTime())) {
                    noOfDays = Long.parseLong(user.getLastLoggedInTime());
                }
                if ((days = TimeUnit.DAYS.convert(diff = System.currentTimeMillis() - noOfDays, TimeUnit.MILLISECONDS)) < user.getNoOfDaysForAutoBlock()) continue;
                logger.debug(user.getUserName() + "...userabout to delete.." + user.getNoOfDaysForAutoBlock() + "...created date more than days ..." + days);
                if (!user.isActive()) continue;
                user.setActive(false);
                this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), user);
                this.saveStatisticToDatabase(cloud, "Blocked", "AUTO", user.getUserName(), "automatic user-aging", System.currentTimeMillis(), PCActionTypes.AUTOMATIC_USER_AGING.getActionTypeValue());
            }
        }
    }

    @Override
    public void updateTargetStatus(int cloudId, boolean targetAssigned, int backupTargetErrorCode, String userName) {
        this.userDao.updateTargetStatus(cloudId, targetAssigned, backupTargetErrorCode, userName);
    }

    @Override
    public long countOfPresentOnedriveUsers(int cloudId, boolean active) {
        return this.userDao.countOfPresentOnedriveUsers(cloudId, active);
    }

    @Override
    public long countOfPresentExchangeUsers(int cloudId, boolean active) {
        return this.userDao.countOfPresentExchangeUsers(cloudId, active);
    }

    @Override
    public void removeUserbyID(int cloudId, String userId) {
        this.userDao.removeUserbyID(cloudId, userId);
    }

    @Override
    public void blockOrUnblockUser(int cloudId, String userName, boolean active) {
        this.userDao.blockOrUnblockUser(cloudId, userName, active);
    }
}

