/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.mem.MemoryStore;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.controller.DeviceManagementController;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.EventHubManagementService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.AuthorizationService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.paracloud.element.RestoreEventsElement;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.EventHubElement;
import com.parablu.pcbd.domain.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EventHubContoller
extends BaseController {
    private static Logger logger = LogManager.getLogger(DeviceManagementController.class);
    private static final String EXCEPTION = " Exception  :";
    protected static final String JSONVIEW = "jsonview";
    private static final String CLIENT_TYPE = "clientType";
    private static final String CRAWL_LIMIT = "crawlLimit";
    @Autowired
    private EventHubManagementService eventHubManagementService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private DeviceManagementService deviceManagementService;
    @Autowired
    private AuthorizationService authorizationService1;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Autowired
    private UserManagementService userManagementService;
    private static final String STOP_BACKUP_ERROR_CODE = "1207";
    private static final String PAUSE_BACKUP_ERROR_CODE = "1992";
    private static final String STOP_MAIL_RESTORE_ERROR_CODE = "1993";
    private static final String PAUSE_MAIL_RESTORE_ERROR_CODE = "1994";

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/eventHub/events/"}, method={RequestMethod.POST})
    public void editAction(@PathVariable(value="cloudName") String cloudName1, @RequestBody EventHubElement eventHubElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/eventHub/events/...  to edit action");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            User currentUser = new User();
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                return;
            }
            if (StringUtils.isEmpty((String)eventHubElement.getActionToDeviceUUID()) && CollectionUtils.isEmpty((Collection)eventHubElement.getActionToDeviceUUIDs())) {
                logger.debug("deviceUUID is null ");
                response.setStatus(406);
                return;
            }
            String actionByUserName = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token).getUser().getUserName();
            this.updateEvents(cloudName1, eventHubElement, request, response, cloudName, cl, cloudId, currentUser, actionByUserName);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    private void addAuditHistory(String cloudName, CloudLicenseTo cl, User currentUser, DeviceElement deviceElement, String actionFormPortal, boolean isDeletedSupportAction) {
        String actionname = null;
        int actionType = 0;
        if (actionFormPortal.equals(PCHelperConstant.EVENTHUB_ACTION.PULL_AGENTLOGS.toString())) {
            if (!isDeletedSupportAction) {
                actionname = "support logs for";
                actionType = PCActionTypes.PULL_AGENTLOGS_ENABLE.getActionTypeValue();
            } else {
                actionname = "Disable support logs for";
                actionType = PCActionTypes.PULL_AGENTLOGS_DISABLE.getActionTypeValue();
            }
        }
        if (actionFormPortal.equals(PCHelperConstant.EVENTHUB_ACTION.PULL_HISTORICAL_LOGS.toString())) {
            if (!isDeletedSupportAction) {
                actionname = "Historical logs for";
                actionType = PCActionTypes.PULL_HISTORICAL_LOGS_ENABLE.getActionTypeValue();
            } else {
                actionname = "Disable Historical logs for";
                actionType = PCActionTypes.PULL_HISTORICAL_LOGS_DISABLE.getActionTypeValue();
            }
        }
        if (actionFormPortal.equals(PCHelperConstant.EVENTHUB_ACTION.STOP_BACKUP_WHILE_RESTORE.toString())) {
            if (!isDeletedSupportAction) {
                actionname = "has Disabled backup  of ";
                actionType = PCActionTypes.STOP_BACKUP_WHILE_RESTORE.getActionTypeValue();
            } else {
                actionname = "has Enabled backup of ";
                actionType = PCActionTypes.STOP_BACKUP_WHILE_RESTORE.getActionTypeValue();
            }
        }
        if (actionFormPortal.equals(PCHelperConstant.EVENTHUB_ACTION.FULL_BACKUP.toString()) && !isDeletedSupportAction) {
            actionname = "Full backup of";
            actionType = PCActionTypes.START_BACKUP.getActionTypeValue();
        }
        if (actionFormPortal.equals(PCHelperConstant.EVENTHUB_ACTION.START_BACKUP.toString()) && !isDeletedSupportAction) {
            actionname = "Start backup of";
            actionType = PCActionTypes.START_BACKUP.getActionTypeValue();
        }
        if (actionFormPortal.equals(PCHelperConstant.EVENTHUB_ACTION.CANCEL_BACKUP.toString())) {
            actionname = "cancel backup of";
            actionType = PCActionTypes.CANCEL_BACKUP.getActionTypeValue();
        }
        if (actionFormPortal.equals(PCHelperConstant.EVENTHUB_ACTION.STOP_BACKUP.toString()) && !isDeletedSupportAction) {
            actionname = "Stop backup of";
            actionType = PCActionTypes.STOP_BACKUP.getActionTypeValue();
        }
        if (actionFormPortal.equals(PCHelperConstant.EVENTHUB_ACTION.PAUSE_BACKUP.toString()) && !isDeletedSupportAction) {
            actionname = "Pause backup of";
            actionType = PCActionTypes.PAUSE_BACKUP.getActionTypeValue();
        }
        if (actionFormPortal.equals(PCHelperConstant.EVENTHUB_ACTION.DATABASES.toString())) {
            if (!isDeletedSupportAction) {
                actionname = "databases of ";
                actionType = PCActionTypes.DATABASES.getActionTypeValue();
            } else {
                actionname = "Disable databases of";
                actionType = PCActionTypes.DATABASES.getActionTypeValue();
            }
        }
        if (actionFormPortal.equals(PCHelperConstant.EVENTHUB_ACTION.SETUP_LOGS.toString())) {
            if (!isDeletedSupportAction) {
                actionname = "Setup Logs of ";
                actionType = PCActionTypes.SETUP_LOGS.getActionTypeValue();
            } else {
                actionname = "DisableSetup Logs of";
                actionType = PCActionTypes.SETUP_LOGS.getActionTypeValue();
            }
        }
        this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "requested " + actionname, currentUser.getUserName(), "device name:" + deviceElement.getDeviceName() + ", user Name:" + deviceElement.getUserName(), "Portal", System.currentTimeMillis(), actionType);
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/eventHub/events/"}, method={RequestMethod.GET})
    public ModelAndView getEvents(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String deviceUUID = request.getParameter("deviceUUID");
        logger.debug("...old api method versions/{versionNumber}/clouds/{cloudName}/eventHub/events/ ...." + deviceUUID);
        return this.getEvents(cloudName1, deviceUUID, request, response);
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/eventHub/events/{deviceUUID}"}, method={RequestMethod.GET})
    public ModelAndView editActions(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        return this.getEvents(cloudName1, deviceUUID, request, response);
    }

    private ModelAndView getEvents(String cloudName1, String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(JSONVIEW);
        String client = request.getHeader(CLIENT_TYPE);
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/eventHub/events/...  to get action of " + deviceUUID);
        try {
            User user;
            String token;
            if (this.getCurrentCrawlLimit() > PCHelperConstant.getMaxCrawlHitCount()) {
                logger.debug("@@@CRAWL_COUNT has exceeded  /eventHub/events/{deviceUUID} the max limit of>>>:" + PCHelperConstant.getMaxCrawlHitCount() + "..sleep for 20 secs...");
                response.setStatus(500);
                return null;
            }
            this.incrementCrawlLimit();
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                this.decrementCrawlLimit();
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
                this.decrementCrawlLimit();
                return null;
            }
            if (user != null && user.isSuspended()) {
                logger.debug("User is suspended.....");
                response.setStatus(400);
                return null;
            }
            logger.debug(" ...events,,,," + deviceUUID);
            Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
            if (device == null) {
                response.setStatus(406);
                this.decrementCrawlLimit();
                logger.error("...invalid device.....");
                return null;
            }
            long currentmillis = System.currentTimeMillis();
            logger.debug("calling events1....");
            DeviceBackupOverView overView = this.deviceManagementService.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
            if (overView != null) {
                String actionByUserName = user.getUserName();
                if (StringUtils.isEmpty((String)client)) {
                    this.deviceManagementService.updateLastHeardTime(cloudId, overView.getId());
                    logger.debug("[agentHeardTimeStamp][" + actionByUserName + "][" + deviceUUID + "][" + currentmillis + "]");
                }
                EventHub eventHub = new EventHub();
                eventHub.setActionBy(actionByUserName);
                eventHub.setActionToDeviceUUID(deviceUUID);
                String actionToUserName = overView.getUserName();
                logger.debug(actionToUserName + "...calling events2...." + actionByUserName);
                eventHub.setActionToUserName(actionToUserName);
                long devicePolicyUpdatedTime = overView.getPolicyUpdatedTime();
                long timeStampOfPolicyModified = user.getPolicyModifiedTime();
                List<String> actions = this.eventHubManagementService.getActionForDevice(cloudId, cloudName, eventHub, timeStampOfPolicyModified, devicePolicyUpdatedTime);
                EventHubElement eventHubElement = new EventHubElement();
                eventHubElement.setActions(actions);
                eventHubElement.setActionToDeviceUUID(deviceUUID);
                eventHubElement.setActionToUserName(eventHub.getActionToUserName());
                modelAndView.addObject((Object)eventHubElement);
                response.setStatus(200);
                this.decrementCrawlLimit();
            }
            return modelAndView;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            this.decrementCrawlLimit();
            return null;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/eventHub/events/"}, method={RequestMethod.DELETE})
    public void deleteAction(@PathVariable(value="cloudName") String cloudName1, @RequestParam(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(JSONVIEW);
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/eventHub/events/...  TO DELETE  ");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String actions = request.getHeader("action");
            List<Object> list = new ArrayList();
            if (StringUtils.isNotEmpty((String)actions)) {
                list = Arrays.asList(actions.split(","));
            }
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return;
            }
            String actionByUserName = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token).getUser().getUserName();
            DeviceElement deviceElement = this.deviceManagementService.getDeviceInfo(cloudId, cloudName, deviceUUID);
            String acctionToUserName = deviceElement.getUserName();
            EventHub eventHub = new EventHub();
            eventHub.setActionToDeviceUUID(deviceUUID);
            eventHub.setActionToUserName(acctionToUserName);
            eventHub.setActionBy(actionByUserName);
            for (String string : list) {
                eventHub.setAction(string);
                logger.debug("Deleteing action for user " + acctionToUserName + " for device " + deviceUUID + " action is " + string);
                this.eventHubManagementService.deleteAction(cloudId, cloudName, eventHub);
            }
            if (StringUtils.isEmpty((String)actions)) {
                logger.debug("action list is empty so delete all even actions");
                this.eventHubManagementService.deleteAllLogEvents(cloudId, cloudName, eventHub);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return;
        }
    }

    private synchronized int getCurrentCrawlLimit() {
        int crawlLimit = 0;
        if (MemoryStore.get((String)CRAWL_LIMIT) != null) {
            crawlLimit = (Integer)MemoryStore.get((String)CRAWL_LIMIT);
        }
        EventHubContoller.printLogs("@@@CURRENT-Crawl count ............. " + crawlLimit, PCHelperConstant.isBrevityLogging());
        return crawlLimit;
    }

    private synchronized void incrementCrawlLimit() {
        int crawlLimit = this.getCurrentCrawlLimit();
        MemoryStore.delete((String)CRAWL_LIMIT);
        MemoryStore.add((String)CRAWL_LIMIT, (Object)(++crawlLimit));
        EventHubContoller.printLogs("@@@INCREMENT Crawl count ............. " + crawlLimit, PCHelperConstant.isBrevityLogging());
    }

    private synchronized void decrementCrawlLimit() {
        int crawlLimit = this.getCurrentCrawlLimit();
        if (crawlLimit > 0) {
            --crawlLimit;
        }
        MemoryStore.delete((String)CRAWL_LIMIT);
        MemoryStore.add((String)CRAWL_LIMIT, (Object)crawlLimit);
        logger.debug("@@@DECREMENT Crawl count ............. " + crawlLimit);
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/restoreEvents/{deviceUUID}"}, method={RequestMethod.GET})
    public ModelAndView getRestoreEvents(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        response.setContentType("text/html; charset=UTF-8");
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/restoreEvents/...  to get restoreEvents of " + deviceUUID);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String destinationFolder = request.getHeader("destinationFolder");
            User user = new User();
            if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
                return null;
            }
            if (user != null && user.isSuspended()) {
                logger.debug("User is suspended.....");
                response.setStatus(400);
                return null;
            }
            Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
            if (device == null) {
                response.setStatus(406);
                logger.error("...invalid device.....");
                return null;
            }
            RestoreEventsElement restoreEventByUUIDAndFolder = this.eventHubManagementService.getRestoreEventByUUIDAndFolder(cloudId, deviceUUID, destinationFolder);
            logger.debug("User ................");
            if (restoreEventByUUIDAndFolder == null) {
                restoreEventByUUIDAndFolder = new RestoreEventsElement();
            } else {
                logger.debug(".....restoreEventByUUIDAndFolder.getActionOnDeviceUUID()....." + restoreEventByUUIDAndFolder.getActionOnDeviceUUID());
                if (!deviceUUID.equalsIgnoreCase(restoreEventByUUIDAndFolder.getActionOnDeviceUUID())) {
                    device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, restoreEventByUUIDAndFolder.getActionOnDeviceUUID());
                }
                if (device != null) {
                    restoreEventByUUIDAndFolder.setActionOnDeviceType(device.getOsType());
                    restoreEventByUUIDAndFolder.setDeviceId(device.getId().toString());
                }
            }
            response.setStatus(200);
            logger.debug(device.getId().toString() + "User ................" + restoreEventByUUIDAndFolder.getSuspendBackup());
            modelAndView.addObject((Object)restoreEventByUUIDAndFolder);
            return modelAndView;
        }
        catch (Exception e) {
            logger.debug("EXCEPTION ................");
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/restoreEvents/{deviceUUID}"}, method={RequestMethod.DELETE})
    public void deleteRestoreActions(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("versions/{versionNumber}/clouds/{cloudName}/restoreEvents/{deviceUUID}   to delete restore... " + deviceUUID);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            User currentUser = new User();
            String token = request.getHeader("token");
            String batchId = request.getHeader("batchId");
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                return;
            }
            Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
            if (device == null) {
                response.setStatus(406);
                logger.error("...invalid device.....");
                return;
            }
            this.eventHubManagementService.deleteRestoreEventsByBatchId(cloudId, batchId);
            this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "deleted restore for", currentUser.getUserName(), "device name:" + device.getDeviceName(), "Portal", System.currentTimeMillis(), PCActionTypes.START_RESTORE.getActionTypeValue());
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/restoreEvents/"}, method={RequestMethod.POST})
    public ModelAndView createRestoreActions(@PathVariable(value="cloudName") String cloudName1, @RequestBody RestoreEventsElement restoreEventsElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/eventHub/events/...  to edit action");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            User currentUser = new User();
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                return null;
            }
            Device sourceDevice = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, restoreEventsElement.getActionOnDeviceUUID());
            Device destinationDevice = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, restoreEventsElement.getDestinationDeviceUUID());
            if (destinationDevice == null) {
                response.setStatus(406);
                logger.error("...invalid destinationDevice.....");
                return null;
            }
            String actionByUserName = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token).getUser().getUserName();
            restoreEventsElement.setActionBy(actionByUserName);
            RestoreEventsElement updateRestoreEvents = this.eventHubManagementService.updateRestoreEvents(cloudId, restoreEventsElement, destinationDevice.getUserName());
            if (updateRestoreEvents != null) {
                modelAndView.addObject((Object)updateRestoreEvents);
                response.setStatus(417);
                return modelAndView;
            }
            String actionOnUser = this.constructActionOnUser(sourceDevice, destinationDevice, restoreEventsElement);
            this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "initiated restore for", currentUser.getUserName(), actionOnUser, "Portal", System.currentTimeMillis(), PCActionTypes.START_RESTORE.getActionTypeValue());
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
        return modelAndView;
    }

    private String constructActionOnUser(Device sourceDevice, Device destinationDevice, RestoreEventsElement restoreEventsElement) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append("{Source - [User: ").append(sourceDevice.getUserName()).append("] [Device Name: ").append(sourceDevice.getDeviceName()).append("]} ");
            stringBuilder.append("{Destination - [User: ").append(destinationDevice.getUserName()).append("] [Device Name: ").append(destinationDevice.getDeviceName()).append("]} ");
            stringBuilder.append("{Restore Source Path: ");
            if (restoreEventsElement.getFileElement().getFileCompletePath().isEmpty()) {
                stringBuilder.append("All Drives} ");
            } else {
                stringBuilder.append(restoreEventsElement.getFileElement().getFileCompletePath()).append("} ");
            }
            if (!restoreEventsElement.isInPlaceRestore()) {
                stringBuilder.append("{Restore Destination Path: ").append(restoreEventsElement.getDestinationPath()).append("} ");
            }
            stringBuilder.append("{Properties: ");
            stringBuilder.append("[Number of Threads: ").append(restoreEventsElement.getNoOfThreads()).append("] ");
            stringBuilder.append("[Disallow new backups during this restore: ").append(restoreEventsElement.getSuspendBackup()).append("] ");
            stringBuilder.append("[Restore all Versions: ").append(restoreEventsElement.isRestoreAllVersions()).append("] ");
            stringBuilder.append("[In place Restore: ").append(restoreEventsElement.isInPlaceRestore()).append("] ");
            stringBuilder.append("[Restore Deleted Files: ").append(restoreEventsElement.isRestoreDeletedFiles()).append("] ");
            stringBuilder.append("[Overwrite Newer Files: ").append(restoreEventsElement.isOverwriteNewerFiles()).append("] ");
            if (restoreEventsElement.getRestoreDataBefore() != 0L) {
                Date date = new Date(restoreEventsElement.getRestoreDataBefore());
                stringBuilder.append("[Restore Before: ").append(date).append("]");
            }
            stringBuilder.append("}");
        }
        catch (Exception e) {
            logger.error("Failed to construct Audit History" + e.getMessage());
        }
        return stringBuilder.toString();
    }

    private void updateEventsByDevice(String cloudName1, EventHubElement eventHubElement, HttpServletRequest request, HttpServletResponse response, CloudLicenseTo cl, int cloudId, User currentUser, String actionByUserName, DeviceElement deviceElement, String acctionToUserName) {
        logger.debug(request.getHeader("isStopBackup") + "..... device type..... " + request.getHeader("isPauseBackup"));
        if (Boolean.parseBoolean(request.getHeader("isPauseBackup"))) {
            logger.debug(actionByUserName + "..entering pause event..." + acctionToUserName);
            String errorCode = PAUSE_BACKUP_ERROR_CODE;
            if (PAUSE_BACKUP_ERROR_CODE.equalsIgnoreCase(errorCode)) {
                errorCode = "1208";
            }
            logger.debug("error code for action ... " + errorCode);
            this.eventHubManagementService.updateBackupBatchForStopAndPauseBkp(cloudId, eventHubElement.getActionToDeviceUUID(), errorCode, PCHelperConstant.EVENTHUB_ACTION.PAUSE_BACKUP.toString());
            this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, PCHelperConstant.EVENTHUB_ACTION.PAUSE_BACKUP.toString(), false);
            response.setStatus(200);
            logger.debug("...pause backup... " + eventHubElement.getActionToDeviceUUID());
            return;
        }
        if (Boolean.parseBoolean(request.getHeader("isStopBackup"))) {
            String errorCode = STOP_BACKUP_ERROR_CODE;
            logger.debug(actionByUserName + "..entering StopBackup event..." + acctionToUserName);
            if (STOP_BACKUP_ERROR_CODE.equalsIgnoreCase(errorCode)) {
                errorCode = "1209";
            }
            logger.debug("error code for action ... " + errorCode);
            this.eventHubManagementService.updateBackupBatchForStopAndPauseBkp(cloudId, eventHubElement.getActionToDeviceUUID(), errorCode, PCHelperConstant.EVENTHUB_ACTION.STOP_BACKUP.toString());
            this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, PCHelperConstant.EVENTHUB_ACTION.STOP_BACKUP.toString(), false);
            response.setStatus(200);
            logger.debug("...stopped backup... " + eventHubElement.getActionToDeviceUUID());
            return;
        }
        logger.debug("... creating event hub....");
        EventHub eventHub = new EventHub();
        eventHub.setActionBy(actionByUserName);
        eventHub.setActionStatus(PCHelperConstant.EVENTHUB_ACTION_STATUS.CREATED.toString());
        eventHub.setActionToUserName(acctionToUserName);
        eventHub.setActionToDeviceUUID(eventHubElement.getActionToDeviceUUID());
        if (Device.TYPE.ONEDRIVE.toString().equals(deviceElement.getDeviceType()) || Device.TYPE.OUTLOOK.toString().equals(deviceElement.getDeviceType())) {
            eventHub.setOdStatus(EventHub.ODSTATUS.STARTED.toString());
        }
        List<String> actionsFromDb = this.eventHubManagementService.getActionsByUserNameAndAction(cloudId, cloudName1, eventHub);
        logger.debug("actions From Db" + actionsFromDb);
        ArrayList<String> actionsFromDb1 = new ArrayList<String>();
        actionsFromDb1.addAll(actionsFromDb);
        List actionsFormReqst = eventHubElement.getActions();
        if (!CollectionUtils.isEmpty((Collection)eventHubElement.getActions())) {
            logger.debug("...inside if 1.....");
            actionsFromDb1.removeAll(actionsFormReqst);
            actionsFormReqst.removeAll(actionsFromDb);
            actionsFormReqst.forEach(action -> {
                EventHub eventHubObj = new EventHub();
                BeanUtils.copyProperties((Object)eventHub, (Object)eventHubObj);
                logger.debug("actions Form Reqst" + actionsFormReqst);
                logger.debug("action:" + action);
                eventHubObj.setAction(action);
                this.eventHubManagementService.saveAction(cloudId, cloudName1, eventHubObj);
                this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, (String)action, false);
            });
            actionsFromDb1.forEach(action -> {
                logger.debug("actions From Db1" + actionsFromDb1);
                eventHub.setAction(action);
                this.eventHubManagementService.deleteAction(cloudId, cloudName1, eventHub);
                if (action.contains(PCHelperConstant.EVENTHUB_ACTION.PULL_AGENTLOGS.toString()) || action.contains(PCHelperConstant.EVENTHUB_ACTION.PULL_HISTORICAL_LOGS.toString()) || action.contains(PCHelperConstant.EVENTHUB_ACTION.DATABASES.toString()) || action.contains(PCHelperConstant.EVENTHUB_ACTION.SETUP_LOGS.toString())) {
                    this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, (String)action, true);
                }
            });
        } else {
            logger.debug("...inside else 1....." + actionsFromDb);
            this.eventHubManagementService.deleteAllActionByDeviceUUID(cloudId, eventHub);
            boolean isCancelBackup = true;
            if (actionsFromDb.contains(PCHelperConstant.EVENTHUB_ACTION.PULL_AGENTLOGS.toString())) {
                this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, "PULL_AGENTLOGS", true);
                isCancelBackup = false;
            }
            if (actionsFromDb.contains(PCHelperConstant.EVENTHUB_ACTION.PULL_HISTORICAL_LOGS.toString())) {
                this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, "PULL_HISTORICAL_LOGS", true);
                isCancelBackup = false;
            }
            if (actionsFromDb.contains(PCHelperConstant.EVENTHUB_ACTION.DATABASES.toString())) {
                this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, "DATABASES", true);
                isCancelBackup = false;
            }
            if (actionsFromDb.contains(PCHelperConstant.EVENTHUB_ACTION.SETUP_LOGS.toString())) {
                this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, "SETUP_LOGS", true);
                isCancelBackup = false;
            }
            if (isCancelBackup) {
                this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, PCHelperConstant.EVENTHUB_ACTION.CANCEL_BACKUP.toString(), true);
            }
        }
    }

    private void updateEvents(String cloudName1, EventHubElement eventHubElement, HttpServletRequest request, HttpServletResponse response, String cloudName, CloudLicenseTo cl, int cloudId, User currentUser, String actionByUserName) {
        if (!StringUtils.isEmpty((String)eventHubElement.getActionToDeviceUUID())) {
            DeviceElement deviceElement = this.deviceManagementService.getDeviceInfo(cloudId, cloudName, eventHubElement.getActionToDeviceUUID());
            String acctionToUserName = deviceElement.getUserName();
            logger.debug("..... device type..... " + deviceElement.getDeviceType());
            this.updateEventsByDevice(cloudName1, eventHubElement, request, response, cl, cloudId, currentUser, actionByUserName, deviceElement, acctionToUserName);
        } else {
            for (String deviceUUID : eventHubElement.getActionToDeviceUUIDs()) {
                logger.debug(".....deviceUUID........" + deviceUUID);
                DeviceElement deviceElement = this.deviceManagementService.getDeviceInfo(cloudId, cloudName, deviceUUID);
                if (deviceElement != null) {
                    String acctionToUserName = deviceElement.getUserName();
                    logger.debug("..... acctionToUserName..... " + acctionToUserName);
                    eventHubElement.setActionToDeviceUUID(deviceUUID);
                    this.updateEventsByDevice(cloudName1, eventHubElement, request, response, cl, cloudId, currentUser, actionByUserName, deviceElement, acctionToUserName);
                    continue;
                }
                logger.debug("..................Device is null............");
            }
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/restore/stop"}, method={RequestMethod.POST})
    public void createRestoreActions(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/restore/stop...  to edit action");
        try {
            String[] deviceUUIDs;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            User currentUser = new User();
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                return;
            }
            String deviceUUIDsList = request.getHeader("deviceUUIDs");
            if (StringUtils.isEmpty((String)deviceUUIDsList)) {
                response.setStatus(406);
                logger.error("...invalid device.....");
                return;
            }
            String actionByUserName = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token).getUser().getUserName();
            for (String deviceUUID : deviceUUIDs = deviceUUIDsList.split(",")) {
                logger.debug("....deviceUUID.........." + deviceUUID);
                DeviceElement deviceElement = this.deviceManagementService.getDeviceInfo(cloudId, cloudName, deviceUUID);
                this.eventHubManagementService.updateBackupBatchForStopRestore(cloudId, deviceUUID, STOP_BACKUP_ERROR_CODE);
                String actionname = "Stop restore";
                this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "requested " + actionname, actionByUserName, "device name:" + deviceElement.getDeviceName() + ", user Name:" + deviceElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.STOP_RESTORE.getActionTypeValue());
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }
}

