/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.CloudCreationService;
import com.parablu.cloud.security.service.CloudDiskUsageService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.service.NetworkManagementService;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.util.DiskSpaceHelper;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.User;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class CloudCreationController
extends BaseController {
    private static Logger logger = LogManager.getLogger(CloudCreationController.class);
    @Autowired
    private CloudCreationService cloudCreationService;
    @Autowired
    private UserManagementService managementService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Autowired
    private CloudDiskUsageService cloudDiskUsageService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private NetworkManagementService networkManagementService;

    @RequestMapping(value={"/validate/cloud"}, method={RequestMethod.GET})
    public void validateCloud(HttpServletRequest request, HttpServletResponse response) {
        String devKey = request.getHeader("devkey");
        try {
            Cloud cloud = this.cloudCreationService.validateCloudKey(devKey);
            if (cloud == null) {
                response.setStatus(401);
            } else {
                this.licenseService.updateCloudLicense(cloud);
                response.setStatus(200);
            }
        }
        catch (BaseException e) {
            logger.debug("BaseException", (Throwable)e);
            response.setStatus(e.getErrorStatus());
        }
        catch (Exception e) {
            logger.debug("Exception", (Throwable)e);
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"/create/admin/user"}, method={RequestMethod.POST})
    public void createFirstAdminUser(HttpServletRequest request, HttpServletResponse response) {
        String devKey = request.getHeader("devkey");
        String userName = request.getHeader("username");
        String password = request.getHeader("password");
        String email = request.getHeader("email");
        try {
            if (!(StringUtils.hasText((String)userName) && StringUtils.hasText((String)password) && StringUtils.hasText((String)email))) {
                throw new BaseException("User name not found.", 400);
            }
            Cloud cloud = this.cloudCreationService.validateCloudKey(devKey);
            if (cloud == null) {
                response.setStatus(401);
            } else {
                if (!this.managementService.getAllUsers(cloud.getCloudId(), cloud.getCloudName()).isEmpty()) {
                    throw new BaseException("Users already exist", 409);
                }
                User user = this.createFirstUser(userName, password, email, true, true);
                this.managementService.createUser(cloud.getCloudId(), cloud.getCloudName(), user);
                DiskSpaceHelper.forceReinitialiseDiskSpace((String)cloud.getCloudName(), (long)this.cloudDiskUsageService.getTotalDiskSpaceUsedForCloud(cloud.getCloudId(), cloud.getCloudName()));
                this.auditHistoryService.saveStatisticToDatabase(cloud.getCloudId(), cloud.getCloudName(), "created  a new user", userName, userName, "ParaBlu", System.currentTimeMillis(), PCActionTypes.USER_CREATE.getActionTypeValue());
                response.setStatus(202);
            }
        }
        catch (BaseException e) {
            logger.debug("BaseException", (Throwable)e);
            response.setStatus(e.getErrorStatus());
        }
        catch (Exception e) {
            logger.debug("Exception", (Throwable)e);
            response.setStatus(500);
        }
    }

    protected User createFirstUser(String userName, String password, String email, boolean syncEnabled, boolean backupEnabled) {
        User user = new User();
        user.setActive(true);
        user.setAdmin(true);
        user.setEmailId(email);
        user.setLastModifiedTimestamp(String.valueOf(System.currentTimeMillis()));
        user.setUserName(userName);
        user.setPasswdHash(password);
        user.setBackupEnabled(backupEnabled);
        user.setSyncEnabled(syncEnabled);
        user.setShareEnabled(true);
        return user;
    }

    @RequestMapping(value={"/api/check/firstlogin"}, method={RequestMethod.GET})
    public void checkAmazonFTL(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Checking First time login for amazon.....");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            List clouds = this.licenseService.getClouds();
            if (!clouds.isEmpty()) {
                if (!((Cloud)clouds.get(0)).getCloudName().isEmpty()) {
                    response.setHeader("first-login", "false");
                    response.setHeader("cloud-name", ((Cloud)clouds.get(0)).getCloudName());
                    response.setStatus(200);
                } else {
                    response.setHeader("first-login", "true");
                    response.setStatus(200);
                }
            } else {
                response.setStatus(500);
            }
            return;
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(" Exception  :" + e);
            logger.error(" Exception while trying to get all Customers ... " + e.getMessage());
            return;
        }
    }
}

