/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bp.service.impl;

import com.parablu.bp.service.PortalPropertiesService;
import com.parablu.httpclient.util.HttpClientUtil;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.BrandingItem;
import com.parablu.paracloud.element.BrandingItemList;
import com.parablu.paracloud.element.PortalPropertiesElement;
import com.parablu.pcbd.dao.BluVaultDao;
import com.parablu.pcbd.dao.PortalPropertiesDao;
import com.parablu.pcbd.domain.BluVault;
import com.parablu.pcbd.domain.PortalProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

public class PortalPropertiesServiceImpl
implements PortalPropertiesService {
    @Resource
    private PortalPropertiesDao portalPropertiesDao;
    private static Logger logger = LogManager.getLogger(PortalPropertiesServiceImpl.class);
    private static final String PREFIX_HTTP = "http://";
    private static final String PREFIX_HTTPS = "https://";
    @Resource
    private BluVaultDao bluVaultDao;
    public static final String FILE_PATH = "/parablu/tmp-chunk";

    @Override
    public PortalProperties getPortalProperties(int cloudId, String componentName) {
        return this.portalPropertiesDao.getPortalProperties(cloudId, componentName);
    }

    public PortalPropertiesDao getPortalPropertiesDao() {
        return this.portalPropertiesDao;
    }

    public void setPortalPropertiesDao(PortalPropertiesDao portalPropertiesDao) {
        this.portalPropertiesDao = portalPropertiesDao;
    }

    @Override
    public Boolean updateComponents(int cloudId, PortalPropertiesElement portalPropertiesElement) {
        PortalProperties portalProperties = this.portalPropertiesDao.getPortalProperties(cloudId, portalPropertiesElement.getComponentName());
        if (portalProperties != null) {
            portalProperties.setComponentsProperties(portalPropertiesElement.getComponentsProperties());
            this.portalPropertiesDao.savePortalProperties(cloudId, portalProperties);
            return true;
        }
        return false;
    }

    @Override
    public BrandingItemList getBrandingItem(List<String> fileNames, String filePath) {
        BrandingItemList brandingItemList = new BrandingItemList();
        ArrayList<BrandingItem> branchElements = new ArrayList<BrandingItem>();
        if (StringUtils.isEmpty((String)filePath)) {
            filePath = FILE_PATH;
        }
        for (String fileName : fileNames) {
            boolean brandingItimeResult = this.portalPropertiesDao.getBrandingItem(filePath, fileName);
            if (!brandingItimeResult) continue;
            BrandingItem brandingItem = new BrandingItem();
            brandingItem.setFilePath(filePath);
            brandingItem.setFileName(fileName);
            branchElements.add(brandingItem);
        }
        brandingItemList.setBrandingItems(branchElements);
        return brandingItemList;
    }

    @Override
    public void saveBrandingItem(int cloudId, String filePath, String fileName) {
        this.portalPropertiesDao.saveBrandingItem(filePath, fileName);
        if (fileName.equalsIgnoreCase("emails.xml")) {
            logger.debug("calling send emails  new...");
            this.resetMailtemplate();
        }
        List allGateways = this.bluVaultDao.getAllBluVaults(cloudId, "");
        for (BluVault gateway : allGateways) {
            logger.debug(".....allGateways...." + gateway.getBluVaultName());
            Map componentsProperties = gateway.getComponentsProperties();
            if (gateway == null || CollectionUtils.isEmpty((Map)componentsProperties)) continue;
            componentsProperties.put("brandingPropertyUpdated", "false");
            gateway.setComponentsProperties(componentsProperties);
            logger.debug(".....allGateways...." + (String)gateway.getComponentsProperties().get("brandingPropertyUpdated"));
            this.bluVaultDao.saveBluVault(cloudId, "", gateway);
        }
    }

    @Override
    public List<BrandingItem> getBrandingItems() {
        return this.portalPropertiesDao.getBrandingItems();
    }

    @Override
    public boolean deleteBrandingItems(String fileName) {
        File f = new File("/var/www/portal/app/templates/default/collateral/" + fileName);
        if (f.exists()) {
            f.delete();
        }
        if (fileName.equalsIgnoreCase("emails.xml")) {
            logger.debug("calling send emails  new...");
            this.resetMailtemplate();
        }
        return this.portalPropertiesDao.deleteBrandingItem(fileName);
    }

    private void resetMailtemplate() {
        HttpComponentsClientHttpRequestFactory requestFactory = HttpClientUtil.getHttpRequestFactory();
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        ArrayList<MappingJackson2HttpMessageConverter> messageConverters = new ArrayList<MappingJackson2HttpMessageConverter>();
        messageConverters.add(new MappingJackson2HttpMessageConverter());
        restTemplate.setMessageConverters(messageConverters);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String url = PCHelperConstant.getPropertyFileValueParacloudUrl() + "/paramail/reset/mailTemplate/";
        if (PCHelperConstant.isHttpEnabled()) {
            url = url.replace(PREFIX_HTTPS, PREFIX_HTTP);
        }
        logger.debug("ParaMail url={} and is Http enabled={}", (Object)url, (Object)PCHelperConstant.isHttpEnabled());
        restTemplate.put(url, null, new Object[0]);
    }

    public BluVaultDao getBluVaultDao() {
        return this.bluVaultDao;
    }

    public void setBluVaultDao(BluVaultDao bluVaultDao) {
        this.bluVaultDao = bluVaultDao;
    }
}

