/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import com.parablu.pcbd.dao.FileRevisionDao;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.ConsolidatedImage;
import com.parablu.pcbd.domain.DailySyncOverView;
import com.parablu.pcbd.domain.FileRevision;
import com.parablu.pcbd.domain.SyncOverView;
import com.pg.factory.BlukryptMongoFactoryUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;

public class FileRevisionDaoImpl
implements FileRevisionDao {
    Logger logger = LogManager.getLogger(FileRevisionDaoImpl.class);
    private static final String CONSOLIDATED_IMAGE_ID = "consolidatedImage.$id";
    private static final String LASTMODIFIEDTIME_STR = "lastModifiedTime";
    private static final String PREFIX_DOLLAR_MATCH = "$match";
    private static final String REVISIONS_STR = "REVISIONS";
    private static final String PREFIX_DOLLAR_CONSOLIDATEDIMAGE = "$consolidatedImage";
    private static final String DOCID_STR = "docId";
    private static final String PREFIX_DOLLAR_LAST = "$last";
    private static final String PREFIX_DOLLAR_LASTMODIFIEDTIME = "$lastModifiedTime";
    private static final String PREFIX_DOLLAR_GROUP = "$group";
    private static final String PREFIX_DOLLAR_SORT = "$sort";
    private static final String PREFIX_DOLLAR_DOCID = "$docId";
    private static final String CONSOLIDATEDIMAGE_STR = "consolidatedImage";
    private static final String PREFIX_DOLLAR_PROJECT = "$project";
    private static final String MODIFIEDTIME_STR = "modifiedTime";
    private static final String FSPATH_STR = "fSPath";
    BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    @Override
    public FileRevision getLatestRevision(int cloudId, String cloudName, ObjectId consolidateImageId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).is((Object)consolidateImageId)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LASTMODIFIEDTIME_STR}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (FileRevision)mongoTemplate.findOne(query, FileRevision.class);
    }

    @Override
    public FileRevision getLatestPresentRevision(int cloudId, String cloudName, ObjectId consolidateImageId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).is((Object)consolidateImageId), Criteria.where((String)"status").ne((Object)"DELETED")});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LASTMODIFIEDTIME_STR}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (FileRevision)mongoTemplate.findOne(query, FileRevision.class);
    }

    @Override
    public List<FileRevision> getAllRevisions(int cloudId, String cloudName, ObjectId consolidateImageId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).is((Object)consolidateImageId)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LASTMODIFIEDTIME_STR}));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, FileRevision.class);
    }

    @Override
    public void saveRevision(int cloudId, String cloudName, FileRevision fileRevision) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)fileRevision);
    }

    @Override
    public List<FileRevision> getLatestByRevisionsByConsoIds(int cloudId, String cloudName, List<ObjectId> consoIdList, String userName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("RESTORED");
        statusList.add("DELETED");
        Document query = new Document("status", (Object)new Document("$nin", statusList));
        return this.getResultsForQuery(mongoTemplate, consoIdList, (Bson)query);
    }

    @Override
    public void reduceUploadSizeOfUserSyncOverView(int cloudId, long filesExpiredDate, double size) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"overViewDate").is((Object)filesExpiredDate)});
        Query query = new Query((CriteriaDefinition)criteria);
        DailySyncOverView dailySyncIverView = (DailySyncOverView)mongoTemplate.findOne(query, DailySyncOverView.class);
        if (dailySyncIverView.getTotalSizeUploaded() != 0L) {
            long reducedSize = dailySyncIverView.getTotalSizeUploaded() - (long)size;
            dailySyncIverView.setTotalSizeUploaded(reducedSize);
        }
        mongoTemplate.save((Object)dailySyncIverView);
    }

    private List<FileRevision> getResultsForQuery(MongoTemplate mongoTemplate, List<ObjectId> consoIdList, Bson query) {
        this.logger.debug("...latest getResultsForQuery..........");
        Bson matchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)CONSOLIDATED_IMAGE_ID, (Object)new Document("$in", consoIdList)), Filters.eq((Object)query)});
        MongoCollection collection = mongoTemplate.getCollection(REVISIONS_STR);
        ArrayList<Bson> pipeline = new ArrayList<Bson>(4);
        pipeline.add(Aggregates.match((Bson)matchQuery));
        pipeline.add(Aggregates.group((Object)new Document().append("_id", (Object)PREFIX_DOLLAR_CONSOLIDATEDIMAGE), (BsonField[])new BsonField[]{new BsonField(DOCID_STR, (Bson)new Document(PREFIX_DOLLAR_LAST, (Object)"$_id")), new BsonField(LASTMODIFIEDTIME_STR, (Bson)new Document(PREFIX_DOLLAR_LAST, (Object)PREFIX_DOLLAR_LASTMODIFIEDTIME))}));
        pipeline.add(Aggregates.sort((Bson)Sorts.descending((String[])new String[]{LASTMODIFIEDTIME_STR})));
        pipeline.add(Aggregates.project((Bson)new Document().append("_id", (Object)0).append("_id", (Object)PREFIX_DOLLAR_DOCID).append(CONSOLIDATEDIMAGE_STR, (Object)"$_id").append(LASTMODIFIEDTIME_STR, (Object)PREFIX_DOLLAR_LASTMODIFIEDTIME)));
        AggregateIterable documents = collection.aggregate(pipeline);
        ArrayList<ObjectId> listOfRevisionIds = new ArrayList<ObjectId>();
        for (Document next : documents) {
            Object revisionId = next.get((Object)"_id");
            listOfRevisionIds.add(new ObjectId(revisionId.toString()));
        }
        List<FileRevision> revisionList = this.getAllLatestRevision((MongoOperations)mongoTemplate, listOfRevisionIds);
        this.logger.debug(" SIZE OF NEW LIST " + revisionList.size());
        return revisionList;
    }

    private List<FileRevision> getAllLatestRevision(MongoOperations mongoTemplate, List<ObjectId> revisionIds) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(revisionIds)});
        Query query = new Query((CriteriaDefinition)criteria);
        return mongoTemplate.find(query, FileRevision.class);
    }

    @Override
    public List<FileRevision> getAllRevisionsImagesByPathAndStatus(int cloudId, String cloudName, String path, long timestamp, String status) {
        Criteria criteria = new Criteria();
        Criteria pathLikeCriteria = Criteria.where((String)"devicePath").regex(path);
        criteria.andOperator(new Criteria[]{pathLikeCriteria, Criteria.where((String)"status").is((Object)status), Criteria.where((String)LASTMODIFIEDTIME_STR).gt((Object)timestamp)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIEDTIME_STR}));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, FileRevision.class);
    }

    @Override
    public List<FileRevision> getAllRevisionsImagesByPathAndStatusForMC(int cloudId, String cloudName, String path, long timestamp, String status) {
        Criteria criteria = new Criteria();
        Criteria pathLikeCriteria = Criteria.where((String)"devicePath").regex(path);
        criteria.andOperator(new Criteria[]{pathLikeCriteria, Criteria.where((String)"status").is((Object)status), Criteria.where((String)LASTMODIFIEDTIME_STR).gt((Object)timestamp)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIEDTIME_STR}));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, FileRevision.class);
        ArrayList<FileRevision> minicloudList = new ArrayList<FileRevision>();
        for (FileRevision revision : list) {
            if (!revision.getConsolidatedImage().isMiniCloud()) continue;
            minicloudList.add(revision);
        }
        return minicloudList;
    }

    @Override
    public List<FileRevision> getAllRevisionsImagesByPath(int cloudId, String cloudName, String path, long timestamp) {
        Criteria criteria = new Criteria();
        Criteria pathLikeCriteria = Criteria.where((String)"devicePath").regex(path);
        criteria.andOperator(new Criteria[]{pathLikeCriteria, Criteria.where((String)LASTMODIFIEDTIME_STR).gt((Object)timestamp)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIEDTIME_STR}));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, FileRevision.class);
    }

    @Override
    public Long getCountOfAllFileRevisionsHavingStatus(int cloudId, String cloudName, String status) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Bson matchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)"status", (Object)status)});
        MongoCollection collection = mongoTemplate.getCollection(REVISIONS_STR);
        ArrayList<Bson> pipeline = new ArrayList<Bson>(4);
        pipeline.add(Aggregates.match((Bson)matchQuery));
        pipeline.add(Aggregates.group((Object)new Document().append("_id", (Object)PREFIX_DOLLAR_CONSOLIDATEDIMAGE), (BsonField[])new BsonField[]{new BsonField(DOCID_STR, (Bson)new Document(PREFIX_DOLLAR_LAST, (Object)"$_id")), new BsonField(LASTMODIFIEDTIME_STR, (Bson)new Document(PREFIX_DOLLAR_LAST, (Object)PREFIX_DOLLAR_LASTMODIFIEDTIME))}));
        pipeline.add(Aggregates.sort((Bson)Sorts.descending((String[])new String[]{LASTMODIFIEDTIME_STR})));
        pipeline.add(Aggregates.project((Bson)new Document().append("_id", (Object)0).append("_id", (Object)PREFIX_DOLLAR_DOCID).append(CONSOLIDATEDIMAGE_STR, (Object)"$_id").append(LASTMODIFIEDTIME_STR, (Object)PREFIX_DOLLAR_LASTMODIFIEDTIME)));
        AggregateIterable documents = collection.aggregate(pipeline);
        ArrayList<ObjectId> listOfRevisionIds = new ArrayList<ObjectId>();
        for (Document next : documents) {
            Object revisionId = next.get((Object)"_id");
            listOfRevisionIds.add(new ObjectId(revisionId.toString()));
        }
        List<FileRevision> revisionList = this.getAllLatestRevision((MongoOperations)mongoTemplate, listOfRevisionIds);
        if (revisionList != null) {
            int size = revisionList.size();
            return size;
        }
        return 0L;
    }

    @Override
    public List<ObjectId> getLatestFileRevisionConsolidatedIds(int cloudId, String cloudName, String status, int offset, int rows) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Bson matchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)"status", (Object)status)});
        MongoCollection collection = mongoTemplate.getCollection(REVISIONS_STR);
        ArrayList<Bson> pipeline = new ArrayList<Bson>(4);
        pipeline.add(Aggregates.match((Bson)matchQuery));
        pipeline.add(Aggregates.group((Object)new Document().append("_id", (Object)PREFIX_DOLLAR_CONSOLIDATEDIMAGE), (BsonField[])new BsonField[]{new BsonField(DOCID_STR, (Bson)new Document(PREFIX_DOLLAR_LAST, (Object)"$_id")), new BsonField(LASTMODIFIEDTIME_STR, (Bson)new Document(PREFIX_DOLLAR_LAST, (Object)PREFIX_DOLLAR_LASTMODIFIEDTIME))}));
        pipeline.add(Aggregates.sort((Bson)Sorts.descending((String[])new String[]{LASTMODIFIEDTIME_STR})));
        pipeline.add(Aggregates.project((Bson)new Document().append("_id", (Object)0).append("_id", (Object)PREFIX_DOLLAR_DOCID).append(CONSOLIDATEDIMAGE_STR, (Object)"$_id").append(LASTMODIFIEDTIME_STR, (Object)PREFIX_DOLLAR_LASTMODIFIEDTIME)));
        AggregateIterable documents = collection.aggregate(pipeline);
        ArrayList<ObjectId> listOfConsIds = new ArrayList<ObjectId>();
        for (Document next : documents) {
            DBRef dbRef = (DBRef)next.get((Object)CONSOLIDATEDIMAGE_STR);
            listOfConsIds.add(new ObjectId(dbRef.getId().toString()));
        }
        return listOfConsIds;
    }

    @Override
    public List<FileRevision> getAllFileRevisionsForIds(int cloudId, String cloudName, List<ObjectId> consoIds) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).in(consoIds)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LASTMODIFIEDTIME_STR}));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, FileRevision.class);
    }

    @Override
    public List<FileRevision> getAllLatestFileRevisionsImagesByIndexes(int cloudId, String cloudName, String status, long timestamp, int offset, int rows) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Bson matchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)"status", (Object)status), Filters.eq((String)LASTMODIFIEDTIME_STR, (Object)new Document("$gt", (Object)timestamp))});
        MongoCollection collection = mongoTemplate.getCollection(REVISIONS_STR);
        ArrayList<Bson> pipeline = new ArrayList<Bson>(4);
        pipeline.add(Aggregates.match((Bson)matchQuery));
        pipeline.add(Aggregates.group((Object)new Document().append("_id", (Object)PREFIX_DOLLAR_CONSOLIDATEDIMAGE), (BsonField[])new BsonField[]{new BsonField(DOCID_STR, (Bson)new Document(PREFIX_DOLLAR_LAST, (Object)"$_id")), new BsonField(LASTMODIFIEDTIME_STR, (Bson)new Document(PREFIX_DOLLAR_LAST, (Object)PREFIX_DOLLAR_LASTMODIFIEDTIME))}));
        pipeline.add(Aggregates.sort((Bson)Sorts.descending((String[])new String[]{LASTMODIFIEDTIME_STR})));
        pipeline.add(Aggregates.project((Bson)new Document().append("_id", (Object)0).append("_id", (Object)PREFIX_DOLLAR_DOCID).append(CONSOLIDATEDIMAGE_STR, (Object)"$_id").append(LASTMODIFIEDTIME_STR, (Object)PREFIX_DOLLAR_LASTMODIFIEDTIME)));
        AggregateIterable documents = collection.aggregate(pipeline);
        ArrayList<ObjectId> listOfRevisionIds = new ArrayList<ObjectId>();
        for (Document next : documents) {
            Object revisionId = next.get((Object)"_id");
            listOfRevisionIds.add(new ObjectId(revisionId.toString()));
        }
        return this.getAllLatestRevision((MongoOperations)mongoTemplate, listOfRevisionIds);
    }

    @Override
    public List<FileRevision> getAllLatestFileRevisionsImagesByIndexesForUser(int cloudId, String cloudName, String status, long timestamp, int offset, int rows, String userName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Bson matchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)"status", (Object)status), Filters.eq((String)"userName", (Object)userName), Filters.eq((String)LASTMODIFIEDTIME_STR, (Object)new Document("$gt", (Object)timestamp))});
        MongoCollection collection = mongoTemplate.getCollection(REVISIONS_STR);
        ArrayList<Bson> pipeline = new ArrayList<Bson>(4);
        pipeline.add(Aggregates.match((Bson)matchQuery));
        pipeline.add(Aggregates.group((Object)new Document().append("_id", (Object)PREFIX_DOLLAR_CONSOLIDATEDIMAGE), (BsonField[])new BsonField[]{new BsonField(DOCID_STR, (Bson)new Document(PREFIX_DOLLAR_LAST, (Object)"$_id")), new BsonField(LASTMODIFIEDTIME_STR, (Bson)new Document(PREFIX_DOLLAR_LAST, (Object)PREFIX_DOLLAR_LASTMODIFIEDTIME))}));
        pipeline.add(Aggregates.sort((Bson)Sorts.descending((String[])new String[]{LASTMODIFIEDTIME_STR})));
        pipeline.add(Aggregates.project((Bson)new Document().append("_id", (Object)0).append("_id", (Object)PREFIX_DOLLAR_DOCID).append(CONSOLIDATEDIMAGE_STR, (Object)"$_id").append(LASTMODIFIEDTIME_STR, (Object)PREFIX_DOLLAR_LASTMODIFIEDTIME)));
        AggregateIterable documents = collection.aggregate(pipeline);
        ArrayList<ObjectId> listOfRevisionIds = new ArrayList<ObjectId>();
        for (Document next : documents) {
            Object revisionId = next.get((Object)"_id");
            listOfRevisionIds.add(new ObjectId(revisionId.toString()));
        }
        return this.getAllLatestRevision((MongoOperations)mongoTemplate, listOfRevisionIds);
    }

    @Override
    public Double getTotalSumOfFileSize(int cloudId, String cloudName) {
        Criteria criteria = Criteria.where((String)"status").ne((Object)"DELETED");
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        long count = mongoTemplate.count(query, FileRevision.class);
        return new Double(count);
    }

    @Override
    public List<String> getRevisionsAccordingToFilePath(int cloudId, String cloudName, List<String> fsPaths, long timestamp) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Bson matchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)FSPATH_STR, (Object)new Document("$in", fsPaths)), Filters.eq((String)LASTMODIFIEDTIME_STR, (Object)new Document("$gt", (Object)timestamp))});
        ArrayList<Bson> pipeline = new ArrayList<Bson>(4);
        pipeline.add(Aggregates.match((Bson)matchQuery));
        pipeline.add(Aggregates.group((Object)new Document().append("_id", (Object)"$fSPath"), (BsonField[])new BsonField[0]));
        pipeline.add(Aggregates.sort((Bson)Sorts.descending((String[])new String[]{"lastServerModifiedTime"})));
        pipeline.add(Aggregates.project((Bson)new Document().append("_id", (Object)0).append(FSPATH_STR, (Object)"$fSPath")));
        return this.getFSPAths((MongoOperations)mongoTemplate, pipeline);
    }

    private List<String> getFSPAths(MongoOperations mongoTemplate, List<Bson> pipeline) {
        MongoCollection collection = mongoTemplate.getCollection(REVISIONS_STR);
        ArrayList<String> listOfBackupIds = new ArrayList<String>();
        try {
            AggregateIterable aggregate = collection.aggregate(pipeline);
            for (Document obj : aggregate) {
                this.logger.debug(obj.get((Object)FSPATH_STR) + " ##### " + obj);
                Object object = obj.get((Object)FSPATH_STR);
                if (object == null) continue;
                listOfBackupIds.add(object.toString());
            }
        }
        catch (Exception e) {
            this.logger.trace(" Exception  :" + e);
            this.logger.error(" Exception  :" + e.getMessage());
        }
        return listOfBackupIds;
    }

    @Override
    public List<String> getRevisionsAccordingToFilePath(int cloudId, String cloudName, List<String> fsPaths, List<ObjectId> revisionIds) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Bson matchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)FSPATH_STR, (Object)new Document("$in", fsPaths)), Filters.eq((String)"id", (Object)new BasicDBObject("$nin", revisionIds))});
        ArrayList<Bson> pipeline = new ArrayList<Bson>(4);
        pipeline.add(Aggregates.match((Bson)matchQuery));
        pipeline.add(Aggregates.group((Object)new Document().append("_id", (Object)"$fSPath"), (BsonField[])new BsonField[0]));
        pipeline.add(Aggregates.sort((Bson)Sorts.descending((String[])new String[]{"lastServerModifiedTime"})));
        pipeline.add(Aggregates.project((Bson)new Document().append("_id", (Object)0).append(FSPATH_STR, (Object)1)));
        return this.getFSPAths((MongoOperations)mongoTemplate, pipeline);
    }

    @Override
    public List<FileRevision> getAllRevisionsAccordingToFilePath(int cloudId, String cloudName, String path) {
        List<FileRevision> revisionList = new ArrayList<FileRevision>();
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)"devicePath").regex("^" + path, "i"), Criteria.where((String)"devicePath").is((Object)path)});
        this.logger.debug(" OR  CRITERIA****************** ");
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, ConsolidatedImage.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            ArrayList<ObjectId> consIds = new ArrayList<ObjectId>();
            for (ConsolidatedImage image : list) {
                consIds.add(image.getId());
            }
            if (!CollectionUtils.isEmpty(consIds)) {
                criteria = new Criteria();
                criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).in(consIds)});
                query = new Query((CriteriaDefinition)criteria);
                revisionList = mongoTemplate.find(query, FileRevision.class);
            }
        }
        return revisionList;
    }

    @Override
    public void deleteRevision(int cloudId, String cloudName, FileRevision fileRevision) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)fileRevision.getId())});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAndRemove(query, BackUpImage.class);
        mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove((Object)fileRevision);
    }

    @Override
    public FileRevision getPresentRevisionByRevisionNumber(int cloudId, String cloudName, ObjectId consolidateImageId, int revisionNumber) {
        String status = "DELETED";
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).is((Object)consolidateImageId), Criteria.where((String)"status").ne((Object)status)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LASTMODIFIEDTIME_STR}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (FileRevision)mongoTemplate.findOne(query, FileRevision.class);
    }

    @Override
    public FileRevision getFirstOldRevisionByRevisionNumber(int cloudId, ObjectId consolidateImageId, int revisionNumber) {
        String status = "DELETED";
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).is((Object)consolidateImageId), Criteria.where((String)"status").ne((Object)status)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.ASC, new String[]{LASTMODIFIEDTIME_STR}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (FileRevision)mongoTemplate.findOne(query, FileRevision.class);
    }

    @Override
    public List<FileRevision> getAllRevisions(int cloudId, String cloudName, ObjectId consolidateImageId, int noOfRevisions) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).is((Object)consolidateImageId)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LASTMODIFIEDTIME_STR}));
        if (noOfRevisions != -1) {
            query.limit(noOfRevisions);
        }
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, FileRevision.class);
    }

    @Override
    public FileRevision getRevision(int cloudId, String cloudName, String revisionId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)revisionId)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LASTMODIFIEDTIME_STR}));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (FileRevision)mongoTemplate.findOne(query, FileRevision.class);
    }

    @Override
    public void updateExternalStorageStatusOfFile(int cloudId, String cloudName, ObjectId syncRevisionId, String storagePlace) {
        Query query;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        FileRevision fileRevision = (FileRevision)mongoTemplate.findOne(query = this.criteriaForRevision(syncRevisionId), FileRevision.class);
        if (fileRevision != null && fileRevision.getConsolidatedImage() != null) {
            ConsolidatedImage consolidatedImage = fileRevision.getConsolidatedImage();
            this.updateRevision(storagePlace, mongoTemplate, query);
            query = this.criteriaForRevision(consolidatedImage.getId());
        }
    }

    private void updateRevision(String storagePlace, MongoTemplate mongoTemplate, Query query) {
        Update update = new Update();
        update.set("storagePlace", (Object)storagePlace);
        mongoTemplate.updateFirst(query, update, FileRevision.class);
    }

    private void updateConsolidatedImage(MongoTemplate mongoTemplate, Query query) {
        Update update = new Update();
        update.set("crawlStartTimestamp", (Object)System.currentTimeMillis());
        mongoTemplate.updateFirst(query, update, ConsolidatedImage.class);
    }

    private Query criteriaForRevision(ObjectId syncRevisionId) {
        Criteria criteria = Criteria.where((String)"id").is((Object)syncRevisionId);
        return new Query((CriteriaDefinition)criteria);
    }

    @Override
    public FileRevision getLatestRevisionForDownload(int cloudId, String cloudName, ObjectId consolidateImageId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).is((Object)consolidateImageId)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LASTMODIFIEDTIME_STR}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (FileRevision)mongoTemplate.findOne(query, FileRevision.class);
    }

    @Override
    public List<FileRevision> getLatestMCByRevisionsByConsoIds(int cloudId, String cloudName, List<ObjectId> consoIdList, String userName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Document query = new Document("userName", (Object)new Document("$ne", (Object)userName));
        return this.getResultsForQuery(mongoTemplate, consoIdList, (Bson)query);
    }

    @Override
    public void deleteAllRevisionsAccordingToFilePath(int cloudId, String path) {
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)"devicePath").regex("^" + path + "$", "i"), Criteria.where((String)"devicePath").is((Object)path)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, ConsolidatedImage.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            ArrayList<ObjectId> consIds = new ArrayList<ObjectId>();
            for (ConsolidatedImage image : list) {
                consIds.add(image.getId());
            }
            if (!CollectionUtils.isEmpty(consIds)) {
                criteria = new Criteria();
                criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).in(consIds)});
                query = new Query((CriteriaDefinition)criteria);
                mongoTemplate.findAndRemove(query, FileRevision.class);
            }
        }
        for (ConsolidatedImage consolidatedImage : list) {
            mongoTemplate.remove((Object)consolidatedImage);
        }
    }

    @Override
    public boolean isFilesInBlukrypt(int cloudId, String userName, String path, String fileName) {
        Criteria criteria = new Criteria();
        Criteria andCriteria = new Criteria();
        Criteria folderFalseCriteria = Criteria.where((String)"folder").is((Object)false);
        if (!StringUtils.isEmpty((String)fileName)) {
            this.logger.debug("File name>>>>>>>>>>>" + fileName + "File Path>>>>>>" + path);
            criteria.andOperator(new Criteria[]{Criteria.where((String)"devicePath").is((Object)path), Criteria.where((String)"fileName").is((Object)fileName)});
        } else {
            this.logger.debug(" NO Filename ........... ");
            criteria.orOperator(new Criteria[]{Criteria.where((String)"devicePath").regex("^" + path + "/", "i"), Criteria.where((String)"devicePath").is((Object)path)});
        }
        if (!StringUtils.isEmpty((String)userName)) {
            andCriteria.andOperator(new Criteria[]{folderFalseCriteria, criteria, Criteria.where((String)"userName").regex("^" + userName + "$", "i")});
        } else {
            andCriteria.andOperator(new Criteria[]{folderFalseCriteria, criteria});
        }
        Query query = new Query((CriteriaDefinition)andCriteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, ConsolidatedImage.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            ArrayList<ObjectId> consIds = new ArrayList<ObjectId>();
            for (ConsolidatedImage image : list) {
                consIds.add(image.getId());
            }
            if (!CollectionUtils.isEmpty(consIds)) {
                criteria = new Criteria();
                criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).in(consIds), Criteria.where((String)"storagePlace").exists(false), folderFalseCriteria, Criteria.where((String)"status").ne((Object)"DELETED")});
                query = new Query((CriteriaDefinition)criteria);
                long count = mongoTemplate.count(query, FileRevision.class);
                if (count > 0L) {
                    this.logger.debug(" Files in Blukrypt........." + count);
                    this.logger.debug(path + " Files in Blukrypt........." + userName);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public long getCountOfVersionsForFile(int cloudId, ObjectId consId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).is((Object)consId), Criteria.where((String)"status").ne((Object)"DELETED")});
        Query query = new Query((CriteriaDefinition)criteria);
        return mongoTemplate.count(query, FileRevision.class);
    }

    @Override
    public List<FileRevision> getAllFilesTobeDeleted(int cloudId, long filesExpiredDate) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)LASTMODIFIEDTIME_STR).lt((Object)filesExpiredDate)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(200);
        this.logger.debug(" limit 200 files........." + filesExpiredDate);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, FileRevision.class);
    }

    @Override
    public void saveSyncOverview(int cloudId, SyncOverView syncOverview) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)syncOverview);
    }

    @Override
    public SyncOverView getSyncOverview(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List syncOverViewList = mongoTemplate.findAll(SyncOverView.class);
        if (!CollectionUtils.isEmpty((Collection)syncOverViewList)) {
            return (SyncOverView)syncOverViewList.get(0);
        }
        return null;
    }

    @Override
    public void saveDailySyncOverview(int cloudId, DailySyncOverView dailySyncOverView) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)dailySyncOverView);
    }

    @Override
    public DailySyncOverView getDailySyncOverview(int cloudId, long currentMillisSeconds) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"overViewDate").is((Object)currentMillisSeconds)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (DailySyncOverView)mongoTemplate.findOne(query, DailySyncOverView.class);
    }

    @Override
    public void deleteRevision(int cloudId, String syncRevisionId, String consId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).is((Object)new ObjectId(consId))});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List fileRevisions = mongoTemplate.find(query, FileRevision.class);
        criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)new ObjectId(syncRevisionId))});
        query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.findAndRemove(query, FileRevision.class);
        if (fileRevisions != null && fileRevisions.size() <= 1) {
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)new ObjectId(consId))});
            query = new Query((CriteriaDefinition)criteria);
            mongoTemplate.remove(query, ConsolidatedImage.class);
        }
    }

    @Override
    public List<FileRevision> getAllSyncFilesToBeDeletedByUserName(int cloudId, long filesExpiredDate, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)LASTMODIFIEDTIME_STR).lt((Object)filesExpiredDate), Criteria.where((String)"userName").is((Object)userName), Criteria.where((String)"folder").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(200);
        this.logger.debug(" limit 200 files........." + filesExpiredDate);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, FileRevision.class);
    }

    @Override
    public FileRevision getFileRevisionById(int cloudId, ObjectId syncRevisionId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = this.criteriaForRevision(syncRevisionId);
        return (FileRevision)mongoTemplate.findOne(query, FileRevision.class);
    }
}

