/*
 * Decompiled with CFR 0.152.
 */
package com.pg.sync.service.impl;

import com.google.api.client.repackaged.org.apache.commons.codec.binary.Base64;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.microsoft.aad.adal4j.AuthenticationCallback;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.Contact;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.parablu.pcbd.dao.EncryptionKeyDao;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.dao.SyncBackUpImageDAO;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupFile;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.ConsolidatedImage;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.EWSAppSetting;
import com.parablu.pcbd.domain.EncryptionKey;
import com.parablu.pcbd.domain.MailAttachment;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.SyncPolicy;
import com.pg.controller.Graph;
import com.pg.dao.FileDao;
import com.pg.dao.Office365Dao;
import com.pg.dao.SyncFileDao;
import com.pg.domain.FileInfo;
import com.pg.element.FileElement;
import com.pg.element.FileStatusElement;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.element.RestoreElement;
import com.pg.encryption.service.FileEncryptionService;
import com.pg.exception.BlukryptClientAbortException;
import com.pg.exception.ParacloudBackupException;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.odb.util.OneDriveUtil;
import com.pg.paracloud.to.DownloadFileTO;
import com.pg.paracloud.to.DownloadTO;
import com.pg.service.CloudSupportService;
import com.pg.service.DownloadService;
import com.pg.service.UtilService;
import com.pg.sync.service.SyncDownloadService;
import com.pg.util.ResourceFileHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ConnectingIdType;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.Importance;
import microsoft.exchange.webservices.data.core.enumeration.property.MapiPropertyType;
import microsoft.exchange.webservices.data.core.enumeration.property.Sensitivity;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceResponseException;
import microsoft.exchange.webservices.data.core.service.item.EmailMessage;
import microsoft.exchange.webservices.data.core.service.item.Task;
import microsoft.exchange.webservices.data.misc.ImpersonatedUserId;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.ItemId;
import microsoft.exchange.webservices.data.property.complex.Mailbox;
import microsoft.exchange.webservices.data.property.complex.MimeContent;
import microsoft.exchange.webservices.data.property.definition.ExtendedPropertyDefinition;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.zeroturnaround.zip.ZipUtil;

@Service
public class SyncDownloadServiceImpl
implements SyncDownloadService {
    private static Logger logger = LogManager.getLogger(SyncDownloadServiceImpl.class);
    @Autowired
    private FileDao fileDao;
    private static final String MERGE = "merge";
    private static final String DECRYPTED = "decrypted";
    private static final String TEMP_DOWNLOAD_SYNC = "tempdownloadsync";
    private static final String ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH = "ERROR Trying to download from orginal source path ..... ";
    private static final String AZURE_DOWNLOAD_ERROR = "Azure download error";
    private static final String CHUNK = "chunk";
    private static final String SENDING_FILE = "Sending file ";
    private static final String FINISHED_FILE = "Finished file ";
    private static final String EXCEPTION_WHILE_DOWNLOADING_FILE_FROM_CLOUD = "Exception While Downloading File From Cloud :";
    private static final String IS_COMPRESSED = "$$$$$ isCompressed>>>>";
    private static final String BACKUP = "backup";
    private static final String PRODUCT_TYPE_SYNC = "sync";
    private static final String CHUNK_DETAILS_NULL = "Chunk detail is null>>>>>>>>";
    private static final String CLOUD_CHUNK_NAME = "CLOUD CHUNK NAME>>>>>>>>>";
    private static final String LOOP_BEFORE_DOWNLOAD_FILE = "for loop  BEFORE DOWNLOADING Chunks file  >>>>>> ";
    private static final String SYNC_DECRYPT_KEY = "d8e87c0927539672f54462c837be0b7f";
    private static final String RESOURCE = "https://outlook.office365.com";
    private static final String AUTHORITY = "https://login.microsoftonline.com/";
    private static final String EWS_URL = "https://outlook.office365.com/EWS/Exchange.asmx";
    private static final String FILEPATH = "filePath";
    private static final String BACKUP_ID = "backupId";
    private static final String CLOUD_NAME = "cloudName";
    private static final String PARAMETERS = "parameters";
    private static final String PREFIX_HTTPS = "https://";
    private static final String PREFIX_HTTP = "http://";
    private static final String BLUKRYPT_BUILDER_DOWNLOAD_FROM_PG = "/BluKryptBuilder/download/frompg/";
    private static final String FILE_NAME = "fileName:";
    private static final String FILE_PATH = "filePath:";
    private static final String UTF8 = "UTF-8";
    private static final String COPY = "-copy";
    @Autowired
    private SyncFileDao syncFileDao;
    @Autowired
    private Office365Dao office365Dao;
    @Autowired
    private ExternalStorageBackupFileDao externalStorageBackupFileDao;
    @Autowired
    private FileEncryptionService fileEncryptionService;
    @Autowired
    private CloudSupportService cloudSupportService;
    @Autowired
    private UtilService utilService;
    @Autowired
    private EncryptionKeyDao encryptionKeyDao;
    @Autowired
    private DownloadService downloadService;
    @Autowired
    private UserDao userDao;
    @Autowired
    private SyncBackUpImageDAO syncBackUpImageDAO;

    public void setDownloadService(DownloadService downloadService) {
        this.downloadService = downloadService;
    }

    public void setFileDao(FileDao fileDao) {
        this.fileDao = fileDao;
    }

    public void setSyncFileDao(SyncFileDao syncFileDao) {
        this.syncFileDao = syncFileDao;
    }

    public void setOffice365Dao(Office365Dao office365Dao) {
        this.office365Dao = office365Dao;
    }

    public void setFileEncryptionService(FileEncryptionService fileEncryptionService) {
        this.fileEncryptionService = fileEncryptionService;
    }

    public void setExternalStorageBackupFileDao(ExternalStorageBackupFileDao externalStorageBackupFileDao) {
        this.externalStorageBackupFileDao = externalStorageBackupFileDao;
    }

    public void setCloudSupportService(CloudSupportService cloudSupportService) {
        this.cloudSupportService = cloudSupportService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public void setEncryptionKeyDao(EncryptionKeyDao encryptionKeyDao) {
        this.encryptionKeyDao = encryptionKeyDao;
    }

    @Override
    public DownloadTO restoreFile(Cloud cloud, String cloudName, String userName, String fileName1, String folderPath, String saltKey, String deviceUUID, String syncRevisionId, String gatewayName, boolean isExternalDownload, boolean isSync) {
        logger.debug(" @@@@@ Folder path for external Storage " + folderPath);
        com.pg.domain.BackupFile backupFile = this.utilService.getSyncFile(1, cloudName, userName, syncRevisionId);
        logger.error(syncRevisionId + " BACKUPFILE FOR MUTILSERVICE ............" + backupFile);
        if (backupFile == null) {
            logger.debug(" @@@@@ FILE NOT FOUND .... " + syncRevisionId);
            throw new ParacloudBackupException("File not found", 507);
        }
        if (!StringUtils.isEmpty((String)backupFile.getDedupBackupId())) {
            backupFile = this.utilService.getSyncFile(1, cloudName, userName, backupFile.getDedupBackupId());
        }
        String fileMD5 = backupFile.getMd5();
        ArrayList<String> nameList = new ArrayList<String>();
        logger.debug(" BEFORE DOWNLOADING File  >>>>>> " + backupFile.getFileName());
        this.downloadFileFromCloud(cloud, cloudName, userName, backupFile, nameList, saltKey, isSync);
        logger.debug(" After DOWNLOADING File  >>>>>> " + backupFile.getFileName());
        String path = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + backupFile.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        String destPath = path + MERGE;
        String destFile = destPath + "/" + backupFile.getFileName();
        File destFolder = new File(destPath);
        if (destFolder.exists()) {
            ResourceFileHelper.deleteAllChildFilesExcludingDirectories((File)destFolder);
        }
        com.pg.util.FileUtils.merge(nameList, (String)(path + DECRYPTED), (String)destFile);
        InputStream decryptedStream = null;
        String mimeType = "application/octet-stream";
        logger.debug(isExternalDownload + " Mimetype for file1 ............" + mimeType);
        long fileSize = backupFile.getSize();
        long fileSize1 = destFile.length();
        logger.debug(backupFile.getSize() + " size of file .merged..... " + fileSize1);
        mimeType = "application/octet-stream";
        DownloadTO downloadTO = new DownloadTO(mimeType, decryptedStream, fileSize, fileMD5);
        downloadTO.setPath(destFile);
        downloadTO.setMd5(fileMD5);
        ArrayList<Object> downloadReturnList = new ArrayList<Object>();
        downloadReturnList.add(decryptedStream);
        downloadReturnList.add(mimeType);
        downloadReturnList.add(String.valueOf(fileSize));
        downloadReturnList.add(fileMD5);
        logger.debug(" Mimetype for file ............" + mimeType);
        return downloadTO;
    }

    private void downloadFileFromCloud(Cloud cloud, String cloudName, String userName, com.pg.domain.BackupFile backupFile, List<String> nameList, String saltKeys, boolean isSync) {
        BufferedInputStream inputStream = null;
        GraphServiceClient<Request> graphClient = null;
        OkHttpClient okHttpClient = null;
        boolean isODBEnabled = this.isODBEnabled(cloud.getCloudCustomisableDetails());
        if (isODBEnabled && cloud.getGraphApiEnabled() == 1) {
            graphClient = OneDriveUtil.getGraphClient();
            okHttpClient = Graph.getInstance().getOkHttpClient();
        }
        if (StringUtils.isEmpty((String)PCHelperConstant.getPropertyFileValueEncryptionEnabled()) || !"true".equals(PCHelperConstant.getPropertyFileValueEncryptionEnabled())) {
            try {
                String path = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + backupFile.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
                File tempdownloadDir = new File(path + TEMP_DOWNLOAD_SYNC);
                if (!tempdownloadDir.exists()) {
                    tempdownloadDir.mkdirs();
                }
                String fileNameToDownload = backupFile.getFileName();
                logger.debug(" BEFORE DOWNLOADING file without encrypt file  >>>>>> " + fileNameToDownload);
                com.pg.domain.ChunkFile chunkFile = (com.pg.domain.ChunkFile)backupFile.getChunkFiles().get(0);
                FileStatusElement fileStatusElement = new FileStatusElement();
                boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
                String fileToDownload = fileNameToDownload;
                if (isGDEnabled) {
                    fileToDownload = chunkFile.getFileId();
                }
                inputStream = this.cloudSupportService.downloadFile(cloud, tempdownloadDir.getPath(), fileToDownload, userName, backupFile.getDeviceUUID(), null, chunkFile, true, backupFile, fileStatusElement, "", null, "", graphClient, okHttpClient);
                logger.debug("File Download from Cloud..........." + inputStream);
                this.convertIntoFile(inputStream, cloudName, backupFile.getDeviceUUID(), backupFile.getFileName());
            }
            catch (Exception e) {
                logger.trace("" + e);
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e1) {
                    logger.trace("" + e1);
                    logger.error("Exception while downloading files from cloud :" + e1.getMessage());
                }
                logger.error(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                throw new ParacloudBackupException("Cloud download error", 507);
            }
            nameList.add(backupFile.getFileName());
            return;
        }
        String path = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + backupFile.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File tempdownloadDir = new File(path + TEMP_DOWNLOAD_SYNC);
        if (!tempdownloadDir.exists()) {
            tempdownloadDir.mkdirs();
        }
        boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
        for (com.pg.domain.ChunkFile chunkFile : backupFile.getChunkFiles()) {
            String syncDecryptKey = SYNC_DECRYPT_KEY;
            String productType = isSync ? PRODUCT_TYPE_SYNC : BACKUP;
            try {
                StringBuilder fileNameToDownload;
                int occurance;
                String dedupVal = this.getDedupValue(userName, isSync);
                ChunkDetail chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, chunkFile.getMd5(), dedupVal, userName, false, false);
                if (chunkDetail == null) {
                    logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                    chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, chunkFile.getMd5(), dedupVal, userName, false, true);
                }
                if (chunkDetail == null) {
                    logger.debug(CHUNK_DETAILS_NULL);
                    chunkDetail = new ChunkDetail();
                    chunkDetail.setCloudChunkName(chunkFile.getFileName());
                    if (isGDEnabled && !StringUtils.isEmpty((String)chunkFile.getFileId())) {
                        chunkDetail.setCloudChunkName(chunkFile.getFileId());
                    }
                }
                logger.debug(backupFile.getDedupBackupId() + CLOUD_CHUNK_NAME + chunkDetail.getCloudChunkName());
                String backupId = backupFile.getBackupId().toString();
                if (!StringUtils.isEmpty((String)backupFile.getDedupBackupId())) {
                    backupId = backupFile.getDedupBackupId();
                }
                if ((occurance = StringUtils.countMatches((String)(fileNameToDownload = new StringBuilder(chunkDetail.getCloudChunkName())).toString(), (String)".")) == 0 || occurance == 1 && backupFile.getChunkFiles().size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                    fileNameToDownload.append("." + backupId);
                }
                String containerName = null;
                if (chunkDetail != null) {
                    containerName = chunkDetail.getContainerName();
                    if (!StringUtils.isEmpty((String)chunkDetail.getCloudStoragePath())) {
                        chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                    }
                    syncDecryptKey = chunkDetail.getUserName();
                }
                logger.debug(chunkFile.getCloudStoragePath() + LOOP_BEFORE_DOWNLOAD_FILE + fileNameToDownload);
                com.pg.domain.ChunkFile pgChunkFile = new com.pg.domain.ChunkFile();
                BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
                FileStatusElement fileStatusElement = new FileStatusElement();
                String fileToDownload = fileNameToDownload.toString();
                if (isGDEnabled) {
                    fileToDownload = chunkDetail.getCloudChunkName();
                }
                inputStream = this.cloudSupportService.downloadFile(cloud, tempdownloadDir.getPath(), fileToDownload, userName, backupFile.getDeviceUUID(), containerName, pgChunkFile, true, backupFile, fileStatusElement, chunkDetail.getUserName(), chunkDetail, "", graphClient, okHttpClient);
            }
            catch (Exception e) {
                logger.trace("" + e);
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e1) {
                    logger.trace("" + e1);
                    logger.error(EXCEPTION_WHILE_DOWNLOADING_FILE_FROM_CLOUD + e1.getMessage());
                }
                logger.error(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
            }
            String saltKeyTemp = this.getEncryptOrDecryptKey(1, chunkFile.getUploadedTimeStamp(), productType);
            this.getDecryptedFile(cloudName, saltKeyTemp, backupFile.getDeviceUUID(), chunkFile.getFileName(), inputStream, userName, syncDecryptKey);
            nameList.add(chunkFile.getFileName());
        }
    }

    private File getDecryptedFile(String cloudName, String saltKey, String deviceUUID, String fileName, BufferedInputStream inputStream, String userName, String syncUniqueKey) {
        String path = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File decryptedDir = new File(path + DECRYPTED);
        if (!decryptedDir.exists()) {
            decryptedDir.mkdirs();
        }
        this.createFolders(path);
        File decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
        decryptedFile = this.fileEncryptionService.decrypt(saltKey, syncUniqueKey, inputStream, decryptedFile);
        return decryptedFile;
    }

    private File getDecryptedFileFromPath(String cloudName, String saltKey, String deviceUUID, String fileName, BufferedInputStream inputStream, String restorePath, String syncUniqueKey) {
        File decryptedDir;
        String path = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File pathDir = new File(path);
        if (!pathDir.exists()) {
            pathDir.mkdir();
        }
        if (!(decryptedDir = new File(path + DECRYPTED)).exists()) {
            decryptedDir.mkdir();
        }
        this.createFolders(path);
        File decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
        decryptedFile = this.fileEncryptionService.decrypt(saltKey, syncUniqueKey, inputStream, decryptedFile);
        return decryptedFile;
    }

    private void createFolders(String pathname) {
        File mergeDir;
        File decryptedDir = new File(pathname + DECRYPTED);
        if (!decryptedDir.exists()) {
            decryptedDir.mkdir();
        }
        if (!(mergeDir = new File(pathname + MERGE)).exists()) {
            mergeDir.mkdir();
        }
    }

    private void convertIntoFile(BufferedInputStream inputStream, String cloudName, String deviceUUID, String fileName) {
        try {
            int bytesRead;
            String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            File decryptedDir = new File(path + DECRYPTED);
            if (!decryptedDir.exists()) {
                decryptedDir.mkdir();
            }
            this.createFolders(path);
            BufferedInputStream is = inputStream;
            FileOutputStream os = new FileOutputStream(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
            byte[] buffer = new byte[1024];
            while ((bytesRead = ((InputStream)is).read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            ((InputStream)is).close();
            os.flush();
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error("Exception While Converting Into File :" + e.getMessage());
        }
    }

    @Override
    public DownloadTO restoreFileForPortal(Cloud cloud, String cloudName, String userName, String fileName1, String folderPath, String saltKey, String deviceUUID, String syncRevisionId, String gatewayName, boolean isExternalDownload, HttpServletResponse response, String browserType, String fileUser) {
        logger.debug(" @@@@@ Folder path for external Storage " + folderPath);
        String fileUserName = userName;
        if (!StringUtils.isEmpty((String)fileUser)) {
            fileUserName = fileUser;
        }
        BackUpImage backUpImage = this.externalStorageBackupFileDao.getSyncBackUpImageForId(1, syncRevisionId, null, null);
        com.pg.domain.BackupFile backupFile = new com.pg.domain.BackupFile();
        this.convertBackupImageToBackupFile(backUpImage, backupFile);
        FileInfo fileInfo = null;
        DownloadTO downloadTO = new DownloadTO("");
        if (backupFile == null) {
            fileInfo = this.fileDao.getFileFromPG(fileUserName, cloudName, syncRevisionId, true);
            this.restoreFromPG(cloud, response, fileInfo, true, browserType, userName);
        }
        if (fileInfo != null) {
            downloadTO.setSize(fileInfo.getSize().longValue());
            return downloadTO;
        }
        logger.error(syncRevisionId + " BACKUPFILE FOR MUTILSERVICE ............" + backupFile);
        if (backupFile == null) {
            logger.debug(" @@@@@ FILE NOT FOUND .... " + syncRevisionId);
            throw new ParacloudBackupException("File not found", 507);
        }
        String fileName = backupFile.getFileName();
        ArrayList<String> nameList = new ArrayList<String>();
        logger.debug(" BEFORE DOWNLOADING File  >>>>>> " + backupFile.getFileName());
        response.addHeader("Pragma", "public");
        response.addHeader("Expires", String.valueOf(200));
        response.addHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        response.addHeader("Content-Transfer-Encoding", "binary");
        response.addHeader("Content-Length", String.valueOf(backupFile.getSize()));
        response.addHeader("filename", fileName);
        response.addHeader("Content-Transfer-Encodingsdasda", "binary");
        response.setContentType("application/octet-stream");
        boolean fileExists = true;
        fileExists = this.downloadFileFromCloud(cloud, cloudName, backupFile.getUserName(), backupFile, nameList, saltKey, response, fileExists);
        if (!fileExists) {
            nameList = new ArrayList();
            logger.debug(" portal .. try parent file for md5..........");
            com.pg.domain.BackupFile backupFileObj = this.syncFileDao.getSyncFileForMd5(1, cloudName, fileUserName, deviceUUID, backupFile.getMd5());
            if (backupFileObj != null) {
                logger.debug(" portal .. parent file for md5 exists ..........");
                this.downloadFileFromCloud(cloud, cloudName, backupFile.getUserName(), backupFileObj, nameList, saltKey, response, fileExists);
            }
        }
        logger.debug(" After DOWNLOADING File  >>>>>> " + backupFile.getFileName());
        downloadTO.setSize(backupFile.getSize().longValue());
        return downloadTO;
    }

    private boolean downloadFileFromCloud(Cloud cloud, String cloudName, String userName, com.pg.domain.BackupFile backupFile, List<String> nameList, String saltKey, HttpServletResponse response, boolean fileExists) {
        boolean fileExistsTemp = fileExists;
        BufferedInputStream inputStream = null;
        String path = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + backupFile.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File tempdownloadDir = new File(path + TEMP_DOWNLOAD_SYNC);
        if (!tempdownloadDir.exists()) {
            tempdownloadDir.mkdirs();
        }
        List chunkFilesList = backupFile.getChunkFiles();
        int totalChunks = chunkFilesList.size();
        Collections.sort(chunkFilesList, (c1, c2) -> {
            if (c1 == null || c2 == null || c1.getFileName() == null || c2.getFileName() == null) {
                return -1;
            }
            return new CompareToBuilder().append((Object)c1.getFileName().toLowerCase(), (Object)c2.getFileName().toLowerCase()).toComparison();
        });
        GraphServiceClient<Request> graphClient = null;
        OkHttpClient okHttpClient = null;
        boolean isODBEnabled = this.isODBEnabled(cloud.getCloudCustomisableDetails());
        if (isODBEnabled && cloud.getGraphApiEnabled() == 1) {
            graphClient = OneDriveUtil.getGraphClient();
            okHttpClient = Graph.getInstance().getOkHttpClient();
        }
        String dedupVal = this.getDedupValueByUserName(userName);
        for (com.pg.domain.ChunkFile chunkFile : chunkFilesList) {
            String syncDecryptKey = SYNC_DECRYPT_KEY;
            String productType = PRODUCT_TYPE_SYNC;
            try {
                ChunkDetail chunkDetail = null;
                List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, false);
                if (CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                    logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                    chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, true);
                }
                if (!CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                    for (ChunkDetail detailFromDB : chunkDetailList) {
                        if (detailFromDB.getRefCount() <= 0 && detailFromDB.getClientDedupRefCount() <= 0) continue;
                        chunkDetail = detailFromDB;
                    }
                }
                if (chunkDetail == null) {
                    logger.debug(CHUNK_DETAILS_NULL);
                    chunkDetail = new ChunkDetail();
                    chunkDetail.setCloudChunkName(chunkFile.getFileName());
                }
                logger.debug(CLOUD_CHUNK_NAME + chunkDetail.getCloudChunkName());
                String backupId = backupFile.getId();
                StringBuilder fileNameToDownload = new StringBuilder(chunkDetail.getCloudChunkName());
                int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
                if (occurance == 0 || occurance == 1 && chunkFilesList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                    fileNameToDownload.append("." + backupId);
                }
                String containerName = null;
                if (chunkDetail != null) {
                    containerName = chunkDetail.getContainerName();
                    if (!StringUtils.isEmpty((String)chunkDetail.getCloudStoragePath())) {
                        chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                    }
                    syncDecryptKey = chunkDetail.getUserName();
                }
                logger.debug(chunkFile.getCloudStoragePath() + LOOP_BEFORE_DOWNLOAD_FILE + fileNameToDownload);
                com.pg.domain.ChunkFile pgChunkFile = new com.pg.domain.ChunkFile();
                BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
                FileStatusElement fileStatusElement = new FileStatusElement();
                boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
                String fileToDownload = fileNameToDownload.toString();
                if (isGDEnabled) {
                    fileToDownload = chunkDetail.getCloudChunkName();
                }
                if ((inputStream = this.cloudSupportService.downloadFile(cloud, tempdownloadDir.getPath(), fileToDownload, userName, backupFile.getDeviceUUID(), containerName, pgChunkFile, true, backupFile, fileStatusElement, chunkDetail.getUserName(), chunkDetail, "", graphClient, okHttpClient)) == null) {
                    fileExistsTemp = false;
                }
                if (inputStream == null) {
                    break;
                }
            }
            catch (Exception e) {
                logger.trace("" + e);
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e1) {
                    logger.trace("" + e1);
                    logger.error(EXCEPTION_WHILE_DOWNLOADING_FILE_FROM_CLOUD + e1.getMessage());
                }
                logger.error(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
            }
            String saltKeyTemp = this.getEncryptOrDecryptKey(1, chunkFile.getUploadedTimeStamp(), productType);
            File decryptedFile = this.getDecryptedFile(cloudName, saltKeyTemp, backupFile.getDeviceUUID(), chunkFile.getFileName(), inputStream, userName, syncDecryptKey);
            this.writeDataToStream(response, decryptedFile, backupFile);
            nameList.add(chunkFile.getFileName());
            logger.debug(" remaining chunks ......" + --totalChunks);
        }
        return fileExistsTemp;
    }

    private boolean isGDEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isGDEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"Google Drive Enabled".equalsIgnoreCase(license.getName())) continue;
            isGDEnabled = true;
            break;
        }
        return isGDEnabled;
    }

    private boolean downloadFileFromCloud(Cloud cloud, String cloudName, String userName, com.pg.domain.BackupFile backupFile, List<String> nameList, String saltKey, HttpServletResponse response, boolean fileExists, boolean isSyncEnabled) {
        boolean fileExistsTemp = fileExists;
        boolean isSync = isSyncEnabled;
        BufferedInputStream inputStream = null;
        String deviceUUID = backupFile.getDeviceUUID();
        int cloudId = cloud.getCloudId();
        String path = isSync ? PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + TEMP_DOWNLOAD_SYNC : PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File tempdownloadDir = new File(path);
        if (!tempdownloadDir.exists()) {
            tempdownloadDir.mkdirs();
        }
        List chunkFilesList = backupFile.getChunkFiles();
        int totalChunks = chunkFilesList.size();
        Collections.sort(chunkFilesList, new Comparator<com.pg.domain.ChunkFile>(){

            @Override
            public int compare(com.pg.domain.ChunkFile c1, com.pg.domain.ChunkFile c2) {
                if (c1 == null || c2 == null || c1.getFileName() == null || c2.getFileName() == null) {
                    return -1;
                }
                return new CompareToBuilder().append((Object)c1.getFileName().toLowerCase(), (Object)c2.getFileName().toLowerCase()).toComparison();
            }
        });
        GraphServiceClient<Request> graphClient = null;
        OkHttpClient okHttpClient = null;
        boolean isODBEnabled = this.isODBEnabled(cloud.getCloudCustomisableDetails());
        if (isODBEnabled && cloud.getGraphApiEnabled() == 1) {
            graphClient = OneDriveUtil.getGraphClient();
            okHttpClient = Graph.getInstance().getOkHttpClient();
        }
        for (com.pg.domain.ChunkFile chunkFile : chunkFilesList) {
            File decryptedFile;
            String saltKeyTemp;
            String syncDecryptKey = SYNC_DECRYPT_KEY;
            String productType = PRODUCT_TYPE_SYNC;
            FileStatusElement fileStatusElement = new FileStatusElement();
            String dedupVal = this.getDedupValue(userName, isSync);
            logger.debug("..before chunk detail...." + userName + "...." + dedupVal + "...ch..." + chunkFile.getMd5());
            ChunkDetail chunkDetail = null;
            List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, false);
            if (CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, true);
            }
            if (!CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                for (ChunkDetail detailFromDB : chunkDetailList) {
                    if (detailFromDB.getRefCount() <= 0 && detailFromDB.getClientDedupRefCount() <= 0) continue;
                    chunkDetail = detailFromDB;
                }
            }
            try {
                if (chunkDetail == null) {
                    logger.debug(CHUNK_DETAILS_NULL);
                    chunkDetail = new ChunkDetail();
                    chunkDetail.setCloudChunkName(chunkFile.getFileName());
                    chunkDetail.setUserName(userName);
                    chunkDetail.setContainerName(userName.toLowerCase());
                    chunkDetail.setMd5(chunkFile.getMd5());
                }
                logger.debug(CLOUD_CHUNK_NAME + chunkDetail.getCloudChunkName());
                String backupId = backupFile.getId();
                String containerName = null;
                if (!isSync) {
                    containerName = chunkDetail.getContainerName();
                }
                StringBuilder fileNameToDownload = new StringBuilder();
                fileNameToDownload.append(chunkDetail.getCloudChunkName());
                int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
                if (occurance == 0 || occurance == 1 && chunkFilesList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                    fileNameToDownload.append(".").append(backupId);
                }
                if (chunkDetail != null) {
                    containerName = chunkDetail.getContainerName();
                    if (!StringUtils.isEmpty((String)chunkDetail.getCloudStoragePath())) {
                        chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                    }
                    syncDecryptKey = chunkDetail.getUserName();
                }
                com.pg.domain.ChunkFile pgChunkFile = new com.pg.domain.ChunkFile();
                BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
                boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
                String fileToDownload = fileNameToDownload.toString();
                if (isGDEnabled) {
                    fileToDownload = chunkDetail.getCloudChunkName();
                    logger.debug(fileNameToDownload.toString() + "....chunk fileid... " + chunkDetail.getCloudChunkName());
                }
                logger.debug(chunkFile.getCloudStoragePath() + LOOP_BEFORE_DOWNLOAD_FILE + fileToDownload + " ..new");
                inputStream = this.cloudSupportService.downloadFile(cloud, tempdownloadDir.getPath(), fileToDownload, userName, backupFile.getDeviceUUID(), containerName, pgChunkFile, isSync, backupFile, fileStatusElement, chunkDetail.getUserName(), chunkDetail, "", graphClient, okHttpClient);
                if (inputStream == null) {
                    fileExistsTemp = false;
                }
                if (inputStream == null) {
                    break;
                }
            }
            catch (Exception e) {
                logger.trace("" + e);
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e1) {
                    logger.trace("" + e1);
                    logger.error(EXCEPTION_WHILE_DOWNLOADING_FILE_FROM_CLOUD + e1.getMessage());
                }
                logger.error(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
            }
            logger.debug("..isSync Value>>>>>" + isSync);
            if (isSync) {
                saltKeyTemp = this.getEncryptOrDecryptKey(cloud.getCloudId(), chunkFile.getUploadedTimeStamp(), productType);
                logger.debug(chunkFile.getUploadedTimeStamp() + "..." + productType + "...sync key...." + saltKeyTemp);
                decryptedFile = this.getDecryptedFile(cloudName, saltKeyTemp, backupFile.getDeviceUUID(), chunkFile.getFileName(), inputStream, userName, syncDecryptKey);
            } else {
                saltKeyTemp = this.getEncryptOrDecryptKey(cloud.getCloudId(), chunkDetail.getChunkCreatedTime(), BACKUP);
                logger.debug(userName + "...users...." + chunkDetail.getUserName());
                File decryptedDir = this.createDecryptedDirs(path);
                File copyFile = this.copyInputStreamToAFile(chunkFile.getFileName(), inputStream, decryptedDir);
                try {
                    inputStream = new BufferedInputStream(new FileInputStream(copyFile));
                }
                catch (FileNotFoundException e) {
                    logger.trace("" + e);
                    logger.error("exception while reading from ins" + e.getMessage());
                }
                decryptedFile = this.downloadService.getDecryptedFileForPortal(cloudName, saltKeyTemp, deviceUUID, chunkFile.getFileName(), inputStream, chunkDetail.getUserName(), path, chunkFile, cloudId, chunkDetail);
                if (decryptedFile == null) {
                    if (StringUtils.isNotEmpty((String)fileStatusElement.getFileOwner())) {
                        logger.debug("decrypt file is null and file owner is not empty:" + fileStatusElement.getFileOwner());
                        BufferedInputStream in = null;
                        try {
                            in = new BufferedInputStream(new FileInputStream(copyFile));
                        }
                        catch (FileNotFoundException e) {
                            logger.trace("" + e);
                            logger.error("exception while copying from istream:" + e.getMessage());
                        }
                        decryptedFile = this.downloadService.getDecryptedFileForPortal(cloudName, saltKeyTemp, deviceUUID, chunkFile.getFileName(), in, fileStatusElement.getFileOwner(), path, chunkFile, cloudId, chunkDetail);
                    }
                    if (copyFile.exists()) {
                        copyFile.delete();
                    }
                    if (decryptedFile == null) break;
                }
                if (copyFile.exists()) {
                    copyFile.delete();
                }
            }
            this.writeDataToStream(response, decryptedFile, backupFile);
            nameList.add(chunkFile.getFileName());
            logger.debug(decryptedFile.length() + " remaining chunks ......" + --totalChunks);
        }
        return fileExistsTemp;
    }

    @Override
    public void inPlaceRestoreForExchangeFromCloud(Cloud cloud, String userName, String mailUserName, com.pg.domain.BackupFile backupFile, String folderId, String destCollection) {
        BufferedInputStream inputStream = null;
        String deviceUUID = backupFile.getDeviceUUID();
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File tempdownloadDir = new File(path);
        if (!tempdownloadDir.exists()) {
            tempdownloadDir.mkdirs();
        }
        try {
            EWSAppSetting appSetting = this.utilService.getEwsAppSettingDetail(cloudId);
            String token = SyncDownloadServiceImpl.getEWSAccesToken(appSetting);
            logger.debug(appSetting.getAccountId() + "..... only from db ews token ... " + token);
            appSetting.setAccountId(mailUserName);
            ExchangeService service = SyncDownloadServiceImpl.getAuthenticatedService(token, appSetting.getAccountId());
            Mailbox userMailbox = new Mailbox(mailUserName);
            logger.debug(mailUserName + ".... before creating message " + backupFile.getEwsId());
            EmailMessage message = null;
            Object contactObj = null;
            boolean messageNotExists = false;
            boolean isrestoreFolderSame = false;
            try {
                ItemId itemId = new ItemId(backupFile.getEwsId());
                EmailMessage bind = EmailMessage.bind((ExchangeService)service, (ItemId)itemId);
                if (bind != null && bind.getParentFolderId() != null) {
                    String uniqueId = bind.getParentFolderId().getUniqueId();
                    logger.debug(folderId + "...before checkdelete folder11..... " + uniqueId);
                    boolean parent = false;
                    do {
                        try {
                            ItemId itemIdval = new ItemId(uniqueId);
                            EmailMessage bindobj = EmailMessage.bind((ExchangeService)service, (ItemId)itemIdval);
                            if (bindobj != null && bindobj.getParentFolderId() != null) {
                                logger.debug(folderId + "...before checkdelete folder..... " + uniqueId);
                                uniqueId = bindobj.getParentFolderId().getUniqueId();
                                parent = true;
                                continue;
                            }
                            parent = false;
                        }
                        catch (ServiceResponseException ee) {
                            logger.debug(".....fff... ");
                            parent = false;
                        }
                    } while (parent);
                    if (uniqueId.equals(folderId)) {
                        isrestoreFolderSame = true;
                    }
                }
            }
            catch (ServiceResponseException ee) {
                logger.error("... item does not exists...  ");
                messageNotExists = true;
            }
            if (!messageNotExists && isrestoreFolderSame) {
                logger.debug("...message already exisits so return... " + isrestoreFolderSame);
                return;
            }
            logger.debug(messageNotExists + "...existing ewsid null... " + isrestoreFolderSame);
            message = new EmailMessage(service);
            if (CollectionUtils.isEmpty((Collection)backupFile.getChunkFiles())) {
                FileInfo fileInfo = this.fileDao.getFileFromPG(userName, cloudName, backupFile.getId(), false);
                List list = fileInfo.getChunkFiles();
                Collections.sort(list);
                String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
                if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
                    deviceTempPath = deviceTempPath + "/" + fileInfo.getBatchId();
                }
                String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
                logger.debug(" file mail sssssss from pg..................");
                tempdownloadDir = new File(chunkFilePath);
                if (!tempdownloadDir.exists()) {
                    tempdownloadDir.mkdirs();
                }
                try {
                    logger.debug(".... before creating message pg " + list.size());
                    for (String chunkName : list) {
                        int endIndex;
                        if (!StringUtils.isEmpty((String)chunkName) && chunkName.startsWith("part") && (endIndex = chunkName.lastIndexOf(46)) != -1) {
                            chunkName = chunkName.substring(0, endIndex);
                        }
                        logger.debug(" file from pg ss.................." + chunkName);
                        String filePath = chunkFilePath + "/" + chunkName;
                        File file = new File(filePath);
                        if (file.exists()) {
                            long size = file.length();
                            logger.debug(size + " file from pg.size................." + filePath);
                            this.inplaceMailRestore(file, backupFile, message);
                            continue;
                        }
                        logger.error(" file does not exists........" + filePath);
                    }
                    ExtendedPropertyDefinition PR_MESSAGE_FLAGS_msgflag_read = new ExtendedPropertyDefinition(3591, MapiPropertyType.Integer);
                    message.setExtendedProperty(PR_MESSAGE_FLAGS_msgflag_read, (Object)1);
                    logger.debug(folderId + "....service save pare.." + userMailbox);
                    FolderId folderIdval = new FolderId();
                    folderIdval.setUniqueId(folderId);
                    message.save(folderIdval);
                    this.utilService.updateEwsId(cloudId, backupFile.getId(), message.getId().getUniqueId(), destCollection);
                    logger.debug("......newewsid....." + message.getId());
                    logger.debug("......newewsid.. uniqueid..." + message.getId().getUniqueId());
                }
                catch (Exception e) {
                    logger.error(".... unable to do inplace restore ... " + e.getMessage());
                }
            } else {
                List chunkFilesList = backupFile.getChunkFiles();
                int totalChunks = chunkFilesList.size();
                Collections.sort(chunkFilesList, new Comparator<com.pg.domain.ChunkFile>(){

                    @Override
                    public int compare(com.pg.domain.ChunkFile c1, com.pg.domain.ChunkFile c2) {
                        if (c1 == null || c2 == null || c1.getFileName() == null || c2.getFileName() == null) {
                            return -1;
                        }
                        return new CompareToBuilder().append((Object)c1.getFileName().toLowerCase(), (Object)c2.getFileName().toLowerCase()).toComparison();
                    }
                });
                try {
                    GraphServiceClient<Request> graphClient = null;
                    OkHttpClient okHttpClient = null;
                    boolean isODBEnabled = this.isODBEnabled(cloud.getCloudCustomisableDetails());
                    if (isODBEnabled && cloud.getGraphApiEnabled() == 1) {
                        graphClient = OneDriveUtil.getGraphClient();
                        okHttpClient = Graph.getInstance().getOkHttpClient();
                    }
                    logger.debug(".... before creating message111 " + chunkFilesList.size());
                    for (com.pg.domain.ChunkFile chunkFile : chunkFilesList) {
                        String dedupVal = this.getDedupValue(userName, false);
                        logger.debug("..before chunk detail...." + userName + "...." + dedupVal + "...ch..." + chunkFile.getMd5());
                        ChunkDetail chunkDetail = null;
                        List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, false);
                        if (CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                            logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                            chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, true);
                        }
                        if (!CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                            for (ChunkDetail detailFromDB : chunkDetailList) {
                                if (detailFromDB.getRefCount() <= 0 && detailFromDB.getClientDedupRefCount() <= 0) continue;
                                chunkDetail = detailFromDB;
                            }
                        }
                        try {
                            if (chunkDetail == null) {
                                logger.debug(CHUNK_DETAILS_NULL);
                                chunkDetail = new ChunkDetail();
                                chunkDetail.setCloudChunkName(chunkFile.getFileName());
                                chunkDetail.setUserName(userName);
                                chunkDetail.setContainerName(userName.toLowerCase());
                                chunkDetail.setMd5(chunkFile.getMd5());
                            }
                            logger.debug(CLOUD_CHUNK_NAME + chunkDetail.getCloudChunkName());
                            String backupId = backupFile.getId();
                            String containerName = chunkDetail.getContainerName();
                            StringBuilder fileNameToDownload = new StringBuilder();
                            fileNameToDownload.append(chunkDetail.getCloudChunkName());
                            int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
                            if (occurance == 0 || occurance == 1 && chunkFilesList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                                fileNameToDownload.append(".").append(backupId);
                            }
                            if (chunkDetail != null) {
                                containerName = chunkDetail.getContainerName();
                                if (!StringUtils.isEmpty((String)chunkDetail.getCloudStoragePath())) {
                                    chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                                }
                            }
                            com.pg.domain.ChunkFile pgChunkFile = new com.pg.domain.ChunkFile();
                            BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
                            boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
                            String fileToDownload = fileNameToDownload.toString();
                            if (isGDEnabled) {
                                fileToDownload = chunkDetail.getCloudChunkName();
                                logger.debug(fileNameToDownload.toString() + "....chunk fileid... " + chunkDetail.getCloudChunkName());
                            }
                            logger.debug(chunkFile.getCloudStoragePath() + LOOP_BEFORE_DOWNLOAD_FILE + fileToDownload + " ..new");
                            FileStatusElement fileStatusElement = new FileStatusElement();
                            inputStream = this.cloudSupportService.downloadFile(cloud, tempdownloadDir.getPath(), fileToDownload, userName, backupFile.getDeviceUUID(), containerName, pgChunkFile, false, backupFile, fileStatusElement, chunkDetail.getUserName(), chunkDetail, "", graphClient, okHttpClient);
                            if (inputStream == null) {
                                break;
                            }
                        }
                        catch (Exception e) {
                            logger.trace("" + e);
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            catch (IOException e1) {
                                logger.trace("" + e1);
                                logger.error(EXCEPTION_WHILE_DOWNLOADING_FILE_FROM_CLOUD + e1.getMessage());
                            }
                            logger.error(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                            throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
                        }
                        String saltKeyTemp = this.getEncryptOrDecryptKey(cloud.getCloudId(), chunkFile.getUploadedTimeStamp(), BACKUP);
                        logger.debug(userName + "...users...." + chunkDetail.getUserName());
                        File decryptedFile = this.downloadService.getDecryptedFileForPortal(cloudName, saltKeyTemp, deviceUUID, chunkFile.getFileName(), inputStream, chunkDetail.getUserName(), path, chunkFile, cloudId, chunkDetail);
                        this.inplaceMailRestore(decryptedFile, backupFile, message);
                        logger.debug(" remaining chunks ......" + --totalChunks);
                    }
                    ExtendedPropertyDefinition PR_MESSAGE_FLAGS_msgflag_read = new ExtendedPropertyDefinition(3591, MapiPropertyType.Integer);
                    message.setExtendedProperty(PR_MESSAGE_FLAGS_msgflag_read, (Object)1);
                    logger.debug(folderId + "....service save pare.." + userMailbox);
                    FolderId folderIdval = new FolderId();
                    folderIdval.setUniqueId(folderId);
                    message.save(folderIdval);
                    this.utilService.updateEwsId(cloudId, backupFile.getId(), message.getId().getUniqueId(), destCollection);
                    logger.debug("......newewsid....." + message.getId());
                    logger.debug("......newewsid.. uniqueid..." + message.getId().getUniqueId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error(".... unable to do inplace restore ... " + e.getMessage());
                }
            }
            service.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(".... exception cjehee......" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inPlaceRestoreForContactFromCloud(Cloud cloud, String userName, String mailUserName, com.pg.domain.BackupFile backupFile, String destCollection, String itemId) {
        block70: {
            BufferedInputStream inputStream = null;
            String deviceUUID = backupFile.getDeviceUUID();
            int cloudId = cloud.getCloudId();
            String cloudName = cloud.getCloudName();
            String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            File tempdownloadDir = new File(path);
            if (!tempdownloadDir.exists()) {
                tempdownloadDir.mkdirs();
            }
            try {
                logger.debug(mailUserName + ".... before creating message itemId .." + itemId);
                Contact contactObj = null;
                boolean contactNotExists = false;
                boolean isrestoreFolderSame = false;
                String accessToken = this.utilService.getAccessTokenForODBBackup(cloud.getCloudId());
                Graph graph = Graph.getInstance();
                GraphServiceClient<Request> graphClient = graph.getGraphClient();
                UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(new Option[0])).get();
                List currentPage = iUserCollectionPage.getCurrentPage();
                User userFound = null;
                for (User user : currentPage) {
                    if (user.mail == null || user.mail != null && !user.mail.equalsIgnoreCase(mailUserName)) continue;
                    logger.debug(user.mail + ".... " + user.displayName + "..." + user.id);
                    userFound = user;
                }
                String userId = userFound.id;
                logger.debug(userId + ".... beforegettting user  ..." + userId);
                try {
                    contactObj = graphClient.users(userId).contacts(itemId).buildRequest(new Option[0]).get();
                }
                catch (GraphServiceException e) {
                    logger.debug(".. contact does not exists graph " + e.getResponseCode());
                }
                catch (Exception e) {
                    logger.debug(".. contact does not exists ");
                }
                if (contactObj != null) {
                    logger.debug("... contact already exists so skip restore again ...");
                    break block70;
                }
                if (CollectionUtils.isEmpty((Collection)backupFile.getChunkFiles())) {
                    logger.debug("... trying to create contact from pg content id..." + backupFile.getId());
                    FileInfo fileInfo = this.fileDao.getFileFromPG(userName, cloudName, backupFile.getId(), false);
                    List list = fileInfo.getChunkFiles();
                    Collections.sort(list);
                    String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
                    if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
                        deviceTempPath = deviceTempPath + "/" + fileInfo.getBatchId();
                    }
                    String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
                    logger.debug(userName + " file mail sssssss from pg.................." + mailUserName);
                    tempdownloadDir = new File(chunkFilePath);
                    if (!tempdownloadDir.exists()) {
                        tempdownloadDir.mkdirs();
                    }
                    HttpClient httpclient = null;
                    HttpPost httpPost = null;
                    HttpResponse response = null;
                    try {
                        for (String chunkName : list) {
                            int endIndex;
                            if (!StringUtils.isEmpty((String)chunkName) && chunkName.startsWith("part") && (endIndex = chunkName.lastIndexOf(46)) != -1) {
                                chunkName = chunkName.substring(0, endIndex);
                            }
                            logger.debug(" file from pg ss.................." + chunkName);
                            String filePath = chunkFilePath + "/" + chunkName;
                            File file = new File(filePath);
                            if (file.exists()) {
                                long size = file.length();
                                logger.debug(size + " file from pg.size................." + filePath);
                                JsonParser jsonParser = new JsonParser();
                                JSONObject jsonObject = null;
                                try (FileReader reader2 = new FileReader(file);){
                                    JsonElement obj = jsonParser.parse((Reader)new FileReader(file));
                                    jsonObject = (JSONObject)obj;
                                }
                                catch (FileNotFoundException reader2) {
                                }
                                catch (IOException reader2) {
                                }
                                catch (JSONException reader2) {
                                    // empty catch block
                                }
                                if (jsonObject != null) {
                                    logger.debug(".....jsonresults ...." + jsonObject.toString());
                                    String url = "https://graph.microsoft.com/v1.0/users/" + userId + "/contacts";
                                    httpclient = HttpClientUtil.getSSlConnection();
                                    httpPost = new HttpPost(url);
                                    httpPost.setHeader("Content-Type", "application/json");
                                    httpPost.setHeader("Authorization", "Bearer " + accessToken);
                                    StringEntity params = new StringEntity(jsonObject.toString());
                                    httpPost.setEntity((HttpEntity)params);
                                    response = httpclient.execute((HttpUriRequest)httpPost);
                                    logger.debug("after doing inplace restore status code :" + response.getStatusLine().getStatusCode());
                                    continue;
                                }
                                logger.error("...unable to restore contacts.... ");
                                continue;
                            }
                            logger.error(" file does not exists........" + filePath);
                        }
                        break block70;
                    }
                    catch (Exception e) {
                        logger.error(".... exception......" + e.getMessage());
                        break block70;
                    }
                    finally {
                        httpPost.releaseConnection();
                    }
                }
                logger.debug("... trying to create contact from cloud content ...");
                List chunkFilesList = backupFile.getChunkFiles();
                int totalChunks = chunkFilesList.size();
                Collections.sort(chunkFilesList, new Comparator<com.pg.domain.ChunkFile>(){

                    @Override
                    public int compare(com.pg.domain.ChunkFile c1, com.pg.domain.ChunkFile c2) {
                        if (c1 == null || c2 == null || c1.getFileName() == null || c2.getFileName() == null) {
                            return -1;
                        }
                        return new CompareToBuilder().append((Object)c1.getFileName().toLowerCase(), (Object)c2.getFileName().toLowerCase()).toComparison();
                    }
                });
                HttpClient httpclient = null;
                HttpPost httpPost = null;
                HttpResponse response = null;
                try {
                    logger.debug(".... before creating message111 " + chunkFilesList.size());
                    OkHttpClient okHttpClient = Graph.getInstance().getOkHttpClient();
                    for (com.pg.domain.ChunkFile chunkFile : chunkFilesList) {
                        Object pgChunkFile;
                        ChunkDetail chunkDetail;
                        block72: {
                            String dedupVal = this.getDedupValue(userName, false);
                            logger.debug("..before chunk detail...." + userName + "...." + dedupVal + "...ch..." + chunkFile.getMd5());
                            chunkDetail = null;
                            List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, false);
                            if (CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                                logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                                chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, true);
                            }
                            if (!CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                                for (ChunkDetail detailFromDB : chunkDetailList) {
                                    if (detailFromDB.getRefCount() <= 0 && detailFromDB.getClientDedupRefCount() <= 0) continue;
                                    chunkDetail = detailFromDB;
                                }
                            }
                            try {
                                if (chunkDetail == null) {
                                    logger.debug(CHUNK_DETAILS_NULL);
                                    chunkDetail = new ChunkDetail();
                                    chunkDetail.setCloudChunkName(chunkFile.getFileName());
                                    chunkDetail.setUserName(userName);
                                    chunkDetail.setContainerName(userName.toLowerCase());
                                    chunkDetail.setMd5(chunkFile.getMd5());
                                }
                                logger.debug(CLOUD_CHUNK_NAME + chunkDetail.getCloudChunkName());
                                String backupId = backupFile.getId();
                                String containerName = chunkDetail.getContainerName();
                                StringBuilder fileNameToDownload = new StringBuilder();
                                fileNameToDownload.append(chunkDetail.getCloudChunkName());
                                int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
                                if (occurance == 0 || occurance == 1 && chunkFilesList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                                    fileNameToDownload.append(".").append(backupId);
                                }
                                if (chunkDetail != null) {
                                    containerName = chunkDetail.getContainerName();
                                    if (!StringUtils.isEmpty((String)chunkDetail.getCloudStoragePath())) {
                                        chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                                    }
                                }
                                pgChunkFile = new com.pg.domain.ChunkFile();
                                BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
                                boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
                                String fileToDownload = fileNameToDownload.toString();
                                if (isGDEnabled) {
                                    fileToDownload = chunkDetail.getCloudChunkName();
                                    logger.debug(fileNameToDownload.toString() + "....chunk fileid... " + chunkDetail.getCloudChunkName());
                                }
                                logger.debug(chunkFile.getCloudStoragePath() + LOOP_BEFORE_DOWNLOAD_FILE + fileToDownload + " ..new");
                                FileStatusElement fileStatusElement = new FileStatusElement();
                                inputStream = this.cloudSupportService.downloadFile(cloud, tempdownloadDir.getPath(), fileToDownload, userName, backupFile.getDeviceUUID(), containerName, (com.pg.domain.ChunkFile)pgChunkFile, false, backupFile, fileStatusElement, chunkDetail.getUserName(), chunkDetail, "", graphClient, okHttpClient);
                                if (inputStream != null) break block72;
                                break;
                            }
                            catch (Exception e) {
                                logger.trace("" + e);
                                try {
                                    if (inputStream != null) {
                                        inputStream.close();
                                    }
                                }
                                catch (IOException e1) {
                                    logger.trace("" + e1);
                                    logger.error(EXCEPTION_WHILE_DOWNLOADING_FILE_FROM_CLOUD + e1.getMessage());
                                }
                                logger.error(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                                throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
                            }
                        }
                        String saltKeyTemp = this.getEncryptOrDecryptKey(cloud.getCloudId(), chunkFile.getUploadedTimeStamp(), BACKUP);
                        logger.debug(userName + "...users...." + chunkDetail.getUserName());
                        File decryptedFile = this.downloadService.getDecryptedFileForPortal(cloudName, saltKeyTemp, deviceUUID, chunkFile.getFileName(), inputStream, chunkDetail.getUserName(), path, chunkFile, cloudId, chunkDetail);
                        JsonParser jsonParser = new JsonParser();
                        JSONObject jsonObject = null;
                        try {
                            FileReader reader = new FileReader(decryptedFile);
                            pgChunkFile = null;
                            try {
                                JsonElement obj = jsonParser.parse((Reader)new FileReader(decryptedFile));
                                jsonObject = (JSONObject)obj;
                            }
                            catch (Throwable throwable) {
                                pgChunkFile = throwable;
                                throw throwable;
                            }
                            finally {
                                if (reader != null) {
                                    if (pgChunkFile != null) {
                                        try {
                                            reader.close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)pgChunkFile).addSuppressed(throwable);
                                        }
                                    } else {
                                        reader.close();
                                    }
                                }
                            }
                        }
                        catch (FileNotFoundException reader) {
                        }
                        catch (IOException reader) {
                        }
                        catch (JSONException reader) {
                            // empty catch block
                        }
                        if (jsonObject != null) {
                            logger.debug(".....jsonresults ...." + jsonObject.toString());
                            String url = "https://graph.microsoft.com/v1.0/users/" + userId + "/contacts";
                            httpclient = HttpClientUtil.getSSlConnection();
                            httpPost = new HttpPost(url);
                            httpPost.setHeader("Content-Type", "application/json");
                            httpPost.setHeader("Authorization", "Bearer " + accessToken);
                            StringEntity params = new StringEntity(jsonObject.toString());
                            httpPost.setEntity((HttpEntity)params);
                            response = httpclient.execute((HttpUriRequest)httpPost);
                            logger.debug("after doing inplace restore status code :" + response.getStatusLine().getStatusCode());
                        } else {
                            logger.error("...unable to restore contacts.... ");
                        }
                        logger.debug(" remaining chunks ......" + --totalChunks);
                    }
                }
                catch (Exception e) {
                    logger.error(".... exception......" + e.getMessage());
                }
            }
            catch (Exception e) {
                logger.error(".... exception......" + e.getMessage());
            }
        }
    }

    private void inplaceMailRestore(File decryptedFile, com.pg.domain.BackupFile backupFile, EmailMessage message) {
        byte[] bytes = new byte[(int)decryptedFile.length()];
        try {
            FileInputStream fis = new FileInputStream(decryptedFile);
            FilterInputStream fif = new BufferedInputStream(fis);
            logger.debug(IS_COMPRESSED + backupFile.isCompressed());
            if (backupFile.isCompressed()) {
                fif = new GZIPInputStream(fif);
            }
            ((InputStream)fif).read(bytes);
            ((InputStream)fif).close();
            message.setMimeContent(new MimeContent(UTF8, bytes));
        }
        catch (Exception e) {
            logger.error(".... exception......" + e.getMessage());
        }
    }

    public static ExchangeService getAuthenticatedService(String token, String senderAddr) {
        ExchangeService service = null;
        try {
            service = new ExchangeService(ExchangeVersion.Exchange2010_SP2);
            service.getHttpHeaders().put("Authorization", "Bearer " + token);
            service.getHttpHeaders().put("X-AnchorMailbox", senderAddr);
            service.setUrl(new URI(EWS_URL));
            service.setImpersonatedUserId(new ImpersonatedUserId(ConnectingIdType.PrincipalName, senderAddr));
        }
        catch (Exception e) {
            logger.error(".... exception......" + e.getMessage());
        }
        return service;
    }

    public static synchronized String getEWSAccesToken(EWSAppSetting ewsAppSetting) {
        String accessToken = "";
        try {
            long now = System.currentTimeMillis();
            ExecutorService es = Executors.newFixedThreadPool(2);
            AuthenticationContext context = new AuthenticationContext(AUTHORITY + ewsAppSetting.getTenantId(), false, es);
            AuthenticationCallback<AuthenticationResult> callback = new AuthenticationCallback<AuthenticationResult>(){

                public void onSuccess(AuthenticationResult result) {
                    System.out.println("received token");
                }

                public void onFailure(Throwable exc) {
                    throw new RuntimeException(exc);
                }
            };
            System.out.println("requesting token");
            Future future = context.acquireToken(RESOURCE, new ClientCredential(ewsAppSetting.getClientId(), ewsAppSetting.getClientSecretKey()), (AuthenticationCallback)callback);
            AuthenticationResult result = (AuthenticationResult)future.get(30L, TimeUnit.SECONDS);
            accessToken = result.getAccessToken();
        }
        catch (Exception e) {
            logger.error(".... exception......" + e.getMessage());
        }
        return accessToken;
    }

    private void writeDataToStream(HttpServletResponse response, File decryptedFile, com.pg.domain.BackupFile backupFile) {
        try {
            int buff;
            logger.debug(SENDING_FILE + decryptedFile.getName());
            FileInputStream fis = new FileInputStream(decryptedFile);
            FilterInputStream fif = new BufferedInputStream(fis);
            logger.debug(IS_COMPRESSED + backupFile.isCompressed());
            if (backupFile.isCompressed()) {
                fif = new GZIPInputStream(fif);
            }
            byte[] b = new byte[4096];
            while ((buff = ((InputStream)fif).read(b)) != -1) {
                response.getOutputStream().write(b, 0, buff);
            }
            ((InputStream)fif).close();
            response.getOutputStream().flush();
            logger.debug(FINISHED_FILE + decryptedFile.getName());
            decryptedFile.delete();
            logger.debug("deleting  file  under path " + decryptedFile.getPath());
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(" error trying to send ...." + e.getMessage());
        }
    }

    private void writeDataToStream(HttpServletResponse response, File decryptedFile, BackUpImage backUpImage) {
        try {
            int buff;
            logger.debug(SENDING_FILE + decryptedFile.getName());
            FileInputStream fis = new FileInputStream(decryptedFile);
            FilterInputStream fif = new BufferedInputStream(fis);
            logger.debug(IS_COMPRESSED + backUpImage.isCompressed());
            if (backUpImage.isCompressed()) {
                fif = new GZIPInputStream(fif);
            }
            byte[] b = new byte[4096];
            while ((buff = ((InputStream)fif).read(b)) != -1) {
                response.getOutputStream().write(b, 0, buff);
            }
            ((InputStream)fif).close();
            response.getOutputStream().flush();
            logger.debug(FINISHED_FILE + decryptedFile.getName());
            decryptedFile.delete();
            logger.debug("deleting  file  under path " + decryptedFile.getPath());
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(" error trying to send ...." + e.getMessage());
        }
    }

    private byte[] writeDataToStreamForPhoto(File decryptedFile, BackUpImage backUpImage) {
        try {
            int nRead;
            logger.debug(SENDING_FILE + decryptedFile.getName());
            FileInputStream fis = new FileInputStream(decryptedFile);
            BufferedInputStream fif = new BufferedInputStream(fis);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = ((InputStream)fif).read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            byte[] byteArray = buffer.toByteArray();
            logger.debug(FINISHED_FILE + decryptedFile.getName());
            decryptedFile.delete();
            logger.debug("deleting  file  under path " + decryptedFile.getPath());
            ((InputStream)fif).close();
            return byteArray;
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(" error trying to send ...." + e.getMessage());
            return new byte[]{0, 1, 2};
        }
    }

    @Override
    public void restoreFilesFromCloud(Cloud cloud, RestoreElement restoreElement, String userName, HttpServletResponse response, int skipValue, long totalCount, long downloadedCount, Map<String, Long> fileVersionMap, List<FileElement> list) {
        long downloadedCountTemp = downloadedCount;
        String cloudName = restoreElement.getCloudName();
        String deviceUUID = restoreElement.getDeviceUUID();
        String restoreId = restoreElement.getRestoreBatchId();
        String path = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        String restorePath = path + restoreId + "/";
        File restorePathDir = new File(restorePath);
        if (!restorePathDir.exists()) {
            restorePathDir.mkdirs();
        }
        List licenseDetails = cloud.getCloudCustomisableDetails();
        int cloudId = cloud.getCloudId();
        boolean isODBEnabled = false;
        licenseDetails.removeAll(Collections.singleton(null));
        for (CloudCustomisableDetails cloudCustomisableDetails : licenseDetails) {
            if (!"ODB Enabled".equals(cloudCustomisableDetails.getName())) continue;
            isODBEnabled = true;
            break;
        }
        PciAuthorizationTokenElement element = null;
        if (isODBEnabled) {
            logger.debug("  USER NAME .................... " + userName);
            com.parablu.pcbd.domain.User user = this.utilService.getUserInfoByName(cloudId, userName);
            element = this.utilService.getPCITokenElement(cloudId, user.getUserId());
            if (user != null && element != null) {
                element.setUserName(user.getUserName());
            }
        }
        for (FileElement fileElement : list) {
            String fileRevisionId = fileElement.getFileRevisionId();
            logger.debug(fileElement.getFileName() + " File revision id ..........................." + fileRevisionId);
            com.pg.domain.BackupFile backupFile = this.syncFileDao.getSyncFileForId(cloudId, cloudName, userName, deviceUUID, fileRevisionId);
            if (backupFile != null && !StringUtils.isEmpty((String)backupFile.getDedupBackupId())) {
                logger.debug(fileRevisionId + " dedup file ..... " + backupFile.getDedupBackupId());
                String fileName = backupFile.getFileName();
                String filePath = backupFile.getFilePath();
                backupFile = this.syncFileDao.getSyncFileForId(cloudId, cloudName, userName, deviceUUID, backupFile.getDedupBackupId());
                backupFile.setFileName(fileName);
                backupFile.setFilePath(filePath);
            }
            FileInfo fileInfo = null;
            if (backupFile == null) {
                fileInfo = this.fileDao.getFileFromPG(userName, cloudName, fileRevisionId, true);
                this.restoreFromPGForAgent(cloudName, response, fileInfo);
            }
            FileStatusElement fileStatusElement = new FileStatusElement();
            if (fileInfo != null || backupFile == null) {
                try {
                    String isChunk = "false";
                    backupFile = new com.pg.domain.BackupFile();
                    backupFile.setFileName(fileElement.getFileName());
                    backupFile.setFilePath(fileElement.getFileCompletePath());
                    backupFile.setMd5(fileElement.getMd5checksum());
                    fileStatusElement.setUploadStatuscode(507);
                    downloadedCountTemp = this.sendHeadersForMultipart(response, totalCount, downloadedCountTemp, backupFile, isChunk, fileStatusElement);
                }
                catch (IOException e) {
                    logger.error("Exception in send headers>>>" + e);
                }
                continue;
            }
            String backupId = backupFile.getId();
            String fileName = backupFile.getFileName();
            String folderPath = backupFile.getFilePath();
            List chunkFileList = backupFile.getChunkFiles();
            Collections.sort(chunkFileList, new Comparator<com.pg.domain.ChunkFile>(){

                @Override
                public int compare(com.pg.domain.ChunkFile d1, com.pg.domain.ChunkFile d2) {
                    return d1.getFileName().compareTo(d2.getFileName());
                }
            });
            BufferedInputStream inputStream = null;
            ArrayList<String> nameList = new ArrayList<String>();
            logger.debug(backupFile.getFileName() + "@#@#@#@##### Writing outside to stream ....download count>>" + downloadedCountTemp);
            try {
                String isChunk = "true";
                downloadedCountTemp = this.sendHeadersForMultipart(response, totalCount, downloadedCountTemp, backupFile, isChunk, fileStatusElement);
            }
            catch (Exception e) {
                String simpleName = e.getCause().getClass().getSimpleName();
                logger.trace("" + e);
                logger.error("Error trying to write data .....%%%%%%%%% " + simpleName + "file path>>>" + backupFile.getFilePath() + "file name>>>" + backupFile.getFileName() + e.getMessage());
                try {
                    if ("ClientAbortException".equals(simpleName) || "SocketException".equals(simpleName)) {
                        this.deleteFilesUnderMergeAndDecrypt(path);
                        logger.error(" throw client abort exception .......");
                        throw new BlukryptClientAbortException("Client Aborted", 1);
                    }
                    response.getOutputStream().close();
                }
                catch (IOException e1) {
                    logger.trace("" + e1);
                    logger.error("Exception While Restoring File From Cloud :" + e1.getMessage());
                }
            }
            boolean parentFileExists = false;
            logger.debug("BakcupFile userName>>>>>$$$$$$$$$$$" + backupFile.getUserName());
            boolean fileExists = this.downloadFile(cloud, backupFile.getUserName(), response, cloudName, deviceUUID, path, restorePath, cloudId, element, backupFile, backupId, fileName, folderPath, chunkFileList, inputStream, nameList, fileStatusElement, true);
            logger.debug(" file exists flag ....... " + fileExists);
            if (!fileExists) {
                logger.debug(" try parent file for md5..........");
                com.pg.domain.BackupFile backupFileObj = this.syncFileDao.getSyncFileForMd5(cloudId, cloudName, userName, deviceUUID, backupFile.getMd5());
                if (backupFileObj != null) {
                    logger.debug(" parent file for md5 exists ..........");
                    chunkFileList = backupFileObj.getChunkFiles();
                    parentFileExists = this.downloadFile(cloud, backupFile.getUserName(), response, cloudName, deviceUUID, path, restorePath, cloudId, element, backupFileObj, backupFileObj.getId(), fileName, folderPath, chunkFileList, inputStream, nameList, fileStatusElement, true);
                }
                logger.debug("************" + parentFileExists + "***" + fileRevisionId);
            }
            String isChunk = "false";
            try {
                ++downloadedCountTemp;
                downloadedCountTemp = this.sendHeadersForMultipart(response, totalCount, downloadedCountTemp, backupFile, isChunk, fileStatusElement);
            }
            catch (IOException e) {
                logger.error("Error in setting headers for multipart" + e);
            }
        }
    }

    private long sendHeadersForMultipart(HttpServletResponse response, long totalCount, long downloadedCountTemp, com.pg.domain.BackupFile backupFile, String isChunk, FileStatusElement fileStatusElement) throws IOException {
        response.getOutputStream().println();
        response.getOutputStream().println("----PARABLUEOF");
        String partHeader = "Content-Disposition: form-data;";
        response.getOutputStream().println(partHeader);
        String fileNameHeader = this.getEncodedFileName(true, backupFile.getFileName());
        byte[] fileNameBytes = fileNameHeader.getBytes(UTF8);
        response.getOutputStream().write(fileNameBytes);
        response.getOutputStream().println();
        String filePathHeader = this.getEncodedFilePath(true, backupFile.getFilePath());
        byte[] filePathBytes = filePathHeader.getBytes(UTF8);
        response.getOutputStream().write(filePathBytes);
        response.getOutputStream().println();
        String md5 = "md5Checksum:" + backupFile.getMd5();
        response.getOutputStream().println(md5);
        logger.debug(" File md5 .......... " + md5);
        response.getOutputStream().println("count:" + downloadedCountTemp + "/" + totalCount);
        response.getOutputStream().println("isAChunkFile:" + isChunk);
        response.getOutputStream().println("downloadStatus:" + fileStatusElement.getUploadStatuscode());
        response.getOutputStream().println();
        return downloadedCountTemp;
    }

    private boolean downloadFile(Cloud cloud, String userName, HttpServletResponse response, String cloudName, String deviceUUID, String path, String restorePath, int cloudId, PciAuthorizationTokenElement element, com.pg.domain.BackupFile backupFile, String backupId, String fileName, String folderPath, List<com.pg.domain.ChunkFile> chunkFileList, BufferedInputStream inputStreams, List<String> nameList, FileStatusElement fileStatusElement, boolean isSync) {
        boolean fileExists = true;
        BufferedInputStream inputStreamTemp = null;
        GraphServiceClient<Request> graphClient = null;
        OkHttpClient okHttpClient = null;
        boolean isODBEnabled = this.isODBEnabled(cloud.getCloudCustomisableDetails());
        if (isODBEnabled && cloud.getGraphApiEnabled() == 1) {
            graphClient = OneDriveUtil.getGraphClient();
            okHttpClient = Graph.getInstance().getOkHttpClient();
        }
        for (com.pg.domain.ChunkFile chunkFile : chunkFileList) {
            String syncDecryptKey;
            String productType;
            String saltKey;
            block25: {
                saltKey = null;
                productType = isSync ? PRODUCT_TYPE_SYNC : BACKUP;
                syncDecryptKey = SYNC_DECRYPT_KEY;
                ChunkDetail chunkDetail = null;
                try {
                    if (StringUtils.isEmpty((String)chunkFile.getMd5())) {
                        logger.debug("Md5 is null so setting it from chunk file");
                        chunkFile.setMd5(SyncDownloadServiceImpl.getMd5FromFileName(chunkFile.getFileName()));
                    }
                    String dedupVal = this.getDedupValue(userName, isSync);
                    chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, chunkFile.getMd5(), dedupVal, userName, false, false);
                    if (chunkDetail == null) {
                        logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                        chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, chunkFile.getMd5(), dedupVal, userName, false, true);
                    }
                    if (chunkDetail == null) {
                        logger.debug(CHUNK_DETAILS_NULL);
                        chunkDetail = new ChunkDetail();
                        chunkDetail.setCloudChunkName(chunkFile.getFileName());
                    }
                    StringBuilder fileNameToDownload = new StringBuilder(chunkDetail.getCloudChunkName());
                    saltKey = this.getEncryptOrDecryptKey(cloudId, chunkFile.getUploadedTimeStamp(), productType);
                    int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
                    if (occurance == 0 || occurance == 1 && chunkFileList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                        fileNameToDownload.append("." + backupId);
                    }
                    String containerName = null;
                    if (chunkDetail != null) {
                        containerName = chunkDetail.getContainerName();
                        if (!StringUtils.isEmpty((String)chunkDetail.getCloudStoragePath())) {
                            chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                        }
                        syncDecryptKey = chunkDetail.getUserName();
                    }
                    if (this.isGDEnabled(cloud.getCloudCustomisableDetails())) {
                        chunkFile.setFileId(chunkDetail.getCloudChunkName());
                    }
                    if (chunkFile.getSize() == null) {
                        chunkFile.setSize(Long.valueOf(0L));
                    }
                    logger.debug(" trying to download .......... " + fileNameToDownload);
                    inputStreamTemp = this.downloadFileFromCloud(cloud, restorePath, fileNameToDownload.toString(), userName.toLowerCase(), cloudName, backupFile.getDeviceUUID(), element, chunkFile, backupFile, containerName, fileStatusElement, chunkDetail.getUserName(), chunkDetail, graphClient, okHttpClient);
                    if (inputStreamTemp == null) {
                        logger.debug(" input stream null .........");
                        fileExists = false;
                    }
                    if (!fileExists) {
                        break;
                    }
                }
                catch (ParacloudBackupException e) {
                    logger.trace("" + (Object)((Object)e));
                    logger.error("THE error code is>>>>>$$>>>>>" + e.getResponseCode());
                    if (e.getResponseCode() != 404) break block25;
                    nameList.clear();
                    try {
                        File decryptedFile = this.searchReplicaAndRestore(cloud, cloudName, userName, backupFile, nameList, saltKey, fileName, folderPath, element, restorePath);
                        logger.debug(" Before writeDatatoStream searchReplicaAndRestore... ");
                        this.writeDataToStream(response, path, restorePath, backupFile, decryptedFile);
                        logger.debug(" After writeDatatoStream searchReplicaAndRestore... ");
                        continue;
                    }
                    catch (Exception ex) {
                        logger.trace("" + ex);
                        logger.error(" Error in searchReplicaAndRestore - File not found ...." + ex.getMessage());
                        try {
                            if (inputStreamTemp != null) {
                                inputStreamTemp.close();
                            }
                        }
                        catch (IOException e1) {
                            logger.trace("" + e1);
                            logger.error("Exception While Downloading File :" + e1.getMessage());
                        }
                        inputStreamTemp = null;
                    }
                }
                catch (Exception e) {
                    logger.debug("Exception = " + e);
                    try {
                        if (inputStreamTemp != null) {
                            inputStreamTemp.close();
                        }
                    }
                    catch (IOException e1) {
                        logger.trace("" + e1);
                        logger.error("Exception While Downloading File :" + e1.getMessage());
                    }
                    logger.error("Error trying to write data .....22222%%%%%%%%% file path>>>" + backupFile.getFilePath() + "file name>>>" + backupFile.getFileName());
                    logger.debug(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                    throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
                }
            }
            saltKey = this.getEncryptOrDecryptKey(cloudId, chunkFile.getUploadedTimeStamp(), productType);
            if (saltKey == null) {
                throw new ParacloudBackupException("Azure download error while get decrypt key", 400);
            }
            File decryptedFile = this.getDecryptedFileFromPath(cloudName, saltKey, deviceUUID, chunkFile.getFileName(), inputStreamTemp, restorePath, syncDecryptKey);
            if (decryptedFile == null) {
                logger.debug(" decryptedFile null so breaking.........");
                fileExists = false;
                break;
            }
            this.writeDataToStream(response, path, restorePath, backupFile, decryptedFile);
            nameList.add(chunkFile.getFileName());
        }
        return fileExists;
    }

    public String getEncryptOrDecryptKey(int cloudId, long timeStamp, String productType) {
        EncryptionKey encryptionKey = this.encryptionKeyDao.getKeyForDecrypt(cloudId, timeStamp, productType);
        String encryptionKeyVal = "";
        if (encryptionKey != null) {
            encryptionKeyVal = encryptionKey.getSaltKey();
            logger.debug(productType + "Recieved salt key  for file ..... " + encryptionKeyVal);
        }
        return encryptionKeyVal;
    }

    private void deleteFilesUnderMergeAndDecrypt(String path) {
        String mergePath = path + MERGE;
        String decryptedPath = path + DECRYPTED;
        File mergeFolder = new File(mergePath);
        File decryptedFolder = new File(decryptedPath);
        if (mergeFolder.exists()) {
            ResourceFileHelper.deleteAllChildFilesExcludingDirectories((File)mergeFolder);
        }
        if (decryptedFolder.exists()) {
            ResourceFileHelper.deleteAllChildFilesExcludingDirectories((File)decryptedFolder);
        }
    }

    private static String getMd5FromFileName(String fileName) {
        int occurance = StringUtils.countMatches((String)fileName, (String)".");
        String md5 = "";
        logger.debug("File name inside getmd5$$$$>>:" + fileName);
        if (occurance == 0) {
            md5 = fileName;
        } else if (occurance == 1) {
            md5 = fileName.substring(0, fileName.lastIndexOf(46));
        } else if (occurance > 1) {
            md5 = fileName.substring(fileName.indexOf(46) + 1, fileName.lastIndexOf(46));
        }
        return md5;
    }

    private BufferedInputStream downloadFileFromCloud(Cloud cloud, String restorePathDir, String fileNameToDownload, String userName, String cloudName, String deviceUUID, PciAuthorizationTokenElement pciAuthorizationTokenElement, com.pg.domain.ChunkFile chunkFile, com.pg.domain.BackupFile backupFile, String containerName, FileStatusElement fileStatusElement, String folderName, ChunkDetail chunkDetailTemp, GraphServiceClient<Request> graphClient, OkHttpClient okHttpClient) {
        logger.debug(chunkFile.getCloudStoragePath() + " downloading files using cloudsupport service  >>>>>> " + fileNameToDownload);
        com.pg.domain.ChunkFile pgChunkFile = new com.pg.domain.ChunkFile();
        BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
        ChunkDetail chunkDetail = new ChunkDetail();
        BeanUtils.copyProperties((Object)chunkFile, (Object)chunkDetail);
        boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
        String fileToDownload = fileNameToDownload;
        chunkDetail.setEncodedName(chunkDetailTemp.getEncodedName());
        if (isGDEnabled) {
            fileToDownload = pgChunkFile.getFileId();
        }
        if (chunkFile.getSize() == null) {
            chunkFile.setSize(Long.valueOf(0L));
        }
        BufferedInputStream inputStream = this.cloudSupportService.downloadFile(cloud, restorePathDir, fileToDownload, userName, deviceUUID, containerName, pgChunkFile, true, backupFile, fileStatusElement, folderName, chunkDetail, "", graphClient, okHttpClient);
        return inputStream;
    }

    private void writeDataToStream(HttpServletResponse response, String path, String restorePath, com.pg.domain.BackupFile backupFile, File decryptedFile) {
        try {
            logger.debug("!!!!NO MERGE..................");
            this.writeDataToStream(decryptedFile, backupFile, response, restorePath);
        }
        catch (Exception e) {
            try {
                String simpleName = e.getCause().getClass().getSimpleName();
                logger.trace("" + e);
                logger.error("Error trying to write data ..... " + simpleName + e.getMessage());
                if (decryptedFile.exists()) {
                    decryptedFile.delete();
                }
                if ("ClientAbortException".equals(simpleName) || "SocketException".equals(simpleName)) {
                    this.deleteFilesUnderMergeAndDecrypt(path);
                    logger.error(" throw client abort exception .......");
                    throw new BlukryptClientAbortException("Client Aborted", 1);
                }
                response.getOutputStream().close();
            }
            catch (IOException e1) {
                logger.trace("" + e1);
                logger.error("Exception While Writting Data to Stream :" + e1.getMessage());
            }
        }
    }

    private void writeDataToStream(File file, com.pg.domain.BackupFile backupFile, HttpServletResponse response, String path) throws IOException {
        int buff;
        logger.debug(SENDING_FILE + file.getName());
        FileInputStream fis = new FileInputStream(file);
        FilterInputStream fif = new BufferedInputStream(fis);
        logger.debug(IS_COMPRESSED + backupFile.isCompressed());
        if (backupFile.isCompressed()) {
            fif = new GZIPInputStream(fif);
        }
        byte[] b = new byte[4096];
        while ((buff = ((InputStream)fif).read(b)) != -1) {
            response.getOutputStream().write(b, 0, buff);
        }
        ((InputStream)fif).close();
        response.getOutputStream().flush();
        logger.debug(FINISHED_FILE + file.getName());
        file.delete();
        logger.debug("deleting  file  under path " + file.getPath());
    }

    private File searchReplicaAndRestore(Cloud cloud, String cloudName, String userName, com.pg.domain.BackupFile backupFile, List<String> nameList, String saltKey, String fileName, String folderPath, PciAuthorizationTokenElement element, String restorePath) {
        return null;
    }

    private void restoreFromPGForAgent(String cloudName, HttpServletResponse response, FileInfo fileInfo) {
        if (fileInfo != null) {
            String fileInfoFileName = fileInfo.getFileName();
            try {
                response.getOutputStream().println();
                response.getOutputStream().println("----PARABLUEOF");
                String partHeader = "Content-Disposition: form-data;";
                response.getOutputStream().println(partHeader);
                String fileNameHeader = this.getEncodedFileName(true, fileInfoFileName);
                byte[] fileNameBytes = fileNameHeader.getBytes(UTF8);
                response.getOutputStream().write(fileNameBytes);
                response.getOutputStream().println();
                String filePathHeader = this.getEncodedFilePath(true, fileInfo.getFilePath());
                byte[] filePathBytes = filePathHeader.getBytes(UTF8);
                response.getOutputStream().write(filePathBytes);
                response.getOutputStream().println();
                String md5 = "md5Checksum:" + fileInfo.getMd5();
                response.getOutputStream().println(md5);
                logger.debug(" File md5 .......... " + md5);
                response.getOutputStream().println();
            }
            catch (IOException e) {
                logger.trace("" + e);
                logger.error("Exception While Restoring From PG For Agent :" + e.getMessage());
            }
            logger.debug(" file is in pg .... " + fileInfo.getFileName() + "...." + fileInfo.getFilePath());
            List list = fileInfo.getChunkFiles();
            Collections.sort(list);
            String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
            if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
                deviceTempPath = deviceTempPath + "/" + fileInfo.getBatchId();
            }
            String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
            for (String chunkName : list) {
                logger.debug(" file from pg.................." + chunkName);
                String filePath = chunkFilePath + "/" + chunkName;
                File file = new File(filePath);
                if (file.exists()) {
                    long size = file.length();
                    logger.debug(size + " file from pg.size................." + filePath);
                    this.writeDataToStreamFromPg(response, file, fileInfo);
                    continue;
                }
                logger.error(" file does not exists........" + filePath);
            }
            logger.debug(" before returning.........");
        }
    }

    private void restoreFromPG(Cloud cloud, HttpServletResponse response, FileInfo fileInfo, boolean isSync, String browserType, String userName) {
        if (fileInfo != null) {
            String fileInfoFileName = fileInfo.getFileName();
            Long filesize = fileInfo.getSize();
            response.addHeader("Pragma", "public");
            response.addHeader("Expires", String.valueOf(200));
            response.addHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            String encodedFilename = fileInfoFileName;
            try {
                encodedFilename = URLEncoder.encode(fileInfoFileName, UTF8).replace("+", "%20");
                if (browserType.contains("Firefox")) {
                    response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + encodedFilename);
                } else if (browserType.contains("Chrome")) {
                    response.setHeader("Content-Disposition", "attachment; filename=" + encodedFilename);
                } else {
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + fileInfoFileName + "\"");
                }
                response.addHeader("Content-Transfer-Encoding", "binary");
                response.addHeader("Content-Length", String.valueOf(filesize));
                response.addHeader("filename", fileInfoFileName);
                response.addHeader("Content-Transfer-Encodingsdasda", "binary");
                response.setContentType("application/octet-stream");
                logger.debug(" file not mail is in pg .... " + fileInfo.getFileName() + "...." + fileInfo.getFilePath());
                List list = fileInfo.getChunkFiles();
                Collections.sort(list);
                String deviceTempPath = isSync ? PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloud.getCloudName()) + fileInfo.getDeviceUUID() : PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloud.getCloudName()) + fileInfo.getDeviceUUID();
                if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
                    deviceTempPath = deviceTempPath + "/" + fileInfo.getBatchId();
                }
                String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
                logger.debug(PCHelperConstant.getComponentName() + "....file in blukrypt..." + fileInfo.getGatewayName());
                if (StringUtils.isEmpty((String)fileInfo.getGatewayName()) || PCHelperConstant.getComponentName().equalsIgnoreCase(fileInfo.getGatewayName())) {
                    for (String chunkName : list) {
                        int endIndex;
                        if (!isSync && !StringUtils.isEmpty((String)chunkName) && chunkName.startsWith("part") && (endIndex = chunkName.lastIndexOf(46)) != -1) {
                            chunkName = chunkName.substring(0, endIndex);
                        }
                        logger.debug(" file from pg.................." + chunkName);
                        String filePath = chunkFilePath + "/" + chunkName;
                        File file = new File(filePath);
                        if (file.exists()) {
                            long size = file.length();
                            logger.debug(size + " file from pg.size................." + filePath);
                            this.writeDataToStreamFromPg(response, file, fileInfo);
                            continue;
                        }
                        logger.error(" file does not exists........" + filePath);
                    }
                } else {
                    logger.debug(" file from different pg.................." + fileInfo.getGatewayName());
                    for (String chunkName : list) {
                        int endIndex;
                        if (!isSync && !StringUtils.isEmpty((String)chunkName) && chunkName.startsWith("part") && (endIndex = chunkName.lastIndexOf(46)) != -1) {
                            chunkName = chunkName.substring(0, endIndex);
                        }
                        logger.debug(" file from pg.................." + chunkName);
                        String filePath = chunkFilePath + "/" + chunkName;
                        HttpComponentsClientHttpRequestFactory reqFactory = HttpClientUtil.getHttpRequestFactory();
                        reqFactory.setConnectTimeout(15000);
                        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
                        ArrayList<Object> messageConverters = new ArrayList<Object>();
                        messageConverters.add(new MappingJackson2HttpMessageConverter());
                        messageConverters.add(new ByteArrayHttpMessageConverter());
                        restTemplate.setMessageConverters(messageConverters);
                        HttpHeaders headers = new HttpHeaders();
                        String backupId = fileInfo.getId().toString();
                        headers.add(BACKUP_ID, backupId);
                        headers.add(CLOUD_NAME, cloud.getCloudName());
                        org.springframework.http.HttpEntity entity = new org.springframework.http.HttpEntity((Object)PARAMETERS, (MultiValueMap)headers);
                        restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
                        messageConverters = new ArrayList();
                        messageConverters.add(new ByteArrayHttpMessageConverter());
                        messageConverters.add(new StringHttpMessageConverter());
                        messageConverters.add(new ResourceHttpMessageConverter());
                        messageConverters.add(new SourceHttpMessageConverter());
                        messageConverters.add(new AllEncompassingFormHttpMessageConverter());
                        restTemplate.setMessageConverters(messageConverters);
                        headers = new HttpHeaders();
                        headers.add(FILEPATH, filePath);
                        headers.setAccept(Arrays.asList(MediaType.APPLICATION_OCTET_STREAM));
                        entity = new org.springframework.http.HttpEntity((Object)PARAMETERS, (MultiValueMap)headers);
                        String url = PREFIX_HTTPS + fileInfo.getGatewayName() + BLUKRYPT_BUILDER_DOWNLOAD_FROM_PG;
                        if (PCHelperConstant.isHttpEnabled()) {
                            url = PREFIX_HTTP + fileInfo.getGatewayName() + BLUKRYPT_BUILDER_DOWNLOAD_FROM_PG;
                        }
                        logger.debug(" downloadpgBkpList pg url .............." + url);
                        try {
                            ResponseEntity resultObj = restTemplate.exchange(url, HttpMethod.GET, entity, byte[].class, new Object[]{"1"});
                            byte[] bytes = (byte[])resultObj.getBody();
                            if (resultObj.getStatusCode().equals((Object)HttpStatus.NO_CONTENT)) {
                                logger.error("...no content ....");
                                break;
                            }
                            logger.debug("...file exists in diff pg ");
                            ByteArrayInputStream input = new ByteArrayInputStream(bytes);
                            this.writeDataToStreamFromPg(response, input, fileInfo, chunkName);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            logger.error(" error trying to download ..." + e);
                            break;
                        }
                    }
                }
                logger.debug(" before returning.........");
            }
            catch (UnsupportedEncodingException e) {
                logger.trace("" + e);
                logger.error("" + e.getMessage());
            }
        }
    }

    private void writeDataToStreamFromPg(HttpServletResponse response, InputStream inputStream, FileInfo fileInfo, String fileName) {
        try {
            int buff;
            logger.debug(SENDING_FILE + fileName);
            InputStream fif = inputStream;
            logger.debug(IS_COMPRESSED + fileInfo.isCompressed());
            if (fileInfo.isCompressed()) {
                fif = new GZIPInputStream(fif);
            }
            byte[] b = new byte[4096];
            while ((buff = fif.read(b)) != -1) {
                response.getOutputStream().write(b, 0, buff);
            }
            fif.close();
            response.getOutputStream().flush();
            logger.debug(FINISHED_FILE + fileName);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(" error trying to send ...." + e.getMessage());
        }
    }

    private void restoreMailFromPG(String cloudName, HttpServletResponse response, FileInfo fileInfo, String browserType) {
        boolean isSync = false;
        if (fileInfo != null) {
            String fileInfoFileName = fileInfo.getFileName() + ".eml";
            Long filesize = fileInfo.getSize();
            response.addHeader("Pragma", "public");
            response.addHeader("Expires", String.valueOf(200));
            response.addHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            String encodedFilename = fileInfoFileName;
            try {
                encodedFilename = URLEncoder.encode(fileInfoFileName, UTF8).replace("+", "%20");
                if (browserType.contains("Firefox")) {
                    response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + encodedFilename);
                } else if (browserType.contains("Chrome")) {
                    response.setHeader("Content-Disposition", "attachment; filename=" + encodedFilename);
                } else {
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + fileInfoFileName + "\"");
                }
                response.addHeader("Content-Transfer-Encoding", "binary");
                response.addHeader("Content-Length", String.valueOf(17215));
                response.addHeader("filename", fileInfoFileName);
                response.addHeader("Content-Transfer-Encodingsdasda", "binary");
                response.setContentType("application/octet-stream");
                logger.debug(" file  mail is in pg .... " + fileInfo.getFileName() + "...." + fileInfo.getFilePath());
                List list = fileInfo.getChunkFiles();
                Collections.sort(list);
                String deviceTempPath = isSync ? PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + fileInfo.getDeviceUUID() : PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
                if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
                    deviceTempPath = deviceTempPath + "/" + fileInfo.getBatchId();
                }
                String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
                for (String chunkName : list) {
                    int endIndex;
                    if (!StringUtils.isEmpty((String)chunkName) && chunkName.startsWith("part") && (endIndex = chunkName.lastIndexOf(46)) != -1) {
                        chunkName = chunkName.substring(0, endIndex);
                    }
                    chunkName = "9a325948ff850170662f004a782b139f";
                    logger.debug(" file from pg.................." + chunkName);
                    String filePath = chunkFilePath + "/" + chunkName;
                    File file = new File(filePath);
                    if (file.exists()) {
                        long size = file.length();
                        logger.debug(size + " file from pg.size................." + filePath);
                        this.writeDataToStreamFromPg(response, file, fileInfo);
                        continue;
                    }
                    logger.error(" file does not exists........" + filePath);
                }
                logger.debug(" before returning.........");
            }
            catch (UnsupportedEncodingException e) {
                logger.trace("" + e);
                logger.error("" + e.getMessage());
            }
        }
    }

    private void restoreMailFromPG(String cloudName, HttpServletResponse response, FileInfo fileInfo, String browserType, String attachmentId) {
        if (fileInfo != null && StringUtils.isEmpty((String)attachmentId)) {
            String fileInfoFileName = fileInfo.getFileName() + ".eml";
            Long filesize = fileInfo.getSize();
            response.addHeader("Pragma", "public");
            response.addHeader("Expires", String.valueOf(200));
            response.addHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            String encodedFilename = fileInfoFileName;
            try {
                encodedFilename = URLEncoder.encode(fileInfoFileName, UTF8).replace("+", "%20");
                if (browserType.contains("Firefox")) {
                    response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + encodedFilename);
                } else if (browserType.contains("Chrome")) {
                    response.setHeader("Content-Disposition", "attachment; filename=" + encodedFilename);
                } else {
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + fileInfoFileName + "\"");
                }
                response.addHeader("Content-Transfer-Encoding", "binary");
                response.addHeader("filename", fileInfoFileName);
                response.addHeader("Content-Transfer-Encodingsdasda", "binary");
                response.setContentType("application/octet-stream");
                logger.debug(" file mail is in pg .... " + fileInfo.getFileName() + "...." + fileInfo.getFilePath());
                List list = fileInfo.getChunkFiles();
                Collections.sort(list);
                String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
                if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
                    deviceTempPath = deviceTempPath + "/" + fileInfo.getBatchId();
                }
                String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
                logger.debug(" file mail sssssss from pg.................." + encodedFilename);
                File tempdownloadDir = new File(chunkFilePath);
                if (!tempdownloadDir.exists()) {
                    tempdownloadDir.mkdirs();
                }
                String filePath1 = chunkFilePath + "/" + encodedFilename;
                try {
                    Properties p = System.getProperties();
                    Session session = Session.getInstance((Properties)p);
                    for (String chunkName : list) {
                        int endIndex;
                        if (!StringUtils.isEmpty((String)chunkName) && chunkName.startsWith("part") && (endIndex = chunkName.lastIndexOf(46)) != -1) {
                            chunkName = chunkName.substring(0, endIndex);
                        }
                        logger.debug(" file from pg ss.................." + chunkName);
                        String filePath = chunkFilePath + "/" + chunkName;
                        File file = new File(filePath);
                        if (file.exists()) {
                            long size = file.length();
                            logger.debug(size + " file from pg.size................." + filePath);
                            this.writeDataToStreamFromPg(response, file, fileInfo);
                            continue;
                        }
                        logger.error(" file does not exists........" + filePath);
                    }
                }
                catch (Exception e) {
                    logger.error(".... exception......" + e.getMessage());
                }
                logger.debug(" before returning.........");
            }
            catch (UnsupportedEncodingException e) {
                logger.trace("" + e);
                logger.error("" + e.getMessage());
            }
        } else {
            logger.debug(".trying to download attachment ..." + attachmentId);
            boolean isSync = false;
            Long filesize = fileInfo.getSize();
            List attlist = fileInfo.getAttachments();
            String fileInfoFileName = fileInfo.getFileName();
            String chunk = "";
            for (MailAttachment attachment : attlist) {
                if (!attachment.getId().equalsIgnoreCase(attachmentId)) continue;
                fileInfoFileName = attachment.getName();
                chunk = (String)attachment.getChunkFiles().get(0);
                filesize = (long)attachment.getSize();
            }
            logger.debug(chunk + "....trying to download attachment  name..." + fileInfoFileName);
            ArrayList<String> list = new ArrayList<String>();
            list.add(chunk);
            Collections.sort(list);
            response.addHeader("Pragma", "public");
            response.addHeader("Expires", String.valueOf(200));
            response.addHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            String encodedFilename = fileInfoFileName;
            try {
                encodedFilename = URLEncoder.encode(fileInfoFileName, UTF8).replace("+", "%20");
                if (browserType.contains("Firefox")) {
                    response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + encodedFilename);
                } else if (browserType.contains("Chrome")) {
                    response.setHeader("Content-Disposition", "attachment; filename=" + encodedFilename);
                } else {
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + fileInfoFileName + "\"");
                }
                response.addHeader("Content-Transfer-Encoding", "binary");
                response.addHeader("filename", fileInfoFileName);
                response.addHeader("Content-Transfer-Encodingsdasda", "binary");
                response.setContentType("application/octet-stream");
                logger.debug(" file not mail is in pg .... " + fileInfo.getFileName() + "...." + fileInfo.getFilePath());
                String deviceTempPath = isSync ? PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + fileInfo.getDeviceUUID() : PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
                if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
                    deviceTempPath = deviceTempPath + "/" + fileInfo.getBatchId();
                }
                String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
                for (String chunkName : list) {
                    int endIndex;
                    if (!isSync && !StringUtils.isEmpty((String)chunkName) && chunkName.startsWith("part") && (endIndex = chunkName.lastIndexOf(46)) != -1) {
                        chunkName = chunkName.substring(0, endIndex);
                    }
                    logger.debug(" file from pg.................." + chunkName);
                    String filePath = chunkFilePath + "/" + chunkName;
                    File file = new File(filePath);
                    if (file.exists()) {
                        long size = file.length();
                        response.addHeader("Content-Length", String.valueOf(size));
                        logger.debug(size + " file from pg.size................." + filePath);
                        this.writeDataToStreamFromPg(response, file, fileInfo);
                        continue;
                    }
                    logger.error(" file does not exists........" + filePath);
                }
                logger.debug(" before returning.........");
            }
            catch (UnsupportedEncodingException e) {
                logger.trace("" + e);
                logger.error("" + e.getMessage());
            }
        }
    }

    private static MimeMessage convertToMimeMessage(FileInfo fileInfo) throws Exception {
        Properties p = System.getProperties();
        Session session = Session.getInstance((Properties)p);
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setSubject(fileInfo.getSubject());
        mimeMessage.setSentDate(fileInfo.getSentDate());
        InternetAddress fromMailbox = new InternetAddress();
        if (fileInfo.getFromEmailAddress() != null) {
            fromMailbox.setAddress(fileInfo.getFromEmailAddress().getAddress());
            if (fileInfo.getFromEmailAddress() != null) {
                fromMailbox.setPersonal(fileInfo.getFromEmailAddress().getName());
            } else {
                fromMailbox.setPersonal(fileInfo.getFromEmailAddress().getName());
            }
        }
        mimeMessage.setFrom((Address)fromMailbox);
        fileInfo.getCcRecipientsAddress().forEach(ccrec -> {
            try {
                mimeMessage.setRecipient(Message.RecipientType.CC, (Address)new InternetAddress(ccrec.getAddress(), ccrec.getName()));
            }
            catch (Exception e) {
                logger.error(".... exception......" + e.getMessage());
            }
        });
        fileInfo.getBccRecipientsAddress().forEach(bccrec -> {
            try {
                mimeMessage.setRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bccrec.getAddress(), bccrec.getName()));
            }
            catch (Exception e) {
                logger.error(".... exception......" + e.getMessage());
            }
        });
        fileInfo.getToRecipientsAddress().forEach(torec -> {
            try {
                mimeMessage.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(torec.getAddress(), torec.getName()));
            }
            catch (Exception e) {
                logger.error(".... exception......" + e.getMessage());
            }
        });
        MimeMultipart rootMultipart = new MimeMultipart();
        MimeMultipart contentMultipart = new MimeMultipart();
        MimeBodyPart contentBodyPart = new MimeBodyPart();
        contentBodyPart.setContent((Multipart)contentMultipart);
        MimeBodyPart htmlBodyPart = new MimeBodyPart();
        htmlBodyPart.setContent((Object)fileInfo.getBodyContent(), "text/html; charset=utf-8");
        contentMultipart.addBodyPart((BodyPart)htmlBodyPart);
        rootMultipart.addBodyPart((BodyPart)contentBodyPart);
        mimeMessage.setContent((Multipart)rootMultipart);
        return mimeMessage;
    }

    private static void addAttachments(FileInfo fileInfo, MimeMessage mimeMessage, MimeMultipart rootMultipart) throws MessagingException {
        if (!CollectionUtils.isEmpty((Collection)fileInfo.getAttachments())) {
            for (MailAttachment attachment : fileInfo.getAttachments()) {
                if (attachment == null) continue;
                MimeBodyPart attachmentBodyPart = new MimeBodyPart();
                attachmentBodyPart.setFileName(attachment.getName());
                rootMultipart.addBodyPart((BodyPart)attachmentBodyPart);
            }
            mimeMessage.setContent((Multipart)rootMultipart);
        }
    }

    private void writeDataToStreamFromPg(HttpServletResponse response, File file, FileInfo fileInfo) {
        try {
            int buff;
            logger.debug(SENDING_FILE + file.getName());
            FileInputStream fis = new FileInputStream(file);
            FilterInputStream fif = new BufferedInputStream(fis);
            logger.debug(IS_COMPRESSED + fileInfo.isCompressed());
            if (fileInfo.isCompressed()) {
                fif = new GZIPInputStream(fif);
            }
            byte[] b = new byte[4096];
            while ((buff = ((InputStream)fif).read(b)) != -1) {
                response.getOutputStream().write(b, 0, buff);
            }
            ((InputStream)fif).close();
            response.getOutputStream().flush();
            logger.debug(FINISHED_FILE + file.getName());
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(" error trying to send ...." + e.getMessage());
        }
    }

    @Override
    public void downloadFileFromPGForPortal(Cloud cloud, HttpServletResponse response, FileInfo fileInfo, String browserType, String attachmentId, String userName, com.pg.domain.BackupFile backupFile) {
        logger.debug("...download file...." + fileInfo);
        if (fileInfo.isClientDedupEnabled()) {
            this.restoreClientDedupFileForPortal(cloud, response, fileInfo, false, browserType, userName, backupFile);
        } else if (!StringUtils.isEmpty((String)fileInfo.getSubject()) || !StringUtils.isEmpty((String)fileInfo.getBodyContent())) {
            this.restoreMailFromPG(cloud.getCloudName(), response, fileInfo, browserType, attachmentId);
        } else {
            this.restoreFromPG(cloud, response, fileInfo, false, browserType, userName);
        }
    }

    private void restoreClientDedupFileForPortal(Cloud cloud, HttpServletResponse response, FileInfo fileInfo, boolean isSync, String browserType, String userName, com.pg.domain.BackupFile backupFile) {
        String fileInfoFileName = fileInfo.getFileName();
        Long filesize = fileInfo.getSize();
        response.addHeader("Pragma", "public");
        response.addHeader("Expires", String.valueOf(200));
        response.addHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        String encodedFilename = fileInfoFileName;
        String backupId = fileInfo.getId();
        try {
            encodedFilename = URLEncoder.encode(fileInfoFileName, UTF8).replace("+", "%20");
            if (browserType.contains("Firefox")) {
                response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + encodedFilename);
            } else if (browserType.contains("Chrome")) {
                response.setHeader("Content-Disposition", "attachment; filename=" + encodedFilename);
            } else {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + fileInfoFileName + "\"");
            }
            response.addHeader("Content-Transfer-Encoding", "binary");
            response.addHeader("Content-Length", String.valueOf(filesize));
            response.addHeader("filename", fileInfoFileName);
            response.addHeader("Content-Transfer-Encodingsdasda", "binary");
            response.setContentType("application/octet-stream");
            logger.debug(" file is in pg .... " + fileInfo.getFileName() + "...." + fileInfo.getFilePath());
            List list = fileInfo.getChunkFiles();
            Collections.sort(list);
            String deviceTempPath = isSync ? PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloud.getCloudName()) + fileInfo.getDeviceUUID() : PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloud.getCloudName()) + fileInfo.getDeviceUUID();
            if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
                deviceTempPath = deviceTempPath + "/" + fileInfo.getBatchId();
            }
            String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
            GraphServiceClient<Request> graphClient = null;
            OkHttpClient okHttpClient = null;
            boolean isODBEnabled = this.isODBEnabled(cloud.getCloudCustomisableDetails());
            if (isODBEnabled && cloud.getGraphApiEnabled() == 1) {
                graphClient = OneDriveUtil.getGraphClient();
                okHttpClient = Graph.getInstance().getOkHttpClient();
            }
            for (String chunkName : list) {
                int endIndex;
                String syncDecryptKey = SYNC_DECRYPT_KEY;
                String productType = PRODUCT_TYPE_SYNC;
                String dedupVal = this.getDedupValue(userName, isSync);
                String md5 = SyncDownloadServiceImpl.getMd5FromFileName(chunkName);
                logger.debug("..before chunk detail...." + userName + "...." + dedupVal + "...ch..." + md5);
                ChunkDetail chunkDetail = null;
                List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, md5, dedupVal, userName, true, false);
                if (CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                    logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                    chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, md5, dedupVal, userName, true, true);
                }
                if (!CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                    for (ChunkDetail detailFromDB : chunkDetailList) {
                        if (detailFromDB.getRefCount() <= 0 && detailFromDB.getClientDedupRefCount() <= 0) continue;
                        chunkDetail = detailFromDB;
                    }
                }
                if (chunkDetail == null) {
                    logger.debug(CHUNK_DETAILS_NULL);
                    break;
                }
                if (!chunkDetail.isPreEntry()) {
                    File decryptedFile;
                    String saltKeyTemp;
                    String path = isSync ? PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloud.getCloudName()) + fileInfo.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + TEMP_DOWNLOAD_SYNC : PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloud.getCloudName()) + fileInfo.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
                    File tempdownloadDir = new File(path);
                    if (!tempdownloadDir.exists()) {
                        tempdownloadDir.mkdirs();
                    }
                    BufferedInputStream inputStream = null;
                    com.pg.domain.ChunkFile chunkFile = new com.pg.domain.ChunkFile();
                    logger.debug(CLOUD_CHUNK_NAME + chunkDetail.getCloudChunkName());
                    String containerName = null;
                    try {
                        if (!isSync) {
                            containerName = chunkDetail.getContainerName();
                        }
                        StringBuilder fileNameToDownload = new StringBuilder();
                        fileNameToDownload.append(chunkDetail.getCloudChunkName());
                        int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
                        if (occurance == 0 || occurance == 1 && list.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                            fileNameToDownload.append(".").append(backupId);
                        }
                        if (chunkDetail != null) {
                            containerName = chunkDetail.getContainerName();
                            if (!StringUtils.isEmpty((String)chunkDetail.getCloudStoragePath())) {
                                chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                            }
                            syncDecryptKey = chunkDetail.getUserName();
                        }
                        chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                        chunkFile.setEncodedName(chunkDetail.getEncodedName());
                        chunkFile.setFileId(chunkDetail.getId().toString());
                        chunkFile.setfSPath(chunkDetail.getFsPath());
                        chunkFile.setUploadedTimeStamp(chunkDetail.getChunkCreatedTime());
                        chunkFile.setFileName(chunkDetail.getCloudChunkName());
                        chunkFile.setMd5(chunkDetail.getMd5());
                        boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
                        String fileToDownload = fileNameToDownload.toString();
                        if (isGDEnabled) {
                            fileToDownload = chunkDetail.getCloudChunkName();
                            logger.debug(fileNameToDownload.toString() + "....chunk fileid... " + chunkDetail.getCloudChunkName());
                        }
                        logger.debug(chunkFile.getCloudStoragePath() + LOOP_BEFORE_DOWNLOAD_FILE + fileToDownload + " ..new");
                        FileStatusElement fileStatusElement = new FileStatusElement();
                        inputStream = this.cloudSupportService.downloadFile(cloud, tempdownloadDir.getPath(), fileToDownload, userName, backupFile.getDeviceUUID(), containerName, chunkFile, isSync, backupFile, fileStatusElement, chunkDetail.getUserName(), chunkDetail, "", graphClient, okHttpClient);
                        if (inputStream == null) {
                            return;
                        }
                    }
                    catch (Exception e) {
                        logger.trace("" + e);
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException e1) {
                            logger.trace("" + e1);
                            logger.error(EXCEPTION_WHILE_DOWNLOADING_FILE_FROM_CLOUD + e1.getMessage());
                        }
                        logger.error(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                        throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
                    }
                    logger.debug("..isSync Value>>>>>" + isSync);
                    if (fileInfo.isSync()) {
                        saltKeyTemp = this.getEncryptOrDecryptKey(cloud.getCloudId(), chunkFile.getUploadedTimeStamp(), productType);
                        decryptedFile = this.getDecryptedFile(cloud.getCloudName(), saltKeyTemp, backupFile.getDeviceUUID(), chunkFile.getFileName(), inputStream, userName, syncDecryptKey);
                    } else {
                        saltKeyTemp = this.getEncryptOrDecryptKey(cloud.getCloudId(), chunkDetail.getChunkCreatedTime(), BACKUP);
                        logger.debug(userName + "...users...." + chunkDetail.getUserName());
                        decryptedFile = this.downloadService.getDecryptedFileForPortal(cloud.getCloudName(), saltKeyTemp, backupFile.getDeviceUUID(), chunkFile.getFileName(), inputStream, chunkDetail.getUserName(), path, chunkFile, cloud.getCloudId(), chunkDetail);
                    }
                    backupFile.setCompressed(fileInfo.isCompressed());
                    this.writeDataToStream(response, decryptedFile, backupFile);
                    continue;
                }
                if (!chunkDetail.isPreEntry()) continue;
                logger.debug("Chunk detail it is pre-entry....");
                if (!isSync && !StringUtils.isEmpty((String)chunkName) && chunkName.startsWith("part") && (endIndex = chunkName.lastIndexOf(46)) != -1) {
                    chunkName = chunkName.substring(0, endIndex);
                }
                logger.debug(" file from pg.................." + chunkName);
                String filePath = chunkDetail.getFsPath();
                File file = new File(filePath);
                if (file.exists()) {
                    long size = file.length();
                    logger.debug(size + " file from pg.size................." + filePath);
                    this.writeDataToStreamFromPg(response, file, fileInfo);
                    continue;
                }
                logger.error(" file does not exists........" + filePath);
            }
            logger.debug(" before returning.........");
        }
        catch (UnsupportedEncodingException e) {
            logger.trace("" + e);
            logger.error("" + e.getMessage());
        }
    }

    private boolean checkMd51(int cloudId, String md5ofChunk) {
        boolean isMd5same = false;
        List rwlist = this.fileDao.getRWSampleFilesList(cloudId);
        for (String md51 : rwlist) {
            if (!md5ofChunk.equalsIgnoreCase(md51)) continue;
            isMd5same = true;
            break;
        }
        return isMd5same;
    }

    @Override
    public boolean downloadFileFromCloudForPortal(Cloud cloud, String cloudName, String userName, com.pg.domain.BackupFile backupFile, List<String> nameList, String saltKey, HttpServletResponse response, boolean fileExists, boolean isSync) {
        return this.downloadFileFromCloud(cloud, cloudName, userName, backupFile, nameList, saltKey, response, fileExists, isSync);
    }

    private String getDedupValue(String userName, boolean isSync) {
        String dedupVal = null;
        int cloudId = 1;
        com.parablu.pcbd.domain.User user = this.utilService.getUserInfoByName(1, userName);
        if (user != null && !StringUtils.isEmpty((String)user.getPolicyName())) {
            BackupPolicy backupPolicy = this.utilService.getBackupPolicy(cloudId, user.getPolicyName());
            dedupVal = backupPolicy.getDedup();
        } else if (isSync && user != null && !StringUtils.isEmpty((String)user.getSyncPolicyName())) {
            SyncPolicy syncPolicy = this.userDao.getSyncPolicyByPolicyName(1, user.getSyncPolicyName());
            dedupVal = syncPolicy.getDedup();
        }
        return dedupVal;
    }

    private String getDedupValueByUserName(String userName) {
        String dedupVal = null;
        int cloudId = 1;
        String syncPolicyName = this.userDao.getSyncPolicyNameByUserName(cloudId, userName);
        if (!StringUtils.isEmpty((String)syncPolicyName)) {
            SyncPolicy syncPolicy = this.utilService.getSyncPolicy(cloudId, syncPolicyName);
            dedupVal = syncPolicy.getDedup();
        }
        return dedupVal;
    }

    @Override
    public void downloadFolderFromCloudForPortal(Cloud cloud, String cloudName, String userName, HttpServletResponse response, boolean isSync, DownloadFileTO downloadFileTO, DownloadTO downloadTO) {
        this.downloadZipFileFromCloudForPortal(cloud, cloudName, userName, response, isSync, downloadFileTO, downloadTO);
    }

    private void downloadZipFileFromCloudForPortal(Cloud cloud, String cloudName, String userName, HttpServletResponse response, boolean isSyncEnabled, DownloadFileTO downloadFileTO, DownloadTO downloadTO) {
        boolean isSync = isSyncEnabled;
        BufferedInputStream inputStream = null;
        String deviceUUID = downloadFileTO.getDeviceUUID();
        Device device = this.utilService.getDeviceForUUID(cloud.getCloudId(), deviceUUID);
        int cloudId = cloud.getCloudId();
        String path = isSync ? PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + TEMP_DOWNLOAD_SYNC : PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File tempdownloadDir = new File(path);
        if (!tempdownloadDir.exists()) {
            tempdownloadDir.mkdirs();
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(baos);
            FileInputStream copyFileInput = null;
            long folderSize = 0L;
            ArrayList<BackUpImage> backupImageList = new ArrayList<BackUpImage>();
            BackUpImage backupImage = this.externalStorageBackupFileDao.getBackupFileById(cloudId, device, downloadFileTO.getBackupID(), true);
            if (backupImage != null) {
                backupImageList.add(backupImage);
            }
            ArrayList<BackUpImage> backupImages = new ArrayList<BackUpImage>();
            if (!StringUtils.isEmpty((String)downloadFileTO.getFilePath())) {
                this.getAllFolderChildrenByDevicePath(cloudName, userName, backupImage.getDevicePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupImage.getFileName(), device, cloudId, backupImages);
            } else {
                this.getAllFolderChildrenByDevicePath(cloudName, userName, backupImage.getFileName(), device, cloudId, backupImages);
            }
            backupImageList.addAll(backupImages);
            if (!CollectionUtils.isEmpty(backupImageList)) {
                for (BackUpImage backupImagedata : backupImageList) {
                    List backupImagesFolderFile = new ArrayList();
                    backupImagesFolderFile = StringUtils.isNotEmpty((String)backupImagedata.getDevicePath()) ? this.externalStorageBackupFileDao.getBackupFilesForBasePath(cloudId, cloudName, userName, device, backupImagedata.getDevicePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupImagedata.getFileName(), true) : this.externalStorageBackupFileDao.getBackupFilesForBasePath(cloudId, cloudName, userName, device, backupImagedata.getFileName(), true);
                    if (CollectionUtils.isEmpty(backupImagesFolderFile)) continue;
                    folderSize = this.restoreBackupFolder(cloud, cloudName, userName, response, downloadFileTO, isSync, inputStream, deviceUUID, cloudId, path, tempdownloadDir, backupImagesFolderFile, folderSize, zos, copyFileInput);
                }
            }
            try {
                zos.close();
                baos.close();
                ServletOutputStream op = response.getOutputStream();
                op.write(baos.toByteArray());
                op.flush();
            }
            catch (IOException e) {
                logger.error("Exception" + e.getMessage());
            }
            downloadTO.setSize(folderSize);
        }
        catch (Exception e) {
            logger.error("Exception" + e.getMessage());
            logger.trace("Exception" + e);
        }
    }

    private void getAllFolderChildrenByDevicePath(String cloudName, String userName, String filePath, Device device, int cloudId, List<BackUpImage> backupImages) {
        List backUpImagesTemp = this.externalStorageBackupFileDao.getBackupFolderForBasePath(cloudId, cloudName, userName, device, filePath, true);
        backupImages.addAll(backUpImagesTemp);
        if (!CollectionUtils.isEmpty((Collection)backUpImagesTemp)) {
            Stream stream = backUpImagesTemp.parallelStream();
            stream.forEach(backUpImage -> {
                String devicePath = backUpImage.getDevicePath() + "/" + backUpImage.getFileName();
                logger.debug("Inside loop after getting folders..bkpimages list size:" + backUpImagesTemp.size());
                if (StringUtils.isEmpty((String)backUpImage.getDevicePath())) {
                    devicePath = backUpImage.getFileName();
                }
                logger.debug("Inside loop to get immediate folders deevicePath:" + devicePath);
                this.getAllFolderChildrenByDevicePath(cloudName, userName, devicePath, device, cloudId, backupImages);
            });
        }
    }

    private long restoreBackupFolder(Cloud cloud, String cloudName, String userName, HttpServletResponse response, DownloadFileTO downloadFileTO, boolean isSync, BufferedInputStream inputStream, String deviceUUID, int cloudId, String path, File tempdownloadDir, List<BackUpImage> backupImages, long folderSize, ZipOutputStream zos, FileInputStream copyFileInput) {
        ArrayList<com.pg.domain.BackupFile> backupFiles = new ArrayList<com.pg.domain.BackupFile>();
        ArrayList<com.pg.domain.BackupFile> backupFilesForPg = new ArrayList<com.pg.domain.BackupFile>();
        for (BackUpImage backupImage : backupImages) {
            com.pg.domain.BackupFile backupFileData = new com.pg.domain.BackupFile();
            if (StringUtils.isNotEmpty((String)backupImage.getStoragePlace()) && backupImage.getStoragePlace().equalsIgnoreCase("CLOUD") && !CollectionUtils.isEmpty((Collection)backupImage.getChunkFiles()) && backupImage.getChunkFiles().size() > 0) {
                this.convertBackupImageToBackupFile(backupImage, backupFileData);
                backupFiles.add(backupFileData);
            } else {
                this.convertBackupImageToBackupFile(backupImage, backupFileData);
                backupFileData.setId(backupImage.getId().toString());
                backupFilesForPg.add(backupFileData);
            }
            if (backupImage.getSizeInBytes() != 0L) {
                folderSize += backupImage.getSizeInBytes();
                continue;
            }
            folderSize += backupImage.getSize();
        }
        this.restoreBackupFolder(cloud, cloudName, userName, response, downloadFileTO, isSync, inputStream, deviceUUID, cloudId, path, tempdownloadDir, backupFiles, backupFilesForPg, zos, copyFileInput);
        return folderSize;
    }

    private void convertBackupImageToBackupFile(BackUpImage backupImage, com.pg.domain.BackupFile backupFileData) {
        BeanUtils.copyProperties((Object)backupImage, (Object)backupFileData);
        ArrayList<com.pg.domain.ChunkFile> chunkList = new ArrayList<com.pg.domain.ChunkFile>();
        for (ChunkFile chunkFile : backupImage.getChunkFiles()) {
            com.pg.domain.ChunkFile file = new com.pg.domain.ChunkFile();
            BeanUtils.copyProperties((Object)chunkFile, (Object)file);
            chunkList.add(file);
        }
        backupFileData.setChunkFiles(chunkList);
        backupFileData.setFilePath(backupImage.getDevicePath());
    }

    private void restoreBackupFolder(Cloud cloud, String cloudName, String userName, HttpServletResponse response, DownloadFileTO downloadFileTO, boolean isSync, BufferedInputStream inputStream, String deviceUUID, int cloudId, String path, File tempdownloadDir, List<com.pg.domain.BackupFile> backupFiles, List<com.pg.domain.BackupFile> backupFilesForPg, ZipOutputStream zos, FileInputStream copyFileInput) {
        String saltKeyTemp = "";
        for (com.pg.domain.BackupFile backupFilePg : backupFilesForPg) {
            FileInfo fileInfo = this.fileDao.getFileFromPG(userName, cloudName, backupFilePg.getId(), isSync);
            if (fileInfo == null) continue;
            String filePath = fileInfo.getFilePath();
            filePath = filePath.replace("\\", "/");
            fileInfo.setFilePath(filePath);
            this.downloadZipFileFromPGForPortal(cloudName, response, fileInfo, isSync, zos, copyFileInput, downloadFileTO);
        }
        for (com.pg.domain.BackupFile backupFile : backupFiles) {
            String folderPath = "";
            String replaceValue = "";
            if (StringUtils.isNotEmpty((String)downloadFileTO.getFilePath())) {
                folderPath = downloadFileTO.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            } else {
                folderPath = ":";
                replaceValue = "_DRIVE";
            }
            String backupFileName = backupFile.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupFile.getFileName();
            String fileName = backupFileName.replaceAll(folderPath, replaceValue);
            ZipEntry zipEntry = new ZipEntry(fileName);
            List chunkFilesList = backupFile.getChunkFiles();
            int totalChunks = chunkFilesList.size();
            Collections.sort(chunkFilesList, new Comparator<com.pg.domain.ChunkFile>(){

                @Override
                public int compare(com.pg.domain.ChunkFile c1, com.pg.domain.ChunkFile c2) {
                    if (c1 == null || c2 == null || c1.getFileName() == null || c2.getFileName() == null) {
                        return -1;
                    }
                    return new CompareToBuilder().append((Object)c1.getFileName().toLowerCase(), (Object)c2.getFileName().toLowerCase()).toComparison();
                }
            });
            try {
                zos.putNextEntry(zipEntry);
            }
            catch (IOException e) {
                logger.error("Exception" + e.getMessage());
            }
            GraphServiceClient<Request> graphClient = null;
            OkHttpClient okHttpClient = null;
            if (cloud.getGraphApiEnabled() == 1) {
                graphClient = OneDriveUtil.getGraphClient();
                okHttpClient = Graph.getInstance().getOkHttpClient();
            }
            for (com.pg.domain.ChunkFile chunkFile : chunkFilesList) {
                logger.debug("chunk file-------" + chunkFile.toString());
                String syncDecryptKey = SYNC_DECRYPT_KEY;
                String productType = PRODUCT_TYPE_SYNC;
                logger.debug("chunkFilesList userName-------" + userName);
                String dedupVal = this.getDedupValue(userName, isSync);
                logger.debug("..before chunk detail...." + userName + "...." + dedupVal + "...ch..." + chunkFile.getMd5());
                ChunkDetail chunkDetail = null;
                List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, false);
                if (CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                    logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                    chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, true);
                }
                if (!CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                    for (ChunkDetail detailFromDB : chunkDetailList) {
                        if (detailFromDB.getRefCount() <= 0 && detailFromDB.getClientDedupRefCount() <= 0) continue;
                        chunkDetail = detailFromDB;
                    }
                }
                try {
                    if (chunkDetail == null) {
                        logger.debug(CHUNK_DETAILS_NULL);
                        chunkDetail = new ChunkDetail();
                        chunkDetail.setCloudChunkName(chunkFile.getFileName());
                        chunkDetail.setUserName(userName);
                        chunkDetail.setContainerName(userName.toLowerCase());
                        chunkDetail.setMd5(chunkFile.getMd5());
                    }
                    logger.debug(CLOUD_CHUNK_NAME + chunkDetail.getCloudChunkName());
                    String backupId = backupFile.getId();
                    String containerName = null;
                    if (!isSync) {
                        containerName = chunkDetail.getContainerName();
                    }
                    StringBuilder fileNameToDownload = new StringBuilder();
                    fileNameToDownload.append(chunkDetail.getCloudChunkName());
                    int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
                    if (occurance == 0 || occurance == 1 && chunkFilesList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                        fileNameToDownload.append(".").append(backupId);
                    }
                    if (chunkDetail != null) {
                        containerName = chunkDetail.getContainerName();
                        if (!StringUtils.isEmpty((String)chunkDetail.getCloudStoragePath())) {
                            chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                        }
                        syncDecryptKey = chunkDetail.getUserName();
                    }
                    com.pg.domain.ChunkFile pgChunkFile = new com.pg.domain.ChunkFile();
                    BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
                    boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
                    String fileToDownload = fileNameToDownload.toString();
                    if (isGDEnabled) {
                        fileToDownload = chunkDetail.getCloudChunkName();
                        logger.debug(fileNameToDownload.toString() + "....chunk fileid... " + chunkDetail.getCloudChunkName());
                    }
                    logger.debug(chunkFile.getCloudStoragePath() + LOOP_BEFORE_DOWNLOAD_FILE + fileToDownload + " ..new");
                    FileStatusElement fileStatusElement = new FileStatusElement();
                    inputStream = this.cloudSupportService.downloadFile(cloud, tempdownloadDir.getPath(), fileToDownload, userName, backupFile.getDeviceUUID(), containerName, pgChunkFile, isSync, backupFile, fileStatusElement, chunkDetail.getUserName(), chunkDetail, "", graphClient, okHttpClient);
                    if (inputStream == null) {
                        break;
                    }
                }
                catch (Exception e) {
                    logger.trace("" + e);
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException e1) {
                        logger.trace("" + e1);
                        logger.error(EXCEPTION_WHILE_DOWNLOADING_FILE_FROM_CLOUD + e1.getMessage());
                    }
                    logger.error(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                    throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
                }
                saltKeyTemp = this.getEncryptOrDecryptKey(cloud.getCloudId(), chunkDetail.getChunkCreatedTime(), BACKUP);
                File decryptedFile = this.downloadService.getDecryptedFileForPortal(cloudName, saltKeyTemp, deviceUUID, chunkFile.getFileName(), inputStream, chunkDetail.getUserName(), path, chunkFile, cloudId, chunkDetail);
                try {
                    int buff;
                    copyFileInput = new FileInputStream(decryptedFile.getAbsolutePath());
                    FilterInputStream fif = new BufferedInputStream(copyFileInput);
                    logger.debug(IS_COMPRESSED + backupFile.isCompressed());
                    if (backupFile.isCompressed()) {
                        fif = new GZIPInputStream(copyFileInput);
                    }
                    byte[] b = new byte[4096];
                    while ((buff = ((InputStream)fif).read(b)) != -1) {
                        zos.write(b, 0, buff);
                    }
                    ((InputStream)fif).close();
                }
                catch (IOException e) {
                    logger.error("Exception" + e.getMessage());
                }
                logger.debug(" remaining chunks ......" + --totalChunks);
                logger.debug("....Download Done for " + backupFile.getFileName() + "..." + zipEntry.getSize());
            }
            try {
                zos.closeEntry();
            }
            catch (IOException e) {
                logger.error("Exception" + e.getMessage());
            }
        }
    }

    private void downloadZipFileFromPGForPortal(String cloudName, HttpServletResponse response1, FileInfo fileInfo, DownloadFileTO downloadFileTO, String restoreFolderPath) {
        String fileName;
        String folderPath = "";
        String replaceValue = "";
        if (StringUtils.isNotEmpty((String)downloadFileTO.getFilePath())) {
            folderPath = downloadFileTO.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        } else {
            folderPath = ":";
            replaceValue = "_DRIVE";
        }
        logger.debug(".....file");
        String backupFileName = fileInfo.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        String downloadFilePath = fileName = backupFileName.replaceAll(folderPath, replaceValue);
        String tempPath = fileInfo.getFilePath().replace(":", "_DRIVE");
        logger.debug(tempPath + "....fileName with temppath..." + fileName);
        fileName = fileName.replaceAll("//", "\\");
        logger.debug(restoreFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + tempPath + "....fileName after replace..." + fileName);
        File res = new File(restoreFolderPath);
        if (!res.exists()) {
            logger.debug("...folder does not exists... " + res.getAbsolutePath());
            if (!res.exists()) {
                try {
                    res.mkdirs();
                }
                catch (Exception e1) {
                    logger.trace("" + e1);
                    logger.error("EXCPTION" + e1.getMessage());
                }
            }
        }
        String fileCompletePath = restoreFolderPath;
        fileCompletePath = fileCompletePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + downloadFilePath;
        logger.debug(fileInfo.getFilePath() + "....fileCompletePath.." + fileCompletePath);
        File filePa = new File(fileCompletePath);
        if (!filePa.exists()) {
            logger.debug("...folder does not exists complete... " + fileCompletePath);
            try {
                filePa.mkdirs();
            }
            catch (Exception e1) {
                logger.trace("" + e1);
                logger.error("EXCPTION" + e1.getMessage());
            }
        }
        logger.debug(fileInfo.getMd5() + " file is in pg .... " + fileInfo.getFileName() + "...." + fileInfo.getFilePath());
        List list = fileInfo.getChunkFiles();
        Collections.sort(list);
        for (String chunkName : list) {
            logger.debug(fileInfo.getMd5() + "...file names....." + chunkName);
        }
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
        if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
            deviceTempPath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileInfo.getBatchId();
        }
        String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
        fileCompletePath = !StringUtils.isEmpty((String)fileInfo.getSubject()) || !StringUtils.isEmpty((String)fileInfo.getFrom()) ? fileCompletePath + ".eml" : fileCompletePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileInfo.getFileName();
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(fileCompletePath));){
            for (String chunkName : list) {
                int endIndex;
                if (!StringUtils.isEmpty((String)chunkName) && chunkName.startsWith("part") && (endIndex = chunkName.lastIndexOf(46)) != -1) {
                    chunkName = chunkName.substring(0, endIndex);
                }
                if ("false".equalsIgnoreCase(chunkName)) {
                    chunkName = fileInfo.getMd5();
                }
                logger.debug(chunkFilePath + " file from pg.................." + chunkName);
                String filePath = chunkFilePath + "/" + chunkName;
                File file = new File(filePath);
                if (file.exists()) {
                    long size = file.length();
                    logger.debug(size + " file from pg.size................." + filePath);
                    try {
                        int buff;
                        FileInputStream copyFileInput = new FileInputStream(file.getAbsolutePath());
                        FilterInputStream fif = new BufferedInputStream(copyFileInput);
                        if (fileInfo.isCompressed()) {
                            fif = new GZIPInputStream(copyFileInput);
                        }
                        byte[] b = new byte[4096];
                        while ((buff = ((InputStream)fif).read(b)) != -1) {
                            bos.write(b, 0, buff);
                        }
                        ((InputStream)fif).close();
                    }
                    catch (IOException e) {
                        logger.debug("....execption......" + e);
                    }
                    continue;
                }
                logger.error(" file does not exists........" + filePath);
                break;
            }
        }
        catch (Exception e1) {
            logger.error("Exception" + e1.getMessage(), (Throwable)e1);
        }
    }

    private void downloadZipFileFromPGForPortal(String cloudName, HttpServletResponse response, FileInfo fileInfo, boolean isSync, ZipOutputStream zos, FileInputStream copyFileInput, DownloadFileTO downloadFileTO) {
        logger.debug(" file is in pg .... " + fileInfo.getFileName() + "...." + fileInfo.getFilePath());
        List list = fileInfo.getChunkFiles();
        Collections.sort(list);
        String deviceTempPath = isSync ? PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + fileInfo.getDeviceUUID() : PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
        if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
            deviceTempPath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileInfo.getBatchId();
        }
        String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
        String folderPath = "";
        if (StringUtils.isNotEmpty((String)downloadFileTO.getFilePath())) {
            folderPath = downloadFileTO.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        }
        String backupFileName = fileInfo.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileInfo.getFileName();
        String fileName = backupFileName.replaceAll(folderPath, "");
        ZipEntry zipEntry = new ZipEntry(fileName);
        try {
            zos.putNextEntry(zipEntry);
        }
        catch (IOException e1) {
            logger.error("Exception" + e1.getMessage());
        }
        for (String chunkName : list) {
            int endIndex;
            if (!isSync && !StringUtils.isEmpty((String)chunkName) && chunkName.startsWith("part") && (endIndex = chunkName.lastIndexOf(46)) != -1) {
                chunkName = chunkName.substring(0, endIndex);
            }
            logger.debug(" file from pg.................." + chunkName);
            String filePath = chunkFilePath + "/" + chunkName;
            File file = new File(filePath);
            if (file.exists()) {
                long size = file.length();
                logger.debug(size + " file from pg.size................." + filePath);
                try {
                    int buff;
                    copyFileInput = new FileInputStream(file.getAbsolutePath());
                    FilterInputStream fif = new BufferedInputStream(copyFileInput);
                    logger.debug(IS_COMPRESSED + fileInfo.isCompressed());
                    if (fileInfo.isCompressed()) {
                        fif = new GZIPInputStream(copyFileInput);
                    }
                    byte[] b = new byte[4096];
                    while ((buff = ((InputStream)fif).read(b)) != -1) {
                        zos.write(b, 0, buff);
                    }
                    ((InputStream)fif).close();
                }
                catch (IOException e) {
                    logger.error("Exception" + e.getMessage());
                }
                continue;
            }
            logger.error(" file does not exists........" + filePath);
        }
        try {
            zos.closeEntry();
        }
        catch (IOException e) {
            logger.error("Exception" + e.getMessage());
        }
    }

    @Override
    public DownloadTO restoreFolderForPortal(Cloud cloud, String cloudName, String userName, String fileName, String filePath, String saltKey, String deviceUUID, String syncRevisionId, String gatewayName, boolean b, HttpServletResponse response, String browserType, String fileUser) {
        DownloadTO downloadTO = new DownloadTO("");
        return null;
    }

    @Override
    public DownloadTO downloadZipSyncFileForPortal(DownloadFileTO downloadFileTO, Cloud cloud, HttpServletResponse response, String browserType, boolean isrestoreDeletedFile, String syncRevisionId) {
        int cloudId = cloud.getCloudId();
        String deviceUUID = downloadFileTO.getDeviceUUID();
        logger.debug("..existing deviuuid..." + deviceUUID);
        Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
        DownloadTO downloadTO = new DownloadTO("");
        return this.downloadZipFileFromCloudForPortal(downloadFileTO, response, cloud, browserType, downloadTO, device, isrestoreDeletedFile, syncRevisionId);
    }

    private DownloadTO downloadZipFileFromCloudForPortal(DownloadFileTO downloadFileTO, HttpServletResponse response, Cloud cloud, String browserType, DownloadTO downloadTO, Device device, boolean isrestoreDeletedFile, String syncRevisionId) {
        try {
            this.downloadZipFileFromCloudForPortal(cloud, response, downloadFileTO, downloadTO, device, isrestoreDeletedFile, syncRevisionId);
        }
        catch (Exception e) {
            logger.error("Exception" + e.getMessage());
        }
        return downloadTO;
    }

    private void downloadZipFileFromCloudForPortal(Cloud cloud, HttpServletResponse response, DownloadFileTO downloadFileTO, DownloadTO downloadTO, Device device, boolean isrestoreDeletedFile, String syncRevisionId) {
        String deviceUUID = downloadFileTO.getDeviceUUID();
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        String userName = downloadFileTO.getUserName();
        MiniCloud miniCloud = null;
        com.parablu.pcbd.domain.User user = null;
        String devicePath = downloadFileTO.getFileName();
        String filePath = downloadFileTO.getFilePath();
        String fileName = downloadFileTO.getFileName();
        String completeFilePath = filePath + "/" + fileName;
        String fullyQualifiedPath = "";
        String path = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + cloud.getCloudName() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "sync-download" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File tempdownloadDir = new File(path);
        if (!tempdownloadDir.exists()) {
            tempdownloadDir.mkdirs();
        }
        long currentMills = System.currentTimeMillis();
        String restorePath = path + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + currentMills + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File restoreFolder = new File(restorePath);
        if (!restoreFolder.exists()) {
            restoreFolder.mkdirs();
        }
        logger.debug("Download path..." + restoreFolder);
        logger.debug(filePath + " BEFORE DOWNLOADING folder  >>>>>> " + restoreFolder);
        try {
            long folderSize = 0L;
            BufferedInputStream inputStream = null;
            logger.debug(filePath + "....filepath and file name..." + fileName);
            if (!StringUtils.isEmpty((String)filePath)) {
                FileInputStream copyFileInput = null;
                boolean isPathInsideMC = this.isPathInsideMC(cloudId, completeFilePath);
                if (isPathInsideMC) {
                    String mcName = this.getMCName(completeFilePath);
                    miniCloud = this.syncFileDao.getMiniCloudByName(cloudId, mcName);
                    userName = "";
                } else {
                    user = this.userDao.getUserByName(cloudId, userName);
                }
                logger.debug("......ispathinsidemc....." + isPathInsideMC + "....filepath..." + filePath + " complete file path : " + completeFilePath);
                ArrayList<BackUpImage> syncFolderList = new ArrayList<BackUpImage>();
                ArrayList<String> emptyFolderPathList = new ArrayList<String>();
                BackUpImage backUpImage = this.syncBackUpImageDAO.getSyncBackUpImageById(cloudId, syncRevisionId, user, miniCloud);
                if (backUpImage != null) {
                    syncFolderList.add(backUpImage);
                }
                ArrayList<BackUpImage> syncFileFolderRecursion = new ArrayList<BackUpImage>();
                logger.debug("......ispathinsidemc....." + isPathInsideMC + "....filepath..." + filePath + " complete file path : " + completeFilePath);
                this.syncFileFolderRecursion(userName, filePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName, cloudId, syncFileFolderRecursion, user, miniCloud, isrestoreDeletedFile);
                syncFolderList.addAll(syncFileFolderRecursion);
                if (!CollectionUtils.isEmpty(syncFolderList)) {
                    for (BackUpImage backUpImageElement : syncFolderList) {
                        ArrayList<BackUpImage> restoreFilesList = new ArrayList<BackUpImage>();
                        if (backUpImageElement == null || backUpImageElement.getDevicePath() == null || backUpImageElement.getFileName() == null) {
                            logger.error("backup image element is null..." + backUpImageElement);
                            continue;
                        }
                        List files = this.syncBackUpImageDAO.getAllChildFilesOfFolder(cloudId, userName, backUpImageElement.getDevicePath() + "/" + backUpImageElement.getFileName(), false, user, miniCloud, isrestoreDeletedFile);
                        if (CollectionUtils.isEmpty((Collection)files)) {
                            emptyFolderPathList.add(backUpImageElement.getDevicePath() + "/" + backUpImageElement.getFileName());
                            logger.debug("The empty folder path found while downloading= " + backUpImageElement.getDevicePath() + "/" + backUpImageElement.getFileName());
                        }
                        restoreFilesList.addAll(files);
                        folderSize = this.restoreSyncFolder(cloud, userName, restoreFilesList, folderSize, inputStream, copyFileInput, filePath, restoreFolder, downloadFileTO, response, user, miniCloud);
                    }
                    if (!CollectionUtils.isEmpty(emptyFolderPathList)) {
                        logger.debug("number of empty folders present in the pat is={}", (Object)emptyFolderPathList.size());
                        this.addEmptyFolderIfPathNotExists(emptyFolderPathList, restorePath, downloadFileTO);
                    }
                }
            }
            downloadTO.setSize(folderSize);
            logger.debug("Complted ....." + folderSize);
            fullyQualifiedPath = path + "/" + devicePath + ".zip";
            this.downloadService.updateModifiedTimeForFileAndParentFolder(downloadFileTO, cloud, System.currentTimeMillis(), downloadTO.getMcName(), downloadTO.isPathInsideMC());
            ZipUtil.pack((File)new File(restorePath), (File)new File(fullyQualifiedPath));
            logger.debug("Path..." + path);
            logger.debug(new File(fullyQualifiedPath).length() + "....");
            response.setStatus(203);
            downloadTO.setPath(fullyQualifiedPath);
            try {
                logger.debug(new File(restorePath).length() + "...");
                FileUtils.deleteDirectory((File)new File(restorePath));
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error(" error trying to delete dir ...." + e.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Exception" + e.getMessage());
            logger.trace("Exception" + e);
            logger.trace("Exception", (Throwable)e);
        }
    }

    private void addEmptyFolderIfPathNotExists(List<String> emptyFolderPathList, String restorePath, DownloadFileTO downloadFileTO) {
        for (String emptyFolderPath : emptyFolderPathList) {
            String fileName;
            String folderPath = "";
            String replaceValue = "";
            if (StringUtils.isNotEmpty((String)downloadFileTO.getFilePath())) {
                folderPath = downloadFileTO.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            } else {
                folderPath = ":";
                replaceValue = "_DRIVE";
            }
            String parentFolderPath = Paths.get(emptyFolderPath, new String[0]).getParent().toString();
            String fileNameFolderPath = Paths.get(emptyFolderPath, new String[0]).getFileName().toString();
            String backupFileName = parentFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            String downloadFilePath = fileName = backupFileName.replaceAll(folderPath, replaceValue);
            logger.debug("downloadFilePath={}", (Object)downloadFilePath);
            try {
                String fileCompletePath = restorePath;
                fileCompletePath = fileCompletePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + downloadFilePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileNameFolderPath;
                logger.debug("fileCompletePath={}", (Object)fileCompletePath);
                Path path = Paths.get(fileCompletePath, new String[0]);
                logger.debug("process=checking if path exists={}", (Object)path);
                if (Files.exists(path, new LinkOption[0])) {
                    logger.debug("The file path exists, doing nothing");
                    continue;
                }
                logger.debug("The file path doesn't exists, adding the path");
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.error("error creating an empty folder " + e);
            }
        }
    }

    @Override
    public boolean isPathInsideMC(int cloudId, String path) {
        List miniCloudElementList = this.syncFileDao.getAllMiniClouds(1);
        String mcNameForPath = this.getMCName(path);
        boolean isPathIsideMiniCloud = this.isPathInsideMC(miniCloudElementList, mcNameForPath);
        return isPathIsideMiniCloud;
    }

    @Override
    public String getMCName(String path) {
        String[] list = path.split("/");
        if (list != null && list.length == 1) {
            return "";
        }
        return list[1];
    }

    private boolean isPathInsideMC(List<MiniCloud> cloudElementList, String mcNameFromPath) {
        if (StringUtils.isEmpty((String)mcNameFromPath)) {
            return false;
        }
        boolean isPathInsideMC = false;
        for (MiniCloud miniCloudElement : cloudElementList) {
            if (!mcNameFromPath.equalsIgnoreCase(miniCloudElement.getMiniCloudName())) continue;
            isPathInsideMC = true;
            break;
        }
        return isPathInsideMC;
    }

    private Long restoreSyncFolder(Cloud cloud, String userName, List<BackUpImage> restoreFilesList, long folderSize, BufferedInputStream inputStream, FileInputStream copyFileInput, String filePath, File restoreFolder, DownloadFileTO downloadFileTO, HttpServletResponse response, com.parablu.pcbd.domain.User user, MiniCloud miniCloud) {
        com.pg.domain.BackupFile backupFile = new com.pg.domain.BackupFile();
        logger.debug("Restore File list size : " + restoreFilesList.size());
        boolean isSync = downloadFileTO.isSync();
        block14: for (BackUpImage backUpImage : restoreFilesList) {
            if (backUpImage.getStatus().equalsIgnoreCase("DELETED") || backUpImage.getStatus().equalsIgnoreCase("RESTORED")) {
                backUpImage = this.syncBackUpImageDAO.getSyncBackUpImageForDeletedVersion(cloud.getCloudId(), backUpImage.getDevicePath(), backUpImage.getFileName(), user, miniCloud);
            }
            if (StringUtils.isNotEmpty((String)backUpImage.getStoragePlace()) && backUpImage.getStoragePlace().equalsIgnoreCase("CLOUD") && !CollectionUtils.isEmpty((Collection)backUpImage.getChunkFiles())) {
                String fileCompletePath;
                File tempdownloadDir1;
                this.convertBackupImageToBackupFile(backUpImage, backupFile);
                String folderPath = "";
                String replaceValue = "";
                String tempPath = backUpImage.getDevicePath();
                String downloadFilePath = "";
                if (!StringUtils.isEmpty((String)tempPath)) {
                    String fileName;
                    if (StringUtils.isNotEmpty((String)downloadFileTO.getFilePath())) {
                        folderPath = downloadFileTO.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
                    } else {
                        folderPath = ":";
                        replaceValue = "_DRIVE";
                    }
                    String backupFileName = tempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
                    downloadFilePath = fileName = backupFileName.replaceAll(folderPath, replaceValue);
                }
                if (!(tempdownloadDir1 = new File(fileCompletePath = restoreFolder.getAbsolutePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + downloadFilePath)).exists()) {
                    tempdownloadDir1.mkdirs();
                }
                folderSize += backUpImage.getSize();
                String path = PCHelperConstant.getPropertyFileValueDefaultSyncDownloadPath((String)cloud.getCloudName()) + backupFile.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + TEMP_DOWNLOAD_SYNC;
                File tempdownloadDir = new File(path);
                if (!tempdownloadDir.exists()) {
                    tempdownloadDir.mkdirs();
                }
                fileCompletePath = fileCompletePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getFileName();
                List chunkFilesList = backupFile.getChunkFiles();
                int totalChunks = chunkFilesList.size();
                this.sortChunkFileListByChunkFileName(chunkFilesList);
                GraphServiceClient<Request> graphClient = null;
                OkHttpClient okHttpClient = null;
                if (cloud.getGraphApiEnabled() == 1) {
                    graphClient = OneDriveUtil.getGraphClient();
                    okHttpClient = Graph.getInstance().getOkHttpClient();
                }
                try {
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(fileCompletePath));
                    Throwable throwable = null;
                    try {
                        for (com.pg.domain.ChunkFile chunkFile : chunkFilesList) {
                            String syncDecryptKey = SYNC_DECRYPT_KEY;
                            String productType = downloadFileTO.isSync() ? PRODUCT_TYPE_SYNC : BACKUP;
                            try {
                                String saltKeyTemp;
                                String dedupVal = this.getDedupValueByUserName(userName);
                                ChunkDetail chunkDetail = this.getChunkDetailsByMd5(userName, chunkFile, dedupVal);
                                logger.debug(CLOUD_CHUNK_NAME + chunkDetail.getCloudChunkName());
                                String backupId = backupFile.getId();
                                StringBuilder fileNameToDownload = new StringBuilder(chunkDetail.getCloudChunkName());
                                int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
                                if (occurance == 0 || occurance == 1 && chunkFilesList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                                    fileNameToDownload.append("." + backupId);
                                }
                                String containerName = null;
                                if (chunkDetail != null) {
                                    containerName = chunkDetail.getContainerName();
                                    if (!StringUtils.isEmpty((String)chunkDetail.getCloudStoragePath())) {
                                        chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                                    }
                                    syncDecryptKey = chunkDetail.getContainerName();
                                }
                                if (!StringUtils.isEmpty((String)chunkDetail.getContainerName()) && !"ParaBlu".equalsIgnoreCase(chunkDetail.getContainerName())) {
                                    productType = BACKUP;
                                    syncDecryptKey = chunkDetail.getUserName();
                                }
                                com.pg.domain.ChunkFile pgChunkFile = new com.pg.domain.ChunkFile();
                                BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
                                FileStatusElement fileStatusElement = new FileStatusElement();
                                boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
                                String fileToDownload = fileNameToDownload.toString();
                                if (isGDEnabled) {
                                    fileToDownload = chunkDetail.getCloudChunkName();
                                }
                                if ((inputStream = this.cloudSupportService.downloadFile(cloud, tempdownloadDir.getPath(), fileToDownload, chunkDetail.getUserName(), backupFile.getDeviceUUID(), containerName, pgChunkFile, true, backupFile, fileStatusElement, chunkDetail.getUserName(), chunkDetail, "", graphClient, okHttpClient)) == null) continue block14;
                                File decryptedFile = null;
                                logger.debug("....decrypt sync...." + isSync);
                                if (isSync) {
                                    productType = PRODUCT_TYPE_SYNC;
                                    saltKeyTemp = this.getEncryptOrDecryptKey(cloud.getCloudId(), chunkFile.getUploadedTimeStamp(), productType);
                                    logger.debug(productType + "....decrypt sync1...." + saltKeyTemp);
                                    decryptedFile = this.getDecryptedFile(cloud.getCloudName(), saltKeyTemp, backupFile.getDeviceUUID(), chunkFile.getFileName(), inputStream, chunkDetail.getUserName(), syncDecryptKey);
                                } else {
                                    saltKeyTemp = this.getEncryptOrDecryptKey(1, chunkFile.getUploadedTimeStamp(), productType);
                                    decryptedFile = this.getDecryptedFileForFolder(cloud.getCloudName(), saltKeyTemp, backupFile.getDeviceUUID(), chunkFile.getFileName(), inputStream, userName, syncDecryptKey);
                                }
                                if (decryptedFile != null && decryptedFile.exists()) {
                                    int buff;
                                    copyFileInput = new FileInputStream(decryptedFile.getAbsolutePath());
                                    FilterInputStream fif = new BufferedInputStream(copyFileInput);
                                    logger.debug(IS_COMPRESSED + backupFile.isCompressed());
                                    if (backupFile.isCompressed()) {
                                        fif = new GZIPInputStream(copyFileInput);
                                    }
                                    byte[] b = new byte[4096];
                                    while ((buff = ((InputStream)fif).read(b)) != -1) {
                                        bos.write(b, 0, buff);
                                    }
                                    ((InputStream)fif).close();
                                    decryptedFile.delete();
                                }
                            }
                            catch (IOException e) {
                                logger.error("Exception" + e.getMessage());
                            }
                            logger.debug(" remaining chunks ......" + --totalChunks);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (bos == null) continue;
                        if (throwable != null) {
                            try {
                                bos.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        bos.close();
                    }
                }
                catch (FileNotFoundException e2) {
                    logger.trace("" + e2);
                    logger.error("EXCPTION" + e2.getMessage());
                }
                catch (IOException e3) {
                    logger.trace("" + e3);
                    logger.error("EXCPTION" + e3.getMessage());
                }
                continue;
            }
            this.convertBackupImageToBackupFile(backUpImage, backupFile);
            backupFile.setId(backUpImage.getId().toString());
            FileInfo fileInfo = this.fileDao.getFileFromPG(downloadFileTO.getUserName(), cloud.getCloudName(), backupFile.getId(), false);
            if (fileInfo == null) continue;
            String restoreFolderPath = restoreFolder.getAbsolutePath();
            logger.debug("...restorefolder path ..." + restoreFolderPath);
            filePath = fileInfo.getFilePath();
            filePath = filePath.replace("\\", "/");
            fileInfo.setFilePath(filePath);
            this.downloadZipFileFromPGForPortal(cloud.getCloudName(), response, fileInfo, downloadFileTO, restoreFolderPath);
            if (fileInfo.getSize() == 0L) continue;
            folderSize += fileInfo.getSize().longValue();
        }
        return folderSize;
    }

    private File getDecryptedFileForFolder(String cloudName, String saltKey, String deviceUUID, String fileName, BufferedInputStream inputStream, String restorePath, String syncUniqueKey) {
        String path = PCHelperConstant.getPropertyFileValueDefaultSyncDownloadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File decryptedDir = new File(path + DECRYPTED);
        if (!decryptedDir.exists()) {
            decryptedDir.mkdirs();
        }
        this.createFolders(path);
        File decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
        decryptedFile = this.fileEncryptionService.decrypt(saltKey, syncUniqueKey, inputStream, decryptedFile);
        return decryptedFile;
    }

    private void sortChunkFileListByChunkFileName(List<com.pg.domain.ChunkFile> chunkFilesList) {
        Collections.sort(chunkFilesList, new Comparator<com.pg.domain.ChunkFile>(){

            @Override
            public int compare(com.pg.domain.ChunkFile c1, com.pg.domain.ChunkFile c2) {
                if (c1 == null || c2 == null || c1.getFileName() == null || c2.getFileName() == null) {
                    return -1;
                }
                return new CompareToBuilder().append((Object)c1.getFileName().toLowerCase(), (Object)c2.getFileName().toLowerCase()).toComparison();
            }
        });
    }

    private String getFileNameForZipEntry(String filePath, BackupFile backupFileData) {
        String filePathTemp = backupFileData.getFilePath();
        if (!backupFileData.getDeviceUUID().equalsIgnoreCase("Portal")) {
            filePathTemp = backupFileData.getFilePath().replace("\\", "/");
        }
        String folderPath = filePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        String syncFileName = filePathTemp + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupFileData.getFileName();
        String fileName = syncFileName.replaceAll(folderPath, "");
        return fileName;
    }

    private ChunkDetail getChunkDetailsByMd5(String userName, com.pg.domain.ChunkFile chunkFile, String dedupVal) {
        ChunkDetail chunkDetail = null;
        List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, false);
        if (CollectionUtils.isEmpty((Collection)chunkDetailList)) {
            logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
            chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, true);
        }
        if (!CollectionUtils.isEmpty((Collection)chunkDetailList)) {
            for (ChunkDetail detailFromDB : chunkDetailList) {
                if (detailFromDB.getRefCount() <= 0 && detailFromDB.getClientDedupRefCount() <= 0) continue;
                chunkDetail = detailFromDB;
            }
        }
        if (chunkDetail == null) {
            logger.debug(CHUNK_DETAILS_NULL);
            chunkDetail = new ChunkDetail();
            chunkDetail.setCloudChunkName(chunkFile.getFileName());
        }
        return chunkDetail;
    }

    private long restorePgFile(Cloud cloud, String userName, HttpServletResponse response, long folderSize, FileInputStream copyFileInput, ZipOutputStream zos, String filePath, ConsolidatedImage consolidatedImage) {
        String syncId = this.fileDao.getRevisionFileByconsolidatedImageId(cloud.getCloudId(), consolidatedImage);
        FileInfo fileInfo = this.fileDao.getFileFromPG(userName, cloud.getCloudName(), syncId, true);
        if (fileInfo != null) {
            folderSize += fileInfo.getSize().longValue();
            String filePath1 = fileInfo.getFilePath();
            filePath1 = filePath1.replace("\\", "/");
            fileInfo.setFilePath(filePath1);
            DownloadFileTO downloadFileTO = new DownloadFileTO();
            downloadFileTO.setFilePath(filePath);
            this.downloadZipFileFromPGForPortal(cloud.getCloudName(), response, fileInfo, true, zos, copyFileInput, downloadFileTO);
        }
        return folderSize;
    }

    private void convertPcbdToPgDomainOfBackupFile(BackupFile backupFileData, com.pg.domain.BackupFile backupFile) {
        BeanUtils.copyProperties((Object)backupFileData, (Object)backupFile);
        ArrayList<com.pg.domain.ChunkFile> chunkList = new ArrayList<com.pg.domain.ChunkFile>();
        for (ChunkFile chunkFile : backupFileData.getChunkFiles()) {
            com.pg.domain.ChunkFile file = new com.pg.domain.ChunkFile();
            BeanUtils.copyProperties((Object)chunkFile, (Object)file);
            chunkList.add(file);
        }
        backupFile.setChunkFiles(chunkList);
    }

    private void syncFileFolderRecursion(String userName, String filePath, int cloudId, List<BackUpImage> syncFileFolderRecursion, com.parablu.pcbd.domain.User user, MiniCloud miniCloud, boolean isRestoreDeletedFile) {
        List syncFilesTemp = this.syncBackUpImageDAO.getAllChildFilesOfFolder(cloudId, userName, filePath, true, user, miniCloud, isRestoreDeletedFile);
        syncFileFolderRecursion.addAll(syncFilesTemp);
        if (!CollectionUtils.isEmpty((Collection)syncFilesTemp)) {
            Stream stream = syncFilesTemp.parallelStream();
            stream.forEach(syncFile -> {
                String devicePath = syncFile.getDevicePath() + "/" + syncFile.getFileName();
                if (StringUtils.isEmpty((String)syncFile.getDevicePath())) {
                    devicePath = syncFile.getFileName();
                }
                this.syncFileFolderRecursion(userName, devicePath, cloudId, syncFileFolderRecursion, user, miniCloud, isRestoreDeletedFile);
            });
        }
    }

    @Override
    public void downloadFileFromCloudForPortalForAttachment(Cloud cloud, String cloudName, String userName, BackUpImage backUpImage, List<String> nameList, String saltKey, HttpServletResponse response, boolean isSync, MailAttachment attachment, GraphServiceClient<Request> graphClient, OkHttpClient okHttpClient) {
        File decryptedFile;
        BufferedInputStream inputStream = null;
        String deviceUUID = backUpImage.getDeviceUUID();
        int cloudId = cloud.getCloudId();
        String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File tempdownloadDir = new File(path);
        if (!tempdownloadDir.exists()) {
            tempdownloadDir.mkdirs();
        }
        List chunkFilesList = attachment.getChunkFiles();
        int totalChunks = chunkFilesList.size();
        String syncDecryptKey = SYNC_DECRYPT_KEY;
        String productType = isSync ? PRODUCT_TYPE_SYNC : BACKUP;
        String dedupVal = this.getDedupValue(userName, isSync);
        logger.debug("..before chunk detail...." + userName + "...." + dedupVal + "...ch..." + attachment.getMd5());
        ChunkDetail chunkDetail = null;
        com.pg.domain.ChunkFile chunkFile = new com.pg.domain.ChunkFile();
        try {
            if (chunkDetail == null) {
                logger.debug(CHUNK_DETAILS_NULL);
                chunkDetail = new ChunkDetail();
                chunkDetail.setCloudChunkName(attachment.getEncodedName());
                chunkDetail.setUserName(userName);
                chunkDetail.setContainerName(userName.toLowerCase());
                chunkDetail.setMd5(attachment.getMd5());
                chunkDetail.setEncodedName(attachment.getEncodedName());
                chunkFile.setMd5(attachment.getMd5());
                chunkFile.setEncodedName(attachment.getEncodedName());
            }
            logger.debug(CLOUD_CHUNK_NAME + chunkDetail.getCloudChunkName());
            String backupId = backUpImage.getId().toString();
            String containerName = null;
            if (!isSync) {
                containerName = chunkDetail.getContainerName();
            }
            StringBuilder fileNameToDownload = new StringBuilder();
            fileNameToDownload.append(chunkDetail.getCloudChunkName());
            int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
            if (occurance == 0 || occurance == 1 && chunkFilesList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                fileNameToDownload.append(".").append(backupId);
            }
            if (chunkDetail != null) {
                containerName = chunkDetail.getContainerName();
                if (!StringUtils.isEmpty((String)attachment.getCloudStoragePath())) {
                    chunkFile.setCloudStoragePath(attachment.getCloudStoragePath());
                }
                syncDecryptKey = chunkDetail.getUserName();
            }
            com.pg.domain.ChunkFile pgChunkFile = new com.pg.domain.ChunkFile();
            BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
            boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
            String fileToDownload = fileNameToDownload.toString();
            if (isGDEnabled) {
                fileToDownload = chunkDetail.getCloudChunkName();
                logger.debug(fileNameToDownload.toString() + "....chunk fileid... " + chunkDetail.getCloudChunkName());
            }
            if (!CollectionUtils.isEmpty((Collection)chunkFilesList)) {
                fileToDownload = (String)chunkFilesList.get(0);
            }
            logger.debug(chunkFile.getCloudStoragePath() + LOOP_BEFORE_DOWNLOAD_FILE + fileToDownload + " ..new");
            FileStatusElement fileStatusElement = new FileStatusElement();
            inputStream = this.cloudSupportService.downloadFile(cloud, tempdownloadDir.getPath(), fileToDownload, userName, backUpImage.getDeviceUUID(), containerName, pgChunkFile, isSync, null, fileStatusElement, chunkDetail.getUserName(), chunkDetail, "", graphClient, okHttpClient);
            if (inputStream == null) {
                return;
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e1) {
                logger.trace("" + e1);
                logger.error(EXCEPTION_WHILE_DOWNLOADING_FILE_FROM_CLOUD + e1.getMessage());
            }
            logger.error(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
            throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
        }
        isSync = !productType.equalsIgnoreCase(BACKUP);
        logger.debug("..isSync Value>>>>>" + isSync);
        if (isSync) {
            String saltKeyTemp = this.getEncryptOrDecryptKey(cloud.getCloudId(), chunkDetail.getChunkCreatedTime(), productType);
            decryptedFile = this.getDecryptedFile(cloudName, saltKeyTemp, backUpImage.getDeviceUUID(), chunkFile.getFileName(), inputStream, userName, syncDecryptKey);
        } else {
            String saltKeyTemp = this.getEncryptOrDecryptKey(cloud.getCloudId(), chunkDetail.getChunkCreatedTime(), BACKUP);
            logger.debug(userName + "...users...." + chunkDetail.getUserName());
            decryptedFile = this.downloadService.getDecryptedFileForPortal(cloudName, saltKeyTemp, deviceUUID, chunkFile.getFileName(), inputStream, chunkDetail.getUserName(), path, chunkFile, cloudId, chunkDetail);
        }
        this.writeDataToStream(response, decryptedFile, backUpImage);
        nameList.add(chunkFile.getFileName());
        logger.debug(" remaining chunks ......" + --totalChunks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inPlaceRestoreForOndriveFromCloud(Cloud cloud, com.pg.domain.BackupFile backupFile, String customPath, String restoreUser, String driveId, boolean c2cRestore, String productType, CompletionService<String> pool, String pbDriveIdforSource) {
        File destFile = null;
        String deviceUUID = backupFile.getDeviceUUID();
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        String userName = backupFile.getUserName();
        String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File tempdownloadDir = new File(path);
        if (!tempdownloadDir.exists()) {
            tempdownloadDir.mkdirs();
        }
        List chunkFilesList = backupFile.getChunkFiles();
        int totalChunks = chunkFilesList.size();
        try {
            logger.debug(".... before creating file ");
            logger.debug(".... before creating file111 " + chunkFilesList.size());
            String dedupVal = this.getDedupValue(userName, false);
            List<String> fileNames = Collections.synchronizedList(new ArrayList());
            chunkFilesList.parallelStream().forEach(chunkFile -> {
                List chunkDetailList;
                GraphServiceClient<Request> graphClient = null;
                OkHttpClient okHttpClient = null;
                BufferedInputStream inputStream = null;
                logger.debug("..before chunk detail...." + userName + "...." + dedupVal + "...ch..." + chunkFile.getMd5());
                ChunkDetail chunkDetail = null;
                if (graphClient == null && cloud.getGraphApiEnabled() == 1) {
                    graphClient = OneDriveUtil.getGraphClient();
                    okHttpClient = Graph.getInstance().getOkHttpClient();
                }
                if (CollectionUtils.isEmpty((Collection)(chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, false)))) {
                    logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                    chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, true);
                }
                if (!CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                    for (ChunkDetail detailFromDB : chunkDetailList) {
                        if (detailFromDB.getRefCount() <= 0 && detailFromDB.getClientDedupRefCount() <= 0) continue;
                        chunkDetail = detailFromDB;
                    }
                }
                FileStatusElement fileStatusElement = new FileStatusElement();
                try {
                    if (chunkDetail == null) {
                        logger.debug(CHUNK_DETAILS_NULL);
                        chunkDetail = new ChunkDetail();
                        chunkDetail.setCloudChunkName(chunkFile.getFileName());
                        chunkDetail.setUserName(userName);
                        chunkDetail.setContainerName(userName.toLowerCase());
                        chunkDetail.setMd5(chunkFile.getMd5());
                    }
                    logger.debug(CLOUD_CHUNK_NAME + chunkDetail.getCloudChunkName());
                    String backupId = backupFile.getId();
                    String containerName = chunkDetail.getContainerName();
                    StringBuilder fileNameToDownload = new StringBuilder();
                    fileNameToDownload.append(chunkDetail.getCloudChunkName());
                    int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
                    if (occurance == 0 || occurance == 1 && chunkFilesList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                        fileNameToDownload.append(".").append(backupId);
                    }
                    if (chunkDetail != null) {
                        containerName = chunkDetail.getContainerName();
                        if (!StringUtils.isEmpty((String)chunkDetail.getCloudStoragePath())) {
                            chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                        }
                    }
                    com.pg.domain.ChunkFile pgChunkFile = new com.pg.domain.ChunkFile();
                    BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
                    boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
                    String fileToDownload = fileNameToDownload.toString();
                    if (isGDEnabled) {
                        fileToDownload = chunkDetail.getCloudChunkName();
                        logger.debug(fileNameToDownload.toString() + "....chunk fileid... " + chunkDetail.getCloudChunkName());
                    }
                    logger.debug(chunkFile.getCloudStoragePath() + LOOP_BEFORE_DOWNLOAD_FILE + fileToDownload + " ..new");
                    logger.debug("before download cloudsupport.......");
                    fileStatusElement.setDriveId(pbDriveIdforSource);
                    inputStream = this.cloudSupportService.downloadFile(cloud, tempdownloadDir.getPath(), fileToDownload, userName, backupFile.getDeviceUUID(), containerName, pgChunkFile, false, backupFile, fileStatusElement, chunkDetail.getUserName(), chunkDetail, pbDriveIdforSource, graphClient, okHttpClient);
                    backupFile.setDedupBackupId(fileStatusElement.getDriveId());
                    logger.debug("....after download ....");
                    if (inputStream == null) {
                        throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
                    }
                }
                catch (Exception e) {
                    logger.error(" error trying to download ...", (Throwable)e);
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException e1) {
                        logger.trace("" + e1);
                        logger.error(EXCEPTION_WHILE_DOWNLOADING_FILE_FROM_CLOUD + e1.getMessage());
                    }
                    logger.error(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                    throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
                }
                String saltKeyTemp = this.getEncryptOrDecryptKey(cloud.getCloudId(), chunkDetail.getChunkCreatedTime(), BACKUP);
                logger.debug(userName + "...users...." + chunkDetail.getUserName());
                String decryptUserName = chunkDetail.getUserName();
                if (StringUtils.isNotEmpty((String)fileStatusElement.getFileOwner())) {
                    decryptUserName = fileStatusElement.getFileOwner();
                }
                File decryptedFile = this.downloadService.getDecryptedFileForPortal(cloudName, saltKeyTemp, deviceUUID, chunkFile.getFileName(), inputStream, decryptUserName, path, (com.pg.domain.ChunkFile)chunkFile, cloudId, chunkDetail);
                logger.debug("decrypted file path:" + decryptedFile.getAbsolutePath() + decryptedFile.getName());
                SyncDownloadServiceImpl syncDownloadServiceImpl = this;
                synchronized (syncDownloadServiceImpl) {
                    fileNames.add(decryptedFile.getName());
                }
            });
            try {
                Collections.sort(fileNames, new Comparator<String>(){

                    @Override
                    public int compare(String c1, String c2) {
                        if (c1 == null || c2 == null) {
                            return -1;
                        }
                        return new CompareToBuilder().append((Object)c1.toLowerCase(), (Object)c2.toLowerCase()).toComparison();
                    }
                });
                FileOutputStream fos = null;
                String destinationPath = "";
                if (destFile == null) {
                    String encodedFileName = "";
                    try {
                        encodedFileName = URLEncoder.encode(backupFile.getFileName(), UTF8).replace("+", "%20");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    destinationPath = path + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + encodedFileName;
                    logger.debug("..destpath...." + destinationPath);
                    destFile = new File(destinationPath);
                    destFile.createNewFile();
                    fos = new FileOutputStream(destinationPath, true);
                }
                logger.debug(backupFile.isCompressed() + "@@PVN....is file compressed.....");
                List<String> list = fileNames;
                synchronized (list) {
                    for (String fileName : fileNames) {
                        int buff;
                        File file = new File(path + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + DECRYPTED + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
                        FilterInputStream fif = null;
                        FileInputStream fis = new FileInputStream(file);
                        fif = new BufferedInputStream(fis);
                        if (backupFile.isCompressed()) {
                            fif = new GZIPInputStream(fif);
                        }
                        byte[] b = new byte[4096];
                        while ((buff = ((InputStream)fif).read(b)) != -1) {
                            fos.write(b, 0, buff);
                            fos.flush();
                        }
                        fis.close();
                        ((InputStream)fif).close();
                    }
                    fos.close();
                }
            }
            catch (Exception e) {
                logger.error("Merge execution failed...!", (Throwable)e);
            }
            logger.debug("..##GRAPHfile to upload...." + destFile.getName() + "...." + destFile.length());
            if (!StringUtils.isEmpty((String)productType) && "SP".equals(productType)) {
                this.cloudSupportService.uploadToSP(cloudId, userName, destFile, backupFile, customPath, true, driveId);
            } else {
                Runnable uploadJob = () -> {
                    String encodedfileName = null;
                    try {
                        encodedfileName = URLEncoder.encode(backupFile.getFileName(), UTF8).replace("+", "%20");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    String destinationPath = path + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + encodedfileName;
                    logger.debug("..destpath...." + destinationPath);
                    File destFile1 = new File(destinationPath);
                    this.inplaceOnedriveUpload(cloudId, restoreUser, destFile1, backupFile, customPath, driveId, c2cRestore);
                    destFile1.delete();
                };
                pool.submit(uploadJob, "");
            }
        }
        catch (Exception e) {
            logger.error(".... exception......", (Throwable)e);
        }
    }

    @Override
    public void inPlaceRestoreForOndriveFromPg(Cloud cloud, com.pg.domain.BackupFile backupFile, FileInfo fileInfo, String customPath, String restoreUser, String driveId, boolean c2cRestore) {
        try {
            File destFile = null;
            FileOutputStream fos = null;
            String deviceUUID = backupFile.getDeviceUUID();
            int cloudId = cloud.getCloudId();
            String cloudName = cloud.getCloudName();
            String userName = backupFile.getUserName();
            String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            File tempdownloadDir = new File(path);
            if (!tempdownloadDir.exists()) {
                tempdownloadDir.mkdirs();
            }
            List chunkFilesList = fileInfo.getChunkFiles();
            Collections.sort(chunkFilesList);
            String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
            boolean isSync = false;
            if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
                deviceTempPath = deviceTempPath + "/" + fileInfo.getBatchId();
            }
            String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
            String destinationPath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupFile.getFileName();
            logger.debug("..destpath...." + destinationPath);
            destFile = new File(destinationPath);
            destFile.createNewFile();
            fos = new FileOutputStream(destinationPath, true);
            for (String chunkName : chunkFilesList) {
                int endIndex;
                if (!isSync && !StringUtils.isEmpty((String)chunkName) && chunkName.startsWith("part") && (endIndex = chunkName.lastIndexOf(46)) != -1) {
                    chunkName = chunkName.substring(0, endIndex);
                }
                logger.debug(" file from pg.................." + chunkName);
                String filePath = chunkFilePath + "/" + chunkName;
                File file = new File(filePath);
                if (file.exists()) {
                    int buff;
                    long size = file.length();
                    logger.debug(size + " file from pg.size................." + filePath);
                    FilterInputStream fif = null;
                    FileInputStream fis = new FileInputStream(file);
                    fif = new BufferedInputStream(fis);
                    if (fileInfo.isCompressed()) {
                        fif = new GZIPInputStream(fif);
                    }
                    logger.debug(" file from pg.compressed................." + fileInfo.isCompressed());
                    byte[] b = new byte[4096];
                    while ((buff = ((InputStream)fif).read(b)) != -1) {
                        fos.write(b, 0, buff);
                        fos.flush();
                    }
                    fis.close();
                    ((InputStream)fif).close();
                    continue;
                }
                logger.error(" file does not exists........" + filePath);
            }
            fos.close();
            this.inplaceOnedriveUpload(cloudId, restoreUser, destFile, backupFile, customPath, driveId, c2cRestore);
            logger.debug(" pvn before returning dest size........." + destFile.length());
            destFile.delete();
        }
        catch (Exception e) {
            logger.error(".... exception......", (Throwable)e);
        }
    }

    @Override
    public void inPlaceRestoreForSPFromPg(Cloud cloud, com.pg.domain.BackupFile backupFile, FileInfo fileInfo, String customPath, String restoreUser, String siteId) {
        try {
            String deviceUUID = backupFile.getDeviceUUID();
            int cloudId = cloud.getCloudId();
            String cloudName = cloud.getCloudName();
            String userName = backupFile.getUserName();
            String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            File tempdownloadDir = new File(path);
            if (!tempdownloadDir.exists()) {
                tempdownloadDir.mkdirs();
            }
            List chunkFilesList = fileInfo.getChunkFiles();
            Collections.sort(chunkFilesList);
            String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
            boolean isSync = false;
            if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
                deviceTempPath = deviceTempPath + "/" + fileInfo.getBatchId();
            }
            String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
            for (String chunkName : chunkFilesList) {
                int endIndex;
                if (!isSync && !StringUtils.isEmpty((String)chunkName) && chunkName.startsWith("part") && (endIndex = chunkName.lastIndexOf(46)) != -1) {
                    chunkName = chunkName.substring(0, endIndex);
                }
                logger.debug(" file from pg.................." + chunkName);
                String filePath = chunkFilePath + "/" + chunkName;
                File file = new File(filePath);
                if (file.exists()) {
                    long size = file.length();
                    logger.debug(size + " file from pg.size................." + filePath);
                    this.cloudSupportService.uploadToSP(cloudId, userName, file, backupFile, customPath, true, siteId);
                    continue;
                }
                logger.error(" file does not exists........" + filePath);
            }
            logger.debug(" before returning.........");
        }
        catch (Exception e) {
            logger.error(".... exception......" + e.getMessage());
        }
    }

    private void inplaceOnedriveUpload(int cloudId, String userName, File decryptedFile, com.pg.domain.BackupFile backupFile, String customPath, String driveId, boolean c2cRestore) {
        this.cloudSupportService.uploadToOneDrive(cloudId, userName, decryptedFile, backupFile, customPath, true, driveId, c2cRestore);
    }

    @Override
    public byte[] downloadFromCloudContactsPhotoForPortal(Cloud cloud, String cloudName, String userName, BackUpImage backUpImage, List<String> nameList, String saltKey, boolean isSync, MailAttachment attachment, GraphServiceClient<Request> graphClient, OkHttpClient okHttpClient) {
        File decryptedFile;
        BufferedInputStream inputStream = null;
        String deviceUUID = backUpImage.getDeviceUUID();
        int cloudId = cloud.getCloudId();
        String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File tempdownloadDir = new File(path);
        if (!tempdownloadDir.exists()) {
            tempdownloadDir.mkdirs();
        }
        List chunkFilesList = attachment.getChunkFiles();
        int totalChunks = chunkFilesList.size();
        String syncDecryptKey = SYNC_DECRYPT_KEY;
        String productType = isSync ? PRODUCT_TYPE_SYNC : BACKUP;
        String dedupVal = this.getDedupValue(userName, isSync);
        logger.debug("..before chunk detail...." + userName + "...." + dedupVal + "...ch..." + attachment.getMd5());
        ChunkDetail chunkDetail = null;
        com.pg.domain.ChunkFile chunkFile = new com.pg.domain.ChunkFile();
        try {
            if (chunkDetail == null) {
                logger.debug(CHUNK_DETAILS_NULL);
                chunkDetail = new ChunkDetail();
                chunkDetail.setCloudChunkName(attachment.getEncodedName());
                chunkDetail.setUserName(userName);
                chunkDetail.setContainerName(userName.toLowerCase());
                chunkDetail.setMd5(attachment.getMd5());
                chunkDetail.setEncodedName(attachment.getEncodedName());
                chunkFile.setMd5(attachment.getMd5());
                chunkFile.setEncodedName(attachment.getEncodedName());
            }
            logger.debug(CLOUD_CHUNK_NAME + chunkDetail.getCloudChunkName());
            String backupId = backUpImage.getId().toString();
            String containerName = null;
            if (!isSync) {
                containerName = chunkDetail.getContainerName();
            }
            StringBuilder fileNameToDownload = new StringBuilder();
            fileNameToDownload.append(chunkDetail.getCloudChunkName());
            int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
            if (occurance == 0 || occurance == 1 && chunkFilesList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                fileNameToDownload.append(".").append(backupId);
            }
            if (chunkDetail != null) {
                containerName = chunkDetail.getContainerName();
                if (!StringUtils.isEmpty((String)attachment.getCloudStoragePath())) {
                    chunkFile.setCloudStoragePath(attachment.getCloudStoragePath());
                }
                syncDecryptKey = chunkDetail.getUserName();
            }
            com.pg.domain.ChunkFile pgChunkFile = new com.pg.domain.ChunkFile();
            BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
            boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
            String fileToDownload = fileNameToDownload.toString();
            if (isGDEnabled) {
                fileToDownload = chunkDetail.getCloudChunkName();
                logger.debug(fileNameToDownload.toString() + "....chunk fileid... " + chunkDetail.getCloudChunkName());
            }
            logger.debug(chunkFile.getCloudStoragePath() + LOOP_BEFORE_DOWNLOAD_FILE + fileToDownload + " ..new");
            FileStatusElement fileStatusElement = new FileStatusElement();
            inputStream = this.cloudSupportService.downloadFile(cloud, tempdownloadDir.getPath(), fileToDownload, userName, backUpImage.getDeviceUUID(), containerName, pgChunkFile, isSync, null, fileStatusElement, chunkDetail.getUserName(), chunkDetail, "", graphClient, okHttpClient);
            if (inputStream == null) {
                return null;
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e1) {
                logger.trace("" + e1);
                logger.error(EXCEPTION_WHILE_DOWNLOADING_FILE_FROM_CLOUD + e1.getMessage());
            }
            logger.error(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
            throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
        }
        isSync = !productType.equalsIgnoreCase(BACKUP);
        logger.debug("..isSync Value>>>>>" + isSync);
        if (isSync) {
            String saltKeyTemp = this.getEncryptOrDecryptKey(cloud.getCloudId(), chunkDetail.getChunkCreatedTime(), productType);
            decryptedFile = this.getDecryptedFile(cloudName, saltKeyTemp, backUpImage.getDeviceUUID(), chunkFile.getFileName(), inputStream, userName, syncDecryptKey);
        } else {
            String saltKeyTemp = this.getEncryptOrDecryptKey(cloud.getCloudId(), chunkDetail.getChunkCreatedTime(), BACKUP);
            logger.debug(userName + "...users...." + chunkDetail.getUserName());
            decryptedFile = this.downloadService.getDecryptedFileForPortal(cloudName, saltKeyTemp, deviceUUID, chunkFile.getFileName(), inputStream, chunkDetail.getUserName(), path, chunkFile, cloudId, chunkDetail);
        }
        return this.writeDataToStreamForPhoto(decryptedFile, backUpImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTasksExist(String graphuserId, String taskId, String accessToken) {
        String downloadurl = "https://graph.microsoft.com/beta/users/" + graphuserId + "/outlook/tasks/" + taskId;
        boolean isTasksExist = false;
        CloseableHttpClient client = null;
        HttpGet httpGet = null;
        CloseableHttpResponse response = null;
        try {
            client = HttpClientBuilder.create().build();
            httpGet = new HttpGet(downloadurl);
            httpGet.addHeader("Accept", "application/json");
            httpGet.addHeader("Authorization", "Bearer " + accessToken);
            httpGet.addHeader("Prefer", "odata.maxpagesize=500");
            response = client.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            logger.debug(" tasks Response Code : " + statusCode);
            if (statusCode == 200) {
                isTasksExist = true;
            }
            httpGet.releaseConnection();
            this.closeResponse(response);
        }
        catch (Exception e) {
            logger.debug("task does not exists... ");
        }
        finally {
            httpGet.releaseConnection();
            this.closeResponse(response);
        }
        return isTasksExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inPlaceRestoreForTasksFromCloud(Cloud cloud, String userName, String mailUserName, com.pg.domain.BackupFile backupFile, String destCollection, String itemId, boolean differentDest) {
        block74: {
            BufferedInputStream inputStream = null;
            String deviceUUID = backupFile.getDeviceUUID();
            int cloudId = cloud.getCloudId();
            String cloudName = cloud.getCloudName();
            String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            File tempdownloadDir = new File(path);
            if (!tempdownloadDir.exists()) {
                tempdownloadDir.mkdirs();
            }
            try {
                logger.debug(mailUserName + ".... before creating message itemId .." + itemId);
                String accessToken = this.utilService.getAccessTokenForODBBackup(cloud.getCloudId());
                GraphServiceClient<Request> graphClient = null;
                OkHttpClient okHttpClient = null;
                if (cloud.getGraphApiEnabled() == 1) {
                    graphClient = OneDriveUtil.getGraphClient();
                    okHttpClient = Graph.getInstance().getOkHttpClient();
                }
                UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(new Option[0])).get();
                List currentPage = iUserCollectionPage.getCurrentPage();
                User userFound = null;
                for (User user : currentPage) {
                    if (user.mail == null || user.mail != null && !user.mail.equalsIgnoreCase(mailUserName)) continue;
                    logger.debug(user.mail + ".... " + user.displayName + "..." + user.id);
                    userFound = user;
                }
                String userId = userFound.id;
                logger.debug(userId + ".... beforegettting user  ..." + userId);
                boolean isTasksExists = this.isTasksExist(userId, itemId, accessToken);
                if (isTasksExists) {
                    logger.debug("... task already exists so skip restore again ...");
                    break block74;
                }
                if (CollectionUtils.isEmpty((Collection)backupFile.getChunkFiles())) {
                    logger.debug("... trying to create tasks from pg content id..." + backupFile.getId());
                    FileInfo fileInfo = this.fileDao.getFileFromPG(userName, cloudName, backupFile.getId(), false);
                    List list = fileInfo.getChunkFiles();
                    Collections.sort(list);
                    String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
                    if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
                        deviceTempPath = deviceTempPath + "/" + fileInfo.getBatchId();
                    }
                    String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
                    logger.debug(userName + " file mail sssssss from pg.................." + mailUserName);
                    tempdownloadDir = new File(chunkFilePath);
                    if (!tempdownloadDir.exists()) {
                        tempdownloadDir.mkdirs();
                    }
                    HttpClient httpclient = null;
                    HttpPost httpPost = null;
                    HttpResponse response = null;
                    try {
                        for (String chunkName : list) {
                            int endIndex;
                            if (!StringUtils.isEmpty((String)chunkName) && chunkName.startsWith("part") && (endIndex = chunkName.lastIndexOf(46)) != -1) {
                                chunkName = chunkName.substring(0, endIndex);
                            }
                            logger.debug(" file from pg ss.................." + chunkName);
                            String filePath = chunkFilePath + "/" + chunkName;
                            File file = new File(filePath);
                            if (file.exists()) {
                                long size = file.length();
                                logger.debug(size + " file from pg.size................." + filePath);
                                JsonParser jsonParser = new JsonParser();
                                JSONObject jsonObject = null;
                                try (FileReader reader2 = new FileReader(file);){
                                    JsonElement obj = jsonParser.parse((Reader)new FileReader(file));
                                    jsonObject = (JSONObject)obj;
                                }
                                catch (FileNotFoundException reader2) {
                                }
                                catch (IOException reader2) {
                                }
                                catch (JSONException reader2) {
                                    // empty catch block
                                }
                                if (jsonObject != null) {
                                    logger.debug(".....beta jsonresults tasks...." + jsonObject.toString());
                                    if (differentDest) {
                                        this.differentuserTaskRestore(mailUserName, cloudId, jsonObject);
                                        continue;
                                    }
                                    String url = "https://graph.microsoft.com/beta/users/" + userId + "/outlook/tasks";
                                    logger.debug(".....after beta jsonresults tasks...." + jsonObject.toString());
                                    httpclient = HttpClientUtil.getSSlConnection();
                                    httpPost = new HttpPost(url);
                                    httpPost.setHeader("Content-Type", "application/json");
                                    httpPost.setHeader("Authorization", "Bearer " + accessToken);
                                    StringEntity params = new StringEntity(jsonObject.toString());
                                    httpPost.setEntity((HttpEntity)params);
                                    response = httpclient.execute((HttpUriRequest)httpPost);
                                    logger.debug("after doing inplace restore status code :" + response.getStatusLine().getStatusCode());
                                    continue;
                                }
                                logger.error("...unable to restore contacts.... ");
                                continue;
                            }
                            logger.error(" file does not exists........" + filePath);
                        }
                        break block74;
                    }
                    catch (Exception e) {
                        logger.error(".... exception......" + e.getMessage());
                        break block74;
                    }
                    finally {
                        httpPost.releaseConnection();
                    }
                }
                logger.debug("... trying to create contact from cloud content ...");
                List chunkFilesList = backupFile.getChunkFiles();
                int totalChunks = chunkFilesList.size();
                Collections.sort(chunkFilesList, new Comparator<com.pg.domain.ChunkFile>(){

                    @Override
                    public int compare(com.pg.domain.ChunkFile c1, com.pg.domain.ChunkFile c2) {
                        if (c1 == null || c2 == null || c1.getFileName() == null || c2.getFileName() == null) {
                            return -1;
                        }
                        return new CompareToBuilder().append((Object)c1.getFileName().toLowerCase(), (Object)c2.getFileName().toLowerCase()).toComparison();
                    }
                });
                HttpClient httpclient = null;
                HttpPost httpPost = null;
                HttpResponse response = null;
                try {
                    logger.debug(".... before creating message111 " + chunkFilesList.size());
                    for (com.pg.domain.ChunkFile chunkFile : chunkFilesList) {
                        Object pgChunkFile;
                        ChunkDetail chunkDetail;
                        block76: {
                            String dedupVal = this.getDedupValue(userName, false);
                            logger.debug("..before chunk detail...." + userName + "...." + dedupVal + "...ch..." + chunkFile.getMd5());
                            chunkDetail = null;
                            List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, false);
                            if (CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                                logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                                chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, true);
                            }
                            if (!CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                                for (ChunkDetail detailFromDB : chunkDetailList) {
                                    if (detailFromDB.getRefCount() <= 0 && detailFromDB.getClientDedupRefCount() <= 0) continue;
                                    chunkDetail = detailFromDB;
                                }
                            }
                            try {
                                if (chunkDetail == null) {
                                    logger.debug(CHUNK_DETAILS_NULL);
                                    chunkDetail = new ChunkDetail();
                                    chunkDetail.setCloudChunkName(chunkFile.getFileName());
                                    chunkDetail.setUserName(userName);
                                    chunkDetail.setContainerName(userName.toLowerCase());
                                    chunkDetail.setMd5(chunkFile.getMd5());
                                }
                                logger.debug(CLOUD_CHUNK_NAME + chunkDetail.getCloudChunkName());
                                String backupId = backupFile.getId();
                                String containerName = chunkDetail.getContainerName();
                                StringBuilder fileNameToDownload = new StringBuilder();
                                fileNameToDownload.append(chunkDetail.getCloudChunkName());
                                int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
                                if (occurance == 0 || occurance == 1 && chunkFilesList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                                    fileNameToDownload.append(".").append(backupId);
                                }
                                if (chunkDetail != null) {
                                    containerName = chunkDetail.getContainerName();
                                    if (!StringUtils.isEmpty((String)chunkDetail.getCloudStoragePath())) {
                                        chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                                    }
                                }
                                pgChunkFile = new com.pg.domain.ChunkFile();
                                BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
                                boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
                                String fileToDownload = fileNameToDownload.toString();
                                if (isGDEnabled) {
                                    fileToDownload = chunkDetail.getCloudChunkName();
                                    logger.debug(fileNameToDownload.toString() + "....chunk fileid... " + chunkDetail.getCloudChunkName());
                                }
                                logger.debug(chunkFile.getCloudStoragePath() + LOOP_BEFORE_DOWNLOAD_FILE + fileToDownload + " ..new");
                                FileStatusElement fileStatusElement = new FileStatusElement();
                                inputStream = this.cloudSupportService.downloadFile(cloud, tempdownloadDir.getPath(), fileToDownload, userName, backupFile.getDeviceUUID(), containerName, (com.pg.domain.ChunkFile)pgChunkFile, false, backupFile, fileStatusElement, chunkDetail.getUserName(), chunkDetail, "", graphClient, okHttpClient);
                                if (inputStream != null) break block76;
                                break;
                            }
                            catch (Exception e) {
                                logger.trace("" + e);
                                try {
                                    if (inputStream != null) {
                                        inputStream.close();
                                    }
                                }
                                catch (IOException e1) {
                                    logger.trace("" + e1);
                                    logger.error(EXCEPTION_WHILE_DOWNLOADING_FILE_FROM_CLOUD + e1.getMessage());
                                }
                                logger.error(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                                throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
                            }
                        }
                        String saltKeyTemp = this.getEncryptOrDecryptKey(cloud.getCloudId(), chunkFile.getUploadedTimeStamp(), BACKUP);
                        logger.debug(userName + "...users...." + chunkDetail.getUserName());
                        File decryptedFile = this.downloadService.getDecryptedFileForPortal(cloudName, saltKeyTemp, deviceUUID, chunkFile.getFileName(), inputStream, chunkDetail.getUserName(), path, chunkFile, cloudId, chunkDetail);
                        JsonParser jsonParser = new JsonParser();
                        JSONObject jsonObject = null;
                        try {
                            FileReader reader = new FileReader(decryptedFile);
                            pgChunkFile = null;
                            try {
                                JsonElement obj = jsonParser.parse((Reader)new FileReader(decryptedFile));
                                jsonObject = (JSONObject)obj;
                            }
                            catch (Throwable throwable) {
                                pgChunkFile = throwable;
                                throw throwable;
                            }
                            finally {
                                if (reader != null) {
                                    if (pgChunkFile != null) {
                                        try {
                                            reader.close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)pgChunkFile).addSuppressed(throwable);
                                        }
                                    } else {
                                        reader.close();
                                    }
                                }
                            }
                        }
                        catch (FileNotFoundException reader) {
                        }
                        catch (IOException reader) {
                        }
                        catch (JSONException reader) {
                            // empty catch block
                        }
                        if (jsonObject != null) {
                            logger.debug(".....beta jsonresults tasks...." + jsonObject.toString());
                            if (differentDest) {
                                this.differentuserTaskRestore(mailUserName, cloudId, jsonObject);
                            } else {
                                String url = "https://graph.microsoft.com/beta/users/" + userId + "/outlook/tasks";
                                logger.debug(".....after beta jsonresults tasks...." + jsonObject.toString());
                                httpclient = HttpClientUtil.getSSlConnection();
                                httpPost = new HttpPost(url);
                                httpPost.setHeader("Content-Type", "application/json");
                                httpPost.setHeader("Authorization", "Bearer " + accessToken);
                                StringEntity params = new StringEntity(jsonObject.toString());
                                httpPost.setEntity((HttpEntity)params);
                                response = httpclient.execute((HttpUriRequest)httpPost);
                                logger.debug("after doing inplace restore status code :" + response.getStatusLine().getStatusCode());
                            }
                        } else {
                            logger.error("...unable to restore contacts.... ");
                        }
                        logger.debug(" remaining chunks ......" + --totalChunks);
                    }
                }
                catch (Exception e) {
                    logger.error(".... exception......" + e.getMessage());
                }
                finally {
                    httpPost.releaseConnection();
                }
            }
            catch (Exception e) {
                logger.error(".... unable to do inplace restore ... " + e.getMessage());
            }
        }
    }

    private void differentuserTaskRestore(String mailUserName, int cloudId, JSONObject jsonObject) throws Exception {
        EWSAppSetting appSetting = this.utilService.getEwsAppSettingDetail(cloudId);
        String token = SyncDownloadServiceImpl.getEWSAccesToken(appSetting);
        logger.debug(appSetting.getAccountId() + ".....diff user upload tasks ... " + token);
        ExchangeService service = SyncDownloadServiceImpl.getAuthenticatedService(token, appSetting.getAccountId());
        Mailbox userMailbox = new Mailbox(mailUserName);
        FolderId folderIdTasks = new FolderId(WellKnownFolderName.Tasks, userMailbox);
        Task task = new Task(service);
        try {
            Date dateva;
            String date;
            JSONObject dateObject;
            if (jsonObject.get("subject") != null) {
                task.setSubject((String)jsonObject.get("subject"));
            }
            SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            if (jsonObject.get("dueDateTime") != null && (dateObject = (JSONObject)jsonObject.get("dueDateTime")) != null) {
                String date2 = (String)dateObject.get("dateTime");
                Date dateva2 = inputFormat.parse(date2);
                task.setDueDate(dateva2);
            }
            if (jsonObject.get("importance") != null) {
                task.setImportance(Importance.valueOf((String)StringUtils.capitalize((String)((String)jsonObject.get("importance")))));
            }
            if (jsonObject.get("isReminderOn") != null) {
                task.setIsReminderSet((Boolean)jsonObject.get("isReminderOn"));
            }
            if (jsonObject.get("reminderDateTime") != null) {
                date = (String)jsonObject.get("reminderDateTime");
                dateva = inputFormat.parse(date);
                task.setReminderDueBy(dateva);
            }
            if (jsonObject.get("startDateTime") != null) {
                date = (String)jsonObject.get("startDateTime");
                dateva = inputFormat.parse(date);
                task.setStartDate(dateva);
            }
            if (jsonObject.get("completedDateTime") != null) {
                date = (String)jsonObject.get("completedDateTime");
                dateva = inputFormat.parse(date);
                task.setCompleteDate(dateva);
            }
            if (jsonObject.get("sensitivity") != null) {
                task.setSensitivity(Sensitivity.valueOf((String)StringUtils.capitalize((String)((String)jsonObject.get("sensitivity")))));
            }
            task.save(folderIdTasks);
            logger.debug(".....translated objec ... " + task.getSubject());
        }
        catch (Exception e) {
            logger.error("...unable to delete " + e.getMessage());
        }
    }

    private void closeResponse(CloseableHttpResponse result) {
        if (result != null) {
            try {
                result.close();
            }
            catch (IOException e) {
                logger.error("error in closing http client:" + e.getMessage());
            }
        }
    }

    private String getEncodedFileName(boolean isEncodedEnabled, String fileName) {
        String fileNameInHeader = FILE_NAME + fileName;
        try {
            if (isEncodedEnabled) {
                fileNameInHeader = FILE_NAME + this.encodeUTFBase64(fileName);
                return fileNameInHeader;
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("" + e);
        }
        return fileNameInHeader;
    }

    protected String encodeUTFBase64(String input) {
        try {
            return Base64.encodeBase64String((byte[])input.getBytes(UTF8));
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("UnsupportedEncodingException", (Throwable)e);
            return input;
        }
    }

    private String getEncodedFilePath(boolean isEncodedEnabled, String filePath) {
        String filePathInHeader = FILE_PATH + filePath;
        try {
            if (isEncodedEnabled) {
                filePathInHeader = FILE_PATH + this.encodeUTFBase64(filePath);
                return filePathInHeader;
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("" + e);
        }
        return filePathInHeader;
    }

    private File copyInputStreamToAFile(String fileName, BufferedInputStream inputStreamTemp, File decryptedDir) {
        String copyPath = decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName + COPY;
        try {
            FileUtils.copyInputStreamToFile((InputStream)inputStreamTemp, (File)new File(copyPath));
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error("Exception while copying::" + e.getMessage());
        }
        File copyFile = new File(decryptedDir + "/" + fileName + COPY);
        return copyFile;
    }

    private File createDecryptedDirs(String restorePath) {
        File decryptedDir = new File(restorePath + "temp");
        if (!decryptedDir.exists()) {
            decryptedDir.mkdir();
        }
        return decryptedDir;
    }

    private boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"ODB Enabled".equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }
}

