/*
 * Decompiled with CFR 0.152.
 */
package com.pg.controller;

import com.mongodb.MongoException;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.InclusionFilter;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.SearchIndex;
import com.parablu.pcbd.domain.User;
import com.pg.controller.BaseController;
import com.pg.domain.BackupFile;
import com.pg.domain.BackupLog;
import com.pg.domain.ContentChunkFile;
import com.pg.domain.FileInfo;
import com.pg.element.BackupElement;
import com.pg.element.BluKryptElement;
import com.pg.element.ChunkFileElement;
import com.pg.element.FileUploadDetailsElement;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MD5Generator;
import com.pg.helper.utils.MemoryStore;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.service.BackupService;
import com.pg.service.ChunkableUploadService;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jms.UncategorizedJmsException;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class UploadController
extends BaseController {
    private static final String IS_TOMCAT_RUNNING = "isTomcatRunning";
    public static final String HYPHEN_BOTH = "-Both";
    private static Logger logger = LogManager.getLogger(UploadController.class);
    @Autowired
    private UploadService uploadService;
    @Autowired
    private ChunkableUploadService chunkableUploadService;
    @Autowired
    private BackupService backupService;
    @Autowired
    private UtilService utilService;
    private static final String USER_STORAGE_LIMIT_REACHED = " User Storage limit reached ..... ";
    private static final String DIRECT_CALL_STORAGE_LIMIT1 = " direct call .... storage limit .......";
    private static final String UPLOAD_COUNT = "uploadCount";
    private static final String DEVICEUUID_MAP_IN_MEMSTORE = "deviceUUIDMapInMemstore";
    private static final String HYPHEN_FULL = "-FULL";
    public static final String FILE_NOT_EXISTS = "File Not exists";
    private static final String HYPHEN_INCRE = "-INCRE";
    private static final String JOB_ID = "JobId";
    private static final String CHUNK = "chunk";
    private static final String UNABLE_TO_DELETE = " unable to delete ... ";
    private static final String PG_OVERLOAD_LIMIT_REACHED = " PG OVERLOAD limit reached ..... ";
    private static final String MSP_ENVIRONMENT_ENABLED = "MSP Environment Enabled";
    private static final String ALREADY_EXISTS = "ALREADY_EXISTS";
    private static final String BATCH_ID_LOG = "##batch id >>>>";
    private static final String IS_A_CHUNK_FILE = "isAChunkFile";
    private static final String PARACLOUD_CLOUD = "/paracloud/cloud/";
    private static final String BACKUP_ID = "backupId";
    private static final String FALSE = "false";
    private static final String IS_NORMAL_FILE = "isNormalFile";
    private static final String STOPPED_BACKUP_ERROR_CODE = "1207";
    private static final String STOPPED_BACKUP_ADMIN_ERROR_CODE = "1209";
    private static final String PAUSED_BACKUP_ERROR_CODE = "1992";
    private static final String PAUSED_BACKUP_ADMIN_ERROR_CODE = "1208";
    private TimerTask contentChunkWatchTask = null;
    private Timer contentChunkWatchTimer = null;
    private static final String AV_SCAN_ENABLED = "AV Scan Enabled";
    private static final int FILE_SIZE_4GB = 4000;
    static final String lineSeparator = System.getProperty("line.separator");
    private ExecutorService executor = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/upload/files/all"}, method={RequestMethod.POST})
    public void uploadMultiPartFiles(HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("Start multipart file DEBUG.........");
        String boundary = "--PARABLUEOF";
        byte[] bryBytes = boundary.getBytes();
        String deviceUUID = "";
        String batchId = "";
        BufferedInputStream in = null;
        Map<String, String> headerMap = null;
        int response = 0;
        long startTimeStamp = System.currentTimeMillis();
        try {
            in = new BufferedInputStream((InputStream)request.getInputStream(), 10240);
            MultipartStream multipartStream = new MultipartStream((InputStream)in, bryBytes, 4096);
            boolean nextPart = multipartStream.skipPreamble();
            logger.debug(" nextpart ...... " + nextPart + "<<<<<<<<<");
            boolean isFirstPart = false;
            int totalNoOfFiles = 0;
            long totalSize = 0L;
            Cloud cloud = this.utilService.getCloud(1);
            Device device = null;
            int cloudId = cloud.getCloudId();
            String cloudName = cloud.getCloudName();
            String userName = "";
            boolean isFullBackup = false;
            boolean anySuccessUpload = false;
            ArrayList<BackupFile> failedList = new ArrayList<BackupFile>();
            boolean isMSPEnv = false;
            long policyStorageSizeAllowed = 0L;
            ArrayList<String> entropyOp = new ArrayList<String>();
            AtomicLong numberOfFilesInfected = new AtomicLong(0L);
            long totalSizeToUpload = 0L;
            int chunkCountToVerifyIncoming = 0;
            boolean isSync = false;
            Boolean isrwLicenseEnabled = this.isLicenseEnabled(cloud, "RW License Allowed");
            while (nextPart) {
                MiniCloud miniCloud;
                BackupBatch backupBatch;
                String header = multipartStream.readHeaders();
                logger.debug(header + " header:");
                logger.debug(numberOfFilesInfected.get() + " numberOfFilesInfected:::");
                headerMap = UploadController.parseHeader(header);
                if (!StringUtils.isEmpty((String)headerMap.get("isSync"))) {
                    isSync = Boolean.parseBoolean(headerMap.get("isSync"));
                }
                boolean isTomcatRunning = true;
                if (MemoryStore.get((String)IS_TOMCAT_RUNNING) != null) {
                    isTomcatRunning = (Boolean)MemoryStore.get((String)IS_TOMCAT_RUNNING);
                }
                UploadController.printLogs("........Is tomcat running........." + isTomcatRunning, PCHelperConstant.isBrevityLogging());
                if (!isTomcatRunning) {
                    httpResponse.setStatus(502);
                    logger.error("..Tomcat is going to be stopped.. so not accepting backup....");
                    return;
                }
                if (MemoryStore.get((String)"threadsCountModified") != null) {
                    long diff = this.getTheadsModifiedValDiff();
                    if (diff > 240000L) {
                        logger.error("..pg overload limit changed waited for 4 mins...." + diff);
                        MemoryStore.delete((String)"threadsCountModified");
                        MemoryStore.delete((String)DEVICEUUID_MAP_IN_MEMSTORE);
                    } else {
                        httpResponse.setStatus(502);
                        logger.error("..pg overload limit changed so wait for 4 mins...." + diff);
                        return;
                    }
                }
                if (chunkCountToVerifyIncoming >= PCHelperConstant.getNumOfChunksToCheckPgOverloadLimit()) {
                    chunkCountToVerifyIncoming = 0;
                    logger.error(userName + "..going to check overload limit...");
                    if (PCHelperConstant.getPGOverloadLimit() == 0) {
                        httpResponse.setStatus(502);
                        logger.error(userName + "...incoming set to zero..." + PG_OVERLOAD_LIMIT_REACHED);
                        return;
                    }
                } else {
                    ++chunkCountToVerifyIncoming;
                }
                if (!isFirstPart) {
                    deviceUUID = headerMap.get("deviceUUID");
                    batchId = headerMap.get("backupBatchId");
                    device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
                    if (device == null) {
                        httpResponse.setStatus(400);
                        logger.error(userName + "...Invalid device......" + deviceUUID);
                        return;
                    }
                    isFullBackup = this.isDeviceFullBackup(cloudId, deviceUUID);
                    logger.debug("valof...batchid." + batchId + "..." + "-1".equals(batchId));
                    if (org.springframework.util.StringUtils.isEmpty((Object)batchId) || "-1".equals(batchId)) {
                        logger.debug("#$#$... batchid -1... " + batchId + "...device..." + deviceUUID);
                        httpResponse.setStatus(502);
                        logger.error(PG_OVERLOAD_LIMIT_REACHED);
                        return;
                    }
                    userName = headerMap.get("userName");
                    isFirstPart = true;
                }
                if ((backupBatch = this.utilService.getBackupBatchById(cloudId, batchId)) != null && StringUtils.isNotEmpty((String)backupBatch.getErrorCode()) && (backupBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE) || backupBatch.getErrorCode().equals(PAUSED_BACKUP_ERROR_CODE) || backupBatch.getErrorCode().equals(STOPPED_BACKUP_ADMIN_ERROR_CODE) || backupBatch.getErrorCode().equals(PAUSED_BACKUP_ADMIN_ERROR_CODE))) {
                    if (backupBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE) || backupBatch.getErrorCode().equals(STOPPED_BACKUP_ADMIN_ERROR_CODE)) {
                        httpResponse.setStatus(429);
                    } else {
                        httpResponse.setStatus(428);
                    }
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    return;
                }
                this.updateDeviceMapForChunk(deviceUUID, isFullBackup);
                double fileSizeInMb = this.getFileSizeInMb(headerMap);
                User user = this.utilService.getUserInfoByName(cloudId, userName);
                List<CloudCustomisableDetails> cloudCustomisableDetails = this.utilService.getCloudLicenseDetails(cloudName);
                for (CloudCustomisableDetails cloudCustomisableDetail : cloudCustomisableDetails) {
                    if (!MSP_ENVIRONMENT_ENABLED.equals(cloudCustomisableDetail.getName())) continue;
                    isMSPEnv = true;
                    break;
                }
                logger.debug("check if it is MSP Env={}", (Object)isMSPEnv);
                if (isMSPEnv) {
                    long MSPTotalStorageUsed = 0L;
                    String policyName = user.getPolicyName();
                    logger.debug("Env=MSP, user policyName={}", (Object)policyName);
                    BackupPolicy backupPolicy = null;
                    backupPolicy = this.utilService.getBackupPolicy(cloudId, policyName);
                    policyStorageSizeAllowed = backupPolicy.getPolicyStorageSizeAllowed();
                    logger.debug("Env=MSP, policyStorageSizeAllowed={}", (Object)policyStorageSizeAllowed);
                    List<DeviceBackupOverView> deviceBackupOverviewForPolicy = this.utilService.getDeviceBkpOverviewForPolicyName(cloudId, policyName);
                    logger.debug("total records of deviceBackupOverviewForPolicy={}", (Object)deviceBackupOverviewForPolicy.size());
                    for (DeviceBackupOverView overview : deviceBackupOverviewForPolicy) {
                        MSPTotalStorageUsed += overview.getStorageUtilized();
                    }
                    logger.debug("Env=MSP, total storage used till now={}", (Object)MSPTotalStorageUsed);
                    boolean isMSPPolicyLimitReached = false;
                    isMSPPolicyLimitReached = this.utilService.isMSPPolicyStorageLimitReached(policyStorageSizeAllowed, fileSizeInMb, MSPTotalStorageUsed);
                    if (isMSPPolicyLimitReached) {
                        httpResponse.setStatus(507);
                        logger.error(userName + "Env=MSP, Server disk full for policy name={}", (Object)policyName);
                        return;
                    }
                }
                if (null != user && user.isSuspended()) {
                    logger.error("Cannot backup as user is suspended");
                    httpResponse.setStatus(400);
                    return;
                }
                boolean isUserStorageLimitReached = isSync ? this.utilService.isSyncUserStorageLimitReached(cloudId, fileSizeInMb, user.getUserName(), cloudName) : this.utilService.isUserStorageLimitReached(1, fileSizeInMb, user, deviceUUID);
                if (isUserStorageLimitReached) {
                    httpResponse.setStatus(449);
                    this.sendWarningMail(headerMap, this.utilService.userStorageLimit(cloudId, cloudName, device), device.getDeviceName());
                    logger.error(userName + USER_STORAGE_LIMIT_REACHED);
                    return;
                }
                String miniCloudId = null;
                if (!StringUtils.isEmpty((String)headerMap.get("miniCloudId"))) {
                    miniCloudId = headerMap.get("miniCloudId");
                    logger.debug("MiniCloudId in upload controller : " + miniCloudId);
                }
                if (isSync && miniCloudId != null && !miniCloudId.equalsIgnoreCase("0") && (miniCloud = this.uploadService.getMiniCloudById(cloudId, miniCloudId)) != null && !miniCloud.isAllowUpload()) {
                    httpResponse.setStatus(405);
                    logger.error(userName + "..minicloud upload limit reached...");
                    return;
                }
                if (this.isODBEnabled(cloud.getCloudCustomisableDetails()) && user != null && !user.isBackupTargetAssigned()) {
                    logger.debug(".....backupTargetAssigned is false so return..." + userName);
                    httpResponse.setStatus(543);
                    return;
                }
                String fileSizeInString = headerMap.get("file-size");
                boolean isMachineStorageReached = this.checkMachineStorage(fileSizeInString);
                if (isMachineStorageReached) {
                    httpResponse.setStatus(507);
                    logger.error(userName + "...Server disk full...");
                    return;
                }
                List<EventHub> eventHubForDeviceUUID = this.uploadService.getEventHubForDeviceUUID(cloudId, deviceUUID);
                List actions = eventHubForDeviceUUID.stream().filter(line -> Objects.nonNull(line.getAction())).map(line -> line.getAction()).collect(Collectors.toList());
                if (actions.contains("STOP_BACKUP_WHILE_RESTORE")) {
                    logger.debug("STOP_BACKUP_WHILE_RESTORE.....is enabled..");
                    BackupBatch lastRestoreBatch = this.utilService.getLastRestoreBatch(cloudId, deviceUUID);
                    if (lastRestoreBatch != null && !StringUtils.isEmpty((String)lastRestoreBatch.getStatus()) && lastRestoreBatch.getStatus().equalsIgnoreCase("STARTED")) {
                        logger.debug("batch is started so return ....");
                        httpResponse.setStatus(500);
                        return;
                    }
                }
                logger.debug("...valueof BatchID&...." + batchId + "...");
                httpResponse.setStatus(500);
                response = this.upload(headerMap, multipartStream, httpResponse, cloud, device, failedList, entropyOp, numberOfFilesInfected);
                if (response == 400) {
                    httpResponse.setStatus(500);
                    return;
                }
                if (!anySuccessUpload && response == 200) {
                    anySuccessUpload = true;
                }
                String isChunkOfAFile = FALSE;
                if (headerMap.get(IS_A_CHUNK_FILE) != null) {
                    isChunkOfAFile = headerMap.get(IS_A_CHUNK_FILE);
                }
                String NormalFile = "true";
                if (headerMap.get(IS_NORMAL_FILE) != null) {
                    NormalFile = headerMap.get(IS_NORMAL_FILE);
                }
                boolean isChunkOfFile = Boolean.parseBoolean(isChunkOfAFile);
                boolean isNormalFile = Boolean.parseBoolean(NormalFile);
                if (response == 200 && !isChunkOfFile) {
                    ++totalNoOfFiles;
                    long fileSize = Long.parseLong(headerMap.get("file-size"));
                    totalSize += fileSize;
                }
                if (backupBatch != null && backupBatch.getTotalSizeToUpload() != 0L) {
                    totalSizeToUpload = backupBatch.getTotalSizeToUpload();
                }
                logger.debug("Upload response code#####....." + response);
                logger.debug(numberOfFilesInfected.get() + " numberOfFilesInfected:::");
                nextPart = multipartStream.readBoundary();
            }
            if (anySuccessUpload) {
                this.updateBackupLog(headerMap, false, failedList);
                httpResponse.setStatus(200);
            }
            logger.debug("[backupBatch][" + userName + "][" + deviceUUID + "][" + batchId + "][" + startTimeStamp + "][" + System.currentTimeMillis() + "]");
            logger.debug("numberOfFilesInfected" + numberOfFilesInfected);
            if (!isSync) {
                this.utilService.updateBackBatchAndOverview(cloudId, batchId, totalNoOfFiles, totalSize, deviceUUID, totalSizeToUpload, numberOfFilesInfected.get());
            }
        }
        catch (IOException e) {
            this.closeInputStreamIfExists(request);
            logger.trace("" + e);
            this.utilService.updateInterruptedBackBatch(1, deviceUUID);
            if (MemoryStore.get((String)DEVICEUUID_MAP_IN_MEMSTORE) != null) {
                Map deviceUUIDMap = (Map)MemoryStore.get((String)DEVICEUUID_MAP_IN_MEMSTORE);
                deviceUUIDMap.remove(deviceUUID + HYPHEN_FULL);
                deviceUUIDMap.remove(deviceUUID + HYPHEN_INCRE);
            }
            logger.error(batchId + ".....IOException While Uploading Multipart Files :" + e.getMessage());
        }
        catch (MongoException | DataAccessResourceFailureException e) {
            logger.debug("................Inside DataAccessResourceFailureException..." + e.getMessage());
            httpResponse.setStatus(500);
            return;
        }
        catch (Exception e) {
            this.closeInputStreamIfExists(request);
            logger.trace("" + e);
            logger.error(".....Exception While Uploading Multipart Files :" + e.getMessage());
        }
        finally {
            this.closeInputStreamIfExists(request);
        }
        logger.debug("End multipart file.........DEBUG");
    }

    private long getTheadsModifiedValDiff() {
        long existValue = 0L;
        if (MemoryStore.get((String)"threadsCountModified") != null) {
            existValue = (Long)MemoryStore.get((String)"threadsCountModified");
        }
        long diff = System.currentTimeMillis() - existValue;
        return diff;
    }

    /*
     * Exception decompiling
     */
    private int upload(Map<String, String> headerMap, MultipartStream multipartStream, HttpServletResponse httpResponse, Cloud cloud, Device device, List<BackupFile> failedList, List<String> entropyOp, AtomicLong numberOfFilesInfected) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 81[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isClamAVScanEnabled(Cloud cl) {
        boolean isClamAVScanEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !AV_SCAN_ENABLED.equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isClamAVScanEnabled = true;
                break;
            }
        }
        logger.debug("is ClamAV Scan Enabled...." + isClamAVScanEnabled);
        return isClamAVScanEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTempFile(MessageDigest md, File[] filesList, File tempFolder, File tempFile, Boolean isNormalFile) throws IOException, FileNotFoundException {
        tempFolder.mkdirs();
        if (tempFile.exists()) {
            tempFile.delete();
        }
        tempFile.createNewFile();
        for (File file : filesList) {
            if (!file.isFile()) continue;
            logger.debug("..before write ....." + file.getAbsolutePath());
            InputStream gZIPInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(tempFile, true);
                if (!isNormalFile.booleanValue()) {
                    gZIPInputStream = new GZIPInputStream(gZIPInputStream);
                }
                byte[] b = new byte[4096];
                int buff = -1;
                while ((buff = gZIPInputStream.read(b)) != -1) {
                    fileOutputStream.write(b, 0, buff);
                    md.update(b, 0, buff);
                }
                logger.debug("..after write ....." + file.getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                logger.debug("Exception", (Throwable)e);
                tempFile.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.debug("Exception", (Throwable)e);
                tempFile.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.trace("" + e);
                logger.error("Exception While Transfering File From Stream :" + e.getMessage());
            }
            finally {
                IOUtils.closeQuietly((InputStream)gZIPInputStream);
                fileOutputStream.close();
            }
        }
    }

    private void addAuditHitsory(String cloudName, BluKryptElement bluKryptElement, String deviceName) throws UnsupportedEncodingException, IOException, ClientProtocolException {
        HttpClient httpclient = HttpClientUtil.getSSlConnection();
        String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + PARACLOUD_CLOUD + cloudName + "/sync/portal/upload/audit";
        logger.debug("INSIDEinsert for sync ..... " + url);
        HttpPost httpPost = new HttpPost(url);
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        entity.addPart("action", (ContentBody)new StringBody("ABCD"));
        entity.addPart("userName", (ContentBody)new StringBody(bluKryptElement.getUserName()));
        entity.addPart("fileName", (ContentBody)new StringBody(bluKryptElement.getFileName()));
        entity.addPart("filePath", (ContentBody)new StringBody(bluKryptElement.getFilePath()));
        entity.addPart("deviceName", (ContentBody)new StringBody(deviceName));
        httpPost.setEntity((HttpEntity)entity);
        logger.debug(bluKryptElement.getFileName() + "INSIDEinsert for sync ..... " + url + "  ...encodedFileName.." + bluKryptElement.getFileCompletePath());
        logger.debug(bluKryptElement.getUserName() + "INSIDEinsert for sync .....   ...encodedFileName..");
        HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/upload/files/all/contentchunk"}, method={RequestMethod.POST})
    public void uploadMultiPartFilesContent(HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("Start multipart file DEBUG.........");
        String boundary = "--PARABLUEOF";
        byte[] bryBytes = boundary.getBytes();
        String deviceUUID = "";
        String batchId = "";
        BufferedInputStream in = null;
        Map<String, String> headerMap = null;
        int response = 0;
        long startTimeStamp = System.currentTimeMillis();
        Future futureTask = null;
        boolean contentChunkJobStrted = false;
        int chunkCountToVerifyIncoming = 0;
        try {
            in = new BufferedInputStream((InputStream)request.getInputStream(), 10240);
            MultipartStream multipartStream = new MultipartStream((InputStream)in, bryBytes, 4096);
            boolean nextPart = multipartStream.skipPreamble();
            logger.debug(" nextpart ...... " + nextPart + "<<<<<<<<<");
            boolean isFirstPart = false;
            int totalNoOfFiles = 0;
            long totalSize = 0L;
            Cloud cloud = this.utilService.getCloud(1);
            Boolean isrwLicenseEnabled = this.isLicenseEnabled(cloud, "RW License Allowed");
            Device device = null;
            int cloudId = cloud.getCloudId();
            String cloudName = cloud.getCloudName();
            String userName = "";
            boolean isFullBackup = false;
            boolean anySuccessUpload = false;
            ArrayList<BackupFile> failedList = new ArrayList<BackupFile>();
            long totalSizeToUpload = 0L;
            String contentChunking = FALSE;
            String tablenameHash = null;
            String isChunkOfAFile = FALSE;
            boolean isChunkOfFile = false;
            String isNormalFile = "";
            String isChunkList = "true";
            ArrayList<ContentChunkFile> noContentChunkFileList = new ArrayList<ContentChunkFile>();
            if (this.executor == null) {
                logger.debug("executor threads:" + PCHelperConstant.getNumOfThreadsToUseForContentChunkFile());
                this.executor = Executors.newFixedThreadPool(PCHelperConstant.getNumOfThreadsToUseForContentChunkFile());
            }
            ArrayList<String> entropyOp = new ArrayList<String>();
            AtomicLong numberOfFilesInfected = new AtomicLong(0L);
            boolean isSync = false;
            while (nextPart) {
                boolean s;
                String header = multipartStream.readHeaders();
                logger.debug(header + " header:");
                headerMap = UploadController.parseHeader(header);
                tablenameHash = headerMap.get("tableNameHash");
                String missingChunk = headerMap.get("missing-chunk");
                isChunkList = headerMap.get("isChunkList");
                isNormalFile = headerMap.get(IS_NORMAL_FILE);
                batchId = headerMap.get("backupBatchId");
                userName = headerMap.get("userName");
                BackupPolicy backupPolicy = this.uploadService.getBackupPolicyForUser(cloudId, userName);
                if (headerMap.get(IS_A_CHUNK_FILE) != null) {
                    isChunkOfAFile = headerMap.get(IS_A_CHUNK_FILE);
                }
                if (!StringUtils.isEmpty((String)headerMap.get("isSync"))) {
                    isSync = Boolean.parseBoolean(headerMap.get("isSync"));
                }
                if (MemoryStore.get((String)"threadsCountModified") != null && !this.isMissingChunkPart(missingChunk) && Boolean.valueOf(isChunkOfAFile).booleanValue()) {
                    long diff = this.getTheadsModifiedValDiff();
                    if (diff > 240000L) {
                        logger.error("..pg overload limit changed waited for 4 mins...." + diff);
                        MemoryStore.delete((String)"threadsCountModified");
                        MemoryStore.delete((String)DEVICEUUID_MAP_IN_MEMSTORE);
                    } else {
                        httpResponse.setStatus(502);
                        logger.error("..pg overload limit changed so wait for default 4 mins...." + diff);
                        return;
                    }
                }
                if (chunkCountToVerifyIncoming >= PCHelperConstant.getNumOfChunksToCheckPgOverloadLimit() && !this.isMissingChunkPart(missingChunk) && Boolean.valueOf(isChunkOfAFile).booleanValue()) {
                    chunkCountToVerifyIncoming = 0;
                    logger.error(userName + "..going to check overload limit...");
                    if (PCHelperConstant.getPGOverloadLimit() == 0) {
                        httpResponse.setStatus(502);
                        logger.error(userName + "...incoming set to zero..." + PG_OVERLOAD_LIMIT_REACHED);
                        return;
                    }
                } else {
                    ++chunkCountToVerifyIncoming;
                }
                if (!isFirstPart && !this.isMissingChunkPart(missingChunk)) {
                    deviceUUID = headerMap.get("deviceUUID");
                    device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
                    if (device == null) {
                        httpResponse.setStatus(400);
                        logger.error(userName + "...Invalid device......" + deviceUUID);
                        return;
                    }
                    isFullBackup = this.isDeviceFullBackup(cloudId, deviceUUID);
                    logger.debug("valof...batchid." + batchId + "..." + "-1".equals(batchId));
                    if (org.springframework.util.StringUtils.isEmpty((Object)batchId) || "-1".equals(batchId)) {
                        logger.debug("#$#$... batchid -1... " + batchId + "...device..." + deviceUUID);
                        httpResponse.setStatus(502);
                        logger.error(PG_OVERLOAD_LIMIT_REACHED);
                        return;
                    }
                    contentChunking = headerMap.get("content-chunking");
                    if (StringUtils.isNotEmpty((String)contentChunking) && contentChunking.equalsIgnoreCase("true")) {
                        logger.debug(contentChunking + " iscontentChunking:::::::::");
                        if (!contentChunkJobStrted) {
                            this.deleteTablenChunkEntriesIfExistsWithSameHash(tablenameHash);
                            this.startContentChunkCheckJob(tablenameHash, userName, this.executor, futureTask, noContentChunkFileList, batchId);
                            contentChunkJobStrted = true;
                        }
                    }
                    isFirstPart = true;
                }
                User user = this.utilService.getUserInfoByName(cloudId, userName);
                logger.debug(isFirstPart + " isFirstPart:::::::::");
                if (isFirstPart && this.isODBEnabled(cloud.getCloudCustomisableDetails()) && user != null && !user.isBackupTargetAssigned()) {
                    logger.debug(".....backupTargetAssigned is false so return..." + userName);
                    httpResponse.setStatus(543);
                    return;
                }
                BackupBatch backupBatch = this.utilService.getBackupBatchById(cloudId, batchId);
                if (backupBatch != null && StringUtils.isNotEmpty((String)backupBatch.getErrorCode()) && (backupBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE) || backupBatch.getErrorCode().equals(PAUSED_BACKUP_ERROR_CODE) || backupBatch.getErrorCode().equals(STOPPED_BACKUP_ADMIN_ERROR_CODE) || backupBatch.getErrorCode().equals(PAUSED_BACKUP_ADMIN_ERROR_CODE))) {
                    if (backupBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE) || backupBatch.getErrorCode().equals(STOPPED_BACKUP_ADMIN_ERROR_CODE)) {
                        httpResponse.setStatus(429);
                    } else {
                        httpResponse.setStatus(428);
                    }
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    return;
                }
                boolean bl = s = Boolean.valueOf(isChunkOfAFile) != false && !this.isMissingChunkPart(missingChunk);
                if (Boolean.valueOf(isNormalFile).booleanValue() || s) {
                    this.updateDeviceMapForChunk(deviceUUID, isFullBackup);
                    double fileSizeInMb = this.getFileSizeInMb(headerMap);
                    boolean isUserStorageLimitReached = isSync ? this.utilService.isSyncUserStorageLimitReached(cloudId, fileSizeInMb, user.getUserName(), cloudName) : this.utilService.isUserStorageLimitReached(1, fileSizeInMb, user, deviceUUID);
                    if (isUserStorageLimitReached) {
                        httpResponse.setStatus(449);
                        this.sendWarningMail(headerMap, this.utilService.userStorageLimit(cloudId, cloudName, device), device.getDeviceName());
                        logger.error(userName + USER_STORAGE_LIMIT_REACHED);
                        return;
                    }
                    String fileSizeInString = headerMap.get("file-size");
                    boolean isMachineStorageReached = this.checkMachineStorage(fileSizeInString);
                    if (isMachineStorageReached) {
                        httpResponse.setStatus(507);
                        logger.error(userName + "...Server disk full...");
                        return;
                    }
                }
                String miniCloudId = null;
                if (Boolean.parseBoolean(isNormalFile) || s) {
                    MiniCloud miniCloud;
                    if (!StringUtils.isEmpty((String)headerMap.get("miniCloudId"))) {
                        miniCloudId = headerMap.get("miniCloudId");
                        logger.debug("MiniCloudId in upload controller : " + miniCloudId);
                    }
                    if (isSync && miniCloudId != null && !miniCloudId.equalsIgnoreCase("0") && (miniCloud = this.uploadService.getMiniCloudById(cloudId, miniCloudId)) != null && !miniCloud.isAllowUpload()) {
                        httpResponse.setStatus(405);
                        logger.error(userName + "..minicloud upload limit reached...");
                        return;
                    }
                }
                logger.debug("...valueof BatchID&...." + batchId + "...");
                httpResponse.setStatus(500);
                response = this.uploadContentChunk(headerMap, multipartStream, httpResponse, cloudId, device, failedList, cloud, entropyOp, numberOfFilesInfected);
                logger.debug("..........entropyOp size...." + entropyOp.size());
                if (response == 400) {
                    httpResponse.setStatus(500);
                    return;
                }
                if (!anySuccessUpload && response == 200) {
                    anySuccessUpload = true;
                }
                if (!(isChunkOfFile = Boolean.parseBoolean(isChunkOfAFile)) && !this.isMissingChunkPart(missingChunk)) {
                    logger.debug("not isChunkOfFile and not missingChunk.......s");
                    this.createContentChunkAndSave(headerMap, "endoffile", false, cloudName);
                }
                if (response == 200 && !isChunkOfFile && Boolean.parseBoolean(isChunkList)) {
                    ++totalNoOfFiles;
                    long fileSize = Long.parseLong(headerMap.get("file-size"));
                    totalSize += fileSize;
                }
                if (backupBatch != null && backupBatch.getTotalSizeToUpload() != 0L) {
                    totalSizeToUpload = backupBatch.getTotalSizeToUpload();
                }
                logger.debug("Upload response code#####....." + response);
                nextPart = multipartStream.readBoundary();
            }
            if (anySuccessUpload) {
                logger.debug("Check the task is completed>>>>>>>>");
                httpResponse.setStatus(200);
                if (this.executor != null && futureTask != null) {
                    while (!futureTask.isDone()) {
                        this.setDummycontentInResponse(httpResponse);
                    }
                    logger.debug("FUTURE TASK DONE:" + futureTask.isDone());
                    if (futureTask.isDone()) {
                        logger.debug(futureTask.get() + ">>>>>>>>>>>noContentChunkFileList size:" + noContentChunkFileList.size());
                        this.setAllDedupNotFoundFiles(tablenameHash, httpResponse, noContentChunkFileList);
                    }
                }
                logger.debug("isChunkOfFile:" + isChunkOfFile + "..." + Boolean.parseBoolean(isChunkList) + "...normal:" + isNormalFile);
                if (!isChunkOfFile && Boolean.parseBoolean(isChunkList) || Boolean.parseBoolean(isNormalFile)) {
                    this.updateBackupLog(headerMap, false, failedList);
                    logger.debug("La importancia de - deleting the temp mongo collection..");
                    this.uploadService.removeContentChunkTableFromMongo(tablenameHash, "contentChunk");
                    this.uploadService.moveChunkDetailFromTempColl(tablenameHash);
                    logger.debug("La importancia de - deleted the temp mongo collection..");
                }
            }
            logger.debug("[backupBatch][" + userName + "][" + deviceUUID + "][" + batchId + "][" + startTimeStamp + "][" + System.currentTimeMillis() + "]");
            if (!isChunkOfFile && Boolean.parseBoolean(isChunkList) || Boolean.parseBoolean(isNormalFile)) {
                this.utilService.updateBackBatchAndOverview(cloudId, batchId, totalNoOfFiles, totalSize, deviceUUID, totalSizeToUpload, numberOfFilesInfected.get());
            }
        }
        catch (IOException e) {
            this.closeInputStreamIfExists(request);
            logger.trace("" + e);
            this.utilService.updateInterruptedBackBatch(1, deviceUUID);
            if (MemoryStore.get((String)DEVICEUUID_MAP_IN_MEMSTORE) != null) {
                Map deviceUUIDMap = (Map)MemoryStore.get((String)DEVICEUUID_MAP_IN_MEMSTORE);
                deviceUUIDMap.remove(deviceUUID + HYPHEN_FULL);
                deviceUUIDMap.remove(deviceUUID + HYPHEN_INCRE);
            }
            logger.error(batchId + ".....IOException While Uploading Multipart Files :", (Throwable)e);
        }
        catch (MongoException | DataAccessResourceFailureException e) {
            logger.debug("................Inside DataAccessResourceFailureException..." + e.getMessage());
            httpResponse.setStatus(500);
            return;
        }
        catch (Exception e) {
            this.closeInputStreamIfExists(request);
            logger.trace("" + e);
            logger.error(".....Exception While Uploading Multipart Files :" + e.getMessage());
        }
        finally {
            this.closeInputStreamIfExists(request);
        }
        logger.debug("End multipart file.........DEBUG");
    }

    private boolean findAvgOfEntropies(List<String> entropyOp, String fileName) {
        logger.debug(" before finding file entropy avg ..........." + entropyOp.size());
        File inputFile = this.getAvgEntropy(entropyOp, fileName);
        entropyOp.clear();
        entropyOp = new ArrayList<String>();
        boolean isEncrypted = this.backupService.runRwDetectionScript(inputFile);
        return isEncrypted;
    }

    private void stopContentJbExecutor1(ExecutorService executor) {
        if (executor != null) {
            logger.debug("interrupting the current thread..");
            Thread.currentThread().interrupt();
            executor.shutdownNow();
            while (!executor.isTerminated()) {
                Thread.currentThread().interrupt();
                logger.debug("executor is  not terminated so interrupt again in loop..");
                executor.shutdownNow();
            }
        }
        executor = null;
    }

    private void deleteTablenChunkEntriesIfExistsWithSameHash(String tablenameHash) {
        logger.debug("inside delete table if laready exists witht same hash");
        this.uploadService.deleteTablenChunkEntriesIfExistsWithSameHash(tablenameHash);
    }

    private boolean isMissingChunkPart(String missingChunk) {
        return StringUtils.isNotEmpty((String)missingChunk) && missingChunk.equalsIgnoreCase("true");
    }

    private List<ContentChunkFile> setAllDedupNotFoundFiles(String tablenameHash, HttpServletResponse httpResponse, List<ContentChunkFile> contentChunkFileDedupNotFoundList) {
        try {
            List<ContentChunkFile> contentChunkFileList = this.uploadService.getFilesForContentChnkStatus(tablenameHash, "NoDedupNoContent", 0);
            if (CollectionUtils.isEmpty(contentChunkFileList)) {
                logger.debug("No chunks found....");
                return contentChunkFileDedupNotFoundList;
            }
            logger.debug("Chunk not found list.....size:" + contentChunkFileList.size());
            for (ContentChunkFile contentChunkFile : contentChunkFileList) {
                if (contentChunkFile.getFileName().equalsIgnoreCase("endoffile")) {
                    logger.debug("WE hit the end of the table  so break...");
                    break;
                }
                if (contentChunkFile.isContentPresent() || contentChunkFile.isChunkFound()) continue;
                logger.debug("Content present is false and chunk found is false...");
                httpResponse.getWriter().write(contentChunkFile.getFileName() + "," + contentChunkFile.getOffset() + "," + contentChunkFile.getSize() + "|");
                this.uploadService.removeContentChunkFileInfoInMongo(contentChunkFile, tablenameHash, "");
            }
            httpResponse.getWriter().flush();
            httpResponse.getWriter().close();
        }
        catch (Exception e) {
            logger.error("exception in sending dedup not found dataaa", (Throwable)e);
        }
        return contentChunkFileDedupNotFoundList;
    }

    private void setDummycontentInResponse(HttpServletResponse httpResponse) {
        try {
            httpResponse.getWriter().write("reject this content\n");
        }
        catch (Exception e) {
            logger.error("exception in sending dedup not found dataaa", (Throwable)e);
        }
    }

    private Future<Boolean> startContentChunkCheckJob(String tablenameHash, String userName, ExecutorService executor, Future<Boolean> futureTask, List<ContentChunkFile> contentChunkFileList, String batchId) {
        if (executor == null) {
            logger.debug("Executor is null....so return");
            return null;
        }
        Runnable uploadJob = () -> {
            if (!Thread.currentThread().getName().endsWith("-CCT")) {
                Thread.currentThread().setName(Thread.currentThread().getName() + "-CCT");
            }
            this.checkChunkStatus(tablenameHash, userName, executor, contentChunkFileList, batchId);
        };
        futureTask = executor.submit(uploadJob, true);
        return futureTask;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void checkChunkStatus(String filenameHash, String userName, ExecutorService executor, List<ContentChunkFile> NoContentChunkFileList, String batchId) {
        UploadController.logger.debug("inside check chunk status.." + filenameHash);
        contentChunkFileList = new ArrayList<E>();
        skipValue = 0;
        endOfCollection = false;
        secsWaited = 0;
        block2: do {
            if (Thread.currentThread().isInterrupted()) {
                UploadController.logger.debug("thread is interrrupted so return.....");
                return;
            }
            contentChunkFileList = this.uploadService.getFilesForContentChnkStatus(filenameHash, "NoDedupNoContent", skipValue);
            UploadController.logger.debug(skipValue + ":skip value........list size............" + contentChunkFileList.size());
            skipValue += contentChunkFileList.size();
            if (CollectionUtils.isEmpty(contentChunkFileList)) {
                UploadController.logger.debug(secsWaited + "..inside check chunk status and list is empty so wait and retry..");
                try {
                    Thread.sleep(1000L);
                    if (++secsWaited < 1800) ** GOTO lbl36
                    endOfCollection = true;
                    UploadController.logger.debug("Looks like the backup is interrupted so breaking...");
                }
                catch (InterruptedException e) {
                    UploadController.logger.error("interruption", (Throwable)e);
                    UploadController.logger.debug("thread is interrrupted so return.....");
                    return;
                }
            } else {
                secsWaited = 0;
                for (ContentChunkFile contentChunkFile : contentChunkFileList) {
                    UploadController.logger.debug("content chunk file name:$$$$$$$$$$$$$$$" + contentChunkFile.getFileName());
                    if (contentChunkFile.getFileName().equalsIgnoreCase("endoffile")) {
                        UploadController.logger.debug("WE hit the end of the table  so break...");
                        endOfCollection = true;
                        continue block2;
                    }
                    if (contentChunkFile.isChunkFound()) continue;
                    UploadController.logger.debug("chunk found is false...");
                    this.uploadService.updateStatusOfContentChnkFile(userName, contentChunkFile, filenameHash, NoContentChunkFileList, batchId);
                }
            }
lbl36:
            // 4 sources

        } while (!endOfCollection);
    }

    /*
     * Exception decompiling
     */
    private int uploadContentChunk(Map<String, String> headerMap, MultipartStream multipartStream, HttpServletResponse httpResponse, int cloudId, Device device, List<BackupFile> failedList, Cloud cloud, List<String> entropyOp, AtomicLong numberOfFilesInfected) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 85[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> getEntropy(List<String> entropyOp, String batchId, InputStream inputStream, String isChunkOfAFile, String isCompressed, ChunkFileElement chunkFileElement) throws IOException {
        try {
            String inputFile = PCHelperConstant.getMntTempChunkPath() + chunkFileElement.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkFileElement.getFileName();
            String outputFile = PCHelperConstant.getMntTempChunkPath() + chunkFileElement.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkFileElement.getFileName() + "uncompressed";
            if (Boolean.parseBoolean(isChunkOfAFile) || Boolean.parseBoolean(isCompressed)) {
                GZIPInputStream compressedStream = new GZIPInputStream(inputStream);
                logger.debug("..........after compressedStream....." + outputFile);
                File opFile = new File(outputFile);
                MessageDigest md = MessageDigest.getInstance("MD5");
                UploadController.copyInputStreamToFile(compressedStream, opFile, md);
                logger.debug("..........inputFile....." + outputFile);
                String exePath = PCHelperConstant.getParabluFolderBasePath() + "/RWdetection/source_oct/ent";
                File ff = new File(exePath);
                logger.debug(".........exePath exists......" + ff.exists());
                entropyOp = this.validateRwDetection1(entropyOp, outputFile, exePath);
                logger.debug(opFile.length() + ".........entropyOp size......" + entropyOp.size());
                if (!opFile.exists()) return entropyOp;
            }
            logger.debug("..........inputFile....." + inputFile);
            String exePath = PCHelperConstant.getParabluFolderBasePath() + "/RWdetection/source_oct/ent";
            File ff = new File(exePath);
            logger.debug(".........exePath exists......" + ff.exists());
            entropyOp = this.validateRwDetection1(entropyOp, inputFile, exePath);
            logger.debug("..............." + entropyOp.size());
            return entropyOp;
        }
        catch (Exception e) {
            logger.error("....error...." + e.getMessage());
            e.printStackTrace();
            return entropyOp;
        }
    }

    private void createContentChunkAndSave(Map<String, String> headerMap, String chunkFilechecksum, boolean isContentPresent, String cloudName) {
        String missingChunk = headerMap.get("missing-chunk");
        boolean isUpdate = this.isMissingChunkPart(missingChunk);
        String chunkFileName = headerMap.get("chunkFileName");
        String batchId = headerMap.get("backupBatchId");
        String filenameHash = headerMap.get("tableNameHash");
        if (!isUpdate) {
            logger.debug("before checking content file" + filenameHash);
            ContentChunkFile contentChunkFile = this.uploadService.getContentChunkFileInfo(filenameHash, chunkFileName, cloudName);
            logger.debug("after checking content file" + contentChunkFile);
            if (contentChunkFile != null) {
                logger.debug("Content chunk file already exists.." + contentChunkFile.getFileName());
                logger.debug("Content chunk already present and data not present so return");
                return;
            }
        }
        ContentChunkFile contentChunkfile = new ContentChunkFile();
        contentChunkfile.setChunkFound(false);
        contentChunkfile.setContentPresent(isContentPresent);
        contentChunkfile.setFileName(chunkFileName);
        contentChunkfile.setMd5(chunkFilechecksum);
        contentChunkfile.setUserName(headerMap.get("userName"));
        if (!chunkFilechecksum.equalsIgnoreCase("endoffile")) {
            contentChunkfile.setOffset(headerMap.get("offset") != null ? Long.valueOf(headerMap.get("offset")) : 0L);
            contentChunkfile.setSize(Long.valueOf(headerMap.get("endOffset") != null ? Long.valueOf(headerMap.get("endOffset")) : 0L));
        } else {
            contentChunkfile.setFileName("endoffile");
        }
        if (isContentPresent) {
            String deviceUUID = headerMap.get("deviceUUID");
            String uploadFilePath = this.getUploadFilePath(deviceUUID, cloudName, batchId);
            String destPath = uploadFilePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkFileName;
            int dedupCount = 1;
            while (new File(destPath).exists()) {
                UploadController.printLogs("file is exist in destination path>>>>>>: " + destPath, PCHelperConstant.isBrevityLogging());
                destPath = uploadFilePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkFileName + "_" + dedupCount;
                ++dedupCount;
            }
            contentChunkfile.setfSPath(destPath);
        }
        logger.debug("before saving content chunk isupdate:" + isUpdate);
        this.saveToContentChunkTable(filenameHash, "", contentChunkfile, isUpdate);
    }

    private void saveToContentChunkTable(String fileName, String cloudName, ContentChunkFile contentChunkfile, boolean isUpdate) {
        this.uploadService.saveContentChunkFileInfo(cloudName, fileName, contentChunkfile, isUpdate);
    }

    private static boolean checkForExtensions(String fileName, List<InclusionFilter> inclusionFilters, String filterType) {
        boolean allow = false;
        if (CollectionUtils.isEmpty(inclusionFilters)) {
            return true;
        }
        HashSet<String> filterExclusionExtensions = new HashSet<String>();
        HashSet<String> filterInclusionExtensions = new HashSet<String>();
        HashSet<String> defaultFilterExclusionExtensions = new HashSet<String>();
        if (!StringUtils.isEmpty((String)PCHelperConstant.getSearchExclusionExtName())) {
            String[] extensions;
            for (String ext : extensions = PCHelperConstant.getSearchExclusionExtName().split(",")) {
                ext = ext.toLowerCase();
                defaultFilterExclusionExtensions.add(ext);
            }
        }
        for (InclusionFilter inclusionFilter : inclusionFilters) {
            String[] extensions;
            if (inclusionFilter != null && !StringUtils.isEmpty((String)filterType) && filterType.equalsIgnoreCase("exclusion")) {
                for (String ext : extensions = inclusionFilter.getExtensionName().split(",")) {
                    ext = ext.toLowerCase();
                    filterExclusionExtensions.add(ext);
                }
                continue;
            }
            for (String ext : extensions = inclusionFilter.getExtensionName().split(",")) {
                ext = ext.toLowerCase();
                filterInclusionExtensions.add(ext);
            }
        }
        if (defaultFilterExclusionExtensions.size() > 0 && defaultFilterExclusionExtensions.contains(FilenameUtils.getExtension((String)fileName.toLowerCase()))) {
            logger.error("... ext added in default exclusion list...");
            return false;
        }
        boolean allowAllextensions = filterInclusionExtensions.contains("all");
        if (allowAllextensions) {
            return true;
        }
        if (filterExclusionExtensions.size() > 0 && !filterExclusionExtensions.contains(FilenameUtils.getExtension((String)fileName.toLowerCase()))) {
            allow = true;
        } else if (filterInclusionExtensions.size() > 0 && filterInclusionExtensions.contains(FilenameUtils.getExtension((String)fileName.toLowerCase()))) {
            allow = true;
        }
        return allow;
    }

    public static String getPropertyFileValueParabluFolderBasePath(String cloudName) {
        return PCHelperConstant.getPropertyFileValueParacloudMountPoint() + cloudName + "/f/";
    }

    protected SearchIndex formSearchIndex(int cloudId, BluKryptElement bluKryptElement, ObjectId consId, String fsPath, ObjectId deviceId, boolean isFileUnderMC) {
        SearchIndex searchIndex = new SearchIndex();
        searchIndex.setCloudId(cloudId);
        searchIndex.setConsolidatedImageId(consId);
        searchIndex.setPresent(true);
        searchIndex.setCloudName(bluKryptElement.getCloudName());
        searchIndex.setAbstractFolderUrl(bluKryptElement.getFileCompletePath());
        searchIndex.setFileName(bluKryptElement.getFileName());
        searchIndex.setFolder(false);
        searchIndex.setSize(String.valueOf(bluKryptElement.getFileSize()));
        searchIndex.setLastModifiedTime(String.valueOf(System.currentTimeMillis()));
        searchIndex.setFsPath(fsPath);
        if (isFileUnderMC) {
            searchIndex.setMiniCloud(true);
        } else {
            searchIndex.setMiniCloud(false);
        }
        searchIndex.setUserName(bluKryptElement.getUserName());
        searchIndex.setStatus("ACTIVE");
        if (bluKryptElement.getIsSync()) {
            searchIndex.setSync(true);
        } else {
            searchIndex.setBackup(true);
        }
        if (!bluKryptElement.getIsSync()) {
            searchIndex.setDeviceUUID(bluKryptElement.getDeviceUUID());
            searchIndex.setDeviceId(deviceId);
        }
        return searchIndex;
    }

    public static String getFsPath(String md5) {
        SimpleDateFormat sdfDate = new SimpleDateFormat("dd-MM-yyyy");
        Date date = new Date();
        String baseFolder = sdfDate.format(date) + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + String.valueOf(date.getTime());
        String fileName = md5;
        return baseFolder + fileName;
    }

    private boolean saveToInterimDbForRebkp(FileInfo fileInfo, Cloud cloud, String batchId, BluKryptElement bluKryptElement, String chunkFilechecksum, String isCompressed, List<String> list, Device device) throws Exception {
        String deviceUUID = fileInfo.getDeviceUUID();
        List<String> orgChunks = list;
        if (!StringUtils.isEmpty((String)isCompressed)) {
            fileInfo.setCompressed(Boolean.valueOf(isCompressed).booleanValue());
        }
        fileInfo.setBatchId(batchId);
        String chunkPath = this.getUploadFilePath(deviceUUID, cloud.getCloudName(), batchId);
        List<String> destChunkNames = this.moveFilesFromTmpPath(deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId, orgChunks, chunkPath, false);
        boolean isTomcatRunning = true;
        if (MemoryStore.get((String)IS_TOMCAT_RUNNING) != null) {
            isTomcatRunning = (Boolean)MemoryStore.get((String)IS_TOMCAT_RUNNING);
        }
        logger.debug("........Is tomcat running........." + isTomcatRunning);
        if (!isTomcatRunning) {
            return false;
        }
        fileInfo.getChunkFiles().clear();
        fileInfo.getChunkFiles().addAll(destChunkNames);
        if (!StringUtils.isEmpty((String)chunkFilechecksum)) {
            List<String> resChunkList = this.getBackupIdAppendedToChunks(destChunkNames, fileInfo.getId());
            fileInfo.getChunkFiles().clear();
            fileInfo.getChunkFiles().addAll(resChunkList);
        }
        fileInfo.setGatewayName(bluKryptElement.getGatewayName());
        fileInfo.setReducePGSize(false);
        boolean sucess = this.updateSizeForRebackup(fileInfo, cloud, device, deviceUUID);
        if (sucess) {
            return this.uploadService.saveFileInfo(cloud.getCloudName(), bluKryptElement.getUserName(), fileInfo);
        }
        return true;
    }

    private boolean updateSizeForRebackup(FileInfo fileInfo, Cloud cloud, Device device, String deviceUUID) {
        boolean sucess = false;
        logger.debug("...........Latest changes..........");
        if (fileInfo != null && !StringUtils.isEmpty((String)fileInfo.getId())) {
            List<BackUpImage> versions;
            Optional<BackUpImage> bkpImages;
            BackUpImage backupImage = this.uploadService.getBkpFileByIdAndDevice(cloud.getCloudId(), new ObjectId(fileInfo.getId()), device);
            if (backupImage == null && (bkpImages = (versions = this.uploadService.getVersions(cloud.getCloudId(), cloud.getCloudName(), fileInfo.getFileName(), fileInfo.getFilePath(), device)).stream().filter(bkpFile -> bkpFile.getStatus().equalsIgnoreCase(bkpFile.getStatus())).findFirst()).isPresent()) {
                backupImage = bkpImages.get();
            }
            if (backupImage != null) {
                fileInfo.setId(backupImage.getId().toString());
                sucess = true;
                if (backupImage.getSize() != 0L) {
                    long privBkpImageSize = backupImage.getSize();
                    long filesizeInKB = (long)Math.ceil((double)fileInfo.getSize().longValue() / 1024.0);
                    logger.debug("...filesizeInKB..." + filesizeInKB + "...privBkpImageSize..." + privBkpImageSize);
                    if (filesizeInKB != backupImage.getSize()) {
                        backupImage.setSize(filesizeInKB);
                        backupImage.setSizeInBytes(fileInfo.getSize().longValue());
                        logger.debug("..updated size in bytes...");
                        this.uploadService.saveImageToBackUp(cloud.getCloudId(), backupImage, device);
                        long deltaChangeInSize = filesizeInKB - privBkpImageSize;
                        this.utilService.updateStorageUtilized(1, deviceUUID, deltaChangeInSize, deltaChangeInSize, null);
                    }
                }
            } else {
                logger.debug("...bkpImage not found..." + fileInfo.getId() + "..." + device.getDeviceUUID());
            }
        }
        return sucess;
    }

    private String getBluKryptBackupType(String gatewayHeader) {
        String gatewayType = Optional.ofNullable(gatewayHeader).orElse(HYPHEN_BOTH);
        if ("Incremental".equalsIgnoreCase(gatewayType)) {
            gatewayType = HYPHEN_INCRE;
            logger.debug("Set Gateway Type INCRE");
        } else if ("Full".equalsIgnoreCase(gatewayType)) {
            logger.debug("Set Gateway Type FULL ..Recived : " + gatewayType);
            gatewayType = HYPHEN_FULL;
        } else {
            gatewayType = HYPHEN_BOTH;
        }
        return gatewayType;
    }

    private String getUploadFilePath(String deviceUUID, String cloudName, String batchId) {
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID;
        if (!StringUtils.isEmpty((String)batchId)) {
            deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId;
        }
        return deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
    }

    private void checkNThrottleAndUploadFileV2(String cloudName, String gatewayName, InputStream inputStream, ChunkFileElement chunkFileElement, String osType, String indexPath, String batchId) throws InterruptedException {
        this.chunkableUploadService.uploadChunkableFileToBackUp(cloudName, inputStream, chunkFileElement, osType, false, indexPath, batchId);
    }

    private boolean checkMachineStorage(String fileSizeInString) {
        File file = new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint());
        long incomingFileSize = Long.parseLong(fileSizeInString);
        long availableSpaceInServer = file.getFreeSpace();
        logger.debug("Total space for this machine.." + file.getTotalSpace() + "FREE_SIZE" + file.getFreeSpace() + "incoming File Size:" + incomingFileSize);
        if (availableSpaceInServer - incomingFileSize <= 0L) {
            logger.debug("Space in server is exceeded........");
            return true;
        }
        return false;
    }

    @RequestMapping(value={"/delete/file"}, method={RequestMethod.GET})
    public void deleteFile(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Entering BlukryptBuilder deleteFile  ");
        try {
            String cloudName = request.getParameter("cloudName");
            String userName = request.getParameter("userName");
            String gatewayName = request.getParameter("gatewayName");
            String backupId = request.getParameter(BACKUP_ID);
            if (StringUtils.isEmpty((String)backupId)) {
                response.setStatus(400);
                return;
            }
            BackupFile backupFile = this.uploadService.getBackupFile(userName, cloudName, backupId, gatewayName);
            if (backupFile == null) {
                response.setStatus(400);
                return;
            }
            this.uploadService.deleteBackupFile(userName, cloudName, backupId, gatewayName);
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.error("@@@@ Error while trying to delete files  " + e);
        }
    }

    @RequestMapping(value={"/ping/"}, method={RequestMethod.GET})
    public void pingCloud(HttpServletRequest request, HttpServletResponse response) {
        try {
            UploadController.printLogs("%&%&%&%&%&%&%&%&%&%&%& pcb thread count:" + Thread.getAllStackTraces().size(), PCHelperConstant.isBrevityLogging());
        }
        catch (Exception e) {
            logger.debug("" + e);
            logger.error("" + e.getCause());
        }
        response.setStatus(200);
    }

    @RequestMapping(value={"/confirm/handshake"}, method={RequestMethod.GET})
    public void handshake(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Entering /confirm/handshake ");
        try {
            String deviceUUID = request.getHeader("deviceUUID");
            int cloudId = 1;
            Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
            if (device == null) {
                response.setStatus(400);
                logger.error("...Invalid device......" + deviceUUID);
                return;
            }
            boolean isFullBackup = this.isDeviceFullBackup(cloudId, deviceUUID);
            String gatewayHeader = request.getHeader("gatewayType");
            String gatewayType = this.getBluKryptBackupType(gatewayHeader);
            this.updateInterruptedBackup(cloudId, deviceUUID);
            boolean isBackupAllowed = this.isBackupAllowed(deviceUUID, gatewayType, isFullBackup);
            if (isBackupAllowed) {
                response.setStatus(200);
            } else {
                response.setStatus(502);
                logger.error(PG_OVERLOAD_LIMIT_REACHED);
            }
        }
        catch (Exception e) {
            logger.error("..error trying to handshake .... " + e.getMessage());
            logger.trace("" + e);
            response.setStatus(502);
        }
    }

    private FileUploadDetailsElement insertEntryForBackupFromBK(Map<String, String> headerMap, String cloudName, String userName, Device device, String batchId, boolean isEncrypted) {
        FileUploadDetailsElement fileUploadDetailsElement = new FileUploadDetailsElement();
        try {
            BackupElement fileElement = new BackupElement();
            fileElement.setFileName(headerMap.get("file-name"));
            fileElement.setFileCompletePath(headerMap.get("file-path"));
            if (headerMap.containsKey("accessTime")) {
                fileElement.setAccessTime(Long.valueOf(headerMap.get("accessTime")).longValue());
            }
            if (headerMap.containsKey("creationTime")) {
                fileElement.setCreationTime(Long.valueOf(headerMap.get("creationTime")).longValue());
            }
            fileElement.setPresent(Boolean.valueOf(headerMap.get("is-exists")).booleanValue());
            fileElement.setFolder(Boolean.valueOf(headerMap.get("is-folder")).booleanValue());
            fileElement.setMd5Checksum(headerMap.get("fileMD5"));
            fileElement.setSize(Long.valueOf(headerMap.get("file-size")).longValue());
            String fileModifiedTimestamp = headerMap.get("modified");
            fileElement.setLastClientModifiedTime(Long.valueOf(fileModifiedTimestamp).longValue());
            fileElement.setBaseBackup(Boolean.valueOf(headerMap.get("is-base-folder")).booleanValue());
            if (StringUtils.isNotEmpty((String)PCHelperConstant.getPropertyFileValueLoadBalancerIp())) {
                fileElement.setGatewayName(PCHelperConstant.getPropertyFileValueLoadBalancerIp().trim());
            } else {
                fileElement.setGatewayName(headerMap.get("gatewayName"));
            }
            if (!StringUtils.isEmpty((String)headerMap.get("isSync"))) {
                fileElement.setIsSync(Boolean.parseBoolean(headerMap.get("isSync")));
            }
            if (!StringUtils.isEmpty((String)headerMap.get("crawlTimestamp"))) {
                fileElement.setCrawlTimestamp(Long.parseLong(headerMap.get("crawlTimestamp")));
            }
            fileElement.setFileUserOwner(userName);
            boolean isFullBackup = false;
            String fullBackup = headerMap.get("isFullBackup");
            if (!StringUtils.isEmpty((String)fullBackup)) {
                isFullBackup = Boolean.parseBoolean(fullBackup);
            }
            String userUnderLegalHold = headerMap.get("userUnderLegalHold");
            fileElement.setContainerName(headerMap.get("containerName"));
            fileElement.setContainerType(headerMap.get("containerType") == null ? "" : headerMap.get("containerType"));
            int uploadCount = 0;
            if (MemoryStore.get((String)UPLOAD_COUNT) != null) {
                uploadCount = (Integer)MemoryStore.get((String)UPLOAD_COUNT);
                logger.debug(" From MEMSTORE ........... " + uploadCount);
            }
            logger.debug(" Before calling uploadExternalFileToBackUp  insertEntryForBackupFromBK...........gateway name:" + fileElement.getGatewayName() + " " + uploadCount);
            fileUploadDetailsElement = this.backupService.uploadExternalFileToBackUp(1, cloudName, fileElement, device, userUnderLegalHold, isFullBackup, isEncrypted);
            Map deviceUUIDMap = (Map)MemoryStore.get((String)DEVICEUUID_MAP_IN_MEMSTORE);
            String deviceUUIDForBackup = "";
            if (deviceUUIDMap != null) {
                for (String key : deviceUUIDMap.keySet()) {
                    if (!key.contains(device.getDeviceUUID())) continue;
                    deviceUUIDForBackup = key;
                    break;
                }
            }
            logger.debug(" After calling uploadExternalFileToBackUp insertEntryForBackupFromBK..........." + deviceUUIDForBackup);
            if (StringUtils.isNotEmpty((String)deviceUUIDForBackup)) {
                deviceUUIDForBackup = deviceUUIDForBackup.replace(device.getDeviceUUID(), "");
            }
            logger.info("[backup][" + headerMap.get("gatewayName") + "][" + headerMap.get("backupBatchId") + "][" + userName + "][" + device.getDeviceName() + "][" + Thread.currentThread().getName() + "][" + fileElement.getFileName() + "][" + fileElement.getSize() + "][" + deviceUUIDForBackup + "][" + System.currentTimeMillis() + "]");
            MemoryStore.delete((String)UPLOAD_COUNT);
            MemoryStore.add((String)UPLOAD_COUNT, (Object)(++uploadCount));
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Inserting Entry For Backup From BK :" + e.getMessage());
        }
        return fileUploadDetailsElement;
    }

    private synchronized boolean isBackupAllowed(String deviceUUIDForBkp, String gatewayType, boolean isFullBackup) {
        String deviceUUIDForBackup = isFullBackup ? deviceUUIDForBkp + HYPHEN_FULL : deviceUUIDForBkp + HYPHEN_INCRE;
        Map<String, Long> deviceUUIDMap = new HashMap<String, Long>();
        boolean allowBackup = false;
        if (PCHelperConstant.getPGOverloadLimit() <= 0) {
            logger.error("...device overload limit reached ..... " + PCHelperConstant.getPGOverloadLimit());
            return allowBackup;
        }
        if (MemoryStore.get((String)DEVICEUUID_MAP_IN_MEMSTORE) == null) {
            UploadController.updateDeviceMap(deviceUUIDForBackup, deviceUUIDMap);
            logger.debug("$$$$$$NewdeviceUUID First Time map initializtion  ........... " + deviceUUIDForBackup);
            return true;
        }
        deviceUUIDMap = (Map)MemoryStore.get((String)DEVICEUUID_MAP_IN_MEMSTORE);
        if (deviceUUIDMap.containsKey(deviceUUIDForBackup) || deviceUUIDMap.size() < PCHelperConstant.getPGOverloadLimit()) {
            UploadController.updateDeviceMap(deviceUUIDForBackup, deviceUUIDMap);
            allowBackup = true;
        } else if (!HYPHEN_BOTH.equalsIgnoreCase(gatewayType)) {
            allowBackup = UploadController.checkForBackupsBasedOnGatewayType(deviceUUIDForBackup, deviceUUIDMap, gatewayType);
        }
        if (!allowBackup) {
            logger.debug("&&&%%% PG OVERLOAD Limit Reached  size........... " + deviceUUIDMap.size());
        } else {
            UploadController.updateDeviceMap(deviceUUIDForBackup, deviceUUIDMap);
            logger.debug("###@@@ NewdeviceUUID added for PG .......... " + deviceUUIDMap.size() + "...." + deviceUUIDForBackup);
        }
        return allowBackup;
    }

    public void updateDeviceMapForChunk(String deviceUUIDForBkp, boolean isFullBackup) {
        String deviceUUIDForBackup = isFullBackup ? deviceUUIDForBkp + HYPHEN_FULL : deviceUUIDForBkp + HYPHEN_INCRE;
        Map<String, Long> deviceUUIDMap = new HashMap<String, Long>();
        if (MemoryStore.get((String)DEVICEUUID_MAP_IN_MEMSTORE) == null) {
            UploadController.updateDeviceMap(deviceUUIDForBackup, deviceUUIDMap);
        } else {
            deviceUUIDMap = (Map)MemoryStore.get((String)DEVICEUUID_MAP_IN_MEMSTORE);
            UploadController.updateDeviceMap(deviceUUIDForBackup, deviceUUIDMap);
        }
    }

    private static void updateDeviceMap(String deviceUUIDForBackup, Map<String, Long> deviceUUIDMap) {
        deviceUUIDMap.put(deviceUUIDForBackup, System.currentTimeMillis());
        MemoryStore.add((String)DEVICEUUID_MAP_IN_MEMSTORE, deviceUUIDMap);
    }

    private void updateInterruptedBackup(int cloudId, String newDeviceDeviceUUID) {
        logger.debug("Inside update interrupted backup>>>>>>>");
        if (MemoryStore.get((String)DEVICEUUID_MAP_IN_MEMSTORE) != null) {
            Map deviceUUIDMap = (Map)MemoryStore.get((String)DEVICEUUID_MAP_IN_MEMSTORE);
            ArrayList<String> devicesToRemove = new ArrayList<String>();
            for (Map.Entry deviceObj : deviceUUIDMap.entrySet()) {
                String deviceUUIDVal = (String)deviceObj.getKey();
                logger.debug(deviceUUIDVal + ".....existing deviceuuid..." + newDeviceDeviceUUID);
                if (deviceUUIDVal.contains(newDeviceDeviceUUID)) continue;
                Long deviceLastAccessedTime = (Long)deviceObj.getValue();
                logger.debug(" device uuid>>>>" + deviceUUIDVal);
                logger.debug(System.currentTimeMillis() + "current time<<<<  time +inactivity>>>" + (deviceLastAccessedTime + (long)PCHelperConstant.getPGOverLoadInactivityPeriod()));
                long inactivityPeriod = deviceLastAccessedTime + (long)PCHelperConstant.getPGOverLoadInactivityPeriod();
                logger.debug(System.currentTimeMillis() + "in activity period>>>>" + inactivityPeriod);
                if (System.currentTimeMillis() > inactivityPeriod) {
                    String deviceUUID = deviceUUIDVal.substring(0, deviceUUIDVal.indexOf(45));
                    logger.debug("before updating inside device uuid>>>>" + deviceUUID);
                    this.utilService.updateInterruptedBackBatch(cloudId, deviceUUID);
                    devicesToRemove.add(deviceUUIDVal);
                    continue;
                }
                logger.debug("time stamp not exceeded the inactivity period" + deviceLastAccessedTime);
            }
            if (!CollectionUtils.isEmpty(devicesToRemove)) {
                for (String deviceToRemove : devicesToRemove) {
                    deviceUUIDMap.remove(deviceToRemove);
                }
            }
            MemoryStore.add((String)DEVICEUUID_MAP_IN_MEMSTORE, (Object)deviceUUIDMap);
        } else {
            logger.debug("memory store is nulll in memstore");
        }
    }

    public boolean isDeviceFullBackup(int cloudId, String deviceUUID) {
        boolean fullBackup = true;
        DeviceBackupOverView deviceBackupOverView = this.utilService.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
        if (deviceBackupOverView != null && !StringUtils.isEmpty((String)deviceBackupOverView.getFirstBkpEndTime())) {
            logger.debug(" INCREMENTAL BACKUP for device .... " + deviceBackupOverView.getDeviceUUID());
            fullBackup = false;
        }
        logger.debug(" @@FULL BACKUP for device .... " + fullBackup);
        return fullBackup;
    }

    private static boolean checkForBackupsBasedOnGatewayType(String deviceUUIDForBackup, Map<String, Long> deviceUUIDMap, String gatewayType) {
        boolean allowBackupTemp = false;
        String deviceToRemove = UploadController.getDeviceToRemove(gatewayType);
        if (!StringUtils.isEmpty((String)deviceToRemove) && deviceUUIDForBackup.contains(gatewayType)) {
            logger.debug(" Removing incremental backup .... " + deviceToRemove + "..... Adding full backup ... " + deviceUUIDForBackup);
            deviceUUIDMap.remove(deviceToRemove);
            UploadController.updateDeviceMap(deviceUUIDForBackup, deviceUUIDMap);
            allowBackupTemp = true;
        }
        return allowBackupTemp;
    }

    private static String getDeviceToRemove(String gatewayType) {
        String backupTypeToRemove = HYPHEN_INCRE;
        if (gatewayType.equalsIgnoreCase(HYPHEN_INCRE)) {
            backupTypeToRemove = HYPHEN_FULL;
        }
        Map deviceUUIDMap = (Map)MemoryStore.get((String)DEVICEUUID_MAP_IN_MEMSTORE);
        String deviceUUIDToRemove = "";
        for (String key : deviceUUIDMap.keySet()) {
            if (!key.contains(backupTypeToRemove)) continue;
            deviceUUIDToRemove = key;
            logger.debug("  deviceuuid to be removed in map ........... " + key);
            break;
        }
        return deviceUUIDToRemove;
    }

    public static double getSizeinMb(long size) {
        double m = (double)size / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        return Double.parseDouble(dec.format(m));
    }

    private void delTempfolder(File tempFilePath) {
        try {
            if (tempFilePath.exists()) {
                tempFilePath.delete();
            }
            if (tempFilePath.getParentFile().exists()) {
                FileUtils.deleteDirectory((File)tempFilePath.getParentFile());
            }
        }
        catch (IOException e) {
            logger.error("Unable to delette temp folder" + e.getMessage());
            logger.error("Unable to delette temp folder" + e);
        }
    }

    private List<String> moveFilesFromTmpPath(String deviceUUID, List<String> orgChunks, String chunkPath, boolean isContentChunk) throws Exception {
        ArrayList<String> chunkNames = new ArrayList<String>();
        for (String chunkName : orgChunks) {
            String path = PCHelperConstant.getMntTempChunkPath() + deviceUUID;
            String srcfilePath = path + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkName;
            File fileObj = new File(srcfilePath);
            if (fileObj.exists()) {
                File chunkDir = new File(chunkPath);
                if (!chunkDir.exists()) {
                    chunkDir.mkdirs();
                }
                String destPath = chunkPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkName;
                String newChunkName = chunkName;
                int dedupCount = 1;
                while (new File(destPath).exists()) {
                    UploadController.printLogs("file is exist in destination path>>>>>>: " + destPath, PCHelperConstant.isBrevityLogging());
                    destPath = chunkPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkName + "_" + dedupCount;
                    newChunkName = chunkName + "_" + dedupCount;
                    ++dedupCount;
                }
                chunkNames.add(newChunkName);
                File destFile = new File(destPath);
                Files.move(fileObj.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                logger.debug("destFile :" + destFile.getAbsolutePath());
                continue;
            }
            logger.debug("...file not exists...." + srcfilePath + "...isContentChunk...." + isContentChunk);
            if (isContentChunk) {
                chunkNames.add(chunkName);
                continue;
            }
            throw new Exception(FILE_NOT_EXISTS);
        }
        return chunkNames;
    }

    private void closeInputStreamAndDelTempFile(InputStream inputStream) throws IOException {
        if (inputStream != null) {
            inputStream.close();
        }
    }

    private ChunkFileElement createChunkFileElement(String deviceUUID, BluKryptElement bluKryptElement, String chunkFilechecksum, String chunkFileName, String checkSum, List<String> list) {
        ChunkFileElement chunkFileElement = new ChunkFileElement();
        if (CollectionUtils.isEmpty(list)) {
            logger.debug("List is empty sooo adding md5checksum" + checkSum);
            list.add(checkSum);
        }
        chunkFileElement.setFileChunks(list);
        chunkFileElement.setFileCompletePath(bluKryptElement.getFileCompletePath());
        chunkFileElement.setFileName(checkSum);
        chunkFileElement.setMd5checksum(checkSum);
        chunkFileElement.setDeviceUUID(bluKryptElement.getDeviceUUID());
        if (!StringUtils.isEmpty((String)chunkFilechecksum)) {
            chunkFileElement.setMd5checksum(chunkFilechecksum);
            chunkFileElement.setFileChunks(list);
            chunkFileElement.setFileCompletePath(chunkFileName);
            chunkFileElement.setFileName(chunkFileName);
            chunkFileElement.setDeviceUUID(deviceUUID);
        }
        return chunkFileElement;
    }

    private List<String> getChunkNames(Map<String, String> headerMap) {
        String fileChunkNames = "";
        if (headerMap.get("fileChunkNames") != null) {
            fileChunkNames = headerMap.get("fileChunkNames");
        }
        List<String> list = new ArrayList<String>();
        if (!fileChunkNames.isEmpty()) {
            list = Arrays.asList(fileChunkNames.split(","));
        }
        return list;
    }

    private double getFileSizeInMb(Map<String, String> headerMap) {
        long fileSizeInBytes = Long.parseLong(headerMap.get("file-size"));
        long filesizeInKB = (long)Math.ceil((double)fileSizeInBytes / 1024.0);
        return UploadController.getSizeinMb(filesizeInKB);
    }

    private void addFailedFileList(Map<String, String> headerMap, List<BackupFile> failedList) {
        String fileName = headerMap.get("file-name");
        String sourceFilePath = headerMap.get("file-path");
        String md5 = headerMap.get("fileMD5");
        Long lastmodified = Long.valueOf(headerMap.get("modified"));
        Long size = Long.valueOf(headerMap.get("file-size"));
        BackupFile backupFile = new BackupFile();
        backupFile.setFileName(fileName);
        backupFile.setFilePath(sourceFilePath);
        backupFile.setMd5(md5);
        backupFile.setUploadedTimestamp(lastmodified);
        backupFile.setSize(size);
        failedList.add(backupFile);
    }

    private void updateBackupLog(Map<String, String> headerMap, boolean isuploadFailed, List<BackupFile> failedList) {
        String restartId = headerMap.get("restartId");
        String batchId = headerMap.get("backupBatchId");
        String cloudName = headerMap.get("cloudName");
        String deviceUUID = headerMap.get("deviceUUID");
        BackupLog backupLog = new BackupLog();
        backupLog.setId(new ObjectId(batchId));
        backupLog.setRestartId(Integer.valueOf(restartId).intValue());
        backupLog.setDeviceUUID(deviceUUID);
        backupLog.getFailedFiles().addAll(failedList);
        this.utilService.updateBackupLog(1, cloudName, backupLog);
    }

    @RequestMapping(value={"/update/restartid"}, method={RequestMethod.POST})
    public void updateRestartID(HttpServletRequest request, HttpServletResponse httpResponse) {
        String restartId = request.getHeader("restartId");
        String batchId = request.getHeader("backupBatchId");
        String cloudName = request.getHeader("cloudName");
        String deviceUUID = request.getHeader("deviceUUID");
        BackupLog backupLog = new BackupLog();
        backupLog.setId(new ObjectId(batchId));
        backupLog.setRestartId(Integer.valueOf(restartId).intValue());
        backupLog.setDeviceUUID(deviceUUID);
        logger.debug(" Before updating backupLog...........");
        this.utilService.updateBackupLog(1, cloudName, backupLog);
        logger.debug(" After updating backupLog...........");
        httpResponse.setStatus(200);
    }

    private List<String> getBackupIdAppendedToChunks(List<String> newChunkList, String newBackupId) {
        ArrayList<String> resChunkList = new ArrayList<String>();
        for (String chunkName : newChunkList) {
            resChunkList.add(chunkName + "." + newBackupId);
        }
        Collections.sort(resChunkList);
        return resChunkList;
    }

    private boolean isFullBackupEnabled(Map<String, String> headerMap) {
        boolean isFullBackup = false;
        String fullBackup = headerMap.get("isFullBackup");
        if (!StringUtils.isEmpty((String)fullBackup)) {
            isFullBackup = Boolean.parseBoolean(fullBackup);
        }
        return isFullBackup;
    }

    @RequestMapping(value={"/upload/files/rebkp"}, method={RequestMethod.POST})
    public void reuploadMultiPartFiles(HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("Start reuploadMultiPartFiles file DEBUG.........");
        String boundary = "--PARABLUEOF";
        byte[] bryBytes = boundary.getBytes();
        String batchId = "";
        BufferedInputStream in = null;
        Map<String, String> headerMap = null;
        int response = 0;
        try {
            in = new BufferedInputStream((InputStream)request.getInputStream(), 10240);
            MultipartStream multipartStream = new MultipartStream((InputStream)in, bryBytes, 4096);
            boolean nextPart = multipartStream.skipPreamble();
            logger.debug(" nextpart ...... " + nextPart + "<<<<<<<<<");
            int i = 1;
            while (nextPart) {
                String header = multipartStream.readHeaders();
                logger.debug(header + " header:" + i);
                headerMap = UploadController.parseHeader(header);
                httpResponse.setStatus(500);
                response = this.reupload(headerMap, multipartStream, httpResponse, i);
                logger.debug("Upload response code#####....." + response);
                nextPart = multipartStream.readBoundary();
                ++i;
            }
        }
        catch (IOException e) {
            this.closeInputStreamIfExists(request);
            logger.trace("" + e);
            logger.error(batchId + ".....IOException While Uploading Multipart Files :" + e.getMessage());
        }
        catch (Exception e) {
            this.closeInputStreamIfExists(request);
            logger.trace("" + e);
            logger.error(".....Exception While Uploading Multipart Files :" + e.getMessage());
        }
        logger.debug("End multipart file.........DEBUG");
    }

    private int reupload(Map<String, String> headerMap, MultipartStream multipartStream, HttpServletResponse httpResponse, int uploadCount) {
        String backupId = "";
        String cloudName = "";
        String batchId = "";
        ByteArrayOutputStream restoreFileOutput = new ByteArrayOutputStream();
        try {
            String checkSum;
            Cloud cloud = this.utilService.getCloud(1);
            String deviceUUID = headerMap.get("deviceUUID");
            Device device = this.utilService.getDeviceForUUID(cloud.getCloudId(), deviceUUID);
            if (device == null) {
                httpResponse.setStatus(400);
                logger.error("...Invalid device......" + deviceUUID);
                return 500;
            }
            BluKryptElement bluKryptElement = this.getBluKryptElementValuesStr(headerMap);
            if (cloud != null) {
                bluKryptElement.setVersionsToKeep(Integer.toString(cloud.getVersioningEnabled()));
            }
            String fileSizeInString = headerMap.get("file-size");
            String chunkFilechecksum = headerMap.get("chunkFileMD5");
            String chunkFileName = headerMap.get("chunkFileName");
            batchId = headerMap.get("backupBatchId");
            String isChunkOfAFile = FALSE;
            String md5 = checkSum = headerMap.get("fileMD5");
            String isCompressed = headerMap.get("isCompressed");
            String isNormalFile = "true";
            long fileSize = Long.parseLong(headerMap.get("file-size"));
            if (headerMap.get(IS_A_CHUNK_FILE) != null) {
                isChunkOfAFile = headerMap.get(IS_A_CHUNK_FILE);
            }
            if (headerMap.get(IS_NORMAL_FILE) != null) {
                isNormalFile = headerMap.get(IS_NORMAL_FILE);
            }
            logger.debug(BATCH_ID_LOG + batchId);
            List<String> list = this.getChunkNames(headerMap);
            boolean isMachineStorageReached = this.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                httpResponse.setStatus(507);
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                return 507;
            }
            cloudName = bluKryptElement.getCloudName();
            if (Boolean.parseBoolean(isNormalFile)) {
                String orgChunkName = checkSum;
            } else if (Boolean.parseBoolean(isChunkOfAFile)) {
                String orgChunkName = chunkFileName;
            } else {
                String orgChunkName = "chunkHeader";
            }
            multipartStream.readBodyData((OutputStream)restoreFileOutput);
            ByteArrayInputStream in = new ByteArrayInputStream(restoreFileOutput.toByteArray());
            Base64InputStream inputStream = new Base64InputStream((InputStream)in, false);
            restoreFileOutput.flush();
            restoreFileOutput.close();
            String fsPath = UploadController.getFsPath(md5);
            String indexPath = "";
            if (Boolean.parseBoolean(isChunkOfAFile) || Boolean.parseBoolean(isNormalFile)) {
                ChunkFileElement chunkFileElement = this.createChunkFileElement(deviceUUID, bluKryptElement, chunkFilechecksum, chunkFileName, checkSum, list);
                String osType = headerMap.get("osType");
                this.checkNThrottleAndUploadFileV2(cloudName, bluKryptElement.getGatewayName(), (InputStream)inputStream, chunkFileElement, osType, indexPath, batchId);
            } else if (inputStream != null) {
                list.clear();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)inputStream, (Writer)writer);
                String chunkList = writer.toString();
                list = new ArrayList<String>(Arrays.asList(chunkList.split(",")));
                checkSum = MD5Generator.generateMD5OfString((String)chunkList);
                headerMap.put("fileMD5", checkSum);
            }
            if (Boolean.parseBoolean(isChunkOfAFile)) {
                logger.debug(BATCH_ID_LOG + batchId + " $$$$$$$$$$$Inside a chunk file upload so return>>>>>>>>");
                this.closeInputStreamAndDelTempFile((InputStream)inputStream);
                return 200;
            }
            backupId = headerMap.get(BACKUP_ID);
            httpResponse.setStatus(200);
            if (StringUtils.isEmpty((String)backupId)) {
                this.closeInputStreamAndDelTempFile((InputStream)inputStream);
                logger.error(" Backup id is empty.............");
                return 500;
            }
            if (CollectionUtils.isEmpty(list)) {
                logger.debug(BATCH_ID_LOG + batchId + " List is empty sooo adding md5checksum" + checkSum);
                list.add(checkSum);
            }
            if (!StringUtils.isEmpty((String)backupId)) {
                FileInfo fileInfo = this.getFileInfo(bluKryptElement, backupId, list);
                fileInfo.setSize(Long.valueOf(fileSize));
                if (!StringUtils.isEmpty((String)headerMap.get(JOB_ID))) {
                    fileInfo.setServerBackupJobId(headerMap.get(JOB_ID));
                }
                fileInfo.setRebackupFile(true);
                boolean uploadSucess = this.saveToInterimDbForRebkp(fileInfo, cloud, batchId, bluKryptElement, chunkFilechecksum, isCompressed, list, device);
                if (!uploadSucess) {
                    this.uploadService.removeBackupFile(cloud.getCloudId(), backupId, device.getDestCollection());
                    httpResponse.setStatus(500);
                    this.closeInputStreamAndDelTempFile((InputStream)inputStream);
                    return 500;
                }
                String gateWayName = headerMap.get("gatewayName");
                if (!StringUtils.isEmpty((String)gateWayName)) {
                    this.utilService.updateGatewayInBackupImage(backupId, gateWayName);
                }
                this.uploadService.deleteFileInfoFromReBackup(cloudName, new ObjectId(backupId));
                httpResponse.setStatus(200);
                logger.debug(BATCH_ID_LOG + batchId + " End of uploading multi part file...........");
            }
            this.closeInputStreamAndDelTempFile((InputStream)inputStream);
        }
        catch (UncategorizedJmsException e) {
            logger.error(BATCH_ID_LOG + batchId + " JMSException connection refused exception backup upload ....... " + backupId);
            logger.trace("" + (Object)((Object)e));
            httpResponse.setStatus(500);
            return 500;
        }
        catch (Exception e) {
            httpResponse.setStatus(500);
            logger.trace("" + e);
            logger.error(" Exception While Uploading :" + e.getMessage());
            return 500;
        }
        return 200;
    }

    private void deleteTmpChunkFilesIfAnyException1(String batchId) {
        String path = PCHelperConstant.getMntTempChunkPath() + batchId;
        File deletePath = new File(path);
        if (deletePath.exists()) {
            try {
                FileUtils.forceDelete((File)deletePath);
                FileUtils.deleteDirectory((File)deletePath);
            }
            catch (IOException e1) {
                logger.debug(UNABLE_TO_DELETE + e1);
                logger.error(UNABLE_TO_DELETE + deletePath.getName() + "....." + deletePath.getPath() + "  ...  " + e1.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendWarningMail(Map<String, String> headerMap, double userStorageQuata, String deviceName) {
        HttpClient httpclient = null;
        HttpPost httpPost = null;
        HttpResponse response = null;
        try {
            BluKryptElement bluKryptElement = this.getBluKryptElementValuesStr(headerMap);
            String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + PARACLOUD_CLOUD + bluKryptElement.getCloudName() + "/mail";
            httpclient = HttpClientUtil.getSSlConnection();
            httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("isInternalCall", "true");
            JSONObject emailDetails = new JSONObject();
            emailDetails.put("actionBy", (Object)bluKryptElement.getUserName());
            emailDetails.put("action", (Object)"backup-limit-reached");
            emailDetails.put("actionOn", (Object)bluKryptElement.getUserName());
            emailDetails.put("deviceName", (Object)deviceName);
            emailDetails.put("customMailMessage", (Object)String.valueOf(userStorageQuata));
            emailDetails.put("toAdmins", true);
            StringEntity params = new StringEntity(emailDetails.toString());
            httpPost.setEntity((HttpEntity)params);
            response = httpclient.execute((HttpUriRequest)httpPost);
            logger.debug("Send mail result status code :", (Object)response);
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error("Exception :", (Object)e.getMessage());
        }
        finally {
            httpPost.releaseConnection();
        }
    }

    private boolean saveToInterimDb(FileInfo fileInfo, String cloudName, FileUploadDetailsElement fileDetailsElement, String batchId, BluKryptElement bluKryptElement, String chunkFilechecksum, String isCompressed, List<String> list, boolean isContentChunk) throws Exception {
        String deviceUUID = fileInfo.getDeviceUUID();
        List<String> orgChunks = list;
        if (!StringUtils.isEmpty((String)isCompressed)) {
            fileInfo.setCompressed(Boolean.valueOf(isCompressed).booleanValue());
        }
        fileInfo.setBatchId(batchId);
        String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, batchId);
        List<String> destChunkNames = this.moveFilesFromTmpPath(deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId, orgChunks, chunkPath, isContentChunk);
        boolean isTomcatRunning = true;
        if (MemoryStore.get((String)IS_TOMCAT_RUNNING) != null) {
            isTomcatRunning = (Boolean)MemoryStore.get((String)IS_TOMCAT_RUNNING);
        }
        logger.debug("........Is tomcat running........." + isTomcatRunning);
        if (!isTomcatRunning) {
            return false;
        }
        fileInfo.getChunkFiles().clear();
        fileInfo.getChunkFiles().addAll(destChunkNames);
        if (!StringUtils.isEmpty((String)chunkFilechecksum)) {
            List<String> resChunkList = this.getBackupIdAppendedToChunks(destChunkNames, fileInfo.getId());
            fileInfo.getChunkFiles().clear();
            fileInfo.getChunkFiles().addAll(resChunkList);
        }
        fileInfo.setGatewayName(bluKryptElement.getGatewayName());
        if (!bluKryptElement.getIsSync()) {
            this.updateStorageUtilization(cloudName, fileDetailsElement, batchId, destChunkNames, deviceUUID);
            fileInfo.setReducePGSize(true);
        }
        fileInfo.setSync(bluKryptElement.getIsSync());
        return this.uploadService.saveFileInfo(cloudName, bluKryptElement.getUserName(), fileInfo);
    }

    private void updateStorageUtilization(String cloudName, FileUploadDetailsElement fileDetailsElement, String batchId, List<String> list, String deviceUUID) {
        long pgChunkSize = 0L;
        if (!CollectionUtils.isEmpty(list)) {
            String chunkFolderPath = this.getUploadFilePath(deviceUUID, cloudName, batchId);
            chunkFolderPath = chunkFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            for (String chunkName : list) {
                try {
                    File file = new File(chunkFolderPath + chunkName).getAbsoluteFile();
                    long fileSize = file.length();
                    logger.debug(chunkName + ".....filename and size1..... " + fileSize + "...filesize kb ..." + fileSize / 1024L);
                    pgChunkSize += fileSize / 1024L;
                }
                catch (Exception e) {
                    logger.debug(".......Exception...." + e.getMessage());
                }
            }
        }
        logger.debug("..................total pgChunkSizeInKB............" + pgChunkSize);
        this.utilService.updateStorageUtilized(1, deviceUUID, fileDetailsElement.getFileSize(), fileDetailsElement.getLatestVersionSize(), pgChunkSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cloud/{cloudName}/upload/demoFile"}, method={RequestMethod.POST})
    public void uploadBackUpFile1(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(".....$$$$$$$$$$........Called new api upload/demoFile");
        ServletInputStream inputStream = null;
        try {
            File tempFilePath = new File("/parablu/temp.tmp");
            if (tempFilePath.exists()) {
                tempFilePath.delete();
            }
            tempFilePath.createNewFile();
            logger.debug("before read.....$$$$$$$$$$......" + System.currentTimeMillis());
            inputStream = request.getInputStream();
            logger.debug("after read.....$$$$$$$$$$......" + System.currentTimeMillis());
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (inputStream != null) {
                UploadController.copyInputStreamToFile((InputStream)inputStream, tempFilePath, md);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception :", (Object)e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.trace("" + e);
                    logger.error("Exception :", (Object)e.getMessage());
                }
            }
            try {
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
            catch (IOException e) {
                logger.trace("" + e);
                logger.error("Exception :", (Object)e.getMessage());
            }
        }
    }

    private static void copyInputStreamToFile(InputStream inputStream, File file, MessageDigest md) throws IOException {
        logger.debug("before write......" + System.currentTimeMillis());
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            int read = -1;
            byte[] bytes = new byte[4096];
            read = inputStream.read(bytes);
            logger.debug("........." + read);
            while ((read = inputStream.read(bytes)) != -1) {
                ((OutputStream)outputStream).write(bytes, 0, read);
                md.update(bytes, 0, read);
            }
        }
        logger.debug("after write......" + System.currentTimeMillis());
    }

    @RequestMapping(value={"/cloud/{cloudName}/checkODBFolders"}, method={RequestMethod.POST})
    public void checkODBFolders(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(".....$$$$$$$$$$........Called new api checkODBFolders");
        try {
            File tempFilePath = new File("/parablu/reports/odbCheck.log");
            if (tempFilePath.exists()) {
                tempFilePath.delete();
            }
            tempFilePath.createNewFile();
            Cloud cloud = this.utilService.getCloud(1);
            StringBuilder checkOdbFolders = this.uploadService.checkOdbFolders(cloud, new StringBuilder());
            logger.debug("Final..." + checkOdbFolders);
            if (StringUtils.isEmpty((String)checkOdbFolders.toString())) {
                checkOdbFolders = new StringBuilder("No counterfeit found");
            }
            UploadController.appendStrToFile(tempFilePath.getAbsolutePath(), checkOdbFolders.toString());
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception :", (Object)e.getMessage());
        }
    }

    public static void appendStrToFile(String fileName, String str) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fileName, true));
            out.write(str);
            out.close();
        }
        catch (IOException e) {
            logger.error("Exception :", (Object)e.getMessage());
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/updateProperties"}, method={RequestMethod.POST})
    public void updateProperties(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(".....$$$$$$$$$$........Called new api updateProperties");
        try {
            logger.debug("...existing pgoverload limit value.... " + PCHelperConstant.getPGOverloadLimit());
            this.utilService.initiateCloudProperties(1);
            logger.debug("...modified pgoverload limit value.... " + PCHelperConstant.getPGOverloadLimit());
            MemoryStore.delete((String)"threadsCountModified");
            MemoryStore.add((String)"threadsCountModified", (Object)System.currentTimeMillis());
            response.setStatus(200);
            return;
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception :", (Throwable)e);
            response.setStatus(500);
            return;
        }
    }

    private boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"ODB Enabled".equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }

    private static String getMd5FromFileName(String fileName, int occurance) {
        String md5 = "";
        if (occurance == 1 && !fileName.startsWith("part")) {
            md5 = fileName.substring(0, fileName.lastIndexOf(46));
        } else if (occurance == 1 && fileName.startsWith("part")) {
            md5 = fileName.substring(fileName.lastIndexOf(46) + 1);
        } else if (occurance == 0) {
            md5 = fileName;
        } else if (occurance > 1) {
            md5 = fileName.substring(fileName.indexOf(46) + 1, fileName.lastIndexOf(46));
        }
        if (StringUtils.isNotEmpty((String)md5) && md5.contains("_")) {
            md5 = md5.substring(0, md5.lastIndexOf("_"));
        }
        return md5;
    }

    private String getDedupValue(BackupPolicy backupPolicy) {
        String dedupVal = null;
        if (backupPolicy != null) {
            dedupVal = backupPolicy.getDedup();
        }
        return dedupVal;
    }

    private File getAvgEntropy(List<String> entropyOp, String fileName) {
        ArrayList<List<String>> entropyList = new ArrayList<List<String>>();
        for (String entropy : entropyOp) {
            List<String> entropy1 = Arrays.asList(entropy.split("\\s*,\\s*"));
            entropyList.add(entropy1);
        }
        float c1 = 0.0f;
        float c2 = 0.0f;
        float c3 = 0.0f;
        float c4 = 0.0f;
        float c5 = 0.0f;
        float c6 = 0.0f;
        float c7 = 0.0f;
        for (List list : entropyList) {
            c1 = Float.valueOf((String)list.get(0)).floatValue() + c1;
            c2 = Float.valueOf((String)list.get(1)).floatValue() + c2;
            c3 = Float.valueOf((String)list.get(2)).floatValue() + c3;
            c4 = Float.valueOf((String)list.get(3)).floatValue() + c4;
            c5 = Float.valueOf((String)list.get(4)).floatValue() + c5;
            c6 = Float.valueOf((String)list.get(5)).floatValue() + c6;
            c7 = Float.valueOf((String)list.get(6)).floatValue() + c7;
        }
        c1 /= (float)entropyList.size();
        c3 /= (float)entropyList.size();
        c4 /= (float)entropyList.size();
        c5 /= (float)entropyList.size();
        c6 /= (float)entropyList.size();
        c7 /= (float)entropyList.size();
        ArrayList<String> finalEP = new ArrayList<String>();
        finalEP.add(String.valueOf(c1));
        finalEP.add(String.valueOf(c2));
        finalEP.add(String.valueOf(c3));
        finalEP.add(String.valueOf(c4));
        finalEP.add(String.valueOf(c5));
        finalEP.add(String.valueOf(c6));
        finalEP.add(String.valueOf(c7));
        String string = String.join((CharSequence)", ", finalEP);
        File file = new File("/parablu/RWdetection/source_oct/inputFile.txt");
        UploadController.writeUsingFileWriter(string, file, fileName);
        return file;
    }

    public List<String> validateRwDetection1(List<String> entropyOp, String inputFile, String exePath) {
        try {
            long currentTime = System.currentTimeMillis();
            File file = new File(inputFile);
            logger.debug("file.length() is" + file.getAbsolutePath() + file.exists());
            ArrayList<String> command = new ArrayList<String>();
            command.add(exePath);
            command.add("-t");
            command.add(file.getAbsolutePath());
            ProcessBuilder pb = new ProcessBuilder(command);
            try {
                Process process = pb.start();
                try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line;
                    BufferedReader error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    while ((line = error.readLine()) != null) {
                        logger.debug(".......entropy........" + line);
                        if (line.startsWith("0,File-bytes,Entropy")) continue;
                        entropyOp.add(line);
                    }
                    while ((line = in.readLine()) != null) {
                        logger.debug("......entropy..33......" + line);
                        if (line.startsWith("0,File-bytes,Entropy")) continue;
                        entropyOp.add(line);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.debug(e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.debug(e.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug(e.getMessage());
        }
        return entropyOp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeUsingFileWriter(String data, File file, String fileName) {
        FileWriter fr = null;
        try {
            fr = new FileWriter(file);
            fr.write(fileName + "::");
            fr.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fr.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @RequestMapping(value={"/healthcheck/"}, method={RequestMethod.GET})
    public void pingCloudNew(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Entering uploadController healthcheck...");
        try {
            long count = this.utilService.countOfPresentUsers(1, "Dummy");
            logger.debug(".....count........" + count);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace("EXCEPTION" + e);
            logger.error("error in healthcheck ...", (Throwable)e);
            response.setStatus(500);
        }
    }

    private boolean isLicenseEnabled(Cloud cl, String licenseName) {
        boolean isLicenseScanEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !licenseName.equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isLicenseScanEnabled = true;
                break;
            }
        }
        logger.debug(licenseName + isLicenseScanEnabled);
        return isLicenseScanEnabled;
    }
}

