/*
 * Decompiled with CFR 0.152.
 */
package com.pg.dao.impl;

import com.mongodb.ReadPreference;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.parablu.pcbd.domain.BackupFile;
import com.parablu.pcbd.domain.ConsolidatedImage;
import com.parablu.pcbd.domain.FileRevision;
import com.parablu.pcbd.domain.MiniCloud;
import com.pg.dao.SyncFileDao;
import com.pg.domain.ChunkFile;
import com.pg.factory.BlukryptMongoFactoryUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class SyncFileDaoImpl
implements SyncFileDao {
    private static Logger logger = LogManager.getLogger(SyncFileDaoImpl.class);
    private static final String PRIVACY_GATEWAY_SYNC = "privacy_gateway_sync_";
    BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    @Override
    public ConsolidatedImage getConsolidatedImageDBRecordByDevicePath(int cloudId, String userName, String cloudName, String devicePath, String fileName) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"devicePath").is((Object)devicePath)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").regex("^" + userName + "$", "i"), Criteria.where((String)"devicePath").is((Object)devicePath)});
        }
        criteria.orOperator(new Criteria[]{Criteria.where((String)"fileName").regex("^" + fileName + "$", "i"), Criteria.where((String)"fileName").is((Object)fileName)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"modifiedTime"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
    }

    @Override
    public ConsolidatedImage getConsolidatedImageDBRecordByDevicePathWithoutRegex(int cloudId, String userName, String cloudName, String devicePath, String fileName) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"devicePath").is((Object)devicePath)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").regex("^" + userName + "$", "i"), Criteria.where((String)"devicePath").is((Object)devicePath)});
        }
        criteria.orOperator(new Criteria[]{Criteria.where((String)"fileName").is((Object)fileName)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"modifiedTime"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
    }

    @Override
    public void saveToConsolidatedImageDB(int cloudId, String cloudName, ConsolidatedImage consolidatedImage) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)consolidatedImage);
    }

    @Override
    public void saveRevision(int cloudId, String cloudName, FileRevision fileRevision) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)fileRevision);
    }

    @Override
    public void deleteRevision(int cloudId, String cloudName, FileRevision fileRevision) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove((Object)fileRevision);
    }

    @Override
    public FileRevision getPresentRevisionByRevisionNumber(int cloudId, String cloudName, ObjectId consolidateImageId, int revisionNumber) {
        String status = REVISION_STATUS.DELETED.toString();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"consolidatedImage.$id").is((Object)consolidateImageId), Criteria.where((String)"status").ne((Object)status)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastModifiedTime"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (FileRevision)mongoTemplate.findOne(query, FileRevision.class);
    }

    @Override
    public List<MiniCloud> getAllMiniClouds(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"status").ne((Object)"DELETED"));
        return mongoTemplate.find(query, MiniCloud.class);
    }

    @Override
    public FileRevision getLatestRevision(int cloudId, String cloudName, ObjectId consolidateImageId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"consolidatedImage.$id").is((Object)consolidateImageId)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastModifiedTime"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (FileRevision)mongoTemplate.findOne(query, FileRevision.class);
    }

    @Override
    public BackupFile getLastSyncFile(int cloudId, String cloudName, String userName) {
        BackupFile backupFile = null;
        try {
            String tableName = PRIVACY_GATEWAY_SYNC + cloudName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            if (!mongoTemplate.collectionExists(tableName)) {
                mongoTemplate.createCollection(tableName);
            }
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").is((Object)userName)});
            Query query = new Query((CriteriaDefinition)criteria);
            query.with(new Sort(Sort.Direction.DESC, new String[]{"id"}));
            query.limit(1);
            backupFile = (BackupFile)mongoTemplate.findOne(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(" !!!!! ERROR TRYING TO getLastSyncFile ...." + e.getMessage());
        }
        return backupFile;
    }

    @Override
    public int getChunkFileCountForGivenPath(int cloudId, String cloudName, String cloudStoragePath) {
        long fileCount = 0L;
        try {
            String tableName = PRIVACY_GATEWAY_SYNC + cloudName;
            logger.debug("cloud id>>>" + cloudId + "cloudName>>>:" + tableName.toUpperCase());
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            if (!mongoTemplate.collectionExists(tableName)) {
                mongoTemplate.createCollection(tableName);
            }
            tableName = tableName.toUpperCase();
            MongoCollection collection = mongoTemplate.getCollection(tableName);
            logger.debug(cloudStoragePath + "Collection mycol selected successfully" + tableName);
            Bson statusQuery = Filters.eq((String)"cloudStoragePath", (Object)cloudStoragePath);
            Bson fields = Filters.eq((String)"$elemMatch", (Object)statusQuery);
            Bson query = Filters.eq((String)"chunkFiles", (Object)fields);
            fileCount = collection.countDocuments(query);
            logger.debug(cloudStoragePath + "Collection chunkfile success AND COUNT>--------------->>>" + fileCount);
        }
        catch (Exception e) {
            logger.error(" !!!!! ERROR TRYING TO get chunkfile count ...." + e);
        }
        return (int)fileCount;
    }

    @Override
    public com.pg.domain.BackupFile getSyncFileForId(int cloudId, String cloudName, String userName, String deviceUUID, String backupId) {
        String tableName = PRIVACY_GATEWAY_SYNC + cloudName;
        tableName = tableName.toUpperCase();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (!mongoTemplate.collectionExists(tableName)) {
            mongoTemplate.createCollection(tableName);
        }
        MongoCollection backupCollection = mongoTemplate.getCollection(tableName);
        backupCollection.withReadPreference(ReadPreference.secondary());
        Bson query = Filters.eq((String)"_id", (Object)new ObjectId(backupId));
        FindIterable find = backupCollection.find(query);
        MongoCursor cursor = find.iterator();
        com.pg.domain.BackupFile backupFile = null;
        while (cursor.hasNext()) {
            Document dbObject = (Document)cursor.next();
            backupFile = this.getConvertedObject(deviceUUID, dbObject);
            if (backupFile == null || !StringUtils.isEmpty((String)backupFile.getMd5())) continue;
            String md5CheckSum = this.getMd5CheckSumForId(cloudId, backupId);
            backupFile.setMd5(md5CheckSum);
            logger.debug("cloud storage type>>>>>>>>>>" + backupFile.getChunkFiles().get(0).getCloudStoragePath());
        }
        return backupFile;
    }

    @Override
    public void deleteRevision(int cloudId, String cloudName, String revisionId) {
        try {
            if (!StringUtils.isEmpty((String)revisionId)) {
                Criteria criteria = new Criteria();
                criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)new ObjectId(revisionId))});
                Query query = new Query((CriteriaDefinition)criteria);
                MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
                mongoTemplate.findAndRemove(query, FileRevision.class);
                logger.debug(" file deleted from revision table.... ");
            }
        }
        catch (Exception e) {
            logger.trace(" error trying to delete revision.... " + e);
            logger.error(" error trying to delete the revision from FileRevision......");
        }
        try {
            if (!StringUtils.isEmpty((String)revisionId)) {
                String tableName = PRIVACY_GATEWAY_SYNC + cloudName;
                tableName = tableName.toUpperCase();
                Criteria criteria = new Criteria();
                criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)new ObjectId(revisionId))});
                Query query = new Query((CriteriaDefinition)criteria);
                MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
                mongoTemplate.findAndRemove(query, BackupFile.class, tableName);
                logger.debug(" file deleted from centralized sync table.... ");
            }
        }
        catch (Exception e) {
            logger.trace(" error trying to delete revision. from PRIVACY_GATEWAY_SYNC... " + e);
            logger.error(" error trying to delete the revision from PRIVACY_GATEWAY_SYNC......");
        }
    }

    @Override
    public com.pg.domain.BackupFile getSyncFileForMd5(int cloudId, String cloudName, String userName, String deviceUUID, String md5) {
        String tableName = PRIVACY_GATEWAY_SYNC + cloudName;
        tableName = tableName.toUpperCase();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (!mongoTemplate.collectionExists(tableName)) {
            mongoTemplate.createCollection(tableName);
        }
        ArrayList<com.pg.domain.BackupFile> list = new ArrayList<com.pg.domain.BackupFile>();
        MongoCollection backupCollection = mongoTemplate.getCollection(tableName);
        backupCollection.withReadPreference(ReadPreference.secondary());
        Bson query = Filters.eq((String)"md5", (Object)md5);
        FindIterable find = backupCollection.find(query);
        MongoCursor cursor = find.iterator();
        com.pg.domain.BackupFile backupFile = null;
        while (cursor.hasNext()) {
            Document dbObject = (Document)cursor.next();
            backupFile = this.getConvertedObject(deviceUUID, dbObject);
            list.add(backupFile);
            if (backupFile != null && StringUtils.isEmpty((String)backupFile.getMd5())) {
                String md5CheckSum = this.getMd5CheckSumForId(cloudId, backupFile.getId());
                backupFile.setMd5(md5CheckSum);
                logger.debug("cloud storage type>>>>>>>>>>" + backupFile.getChunkFiles().get(0).getCloudStoragePath());
            }
            list.removeAll(Collections.singleton(null));
            list.sort((a, b) -> a.getId().compareTo(b.getId()));
            backupFile = (com.pg.domain.BackupFile)list.get(0);
            logger.debug(" .........backup file............" + backupFile.getId());
        }
        return backupFile;
    }

    private com.pg.domain.BackupFile getConvertedObject(String deviceUUID, Document dbObject) {
        com.pg.domain.BackupFile backupFile = new com.pg.domain.BackupFile();
        String objectId = dbObject.get((Object)"_id").toString();
        List<ChunkFile> chunkFiles = SyncFileDaoImpl.getChunkFiles(dbObject);
        backupFile.setId(objectId);
        backupFile.setBackupId(new ObjectId(objectId));
        backupFile.setFileName(dbObject.get((Object)"fileName").toString());
        backupFile.setFilePath(dbObject.get((Object)"filePath").toString());
        backupFile.setDeviceUUID(dbObject.get((Object)"deviceUUID").toString());
        backupFile.setUserName(dbObject.get((Object)"userName").toString());
        if (dbObject.get((Object)"compressed") != null) {
            backupFile.setCompressed(Boolean.parseBoolean(dbObject.get((Object)"compressed").toString()));
        }
        if (dbObject.get((Object)"dedupBackupId") != null) {
            backupFile.setDedupBackupId(dbObject.get((Object)"dedupBackupId").toString());
        }
        if (dbObject.get((Object)"md5") != null) {
            backupFile.setMd5(dbObject.get((Object)"md5").toString());
        }
        backupFile.setChunkFiles(chunkFiles);
        return backupFile;
    }

    private static List<ChunkFile> getChunkFiles(Document dbObject) {
        List list = (List)dbObject.get((Object)"chunkFiles");
        ArrayList<ChunkFile> chunkFiles = new ArrayList<ChunkFile>();
        for (Document chunk : list) {
            Object cloudStoragePath = chunk.get((Object)"cloudStoragePath");
            ChunkFile chunkFile = new ChunkFile();
            if (chunk.get((Object)"fileId") != null) {
                chunkFile.setFileId(chunk.get((Object)"fileId").toString());
            }
            chunkFile.setFileName(chunk.get((Object)"fileName").toString());
            if (chunk.get((Object)"md5") != null) {
                chunkFile.setMd5(chunk.get((Object)"md5").toString());
            }
            chunkFile.setUploadedTimeStamp((Long)chunk.get((Object)"uploadedTimeStamp"));
            if (chunk.get((Object)"fSPath") != null) {
                chunkFile.setfSPath(chunk.get((Object)"fSPath").toString());
            }
            if (cloudStoragePath != null) {
                chunkFile.setCloudStoragePath(cloudStoragePath.toString());
            }
            chunkFiles.add(chunkFile);
        }
        return chunkFiles;
    }

    private String getMd5CheckSumForId(int cloudId, String revisionId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String tableName = "REVISIONS";
        String md5CheckSum = "";
        MongoCollection backupCollection = mongoTemplate.getCollection(tableName);
        backupCollection.withReadPreference(ReadPreference.secondary());
        Bson query = Filters.eq((String)"_id", (Object)new ObjectId(revisionId));
        FindIterable find = backupCollection.find(query);
        MongoCursor cursor = find.iterator();
        while (cursor.hasNext()) {
            Document dbObject = (Document)cursor.next();
            md5CheckSum = dbObject.get((Object)"md5").toString();
        }
        cursor.close();
        return md5CheckSum;
    }

    @Override
    public MiniCloud getMiniCloudByName(int cloudId, String miniCloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"miniCloudName").is((Object)miniCloudName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (MiniCloud)mongoTemplate.findOne(query, MiniCloud.class);
    }

    @Override
    public MiniCloud getMiniCloudById(int cloudId, String miniCloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)miniCloudId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (MiniCloud)mongoTemplate.findOne(query, MiniCloud.class);
    }

    public static enum REVISION_STATUS {
        MODIFIED,
        DELETED,
        ADDED,
        RESTORED;

    }
}

