/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.parablu.pcbd.dao.MSUtilDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Components;
import com.parablu.pcbd.domain.CrawlDeltaFileInfo;
import com.parablu.pcbd.domain.DeltaPath;
import com.parablu.pcbd.domain.EWSAppSetting;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.ExcludedFolders;
import com.parablu.pcbd.domain.FolderFileInfo;
import com.parablu.pcbd.domain.InclusionFilter;
import com.parablu.pcbd.domain.MSAppBluKrypt;
import com.parablu.pcbd.domain.MSAppSetting;
import com.parablu.pcbd.domain.ODBBackupBatch;
import com.parablu.pcbd.domain.OPWS;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PrivacyGateway;
import com.parablu.pcbd.domain.Schedule;
import com.pg.domain.DriveFileInfo;
import com.pg.factory.BlukryptMongoFactoryUtils;
import com.pg.helper.constant.PCHelperConstant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;

public class MSUtilDaoImpl
implements MSUtilDao {
    private static Logger logger = LogManager.getLogger(MSUtilDaoImpl.class);
    private static final String ACTION = "action";
    private static final String ACTION_TO_DEVICEUUID = "actionToDeviceUUID";
    private MongoOperations msgMongoTemplate;
    private MongoOperations mongoOps;
    BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;
    private static final String DEVICE = "device";
    private static final String FILE_NAME = "fileName";
    private static final String DEVICE_PATH = "devicePath";
    private static final String LAST_SERVER_MODIFIED_TIME = "lastServerModifiedTime";
    private static final String PRESENT = "present";
    private static final String DEVICE_UUID = "deviceUUID";

    public MongoOperations getMongoTemplate() {
        return this.msgMongoTemplate;
    }

    public void setMsgMongoTemplate(MongoOperations msgMongoTemplate) {
        this.msgMongoTemplate = msgMongoTemplate;
    }

    public MongoOperations getMongoOps() {
        return this.mongoOps;
    }

    public void setMongoOps(MongoOperations mongoOps) {
        this.mongoOps = mongoOps;
    }

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    @Override
    public List<OfficeBackupPolicy> getAllOfficeBackupPolicies(int cloudId, String policyType) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        if (!"Sharepoint".equalsIgnoreCase(policyType)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false), Criteria.where((String)"policType").is((Object)"Sharepoint")});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        return mongoTemplate.find(query, OfficeBackupPolicy.class);
    }

    @Override
    public boolean saveDriveItem(int cloudId, DriveFileInfo driveFileInfo, CrawlDeltaFileInfo crawlDeltaFileInfo) {
        boolean itemSaved = false;
        Criteria andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)driveFileInfo.getDeviceUUID()), Criteria.where((String)"itemPath").is((Object)driveFileInfo.getItemPath()), Criteria.where((String)"itemName").is((Object)driveFileInfo.getItemName()), Criteria.where((String)"itemId").is((Object)driveFileInfo.getItemId())});
        Query query = new Query((CriteriaDefinition)andCriteria);
        DriveFileInfo existFile = (DriveFileInfo)this.msgMongoTemplate.findOne(query, DriveFileInfo.class);
        if (existFile == null) {
            this.msgMongoTemplate.save((Object)driveFileInfo);
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            mongoTemplate.save((Object)crawlDeltaFileInfo);
            itemSaved = true;
        }
        logger.debug(itemSaved + "...file added...." + driveFileInfo.getDeviceUUID() + "..." + driveFileInfo.getItemPath() + "...." + driveFileInfo.getItemId());
        return itemSaved;
    }

    @Override
    public void saveBulkDriveItem(int cloudId, List<DriveFileInfo> driveFileInfoList, List<CrawlDeltaFileInfo> crawlDeltaFileInfoList) {
        if (!CollectionUtils.isEmpty(driveFileInfoList)) {
            BulkOperations localbulkOps = this.msgMongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, DriveFileInfo.class);
            localbulkOps.insert(driveFileInfoList);
            localbulkOps.execute();
        }
        if (!CollectionUtils.isEmpty(crawlDeltaFileInfoList)) {
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            BulkOperations bulkOps = mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, CrawlDeltaFileInfo.class);
            bulkOps.insert(driveFileInfoList);
            bulkOps.execute();
        }
    }

    @Override
    public void saveDeletedDriveItem(int cloudId, String deletedItemId) {
    }

    @Override
    public List<DriveFileInfo> getDriveFileInfoList() {
        Query query = new Query().limit(PCHelperConstant.getQueryLimit());
        return this.msgMongoTemplate.find(query, DriveFileInfo.class);
    }

    @Override
    public void deleteDriveInfo(String driveFileInfoId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)driveFileInfoId));
        this.msgMongoTemplate.findAndRemove(query, DriveFileInfo.class);
    }

    @Override
    public String saveBatchDetails(int cloudId, ODBBackupBatch backupBatch, String policyName, long batchStartTime) {
        backupBatch.setBatchStartTimestamp(batchStartTime);
        this.msgMongoTemplate.save((Object)backupBatch, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug("...dao... " + backupBatch);
        logger.debug("...dao1... " + backupBatch.getId());
        if ("STARTED".equalsIgnoreCase(backupBatch.getStatus())) {
            // empty if block
        }
        return backupBatch.getId().toString();
    }

    @Override
    public void deleteBatchFromOdServer(ObjectId id, String policyName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        this.msgMongoTemplate.findAndRemove(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
    }

    public Components getComponents(String componentName, int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"gatewayName").is((Object)componentName);
        Query query = new Query((CriteriaDefinition)criteria);
        PrivacyGateway privacyGateway = (PrivacyGateway)mongoTemplate.findOne(query, PrivacyGateway.class);
        Components components = new Components();
        if (privacyGateway != null) {
            components.setComponentName(componentName);
            components.setComponentsProperties(privacyGateway.getComponentsProperties());
            components.setNoOfThreadsUsed(privacyGateway.getNoOfThreadsUsed());
        }
        return components;
    }

    @Override
    public List<ODBBackupBatch> getBatchList(String policyName) {
        if (PCHelperConstant.getPGOverloadLimit() == 0) {
            Properties props = null;
            try {
                long threadSize;
                String threadstr;
                ClassPathResource resource = new ClassPathResource("privacygateway.properties");
                props = PropertiesLoaderUtils.loadProperties((Resource)resource);
                logger.debug(".....componentn name ..... " + props.getProperty("componentName"));
                Components components = this.getComponents(props.getProperty("componentName"), 1);
                logger.debug("getting components properties from db of" + components.getComponentName());
                Map<String, String> componentProperties = components.getComponentsProperties();
                if (componentProperties.containsKey("pgOverloadLimit") && !StringUtils.isEmpty((String)(threadstr = componentProperties.get("pgOverloadLimit")))) {
                    threadSize = Integer.parseInt(threadstr);
                    logger.debug("...threads from collection ...." + threadSize);
                    PCHelperConstant.setPGOverloadLimit((String)("" + threadSize));
                }
                if (componentProperties.containsKey("officeDownloadThreads")) {
                    threadstr = componentProperties.get("officeDownloadThreads");
                    if (!StringUtils.isEmpty((String)threadstr)) {
                        threadSize = Integer.parseInt(threadstr);
                        logger.debug("...threads from db for offfice ...." + threadSize);
                        PCHelperConstant.setOfficeThreadsValue((String)("" + threadSize));
                    }
                } else {
                    PCHelperConstant.setOfficeThreadsValue((String)"2");
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
                logger.error("...error trying to get threads..." + ee.getMessage());
            }
        }
        if (PCHelperConstant.getPGOverloadLimit() > 0) {
            Criteria criteria2 = Criteria.where((String)"status").is((Object)"DEFERRED");
            Query query = new Query((CriteriaDefinition)criteria2);
            Update updateObj = new Update();
            updateObj.set("status", (Object)"COMPLETED");
            UpdateResult updateFirstObj = this.msgMongoTemplate.updateFirst(query, updateObj, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
            Criteria criteria = Criteria.where((String)"cloudId").is((Object)1);
            Query query2 = new Query((CriteriaDefinition)criteria);
            Cloud cloud = (Cloud)this.mongoOps.findOne(query2, Cloud.class);
            boolean licenseActive = this.vaildatedLicensceStatus(cloud);
            if (licenseActive) {
                Criteria criteria1 = Criteria.where((String)"status").is((Object)"LICENSEEXPIRED");
                Query query1 = new Query((CriteriaDefinition)criteria1);
                Update update = new Update();
                update.set("status", (Object)"COMPLETED");
                UpdateResult updateResult = this.msgMongoTemplate.updateFirst(query1, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
            }
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"status").is((Object)"COMPLETED"));
        return this.msgMongoTemplate.find(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
    }

    private boolean vaildatedLicensceStatus(Cloud cloud) {
        return cloud.getValidityPeriod() >= System.currentTimeMillis() && cloud.getStatusCode().equals("ACTIVE");
    }

    @Override
    public List<DriveFileInfo> getDriveFileInfoFromListForBatchId(String batchId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"backupBatchId").is((Object)batchId));
        query.limit(5);
        return this.msgMongoTemplate.find(query, DriveFileInfo.class);
    }

    @Override
    public void updateBatchDetails(int cloudId, ODBBackupBatch backupBatch, String policyName, long batchStartTime) {
        Update update;
        List find;
        Query query;
        Criteria criteria;
        if (!StringUtils.isEmpty((String)backupBatch.getStatus()) && "COMPLETED".equalsIgnoreCase(backupBatch.getStatus())) {
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)backupBatch.getDeviceUUID())});
            query = new Query((CriteriaDefinition)criteria);
            find = this.msgMongoTemplate.find(query, DriveFileInfo.class);
            if (!CollectionUtils.isEmpty((Collection)find)) {
                logger.debug("....findprev list ... " + find.size());
            }
            update = new Update();
            update.set("backupBatchId", (Object)backupBatch.getId());
            UpdateResult updateRes = this.msgMongoTemplate.updateMulti(query, update, DriveFileInfo.class);
            logger.debug(updateRes.getModifiedCount() + "...updated successfully.... " + policyName + "..." + backupBatch.getId());
            long totalcount = this.msgMongoTemplate.count(query, DriveFileInfo.class);
            backupBatch.setNoOfFiles(totalcount);
        }
        if ((find = this.msgMongoTemplate.find(query = new Query((CriteriaDefinition)(criteria = Criteria.where((String)"id").is((Object)backupBatch.getId()))), ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase())) != null) {
            logger.debug("....find list ... " + find.size());
        }
        update = new Update();
        update.set("status", (Object)backupBatch.getStatus());
        update.set("noOfFiles", (Object)backupBatch.getNoOfFiles());
        update.set("batchStartTimestamp", (Object)batchStartTime);
        UpdateResult updateFirst = this.msgMongoTemplate.updateFirst(query, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug(updateFirst.getModifiedCount() + "...updated successfully.... " + policyName + "..." + backupBatch.getId());
    }

    @Override
    public List<EventHub> getStartBackupEventHubList(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)ACTION).is((Object)"FULL_BACKUP"), Criteria.where((String)ACTION).is((Object)"START_BACKUP")});
        Criteria odStatusCriteria = Criteria.where((String)"odStatus").is((Object)"STARTED");
        andCriteria.andOperator(new Criteria[]{odStatusCriteria, criteria});
        Query query = new Query((CriteriaDefinition)andCriteria);
        return mongoTemplate.find(query, EventHub.class);
    }

    @Override
    public void deleteActionBasedOnBackupBatchStatus(int cloudId, String deviceUUID, String action) {
        Criteria andCriteria = new Criteria();
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)ACTION).is((Object)"FULL_BACKUP"), Criteria.where((String)ACTION).is((Object)"START_BACKUP")});
        Criteria devUUIDCriteria = Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)deviceUUID);
        andCriteria.andOperator(new Criteria[]{devUUIDCriteria, criteria});
        Query query = new Query((CriteriaDefinition)andCriteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        DeleteResult remove = mongoTemplate.remove(query, EventHub.class);
        logger.debug("...removed eventhub.... " + action + "....." + deviceUUID + "......" + remove.getDeletedCount());
    }

    @Override
    public List<EventHub> getEventHubForDeviceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, EventHub.class);
    }

    @Override
    public BackUpImage getBackupImageForItemId(int cloudId, String itemId, String deviceDestCollection, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)"odItemId").is((Object)itemId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, BackUpImage.class, deviceDestCollection);
        BackUpImage backUpImage = null;
        if (!CollectionUtils.isEmpty((Collection)list)) {
            if (list.size() > 1) {
                for (BackUpImage image : list) {
                    if (!image.getStatus().equals(PCHelperConstant.REVISION_STATUS.DELETED)) continue;
                    logger.debug("...item id already deleted...." + image.getOdItemId());
                    return null;
                }
                backUpImage = (BackUpImage)list.get(0);
            } else {
                backUpImage = (BackUpImage)list.get(0);
                logger.debug(backUpImage.getUserName() + "..path..." + backUpImage.getDevicePath() + "..... item to be deleted .... " + backUpImage.getOdItemId() + "...." + backUpImage.getId());
            }
        }
        return backUpImage;
    }

    @Override
    public void saveDeletedBackupImage(int cloudId, BackUpImage deletedBkpImage, String deviceDestCollection) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)deletedBkpImage, deviceDestCollection);
    }

    @Override
    public void updateEventHubOdStatus(int cloudId, ObjectId eventHubId) {
        Criteria criteria = Criteria.where((String)"id").is((Object)eventHubId);
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List find = mongoTemplate.find(query, EventHub.class);
        if (find != null) {
            logger.debug("....find list ... " + find.size());
        }
        Update update = new Update();
        update.set("odStatus", (Object)EventHub.ODSTATUS.PROCESSED.toString());
        UpdateResult updateFirst = mongoTemplate.updateFirst(query, update, EventHub.class);
        logger.debug(updateFirst.getModifiedCount() + "...event hub updated successfully.... " + eventHubId);
    }

    @Override
    public void updateBatchStatusInOdServer(ObjectId id, String policyName) {
        Criteria criteria = Criteria.where((String)"id").is((Object)id);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("status", (Object)"PAUSED");
        UpdateResult updateFirst = this.msgMongoTemplate.updateFirst(query, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug(updateFirst.getModifiedCount() + "... paused successfully.... " + policyName + "..." + id);
    }

    @Override
    public boolean isPrevBkpPaused(String actionToDeviceUUID, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)actionToDeviceUUID), Criteria.where((String)"status").is((Object)"PAUSED")});
        Query query = new Query((CriteriaDefinition)criteria);
        ODBBackupBatch bkpBatch = (ODBBackupBatch)this.msgMongoTemplate.findOne(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        boolean isPrevBkpPaused = false;
        if (bkpBatch != null && "PAUSED".equalsIgnoreCase(bkpBatch.getStatus())) {
            isPrevBkpPaused = true;
        }
        return isPrevBkpPaused;
    }

    @Override
    public void updatePauseBkp(String actionToDeviceUUID, String policyName) {
        Criteria criteria = Criteria.where((String)DEVICE_UUID).is((Object)actionToDeviceUUID);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("status", (Object)"COMPLETED");
        UpdateResult updateFirst = this.msgMongoTemplate.updateFirst(query, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug(updateFirst.getMatchedCount() + "... unpaused successfully.... " + policyName + "..." + actionToDeviceUUID);
    }

    @Override
    public long getThreadSize(int cloudId, String cloudName) {
        Query query;
        OPWS opws;
        String tableName = "opws_" + cloudName;
        tableName = tableName.toUpperCase();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (!mongoTemplate.collectionExists(tableName)) {
            mongoTemplate.createCollection(tableName);
        }
        if ((opws = (OPWS)mongoTemplate.findOne(query = new Query(), OPWS.class, tableName)) != null) {
            return opws.getThreadSize();
        }
        return 0L;
    }

    @Override
    public List<BackUpImage> getChildrenByFolder(int cloudId, String folderPath, String deviceUUID, String destCollection) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)folderPath)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_SERVER_MODIFIED_TIME}));
        List<BackUpImage> backupImageList = new ArrayList<BackUpImage>();
        List list = mongoTemplate.find(query, BackUpImage.class, destCollection);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            backupImageList.addAll(list);
        }
        backupImageList = this.getFilteredBackupImageListByGrouping(backupImageList);
        return backupImageList;
    }

    private List<ObjectId> getAggregatedBackupIds(int cloudId, MongoTemplate mongoTemplate, String folderPath, String deviceUUID, String destCollection) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)PRESENT).is((Object)true)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME, DEVICE_PATH}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        ArrayList<String> bkpCollectionList = new ArrayList<String>();
        bkpCollectionList.add(destCollection);
        ArrayList stateStatsList = new ArrayList();
        for (String dest : bkpCollectionList) {
            AggregationResults result = mongoTemplate.aggregate(aggregation, dest, Document.class);
            List list = result.getMappedResults();
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            stateStatsList.addAll(list);
        }
        ArrayList<ObjectId> listOfObjectIds = new ArrayList<ObjectId>();
        for (Document dbObject : stateStatsList) {
            Long lastServerModifiedTime;
            String devicePath;
            String fileName = dbObject.get((Object)FILE_NAME).toString();
            BackUpImage backUpImage = this.getBackUpImageForFile(cloudId, deviceUUID, destCollection, mongoTemplate, fileName, devicePath = dbObject.get((Object)DEVICE_PATH).toString(), lastServerModifiedTime = (Long)dbObject.get((Object)LAST_SERVER_MODIFIED_TIME));
            if (backUpImage == null) continue;
            listOfObjectIds.add(backUpImage.getId());
        }
        return listOfObjectIds;
    }

    private BackUpImage getBackUpImageForFile(int cloudId, String deviceUUID, String destCollection, MongoTemplate mongoTemplate, String fileName, String devicePath, Long serverModifiedTime) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)LAST_SERVER_MODIFIED_TIME).is((Object)serverModifiedTime)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        ArrayList backUpImageList = new ArrayList();
        ArrayList<String> bkpCollectionList = new ArrayList<String>();
        bkpCollectionList.add(destCollection);
        for (String dest : bkpCollectionList) {
            List list = mongoTemplate.find(query, BackUpImage.class, dest);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            backUpImageList.addAll(list);
        }
        if (!CollectionUtils.isEmpty(backUpImageList)) {
            return (BackUpImage)backUpImageList.get(0);
        }
        return null;
    }

    private List<BackUpImage> getFilteredBackupImageListByGrouping(List<BackUpImage> backUpImages) {
        logger.debug("Inside grouping backup images");
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        backUpImages.stream().filter(p -> p.getDevicePath() == null).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(BackUpImage::getFileName)).entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().filter(p -> p.getDevicePath() != null).collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }

    @Override
    public void saveOfficeBackupPolicy(int cloudId, OfficeBackupPolicy officeBackupPolicy) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)officeBackupPolicy.getId()));
        this.msgMongoTemplate.findAndRemove(query, OfficeBackupPolicy.class);
        this.msgMongoTemplate.save((Object)officeBackupPolicy);
        if (!CollectionUtils.isEmpty(officeBackupPolicy.getBackupFolders())) {
            officeBackupPolicy.getBackupFolders().forEach(folders -> {
                if (folders != null) {
                    logger.debug("... MailBackupFolders..... " + folders.getFolderPath());
                    try {
                        Query query1 = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)folders.getId()));
                        this.msgMongoTemplate.findAndRemove(query1, BackupFolders.class);
                        this.msgMongoTemplate.save(folders);
                    }
                    catch (MongoException mongoException) {
                    }
                    catch (DuplicateKeyException duplicateKeyException) {
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                }
            });
        }
        if (!CollectionUtils.isEmpty(officeBackupPolicy.getSchedules())) {
            officeBackupPolicy.getSchedules().forEach(schedules -> {
                if (schedules != null) {
                    try {
                        logger.debug("... MailSchedules..... " + schedules.getTime());
                        Query query1 = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)schedules.getId()));
                        this.msgMongoTemplate.findAndRemove(query1, Schedule.class);
                        this.msgMongoTemplate.save(schedules);
                    }
                    catch (MongoException mongoException) {
                    }
                    catch (DuplicateKeyException duplicateKeyException) {
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                }
            });
        }
        if (!CollectionUtils.isEmpty(officeBackupPolicy.getExcludedFolders())) {
            officeBackupPolicy.getExcludedFolders().forEach(excludedFolders -> {
                if (excludedFolders != null) {
                    try {
                        logger.debug("... MailExcludedFolders..... " + excludedFolders.getFolderPath());
                        Query query1 = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)excludedFolders.getId()));
                        this.msgMongoTemplate.findAndRemove(query1, ExcludedFolders.class);
                        this.msgMongoTemplate.save(excludedFolders);
                    }
                    catch (MongoException mongoException) {
                    }
                    catch (DuplicateKeyException duplicateKeyException) {
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                }
            });
        }
        if (officeBackupPolicy.getInclusionFilter() != null) {
            for (InclusionFilter inclusionFilter : officeBackupPolicy.getInclusionFilter()) {
                try {
                    Query query1 = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)inclusionFilter.getId()));
                    this.msgMongoTemplate.findAndRemove(query1, InclusionFilter.class);
                    this.msgMongoTemplate.save((Object)inclusionFilter);
                }
                catch (MongoException mongoException) {
                }
                catch (DuplicateKeyException duplicateKeyException) {
                }
                catch (Exception exception) {
                }
                catch (Error error) {}
            }
        }
    }

    @Override
    public OfficeBackupPolicy getOfficeBackupPolicyFromLocal(int cloudId, String policyName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"policyName").is((Object)policyName));
        return (OfficeBackupPolicy)this.msgMongoTemplate.findOne(query, OfficeBackupPolicy.class);
    }

    @Override
    public BackUpImage getBackupImageFolderForItemId(int cloudId, String itemId, String deviceDestCollection) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"odItemId").is((Object)itemId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, BackUpImage.class, deviceDestCollection);
        logger.debug("..... for item id vla ..... " + itemId + "... " + deviceDestCollection);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            logger.debug("..... for list size ..... " + list.size());
        } else {
            logger.debug("... no files.... " + itemId);
        }
        BackUpImage backUpImage = null;
        if (!CollectionUtils.isEmpty((Collection)list)) {
            if (list.size() > 1) {
                logger.debug(".... folder filter..... ");
                List bkpImageList = list.stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).collect(Collectors.toList());
                backUpImage = (BackUpImage)bkpImageList.get(0);
                logger.debug(".... folder filter. after .... " + backUpImage.getDevicePath() + "/" + backUpImage.getFileName());
            } else {
                backUpImage = (BackUpImage)list.get(0);
                logger.debug("..... item to be deleted .... " + backUpImage.getOdItemId() + "...." + backUpImage.getId());
            }
        }
        return backUpImage;
    }

    @Override
    public void saveFolderItem(FolderFileInfo folderFileInfo) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"itemPath").is((Object)folderFileInfo.getItemPath()), Criteria.where((String)DEVICE_UUID).is((Object)folderFileInfo.getDeviceUUID())});
        Query query = new Query((CriteriaDefinition)criteria);
        this.msgMongoTemplate.findAndRemove(query, FolderFileInfo.class);
        this.msgMongoTemplate.save((Object)folderFileInfo);
    }

    @Override
    public String getFolderItemId(String path, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"itemPath").is((Object)path), Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        FolderFileInfo folderFileInfo = (FolderFileInfo)this.msgMongoTemplate.findOne(query, FolderFileInfo.class);
        String folderItemId = "";
        if (folderFileInfo != null) {
            folderItemId = folderFileInfo.getItemId();
        }
        logger.debug(".... item path .... " + path + "...id from table..." + folderItemId);
        return folderItemId;
    }

    @Override
    public List<ODBBackupBatch> getCurrentBatch(String policyName, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"status").is((Object)"COMPLETED"), Criteria.where((String)"userName").is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.msgMongoTemplate.find(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
    }

    public String getDatabaseName() {
        return "parablumsg";
    }

    public MongoClient mongoClient() {
        MongoCredential credential = MongoCredential.createCredential((String)"neil", (String)this.getDatabaseName(), (char[])"parablu".toCharArray());
        MongoClientOptions options = MongoClientOptions.builder().build();
        MongoClient client = new MongoClient(Arrays.asList(new ServerAddress(PCHelperConstant.getPropertyValueDBHost1().trim(), Integer.parseInt(PCHelperConstant.getPropertyValueDBPort1().trim())), new ServerAddress(PCHelperConstant.getPropertyValueDBHost2().trim(), Integer.parseInt(PCHelperConstant.getPropertyValueDBPort2().trim())), new ServerAddress(PCHelperConstant.getPropertyValueDBHost3().trim(), Integer.parseInt(PCHelperConstant.getPropertyValueDBPort3().trim()))), credential, options);
        return client;
    }

    public MongoDbFactory mongoDbFactory() {
        return new SimpleMongoDbFactory(this.mongoClient(), this.getDatabaseName());
    }

    public MongoTemplate mongoTemplate() {
        return new MongoTemplate(this.mongoDbFactory());
    }

    public MSAppBluKrypt getMsAppBluKrypt() {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        List findAllOdPolicies = mongoTemplate.findAll(OfficeBackupPolicy.class);
        String msAppBluKrypt = this.getMsAppBlukrypt(findAllOdPolicies);
        logger.debug("...msapp blukrypt ... " + msAppBluKrypt);
        MSAppBluKrypt msBluKrypt = null;
        if (!StringUtils.isEmpty((String)msAppBluKrypt)) {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"host").is((Object)msAppBluKrypt));
            msBluKrypt = (MSAppBluKrypt)mongoTemplate.findOne(query, MSAppBluKrypt.class);
        }
        return msBluKrypt;
    }

    private String getMsAppBlukrypt(List<OfficeBackupPolicy> findAllOdPolicies) {
        String msAppBluKrypt = "";
        for (OfficeBackupPolicy oneDriveBackupPolicy : findAllOdPolicies) {
            if (oneDriveBackupPolicy == null) continue;
            if (!StringUtils.isEmpty((String)oneDriveBackupPolicy.getMsAppBluKrypt()) && oneDriveBackupPolicy.getMsAppBluKrypt().equalsIgnoreCase(PCHelperConstant.getComponentName())) {
                msAppBluKrypt = oneDriveBackupPolicy.getMsAppBluKrypt();
                break;
            }
            if (StringUtils.isEmpty((String)oneDriveBackupPolicy.getMsAppBluKrypt()) || !oneDriveBackupPolicy.getMsAppBluKrypt().equalsIgnoreCase(PCHelperConstant.getComponentName())) continue;
            msAppBluKrypt = oneDriveBackupPolicy.getMsAppBluKrypt();
            break;
        }
        return msAppBluKrypt;
    }

    @Override
    public String getDeltaLinkForPathAndUser(String path, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"path").is((Object)path), Criteria.where((String)"userName").is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        DeltaPath deltaPath = (DeltaPath)this.msgMongoTemplate.findOne(query, DeltaPath.class);
        String delta = "";
        if (deltaPath != null) {
            delta = deltaPath.getDeltaLink();
        }
        return delta;
    }

    @Override
    public List<DeltaPath> getAllDeltaLinkUser(String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.msgMongoTemplate.find(query, DeltaPath.class);
    }

    @Override
    public void updateDeltaForPathAndUser(String path, String userName, String messDeltaLink) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"path").is((Object)path), Criteria.where((String)"userName").is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        DeltaPath existPath = (DeltaPath)this.msgMongoTemplate.findOne(query, DeltaPath.class);
        logger.debug("...deltapath .." + userName + ".." + path + "..." + messDeltaLink);
        if (existPath == null) {
            existPath = new DeltaPath();
            existPath.setPath(path);
            existPath.setUserName(userName);
            existPath.setDeltaLink(messDeltaLink);
            this.msgMongoTemplate.save((Object)existPath);
        } else {
            Update update = new Update();
            update.set("deltaLink", (Object)messDeltaLink);
            UpdateResult updateFirst = this.msgMongoTemplate.updateFirst(query, update, DeltaPath.class);
            logger.debug(updateFirst.getModifiedCount() + "...updated successfully.... " + path + "..." + userName);
        }
    }

    @Override
    public ObjectId saveEventHubAction(int cloudId, EventHub eventHub) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        EventHub save = (EventHub)mongoTemplate.save((Object)eventHub);
        return save.getId();
    }

    @Override
    public void saveStatisticToDatabase(int cloudId, AuditHistory auditHistory) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)auditHistory);
    }

    @Override
    public void saveEwsAppSetting(int cloudId, EWSAppSetting appSetting) {
        Query query;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        MSAppSetting msAppSetting = (MSAppSetting)mongoTemplate.findOne(query = new Query(), MSAppSetting.class);
        if (msAppSetting != null) {
            appSetting.setTenantId(msAppSetting.getTenantId());
        }
        mongoTemplate.remove(EWSAppSetting.class);
        mongoTemplate.save((Object)appSetting);
    }

    @Override
    public EWSAppSetting getEwsAppSettingDetail(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query();
        return (EWSAppSetting)mongoTemplate.findOne(query, EWSAppSetting.class);
    }

    @Override
    public List<CrawlDeltaFileInfo> getCrawlDeltaList(int cloudId, String folderPath) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{Criteria.where((String)"itemPath").is((Object)folderPath)});
        Query query = new Query((CriteriaDefinition)andCriteria);
        query.limit(500);
        return mongoTemplate.find(query, CrawlDeltaFileInfo.class);
    }

    @Override
    public void deleteCrawlInfo(int cloudId, ObjectId id) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)id)});
        Query query = new Query((CriteriaDefinition)andCriteria);
        mongoTemplate.findAndRemove(query, CrawlDeltaFileInfo.class);
    }

    @Override
    public List<CrawlDeltaFileInfo> getExistingTasksList(int cloudId, String userName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{Criteria.where((String)"userName").is((Object)userName), Criteria.where((String)"itemPath").is((Object)"Tasks")});
        Query query = new Query((CriteriaDefinition)andCriteria);
        return mongoTemplate.find(query, CrawlDeltaFileInfo.class);
    }

    @Override
    public List<CrawlDeltaFileInfo> getExistingContactsList(int cloudId, String userName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{Criteria.where((String)"userName").is((Object)userName), Criteria.where((String)"itemPath").is((Object)"Contacts")});
        Query query = new Query((CriteriaDefinition)andCriteria);
        return mongoTemplate.find(query, CrawlDeltaFileInfo.class);
    }

    @Override
    public void deleteBackupImageForItemId(int cloudId, String itemId, String deviceDestCollection) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{Criteria.where((String)"odItemId").is((Object)itemId)});
        Query query = new Query((CriteriaDefinition)andCriteria);
        mongoTemplate.findAndRemove(query, BackUpImage.class, deviceDestCollection);
    }

    @Override
    public long getTotalFilesCountByBatchId(String batchId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"backupBatchId").is((Object)batchId));
        return this.msgMongoTemplate.count(query, DriveFileInfo.class);
    }

    @Override
    public long getTotalFilesCountByPrevDelta(String userName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"userName").is((Object)userName));
        query.limit(50);
        logger.debug("getPrevItemsForMailBkp count...");
        return this.msgMongoTemplate.count(query, DriveFileInfo.class, "PREV_DELTA_ITEMS");
    }

    @Override
    public List<DriveFileInfo> getOneDriveFileInfoFromListForBatchId(int cloudId, String batchId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"backupBatchId").is((Object)batchId));
        query.limit(1);
        return this.msgMongoTemplate.find(query, DriveFileInfo.class);
    }

    @Override
    public void savePrevItemsForMailBackup(DriveFileInfo item) {
        item.setPrevDeltaItem(true);
        this.msgMongoTemplate.save((Object)item, "PREV_DELTA_ITEMS");
    }

    @Override
    public List<DriveFileInfo> getPrevItemsForMailBkp(String userName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"userName").is((Object)userName));
        query.limit(50);
        logger.debug("getPrevItemsForMailBkp");
        return this.msgMongoTemplate.find(query, DriveFileInfo.class, "PREV_DELTA_ITEMS");
    }

    @Override
    public void updateDeferedBatchStatusInOdServer(ObjectId id, String policyName) {
        Criteria criteria = Criteria.where((String)"id").is((Object)id);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("status", (Object)"DEFERRED");
        UpdateResult updateFirst = this.msgMongoTemplate.updateFirst(query, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug(updateFirst.getModifiedCount() + "... DEFERRED successfully.... " + policyName + "..." + id);
    }

    @Override
    public void updateLicenseExpiredBatchStatusInOdServer(ObjectId id, String policyName) {
        Criteria criteria = Criteria.where((String)"id").is((Object)id);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("status", (Object)"LICENSEEXPIRED");
        UpdateResult updateFirst = this.msgMongoTemplate.updateFirst(query, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug(updateFirst.getModifiedCount() + "... DEFERRED successfully.... " + policyName + "..." + id);
    }

    @Override
    public boolean isPrevBkpDeferred(String actionToDeviceUUID, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)actionToDeviceUUID), Criteria.where((String)"status").is((Object)"DEFERRED")});
        Query query = new Query((CriteriaDefinition)criteria);
        ODBBackupBatch bkpBatch = (ODBBackupBatch)this.msgMongoTemplate.findOne(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        boolean isPrevBkpPaused = false;
        if (bkpBatch != null && "DEFERRED".equalsIgnoreCase(bkpBatch.getStatus())) {
            isPrevBkpPaused = true;
        }
        return isPrevBkpPaused;
    }

    @Override
    public void updateDeferredBkp(String actionToDeviceUUID, String policyName) {
        Criteria criteria = Criteria.where((String)DEVICE_UUID).is((Object)actionToDeviceUUID);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("status", (Object)"COMPLETED");
        UpdateResult updateFirst = this.msgMongoTemplate.updateFirst(query, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug(updateFirst.getMatchedCount() + "... un deferred successfully.... " + policyName + "..." + actionToDeviceUUID);
    }

    @Override
    public long getTotaFailedlFilesFromPrevBackup(String deviceUUID) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID));
        query.limit(50);
        logger.debug("getTotaFailedlFilesFromPrevBackup count...");
        return this.msgMongoTemplate.count(query, DriveFileInfo.class, "RETRY_FAILED_FILES");
    }

    @Override
    public void removeFailedFile(String itemId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)itemId));
        this.msgMongoTemplate.findAndRemove(query, DriveFileInfo.class, "RETRY_FAILED_FILES");
    }

    @Override
    public List<ODBBackupBatch> getBatchList(String policyName, int limit) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"status").is((Object)"COMPLETED"));
        query.limit(limit);
        return this.msgMongoTemplate.find(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
    }

    @Override
    public long getTotalSizeByBatchId(String batchId) {
        long totalSize = 0L;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"backupBatchId").is((Object)batchId)});
        TypedAggregation aggregation = Aggregation.newAggregation(DriveFileInfo.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"id"}).sum("size").as("size"), Aggregation.project((String[])new String[]{"size"})});
        AggregationResults result = this.msgMongoTemplate.aggregate(aggregation, Document.class);
        List overViewList = result.getMappedResults();
        for (Document dbObject : overViewList) {
            totalSize += ((Long)dbObject.get((Object)"size")).longValue();
        }
        return totalSize;
    }

    @Override
    public void saveDriveFileInfo(DriveFileInfo driveFileInfo) {
        this.msgMongoTemplate.save((Object)driveFileInfo);
        this.removeFailedFile(driveFileInfo.getId().toString());
    }

    @Override
    public List<DriveFileInfo> getPrevBatchFailedFiles(String deviceUUID) {
        Criteria criteria = new Criteria();
        logger.debug("......getPrevBatchFailedFiles....." + deviceUUID);
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.msgMongoTemplate.find(query, DriveFileInfo.class);
    }

    @Override
    public List<EventHub> getStartBackupEventHubListForBlukrypt(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)ACTION).is((Object)"FULL_BACKUP"), Criteria.where((String)ACTION).is((Object)"START_BACKUP")});
        Criteria odStatusCriteria = new Criteria();
        odStatusCriteria.orOperator(new Criteria[]{Criteria.where((String)"odStatus").is((Object)"STARTED"), Criteria.where((String)"odStatus").is((Object)"PROCESSED")});
        andCriteria.andOperator(new Criteria[]{odStatusCriteria, criteria, Criteria.where((String)"blukryptName").is((Object)PCHelperConstant.getComponentName())});
        Query query = new Query((CriteriaDefinition)andCriteria);
        List list = mongoTemplate.find(query, EventHub.class);
        logger.debug("...empty events so try if any orphaned events lastUpdatedTime...");
        andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{odStatusCriteria, criteria, Criteria.where((String)"lastUpdatedTime").is((Object)0)});
        query = new Query((CriteriaDefinition)andCriteria);
        List oldlist = mongoTemplate.find(query, EventHub.class);
        list.addAll(oldlist);
        if (!CollectionUtils.isEmpty((Collection)oldlist)) {
            logger.debug(list.size() + "....overall list ..lastUpdatedTime.." + oldlist.size());
        }
        return list;
    }

    @Override
    public void removeOldEventHub(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)ACTION).is((Object)"FULL_BACKUP"), Criteria.where((String)ACTION).is((Object)"START_BACKUP")});
        Criteria odStatusCriteria = new Criteria();
        odStatusCriteria.orOperator(new Criteria[]{Criteria.where((String)"odStatus").is((Object)"STARTED"), Criteria.where((String)"odStatus").is((Object)"PROCESSED")});
        andCriteria.andOperator(new Criteria[]{odStatusCriteria, criteria, Criteria.where((String)"blukryptName").is((Object)PCHelperConstant.getComponentName())});
        Query query = new Query((CriteriaDefinition)andCriteria);
        logger.debug("...remove all old eventhub..... ");
        mongoTemplate.findAllAndRemove(query, EventHub.class);
    }

    @Override
    public void deleteEventHub(int cloudId, ObjectId eventHubId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)eventHubId)});
        Query query = new Query((CriteriaDefinition)andCriteria);
        logger.debug("...remove eventhub..... " + eventHubId);
        mongoTemplate.findAllAndRemove(query, EventHub.class);
    }

    @Override
    public void updateEventHubTime(int cloudId, String eventHubId) {
        Criteria criteria = Criteria.where((String)"id").is((Object)eventHubId);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("lastUpdatedTime", (Object)System.currentTimeMillis());
        update.set("blukryptName", (Object)PCHelperConstant.getComponentName());
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        UpdateResult updateFirst = mongoTemplate.updateFirst(query, update, EventHub.class);
    }

    @Override
    public BackUpImage getBackupImageFolder(int cloudId, String parentpath, String child, String deviceDestCollection, String deviceUUID) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)child)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)FILE_NAME).is((Object)parentpath), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)"folder").is((Object)true)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)parentpath), Criteria.where((String)FILE_NAME).is((Object)child), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)"folder").is((Object)true)});
        }
        Query query1 = new Query((CriteriaDefinition)criteria);
        BackUpImage backupImage = (BackUpImage)mongoTemplate.findOne(query1, BackUpImage.class, deviceDestCollection);
        return backupImage;
    }

    @Override
    public void saveDeletedBackupImageForMail(int cloudId, BackUpImage deletedBkpImage, String deviceDestCollection) {
        Query query;
        Criteria criteria;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = new ArrayList();
        if (deletedBkpImage.isFolder()) {
            criteria = new Criteria();
            if (!StringUtils.isEmpty((String)deletedBkpImage.getDevicePath())) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deletedBkpImage.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)deletedBkpImage.getDevicePath()), Criteria.where((String)FILE_NAME).is((Object)deletedBkpImage.getFileName()), Criteria.where((String)"folder").is((Object)true), Criteria.where((String)PRESENT).is((Object)true)});
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deletedBkpImage.getDeviceUUID()), Criteria.where((String)FILE_NAME).is((Object)deletedBkpImage.getFileName()), Criteria.where((String)"folder").is((Object)true), Criteria.where((String)PRESENT).is((Object)true)});
            }
            logger.debug(deletedBkpImage.getDevicePath() + "..deletechildcritelist.." + deletedBkpImage.getFileName());
            query = new Query((CriteriaDefinition)criteria);
            list = mongoTemplate.find(query, BackUpImage.class, deviceDestCollection);
            logger.debug("..deletechildlist.." + list.size());
        } else {
            logger.debug("..deletechild.." + deletedBkpImage.getOdItemId());
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deletedBkpImage.getDeviceUUID()), Criteria.where((String)"odItemId").is((Object)deletedBkpImage.getOdItemId()), Criteria.where((String)PRESENT).is((Object)true)});
            query = new Query((CriteriaDefinition)criteria);
            list = mongoTemplate.find(query, BackUpImage.class, deviceDestCollection);
            logger.debug("..deletechildlist file.." + list.size());
        }
        if (!CollectionUtils.isEmpty(list)) {
            for (BackUpImage backUpImage : list) {
                logger.debug("...updating to false...." + backUpImage.getId().toString());
                backUpImage.setPresent(false);
                mongoTemplate.save((Object)backUpImage, deviceDestCollection);
            }
        }
        mongoTemplate.save((Object)deletedBkpImage, deviceDestCollection);
    }

    @Override
    public void deleteMailsForPath(int cloudId, String newPathVal, String deviceUUID, String deviceDestCollection) {
        this.deleteMailsForPathNew(cloudId, newPathVal, deviceUUID, deviceDestCollection);
    }

    public void deleteMailsForPathNew(int cloudId, String newPathVal, String deviceUUID, String deviceDestCollection) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        boolean filesExist = false;
        do {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)newPathVal), Criteria.where((String)PRESENT).is((Object)true)});
            Query query = new Query((CriteriaDefinition)criteria);
            query.limit(50);
            List list = mongoTemplate.find(query, BackUpImage.class, deviceDestCollection);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                logger.debug(newPathVal + "...still more mails to delete..." + list.size());
                for (BackUpImage backUpImage : list) {
                    if (backUpImage == null) continue;
                    BackUpImage deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImage);
                    this.saveDeletedBackupImageForMail(cloudId, deletedBkpImage, deviceDestCollection);
                    filesExist = true;
                }
            } else {
                filesExist = false;
                logger.debug(newPathVal + "...no more mails to delete...");
            }
        } while (filesExist);
    }

    private BackUpImage convertToBkpImage(String deviceUUID, BackUpImage backUpImageold) {
        BackUpImage backUpImageDeleted = new BackUpImage();
        BeanUtils.copyProperties((Object)backUpImageold, (Object)backUpImageDeleted);
        backUpImageDeleted.setId(null);
        long timeMilliSec = System.currentTimeMillis();
        backUpImageDeleted.setDevicePath(backUpImageold.getDevicePath());
        backUpImageDeleted.setFileName(backUpImageold.getFileName());
        backUpImageDeleted.setDeviceUUID(deviceUUID);
        backUpImageDeleted.setLastServerModifiedTime(timeMilliSec);
        backUpImageDeleted.setFolder(backUpImageold.isFolder());
        backUpImageDeleted.setMd5Checksum(backUpImageold.getMd5Checksum());
        backUpImageDeleted.setPresent(false);
        backUpImageDeleted.setfSPath(backUpImageold.getfSPath());
        backUpImageDeleted.setUserName(backUpImageold.getUserName());
        backUpImageDeleted.setStatus(PCHelperConstant.REVISION_STATUS.DELETED.toString());
        backUpImageDeleted.setLastClientModifiedTime(backUpImageold.getLastClientModifiedTime());
        backUpImageDeleted.setBaseBackup(false);
        backUpImageDeleted.setSize(backUpImageold.getSize());
        backUpImageDeleted.setOdItemId(backUpImageold.getOdItemId());
        backUpImageDeleted.setGatewayName(backUpImageold.getGatewayName());
        backUpImageDeleted.setSubject(backUpImageold.getSubject());
        backUpImageDeleted.setFrom(backUpImageold.getFrom());
        backUpImageDeleted.setBodyContent(backUpImageold.getBodyContent());
        backUpImageDeleted.setBccRecipients(backUpImageold.getBccRecipients());
        backUpImageDeleted.setCcRecipients(backUpImageold.getCcRecipients());
        backUpImageDeleted.setToRecipients(backUpImageold.getToRecipients());
        backUpImageDeleted.setHasAttachments(backUpImageold.isHasAttachments());
        backUpImageDeleted.setTaskSubject(backUpImageold.getTaskSubject());
        backUpImageDeleted.setTaskStartDate(backUpImageold.getTaskStartDate());
        backUpImageDeleted.setTaskReminderTime(backUpImageold.getTaskReminderTime());
        backUpImageDeleted.setTaskDueDate(backUpImageold.getTaskDueDate());
        backUpImageDeleted.setContactMobile(backUpImageold.getContactMobile());
        backUpImageDeleted.setContactAddrStreet(backUpImageold.getContactAddrStreet());
        backUpImageDeleted.setContactAddrCity(backUpImageold.getContactAddrCity());
        backUpImageDeleted.setContactAddrState(backUpImageold.getContactAddrState());
        backUpImageDeleted.setContactAddrCountry(backUpImageold.getContactAddrCountry());
        backUpImageDeleted.setContactAddrPostalCode(backUpImageold.getContactAddrPostalCode());
        backUpImageDeleted.setChunkFiles(backUpImageold.getChunkFiles());
        boolean isMail = false;
        if (backUpImageold.isMail()) {
            isMail = true;
            backUpImageDeleted.setEwsId(backUpImageold.getEwsId());
        }
        backUpImageDeleted.setMail(isMail);
        return backUpImageDeleted;
    }

    @Override
    public void updatePrevBatch(String deviceUUID, String batchId) {
        Criteria criteria2 = Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID);
        Query query = new Query((CriteriaDefinition)criteria2);
        Update updateObj = new Update();
        updateObj.set("backupBatchId", (Object)batchId);
        UpdateResult updateMulti = this.msgMongoTemplate.updateMulti(query, updateObj, DriveFileInfo.class);
        logger.debug("...update records for device...." + updateMulti.getModifiedCount());
    }

    @Override
    public BackUpImage getDeletedBkpImageforPathandFile(int cloudId, String deviceUUID, String devicePath, String fileName, String deviceDestCollection) {
        BackUpImage backUpImageDeleted = null;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)"status").is((Object)"DELETED")});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_SERVER_MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, BackUpImage.class, deviceDestCollection);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            backUpImageDeleted = (BackUpImage)list.get(0);
        }
        return backUpImageDeleted;
    }

    @Override
    public void deleteBatchFromOdServer(String deviceUUID, long batchStartTime, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)"batchStartTimestamp").is((Object)batchStartTime)});
        Query query = new Query((CriteriaDefinition)criteria);
        this.msgMongoTemplate.findAndRemove(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
    }

    public List<BackUpImage> getBackupFolderForBasePath(int cloudId, String deviceUUID, String devicePath, String destCollection) {
        ArrayList<BackUpImage> backupImageList = new ArrayList();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)"folder").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        backupImageList = mongoTemplate.find(query, BackUpImage.class, destCollection);
        return backupImageList;
    }

    public void getAllFolderChildrenByDevicePath(int cloudId, String deviceUUID, String filePath, String deviceDestCollection, List<BackUpImage> backupImages) {
        List<BackUpImage> backUpImagesTemp = this.getBackupFolderForBasePath(cloudId, deviceUUID, filePath, deviceDestCollection);
        backupImages.addAll(backUpImagesTemp);
        logger.debug("...folders for path ....." + filePath + "..." + backupImages.size());
        if (!CollectionUtils.isEmpty(backUpImagesTemp)) {
            Stream stream = backUpImagesTemp.parallelStream();
            stream.forEach(backUpImage -> {
                String devicePath = backUpImage.getDevicePath() + "/" + backUpImage.getFileName();
                logger.debug("Inside loop after getting folders..bkpimages list size:" + backUpImagesTemp.size());
                if (StringUtils.isEmpty((String)backUpImage.getDevicePath())) {
                    devicePath = backUpImage.getFileName();
                }
                logger.debug("Inside loop to get immediate folders deevicePath:" + devicePath);
                this.getAllFolderChildrenByDevicePath(cloudId, deviceUUID, devicePath, deviceDestCollection, backupImages);
            });
        }
    }

    @Override
    public void deleteAllFilesUnderFolder(int cloudId, String newPathVal, String deviceUUID, String deviceDestCollection) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        ArrayList<BackUpImage> backupImages = new ArrayList<BackUpImage>();
        this.getAllFolderChildrenByDevicePath(cloudId, deviceUUID, newPathVal, deviceDestCollection, backupImages);
        List<BackUpImage> list = this.getRestBackupFilesForGivenPathfromBackupImage(cloudId, newPathVal, deviceUUID, deviceDestCollection);
        int i = 0;
        logger.debug("....before adding parent file list..");
        ArrayList<BackUpImage> delList = new ArrayList<BackUpImage>();
        for (BackUpImage image : list) {
            ++i;
            BackUpImage deletedBkpImage = this.convertToBkpImage(image.getDeviceUUID(), image);
            delList.add(deletedBkpImage);
        }
        if (!CollectionUtils.isEmpty(delList)) {
            BulkOperations localbulkOps = mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, BackUpImage.class, deviceDestCollection);
            localbulkOps.insert(delList);
            localbulkOps.execute();
        }
        for (BackUpImage image : backupImages) {
            logger.debug("....folders to parse...." + image.getDevicePath() + "/" + image.getFileName());
        }
        for (BackUpImage folderimage : backupImages) {
            String newPath = folderimage.getDevicePath() + "/" + folderimage.getFileName();
            list = this.getRestBackupFilesForGivenPathfromBackupImage(cloudId, newPath, deviceUUID, deviceDestCollection);
            i = 0;
            delList = new ArrayList();
            logger.debug("....before adding sub folder parent file list.." + newPath);
            for (BackUpImage image : list) {
                ++i;
                BackUpImage deletedBkpImage = this.convertToBkpImage(image.getDeviceUUID(), image);
                delList.add(deletedBkpImage);
            }
            if (CollectionUtils.isEmpty(delList)) continue;
            BulkOperations localbulkOps = mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, BackUpImage.class, deviceDestCollection);
            localbulkOps.insert(delList);
            localbulkOps.execute();
        }
    }

    @Override
    public BackUpImage getBackupImageFolderForItemIdForModified(int cloudId, String itemId, String deviceDestCollection) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"odItemId").is((Object)itemId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, BackUpImage.class, deviceDestCollection);
        logger.debug("..... for item id vla ..... " + itemId + "... " + deviceDestCollection);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            logger.debug("..... for list size ..... " + list.size());
        } else {
            logger.debug("... no files.... " + itemId);
        }
        BackUpImage backUpImage = null;
        if (!CollectionUtils.isEmpty((Collection)list)) {
            if (list.size() > 1) {
                logger.debug(".... folder filter..... ");
                List bkpImageList = list.stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).collect(Collectors.toList());
                backUpImage = (BackUpImage)bkpImageList.get(0);
                logger.debug(".... folder filter. after .... " + backUpImage.getDevicePath() + "/" + backUpImage.getFileName());
            } else {
                backUpImage = (BackUpImage)list.get(0);
                logger.debug("..... item to be deleted .... " + backUpImage.getOdItemId() + "...." + backUpImage.getId());
            }
        }
        return backUpImage;
    }

    public List<BackUpImage> getRestBackupFilesForGivenPathfromBackupImage(int cloudId, String folderPath, String deviceUUID, String dest) {
        List<Object> list = new ArrayList();
        ArrayList<BackUpImage> bkpImages = new ArrayList<BackUpImage>();
        try {
            logger.debug("RESTORE-QUERY ..getBackupFilesForGivenPathfromBackupImage..........");
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)folderPath)});
            Query query = new Query((CriteriaDefinition)criteria);
            query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_SERVER_MODIFIED_TIME}));
            List results = mongoTemplate.find(query, BackUpImage.class, dest);
            if (!CollectionUtils.isEmpty((Collection)results)) {
                list.addAll(results);
            }
            bkpImages.addAll(list);
            logger.debug("....count of list..." + list.size());
            list = this.getFilteredLatestVersionBackupImageList(bkpImages, false);
            logger.debug("....count of list after ..." + list.size());
            logger.error("##End getBackupFilesForGivenPathfromBackupImage ..........");
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(" Exception while getting filefrom backupimage:" + e.getMessage());
            return null;
        }
        return list;
    }

    private List<BackUpImage> getFilteredLatestVersionBackupImageList(List<BackUpImage> backUpImages, boolean restoreDeletedFiles) {
        logger.debug("Inside grouping backup images....");
        ArrayList filteredBackUpImages = new ArrayList();
        ArrayList<BackUpImage> filteredBackUpImagesList = new ArrayList<BackUpImage>();
        ArrayList deltedBackUpImages = new ArrayList();
        ArrayList<BackUpImage> deletedBackUpImagesList = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        for (BackUpImage filteredBackUpImage : filteredBackUpImages) {
            if (filteredBackUpImage.isPresent()) {
                filteredBackUpImagesList.add(filteredBackUpImage);
                continue;
            }
            deletedBackUpImagesList.add(filteredBackUpImage);
        }
        if (restoreDeletedFiles) {
            for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
                entry.getValue().entrySet().stream().forEach(p -> deltedBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).filter(p1 -> p1.isPresent()).findFirst().get()));
            }
            for (BackUpImage bkpimage : deletedBackUpImagesList) {
                for (BackUpImage bkpimage1 : deltedBackUpImages) {
                    if (!bkpimage.getFileName().equals(bkpimage1.getFileName()) || !bkpimage.getDevicePath().equals(bkpimage1.getDevicePath())) continue;
                    bkpimage1.setPresent(false);
                    filteredBackUpImagesList.add(bkpimage1);
                }
            }
        }
        return filteredBackUpImagesList;
    }

    @Override
    public void deletedeltPathForUser(String path, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"path").is((Object)path), Criteria.where((String)"userName").is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        this.msgMongoTemplate.remove(query, DeltaPath.class);
        logger.debug("...deletedeltapath .." + userName + ".." + path);
    }
}

