/*
 * Decompiled with CFR 0.152.
 */
package com.pg.office365restore;

import java.util.function.Supplier;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RetryCommand<T> {
    private static Logger logger = LogManager.getLogger(RetryCommand.class);
    private int retryCounter;
    private final int maxRetries;

    public RetryCommand(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public T run(Supplier<T> function) {
        try {
            return function.get();
        }
        catch (Exception e) {
            try {
                return this.retry(function);
            }
            catch (Exception e1) {
                logger.error("...Exception :" + e1.getMessage());
                return null;
            }
        }
    }

    public int getRetryCounter() {
        return this.retryCounter;
    }

    private T retry(Supplier<T> function) throws Exception {
        System.out.println("FAILED - Command failed, will be retried " + this.maxRetries + " times.");
        this.retryCounter = 0;
        while (this.retryCounter < this.maxRetries) {
            try {
                return function.get();
            }
            catch (Exception ex) {
                ++this.retryCounter;
                System.out.println("FAILED - Command failed on retry " + this.retryCounter + " of " + this.maxRetries + " error: " + ex);
                if (this.retryCounter < this.maxRetries) continue;
                System.out.println("Max retries exceeded.");
                break;
            }
        }
        throw new Exception("Command failed on all of " + this.maxRetries + " retries");
    }

    public Supplier<CloseableHttpResponse> run1(Supplier<CloseableHttpResponse> function) {
        return null;
    }
}

