/*
 * Decompiled with CFR 0.152.
 */
package com.pg.controller;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.ProxyOptions;
import com.azure.core.util.HttpClientOptions;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.google.api.client.repackaged.org.apache.commons.codec.binary.Base64;
import com.microsoft.aad.adal4j.AuthenticationCallback;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.httpcore.HttpClients;
import com.microsoft.graph.models.Attachment;
import com.microsoft.graph.models.BodyType;
import com.microsoft.graph.models.Contact;
import com.microsoft.graph.models.ConvertIdResult;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.ExchangeIdFormat;
import com.microsoft.graph.models.InferenceClassificationType;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.Message;
import com.microsoft.graph.models.ProfilePhoto;
import com.microsoft.graph.models.Recipient;
import com.microsoft.graph.models.User;
import com.microsoft.graph.models.UserTranslateExchangeIdsParameterSet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.AttachmentCollectionPage;
import com.microsoft.graph.requests.AttachmentCollectionRequest;
import com.microsoft.graph.requests.DriveItemContentStreamRequestBuilder;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.microsoft.graph.requests.UserTranslateExchangeIdsCollectionPage;
import com.microsoft.graph.requests.UserTranslateExchangeIdsCollectionRequest;
import com.parablu.cloudbackup.CloudBackupStorageBridge;
import com.parablu.cloudbackup.OfficeRestoreService;
import com.parablu.cloudbackup.StorageService;
import com.parablu.cloudbackup.UploadStatus;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.EWSAppSetting;
import com.parablu.pcbd.domain.FailedFileReason;
import com.parablu.pcbd.domain.InclusionFilter;
import com.parablu.pcbd.domain.MailAttachment;
import com.parablu.pcbd.domain.MailBackupBatch;
import com.parablu.pcbd.domain.O365BlackListUser;
import com.parablu.pcbd.domain.ODBBackupBatch;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.OutlookEmailAddress;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.SearchIndex;
import com.pg.controller.BaseController;
import com.pg.controller.Graph;
import com.pg.domain.DriveFileInfo;
import com.pg.domain.FileInfo;
import com.pg.element.BackupElement;
import com.pg.element.BluKryptElement;
import com.pg.element.ChunkFileElement;
import com.pg.element.FileUploadDetailsElement;
import com.pg.element.MailAttachmentElement;
import com.pg.element.OutlookEmailAddressElement;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MD5Generator;
import com.pg.helper.utils.MemoryStore;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.service.BackupService;
import com.pg.service.ChunkableUploadService;
import com.pg.service.ComponentSettingService;
import com.pg.service.DownloadService;
import com.pg.service.JobConfigService;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import com.pg.sync.service.SyncDownloadService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ConnectingIdType;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.BasePropertySet;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.service.item.EmailMessage;
import microsoft.exchange.webservices.data.core.service.schema.ItemSchema;
import microsoft.exchange.webservices.data.misc.ImpersonatedUserId;
import microsoft.exchange.webservices.data.property.complex.AttachmentCollection;
import microsoft.exchange.webservices.data.property.complex.EmailAddress;
import microsoft.exchange.webservices.data.property.complex.ItemId;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinitionBase;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.BsonMaximumSizeExceededException;
import org.bson.types.ObjectId;
import org.json.JSONException;
import org.json.JSONObject;
import org.jvnet.hk2.annotations.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
@Service
public class CloudBackupController
extends BaseController
implements DisposableBean,
ApplicationContextAware,
Runnable,
CloudBackupStorageBridge {
    private static final Logger logger = LogManager.getLogger(CloudBackupController.class);
    private static final String AUTHORITY = "https://login.microsoftonline.com/";
    private static final String EWS_URL = "https://outlook.office365.com/EWS/Exchange.asmx";
    private static final String RESOURCE = "https://outlook.office365.com";
    @Autowired
    private UploadService uploadService;
    @Autowired
    private ChunkableUploadService chunkableUploadService;
    @Autowired
    private BackupService backupService;
    @Autowired
    private ComponentSettingService componentSettingService;
    @Autowired
    private JobConfigService jobConfigService;
    public static final String FILE_NOT_EXISTS = "File Not exists";
    @Autowired
    private SyncDownloadService syncDownloadService;
    @Autowired
    private DownloadService downloadService;
    @Autowired
    private UtilService utilService;
    static Thread thisThread;
    private static final Semaphore sem;
    private static final long DAY_IN_MS = 86400000L;
    private static ApplicationContext applicationContext;
    private static final String USER_STORAGE_LIMIT_REACHED = " User Storage limit reached ..... ";
    private static final String DIRECT_CALL_STORAGE_LIMIT = " direct call .... storage limit .......";
    private static final String UPLOAD_COUNT = "uploadCount";
    private static final String JOB_ID = "JobId";
    private static final String CHUNK = "chunk";
    private static final String ALREADY_EXISTS = "ALREADY_EXISTS";
    private static final String LARGE_MONGO_ENTRY = "LARGE_MONGO_ENTRY";
    private static final String BATCH_ID_LOG = "##batch id >>>>";

    public void setComponentSettingService(ComponentSettingService componentSettingService) {
        this.componentSettingService = componentSettingService;
    }

    public void setJobConfigService(JobConfigService jobConfigService) {
        this.jobConfigService = jobConfigService;
    }

    public void setSyncDownloadService(SyncDownloadService syncDownloadService) {
        this.syncDownloadService = syncDownloadService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        logger.debug("---- Application context is set! ---- ");
        CloudBackupController.applicationContext = applicationContext;
        sem.release();
    }

    public static ApplicationContext getContext() {
        return applicationContext;
    }

    public void setUploadService(UploadService uploadService) {
        this.uploadService = uploadService;
    }

    public void setChunkableUploadService(ChunkableUploadService chunkableUploadService) {
        this.chunkableUploadService = chunkableUploadService;
    }

    public void setBackupService(BackupService backupService) {
        this.backupService = backupService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    CloudBackupController() {
        logger.debug("----------------~~~~~~ CloudBackupBridge ~~~~~~----------------");
        this.runOnce();
    }

    void runOnce() {
        logger.info("Triggered run Once");
        if (thisThread == null) {
            logger.info("Launching thread!");
            thisThread = new Thread(this);
            logger.info("@@@@@@@@@@@@@ ----- @@@@@@@@@@@");
            thisThread.start();
        }
    }

    public void destroy() {
        try {
            StorageService.GETINST.shutdown();
            OfficeRestoreService.GETINST.shutdown();
            try {
                logger.debug("going to sleep no work found");
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error("Sleep interrupted", (Throwable)e);
            }
            thisThread.join();
        }
        catch (InterruptedException e) {
            logger.error("Exception while destroying", (Throwable)e);
        }
        logger.info("----------------~~~~~~ CloudBackupBridge ~~~~~~----------------");
    }

    private static ChunkFileElement createChunkFileElement(String deviceUUID, BluKryptElement bluKryptElement, String chunkFilechecksum, String chunkFileName, String checkSum, List<String> list) {
        ChunkFileElement chunkFileElement = new ChunkFileElement();
        if (CollectionUtils.isEmpty(list)) {
            logger.info("List is empty sooo adding md5checksum" + checkSum);
            list.add(checkSum);
        }
        chunkFileElement.setFileChunks(list);
        chunkFileElement.setFileCompletePath(bluKryptElement.getFileCompletePath());
        logger.info("createChunkFileElemet " + bluKryptElement.getFileCompletePath());
        chunkFileElement.setFileName(checkSum);
        chunkFileElement.setMd5checksum(checkSum);
        chunkFileElement.setDeviceUUID(bluKryptElement.getDeviceUUID());
        if (!StringUtils.isEmpty((Object)chunkFilechecksum)) {
            chunkFileElement.setMd5checksum(chunkFilechecksum);
            chunkFileElement.setFileChunks(list);
            logger.info("Create chunk file element " + chunkFileName);
            chunkFileElement.setFileCompletePath(chunkFileName);
            chunkFileElement.setFileName(chunkFileName);
            chunkFileElement.setDeviceUUID(deviceUUID);
        }
        return chunkFileElement;
    }

    private static boolean checkMachineStorage(String fileSizeInString) {
        File file = new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint());
        long incomingFileSize = Long.parseLong(fileSizeInString);
        long availableSpaceInServer = file.getFreeSpace();
        logger.info("Total space for this machine.." + file.getTotalSpace() + "FREE_SIZE" + file.getFreeSpace() + "incoming File Size:" + incomingFileSize);
        if (availableSpaceInServer - incomingFileSize <= 0L) {
            logger.info("Space in server is exceeded........");
            return true;
        }
        return false;
    }

    public static double getSizeinMb(long size) {
        double m = (double)size / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        return Double.parseDouble(dec.format(m));
    }

    private double getFileSizeInMb(Map<String, String> headerMap) {
        long fileSizeInBytes = Long.parseLong(headerMap.get("file-size"));
        long filesizeInKB = (long)Math.ceil((double)fileSizeInBytes / 1024.0);
        return CloudBackupController.getSizeinMb(filesizeInKB);
    }

    protected FileUploadDetailsElement insertEntryForBackupFromBK(Map<String, Object> request, String cloudName, String userName, String maxVersionsToKeep, Device device, boolean isMail) {
        FileUploadDetailsElement fileUploadDetailsElement;
        block41: {
            fileUploadDetailsElement = new FileUploadDetailsElement();
            try {
                String deviceUUID;
                OutlookEmailAddressElement outlookEmailAddress;
                OutlookEmailAddress add;
                Iterator iterator;
                ArrayList<OutlookEmailAddressElement> llist;
                Object addresses;
                BackupElement fileElement = new BackupElement();
                fileElement.setFileName((String)request.get("file-name"));
                fileElement.setFileCompletePath((String)request.get("file-path"));
                fileElement.setPresent(Boolean.valueOf((String)request.get("is-exists")).booleanValue());
                fileElement.setFolder(Boolean.valueOf((String)request.get("is-folder")).booleanValue());
                fileElement.setMd5Checksum((String)request.get("fileMD5"));
                if (request.get("taskStartDate") != null) {
                    fileElement.setTaskStartDate((Date)request.get("taskStartDate"));
                }
                if (request.get("taskDueDate") != null) {
                    fileElement.setTaskDueDate((Date)request.get("taskDueDate"));
                }
                if (request.get("taskReminderTime") != null) {
                    fileElement.setTaskReminderTime((Date)request.get("taskReminderTime"));
                }
                if (request.get("taskSubject") != null) {
                    fileElement.setTaskSubject((String)request.get("taskSubject"));
                }
                if (request.get("file-size") != null) {
                    if (!StringUtils.isEmpty((Object)((String)request.get("file-size")))) {
                        fileElement.setSize(Long.valueOf((String)request.get("file-size")).longValue());
                    } else {
                        fileElement.setSize(0L);
                    }
                } else {
                    fileElement.setSize(0L);
                }
                if (!isMail) {
                    String fileModifiedTimestamp = (String)request.get("modified");
                    fileElement.setLastClientModifiedTime(Long.valueOf(fileModifiedTimestamp).longValue());
                } else {
                    fileElement.setLastClientModifiedTime(System.currentTimeMillis());
                }
                fileElement.setBaseBackup(Boolean.valueOf((String)request.get("is-base-folder")).booleanValue());
                fileElement.setGatewayName((String)request.get("gatewayName"));
                String version = (String)request.get("maxVersions");
                logger.debug(request.get("parentItemID") + ".... item id iss.... " + request.get("odItemId") + "..ewsid..." + request.get("ewsId"));
                fileElement.setOdItemId((String)request.get("odItemId"));
                if (!StringUtils.isEmpty((Object)request.get("ewsId"))) {
                    fileElement.setEwsId((String)request.get("ewsId"));
                }
                fileElement.setParentItemId((String)request.get("parentItemID"));
                fileElement.setSubject((String)request.get("subject"));
                fileElement.setFrom((String)request.get("from"));
                fileElement.setBodyContent((String)request.get("bodyContent"));
                if (request.get("receivedDateTime") != null) {
                    fileElement.setReceivedDateTime(((Long)request.get("receivedDateTime")).longValue());
                }
                if (request.get("sentDateTime") != null) {
                    fileElement.setSentDateTime(((Long)request.get("sentDateTime")).longValue());
                }
                fileElement.setDisplayContent((String)request.get("displayContent"));
                fileElement.setCcRecipients((String)request.get("ccRecipients"));
                fileElement.setBccRecipients((String)request.get("bccRecipients"));
                fileElement.setToRecipients((String)request.get("toRecipients"));
                if (request.get("hasAttachments") != null) {
                    fileElement.setHasAttachments(((Boolean)request.get("hasAttachments")).booleanValue());
                }
                if (fileElement.isHasAttachments()) {
                    ArrayList<MailAttachmentElement> list = new ArrayList<MailAttachmentElement>();
                    List attachments = (List)request.get("attachments");
                    if (!CollectionUtils.isEmpty((Collection)attachments)) {
                        for (MailAttachment attachment : attachments) {
                            MailAttachmentElement elemen = new MailAttachmentElement();
                            BeanUtils.copyProperties((Object)attachment, (Object)elemen);
                            logger.debug("..pcibusattach..." + elemen.getName());
                            list.add(elemen);
                        }
                    }
                    fileElement.setAttachments(list);
                }
                if (request.get("fromEmailAddress") != null) {
                    addresses = (OutlookEmailAddress)request.get("fromEmailAddress");
                    OutlookEmailAddressElement emailAddress = new OutlookEmailAddressElement();
                    BeanUtils.copyProperties((Object)addresses, (Object)emailAddress);
                    fileElement.setFromEmailAddress(emailAddress);
                }
                if (request.get("toRecipientsAddress") != null) {
                    addresses = (List)request.get("toRecipientsAddress");
                    llist = new ArrayList<OutlookEmailAddressElement>();
                    logger.debug("...ttooo addrr..." + addresses);
                    if (!CollectionUtils.isEmpty((Collection)addresses)) {
                        iterator = addresses.iterator();
                        while (iterator.hasNext()) {
                            add = (OutlookEmailAddress)iterator.next();
                            outlookEmailAddress = new OutlookEmailAddressElement();
                            BeanUtils.copyProperties((Object)add, (Object)outlookEmailAddress);
                            logger.debug("..toadddddd...." + add.getAddress());
                            llist.add(outlookEmailAddress);
                        }
                    }
                    fileElement.setToRecipientsAddress(llist);
                }
                if (request.get("ccRecipientsAddress") != null) {
                    addresses = (List)request.get("ccRecipientsAddress");
                    logger.debug("...cc addrr..." + addresses);
                    llist = new ArrayList();
                    if (!CollectionUtils.isEmpty((Collection)addresses)) {
                        iterator = addresses.iterator();
                        while (iterator.hasNext()) {
                            add = (OutlookEmailAddress)iterator.next();
                            outlookEmailAddress = new OutlookEmailAddressElement();
                            BeanUtils.copyProperties((Object)add, (Object)outlookEmailAddress);
                            llist.add(outlookEmailAddress);
                        }
                    }
                    fileElement.setCcRecipientsAddress(llist);
                }
                if (request.get("bccRecipientsAddress") != null) {
                    addresses = (List)request.get("bccRecipientsAddress");
                    logger.debug("...bccRecipientsAddress addrr..." + addresses);
                    llist = new ArrayList();
                    if (!CollectionUtils.isEmpty((Collection)addresses)) {
                        iterator = addresses.iterator();
                        while (iterator.hasNext()) {
                            add = (OutlookEmailAddress)iterator.next();
                            outlookEmailAddress = new OutlookEmailAddressElement();
                            BeanUtils.copyProperties((Object)add, (Object)outlookEmailAddress);
                            llist.add(outlookEmailAddress);
                        }
                    }
                    fileElement.setBccRecipientsAddress(llist);
                }
                fileElement.setSentDate((String)request.get("sentDate"));
                logger.debug("..fileElement.setSentDate.." + request.get("sentDate"));
                String userUnderLegalHold = (String)request.get("userUnderLegalHold");
                boolean isFullBackup = false;
                String fullBackup = (String)request.get("isFullBackup");
                if (!StringUtils.isEmpty((Object)fullBackup)) {
                    isFullBackup = Boolean.parseBoolean(fullBackup);
                }
                if ((deviceUUID = (String)request.get("deviceUUID")) != null) {
                    CloudBackupController.printLogs("Device UUID is not null", PCHelperConstant.isBrevityLogging());
                }
                int uploadCount = 0;
                if (MemoryStore.get((String)UPLOAD_COUNT) != null) {
                    uploadCount = (Integer)MemoryStore.get((String)UPLOAD_COUNT);
                    logger.info(" From MEMSTORE ........... " + uploadCount);
                }
                if (request.get("contactMobile") != null) {
                    fileElement.setContactMobile((String)request.get("contactMobile"));
                }
                if (request.get("contactAddrStreet") != null) {
                    fileElement.setContactAddrStreet((String)request.get("contactAddrStreet"));
                }
                if (request.get("contactAddrCity") != null) {
                    fileElement.setContactAddrCity((String)request.get("contactAddrCity"));
                }
                if (request.get("contactAddrState") != null) {
                    fileElement.setContactAddrState((String)request.get("contactAddrState"));
                }
                if (request.get("contactAddrCountry") != null) {
                    fileElement.setContactAddrCountry((String)request.get("contactAddrCountry"));
                }
                if (request.get("contactAddrPostalCode") != null) {
                    fileElement.setContactAddrPostalCode((String)request.get("contactAddrPostalCode"));
                }
                logger.info(request.get("o365LastModifiedTime") + " Before calling uploadExternalFileToBackUp ..........." + fileElement.getSubject() + "..." + fileElement.getTaskDueDate());
                logger.debug(".....$$$o365time$$$....." + fileElement.getFileName() + "...." + fileElement.getO365LastModifiedTime());
                fileUploadDetailsElement = this.backupService.uploadExternalFileToBackUp(1, cloudName, fileElement, device, userUnderLegalHold, isFullBackup);
                if (ALREADY_EXISTS.equalsIgnoreCase(fileUploadDetailsElement.getBkpId())) {
                    logger.debug("...already exists.....");
                } else {
                    logger.info(" After calling uploadExternalFileToBackUp ..........." + fileUploadDetailsElement.getBkpId() + "...." + fileUploadDetailsElement.getFileSize());
                    MemoryStore.delete((String)UPLOAD_COUNT);
                    MemoryStore.add((String)UPLOAD_COUNT, (Object)(++uploadCount));
                }
            }
            catch (BsonMaximumSizeExceededException ee) {
                logger.error("..large size file.... ");
                fileUploadDetailsElement.setBkpId(LARGE_MONGO_ENTRY);
            }
            catch (Exception e) {
                logger.error("..Exception When Inserting Entry For Backup From BK :....", (Throwable)e);
                if (!(e instanceof BsonMaximumSizeExceededException)) break block41;
                logger.error("..large size file.... ");
                fileUploadDetailsElement.setBkpId(LARGE_MONGO_ENTRY);
            }
        }
        return fileUploadDetailsElement;
    }

    private File createFileInBackupPath(Map<String, Object> headerMap, String cloudName, String fileName, boolean isMail) throws IOException {
        logger.info("Entering createFileInBackupPath ");
        String backupBatchId = (String)headerMap.get("backupBatchId");
        if (StringUtils.isEmpty((Object)backupBatchId)) {
            backupBatchId = "FIXME-INBA";
        }
        String deviceUUID = (String)headerMap.get("deviceUUID");
        String deviceTempPath = PCHelperConstant.getMntTempChunkPath() + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupBatchId;
        File uploadBackupPath = new File(deviceTempPath);
        uploadBackupPath.mkdirs();
        if (isMail) {
            String itemId = (String)headerMap.get("odItemId");
            logger.debug("...changem md5 for filenamemail..." + itemId);
            String md5 = MD5Generator.generateMD5OfString((String)itemId);
            fileName = md5 + ".tmp";
        }
        String filePath = uploadBackupPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName;
        logger.info("File path: " + filePath);
        File tempFilePath = new File(filePath);
        if (tempFilePath.exists()) {
            logger.info("Temp file exists so deleting the file####");
            tempFilePath.delete();
        }
        try {
            tempFilePath.createNewFile();
        }
        catch (IOException e) {
            logger.error("....unable to create filepppp...");
            logger.error(tempFilePath + "....unable to create filepppp..." + e.getMessage());
            String md5 = MD5Generator.generateMD5OfString((String)fileName);
            fileName = md5 + ".tmp";
            filePath = uploadBackupPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName;
            logger.info("File path: " + filePath);
            tempFilePath = new File(filePath);
            if (tempFilePath.exists()) {
                logger.info("Temp file exists so deleting the file####");
                tempFilePath.delete();
            }
            try {
                tempFilePath.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        logger.info("Leaving createFileInBackupPath");
        return tempFilePath;
    }

    private void checkNThrottleAndUploadFileV2(String cloudName, String gatewayName, InputStream inputStream, long fileSize, ChunkFileElement chunkFileElement, String sourceFilePath, String osType, String indexPath, String batchId) throws InterruptedException {
        this.chunkableUploadService.uploadChunkableFileToBackUp(cloudName, inputStream, chunkFileElement, osType, false, indexPath, batchId);
    }

    private List<String> getBackupIdAppendedToChunks(List<String> newChunkList, String newBackupId) {
        ArrayList<String> resChunkList = new ArrayList<String>();
        for (String chunkName : newChunkList) {
            resChunkList.add(chunkName + "." + newBackupId);
        }
        Collections.sort(resChunkList);
        return resChunkList;
    }

    protected FileInfo getFileInfo(BluKryptElement bluKryptElement, String backupId, String prevBackupId, List<String> list) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setChunkFiles(new ArrayList());
        fileInfo.setFileName(bluKryptElement.getFileName());
        fileInfo.setId(backupId);
        fileInfo.setFilePath(bluKryptElement.getFilePath());
        fileInfo.setDeviceUUID(bluKryptElement.getDeviceUUID());
        fileInfo.setOsType(bluKryptElement.getOsType());
        fileInfo.setPrevBackupId(prevBackupId);
        fileInfo.setUserName(bluKryptElement.getUserName());
        fileInfo.getChunkFiles().addAll(list);
        return fileInfo;
    }

    private String getUploadFilePath(String deviceUUID, String cloudName, String batchId) {
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID;
        if (!StringUtils.isEmpty((Object)batchId)) {
            deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId;
        }
        return deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
    }

    private List<String> moveFilesFromTmpPath(String deviceUUID, List<String> orgChunks, String chunkPath, String batchId) throws Exception {
        ArrayList<String> chunkNames = new ArrayList<String>();
        for (String chunkName : orgChunks) {
            String path = PCHelperConstant.getMntTempChunkPath() + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId;
            String srcfilePath = path + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkName;
            File fileObj = new File(srcfilePath);
            if (fileObj.exists()) {
                File chunkDir = new File(chunkPath);
                if (!chunkDir.exists()) {
                    chunkDir.mkdirs();
                }
                String destPath = chunkPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkName;
                String newChunkName = chunkName;
                int dedupCount = 1;
                while (new File(destPath).exists()) {
                    logger.debug("file is exist in destination path>>>>>>: " + destPath);
                    destPath = chunkPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkName + "_" + dedupCount;
                    newChunkName = chunkName + "_" + dedupCount;
                    ++dedupCount;
                }
                chunkNames.add(newChunkName);
                logger.debug("newChunkName check exists :" + newChunkName);
                File destFile = new File(destPath);
                if (fileObj.exists()) {
                    Files.move(fileObj.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                logger.debug("destFile :" + destFile.getAbsolutePath());
                continue;
            }
            logger.debug("....file not exixts......" + srcfilePath);
            throw new Exception(FILE_NOT_EXISTS);
        }
        return chunkNames;
    }

    private void closeInputStreamAndDelTempFile(File tempFilePath, InputStream inputStream) {
        if (inputStream != null) {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        if (tempFilePath != null && tempFilePath.exists()) {
            tempFilePath.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int upload(Map<String, Object> headerMap, InputStream dataStream, int uploadCount, List<String> chunkMd5s, Cloud cloud) {
        String backupId = "";
        String cloudName = "";
        String batchId = "";
        CloudBackupController.printLogs("Entering upload!", PCHelperConstant.isBrevityLogging());
        InputStream inputStream = dataStream;
        try {
            String deviceUUID = (String)headerMap.get("deviceUUID");
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(headerMap);
            String driveFileInfoId = (String)headerMap.get("driveFileInfoId");
            if (cloud != null) {
                bluKryptElement.setVersionsToKeep(Integer.toString(cloud.getVersioningEnabled()));
            }
            String fileSizeInString = (String)headerMap.get("file-size");
            String chunkFilechecksum = (String)headerMap.get("chunkFileMD5");
            String chunkFileName = (String)headerMap.get("chunkFileName");
            batchId = (String)headerMap.get("backupBatchId");
            String isChunkOfAFile = "false";
            String checkSum = (String)headerMap.get("fileMD5");
            String prevBackupId = (String)headerMap.get("prevBackupId");
            String isCompressed = "false";
            String isNormalFile = "true";
            long fileSize = Long.parseLong(fileSizeInString);
            logger.debug(BATCH_ID_LOG + batchId);
            ArrayList<String> list = new ArrayList<String>();
            boolean isMachineStorageReached = CloudBackupController.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                int n = 507;
                return n;
            }
            cloudName = bluKryptElement.getCloudName();
            Device device = this.utilService.getDeviceForUUID(cloud.getCloudId(), deviceUUID);
            logger.debug("!!!Obtained the device " + device.getDeviceUUID());
            boolean isOneDrive = false;
            if (!StringUtils.isEmpty((Object)device.getDeviceType()) && device.getDeviceType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.name())) {
                isOneDrive = true;
            }
            boolean isOutlook = false;
            if (!StringUtils.isEmpty((Object)device.getDeviceType()) && device.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
                isOutlook = true;
            }
            ChunkFileElement chunkFileElement = CloudBackupController.createChunkFileElement(deviceUUID, bluKryptElement, chunkFilechecksum, chunkFileName, checkSum, list);
            String sourceFilePath = (String)headerMap.get("file-path");
            String osType = "Microsoft OneDrive";
            String fsPath = CloudBackupController.getFsPath((String)headerMap.get("fileMD5"));
            String indexPath = null;
            int cloudId = cloud.getCloudId();
            boolean isSearchEnabled = false;
            if (cloud.getContentSearchEnabled() == 1) {
                OfficeBackupPolicy backupPolicy = this.uploadService.getOfficeBackupPolicyForUser(cloudId, bluKryptElement.getUserName());
                boolean isFileAllowed = true;
                if (backupPolicy.isContentIndexEnabled() && isFileAllowed) {
                    isSearchEnabled = true;
                }
            }
            if (cloud.getContentSearchForODDisabled() == 1) {
                isSearchEnabled = false;
            }
            if (isSearchEnabled) {
                indexPath = CloudBackupController.getPropertyFileValueParabluFolderBasePath(bluKryptElement.getCloudName()) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            }
            logger.debug("index path" + indexPath);
            logger.debug("File name after creating the random uuid: " + chunkFileElement.getFileName());
            this.checkNThrottleAndUploadFileV2(cloudName, bluKryptElement.getGatewayName(), inputStream, fileSize, chunkFileElement, sourceFilePath, osType, indexPath, batchId);
            chunkMd5s.add(chunkFileElement.getMd5checksum());
            logger.debug("Chunk file md5 list>>>>> " + chunkMd5s.size());
            checkSum = chunkFileElement.getMd5checksum();
            assert (Boolean.parseBoolean(isNormalFile));
            logger.debug(" Before calling insert query ...........");
            FileUploadDetailsElement fileUploadDetailsElement = this.insertEntryForBackupFromBK(headerMap, cloudName, bluKryptElement.getUserName(), bluKryptElement.getVersionsToKeep(), device, false);
            backupId = fileUploadDetailsElement.getBkpId();
            if (StringUtils.isEmpty((Object)backupId) || ALREADY_EXISTS.equalsIgnoreCase(backupId) || LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                int file2;
                File file2;
                logger.debug(" Already exists!" + backupId);
                this.removeDriveItem(driveFileInfoId, false);
                if (!StringUtils.isEmpty((Object)indexPath) && (file2 = new File(indexPath)).exists()) {
                    file2.delete();
                }
                if (LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                    file2 = 200;
                    return file2;
                }
                if (ALREADY_EXISTS.equalsIgnoreCase(backupId)) {
                    file2 = 200;
                    return file2;
                }
                file2 = 409;
                return file2;
            }
            if (CollectionUtils.isEmpty(list)) {
                logger.info(BATCH_ID_LOG + batchId + " List is empty sooo adding md5checksum" + checkSum);
                list.add(checkSum);
            }
            logger.debug("backupid ---> " + backupId + "(" + StringUtils.isEmpty((Object)backupId) + ")");
            FileInfo fileInfo = this.getFileInfo(bluKryptElement, backupId, prevBackupId, list);
            ArrayList<String> orgChunks = list;
            fileInfo.setSize(Long.valueOf(fileSize));
            if (headerMap.get("hasAttachments") != null) {
                fileInfo.setHasAttachments(((Boolean)headerMap.get("hasAttachments")).booleanValue());
            }
            if (fileInfo.isHasAttachments()) {
                fileInfo.setAttachments((List)headerMap.get("attachments"));
            }
            if (!StringUtils.isEmpty((Object)headerMap.get(JOB_ID))) {
                fileInfo.setServerBackupJobId((String)headerMap.get(JOB_ID));
            }
            if (!StringUtils.isEmpty((Object)isCompressed)) {
                fileInfo.setCompressed(Boolean.valueOf(isCompressed).booleanValue());
            }
            fileInfo.setBatchId(batchId);
            String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, fileInfo.getBatchId());
            logger.debug("orgchunks list>>" + orgChunks.size());
            boolean fileExists = false;
            logger.debug("Chunk file path --" + chunkPath + " size ->" + orgChunks.size());
            List<String> moveFilesFromTmpPath = this.moveFilesFromTmpPath(deviceUUID, orgChunks, chunkPath, fileInfo.getBatchId());
            fileInfo.getChunkFiles().clear();
            fileInfo.getChunkFiles().addAll(moveFilesFromTmpPath);
            if (!StringUtils.isEmpty((Object)chunkFilechecksum)) {
                List<String> resChunkList = this.getBackupIdAppendedToChunks(moveFilesFromTmpPath, fileInfo.getId());
                fileInfo.getChunkFiles().clear();
                fileInfo.getChunkFiles().addAll(resChunkList);
            }
            logger.debug("...isfileexistsisSearchEnabled....." + fileExists + "...." + isSearchEnabled);
            if (fileExists) {
                this.uploadService.updateFileInfo(cloudName, "", fileInfo);
                this.removeDriveItem(driveFileInfoId, false);
            } else {
                fileInfo.setGatewayName(PCHelperConstant.getComponentName());
                this.updateStorageUtilization(cloudName, batchId, deviceUUID, list, fileUploadDetailsElement);
                fileInfo.setReducePGSize(true);
                this.uploadService.saveFileInfoForODB(cloudName, bluKryptElement.getUserName(), fileInfo, driveFileInfoId, false);
                BackUpImage backUpImage = this.utilService.getBackupImageForItemId(cloudId, (String)headerMap.get("odItemId"), device.getDestCollection(), deviceUUID);
                logger.debug(".....check link...");
                if (backUpImage != null && isOneDrive) {
                    logger.debug("check for file deletion in onedrive and create links...");
                    com.parablu.pcbd.domain.User user = this.utilService.getUserInfoByName(cloud.getCloudId(), device.getUserName());
                    String emailId = user.getEmailId();
                    OfficeBackupPolicy officeBackupPolicy = this.utilService.getOfficeBackupPolicyForUser(cloudId, device.getUserName());
                    logger.debug("check for create links..." + officeBackupPolicy.isCreateLinkEnabled());
                    if (officeBackupPolicy != null && officeBackupPolicy.isCreateLinkEnabled() && officeBackupPolicy.getThreshholdLimit() > 0L) {
                        Drive drive = this.getDriveIdForUser(emailId);
                        double usedPercent = this.getUsedPercentage(drive);
                        logger.debug(officeBackupPolicy.getPurgeFilesSizeGTThan() + ".......used backUpImage.getSize()  ...." + backUpImage.getSize() + "...used limit..." + usedPercent);
                        if (usedPercent > (double)officeBackupPolicy.getThreshholdLimit()) {
                            logger.debug(officeBackupPolicy.getPurgeFilesOlderThan() + ".......used percent threshold limit ...." + officeBackupPolicy.getThreshholdLimit() + "...used limit..." + usedPercent);
                            int noOfDays = officeBackupPolicy.getPurgeFilesOlderThan();
                            if (noOfDays > 0 || officeBackupPolicy.getPurgeFilesSizeGTThan() > 0) {
                                long filesExpiredDate = 0L;
                                if (noOfDays > 0) {
                                    filesExpiredDate = System.currentTimeMillis() - (long)noOfDays * 86400000L;
                                }
                                long sizeBasedFiles = officeBackupPolicy.getPurgeFilesSizeGTThan() * 1024;
                                logger.debug("......noofdayscheck...." + backUpImage.getO365LastModifiedTime() + "....policy date..." + filesExpiredDate);
                                logger.debug("....sizecheck ..... " + backUpImage.getSize() + "..." + sizeBasedFiles);
                                logger.debug("......." + (backUpImage.getO365LastModifiedTime() < filesExpiredDate) + "...size..." + (backUpImage.getSize() > sizeBasedFiles));
                                if (noOfDays > 0 && backUpImage.getO365LastModifiedTime() < filesExpiredDate && backUpImage.getSize() > sizeBasedFiles || noOfDays == 0 && backUpImage.getSize() > sizeBasedFiles) {
                                    logger.debug(backUpImage.getDevicePath() + "...ddbackup file...." + backUpImage.getFileName() + "...." + backUpImage.getO365LastModifiedTime());
                                    String filePath = this.encodeBase64UTFString(backUpImage.getDevicePath());
                                    backupId = backUpImage.getId().toString();
                                    String userName = this.encodeBase64UTFString(backUpImage.getUserName());
                                    deviceUUID = this.encodeBase64UTFString(backUpImage.getDeviceUUID());
                                    String odItemId = this.encodeBase64UTFString(backUpImage.getOdItemId());
                                    String attachName = this.encodeBase64UTFString("EMPTY");
                                    String redirectURL = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/portal/viewFile/" + userName + "/" + deviceUUID + "/" + odItemId + "/" + attachName;
                                    String fileUrl = "";
                                    String driveId = drive.id;
                                    String path = "";
                                    if (backUpImage.getDevicePath().equalsIgnoreCase("Files")) {
                                        path = backUpImage.getFileName();
                                        fileUrl = "https://graph.microsoft.com/v1.0/drives/" + driveId + "/root/children/" + path + ".url/content";
                                    } else {
                                        String folderPath = backUpImage.getDevicePath().replaceAll("Files/", "");
                                        path = folderPath + "/" + backUpImage.getFileName();
                                        fileUrl = "https://graph.microsoft.com/v1.0/drives/" + driveId + "/root:/" + path + ".url:/content";
                                    }
                                    logger.debug(backUpImage.getFileName() + "....file and url...." + fileUrl);
                                    logger.debug("....new redirect url test...." + redirectURL);
                                    String bodyContent = "[InternetShortcut]\nURL=" + redirectURL + "";
                                    RequestBody body = RequestBody.create((byte[])bodyContent.getBytes());
                                    Request request = new Request.Builder().url(fileUrl).put(body).build();
                                    Call call = CloudBackupController.getOkHttpClient().newCall(request);
                                    try {
                                        Response response = call.execute();
                                        int responseCode = response.code();
                                        logger.debug(".....responsecode...." + responseCode);
                                        if (responseCode == 200) {
                                            DriveItem item = null;
                                            try {
                                                item = (DriveItem)this.getGraphClient().customRequest("/drives/" + driveId + "/root:/" + path + ".url", DriveItem.class).buildRequest(new Option[0]).get();
                                                CloudBackupController.deleteFile(driveId, item.id);
                                            }
                                            catch (GraphServiceException ee) {
                                                logger.debug("....item not found..." + ee.getResponseCode());
                                            }
                                            body = RequestBody.create((byte[])bodyContent.getBytes());
                                            request = new Request.Builder().url(fileUrl).put(body).build();
                                            call = CloudBackupController.getOkHttpClient().newCall(request);
                                            response = call.execute();
                                            responseCode = response.code();
                                        }
                                        if (responseCode == 201) {
                                            AuditHistory audit = new AuditHistory();
                                            audit.setAction("Purged onedrive file and created url for  File name:");
                                            audit.setActionByUserName("");
                                            audit.setActionOnObject(backUpImage.getDevicePath() + "/" + backUpImage.getFileName());
                                            audit.setTimestamp(System.currentTimeMillis());
                                            audit.setActionUsingObject("");
                                            audit.setActionType(210);
                                            this.utilService.saveAudit(cloudId, audit);
                                        }
                                        CloudBackupController.deleteFile(driveId, backUpImage.getOdItemId());
                                    }
                                    catch (GraphServiceException e) {
                                        e.printStackTrace();
                                        logger.error(".....error in creating link to ...");
                                    }
                                    catch (IOException ee) {
                                        ee.printStackTrace();
                                    }
                                }
                            }
                        }
                    }
                }
                logger.debug(".. start of adding search index....");
                bluKryptElement.setDeviceUUID(device.getDeviceUUID());
                if (isSearchEnabled) {
                    SearchIndex index = this.formSearchIndex(1, bluKryptElement, new ObjectId(backupId), fsPath, device.getId());
                    index.setDeviceType(device.getDeviceType());
                    index.setDeviceName(device.getDeviceName());
                    this.utilService.addFileToTable(index, bluKryptElement.getCloudName());
                    logger.debug(index.getDeviceUUID() + ".. end of adding search index...." + index.getDeviceId());
                }
            }
            logger.debug(BATCH_ID_LOG + batchId + " End of uploading multi part file...........");
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            logger.error(BATCH_ID_LOG + batchId + " Exception While Uploading", (Throwable)e);
            int n = 500;
            return n;
        }
        finally {
            this.closeInputStreamAndDelTempFile(null, inputStream);
        }
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int uploadMail(Map<String, Object> headerMap, InputStream dataStream, int uploadCount, List<String> chunkMd5s, Cloud cloud, OfficeBackupPolicy backupPolicy) {
        String backupId = "";
        String cloudName = "";
        String batchId = "";
        InputStream inputStream = dataStream;
        logger.debug("Entering mail upload!");
        try {
            String deviceUUID = (String)headerMap.get("deviceUUID");
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(headerMap);
            String driveFileInfoId = (String)headerMap.get("driveFileInfoId");
            if (cloud != null) {
                bluKryptElement.setVersionsToKeep(Integer.toString(cloud.getVersioningEnabled()));
            }
            String fileSizeInString = (String)headerMap.get("file-size");
            String chunkFilechecksum = (String)headerMap.get("chunkFileMD5");
            String chunkFileName = (String)headerMap.get("chunkFileName");
            batchId = (String)headerMap.get("backupBatchId");
            String isChunkOfAFile = "false";
            String checkSum = (String)headerMap.get("fileMD5");
            String prevBackupId = (String)headerMap.get("prevBackupId");
            String isCompressed = "false";
            String isNormalFile = "true";
            long fileSize = Long.parseLong(fileSizeInString);
            logger.debug(BATCH_ID_LOG + batchId);
            ArrayList<String> list = new ArrayList<String>();
            boolean isMachineStorageReached = CloudBackupController.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                int n = 507;
                return n;
            }
            cloudName = bluKryptElement.getCloudName();
            Device device = this.utilService.getDeviceForUUID(cloud.getCloudId(), deviceUUID);
            logger.debug("!!!Obtained the device " + device.getDeviceUUID());
            ChunkFileElement chunkFileElement = CloudBackupController.createChunkFileElement(deviceUUID, bluKryptElement, chunkFilechecksum, chunkFileName, checkSum, list);
            String sourceFilePath = (String)headerMap.get("file-path");
            String osType = "Microsoft OneDrive";
            String fsPath = CloudBackupController.getFsPath((String)headerMap.get("fileMD5"));
            String indexPath = null;
            int cloudId = cloud.getCloudId();
            boolean isSearchEnabled = false;
            if (cloud.getContentSearchEnabled() == 1 && backupPolicy.isContentIndexEnabled()) {
                isSearchEnabled = true;
            }
            if (isSearchEnabled) {
                indexPath = CloudBackupController.getPropertyFileValueParabluFolderBasePath(bluKryptElement.getCloudName()) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            }
            logger.debug(".....isSearchEnabled...." + isSearchEnabled);
            logger.debug("index path" + indexPath);
            logger.debug("File name after creating the random uuid: " + chunkFileElement.getFileName());
            this.checkNThrottleAndUploadFileV2(cloudName, bluKryptElement.getGatewayName(), inputStream, fileSize, chunkFileElement, sourceFilePath, osType, indexPath, batchId);
            chunkMd5s.add(chunkFileElement.getMd5checksum());
            logger.debug("Chunk file md5 list>>>>> " + chunkMd5s.size());
            checkSum = chunkFileElement.getMd5checksum();
            logger.debug(" Before calling insert query mail...........");
            FileUploadDetailsElement fileUploadDetailsElement = this.insertEntryForBackupFromBK(headerMap, cloudName, bluKryptElement.getUserName(), bluKryptElement.getVersionsToKeep(), device, true);
            backupId = fileUploadDetailsElement.getBkpId();
            if (StringUtils.isEmpty((Object)backupId) || ALREADY_EXISTS.equalsIgnoreCase(backupId) || LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                File file22;
                logger.debug(" Already exists!" + backupId);
                this.removeDriveItem(driveFileInfoId, true);
                if (!StringUtils.isEmpty((Object)indexPath) && (file22 = new File(indexPath)).exists()) {
                    file22.delete();
                }
                if (LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                    int file22 = 200;
                    return file22;
                }
                if (ALREADY_EXISTS.equalsIgnoreCase(backupId)) {
                    int file22 = 200;
                    return file22;
                }
                int file22 = 409;
                return file22;
            }
            if (CollectionUtils.isEmpty(list)) {
                logger.info(BATCH_ID_LOG + batchId + " List is empty sooo adding md5checksum" + checkSum);
                list.add(checkSum);
            }
            logger.debug("backupid ---> " + backupId + "(" + StringUtils.isEmpty((Object)backupId) + ")");
            FileInfo fileInfo = this.getFileInfo(bluKryptElement, backupId, prevBackupId, list);
            fileInfo.setSubject((String)headerMap.get("subject"));
            fileInfo.setFrom((String)headerMap.get("from"));
            fileInfo.setBodyContent((String)headerMap.get("bodyContent"));
            if (headerMap.get("receivedDateTime") != null) {
                fileInfo.setReceivedDateTime(((Long)headerMap.get("receivedDateTime")).longValue());
            }
            if (headerMap.get("sentDateTime") != null) {
                fileInfo.setSentDateTime(((Long)headerMap.get("sentDateTime")).longValue());
            }
            fileInfo.setCcRecipients((String)headerMap.get("ccRecipients"));
            fileInfo.setBccRecipients((String)headerMap.get("bccRecipients"));
            fileInfo.setToRecipients((String)headerMap.get("toRecipients"));
            fileInfo.setHasAttachments(((Boolean)headerMap.get("hasAttachments")).booleanValue());
            fileInfo.setFromAddr((String)headerMap.get("fromAddr"));
            fileInfo.setCcRecipientsAddr((String)headerMap.get("ccRecipientsAddr"));
            fileInfo.setBccRecipientsAddr((String)headerMap.get("bccRecipientsAddr"));
            fileInfo.setToRecipientsAddr((String)headerMap.get("toRecipientsAddr"));
            if (fileInfo.isHasAttachments()) {
                fileInfo.setAttachments((List)headerMap.get("attachments"));
            }
            if (headerMap.get("toRecipientsAddress") != null) {
                fileInfo.setToRecipientsAddress((List)headerMap.get("toRecipientsAddress"));
            }
            if (headerMap.get("ccRecipientsAddress") != null) {
                fileInfo.setCcRecipientsAddress((List)headerMap.get("ccRecipientsAddress"));
            }
            if (headerMap.get("bccRecipientsAddress") != null) {
                fileInfo.setBccRecipientsAddress((List)headerMap.get("bccRecipientsAddress"));
            }
            if (headerMap.get("fromEmailAddress") != null) {
                fileInfo.setFromEmailAddress((OutlookEmailAddress)headerMap.get("fromEmailAddress"));
            }
            ArrayList<String> orgChunks = list;
            fileInfo.setSize(Long.valueOf(fileSize));
            if (!StringUtils.isEmpty((Object)headerMap.get(JOB_ID))) {
                fileInfo.setServerBackupJobId((String)headerMap.get(JOB_ID));
            }
            if (!StringUtils.isEmpty((Object)isCompressed)) {
                fileInfo.setCompressed(Boolean.valueOf(isCompressed).booleanValue());
            }
            if (!StringUtils.isEmpty((Object)chunkFilechecksum)) {
                List<String> resChunkList = this.getBackupIdAppendedToChunks(list, backupId);
                fileInfo.getChunkFiles().clear();
                fileInfo.getChunkFiles().addAll(resChunkList);
            }
            fileInfo.setBatchId(batchId);
            logger.debug("..batchidpath...." + batchId);
            String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, fileInfo.getBatchId());
            logger.debug("orgchunks list>>" + orgChunks.size());
            boolean isFullBackup = true;
            boolean fileExists = false;
            logger.debug(fileUploadDetailsElement.getFileSize() + "Chunk file path --" + chunkPath + " size ->" + orgChunks.size());
            this.moveFilesFromTmpPath(deviceUUID, orgChunks, chunkPath, fileInfo.getBatchId());
            this.updateMailStorageUtilization(deviceUUID, fileUploadDetailsElement);
            fileInfo.setReducePGSize(true);
            HashedMap urlSetMap = new HashedMap();
            boolean isLocalSaveSuccess = this.uploadService.saveFileInfoForODB(cloudName, bluKryptElement.getUserName(), fileInfo, driveFileInfoId, true);
            logger.debug("...savelocalsuccess..." + isLocalSaveSuccess);
            logger.debug(".....mail isSearchEnabled...." + isSearchEnabled);
            logger.debug(".....outlook ....");
            if (backupPolicy.isCreateMailLinkEnabled()) {
                GraphServiceClient<Request> graphClient = Graph.getInstance().getGraphClient();
                String odItemId = (String)headerMap.get("odItemId");
                String userId = (String)headerMap.get("graphUserId");
                logger.debug(userId + "...before meessage...." + odItemId);
                Message message = graphClient.users(userId).messages(odItemId).buildRequest(new Option[0]).get();
                if ("HTML".equals(message.body.contentType.name())) {
                    Object listAttachments;
                    AttachmentCollectionPage attachmentCollectionPage = (AttachmentCollectionPage)((AttachmentCollectionRequest)graphClient.users(userId).messages(odItemId).attachments().buildRequest(new Option[0])).get();
                    logger.debug(message.id + "...after meessage1...." + attachmentCollectionPage);
                    logger.debug(message.hasAttachments + "...after meessage2...." + message.subject);
                    HashedMap attachMap = new HashedMap();
                    if (attachmentCollectionPage != null && !CollectionUtils.isEmpty((Collection)(listAttachments = attachmentCollectionPage.getCurrentPage()))) {
                        Iterator iterator = listAttachments.iterator();
                        while (iterator.hasNext()) {
                            Attachment attachment = (Attachment)iterator.next();
                            boolean bl = CloudBackupController.checkFileSize((long)attachment.size, Long.parseLong(backupPolicy.getMailMaxFileSize()));
                            if (bl || attachment.isInline.booleanValue()) continue;
                            attachMap.put(attachment.id, attachment.name);
                        }
                    }
                    if (!CollectionUtils.isEmpty((Map)attachMap)) {
                        logger.debug(message.body.contentType.name() + "...message format...." + message.subject);
                        if (!"HTML".equals(message.body.contentType.name())) {
                            // empty if block
                        }
                        for (Map.Entry entry : attachMap.entrySet()) {
                            String attachId = (String)entry.getKey();
                            logger.debug("....attachments...." + (String)entry.getKey() + "...name..." + (String)entry.getValue());
                            graphClient.users(userId).messages(odItemId).attachments(attachId).buildRequest(new Option[0]).delete();
                            Thread.sleep(3000L);
                        }
                        logger.debug(odItemId + "...body preview...." + userId + "/messages/" + odItemId);
                        String userNameVal = this.encodeBase64UTFString(fileInfo.getUserName());
                        deviceUUID = this.encodeBase64UTFString(fileInfo.getDeviceUUID());
                        String string = this.encodeBase64UTFString(odItemId);
                        for (Map.Entry entry : attachMap.entrySet()) {
                            logger.debug("....attachments...." + (String)entry.getKey() + "...name..." + (String)entry.getValue());
                            String url = "https://graph.microsoft.com/beta/users/" + userId + "/messages/" + odItemId + "/attachments/";
                            JSONObject jsonObject = new JSONObject();
                            try {
                                String attachName = this.encodeBase64UTFString((String)entry.getValue());
                                String redirectURL = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/portal/viewFile/" + userNameVal + "/" + deviceUUID + "/" + string + "/" + attachName;
                                jsonObject.put("sourceUrl", (Object)redirectURL);
                                jsonObject.put("name", entry.getValue());
                                jsonObject.put("isFolder", (Object)"false");
                                jsonObject.put("providerType", (Object)"other");
                                jsonObject.put("permission", (Object)"other");
                                jsonObject.put("@odata.type", (Object)"#microsoft.graph.referenceAttachment");
                                urlSetMap.put(entry.getValue(), redirectURL);
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                            MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
                            RequestBody body = RequestBody.create((MediaType)JSON, (byte[])jsonObject.toString().getBytes());
                            Request request = new Request.Builder().url(url).post(body).build();
                            Response response = null;
                            try {
                                response = Graph.getInstance().getOkHttpClient().newCall(request).execute();
                                String resStr = response.body().string();
                                logger.debug(response.code() + "....attachresponse......" + resStr);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        try {
                            Thread.sleep(3000L);
                            Message newMsg = new Message();
                            ItemBody itemBody = new ItemBody();
                            itemBody.contentType = BodyType.HTML;
                            Message messageVal = graphClient.users(userId).messages(odItemId).buildRequest(new Option[0]).get();
                            String content = messageVal.body.content;
                            logger.debug(messageVal + "...before updating txt..after.." + cloud.getMailWarningText());
                            if (!StringUtils.isEmpty((Object)cloud.getMailWarningText())) {
                                content = cloud.getMailWarningText() + messageVal.body.content;
                            }
                            itemBody.content = content;
                            newMsg.body = itemBody;
                            newMsg.inferenceClassification = InferenceClassificationType.FOCUSED;
                            graphClient.users(userId).messages(odItemId).buildRequest(new Option[0]).patch(newMsg);
                            Thread.sleep(3000L);
                        }
                        catch (GraphServiceException ee) {
                            ee.printStackTrace();
                            logger.error("...unable to update ..." + ee.getMessage());
                        }
                        catch (Exception ee) {
                            ee.printStackTrace();
                            logger.error("...unable to update ..." + ee.getMessage());
                        }
                    }
                }
            }
            if (isSearchEnabled) {
                if (headerMap.get("fsMailPath") != null) {
                    // empty if block
                }
                SearchIndex index = this.formMailSearchIndex(1, bluKryptElement, new ObjectId(backupId), fsPath, device.getId());
                index.setSubject(fileInfo.getSubject());
                index.setFrom(fileInfo.getFrom());
                index.setBodyContent(fileInfo.getBodyContent());
                index.setReceivedDateTime(fileInfo.getReceivedDateTime());
                index.setSentDateTime(fileInfo.getSentDateTime());
                index.setCcRecipients(fileInfo.getCcRecipients());
                index.setBccRecipients(fileInfo.getBccRecipients());
                index.setToRecipients(fileInfo.getToRecipients());
                index.setHasAttachments(fileInfo.isHasAttachments());
                index.setAttachments(fileInfo.getAttachments());
                index.setCcRecipientsAddr(fileInfo.getCcRecipientsAddr());
                index.setFromAddr(fileInfo.getFromAddr());
                index.setBccRecipientsAddr(fileInfo.getBccRecipientsAddr());
                index.setToRecipientsAddr(fileInfo.getToRecipientsAddr());
                logger.debug("....torecepientsaddress ......" + fileInfo.getToRecipientsAddr());
                index.setDeviceType(device.getDeviceType());
                index.setDeviceName(device.getDeviceName());
                this.utilService.addFileToTable(index, bluKryptElement.getCloudName());
                logger.debug(index.getDeviceUUID() + ".. end of adding search index...." + index.getDeviceId());
            }
            logger.debug(BATCH_ID_LOG + batchId + " End of uploading multi part file...........");
        }
        catch (Exception e) {
            logger.error(BATCH_ID_LOG + batchId + " Exception While Uploading", (Throwable)e);
            int n = 500;
            return n;
        }
        finally {
            this.closeInputStreamAndDelTempFile(null, inputStream);
        }
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int uploadContacts(Map<String, Object> headerMap, InputStream dataStream, int uploadCount, List<String> chunkMd5s, Cloud cloud, OfficeBackupPolicy backupPolicy) {
        String backupId = "";
        String cloudName = "";
        String batchId = "";
        InputStream inputStream = dataStream;
        logger.debug("Entering Contacts upload!");
        try {
            String deviceUUID = (String)headerMap.get("deviceUUID");
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(headerMap);
            bluKryptElement.setFilePath("Contacts");
            String driveFileInfoId = (String)headerMap.get("driveFileInfoId");
            if (cloud != null) {
                bluKryptElement.setVersionsToKeep(Integer.toString(cloud.getVersioningEnabled()));
            }
            String fileSizeInString = (String)headerMap.get("file-size");
            String chunkFilechecksum = (String)headerMap.get("chunkFileMD5");
            String chunkFileName = (String)headerMap.get("chunkFileName");
            batchId = (String)headerMap.get("backupBatchId");
            String isChunkOfAFile = "false";
            String checkSum = (String)headerMap.get("fileMD5");
            String prevBackupId = (String)headerMap.get("prevBackupId");
            String isCompressed = "false";
            String isNormalFile = "true";
            long fileSize = Long.parseLong(fileSizeInString);
            logger.debug(BATCH_ID_LOG + batchId);
            ArrayList<String> list = new ArrayList<String>();
            boolean isMachineStorageReached = CloudBackupController.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                int n = 507;
                return n;
            }
            cloudName = bluKryptElement.getCloudName();
            Device device = this.utilService.getDeviceForUUID(cloud.getCloudId(), deviceUUID);
            logger.debug("!!!Obtained the device " + device.getDeviceUUID());
            ChunkFileElement chunkFileElement = CloudBackupController.createChunkFileElement(deviceUUID, bluKryptElement, chunkFilechecksum, chunkFileName, checkSum, list);
            String sourceFilePath = (String)headerMap.get("file-path");
            String osType = "Microsoft OneDrive";
            String fsPath = CloudBackupController.getFsPath((String)headerMap.get("fileMD5"));
            String indexPath = null;
            int cloudId = cloud.getCloudId();
            boolean isSearchEnabled = false;
            if (cloud.getContentSearchEnabled() == 1 && backupPolicy.isContentIndexEnabled()) {
                isSearchEnabled = true;
            }
            if (isSearchEnabled = false) {
                indexPath = CloudBackupController.getPropertyFileValueParabluFolderBasePath(bluKryptElement.getCloudName()) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            }
            logger.debug(".....isSearchEnabled...." + isSearchEnabled);
            logger.debug("index path" + indexPath);
            logger.debug("File name after creating the random uuid: " + chunkFileElement.getFileName());
            this.checkNThrottleAndUploadFileV2(cloudName, bluKryptElement.getGatewayName(), inputStream, fileSize, chunkFileElement, sourceFilePath, osType, indexPath, batchId);
            chunkMd5s.add(chunkFileElement.getMd5checksum());
            logger.debug("Chunk file md5 list>>>>> " + chunkMd5s.size());
            checkSum = chunkFileElement.getMd5checksum();
            logger.debug(" Before calling insert query mail...........");
            FileUploadDetailsElement fileUploadDetailsElement = this.insertEntryForBackupFromBK(headerMap, cloudName, bluKryptElement.getUserName(), bluKryptElement.getVersionsToKeep(), device, true);
            backupId = fileUploadDetailsElement.getBkpId();
            if (StringUtils.isEmpty((Object)backupId) || ALREADY_EXISTS.equalsIgnoreCase(backupId) || LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                File file2;
                logger.debug(" Already exists!" + backupId);
                this.removeDriveItem(driveFileInfoId, true);
                if (!StringUtils.isEmpty((Object)indexPath) && (file2 = new File(indexPath)).exists()) {
                    file2.delete();
                }
                if (LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                    int file2 = 200;
                    return file2;
                }
                if (ALREADY_EXISTS.equalsIgnoreCase(backupId)) {
                    int file2 = 200;
                    return file2;
                }
                int file2 = 409;
                return file2;
            }
            if (CollectionUtils.isEmpty(list)) {
                logger.info(BATCH_ID_LOG + batchId + " List is empty sooo adding md5checksum" + checkSum);
                list.add(checkSum);
            }
            logger.debug("backupid ---> " + backupId + "(" + StringUtils.isEmpty((Object)backupId) + ")");
            FileInfo fileInfo = this.getFileInfo(bluKryptElement, backupId, prevBackupId, list);
            if (headerMap.get("hasAttachments") == null) {
                headerMap.put("hasAttachments", false);
            }
            logger.debug("..attachphoto...." + headerMap.get("hasAttachments"));
            fileInfo.setHasAttachments(((Boolean)headerMap.get("hasAttachments")).booleanValue());
            fileInfo.setSubject((String)headerMap.get("subject"));
            fileInfo.setFrom((String)headerMap.get("from"));
            logger.debug("......mob...." + headerMap.get("contactMobile"));
            if (headerMap.get("contactMobile") != null) {
                fileInfo.setContactMobile((String)headerMap.get("contactMobile"));
            }
            if (headerMap.get("contactAddrStreet") != null) {
                fileInfo.setContactAddrStreet((String)headerMap.get("contactAddrStreet"));
            }
            if (headerMap.get("contactAddrCity") != null) {
                fileInfo.setContactAddrCity((String)headerMap.get("contactAddrCity"));
            }
            if (headerMap.get("contactAddrState") != null) {
                fileInfo.setContactAddrState((String)headerMap.get("contactAddrState"));
            }
            if (headerMap.get("contactAddrCountry") != null) {
                fileInfo.setContactAddrCountry((String)headerMap.get("contactAddrCountry"));
            }
            if (headerMap.get("contactAddrPostalCode") != null) {
                fileInfo.setContactAddrPostalCode((String)headerMap.get("contactAddrPostalCode"));
            }
            if (fileInfo.isHasAttachments()) {
                fileInfo.setAttachments((List)headerMap.get("attachments"));
            }
            ArrayList<String> orgChunks = list;
            fileInfo.setSize(Long.valueOf(fileSize));
            if (!StringUtils.isEmpty((Object)headerMap.get(JOB_ID))) {
                fileInfo.setServerBackupJobId((String)headerMap.get(JOB_ID));
            }
            if (!StringUtils.isEmpty((Object)isCompressed)) {
                fileInfo.setCompressed(Boolean.valueOf(isCompressed).booleanValue());
            }
            if (!StringUtils.isEmpty((Object)chunkFilechecksum)) {
                List<String> resChunkList = this.getBackupIdAppendedToChunks(list, backupId);
                fileInfo.getChunkFiles().clear();
                fileInfo.getChunkFiles().addAll(resChunkList);
            }
            fileInfo.setBatchId(batchId);
            String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, fileInfo.getBatchId());
            logger.debug("orgchunks list>>" + orgChunks.size());
            boolean isFullBackup = true;
            boolean fileExists = false;
            logger.debug(fileUploadDetailsElement.getFileSize() + "Chunk file path --" + chunkPath + " size ->" + orgChunks.size());
            this.moveFilesFromTmpPath(deviceUUID, orgChunks, chunkPath, fileInfo.getBatchId());
            this.updateMailStorageUtilization(deviceUUID, fileUploadDetailsElement);
            fileInfo.setReducePGSize(true);
            boolean isLocalSaveSuccess = this.uploadService.saveFileInfoForODB(cloudName, bluKryptElement.getUserName(), fileInfo, driveFileInfoId, true);
            logger.debug("...savelocalsuccess..." + isLocalSaveSuccess);
            logger.debug(".....mail isSearchEnabled...." + isSearchEnabled);
            if (isSearchEnabled) {
                if (headerMap.get("fsMailPath") != null) {
                    // empty if block
                }
                SearchIndex index = this.formMailSearchIndex(1, bluKryptElement, new ObjectId(backupId), fsPath, device.getId());
                index.setSubject(fileInfo.getSubject());
                index.setFrom(fileInfo.getFrom());
                index.setBodyContent(fileInfo.getBodyContent());
                index.setReceivedDateTime(fileInfo.getReceivedDateTime());
                index.setSentDateTime(fileInfo.getSentDateTime());
                index.setCcRecipients(fileInfo.getCcRecipients());
                index.setBccRecipients(fileInfo.getBccRecipients());
                index.setToRecipients(fileInfo.getToRecipients());
                index.setHasAttachments(fileInfo.isHasAttachments());
                index.setAttachments(fileInfo.getAttachments());
                index.setCcRecipientsAddr(fileInfo.getCcRecipientsAddr());
                index.setFromAddr(fileInfo.getFromAddr());
                index.setBccRecipientsAddr(fileInfo.getBccRecipientsAddr());
                index.setToRecipientsAddr(fileInfo.getToRecipientsAddr());
                logger.debug("....torecepientsaddress ......" + fileInfo.getToRecipientsAddr());
                index.setDeviceType(device.getDeviceType());
                index.setDeviceName(device.getDeviceName());
                this.utilService.addFileToTable(index, bluKryptElement.getCloudName());
                logger.debug(index.getDeviceUUID() + ".. end of adding search index...." + index.getDeviceId());
            }
            logger.debug(BATCH_ID_LOG + batchId + " End of uploading multi part file...........");
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            logger.error(BATCH_ID_LOG + batchId + " Exception While Uploading", (Throwable)e);
            int n = 500;
            return n;
        }
        finally {
            this.closeInputStreamAndDelTempFile(null, inputStream);
        }
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int uploadTasks(Map<String, Object> headerMap, InputStream dataStream, int uploadCount, List<String> chunkMd5s, Cloud cloud, OfficeBackupPolicy backupPolicy) {
        String backupId = "";
        String cloudName = "";
        String batchId = "";
        InputStream inputStream = dataStream;
        logger.debug("Entering Contacts upload!");
        try {
            String deviceUUID = (String)headerMap.get("deviceUUID");
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(headerMap);
            bluKryptElement.setFilePath("Tasks");
            String driveFileInfoId = (String)headerMap.get("driveFileInfoId");
            if (cloud != null) {
                bluKryptElement.setVersionsToKeep(Integer.toString(cloud.getVersioningEnabled()));
            }
            String fileSizeInString = (String)headerMap.get("file-size");
            String chunkFilechecksum = (String)headerMap.get("chunkFileMD5");
            String chunkFileName = (String)headerMap.get("chunkFileName");
            batchId = (String)headerMap.get("backupBatchId");
            String isChunkOfAFile = "false";
            String checkSum = (String)headerMap.get("fileMD5");
            String prevBackupId = (String)headerMap.get("prevBackupId");
            String isCompressed = "false";
            String isNormalFile = "true";
            long fileSize = Long.parseLong(fileSizeInString);
            logger.debug(BATCH_ID_LOG + batchId);
            ArrayList<String> list = new ArrayList<String>();
            boolean isMachineStorageReached = CloudBackupController.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                int n = 507;
                return n;
            }
            cloudName = bluKryptElement.getCloudName();
            Device device = this.utilService.getDeviceForUUID(cloud.getCloudId(), deviceUUID);
            logger.debug("!!!Obtained the device " + device.getDeviceUUID());
            ChunkFileElement chunkFileElement = CloudBackupController.createChunkFileElement(deviceUUID, bluKryptElement, chunkFilechecksum, chunkFileName, checkSum, list);
            String sourceFilePath = (String)headerMap.get("file-path");
            String osType = "Microsoft OneDrive";
            String fsPath = CloudBackupController.getFsPath((String)headerMap.get("fileMD5"));
            String indexPath = null;
            int cloudId = cloud.getCloudId();
            boolean isSearchEnabled = false;
            if (cloud.getContentSearchEnabled() == 1 && backupPolicy.isContentIndexEnabled()) {
                isSearchEnabled = true;
            }
            if (isSearchEnabled = false) {
                indexPath = CloudBackupController.getPropertyFileValueParabluFolderBasePath(bluKryptElement.getCloudName()) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            }
            logger.debug(".....isSearchEnabled...." + isSearchEnabled);
            logger.debug("index path" + indexPath);
            logger.debug("File name after creating the random uuid: " + chunkFileElement.getFileName());
            this.checkNThrottleAndUploadFileV2(cloudName, bluKryptElement.getGatewayName(), inputStream, fileSize, chunkFileElement, sourceFilePath, osType, indexPath, batchId);
            chunkMd5s.add(chunkFileElement.getMd5checksum());
            logger.debug("Chunk file md5 list>>>>> " + chunkMd5s.size());
            checkSum = chunkFileElement.getMd5checksum();
            logger.debug(" Before calling insert query mail...........");
            FileUploadDetailsElement fileUploadDetailsElement = this.insertEntryForBackupFromBK(headerMap, cloudName, bluKryptElement.getUserName(), bluKryptElement.getVersionsToKeep(), device, true);
            backupId = fileUploadDetailsElement.getBkpId();
            if (StringUtils.isEmpty((Object)backupId) || ALREADY_EXISTS.equalsIgnoreCase(backupId) || LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                File file2;
                logger.debug(" Already exists!" + backupId);
                this.removeDriveItem(driveFileInfoId, true);
                if (!StringUtils.isEmpty((Object)indexPath) && (file2 = new File(indexPath)).exists()) {
                    file2.delete();
                }
                if (LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                    int file2 = 200;
                    return file2;
                }
                if (ALREADY_EXISTS.equalsIgnoreCase(backupId)) {
                    int file2 = 200;
                    return file2;
                }
                int file2 = 409;
                return file2;
            }
            if (CollectionUtils.isEmpty(list)) {
                logger.info(BATCH_ID_LOG + batchId + " List is empty sooo adding md5checksum" + checkSum);
                list.add(checkSum);
            }
            logger.debug("backupid ---> " + backupId + "(" + StringUtils.isEmpty((Object)backupId) + ")");
            FileInfo fileInfo = this.getFileInfo(bluKryptElement, backupId, prevBackupId, list);
            logger.debug("..attachphoto...." + headerMap.get("hasAttachments"));
            if (headerMap.get("hasAttachments") != null) {
                fileInfo.setHasAttachments(((Boolean)headerMap.get("hasAttachments")).booleanValue());
            }
            fileInfo.setSubject((String)headerMap.get("subject"));
            fileInfo.setFrom((String)headerMap.get("from"));
            if (fileInfo.isHasAttachments()) {
                fileInfo.setAttachments((List)headerMap.get("attachments"));
            }
            ArrayList<String> orgChunks = list;
            fileInfo.setSize(Long.valueOf(fileSize));
            if (!StringUtils.isEmpty((Object)headerMap.get(JOB_ID))) {
                fileInfo.setServerBackupJobId((String)headerMap.get(JOB_ID));
            }
            if (!StringUtils.isEmpty((Object)isCompressed)) {
                fileInfo.setCompressed(Boolean.valueOf(isCompressed).booleanValue());
            }
            if (!StringUtils.isEmpty((Object)chunkFilechecksum)) {
                List<String> resChunkList = this.getBackupIdAppendedToChunks(list, backupId);
                fileInfo.getChunkFiles().clear();
                fileInfo.getChunkFiles().addAll(resChunkList);
            }
            fileInfo.setBatchId(batchId);
            String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, fileInfo.getBatchId());
            logger.debug("orgchunks list>>" + orgChunks.size());
            boolean isFullBackup = true;
            boolean fileExists = false;
            logger.debug(fileUploadDetailsElement.getFileSize() + "Chunk file path --" + chunkPath + " size ->" + orgChunks.size());
            this.moveFilesFromTmpPath(deviceUUID, orgChunks, chunkPath, fileInfo.getBatchId());
            this.updateMailStorageUtilization(deviceUUID, fileUploadDetailsElement);
            fileInfo.setReducePGSize(true);
            boolean isLocalSaveSuccess = this.uploadService.saveFileInfoForODB(cloudName, bluKryptElement.getUserName(), fileInfo, driveFileInfoId, true);
            logger.debug("...savelocalsuccess..." + isLocalSaveSuccess);
            logger.debug(".....mail isSearchEnabled...." + isSearchEnabled);
            if (isSearchEnabled) {
                if (headerMap.get("fsMailPath") != null) {
                    // empty if block
                }
                SearchIndex index = this.formMailSearchIndex(1, bluKryptElement, new ObjectId(backupId), fsPath, device.getId());
                index.setSubject(fileInfo.getSubject());
                index.setFrom(fileInfo.getFrom());
                index.setBodyContent(fileInfo.getBodyContent());
                index.setReceivedDateTime(fileInfo.getReceivedDateTime());
                index.setSentDateTime(fileInfo.getSentDateTime());
                index.setCcRecipients(fileInfo.getCcRecipients());
                index.setBccRecipients(fileInfo.getBccRecipients());
                index.setToRecipients(fileInfo.getToRecipients());
                index.setHasAttachments(fileInfo.isHasAttachments());
                index.setAttachments(fileInfo.getAttachments());
                index.setCcRecipientsAddr(fileInfo.getCcRecipientsAddr());
                index.setFromAddr(fileInfo.getFromAddr());
                index.setBccRecipientsAddr(fileInfo.getBccRecipientsAddr());
                index.setToRecipientsAddr(fileInfo.getToRecipientsAddr());
                logger.debug("....torecepientsaddress ......" + fileInfo.getToRecipientsAddr());
                index.setDeviceType(device.getDeviceType());
                index.setDeviceName(device.getDeviceName());
                this.utilService.addFileToTable(index, bluKryptElement.getCloudName());
                logger.debug(index.getDeviceUUID() + ".. end of adding search index...." + index.getDeviceId());
            }
            logger.debug(BATCH_ID_LOG + batchId + " End of uploading multi part file...........");
        }
        catch (Exception e) {
            logger.error(BATCH_ID_LOG + batchId + " Exception While Uploading", (Throwable)e);
            int n = 500;
            return n;
        }
        finally {
            this.closeInputStreamAndDelTempFile(null, inputStream);
        }
        return 200;
    }

    protected SearchIndex formSearchIndex(int cloudId, BluKryptElement bluKryptElement, ObjectId consId, String fsPath, ObjectId deviceId) {
        SearchIndex searchIndex = new SearchIndex();
        searchIndex.setCloudId(cloudId);
        searchIndex.setBackup(false);
        searchIndex.setConsolidatedImageId(consId);
        searchIndex.setPresent(true);
        searchIndex.setCloudName(bluKryptElement.getCloudName());
        searchIndex.setAbstractFolderUrl(bluKryptElement.getFileCompletePath());
        searchIndex.setFileName(bluKryptElement.getFileName());
        searchIndex.setFolder(false);
        searchIndex.setSize(String.valueOf(bluKryptElement.getFileSize()));
        searchIndex.setLastModifiedTime(String.valueOf(System.currentTimeMillis()));
        searchIndex.setFsPath(fsPath);
        searchIndex.setMiniCloud(false);
        searchIndex.setUserName(bluKryptElement.getUserName());
        searchIndex.setStatus("ACTIVE");
        searchIndex.setOneDrive(true);
        searchIndex.setDeviceUUID(bluKryptElement.getDeviceUUID());
        searchIndex.setDeviceId(deviceId);
        return searchIndex;
    }

    protected SearchIndex formMailSearchIndex(int cloudId, BluKryptElement bluKryptElement, ObjectId consId, String fsPath, ObjectId deviceId) {
        SearchIndex searchIndex = new SearchIndex();
        searchIndex.setBackup(false);
        searchIndex.setCloudId(cloudId);
        searchIndex.setConsolidatedImageId(consId);
        searchIndex.setPresent(true);
        searchIndex.setCloudName(bluKryptElement.getCloudName());
        searchIndex.setAbstractFolderUrl(bluKryptElement.getFileCompletePath());
        searchIndex.setFileName(bluKryptElement.getFileName());
        searchIndex.setFolder(false);
        searchIndex.setSize(String.valueOf(bluKryptElement.getFileSize()));
        searchIndex.setLastModifiedTime(String.valueOf(System.currentTimeMillis()));
        searchIndex.setFsPath(fsPath);
        searchIndex.setMiniCloud(false);
        searchIndex.setUserName(bluKryptElement.getUserName());
        searchIndex.setStatus("ACTIVE");
        searchIndex.setMail(true);
        searchIndex.setDeviceUUID(bluKryptElement.getDeviceUUID());
        searchIndex.setDeviceId(deviceId);
        return searchIndex;
    }

    private void updateStorageUtilization(String cloudName, String batchId, String deviceUUID, List<String> list, FileUploadDetailsElement fileUploadDetailsElement) {
        long pgChunkSize = 0L;
        if (!CollectionUtils.isEmpty(list)) {
            String chunkFolderPath = this.getUploadFilePath(deviceUUID, cloudName, batchId);
            chunkFolderPath = chunkFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            for (String chunkName : list) {
                try {
                    File file = new File(chunkFolderPath + chunkName).getAbsoluteFile();
                    pgChunkSize += file.length() / 1024L;
                }
                catch (Exception e) {
                    logger.debug(".......Exception...." + e.getMessage());
                }
            }
        }
        logger.debug("..................total pgChunkSizeInKB............" + pgChunkSize);
        this.utilService.updateStorageUtilized(1, deviceUUID, fileUploadDetailsElement.getFileSize(), fileUploadDetailsElement.getLatestVersionSize(), pgChunkSize);
    }

    private void updateMailStorageUtilization(String deviceUUID, FileUploadDetailsElement fileUploadDetailsElement) {
        long pgChunkSize = fileUploadDetailsElement.getFileSize();
        logger.debug("..................total pgChunkSizeInKB............" + pgChunkSize);
        this.utilService.updateStorageUtilized(1, deviceUUID, fileUploadDetailsElement.getFileSize(), fileUploadDetailsElement.getLatestVersionSize(), pgChunkSize);
    }

    public static String getPropertyFileValueParabluFolderBasePath(String cloudName) {
        return PCHelperConstant.getPropertyFileValueParacloudMountPoint() + cloudName + "/f/";
    }

    public static String getFsPath(String md5) {
        SimpleDateFormat sdfDate = new SimpleDateFormat("dd-MM-yyyy");
        Date date = new Date();
        String baseFolder = sdfDate.format(date) + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + String.valueOf(date.getTime());
        String fileName = md5;
        return baseFolder + fileName;
    }

    @Override
    public void removeDriveItem(String driveFileInfoId, boolean isMail) {
        this.uploadService.removeFileInfoForAlreadyExists(driveFileInfoId, isMail);
    }

    public boolean initialize() {
        boolean success = true;
        if (CloudBackupController.getContext() == null) {
            logger.info("Application context not set!");
            return false;
        }
        try {
            if (this.backupService == null) {
                this.backupService = (BackupService)CloudBackupController.getContext().getBean("BackupServiceImpl", BackupService.class);
                if (this.backupService == null) {
                    success = false;
                    logger.error("failed to get backupService");
                }
            }
            if (this.utilService == null) {
                this.utilService = (UtilService)CloudBackupController.getContext().getBean("UtilServiceImpl", UtilService.class);
                if (this.utilService == null) {
                    success = false;
                    logger.error("failed to get utilService");
                }
            }
            if (this.uploadService == null) {
                this.uploadService = (UploadService)CloudBackupController.getContext().getBean("UploadService", UploadService.class);
                if (this.uploadService == null) {
                    success = false;
                    logger.error("failed to get chunkableUploadService");
                }
            }
            if (this.chunkableUploadService == null) {
                this.chunkableUploadService = (ChunkableUploadService)CloudBackupController.getContext().getBean("ChunkableUploadService", ChunkableUploadService.class);
                if (this.chunkableUploadService != null) {
                    success = false;
                    logger.error("failed to get chunkableUploadService");
                }
            }
            if (this.componentSettingService == null) {
                this.componentSettingService = (ComponentSettingService)CloudBackupController.getContext().getBean("ComponentSettingServiceImpl", ComponentSettingService.class);
                if (this.componentSettingService == null) {
                    success = false;
                    logger.error("failed to get componentSettingService");
                }
            }
            if (this.jobConfigService == null) {
                this.jobConfigService = (JobConfigService)CloudBackupController.getContext().getBean("JobConfigServiceImpl", JobConfigService.class);
                if (this.jobConfigService == null) {
                    success = false;
                    logger.error("failed to get jobConfigService");
                }
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            e.printStackTrace(System.out);
            success = false;
        }
        return success;
    }

    @Override
    public void run() {
        try {
            logger.info("Invoking storage service!");
            try {
                sem.acquire(1);
            }
            catch (InterruptedException e) {
                logger.error("Failed to acquire semaphore! ", (Throwable)e);
            }
            Thread.sleep(100L);
            logger.info("Invoking storage service!");
            if (!StorageService.GETINST.initialize(this, this.utilService, this.componentSettingService, this.jobConfigService)) {
                logger.error("Failed to init storage service!");
                return;
            }
            if (!OfficeRestoreService.GETINST.initialize(this, this.utilService, this.syncDownloadService, this.downloadService)) {
                logger.error("Failed to init OfficeRestoreService  service!");
                return;
            }
            StorageService.GETINST.run();
            OfficeRestoreService.GETINST.run();
            logger.info("^^^^^^^^^^^^^^DONE^^^^^^^^^^^^^^^^^^^");
        }
        catch (InterruptedException e) {
            logger.error("Woke up!", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Something bad happened while executing test", (Throwable)e);
        }
    }

    private double getUsedPercentage(String driveId) {
        Drive oneDrive = this.getGraphClient().drives(driveId).buildRequest(new Option[0]).get();
        long remaining = oneDrive.quota.remaining;
        long total = oneDrive.quota.total;
        double percentage = (double)remaining / (double)total * 100.0;
        double usedPercent = 100.0 - percentage;
        return usedPercent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    UploadStatus uploadAsync(UploadStatus status, Map<String, Object> fileProperties) {
        long fileSize = 0L;
        Cloud cloud = this.utilService.getCloud(1);
        String currentUploadIPToUse = PCHelperConstant.getComponentName();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("gatewayName", currentUploadIPToUse);
        parameters.put("dedupifiedBackupId", "false");
        parameters.put("maxVersions", String.valueOf("10"));
        parameters.put("is-base-folder", String.valueOf(false));
        parameters.put("is-folder", String.valueOf(false));
        parameters.put("is-exists", String.valueOf(true));
        String batchId = (String)fileProperties.get("backupBatchId");
        parameters.put("backupBatchId", batchId);
        parameters.put("userUnderLegalHold", String.valueOf(true));
        parameters.put("userName", (String)fileProperties.get("userName"));
        String deviceUUID = (String)fileProperties.get("deviceUUID");
        parameters.put("deviceUUID", deviceUUID);
        parameters.put("file-path", (String)fileProperties.get("file-path"));
        parameters.put("file-name", (String)fileProperties.get("file-name"));
        parameters.put("driveFileInfoId", (String)fileProperties.get("driveFileInfoId"));
        String messageId = (String)fileProperties.get("itemID");
        parameters.put("odItemId", messageId);
        logger.debug(".... parent id set for parameter.... " + fileProperties.get("parentItemID"));
        if (fileProperties.get("parentItemID") != null) {
            parameters.put("parentItemID", (String)fileProperties.get("parentItemID"));
        }
        String cloudName = cloud.getCloudName();
        parameters.put("cloudName", cloudName);
        parameters.put("prevGatewayName", currentUploadIPToUse);
        parameters.put("osType", "Android");
        parameters.put("restartId", String.valueOf(0));
        parameters.put("isFullBackup", Boolean.valueOf(fileProperties.get("isFullBackup").toString()).toString());
        Boolean isMail = Boolean.valueOf(fileProperties.get("isMail").toString());
        Boolean isContact = Boolean.valueOf(fileProperties.get("isContact").toString());
        Boolean isTasks = Boolean.valueOf(fileProperties.get("isTasks").toString());
        Boolean isInPlaceArchive = Boolean.valueOf(fileProperties.get("isInPlaceArchive").toString());
        parameters.put("cloudName", cloudName);
        parameters.put("o365LastModifiedTime", Long.valueOf(fileProperties.get("o365LastModifiedTime").toString()).toString());
        File tempFilePath = null;
        logger.debug("....deviceUUID available... " + deviceUUID);
        String accessToken = "";
        isContact = false;
        if (isContact.booleanValue()) {
            return this.downloadContacts(fileProperties, cloud, parameters, batchId, deviceUUID, messageId, cloudName, tempFilePath, accessToken, status);
        }
        if (isTasks.booleanValue()) {
            Object jsonObject;
            logger.debug("...inside tasks...... ");
            logger.debug(messageId + "..... tasks uppload...." + fileProperties.get("graphUserId"));
            GraphServiceClient<Request> graphClient = this.getGraphClient();
            String graphuserId = (String)fileProperties.get("graphUserId");
            String downloadurl = "https://graph.microsoft.com/beta/users/" + graphuserId + "/outlook/tasks/" + messageId;
            String deltaLinkForNext = "";
            String taskId = "";
            String taskSubject = "";
            Date taskStartDate = null;
            Date taskDueDate = null;
            Date taskReminderTime = null;
            JSONObject taskObject = new JSONObject();
            try {
                String deltaLink = "";
                CloseableHttpClient client = HttpClientBuilder.create().build();
                HttpGet httpGet = new HttpGet(downloadurl);
                httpGet.addHeader("Accept", "application/json");
                httpGet.addHeader("Authorization", "Bearer " + accessToken);
                httpGet.addHeader("Prefer", "odata.maxpagesize=20");
                HttpResponse response = client.execute((HttpUriRequest)httpGet);
                int statusCode = response.getStatusLine().getStatusCode();
                logger.debug(" tasks Response Code : " + statusCode);
                if (statusCode == 200) {
                    String json = EntityUtils.toString((HttpEntity)response.getEntity());
                    jsonObject = new JSONObject(json);
                    if (!StringUtils.isEmpty((Object)json)) {
                        logger.debug("..obj..." + jsonObject);
                        taskId = jsonObject.optString("id");
                        taskStartDate = this.getDateVal(jsonObject.optString("startDateTime"));
                        taskDueDate = this.getDateVal(jsonObject.optString("dueDateTime"));
                        taskReminderTime = this.getDateVal(jsonObject.optString("reminderDateTime"));
                        taskSubject = jsonObject.optString("subject");
                        parameters.put("taskStartDate", taskStartDate);
                        parameters.put("taskDueDate", taskDueDate);
                        parameters.put("taskReminderTime", taskReminderTime);
                        parameters.put("taskSubject", taskSubject);
                    }
                    taskObject = jsonObject;
                }
            }
            catch (Exception e) {
                logger.error("....error trying to get tasks....." + e.getMessage());
            }
            logger.debug(taskSubject + ".....tasks after...." + fileProperties.get("userName") + "......" + taskDueDate);
            LinkedList<String> empty = new LinkedList<String>();
            String md5val = "task";
            parameters.put("fileMD5", md5val);
            parameters.put("file-name", taskSubject);
            OfficeBackupPolicy officeBackupPolicy = this.uploadService.getOfficeBackupPolicyForUser(cloud.getCloudId(), (String)fileProperties.get("userName"));
            parameters.put("graphUserId", graphuserId);
            try {
                tempFilePath = this.createFileInBackupPath(parameters, cloudName, (String)fileProperties.get("file-name") + ".tmp", true);
                File temp = new File(tempFilePath.getAbsolutePath());
                parameters.put("modified", String.valueOf(temp.lastModified()));
            }
            catch (IOException e) {
                logger.error("..error trying to create msg ..." + e.getMessage(), (Throwable)e);
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(taskObject.toString().getBytes());
            logger.debug(tempFilePath.getAbsolutePath() + "................." + inputStream);
            Path target = Paths.get(tempFilePath.getAbsolutePath(), new String[0]);
            try {
                Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException json) {
                // empty catch block
            }
            try {
                FileInputStream is = new FileInputStream(tempFilePath);
                jsonObject = null;
                try {
                    UploadStatus uploadStatus;
                    try {
                        String md5 = MD5Generator.generateMD5OfFile((File)new File(tempFilePath.getAbsolutePath()));
                        logger.debug(tempFilePath.getAbsolutePath() + "...md5 value calculation after downloadingmai..... " + md5);
                        parameters.put("fileMD5", md5);
                    }
                    catch (Exception e) {
                        logger.error("MD5 computation failed", (Throwable)e);
                    }
                    parameters.put("file-size", String.valueOf(Files.size(tempFilePath.toPath())));
                    fileSize = Files.size(tempFilePath.toPath());
                    int statusval = this.uploadTasks(parameters, is, 1, empty, cloud, officeBackupPolicy);
                    logger.debug("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
                    logger.debug(".....Tasks............" + parameters.get("file-size"));
                    fileProperties.put("file-size", parameters.get("file-size"));
                    boolean isSuccess = false;
                    if (statusval == 200) {
                        isSuccess = true;
                    }
                    UploadStatus uploadStatus2 = uploadStatus = new UploadStatus(messageId, isSuccess, statusval, fileSize);
                    return uploadStatus2;
                }
                catch (Throwable statusval) {
                    jsonObject = statusval;
                    throw statusval;
                }
                finally {
                    if (is != null) {
                        if (jsonObject != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)jsonObject).addSuppressed(throwable);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("Failed to get the file in right path!", (Throwable)e);
                return status;
            }
        }
        if (isInPlaceArchive.booleanValue()) {
            block216: {
                logger.debug(messageId + "..... isInPlaceArchive...." + fileProperties.get("graphUserId"));
                try {
                    logger.debug(fileProperties.get("file-name") + "..... mail uppload...." + fileProperties.get("graphUserId"));
                    LinkedList<String> empty = new LinkedList<String>();
                    String graphuserId = (String)fileProperties.get("graphUserId");
                    String userMailId = (String)fileProperties.get("userMailId");
                    String token = (String)fileProperties.get("token");
                    logger.debug(".....ews token ... " + token);
                    ExchangeService service = CloudBackupController.getAuthenticatedService(token, userMailId);
                    logger.debug("...user mail id value ..... " + userMailId);
                    EmailMessage item = null;
                    try {
                        ItemId itemId = new ItemId(messageId);
                        item = EmailMessage.bind((ExchangeService)service, (ItemId)itemId);
                    }
                    catch (Exception e) {
                        logger.error("...unable to get mail.... " + e.getMessage());
                        try {
                            if (e.getMessage().contains("401")) {
                                logger.debug("...ews401...");
                                int statusval = 401;
                                return new UploadStatus(messageId, false, statusval, 0L);
                            }
                            logger.debug("...wait and retry failed mails..." + fileProperties.get("file-path") + "...subj..." + fileProperties.get("file-name"));
                            Thread.sleep(60000L);
                            ItemId itemId = new ItemId(messageId);
                            item = EmailMessage.bind((ExchangeService)service, (ItemId)itemId);
                        }
                        catch (Exception ee) {
                            logger.error("...unable to get mail.... " + e.getMessage());
                            int statusval = 234;
                            return new UploadStatus(messageId, false, statusval, 0L);
                        }
                    }
                    try {
                        String md5 = "mail";
                        parameters.put("fileMD5", md5);
                    }
                    catch (Exception e) {
                        logger.error("MD5 computation failed", (Throwable)e);
                    }
                    parameters.put("file-name", item.getSubject());
                    logger.debug("....itemmessage ..... " + item.getSubject());
                    parameters.put("ewsId", item.getId().getUniqueId());
                    parameters.put("subject", item.getSubject());
                    if (!StringUtils.isEmpty((Object)item.getFrom())) {
                        parameters.put("from", item.getFrom().getName());
                        parameters.put("fromAddr", item.getFrom().getAddress());
                        OutlookEmailAddress senderEmail = new OutlookEmailAddress();
                        senderEmail.setAddress(item.getFrom().getAddress());
                        senderEmail.setName(item.getFrom().getName());
                        parameters.put("fromEmailAddress", senderEmail);
                    }
                    parameters.put("bodyContent", item.getBody().toString());
                    String cccRecipients = "";
                    String ccRecipientsAddr = "";
                    ArrayList<OutlookEmailAddress> ccMails = new ArrayList<OutlookEmailAddress>();
                    StringJoiner emailAddressSJ = new StringJoiner(",");
                    StringJoiner emailNameSJ = new StringJoiner(",");
                    if (!StringUtils.isEmpty((Object)item.getCcRecipients())) {
                        List ccList = item.getCcRecipients().getItems();
                        for (EmailAddress ccRec : ccList) {
                            emailNameSJ.add(ccRec.getName());
                            emailAddressSJ.add(ccRec.getAddress());
                            OutlookEmailAddress ccEmail = new OutlookEmailAddress();
                            ccEmail.setAddress(ccRec.getAddress());
                            ccEmail.setName(ccRec.getName());
                            ccMails.add(ccEmail);
                        }
                        cccRecipients = emailNameSJ.toString();
                        ccRecipientsAddr = emailAddressSJ.toString();
                    }
                    parameters.put("ccRecipients", cccRecipients);
                    parameters.put("ccRecipientsAddr", ccRecipientsAddr);
                    parameters.put("ccRecipientsAddress", ccMails);
                    ArrayList<OutlookEmailAddress> bccMails = new ArrayList<OutlookEmailAddress>();
                    String bccRecipients = "";
                    String bccRecipientsAddr = "";
                    StringJoiner emailBCCAddressSJ = new StringJoiner(",");
                    StringJoiner emailBCCNameSJ = new StringJoiner(",");
                    if (!StringUtils.isEmpty((Object)item.getBccRecipients())) {
                        List bccList = item.getBccRecipients().getItems();
                        for (EmailAddress bccRec : bccList) {
                            emailBCCNameSJ.add(bccRec.getName());
                            emailBCCAddressSJ.add(bccRec.getAddress());
                            OutlookEmailAddress bccEmail = new OutlookEmailAddress();
                            bccEmail.setAddress(bccRec.getAddress());
                            bccEmail.setName(bccRec.getName());
                            bccMails.add(bccEmail);
                        }
                        bccRecipients = emailBCCNameSJ.toString();
                        bccRecipientsAddr = emailBCCAddressSJ.toString();
                    }
                    parameters.put("bccRecipients", bccRecipients);
                    parameters.put("bccRecipientsAddr", bccRecipientsAddr);
                    parameters.put("bccRecipientsAddress", bccMails);
                    ArrayList<OutlookEmailAddress> toMails = new ArrayList<OutlookEmailAddress>();
                    String toRecipients = "";
                    String toRecipientsAddr = "";
                    StringJoiner emailTOAddressSJ = new StringJoiner(",");
                    StringJoiner emailTONameSJ = new StringJoiner(",");
                    if (!StringUtils.isEmpty((Object)item.getToRecipients())) {
                        List toList = item.getToRecipients().getItems();
                        for (EmailAddress toRec : toList) {
                            emailTONameSJ.add(toRec.getName());
                            emailTOAddressSJ.add(toRec.getAddress());
                            OutlookEmailAddress toRecEmail = new OutlookEmailAddress();
                            toRecEmail.setAddress(toRec.getAddress());
                            toRecEmail.setName(toRec.getName());
                            toMails.add(toRecEmail);
                        }
                        toRecipients = emailTONameSJ.toString();
                        toRecipientsAddr = emailTOAddressSJ.toString();
                    }
                    parameters.put("toRecipients", toRecipients);
                    parameters.put("toRecipientsAddr", toRecipientsAddr);
                    parameters.put("toRecipientsAddress", toMails);
                    parameters.put("hasAttachments", item.getHasAttachments());
                    OfficeBackupPolicy officeBackupPolicy = this.uploadService.getOfficeBackupPolicyForUser(cloud.getCloudId(), (String)fileProperties.get("userName"));
                    parameters.put("graphUserId", graphuserId);
                    if (item.getDateTimeSent() != null) {
                        SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                        String date = df2.format(item.getDateTimeSent());
                        parameters.put("sentDate", date);
                    }
                    logger.debug("..attachaaa.." + item.getHasAttachments());
                    boolean fileAllowed = true;
                    ArrayList<MailAttachment> updatedAttachments = new ArrayList<MailAttachment>();
                    if (item.getHasAttachments()) {
                        AttachmentCollection attachments = item.getAttachments();
                        for (microsoft.exchange.webservices.data.property.complex.Attachment attItemAttachment : attachments.getItems()) {
                            try {
                                logger.debug("... attachments available... " + attItemAttachment.getName());
                                String attachId = attItemAttachment.getId();
                                String attachname = attItemAttachment.getName();
                                boolean skipFileBasedonSize = CloudBackupController.checkFileSize(Long.valueOf(attItemAttachment.getSize()), Long.parseLong(officeBackupPolicy.getMailMaxFileSize()));
                                logger.debug("...check skip attachments because of size ..." + skipFileBasedonSize);
                                if (skipFileBasedonSize || !fileAllowed) continue;
                                boolean extcheck = this.checkForExtensions(attachname, officeBackupPolicy.getMailInclusionFilter(), officeBackupPolicy.getMailFilterType());
                                if (!StringUtils.isEmpty((Object)attachname) && (attachname = attachname.trim()).contains("/")) {
                                    attachname = attachname.replaceAll("/", "-");
                                }
                                if (StringUtils.isEmpty((Object)attachname)) continue;
                                logger.debug(extcheck + "...EXTCHECK...." + attachname);
                                fileAllowed = extcheck;
                                if (!extcheck) continue;
                                MailAttachment mailAttachment = new MailAttachment();
                                mailAttachment.setId(attItemAttachment.getId());
                                mailAttachment.setName(attItemAttachment.getName());
                                mailAttachment.setSize(Integer.valueOf(attItemAttachment.getSize()));
                                mailAttachment.setContentType(attItemAttachment.getContentType());
                                ArrayList<String> chunkFiles = new ArrayList<String>();
                                mailAttachment.setChunkFiles(chunkFiles);
                                chunkFiles.add("checkthisvaluesomethingiswrong.txt");
                                mailAttachment.setChunkFiles(chunkFiles);
                                updatedAttachments.add(mailAttachment);
                            }
                            catch (Exception e) {
                                logger.error("..error trying to get attach..... " + e.getMessage());
                            }
                        }
                        parameters.put("attachments", updatedAttachments);
                    }
                    if (!fileAllowed) {
                        logger.debug("...ext not allowed so exclude...");
                        int statusval = 234;
                        return new UploadStatus(messageId, false, statusval, 0L);
                    }
                    if (CollectionUtils.isEmpty(updatedAttachments)) {
                        parameters.put("hasAttachments", false);
                    }
                    try {
                        tempFilePath = this.createFileInBackupPath(parameters, cloudName, (String)fileProperties.get("file-name") + ".tmp", isMail);
                        File temp = new File(tempFilePath.getAbsolutePath());
                        parameters.put("modified", String.valueOf(temp.lastModified()));
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return new UploadStatus(messageId, false, -1, 0L);
                    }
                    logger.debug(graphuserId + "........before downloadmail........." + messageId);
                    try {
                        PropertySet psPropset = new PropertySet(BasePropertySet.IdOnly);
                        psPropset.add((PropertyDefinitionBase)ItemSchema.MimeContent);
                        item.load(psPropset);
                    }
                    catch (Exception e2) {
                        logger.error("...unalbe to load email with mime content.....");
                        e2.printStackTrace();
                    }
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(item.getMimeContent().getContent());
                    logger.debug(tempFilePath.getAbsolutePath() + "........after download........." + inputStream);
                    Path target = Paths.get(tempFilePath.getAbsolutePath(), new String[0]);
                    try {
                        Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException attItemAttachment) {
                        // empty catch block
                    }
                    try (FileInputStream is = new FileInputStream(tempFilePath);){
                        UploadStatus uploadStatus;
                        try {
                            String md5 = MD5Generator.generateMD5OfFile((File)new File(tempFilePath.getAbsolutePath()));
                            logger.debug(tempFilePath.getAbsolutePath() + "...md5 value calculation after downloadingmai..... " + md5);
                            parameters.put("fileMD5", md5);
                        }
                        catch (Exception e) {
                            logger.error("MD5 computation failed", (Throwable)e);
                        }
                        fileSize = Files.size(tempFilePath.toPath());
                        parameters.put("file-size", String.valueOf(fileSize));
                        BaseController.printLogs("Going to launch read" + parameters.get("ewsId"), PCHelperConstant.isBrevityLogging());
                        int statusval = this.uploadMail(parameters, is, 1, empty, cloud, officeBackupPolicy);
                        logger.debug("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
                        logger.debug(".....MAILSIZEEE............" + parameters.get("file-size"));
                        fileProperties.put("file-size", parameters.get("file-size"));
                        boolean isSuccess = false;
                        if (statusval == 200) {
                            isSuccess = true;
                        }
                        try {
                            if (service != null) {
                                service.close();
                            }
                        }
                        catch (Exception e) {
                            logger.debug("...unable to close connection....");
                        }
                        UploadStatus uploadStatus3 = uploadStatus = new UploadStatus(messageId, isSuccess, statusval, fileSize);
                        return uploadStatus3;
                    }
                    catch (Exception e) {
                        logger.error("Failed to get the file in right path!", (Throwable)e);
                    }
                }
                catch (ClientException e) {
                    logger.error("... mail not found1........." + fileProperties.get("file-name"));
                    return new UploadStatus(messageId, false, 409, 0L);
                }
                catch (ServiceLocalException e2) {
                    logger.error("... mail not found1...ServiceLocalException......" + e2.getMessage());
                    return new UploadStatus(messageId, false, 409, 0L);
                }
                catch (Exception eee) {
                    if (!eee.getMessage().contains("401")) break block216;
                    logger.error("... 401 exception...mail not found1...ServiceLocalException......" + eee.getMessage());
                }
            }
            logger.debug("....completed inplace archive ............");
            return status;
        }
        if (!isMail.booleanValue()) {
            DriveItemContentStreamRequestBuilder content;
            InputStream inputStream;
            block218: {
                String driveId;
                GraphServiceClient<Request> graphClient;
                block217: {
                    logger.debug("...onedrive backup file..");
                    graphClient = this.getGraphClient();
                    String userName = (String)fileProperties.get("userName");
                    com.parablu.pcbd.domain.User user = this.utilService.getUserInfoByName(cloud.getCloudId(), userName);
                    String driveIdVal = "";
                    if (fileProperties.get("driveId") != null) {
                        driveIdVal = (String)fileProperties.get("driveId");
                    }
                    logger.debug("...onedrivedriveid1.." + driveIdVal);
                    driveId = "";
                    driveId = StringUtils.isEmpty((Object)driveIdVal) ? this.getDriveIdForUserMailId(user.getEmailId()) : driveIdVal;
                    logger.debug("...onedrivedriveid2.." + driveId);
                    Object lastModifiedDateTime = null;
                    inputStream = null;
                    content = null;
                    String fileName = (String)fileProperties.get("file-name");
                    try {
                        if ("$$%^&malarefile.txt".equalsIgnoreCase(fileName)) {
                            this.saveFailedFilesReason(cloud.getCloudId(), userName, 403, fileName, (String)fileProperties.get("file-path"), "malwareDetected", deviceUUID, "ONEDRIVE", batchId);
                            return new UploadStatus(messageId, false, 409, 0L);
                        }
                        logger.debug("...onedrive backup file1..");
                        content = graphClient.drives(driveId).items(messageId).content();
                        inputStream = content.buildRequest(new Option[0]).get();
                        logger.debug(messageId + "...onedrive backup file2......." + inputStream);
                        if (inputStream != null) break block217;
                        logger.debug("...retry one more time...." + messageId);
                        content = graphClient.drives(driveId).items(messageId).content();
                        inputStream = content.buildRequest(new Option[0]).get();
                        logger.debug(messageId + "...onedrive backup file2 after retry......." + inputStream);
                        if (inputStream == null) {
                            logger.debug("..stream is null so create zero kb file...");
                            inputStream = IOUtils.toInputStream((String)"   ");
                        }
                    }
                    catch (GraphServiceException e) {
                        logger.error("....unable to get drive .... " + e.getResponseCode());
                        if (e.getResponseCode() == 403) {
                            logger.debug(e.getError().error.message + ".....check for maleware..." + e.getError().error.code);
                            if (e.getError() != null && e.getError().error != null && !StringUtils.isEmpty((Object)e.getError().error.code) && "malwareDetected".equalsIgnoreCase(e.getError().error.code)) {
                                this.saveFailedFilesReason(cloud.getCloudId(), userName, 403, fileName, (String)fileProperties.get("file-path"), "malwareDetected", deviceUUID, "ONEDRIVE", batchId);
                                return new UploadStatus(messageId, false, 409, 0L);
                            }
                        }
                        if (e.getResponseCode() == 429 || e.getResponseCode() == 401) {
                            logger.debug(".... retry .. after 2 mins.. ");
                            try {
                                Thread.sleep(120000L);
                                do {
                                    try {
                                        logger.debug(driveId + "...retry one more time...." + messageId);
                                        content = graphClient.drives(driveId).items(messageId).content();
                                        inputStream = content.buildRequest(new Option[0]).get();
                                        logger.debug(messageId + "...onedrive backup file2 after retry......." + inputStream);
                                    }
                                    catch (GraphServiceException eq) {
                                        if (eq.getResponseCode() != 429) continue;
                                        inputStream = null;
                                        logger.debug("..sleep for 90 sec...");
                                        try {
                                            Thread.sleep(90000L);
                                        }
                                        catch (InterruptedException bccMails) {}
                                    }
                                    catch (ClientException ee) {
                                        inputStream = null;
                                        logger.debug("..sleep for 90 sec...");
                                        try {
                                            Thread.sleep(90000L);
                                        }
                                        catch (InterruptedException bccMails) {
                                            // empty catch block
                                        }
                                    }
                                } while (inputStream == null);
                            }
                            catch (InterruptedException ee) {
                                // empty catch block
                            }
                        }
                        if (e.getResponseCode() == 403) {
                            this.saveBlackListUser(cloud, userName);
                            return new UploadStatus(messageId, false, 403, 0L);
                        }
                        if (e.getResponseCode() != 404) break block217;
                        try {
                            logger.debug(driveId + "...retry 404 driveid.." + messageId);
                            if ("$$%^&malarefile.txt".equalsIgnoreCase(fileName)) {
                                this.saveFailedFilesReason(cloud.getCloudId(), userName, 403, fileName, (String)fileProperties.get("file-path"), "malwareDetected", deviceUUID, "ONEDRIVE", batchId);
                                return new UploadStatus(messageId, false, 409, 0L);
                            }
                            logger.debug(driveId + "...onedrive backup file1 retry.." + messageId);
                            content = graphClient.drives(driveId).items(messageId).content();
                            inputStream = content.buildRequest(new Option[0]).get();
                            logger.debug(messageId + "...onedrive backup file2......." + inputStream);
                            if (inputStream == null) {
                                logger.debug("...retry one more time...." + messageId);
                                content = graphClient.drives(driveId).items(messageId).content();
                                inputStream = content.buildRequest(new Option[0]).get();
                                logger.debug(messageId + "...onedrive backup file2 after retry......." + inputStream);
                            }
                        }
                        catch (GraphServiceException eee) {
                            logger.debug(eee.getResponseCode() + "...unable to get file...." + messageId);
                            return new UploadStatus(messageId, false, 555, 0L);
                        }
                    }
                    catch (ClientException ee) {
                        this.sleep5sec();
                        graphClient = this.getGraphClient();
                        logger.debug("...onedrive backup file1..");
                        content = graphClient.drives(driveId).items(messageId).content();
                        inputStream = content.buildRequest(new Option[0]).get();
                        logger.debug("...onedrive backup file2..");
                    }
                }
                try {
                    tempFilePath = this.createFileInBackupPath(parameters, cloudName, (String)fileProperties.get("file-name") + System.currentTimeMillis() + ".tmp", isMail);
                    File temp = new File(tempFilePath.getAbsolutePath());
                    parameters.put("modified", String.valueOf(temp.lastModified()));
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return new UploadStatus(messageId, false, -1, 0L);
                }
                logger.debug(tempFilePath.getAbsolutePath() + "................." + inputStream);
                Path target = Paths.get(tempFilePath.getAbsolutePath(), new String[0]);
                if (!Files.exists(target, LinkOption.NOFOLLOW_LINKS)) {
                    logger.error("....unable to download file....");
                    return new UploadStatus(messageId, false, -1, 0L);
                }
                try {
                    Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
                    inputStream.close();
                }
                catch (Exception e1) {
                    logger.error("....unable to download file...." + e1.getMessage());
                    boolean fileDownloadedSuccessfully = false;
                    do {
                        try {
                            logger.debug(driveId + "...retry one more time...." + messageId);
                            content = graphClient.drives(driveId).items(messageId).content();
                            inputStream = content.buildRequest(new Option[0]).get();
                            logger.debug(messageId + "...onedrive backup file2 after retry......." + inputStream);
                            Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
                            inputStream.close();
                            fileDownloadedSuccessfully = true;
                        }
                        catch (GraphServiceException e) {
                            if (e.getResponseCode() != 429) continue;
                            inputStream = null;
                            logger.debug("..sleep for 90 sec...");
                            try {
                                Thread.sleep(90000L);
                            }
                            catch (InterruptedException bccRecipientsAddr) {}
                        }
                        catch (IOException e) {
                            inputStream = null;
                        }
                    } while (inputStream == null);
                    if (fileDownloadedSuccessfully) break block218;
                    return new UploadStatus(messageId, false, -1, 0L);
                }
            }
            LinkedList<String> empty = new LinkedList<String>();
            try (FileInputStream is = new FileInputStream(tempFilePath);){
                UploadStatus uploadStatus;
                try {
                    String md5 = MD5Generator.generateMD5OfFile((File)new File(tempFilePath.getAbsolutePath()));
                    logger.debug(tempFilePath.getAbsolutePath() + "...md5 value calculation after downloading..... " + md5);
                    parameters.put("fileMD5", md5);
                }
                catch (Exception e) {
                    logger.error("MD5 computation failed", (Throwable)e);
                }
                fileSize = Files.size(tempFilePath.toPath());
                parameters.put("file-size", String.valueOf(Files.size(tempFilePath.toPath())));
                parameters.put("o365LastModifiedTime", (Long)fileProperties.get("o365LastModifiedTime"));
                logger.debug("Going to launch read ss..." + fileProperties.get("o365LastModifiedTime"));
                int statusval = this.upload(parameters, is, 1, empty, cloud);
                logger.debug("^^^^^^^^^^^^^^^^^^^^status for onedrive^^^^^^^^^^^^^^^^^^^^^" + statusval);
                boolean isSuccess = false;
                if (statusval == 200) {
                    isSuccess = true;
                }
                if (tempFilePath.exists()) {
                    tempFilePath.delete();
                }
                inputStream.close();
                content = null;
                UploadStatus toMails = uploadStatus = new UploadStatus(messageId, isSuccess, statusval, fileSize);
                return toMails;
            }
            catch (Exception e) {
                logger.error("Failed to get the file in right path!", (Throwable)e);
                return status;
            }
        }
        try {
            List listAttachments;
            AttachmentCollectionPage AttachmentCollectionPage2;
            logger.debug(fileProperties.get("file-name") + "..... mail uppload...." + fileProperties.get("graphUserId"));
            LinkedList<String> empty = new LinkedList<String>();
            GraphServiceClient<Request> graphClient = this.getGraphClient();
            String graphuserId = (String)fileProperties.get("graphUserId");
            Message message = null;
            int count = 0;
            int maxTries = 5;
            while (true) {
                try {
                    logger.debug(messageId + "...trying for time..." + count + "..." + maxTries);
                    message = graphClient.users(graphuserId).messages(messageId).buildRequest(new Option[0]).get();
                }
                catch (GraphServiceException e) {
                    logger.error("... error response codecheck .... " + e.getResponseCode());
                    if (e.getResponseCode() == 404) {
                        return new UploadStatus(messageId, false, 555, 0L);
                    }
                    if (e.getResponseCode() != 429 && e.getResponseCode() != 401) continue;
                    logger.debug(".... retry .. after 2 mins.. ");
                    try {
                        Thread.sleep(120000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    while (true) {
                        try {
                            message = graphClient.users(graphuserId).messages(messageId).buildRequest(new Option[0]).get();
                        }
                        catch (GraphServiceException ee) {
                            logger.error("... error response codecheck .... " + ee.getResponseCode());
                            if (ee.getResponseCode() != 429 && ee.getResponseCode() != 401) continue;
                            logger.debug(".... retry .. after 2 mins.. ");
                            try {
                                Thread.sleep(120000L);
                                continue;
                            }
                            catch (InterruptedException e1) {
                                e1.printStackTrace();
                            }
                            if (message != null) continue;
                        }
                        break;
                    }
                    continue;
                }
                catch (Exception ex) {
                    logger.error("...retry error new...." + ex.getMessage());
                    if (ex != null && !StringUtils.isEmpty((Object)ex.getMessage())) {
                        if (ex.getMessage().contains("Error code: ErrorItemNotFound")) return new UploadStatus(messageId, false, 555, 0L);
                        if (ex.getMessage().contains("Error code: ResourceNotFound")) {
                            return new UploadStatus(messageId, false, 555, 0L);
                        }
                    }
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException uploadStatus) {
                        // empty catch block
                    }
                    logger.error(graphuserId + "..slept for 3 secs ....unable to get mail general.... " + messageId);
                    graphClient = this.getGraphClient();
                    if (++count == maxTries) break;
                    continue;
                }
                break;
            }
            if (message == null) {
                int statusval = 234;
                return new UploadStatus(messageId, false, statusval, 0L);
            }
            try {
                String md5 = "mail";
                parameters.put("fileMD5", md5);
            }
            catch (Exception e) {
                logger.error("MD5 computation failed", (Throwable)e);
            }
            String subject = message.subject;
            if (StringUtils.isEmpty((Object)subject)) {
                subject = "(No subject)";
            }
            logger.debug(".....Subject....." + subject);
            parameters.put("file-name", subject);
            LinkedList<String> inputIdsList = new LinkedList<String>();
            ExchangeIdFormat sourceIdType = ExchangeIdFormat.REST_ID;
            ExchangeIdFormat targetIdType = ExchangeIdFormat.EWS_ID;
            inputIdsList.add(messageId);
            UserTranslateExchangeIdsParameterSet exchangeIdsParameterSet = new UserTranslateExchangeIdsParameterSet();
            exchangeIdsParameterSet.inputIds = inputIdsList;
            exchangeIdsParameterSet.targetIdType = targetIdType;
            exchangeIdsParameterSet.sourceIdType = sourceIdType;
            UserTranslateExchangeIdsCollectionPage post = (UserTranslateExchangeIdsCollectionPage)((UserTranslateExchangeIdsCollectionRequest)graphClient.users(graphuserId).translateExchangeIds(exchangeIdsParameterSet).buildRequest(new Option[0])).post();
            List convertedIdPages = post.getCurrentPage();
            String ewsId = "";
            for (ConvertIdResult convertIdResult : convertedIdPages) {
                logger.debug(inputIdsList.size() + "...converted ewsidsss ...." + convertIdResult.targetId);
                ewsId = convertIdResult.targetId;
            }
            parameters.put("ewsId", ewsId);
            parameters.put("subject", subject);
            if (message.from != null) {
                parameters.put("from", message.from.emailAddress.name);
                parameters.put("fromAddr", message.from.emailAddress.address);
                OutlookEmailAddress senderEmail = new OutlookEmailAddress();
                senderEmail.setAddress(message.from.emailAddress.address);
                senderEmail.setName(message.from.emailAddress.name);
                parameters.put("fromEmailAddress", senderEmail);
            }
            parameters.put("bodyContent", message.body.content);
            parameters.put("receivedDateTime", message.receivedDateTime.toInstant().toEpochMilli());
            if (!StringUtils.isEmpty((Object)message.sentDateTime)) {
                parameters.put("sentDateTime", message.sentDateTime.toInstant().toEpochMilli());
            }
            String cccRecipients = "";
            String ccRecipientsAddr = "";
            ArrayList<OutlookEmailAddress> ccMails = new ArrayList<OutlookEmailAddress>();
            if (message.ccRecipients != null) {
                try {
                    cccRecipients = message.ccRecipients.stream().map(a -> String.valueOf(a.emailAddress.name)).collect(Collectors.joining(","));
                }
                catch (Exception toRecipients) {
                    // empty catch block
                }
                try {
                    ccRecipientsAddr = message.ccRecipients.stream().map(a -> String.valueOf(a.emailAddress.address)).collect(Collectors.joining(","));
                }
                catch (Exception toRecipients) {
                    // empty catch block
                }
                for (Recipient ccRec : message.ccRecipients) {
                    OutlookEmailAddress ccEmail = new OutlookEmailAddress();
                    ccEmail.setAddress(ccRec.emailAddress.address);
                    ccEmail.setName(ccRec.emailAddress.name);
                    ccMails.add(ccEmail);
                }
            }
            parameters.put("ccRecipients", cccRecipients);
            parameters.put("ccRecipientsAddr", ccRecipientsAddr);
            parameters.put("ccRecipientsAddress", ccMails);
            ArrayList<OutlookEmailAddress> bccMails = new ArrayList<OutlookEmailAddress>();
            List bccRecipientsCol = message.bccRecipients;
            String bccRecipients = "";
            String bccRecipientsAddr = "";
            if (bccRecipientsCol != null) {
                try {
                    bccRecipients = bccRecipientsCol.stream().map(a -> String.valueOf(a.emailAddress.name)).collect(Collectors.joining(","));
                }
                catch (Exception officeBackupPolicy) {
                    // empty catch block
                }
                try {
                    bccRecipientsAddr = bccRecipientsCol.stream().map(a -> String.valueOf(a.emailAddress.address)).collect(Collectors.joining(","));
                }
                catch (Exception officeBackupPolicy) {
                    // empty catch block
                }
                for (Recipient bccRec : bccRecipientsCol) {
                    OutlookEmailAddress bccEmail = new OutlookEmailAddress();
                    bccEmail.setAddress(bccRec.emailAddress.address);
                    bccEmail.setName(bccRec.emailAddress.name);
                    bccMails.add(bccEmail);
                }
            }
            parameters.put("bccRecipients", bccRecipients);
            parameters.put("bccRecipientsAddr", bccRecipientsAddr);
            parameters.put("bccRecipientsAddress", bccMails);
            ArrayList<OutlookEmailAddress> toMails = new ArrayList<OutlookEmailAddress>();
            List toRecipientsCol = message.toRecipients;
            String toRecipients = "";
            String toRecipientsAddr = "";
            if (toRecipientsCol != null) {
                try {
                    toRecipients = toRecipientsCol.stream().map(a -> String.valueOf(a.emailAddress.name)).collect(Collectors.joining(","));
                }
                catch (Exception target) {
                    // empty catch block
                }
                try {
                    toRecipientsAddr = toRecipientsCol.stream().map(a -> String.valueOf(a.emailAddress.address)).collect(Collectors.joining(","));
                }
                catch (Exception target) {
                    // empty catch block
                }
                for (Recipient toRec : toRecipientsCol) {
                    OutlookEmailAddress toEmail = new OutlookEmailAddress();
                    toEmail.setAddress(toRec.emailAddress.address);
                    toEmail.setName(toRec.emailAddress.name);
                    toMails.add(toEmail);
                }
            }
            parameters.put("toRecipients", toRecipients);
            parameters.put("toRecipientsAddr", toRecipientsAddr);
            parameters.put("toRecipientsAddress", toMails);
            parameters.put("hasAttachments", (boolean)message.hasAttachments);
            OfficeBackupPolicy officeBackupPolicy = this.uploadService.getOfficeBackupPolicyForUser(cloud.getCloudId(), (String)fileProperties.get("userName"));
            parameters.put("graphUserId", graphuserId);
            if (message.sentDateTime != null && message.sentDateTime.toInstant() != null) {
                SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                String date = df2.format(message.sentDateTime.toInstant().toEpochMilli());
                parameters.put("sentDate", date);
            }
            logger.debug("..attachaaa.." + message.hasAttachments);
            String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, batchId);
            boolean fileAllowed = true;
            ArrayList<MailAttachment> updatedAttachments = new ArrayList<MailAttachment>();
            if (message.hasAttachments != null && message.hasAttachments.booleanValue() && (AttachmentCollectionPage2 = (AttachmentCollectionPage)((AttachmentCollectionRequest)graphClient.users(graphuserId).messages(messageId).attachments().buildRequest(new Option[0])).get()) != null && !CollectionUtils.isEmpty((Collection)(listAttachments = AttachmentCollectionPage2.getCurrentPage()))) {
                for (Attachment attachment : listAttachments) {
                    try {
                        Attachment attachmentObj = null;
                        do {
                            try {
                                attachmentObj = graphClient.users(graphuserId).messages(messageId).attachments(attachment.id).buildRequest(new Option[0]).get();
                            }
                            catch (ClientException ee) {
                                logger.error("..error trying to  get attachment obj wait for 5 secs....");
                                Thread.sleep(5000L);
                                attachmentObj = null;
                            }
                        } while (attachmentObj == null);
                        logger.debug("... attachments available... " + attachmentObj.id);
                        String attachId = attachmentObj.id;
                        String attachname = attachmentObj.name;
                        boolean skipFileBasedonSize = CloudBackupController.checkFileSize((long)attachment.size, Long.parseLong(officeBackupPolicy.getMailMaxFileSize()));
                        logger.debug("...check skip attachments because of size ..." + skipFileBasedonSize);
                        if (skipFileBasedonSize || !fileAllowed) continue;
                        boolean extcheck = this.checkForExtensions(attachname, officeBackupPolicy.getMailInclusionFilter(), officeBackupPolicy.getMailFilterType());
                        if (!StringUtils.isEmpty((Object)attachname) && (attachname = attachname.trim()).contains("/")) {
                            attachname = attachname.replaceAll("/", "-");
                        }
                        if (StringUtils.isEmpty((Object)attachname)) continue;
                        logger.debug(extcheck + "...EXTCHECK...." + attachname);
                        fileAllowed = extcheck;
                        if (!extcheck) continue;
                        String downloadedNameobj = null;
                        do {
                            try {
                                downloadedNameobj = this.downloadAttachment(accessToken, attachId, attachname, graphuserId, messageId, chunkPath, cloudName);
                            }
                            catch (ClientException ee) {
                                logger.error("..error trying to  get downloadedNameobj obj wait for 5 secs....");
                                Thread.sleep(5000L);
                                downloadedNameobj = null;
                            }
                        } while (StringUtils.isEmpty((Object)downloadedNameobj));
                        logger.debug(downloadedNameobj + "........attachu1.........");
                        String[] arrObj = downloadedNameobj.split("~~");
                        String downloadedName = arrObj[0];
                        String fsPath = arrObj[1];
                        logger.debug(downloadedNameobj + "........attachu........." + downloadedName);
                        MailAttachment updatedAttachmentFile = new MailAttachment();
                        BeanUtils.copyProperties((Object)attachment, (Object)updatedAttachmentFile);
                        updatedAttachmentFile.setId(attachment.id);
                        updatedAttachmentFile.setName(attachment.name);
                        updatedAttachmentFile.setSize(attachment.size);
                        updatedAttachmentFile.setContentType(attachment.contentType);
                        ArrayList<String> chunkFiles = new ArrayList<String>();
                        updatedAttachmentFile.setChunkFiles(chunkFiles);
                        chunkFiles.add(downloadedName);
                        updatedAttachmentFile.setChunkFiles(chunkFiles);
                        updatedAttachments.add(updatedAttachmentFile);
                        parameters.put("fileMD5", downloadedName);
                    }
                    catch (Exception e) {
                        logger.error("..error trying to get attach..... " + e.getMessage());
                    }
                }
                parameters.put("attachments", updatedAttachments);
            }
            if (!fileAllowed) {
                logger.debug("...ext not allowed so exclude...");
                int statusval = 234;
                return new UploadStatus(messageId, false, statusval, 0L);
            }
            if (CollectionUtils.isEmpty(updatedAttachments)) {
                parameters.put("hasAttachments", false);
            }
            try {
                tempFilePath = this.createFileInBackupPath(parameters, cloudName, (String)fileProperties.get("file-name") + ".tmp", isMail);
                File temp = new File(tempFilePath.getAbsolutePath());
                parameters.put("modified", String.valueOf(temp.lastModified()));
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return new UploadStatus(messageId, false, -1, 0L);
            }
            logger.debug(graphuserId + "........before downloadmail........." + messageId);
            InputStream inputStream = this.downloadMail(graphuserId, messageId);
            logger.debug(tempFilePath.getAbsolutePath() + "........after download........." + inputStream);
            Path target = Paths.get(tempFilePath.getAbsolutePath(), new String[0]);
            if (!Files.exists(target, LinkOption.NOFOLLOW_LINKS)) {
                logger.error("....unable to download file....");
                return new UploadStatus(messageId, false, -1, 0L);
            }
            try {
                Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try (FileInputStream fileInputStream = new FileInputStream(tempFilePath);){
                UploadStatus uploadStatus;
                try {
                    String md5 = MD5Generator.generateMD5OfFile((File)new File(tempFilePath.getAbsolutePath()));
                    logger.debug(tempFilePath.getAbsolutePath() + "...md5 value calculation after downloadingmai..... " + md5);
                    parameters.put("fileMD5", md5);
                }
                catch (Exception e) {
                    logger.error("MD5 computation failed", (Throwable)e);
                }
                fileSize = Files.size(tempFilePath.toPath());
                parameters.put("file-size", String.valueOf(fileSize));
                logger.debug("Going to launch read" + parameters.get("ewsId"));
                int statusval = this.uploadMail(parameters, fileInputStream, 1, empty, cloud, officeBackupPolicy);
                logger.debug("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
                logger.debug(".....MAILSIZEEE............" + parameters.get("file-size"));
                fileProperties.put("file-size", parameters.get("file-size"));
                boolean isSuccess = false;
                if (statusval == 200) {
                    isSuccess = true;
                }
                if (tempFilePath.exists()) {
                    tempFilePath.delete();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                UploadStatus uploadStatus4 = uploadStatus = new UploadStatus(messageId, isSuccess, statusval, fileSize);
                return uploadStatus4;
            }
            catch (Exception exception) {
                logger.error("Failed to get the file in right path!", (Throwable)exception);
                return status;
            }
        }
        catch (ClientException e) {
            logger.error(e.getMessage() + "... mail not found1........." + fileProperties.get("file-name"));
            return new UploadStatus(messageId, false, 409, 0L);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UploadStatus downloadContacts(Map<String, Object> fileProperties, Cloud cloud, Map<String, Object> parameters, String batchId, String deviceUUID, String messageId, String cloudName, File tempFilePath, String accessToken, UploadStatus status) {
        logger.debug("...inside contacts...... ");
        logger.debug(messageId + "..... contacts uppload...." + fileProperties.get("graphUserId"));
        GraphServiceClient<Request> graphClient = this.getGraphClient();
        String graphuserId = (String)fileProperties.get("graphUserId");
        Contact contact = graphClient.users(graphuserId).contacts(messageId).buildRequest(new Option[0]).get();
        try {
            ProfilePhoto profilePhoto = graphClient.users(graphuserId).contacts(messageId).photo().buildRequest(new Option[0]).get();
            ArrayList<MailAttachment> updatedAttachments = new ArrayList<MailAttachment>();
            if (profilePhoto != null) {
                String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, batchId);
                logger.debug("... profilePhoto available... " + profilePhoto.id);
                String attachId = profilePhoto.id;
                String attachname = "photo";
                String downloadedNameobj = CloudBackupController.downloadPhoto(accessToken, attachId, attachname, graphuserId, messageId, chunkPath, cloudName);
                logger.debug(downloadedNameobj + "........attachu1.........");
                String[] arrObj = downloadedNameobj.split("~~");
                String downloadedName = arrObj[0];
                String fsPath = arrObj[1];
                logger.debug(downloadedNameobj + "........attachu........." + downloadedName);
                MailAttachment updatedAttachmentFile = new MailAttachment();
                updatedAttachmentFile.setId(attachId);
                updatedAttachmentFile.setName(attachname);
                ArrayList<String> chunkFiles = new ArrayList<String>();
                updatedAttachmentFile.setChunkFiles(chunkFiles);
                chunkFiles.add(downloadedName);
                updatedAttachmentFile.setChunkFiles(chunkFiles);
                updatedAttachments.add(updatedAttachmentFile);
                parameters.put("fileMD5", downloadedName);
                parameters.put("hasAttachments", true);
            }
            parameters.put("attachments", updatedAttachments);
        }
        catch (Error eee) {
            logger.error(".. no photo available");
        }
        catch (GraphServiceException ee) {
            if (ee.getResponseCode() != 404) {
                logger.error("...error trying to download photo....." + ee.getMessage());
            }
        }
        catch (Exception eee) {
            logger.error(".. excno photo available" + eee.getMessage());
        }
        logger.debug(".....contacts after...." + fileProperties.get("userName"));
        LinkedList<String> empty = new LinkedList<String>();
        String md5val = "contact";
        parameters.put("fileMD5", md5val);
        parameters.put("file-name", contact.displayName);
        logger.debug(contact.displayName + "...disp..." + contact.mobilePhone);
        parameters.put("contactMobile", contact.mobilePhone);
        parameters.put("contactAddrStreet", contact.homeAddress.street);
        parameters.put("contactAddrCity", contact.homeAddress.city);
        parameters.put("contactAddrState", contact.homeAddress.state);
        parameters.put("contactAddrCountry", contact.homeAddress.countryOrRegion);
        parameters.put("contactAddrPostalCode", contact.homeAddress.postalCode);
        OfficeBackupPolicy officeBackupPolicy = this.uploadService.getOfficeBackupPolicyForUser(cloud.getCloudId(), (String)fileProperties.get("userName"));
        parameters.put("graphUserId", graphuserId);
        try {
            tempFilePath = this.createFileInBackupPath(parameters, cloudName, (String)fileProperties.get("file-name") + ".tmp", true);
            File temp = new File(tempFilePath.getAbsolutePath());
            if (temp.exists()) {
                temp.delete();
            }
            temp.createNewFile();
            parameters.put("modified", String.valueOf(temp.lastModified()));
        }
        catch (IOException e) {
            logger.error("error trying to create new files " + e.getMessage(), (Throwable)e);
        }
        logger.debug("...json-string ... " + contact.oDataType);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(contact.oDataType.getBytes());
        logger.debug(tempFilePath.getAbsolutePath() + "................." + inputStream);
        Path target = Paths.get(tempFilePath.getAbsolutePath(), new String[0]);
        try {
            Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException downloadedNameobj) {
            // empty catch block
        }
        try (FileInputStream is = new FileInputStream(tempFilePath);){
            UploadStatus uploadStatus2;
            try {
                String md5 = MD5Generator.generateMD5OfFile((File)new File(tempFilePath.getAbsolutePath()));
                logger.debug(tempFilePath.getAbsolutePath() + "...md5 value calculation after downloadingmai..... " + md5);
                parameters.put("fileMD5", md5);
            }
            catch (Exception e) {
                logger.error("MD5 computation failed", (Throwable)e);
            }
            long fileSize = Files.size(tempFilePath.toPath());
            parameters.put("file-size", String.valueOf(fileSize));
            int statusval = this.uploadContacts(parameters, is, 1, empty, cloud, officeBackupPolicy);
            logger.debug("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
            logger.debug(".....Contacts............" + parameters.get("file-size"));
            fileProperties.put("file-size", parameters.get("file-size"));
            boolean isSuccess = false;
            if (statusval == 200) {
                isSuccess = true;
            }
            UploadStatus uploadStatus = uploadStatus2 = new UploadStatus(messageId, isSuccess, statusval, fileSize);
            return uploadStatus;
        }
        catch (Exception e) {
            logger.error("Failed to get the file in right path!", (Throwable)e);
            return status;
        }
    }

    private void sleep5sec() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void saveFailedFilesReason(int cloudId, String userName, int responseCode, String fileName, String filePath, String reason, String deviceUUID, String osType, String batchId) {
        FailedFileReason failedFileReason = new FailedFileReason();
        failedFileReason.setUserName(userName);
        failedFileReason.setResponseCode(responseCode);
        failedFileReason.setFileName(fileName);
        failedFileReason.setFilePath(filePath);
        failedFileReason.setOsType(osType);
        failedFileReason.setDeviceUUID(deviceUUID);
        failedFileReason.setReason(reason);
        failedFileReason.setBatchId(batchId);
        this.utilService.saveFailedFilesReason(cloudId, failedFileReason);
    }

    private void saveBlackListUser(Cloud cloud, String userName) {
        O365BlackListUser o365BlackListUser = new O365BlackListUser();
        o365BlackListUser.setUserName(userName);
        o365BlackListUser.setResponseCode("404");
        o365BlackListUser.setLocalHost(PCHelperConstant.getComponentName());
        this.utilService.saveO365BlackListUser(cloud.getCloudId(), o365BlackListUser);
    }

    private boolean checkForExtensions(String fileName, List<InclusionFilter> inclusionFilterList, String filterType) {
        boolean allow = false;
        if (CollectionUtils.isEmpty(inclusionFilterList)) {
            return true;
        }
        HashSet<String> inclusionFilterExtensions = new HashSet<String>();
        HashSet<String> exclusionFilterExtensions = new HashSet<String>();
        boolean allowAllextensions = false;
        for (InclusionFilter inclusionFilter : inclusionFilterList) {
            if (inclusionFilter == null) continue;
            String[] extensions = inclusionFilter.getExtensionName().split(",");
            if (!StringUtils.isEmpty((Object)filterType) && filterType.equalsIgnoreCase("exclusion")) {
                for (String ext : extensions) {
                    ext = ext.toLowerCase();
                    exclusionFilterExtensions.add(ext);
                }
            } else {
                for (String ext : extensions) {
                    ext = ext.toLowerCase();
                    inclusionFilterExtensions.add(ext);
                }
            }
            if (allowAllextensions) continue;
            allowAllextensions = inclusionFilterExtensions.contains("all");
        }
        logger.debug(inclusionFilterExtensions.size() + "....filterlist... " + exclusionFilterExtensions.size());
        for (String ext : inclusionFilterExtensions) {
            logger.debug(".....inclusion list val..." + ext);
        }
        for (String ext : exclusionFilterExtensions) {
            logger.debug(".....exclusion list val..." + ext);
        }
        if (!allowAllextensions) {
            if (exclusionFilterExtensions.size() > 0 && !exclusionFilterExtensions.contains(FilenameUtils.getExtension((String)fileName.toLowerCase()))) {
                allow = true;
            } else if (inclusionFilterExtensions.size() > 0 && inclusionFilterExtensions.contains(FilenameUtils.getExtension((String)fileName.toLowerCase()))) {
                allow = true;
            }
        } else {
            allow = true;
        }
        return allow;
    }

    private Date getDateVal(String dateValue) {
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        try {
            JSONObject dateObj = new JSONObject(dateValue);
            date = simpleDateFormat.parse(dateObj.getString("dateTime").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    private static boolean checkFileSize(Long fileSize, long allowedSize) {
        boolean isFileTobeSkipped = true;
        if (allowedSize != 0L && allowedSize != -1L) {
            long fileSizeinBytes = fileSize;
            float fileSizeinMb = (float)fileSizeinBytes / 1048576.0f;
            if (fileSizeinMb <= (float)allowedSize) {
                isFileTobeSkipped = false;
            }
        } else if (allowedSize == -1L) {
            isFileTobeSkipped = false;
        }
        return isFileTobeSkipped;
    }

    private String downloadAttachment(String accessToken, String attachId, String attachname, String userId, String msgId, String filePath, String cloudName) {
        String downloadurl = "https://graph.microsoft.com/v1.0/users/" + userId + "/messages/" + msgId + "/attachments/" + attachId + "/$value";
        String downloadedName = "";
        try {
            logger.debug("...start download attachment .....");
            String uploadedFileMd5Checksum = MD5Generator.generateMD5OfString((String)(attachname + System.currentTimeMillis()));
            File chunkFile = new File(filePath + "/" + uploadedFileMd5Checksum);
            logger.debug(attachname + "....renamechunk...." + uploadedFileMd5Checksum);
            downloadedName = uploadedFileMd5Checksum;
            String fsPath = CloudBackupController.getFsPath(downloadedName);
            downloadedName = downloadedName + "~~" + fsPath;
            logger.debug(" end of move file to search path" + downloadedName);
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        return downloadedName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String downloadAttachment1(String accessToken, String attachId, String attachname, String userId, String msgId, String filePath, String cloudName) {
        String downloadurl = "https://graph.microsoft.com/v1.0/users/" + userId + "/messages/" + msgId + "/attachments/" + attachId + "/$value";
        String downloadedName = "";
        try {
            logger.debug("...start download attachment .....");
            OkHttpClient okHttpClient = CloudBackupController.getOkHttpClient();
            HttpUrl.Builder httpBuilder = HttpUrl.parse((String)downloadurl).newBuilder();
            Request request = new Request.Builder().url(httpBuilder.build()).build();
            Response response = okHttpClient.newCall(request).execute();
            InputStream inputStream = response.body().byteStream();
            int responseCode = response.code();
            logger.debug("...attachment download responsecode...." + responseCode);
            String fullpath = filePath + "/" + attachname;
            logger.debug("... file PAth...." + fullpath);
            File parent = new File(filePath);
            if (!parent.exists()) {
                parent.mkdirs();
            }
            File file = null;
            try {
                file = new File(fullpath);
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
            }
            catch (Exception e) {
                fullpath = filePath + "/" + System.currentTimeMillis();
                file = new File(fullpath);
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
            }
            byte[] b = new byte[4096];
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            try (FileOutputStream outstream = new FileOutputStream(file);){
                int buff = -1;
                while ((buff = inputStream.read(b)) != -1) {
                    outstream.write(b, 0, buff);
                    md.update(b, 0, buff);
                }
                logger.error(file.getAbsolutePath() + "  tranferFileFromStream > getSizeinMb(intermediateFile.length()) ................ " + CloudBackupController.getSizeinMb(file.length()));
            }
            catch (FileNotFoundException e) {
                logger.error("Exception", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("Exception", (Throwable)e);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Exception While Transfering File From Stream :" + e.getMessage());
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            try {
                response.close();
            }
            catch (Exception e1) {
                logger.error("..unable to close....");
            }
            String uploadedFileMd5Checksum = MD5Generator.generateMD5OfFile((File)file);
            File chunkFile = new File(filePath + "/" + uploadedFileMd5Checksum);
            logger.debug(attachname + "....renamechunk...." + uploadedFileMd5Checksum);
            file.renameTo(chunkFile);
            downloadedName = uploadedFileMd5Checksum;
            String fsPath = CloudBackupController.getFsPath(downloadedName);
            try {
                if (file.exists()) {
                    file.delete();
                }
                if (chunkFile.exists()) {
                    chunkFile.delete();
                }
                downloadedName = downloadedName + "~~" + fsPath;
                logger.debug(" end of move file to search path" + downloadedName);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error(" Error trying to create index file ....... " + e.getMessage());
            }
        }
        catch (ClientProtocolException e) {
            logger.error("Exception", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Exception", (Throwable)e);
        }
        return downloadedName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String downloadPhoto(String accessToken, String attachId, String attachname, String userId, String msgId, String filePath, String cloudName) {
        String downloadurl = "https://graph.microsoft.com/v1.0/users/" + userId + "/contacts/" + msgId + "/photo/$value";
        String downloadedName = "";
        try {
            OkHttpClient okHttpClient = CloudBackupController.getOkHttpClient();
            HttpUrl.Builder httpBuilder = HttpUrl.parse((String)downloadurl).newBuilder();
            Request request = new Request.Builder().url(httpBuilder.build()).build();
            Response response = okHttpClient.newCall(request).execute();
            InputStream inputStream = response.body().byteStream();
            int responseCode = response.code();
            String fullpath = filePath + "/" + attachname;
            logger.debug("... file PAth...." + fullpath);
            File parent = new File(filePath);
            if (!parent.exists()) {
                parent.mkdirs();
            }
            File file = new File(fullpath);
            file.createNewFile();
            byte[] b = new byte[4096];
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            try (FileOutputStream outstream = new FileOutputStream(file);){
                int buff = -1;
                while ((buff = inputStream.read(b)) != -1) {
                    outstream.write(b, 0, buff);
                    md.update(b, 0, buff);
                }
                logger.error(file.getAbsolutePath() + "  tranferFileFromStream > getSizeinMb(intermediateFile.length()) ................ " + CloudBackupController.getSizeinMb(file.length()));
            }
            catch (FileNotFoundException e) {
                logger.error("Exception", (Throwable)e);
                file.delete();
            }
            catch (IOException e) {
                logger.error("Exception", (Throwable)e);
                file.delete();
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Exception While Transfering File From Stream :" + e.getMessage());
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            response.close();
            String uploadedFileMd5Checksum = MD5Generator.generateMD5OfFile((File)file);
            File chunkFile = new File(filePath + "/" + uploadedFileMd5Checksum);
            logger.debug(attachname + "....renamechunk...." + uploadedFileMd5Checksum);
            file.renameTo(chunkFile);
            downloadedName = uploadedFileMd5Checksum;
            String fsPath = CloudBackupController.getFsPath(downloadedName);
            String indexPath = CloudBackupController.getPropertyFileValueParabluFolderBasePath(cloudName) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            logger.debug("...indexpat..." + indexPath);
            try {
                downloadedName = downloadedName + "~~" + fsPath;
                logger.debug(" end of move file to search path" + downloadedName);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error(" Error trying to create index file ....... " + e.getMessage());
            }
        }
        catch (ClientProtocolException e) {
            logger.error("Exception", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Exception", (Throwable)e);
        }
        return downloadedName;
    }

    private InputStream downloadMail(String userId, String msgId) {
        GraphServiceClient<Request> graphClient = this.getGraphClient();
        InputStream inputStream = null;
        try {
            inputStream = graphClient.users(userId).messages(msgId).content().buildRequest(new Option[0]).get();
        }
        catch (GraphServiceException e) {
            logger.error("..codeerrror..." + e.getResponseCode());
            if (e.getResponseCode() == 429) {
                List responseHeaders = e.getResponseHeaders();
                for (String responseHeader : responseHeaders) {
                    logger.debug(responseHeader + "...response hearder....");
                }
            }
        }
        catch (ClientException cli) {
            logger.debug("...client exception  wait for 5 sec and retry... ");
            this.sleep5sec();
            inputStream = this.getGraphClient().users(userId).messages(msgId).content().buildRequest(new Option[0]).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(".....exception trying to download email...." + e.getMessage());
        }
        return inputStream;
    }

    private static InputStream downloadMail(String accessToken, String userId, String msgId) {
        String downloadurl = "https://graph.microsoft.com/v1.0/users/" + userId + "/messages/" + msgId + "/$value";
        InputStream inputStream = null;
        HttpGet httpGet = new HttpGet(downloadurl);
        httpGet.addHeader("Authorization", "Bearer " + accessToken);
        httpGet.addHeader("Accept", "application/json;odata=verbose");
        httpGet.addHeader("Content-Type", "*/*");
        HttpClient httpclient = HttpClientUtil.getSSlConnection();
        try {
            HttpResponse result = httpclient.execute((HttpUriRequest)httpGet);
            int responseCode = result.getStatusLine().getStatusCode();
            logger.debug(" Response status code: " + responseCode);
            inputStream = result.getEntity().getContent();
            System.out.println("...." + inputStream);
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        return inputStream;
    }

    private static InputStream downloadContact(String accessToken, String userId, String contactId) {
        String downloadurl = "https://graph.microsoft.com/v1.0/users/" + userId + "/contacts/" + contactId + "/$value";
        InputStream inputStream = null;
        try {
            OkHttpClient okHttpClient = CloudBackupController.getOkHttpClient();
            HttpUrl.Builder httpBuilder = HttpUrl.parse((String)downloadurl).newBuilder();
            Request request = new Request.Builder().url(httpBuilder.build()).build();
            Response response = okHttpClient.newCall(request).execute();
            inputStream = response.body().byteStream();
            int responseCode = response.code();
            response.close();
            logger.debug(" Response status code: " + responseCode);
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        return inputStream;
    }

    @Override
    public CompletableFuture<UploadStatus> notifyService(Map<String, ? super Object> fileProperties, InputStream buffer) {
        UploadStatus status = new UploadStatus((String)fileProperties.get("messageID"), true, 0, 0L);
        CompletableFuture<UploadStatus> statusWhenDone = new CompletableFuture<UploadStatus>();
        UploadStatus newStatus = this.uploadAsync(status, fileProperties);
        statusWhenDone.complete(newStatus);
        return statusWhenDone;
    }

    @Override
    public List<DriveFileInfo> getDriveFileInfoList(int cloudId) {
        return this.utilService.getDriveFileInfoList();
    }

    @Override
    public void deleteBatchFromOdServer(ObjectId id, String policyName) {
        this.utilService.deleteBatchFromOdServer(id, policyName);
    }

    @Override
    public List<ODBBackupBatch> getODBBatchList(int cloudId, String policyName) {
        return this.utilService.getODBBatchList(policyName);
    }

    @Override
    public List<DriveFileInfo> getDriveFileInfoFromListForBatchId(int cloudId, String batchId) {
        return this.utilService.getDriveFileInfoFromListForBatchId(batchId);
    }

    @Override
    public List<MailBackupBatch> getMailBatchList(int cloudId, String policyName) {
        return this.utilService.getMailBatchList(cloudId, policyName);
    }

    @Override
    public List<RestoreEvents> getRestoreEventsList(int cloudId, String policyName) {
        return this.utilService.getRestoreEventsList(cloudId, policyName);
    }

    @Override
    public long getTotalFilesCountByBatchId(int cloudId, String batchId) {
        return this.utilService.getTotalFilesCountByBatchId(batchId);
    }

    @Override
    public List<DriveFileInfo> getOneDriveFileInfoFromListForBatchId(int cloudId, String batchId) {
        return this.utilService.getOneDriveFileInfoFromListForBatchId(cloudId, batchId);
    }

    public static synchronized String getEWSAccesToken12(EWSAppSetting ewsAppSetting) {
        String accessToken = "";
        try {
            long now = System.currentTimeMillis();
            ExecutorService es = Executors.newFixedThreadPool(2);
            AuthenticationContext context = new AuthenticationContext(AUTHORITY + ewsAppSetting.getTenantId(), false, es);
            AuthenticationCallback<AuthenticationResult> callback = new AuthenticationCallback<AuthenticationResult>(){

                public void onSuccess(AuthenticationResult result) {
                    logger.debug("received token");
                }

                public void onFailure(Throwable exc) {
                    throw new RuntimeException(exc);
                }
            };
            logger.debug("requesting token..val");
            Future future = context.acquireToken(RESOURCE, new ClientCredential(ewsAppSetting.getClientId(), ewsAppSetting.getClientSecretKey()), (AuthenticationCallback)callback);
            logger.debug("requesting token..val1");
            AuthenticationResult result = (AuthenticationResult)future.get(30L, TimeUnit.SECONDS);
            accessToken = result.getAccessToken();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Exception", (Throwable)e);
            logger.debug(".....sleep for 5 secs.....");
            try {
                Thread.sleep(5000L);
                accessToken = CloudBackupController.getEWSAccesToken12(ewsAppSetting);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return accessToken;
    }

    public static ExchangeService getAuthenticatedService(String token, String senderAddr) {
        ExchangeService service = null;
        try {
            service = new ExchangeService(ExchangeVersion.Exchange2010_SP2);
            service.getHttpHeaders().put("Authorization", "Bearer " + token);
            service.getHttpHeaders().put("X-AnchorMailbox", senderAddr);
            service.setUrl(new URI(EWS_URL));
            service.setImpersonatedUserId(new ImpersonatedUserId(ConnectingIdType.PrincipalName, senderAddr));
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        return service;
    }

    @Override
    public void addFailedFiles(DriveFileInfo item, String policyName) {
        this.uploadService.addFailedFiles(item, policyName);
    }

    @Override
    public List<DriveFileInfo> getFailedFiles(String deviceUUID) {
        return this.uploadService.getFailedFiles(deviceUUID);
    }

    @Override
    public List<ODBBackupBatch> getODBBatchList(int cloudId, String policyName, int limit) {
        return this.utilService.getODBBatchList(policyName, limit);
    }

    public static OkHttpClient getOkHttpClient() {
        String authorityHost = "https://login.microsoftonline.com";
        OkHttpClient httpClient = null;
        if (!StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && PCHelperConstant.getProxyPort() != 0) {
            Authenticator proxyAuthenticator = new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)PCHelperConstant.getProxyUserName(), (String)PCHelperConstant.getProxyPassword());
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
            };
            ProxyOptions proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort()));
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).proxyOptions(proxyOptions)).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            httpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort()))).proxyAuthenticator(proxyAuthenticator).build();
        } else {
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            httpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().build();
        }
        return httpClient;
    }

    private GraphServiceClient<Request> getGraphClient() {
        String authorityHost = "https://login.microsoftonline.com";
        logger.debug("...helper constant ...." + PCHelperConstant.getMSClientId());
        GraphServiceClient graphClient = null;
        if (!StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && PCHelperConstant.getProxyPort() != 0) {
            logger.debug("....using proxy latest......");
            InetSocketAddress proxyInetAddress = new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort());
            logger.debug("....using proxy latest before createDefault 1bb......" + PCHelperConstant.getProxyHost() + "..pwd..." + PCHelperConstant.getProxyPort());
            ProxyOptions proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort()));
            HttpClientOptions clientOptions = new HttpClientOptions();
            clientOptions.setProxyOptions(proxyOptions);
            logger.debug("....using proxy latest before createDefault 2a with host latest");
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).proxyOptions(proxyOptions)).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            OkHttpClient httpClient = null;
            Proxy proxy = new Proxy(Proxy.Type.HTTP, proxyInetAddress);
            logger.debug("....using proxy latest before createDefault 3a");
            httpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().proxy(proxy).build();
            logger.debug("....using proxy latest before createDefault 4");
            graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).httpClient((Object)httpClient).buildClient();
            logger.debug("....using proxy latest before createDefault 5");
        } else {
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).buildClient();
        }
        return graphClient;
    }

    private String getDriveIdForUser(Cloud cloud, String emailId) {
        Drive drive = null;
        try {
            com.parablu.pcbd.domain.User user;
            GraphServiceClient<Request> graphClient = this.getGraphClient();
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
            String userId = "";
            for (User userObj : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                userId = userObj.id;
            }
            if (StringUtils.isEmpty((Object)userId)) {
                requestOptions = new ArrayList();
                requestOptions.add(new QueryOption("$filter", (Object)("userPrincipalName eq '" + emailId + "'")));
                iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
                for (User userObj : iUserCollectionPage.getCurrentPage()) {
                    logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                    userId = userObj.id;
                }
            }
            if (StringUtils.isEmpty((Object)userId) && (user = this.utilService.getUserDetailsForEmail(cloud.getCloudId(), emailId)) != null) {
                requestOptions = new ArrayList();
                requestOptions.add(new QueryOption("$filter", (Object)("userPrincipalName eq '" + user.getUserName() + "'")));
                iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
                for (User userObj : iUserCollectionPage.getCurrentPage()) {
                    logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                    userId = userObj.id;
                }
            }
            logger.debug(userId + ".. get drive1 for user given name.... " + emailId);
            int retryDrive = 0;
            do {
                drive = this.getDrive(graphClient, userId);
                logger.debug(++retryDrive + "....drive for user...." + drive);
                Thread.sleep(10000L);
            } while (retryDrive < 5 && drive == null || drive == null);
            if (drive != null) {
                logger.debug(emailId + "....drive id for user ... " + drive.id);
                return drive.id;
            }
        }
        catch (GraphServiceException e) {
            logger.error(" ... error trying to get token ..." + e.getResponseCode());
            if (e.getResponseCode() == 401) {
                logger.debug("..sleep for 90 sec...");
                try {
                    Thread.sleep(90000L);
                    return this.getDriveIdForUser(cloud, emailId);
                }
                catch (InterruptedException interruptedException) {
                }
            } else if (e.getResponseCode() == 404) {
                logger.error("... not able to access resource check right user token is mapped .... " + emailId);
            }
        }
        catch (Exception ee) {
            logger.error(".... exception......" + ee.getMessage());
        }
        return null;
    }

    private Drive getDrive(GraphServiceClient<Request> graphClient, String userId) {
        Drive drive = graphClient.users(userId).drive().buildRequest(new Option[0]).get();
        return drive;
    }

    private Drive getDriveIdForUser(String emailId) {
        Drive drive = null;
        try {
            com.parablu.pcbd.domain.User user;
            GraphServiceClient<Request> graphClient = this.getGraphClient();
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
            String userId = "";
            for (User userObj : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                userId = userObj.id;
            }
            if (StringUtils.isEmpty((Object)userId)) {
                requestOptions = new ArrayList();
                requestOptions.add(new QueryOption("$filter", (Object)("userPrincipalName eq '" + emailId + "'")));
                iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
                for (User userObj : iUserCollectionPage.getCurrentPage()) {
                    logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                    userId = userObj.id;
                }
            }
            if (StringUtils.isEmpty((Object)userId) && (user = this.utilService.getUserDetailsForEmail(1, emailId)) != null) {
                requestOptions = new ArrayList();
                requestOptions.add(new QueryOption("$filter", (Object)("userPrincipalName eq '" + user.getUserName() + "'")));
                iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
                for (User userObj : iUserCollectionPage.getCurrentPage()) {
                    logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                    userId = userObj.id;
                }
            }
            logger.debug(userId + ".. get drive1 for user given name.... " + emailId);
            int retryDrive = 0;
            do {
                drive = this.getDrive(graphClient, userId);
                logger.debug(++retryDrive + "....drive for user...." + drive);
                Thread.sleep(10000L);
            } while (retryDrive < 5 && drive == null || drive == null);
            if (drive != null) {
                logger.debug(emailId + "....drive id for user ... " + drive.id);
                return drive;
            }
        }
        catch (GraphServiceException e) {
            logger.error(" ... error trying to get token ..." + e.getResponseCode());
            if (e.getResponseCode() == 401) {
                logger.debug("..sleep for 90 sec...");
                try {
                    Thread.sleep(90000L);
                    return this.getDriveIdForUser(emailId);
                }
                catch (InterruptedException interruptedException) {
                }
            } else if (e.getResponseCode() == 404) {
                logger.error("... not able to access resource check right user token is mapped .... " + emailId);
            }
        }
        catch (Exception ee) {
            logger.error(".... exception......" + ee.getMessage());
        }
        return drive;
    }

    private double getUsedPercentage(Drive theDrive) {
        long remaining = theDrive.quota.remaining;
        long total = theDrive.quota.total;
        double percentage = (double)remaining / (double)total * 100.0;
        double usedPercent = 100.0 - percentage;
        return usedPercent;
    }

    protected String encodeBase64UTFString(String value) {
        String encodedString = value;
        try {
            encodedString = new String(Base64.encodeBase64((byte[])value.getBytes()), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.trace("" + e);
            logger.error("" + e.getMessage());
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return encodedString;
    }

    private static int deleteFile(String driveId, String itemId) {
        String fileUrl = "https://graph.microsoft.com/v1.0/drives/" + driveId + "/items/" + itemId;
        logger.debug("...delete url...." + fileUrl);
        int responseCode = 0;
        try {
            OkHttpClient okHttpClient = Graph.getInstance().getOkHttpClient();
            Request request = new Request.Builder().url(fileUrl).delete().build();
            Call call = okHttpClient.newCall(request);
            Response response = call.execute();
            responseCode = response.code();
            logger.debug("...deleted usinggraph...." + responseCode);
            response.close();
        }
        catch (GraphServiceException e) {
            logger.error("GraphServiceException....", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("graph exception to delete:", (Object)e.getMessage());
        }
        return responseCode;
    }

    private String getDriveIdForUserMailId(String emailId) {
        Drive drive = null;
        try {
            com.parablu.pcbd.domain.User user;
            GraphServiceClient<Request> graphClient = this.getGraphClient();
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
            String userId = "";
            for (User userObj : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                userId = userObj.id;
            }
            if (StringUtils.isEmpty((Object)userId)) {
                requestOptions = new ArrayList();
                requestOptions.add(new QueryOption("$filter", (Object)("userPrincipalName eq '" + emailId + "'")));
                iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
                for (User userObj : iUserCollectionPage.getCurrentPage()) {
                    logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                    userId = userObj.id;
                }
            }
            if (StringUtils.isEmpty((Object)userId) && (user = this.utilService.getUserDetailsForEmail(1, emailId)) != null) {
                requestOptions = new ArrayList();
                requestOptions.add(new QueryOption("$filter", (Object)("userPrincipalName eq '" + user.getUserName() + "'")));
                iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
                for (User userObj : iUserCollectionPage.getCurrentPage()) {
                    logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                    userId = userObj.id;
                }
            }
            logger.debug(userId + ".. get drive1 for user given name.... " + emailId);
            int retryDrive = 0;
            do {
                drive = this.getDrive(graphClient, userId);
                logger.debug(++retryDrive + "....drive for user...." + drive);
                Thread.sleep(10000L);
            } while (retryDrive < 5 && drive == null || drive == null);
            if (drive != null) {
                logger.debug(emailId + "....drive id for user ... " + drive.id);
                return drive.id;
            }
        }
        catch (GraphServiceException e) {
            logger.error(" ... error trying to get token ..." + e.getResponseCode());
            if (e.getResponseCode() == 401) {
                logger.debug("..sleep for 90 sec...");
                try {
                    Thread.sleep(90000L);
                    return this.getDriveIdForUserMailId(emailId);
                }
                catch (InterruptedException interruptedException) {
                }
            } else if (e.getResponseCode() == 404) {
                logger.error("... not able to access resource check right user token is mapped .... " + emailId);
            } else if (e.getResponseCode() == 429) {
                logger.debug("..sleep for 90 sec...");
                try {
                    Thread.sleep(90000L);
                    return this.getDriveIdForUserMailId(emailId);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception ee) {
            logger.error(".... exception......" + ee.getMessage());
        }
        return null;
    }

    static {
        sem = new Semaphore(1);
        System.setProperty("DEBUG.MONGO", "true");
        System.setProperty("DB.TRACE", "true");
        try {
            sem.acquire(1);
        }
        catch (InterruptedException e) {
            logger.error("Failed to acquire semaphore! ", (Throwable)e);
        }
    }
}

