/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.controller.bp;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bp.service.ScheduleService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.element.NoBkpScheduleElement;
import com.parablu.paracloud.element.ScheduleElement;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.NoBkpSchedule;
import com.parablu.pcbd.domain.Schedule;
import com.parablu.pcbd.domain.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ScheduleController
extends BaseController {
    private static Logger logger = LogManager.getLogger(ScheduleController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private ScheduleService scheduleService;
    private static final String CALLING_SAVE_SCHEDULE = "calling save Schedule ...";
    private static final String ERROR_FAILED_TO_LOAD_SCHEDULE = "Error failed to load Schedule ...";

    private static boolean checkSpecialCharacters(String checkStr) {
        boolean isSpecCharExists = false;
        if (StringUtils.isEmpty((CharSequence)checkStr)) {
            return false;
        }
        String specialCharactersString = "/([{}<>;:=]+)(*)/";
        for (int i = 0; i < checkStr.length(); ++i) {
            char ch = checkStr.charAt(i);
            if (specialCharactersString.contains(Character.toString(ch))) {
                return true;
            }
            if (i != checkStr.length() - 1) continue;
            isSpecCharExists = false;
        }
        return isSpecCharExists;
    }

    @RequestMapping(value={"cloud/{cloudName}/gp/schedule/save"}, method={RequestMethod.POST})
    public void saveSchedule(@PathVariable(value="cloudName") String cloudName1, @RequestBody ScheduleElement scheduleElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(CALLING_SAVE_SCHEDULE);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            Schedule schedule = new Schedule();
            schedule.setScheduleName(scheduleElement.getScheduleName());
            schedule.setTime(scheduleElement.getTime());
            schedule.setTimeZone(scheduleElement.getTimeZone());
            schedule.setDayArray(scheduleElement.getDayArray());
            schedule.setBackupType(scheduleElement.getBackupType());
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            if (ScheduleController.checkSpecialCharacters(scheduleElement.getScheduleName())) {
                logger.error("...bad value for schedule name..." + scheduleElement.getScheduleName());
                response.setStatus(400);
                return;
            }
            if (ScheduleController.checkSpecialCharacters(scheduleElement.getTimeZone())) {
                logger.error("...bad value for schedule TimeZone..." + scheduleElement.getTimeZone());
                response.setStatus(400);
                return;
            }
            this.scheduleService.saveSchedule(cloudId, cloudName, schedule, authorizationTokens.getUser().getUserName());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to save Schedule ..." + (Object)((Object)e));
            logger.error("Error failed to save Schedule ..." + e.getMessage());
        }
        logger.debug("end of calling  save Schedule ....");
    }

    @RequestMapping(value={"cloud/{cloudName}/gp/schedule/save"}, method={RequestMethod.PUT})
    public void createSchedule(@PathVariable(value="cloudName") String cloudName1, @RequestBody ScheduleElement scheduleElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(CALLING_SAVE_SCHEDULE);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            ScheduleElement scheduleElement1 = this.scheduleService.getSchedule(cloudId, cloudName, scheduleElement.getScheduleName());
            if (scheduleElement1 != null) {
                logger.debug("schedule Already exists----");
                response.setStatus(406);
                return;
            }
            Schedule schedule = new Schedule();
            schedule.setScheduleName(scheduleElement.getScheduleName());
            schedule.setTime(scheduleElement.getTime());
            schedule.setTimeZone(scheduleElement.getTimeZone());
            schedule.setDayArray(scheduleElement.getDayArray());
            schedule.setBackupType(scheduleElement.getBackupType());
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            if (ScheduleController.checkSpecialCharacters(scheduleElement.getScheduleName())) {
                logger.error("...bad value for schedule name..." + scheduleElement.getScheduleName());
                response.setStatus(400);
                return;
            }
            if (ScheduleController.checkSpecialCharacters(scheduleElement.getTimeZone())) {
                logger.error("...bad value for schedule TimeZone..." + scheduleElement.getTimeZone());
                response.setStatus(400);
                return;
            }
            this.scheduleService.saveSchedule(cloudId, cloudName, schedule, authorizationTokens.getUser().getUserName());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to save Schedule ..." + (Object)((Object)e));
            logger.error("Error failed to save Schedule ..." + e.getMessage());
        }
        logger.debug("end of calling  save Schedule . put ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/gp/schedule/load/{scheduleName}/", "versions/{versionNumber}/clouds/{cloudName}/gp/schedule/load/{scheduleName}/"}, method={RequestMethod.GET})
    public ModelAndView getSchedule(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="scheduleName") String scheduleName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(CALLING_SAVE_SCHEDULE);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            ScheduleElement scheduleElement = this.scheduleService.getSchedule(cloudId, cloudName, scheduleName);
            if (scheduleElement == null) {
                response.setStatus(400);
                return null;
            }
            modelAndView.addObject((Object)scheduleElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_SCHEDULE + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_SCHEDULE + e.getMessage());
        }
        logger.debug("end of loading schedule ...");
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/schedule/"}, method={RequestMethod.DELETE})
    public ModelAndView deleteSchedule(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        User currentUser = new User();
        logger.debug(CALLING_SAVE_SCHEDULE);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String scheduleName = request.getHeader("scheduleName");
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                return null;
            }
            boolean deleted = this.scheduleService.deleteSchedule(cloudId, cloudName, scheduleName, currentUser.getUserName());
            if (!deleted) {
                response.setStatus(412);
            } else {
                response.setStatus(200);
            }
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_SCHEDULE + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_SCHEDULE + e.getMessage());
        }
        logger.debug("end of loading schedule ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/gp/schedule/load/all"}, method={RequestMethod.GET})
    public ModelAndView getAllSchedule(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(CALLING_SAVE_SCHEDULE);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            List<ScheduleElement> scheduleElements = this.scheduleService.getAllSchedules(cloudId, cloudName);
            if (scheduleElements.isEmpty()) {
                scheduleElements = new ArrayList<ScheduleElement>();
            }
            modelAndView.addObject(scheduleElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_SCHEDULE + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_SCHEDULE + e.getMessage());
        }
        logger.debug("end of loading schedule ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/gp/schedule/load/schedules"}, method={RequestMethod.GET})
    public ModelAndView loadAllSchedulesForName(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load schedule  ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            String schedules = request.getHeader("schedules");
            String[] items = schedules.split(",");
            ArrayList<String> schedulesList = new ArrayList<String>(Arrays.asList(items));
            List<ScheduleElement> scheduleElements = this.scheduleService.getAllSchedules(cloudId, cloudName, schedulesList);
            if (scheduleElements.isEmpty()) {
                scheduleElements = new ArrayList<ScheduleElement>();
            }
            modelAndView.addObject(scheduleElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load schedules ..." + (Object)((Object)e));
            logger.error("Error failed to load schedules ..." + e.getMessage());
        }
        logger.debug("end of loading schedules ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/nobkp/schedule/save"}, method={RequestMethod.PUT})
    public void createNoBkpSchedule(@PathVariable(value="cloudName") String cloudName1, @RequestBody NoBkpScheduleElement noScheduleElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(CALLING_SAVE_SCHEDULE);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            NoBkpScheduleElement scheduleElement1 = this.scheduleService.getNoBkpSchedule(cloudId, cloudName, noScheduleElement.getScheduleName());
            if (scheduleElement1 != null) {
                logger.debug("schedule Already exists----");
                response.setStatus(406);
                return;
            }
            NoBkpSchedule schedule = new NoBkpSchedule();
            schedule.setScheduleName(noScheduleElement.getScheduleName());
            schedule.setScheduleName(noScheduleElement.getScheduleName());
            schedule.setFromTime(String.valueOf(noScheduleElement.getFromTime()));
            schedule.setToTime(String.valueOf(noScheduleElement.getToTime()));
            schedule.setTimeZone(noScheduleElement.getTimeZone());
            schedule.setDayArray(noScheduleElement.getDayArray());
            schedule.setBackupType(noScheduleElement.getBackupType());
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            if (ScheduleController.checkSpecialCharacters(noScheduleElement.getScheduleName())) {
                logger.error("...bad value for schedule name..." + noScheduleElement.getScheduleName());
                response.setStatus(400);
                return;
            }
            if (ScheduleController.checkSpecialCharacters(noScheduleElement.getTimeZone())) {
                logger.error("...bad value for schedule TimeZone..." + noScheduleElement.getTimeZone());
                response.setStatus(400);
                return;
            }
            this.scheduleService.saveNoBKPSchedule(cloudId, cloudName, schedule, authorizationTokens.getUser().getUserName());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to save Schedule ..." + (Object)((Object)e));
            logger.error("Error failed to save Schedule ..." + e.getMessage());
        }
        logger.debug("end of calling  save Schedule . put ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/noBkp/schedule/load/all"}, method={RequestMethod.GET})
    public ModelAndView getAllNoBkpSchedule(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(CALLING_SAVE_SCHEDULE);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            List<NoBkpScheduleElement> scheduleElements = this.scheduleService.getAllNoBkpSchedules(cloudId, cloudName);
            if (scheduleElements.isEmpty()) {
                scheduleElements = new ArrayList<NoBkpScheduleElement>();
            }
            modelAndView.addObject(scheduleElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_SCHEDULE + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_SCHEDULE + e.getMessage());
        }
        logger.debug("end of loading schedule ...");
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/NoBkp/schedule/load/{scheduleName}/"}, method={RequestMethod.GET})
    public ModelAndView getNoBkpSchedule(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="scheduleName") String scheduleName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(CALLING_SAVE_SCHEDULE);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            NoBkpScheduleElement scheduleElement = this.scheduleService.getNoBkpSchedule(cloudId, cloudName, scheduleName);
            if (scheduleElement == null) {
                response.setStatus(400);
                return null;
            }
            modelAndView.addObject((Object)scheduleElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_SCHEDULE + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_SCHEDULE + e.getMessage());
        }
        logger.debug("end of loading schedule ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/nobkp/schedule/save"}, method={RequestMethod.POST})
    public void saveNoBkpSchedule(@PathVariable(value="cloudName") String cloudName1, @RequestBody NoBkpScheduleElement noBkpScheduleElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(CALLING_SAVE_SCHEDULE);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            NoBkpSchedule schedule = new NoBkpSchedule();
            schedule.setScheduleName(noBkpScheduleElement.getScheduleName());
            schedule.setScheduleName(noBkpScheduleElement.getScheduleName());
            schedule.setScheduleName(noBkpScheduleElement.getScheduleName());
            schedule.setFromTime(String.valueOf(noBkpScheduleElement.getFromTime()));
            schedule.setToTime(String.valueOf(noBkpScheduleElement.getToTime()));
            schedule.setTimeZone(noBkpScheduleElement.getTimeZone());
            schedule.setDayArray(noBkpScheduleElement.getDayArray());
            schedule.setBackupType(noBkpScheduleElement.getBackupType());
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            if (ScheduleController.checkSpecialCharacters(noBkpScheduleElement.getScheduleName())) {
                logger.error("...bad value for schedule name..." + noBkpScheduleElement.getScheduleName());
                response.setStatus(400);
                return;
            }
            if (ScheduleController.checkSpecialCharacters(noBkpScheduleElement.getTimeZone())) {
                logger.error("...bad value for schedule TimeZone..." + noBkpScheduleElement.getTimeZone());
                response.setStatus(400);
                return;
            }
            this.scheduleService.saveNoBKPSchedule(cloudId, cloudName, schedule, authorizationTokens.getUser().getUserName());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to save Schedule ..." + (Object)((Object)e));
            logger.error("Error failed to save Schedule ..." + e.getMessage());
        }
        logger.debug("end of calling  save Schedule ....");
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/nobkpschedule/"}, method={RequestMethod.DELETE})
    public ModelAndView deleteNoBkpSchedule(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        User currentUser = new User();
        logger.debug(CALLING_SAVE_SCHEDULE);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String scheduleName = request.getHeader("scheduleName");
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                return null;
            }
            boolean deleted = this.scheduleService.deleteNoBkpSchedule(cloudId, cloudName, scheduleName, currentUser.getUserName());
            if (!deleted) {
                response.setStatus(412);
            } else {
                response.setStatus(200);
            }
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_SCHEDULE + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_SCHEDULE + e.getMessage());
        }
        logger.debug("end of loading schedule ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/nobkp/schedule/load/schedules"}, method={RequestMethod.GET})
    public ModelAndView loadAllNoBkpSchedulesForName(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load schedule  ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            String schedules = request.getHeader("schedules");
            String[] items = schedules.split(",");
            ArrayList<String> schedulesList = new ArrayList<String>(Arrays.asList(items));
            List<NoBkpScheduleElement> scheduleElements = this.scheduleService.getAllNoBkpSchedules(cloudId, cloudName, schedulesList);
            if (scheduleElements.isEmpty()) {
                scheduleElements = new ArrayList<NoBkpScheduleElement>();
            }
            modelAndView.addObject(scheduleElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load schedules ..." + (Object)((Object)e));
            logger.error("Error failed to load schedules ..." + e.getMessage());
        }
        logger.debug("end of loading schedules ...");
        return modelAndView;
    }
}

