/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.controller.bp;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bp.service.PGInfoService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.paracloud.element.PGInfoElement;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PGInfoController
extends BaseController {
    private static Logger logger = LogManager.getLogger(PGInfoController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private PGInfoService pgInfoService;
    private static final String EXCEPTION = "Exception ";
    private static final String START_DATE = "startDate";
    private static final String END_DATE = "endDate";
    private static final String INVALID_CLOUD_NAME = "Invalid cloud name ....";

    @RequestMapping(value={"cloud/{cloudName}/report/sizeperpg/"}, method={RequestMethod.GET})
    public ModelAndView getPgSize(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Entering getsize per PG #$#$#$$$$$$ ");
        List<Object> infoElements = new ArrayList();
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            infoElements = this.pgInfoService.getTotalStoragePerPG(cl.getCloud().getCloudId(), cl.getCloud().getCloudName());
        }
        catch (Exception e) {
            response.setHeader("errorMessage", EXCEPTION);
            response.setStatus(500);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        modelAndView.addObject(infoElements);
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/trends/sizeperpg"}, method={RequestMethod.GET})
    public ModelAndView getTrendReportPgSize(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("Entering /report/trends/sizeperpg per PG #$#$#$$$$$$ ");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        String startDate = request.getHeader(START_DATE);
        String endDate = request.getHeader(END_DATE);
        logger.debug(startDate + "Entering /report/trends/sizeperpg per PG #$#$#$$$$$$ " + endDate);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, httpResponse)) {
                logger.debug(INVALID_CLOUD_NAME);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            List<PGInfoElement> infoElements = this.pgInfoService.getPGInfo(cloudId, cloudName, startDate, endDate);
            httpResponse.setStatus(200);
            modelAndView.addObject(infoElements);
        }
        catch (Exception ex) {
            httpResponse.setHeader("errorMessage", EXCEPTION);
            httpResponse.setStatus(500);
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/trends/odstorage"}, method={RequestMethod.GET})
    public ModelAndView getTrendReportsForOD(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("Entering getsize of OD #$#$#$$$$$$ ");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        String startDate = request.getHeader(START_DATE);
        String endDate = request.getHeader(END_DATE);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, httpResponse)) {
                logger.debug(INVALID_CLOUD_NAME);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            List<PGInfoElement> infoElements = this.pgInfoService.getODInfo(cloudId, cloudName, startDate, endDate);
            httpResponse.setStatus(200);
            modelAndView.addObject(infoElements);
        }
        catch (Exception ex) {
            httpResponse.setHeader("errorMessage", EXCEPTION);
            httpResponse.setStatus(500);
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/trends/blobstorage"}, method={RequestMethod.GET})
    public ModelAndView getTrendReportsForBlob(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("Entering getsize of OD #$#$#$$$$$$ ");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        String startDate = request.getHeader(START_DATE);
        String endDate = request.getHeader(END_DATE);
        logger.debug("start date....." + startDate + "end Date...." + endDate);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, httpResponse)) {
                logger.debug(INVALID_CLOUD_NAME);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            List<PGInfoElement> infoElements = this.pgInfoService.getBlobStorageInfo(cloudId, cloudName, startDate, endDate);
            httpResponse.setStatus(200);
            modelAndView.addObject(infoElements);
        }
        catch (Exception ex) {
            httpResponse.setHeader("errorMessage", EXCEPTION);
            httpResponse.setStatus(500);
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
        }
        return modelAndView;
    }
}

