/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.controller.bp;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bp.service.NetworkThrottlingService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.element.NetworkThrottlingElement;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.NetworkThrottling;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class NetworkThrotllingController
extends BaseController {
    private static Logger logger = LogManager.getLogger(NetworkThrotllingController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private NetworkThrottlingService networkThrottlingService;
    private static final String ERROR_FAILED_TO_SAVE_NETWORKTHROTTLING = "Error failed to save NetworkThrottling ...";
    private static final String CALLING_LOAD_NETWORKTHROTTLING = "calling load networkThrottling  ...";
    private static final String ERROR_FAILED_TO_LOAD_NETWORKTHROTTLING = "Error failed to load networkThrottling ...";
    private static final String END_OF_LOADING_NETWORKTHROTTLING_ELEMENT = "end of loading networkThrottlingElement ...";

    @RequestMapping(value={"cloud/{cloudName}/networkthrottling/save"}, method={RequestMethod.POST})
    public void saveNetworkThrottling(@PathVariable(value="cloudName") String cloudName1, @RequestBody NetworkThrottlingElement networkThrottlingElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling save NetworkThrottling...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            NetworkThrottling networkThrottling = new NetworkThrottling();
            networkThrottling.setNetworkThrottlingName(networkThrottlingElement.getNetworkThrottlingName());
            networkThrottling.setEndTime(networkThrottlingElement.getEndTime());
            networkThrottling.setUploadSpeed(networkThrottlingElement.getUploadSpeed().longValue());
            networkThrottling.setDownloadSpeed(networkThrottlingElement.getDownloadSpeed().longValue());
            networkThrottling.setStartTime(networkThrottlingElement.getStartTime());
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            this.networkThrottlingService.saveNetworkThrottling(cloudId, cloudName, networkThrottling, authorizationTokens.getUser().getUserName());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_SAVE_NETWORKTHROTTLING + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_SAVE_NETWORKTHROTTLING + e.getMessage());
        }
        logger.debug("end of save NetworkThrottling ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/networkthrottling/load/{networkThrottlingName}/"}, method={RequestMethod.GET})
    public ModelAndView getNetworkThrottling(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="networkThrottlingName") String networkThrottlingName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(CALLING_LOAD_NETWORKTHROTTLING);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            NetworkThrottlingElement networkThrottlingElement = this.networkThrottlingService.getNetworkThrottling(cloudId, cloudName, networkThrottlingName);
            if (networkThrottlingElement == null) {
                response.setStatus(400);
                return null;
            }
            modelAndView.addObject((Object)networkThrottlingElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_NETWORKTHROTTLING + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_NETWORKTHROTTLING + e.getMessage());
        }
        logger.debug(END_OF_LOADING_NETWORKTHROTTLING_ELEMENT);
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/networkthrottling/load/all"}, method={RequestMethod.GET})
    public ModelAndView getAllNetworkThrottling(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(CALLING_LOAD_NETWORKTHROTTLING);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            List<NetworkThrottlingElement> networkThrottlingElements = this.networkThrottlingService.getAllNetworkThrottling(cloudId, cloudName);
            if (networkThrottlingElements == null) {
                networkThrottlingElements = new ArrayList<NetworkThrottlingElement>();
            }
            modelAndView.addObject(networkThrottlingElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_NETWORKTHROTTLING + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_NETWORKTHROTTLING + e.getMessage());
        }
        logger.debug(END_OF_LOADING_NETWORKTHROTTLING_ELEMENT);
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/networkthrottling/load/networkThrottlings"}, method={RequestMethod.GET})
    public ModelAndView loadAllNetworkThrottlingForName(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(CALLING_LOAD_NETWORKTHROTTLING);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            String nwThrottlingNames = request.getHeader("nwThrottlingNames");
            String[] items = nwThrottlingNames.split(",");
            ArrayList<String> nwThrottlingNamesList = new ArrayList<String>(Arrays.asList(items));
            List<NetworkThrottlingElement> networkThrottlingElements = this.networkThrottlingService.getAllNetworkThrottling(cloudId, cloudName, nwThrottlingNamesList);
            if (networkThrottlingElements == null) {
                networkThrottlingElements = new ArrayList<NetworkThrottlingElement>();
            }
            modelAndView.addObject(networkThrottlingElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_NETWORKTHROTTLING + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_NETWORKTHROTTLING + e.getMessage());
        }
        logger.debug(END_OF_LOADING_NETWORKTHROTTLING_ELEMENT);
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/pg/networkthrottling/save"}, method={RequestMethod.POST})
    public void savePGNetworkThrottling(@PathVariable(value="cloudName") String cloudName1, @RequestBody NetworkThrottlingElement networkThrottlingElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling save pg NetworkThrottling...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            NetworkThrottling networkThrottling = new NetworkThrottling();
            networkThrottling.setPrivacyGatewayName(networkThrottlingElement.getPrivacyGatewayName());
            networkThrottling.setEndTime(networkThrottlingElement.getEndTime());
            networkThrottling.setUploadSpeed(networkThrottlingElement.getUploadSpeed().longValue());
            networkThrottling.setStartTime(networkThrottlingElement.getStartTime());
            networkThrottling.setThrottleType(networkThrottlingElement.getThrottleType());
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            this.networkThrottlingService.savePGNetworkThrottling(cloudId, cloudName, networkThrottling, authorizationTokens.getUser().getUserName());
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_SAVE_NETWORKTHROTTLING + e);
            logger.error(ERROR_FAILED_TO_SAVE_NETWORKTHROTTLING + e.getMessage());
        }
        logger.debug("end of save pg NetworkThrottling ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/networkthrottling/load/{pgName}/networkThrottlings"}, method={RequestMethod.GET})
    public ModelAndView loadAllNetworkThrottlingForPGName(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="pgName") String pgName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(CALLING_LOAD_NETWORKTHROTTLING);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            List<NetworkThrottlingElement> networkThrottlingElements = this.networkThrottlingService.getAllNetworkThrottlingForPG(cloudId, cloudName, pgName);
            if (networkThrottlingElements == null) {
                networkThrottlingElements = new ArrayList<NetworkThrottlingElement>();
            }
            modelAndView.addObject(networkThrottlingElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_NETWORKTHROTTLING + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_NETWORKTHROTTLING + e.getMessage());
        }
        logger.debug(END_OF_LOADING_NETWORKTHROTTLING_ELEMENT);
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/pg/networkthrottling/delete"}, method={RequestMethod.DELETE})
    public void deletePGNetworkThrottling(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling delete NetworkThrottling...");
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String throttleId = request.getHeader("throttle-id");
            cloudName = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            this.networkThrottlingService.deletePGNetworkThrottling(cloudId, cloudName, throttleId, authorizationTokens.getUser().getUserName());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to delete NetworkThrottling ..." + (Object)((Object)e));
            logger.error("Error failed to delete NetworkThrottling ..." + e.getMessage());
        }
        logger.debug("end of delete NetworkThrottling ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/networkthrottling/load/{pgName}/networkThrottlings/{type}/"}, method={RequestMethod.GET})
    public ResponseEntity<List<NetworkThrottlingElement>> loadAllNetworkThrottlingForPGNameByType(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="pgName") String pgName, @PathVariable(value="type") String type, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(CALLING_LOAD_NETWORKTHROTTLING);
        String cloudName = cloudName1;
        List<Object> networkThrottlingElements = new ArrayList();
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            networkThrottlingElements = this.networkThrottlingService.getAllNetworkThrottlingForPGByType(cloudId, cloudName, pgName, type);
            if (networkThrottlingElements == null) {
                networkThrottlingElements = new ArrayList();
            }
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_NETWORKTHROTTLING + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_NETWORKTHROTTLING + e.getMessage());
        }
        logger.debug(END_OF_LOADING_NETWORKTHROTTLING_ELEMENT);
        return new ResponseEntity(networkThrottlingElements, HttpStatus.OK);
    }
}

