/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.controller.bp;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bp.service.BluVaultMappingService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.BluVaultMappingElement;
import com.parablu.pcbd.domain.BluVault;
import com.parablu.pcbd.domain.User;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BluVaultMappingController
extends BaseController {
    private static Logger logger = LogManager.getLogger(BluVaultMappingController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private BluVaultMappingService bluvaultMappingService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    private static final String NOT_AN_ADMIN_USER = "not a admin user so return";

    @RequestMapping(value={"cloud/{cloudName}/bluvault/load/all"}, method={RequestMethod.GET})
    public ModelAndView getAllEBMS(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load ebms ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token = request.getHeader("token")).getUser().isAdmin()) {
                logger.debug(NOT_AN_ADMIN_USER);
                response.setStatus(403);
                return null;
            }
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return null;
            }
            List<BluVaultMappingElement> ebmsMappingElements = this.bluvaultMappingService.getAllBluVaults(cloudId, cloudName);
            if (ebmsMappingElements == null) {
                ebmsMappingElements = new ArrayList<BluVaultMappingElement>();
            }
            modelAndView.addObject(ebmsMappingElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.debug("Error failed to load ebms ..." + (Object)((Object)e));
            logger.error("Error failed to load ebms ..." + e.getMessage());
        }
        logger.debug("end of loading bluvaults ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/bluvault/save"}, method={RequestMethod.POST})
    public void saveEBMS(@PathVariable(value="cloudName") String cloudName1, @RequestBody BluVaultMappingElement bluvaultMappingElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling save EBMS...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            User currentUser = new User();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            if (!this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token).getUser().isAdmin()) {
                logger.debug(NOT_AN_ADMIN_USER);
                response.setStatus(403);
                return;
            }
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                return;
            }
            BluVault ebmsMapping = new BluVault();
            ebmsMapping.setBluVaultName(bluvaultMappingElement.getBluVaultName());
            boolean isBluValultNameExist = this.bluvaultMappingService.isBluVaultNameExist(cloudId, bluvaultMappingElement.getBluVaultName());
            this.bluvaultMappingService.saveBluVault(cloudId, cloudName, ebmsMapping);
            if (isBluValultNameExist) {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "edit a paracloud ip address ", currentUser.getUserName(), bluvaultMappingElement.getBluVaultName(), "Portal", System.currentTimeMillis(), PCActionTypes.EDIT_PARACLOUD.getActionTypeValue());
            } else {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "added a new paracloud ip address ", currentUser.getUserName(), bluvaultMappingElement.getBluVaultName(), "Portal", System.currentTimeMillis(), PCActionTypes.ADD_PARACLOUD.getActionTypeValue());
            }
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to save bluvault mapping ..." + (Object)((Object)e));
            logger.error("Error failed to save bluvault mapping ..." + e.getMessage());
        }
        logger.debug("end of save BluVault mapping ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/bluvault/delete"}, method={RequestMethod.DELETE})
    public void deleteEBMS(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling delete ebms mapping...");
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            User currentUser = new User();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String bluvaultIp = request.getHeader("bluVaultName");
            String ebmsId = request.getHeader("id");
            cloudName = cl.getCloud().getCloudName();
            if (!this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token).getUser().isAdmin()) {
                logger.debug(NOT_AN_ADMIN_USER);
                response.setStatus(403);
                return;
            }
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                return;
            }
            this.bluvaultMappingService.deleteBluVault(cloudId, cloudName, ebmsId);
            response.setStatus(200);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "deleted paracloud ip address ", currentUser.getUserName(), bluvaultIp, "Portal", System.currentTimeMillis(), PCActionTypes.DELETE_PARACLOUD.getActionTypeValue());
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to delete ebms ..." + (Object)((Object)e));
            logger.error("Error failed to delete ebms ..." + e.getMessage());
        }
        logger.debug("end of delete BLUVAULT ...");
    }
}

