/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.controller.bp;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bp.service.DeviceBackupJobService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.psc.service.UserAndDeviceStatisticService;
import com.parablu.report.service.ReportService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BackupOverviewController
extends BaseController {
    private static Logger logger = LogManager.getLogger(BackupOverviewController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private ReportService reportService;
    @Autowired
    private UserAndDeviceStatisticService userAndDeviceStatisticService;
    private static final String EXCEPTION = "Exception  :";
    @Autowired
    private DeviceBackupJobService deviceBackupJobService;

    @RequestMapping(value={"/cloud/{cloudName}/mt/overview/"}, method={RequestMethod.GET})
    public void backupOverview(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug("Invalid cloud name ....");
            return;
        }
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        try {
            Long bsInstalled = this.userAndDeviceStatisticService.getNumberOfDevicePresent(cloudId, cloudName, false);
            Long noOfUsersMigrated = this.userAndDeviceStatisticService.getNumberOfUserPresent(cloudId, cloudName);
            Long noOfSuccessFullBackup = this.deviceBackupJobService.getNoOfSuccessfulBackups(cloudId, cloudName);
            String bluSyncInstalled = "";
            String usersMigrated = "";
            String successfulBackup = "";
            if (bsInstalled != null) {
                bluSyncInstalled = bsInstalled.toString();
            }
            if (noOfUsersMigrated != null) {
                usersMigrated = noOfUsersMigrated.toString();
            }
            if (noOfSuccessFullBackup != null) {
                successfulBackup = noOfSuccessFullBackup.toString();
            }
            response.addHeader("noOfUsersMigrated", usersMigrated);
            response.addHeader("noOfBSInstalled", bluSyncInstalled);
            response.addHeader("noOfSuccessFullBackup", successfulBackup);
            response.setStatus(200);
        }
        catch (Exception ex) {
            response.setHeader("errorMessage", "Exception ");
            response.setStatus(500);
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/mt/bkp/overview/"}, method={RequestMethod.GET})
    public ModelAndView loadMTOverview(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug("Invalid cloud name ....");
            return null;
        }
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        try {
            List usersList = this.reportService.getAllUserMTBackupElements(cloudId, cloudName);
            if (!CollectionUtils.isEmpty((Collection)usersList)) {
                modelAndView.addObject((Object)usersList);
            } else {
                modelAndView.addObject(new ArrayList());
            }
            response.setStatus(200);
        }
        catch (Exception ex) {
            response.setHeader("errorMessage", "Exception ");
            response.setStatus(500);
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
        }
        return modelAndView;
    }
}

