/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bp.service.impl;

import com.parablu.bluvault.udc.service.CloudSettingsService;
import com.parablu.bp.service.UserDefinedFolderService;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.BluSyncPortalBackupPolicyElement;
import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.paracloud.element.InclusionFilterElement;
import com.parablu.paracloud.element.UserDefinedFolderElement;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.ExcludedFoldersDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.dao.UserDefinedFoldersDao;
import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.ExcludedFolders;
import com.parablu.pcbd.domain.InclusionFilter;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.SQLBackupFolders;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserDefinedFolders;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserDefinedFolderServiceImpl
implements UserDefinedFolderService {
    private static Logger logger = LogManager.getLogger(UserDefinedFolderServiceImpl.class);
    @Resource
    private UserDefinedFoldersDao userDefinedFoldersDao;
    @Resource
    private ExcludedFoldersDao excludedFoldersDao;
    @Autowired
    private DeviceDao deviceDao;
    @Resource
    private UserDao userDao;
    @Autowired
    private CloudSettingsService cloudSettingsService;

    @Override
    public void saveUserDefinedFolders(int cloudId, String cloudName, UserDefinedFolderElement userDefinedFolderElement) {
        UserDefinedFolders userDefinedFolders = new UserDefinedFolders();
        this.setFolderPathWithLowerCaseAndRemovedExtraSlash(userDefinedFolderElement, userDefinedFolders);
        userDefinedFolders.setDeviceUUID(userDefinedFolderElement.getDeviceUUID());
        userDefinedFolders.setUserName(userDefinedFolderElement.getUserName());
        userDefinedFolders.setFolderType(userDefinedFolderElement.getFolderType());
        Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, null, userDefinedFolders.getDeviceUUID());
        if (device != null && (device.getOsType().equalsIgnoreCase("OUTLOOK") || device.getOsType().equalsIgnoreCase("ONEDRIVE"))) {
            logger.debug("... folder path for office .. device... " + userDefinedFolders.getFolderPath());
            if (!userDefinedFolders.getFolderPath().startsWith("/")) {
                userDefinedFolders.setFolderPath("/" + userDefinedFolders.getFolderPath());
            }
        }
        this.saveUserDefinedFolders(cloudId, cloudName, userDefinedFolders);
    }

    private void setFolderPathWithLowerCaseAndRemovedExtraSlash(UserDefinedFolderElement userDefinedFolderElement, UserDefinedFolders userDefinedFolders) {
        String folderPath = userDefinedFolderElement.getFolderPath();
        String removeExtraSlash = folderPath.replace("\\\\", "\\");
        String removeExtraSlashAndSpace = removeExtraSlash.replace("\\ \\", "\\");
        userDefinedFolders.setFolderPath(removeExtraSlashAndSpace);
    }

    private void saveUserDefinedFolders(int cloudId, String cloudName, UserDefinedFolders userDefinedFolders) {
        Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, null, userDefinedFolders.getDeviceUUID());
        if (StringUtils.isEmpty((String)device.getUserName())) {
            throw new BaseException("No user mapped for the device", 204);
        }
        String userName = device.getUserName();
        User user = this.userDao.getUserByName(cloudId, userName);
        if (user != null) {
            ArrayList<String> defaultFoldersListInLower;
            ArrayList<String> defaultFoldersList;
            List backupFoldersList = new ArrayList();
            List excludedFoldersList = new ArrayList();
            if (device != null && !StringUtils.isEmpty((String)device.getDeviceType()) && !device.getDeviceType().equalsIgnoreCase("BACKUP")) {
                OfficeBackupPolicy odbBackupPolicyByPolicyName = this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, user.getOneDrivePolicyName());
                backupFoldersList = odbBackupPolicyByPolicyName.getBackupFolders();
                excludedFoldersList = odbBackupPolicyByPolicyName.getExcludedFolders();
            } else {
                BackupPolicy backupPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName());
                backupFoldersList = backupPolicy.getBackupFolders();
                excludedFoldersList = backupPolicy.getExcludedFolders();
            }
            if (userDefinedFolders.getFolderType().equals(PCHelperConstant.FOLDER_TYPE.INCLUSION.toString())) {
                defaultFoldersList = new ArrayList<String>();
                if (!CollectionUtils.isEmpty((Collection)backupFoldersList)) {
                    for (BackupFolders backupFolders : backupFoldersList) {
                        defaultFoldersList.add(backupFolders.getFolderPath());
                    }
                }
                defaultFoldersListInLower = new ArrayList<String>();
                this.removeExtraSlashAndConverLowerCase(defaultFoldersList, defaultFoldersListInLower);
                List userDefinedFoldersList = this.userDefinedFoldersDao.getAllUserDefinedInclusionFolders(cloudId, cloudName, userDefinedFolders.getDeviceUUID(), userName);
                ArrayList<String> existingUserDefinedFolders = new ArrayList<String>();
                if (!CollectionUtils.isEmpty((Collection)userDefinedFoldersList)) {
                    for (UserDefinedFolders definedFolders : userDefinedFoldersList) {
                        existingUserDefinedFolders.add(definedFolders.getFolderPath());
                    }
                }
                ArrayList<String> existingUserDefinedFoldersForRmvdExtraSlash = new ArrayList<String>();
                this.removeExtraSlashAndConverLowerCase(existingUserDefinedFolders, existingUserDefinedFoldersForRmvdExtraSlash);
                if (!existingUserDefinedFoldersForRmvdExtraSlash.contains(userDefinedFolders.getFolderPath()) && !defaultFoldersListInLower.contains(userDefinedFolders.getFolderPath())) {
                    this.userDefinedFoldersDao.saveUserDefinedFolders(cloudId, cloudName, userDefinedFolders);
                }
            }
            if (userDefinedFolders.getFolderType().equals(PCHelperConstant.FOLDER_TYPE.EXCLUSION.toString())) {
                defaultFoldersList = new ArrayList();
                if (!CollectionUtils.isEmpty((Collection)excludedFoldersList)) {
                    for (ExcludedFolders excludedFolders : excludedFoldersList) {
                        defaultFoldersList.add(excludedFolders.getFolderPath());
                    }
                }
                defaultFoldersListInLower = new ArrayList<String>();
                this.removeExtraSlashAndConverLowerCase(defaultFoldersList, defaultFoldersListInLower);
                List userExcludedFoldersList = this.userDefinedFoldersDao.getAllUserDefinedExclusionFolders(cloudId, cloudName, userDefinedFolders.getDeviceUUID(), userName);
                ArrayList<String> existingUserExcludedFolders = new ArrayList<String>();
                if (!CollectionUtils.isEmpty((Collection)userExcludedFoldersList)) {
                    for (UserDefinedFolders definedFolders : userExcludedFoldersList) {
                        existingUserExcludedFolders.add(definedFolders.getFolderPath());
                    }
                }
                ArrayList<String> existingUserExcludedFoldersForRmvdExtraSlash = new ArrayList<String>();
                this.removeExtraSlashAndConverLowerCase(existingUserExcludedFolders, existingUserExcludedFoldersForRmvdExtraSlash);
                if (!existingUserExcludedFoldersForRmvdExtraSlash.contains(userDefinedFolders.getFolderPath()) && !defaultFoldersListInLower.contains(userDefinedFolders.getFolderPath())) {
                    this.userDefinedFoldersDao.saveUserDefinedFolders(cloudId, cloudName, userDefinedFolders);
                }
            }
        }
    }

    private void removeExtraSlashAndConverLowerCase(List<String> folderPathList, List<String> foldersPathForRmvdExtraSlash) {
        List<Object> folderPathListToLowerCase = new ArrayList();
        folderPathListToLowerCase = folderPathList;
        for (String string : folderPathListToLowerCase) {
            String removeExtraSlash = string.replace("\\\\", "\\");
            String removeExtraSlashAndSpace = removeExtraSlash.replace("\\ \\", "\\");
            foldersPathForRmvdExtraSlash.add(removeExtraSlashAndSpace);
        }
    }

    @Override
    public List<UserDefinedFolderElement> getAllUserDefinedInclusionFolders(int cloudId, String cloudName, String deviceUUID, String userName) {
        List backupFoldersList = this.userDefinedFoldersDao.getAllUserDefinedInclusionFolders(cloudId, cloudName, deviceUUID, userName);
        ArrayList<UserDefinedFolderElement> elements = new ArrayList<UserDefinedFolderElement>();
        for (UserDefinedFolders backupFolders : backupFoldersList) {
            UserDefinedFolderElement element = new UserDefinedFolderElement();
            BeanUtils.copyProperties((Object)backupFolders, (Object)element);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public void deleteUserDefinedFolder(int cloudId, String cloudName, String folderPath, String deviceUUID, String userName, String folderType) {
        this.userDefinedFoldersDao.deleteUserDefinedFolder(cloudId, cloudName, folderPath, deviceUUID, userName, folderType);
    }

    @Override
    public BluSyncPortalBackupPolicyElement getBluSyncPortalBackupPolicy(int cloudId, String cloudName, String deviceUUID, Cloud cloud) {
        Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, null, deviceUUID);
        if (StringUtils.isEmpty((String)device.getUserName())) {
            throw new BaseException("No user mapped for the device", 204);
        }
        String userName = device.getUserName();
        User user = this.userDao.getUserByName(cloudId, userName);
        BluSyncPortalBackupPolicyElement element = new BluSyncPortalBackupPolicyElement();
        if (user != null) {
            if (Device.TYPE.ONEDRIVE.toString().equalsIgnoreCase(device.getOsType())) {
                OfficeBackupPolicy backupPolicy = this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, user.getOneDrivePolicyName());
                ArrayList filters = backupPolicy.getInclusionFilter();
                if (!CollectionUtils.isEmpty((Collection)filters)) {
                    element.setFilterType(this.getFilter(filters, backupPolicy.getFilterType()).getFilterType());
                    element.setFileTypes(this.getFilter(filters, backupPolicy.getFilterType()).getFilters());
                }
                element.setMaxSizeAllowed(backupPolicy.getMaxFileSize());
                ArrayList<String> defaultFoldersList = new ArrayList<String>();
                for (BackupFolders backupFolders : backupPolicy.getBackupFolders()) {
                    defaultFoldersList.add(backupFolders.getFolderPath());
                }
                element.setDefaultFolders(defaultFoldersList);
                List userDefinedFoldersList = this.userDefinedFoldersDao.getAllUserDefinedInclusionFolders(cloudId, cloudName, deviceUUID, userName);
                ArrayList<String> existingUserDefinedFolders = new ArrayList<String>();
                if (!CollectionUtils.isEmpty((Collection)userDefinedFoldersList)) {
                    for (UserDefinedFolders definedFolders : userDefinedFoldersList) {
                        existingUserDefinedFolders.add(definedFolders.getFolderPath());
                    }
                }
                List userExcludedFoldersList = this.userDefinedFoldersDao.getAllUserDefinedExclusionFolders(cloudId, cloudName, deviceUUID, userName);
                ArrayList<String> existingUserExcludedFolders = new ArrayList<String>();
                if (!CollectionUtils.isEmpty((Collection)userExcludedFoldersList)) {
                    for (UserDefinedFolders definedFolders : userExcludedFoldersList) {
                        existingUserExcludedFolders.add(definedFolders.getFolderPath());
                    }
                }
                element.setUserDefinedFolders(existingUserDefinedFolders);
                element.setUserExcludedFolders(existingUserExcludedFolders);
            } else if (Device.TYPE.OUTLOOK.toString().equalsIgnoreCase(device.getOsType())) {
                Object userExcludedFoldersList;
                OfficeBackupPolicy backupPolicy = this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, user.getExchangePolicyName());
                ArrayList filters = backupPolicy.getInclusionFilter();
                if (!CollectionUtils.isEmpty((Collection)filters)) {
                    element.setFilterType(this.getFilter(filters, backupPolicy.getFilterType()).getFilterType());
                    element.setFileTypes(this.getFilter(filters, backupPolicy.getFilterType()).getFilters());
                }
                element.setMaxSizeAllowed(backupPolicy.getMaxFileSize());
                ArrayList<String> defaultFoldersList = new ArrayList<String>();
                for (BackupFolders backupFolders : backupPolicy.getBackupFolders()) {
                    defaultFoldersList.add(backupFolders.getFolderPath());
                }
                element.setDefaultFolders(defaultFoldersList);
                List userDefinedFoldersList = this.userDefinedFoldersDao.getAllUserDefinedInclusionFolders(cloudId, cloudName, deviceUUID, userName);
                ArrayList<String> existingUserDefinedFolders = new ArrayList<String>();
                if (!CollectionUtils.isEmpty((Collection)userDefinedFoldersList)) {
                    userExcludedFoldersList = userDefinedFoldersList.iterator();
                    while (userExcludedFoldersList.hasNext()) {
                        UserDefinedFolders definedFolders = (UserDefinedFolders)userExcludedFoldersList.next();
                        existingUserDefinedFolders.add(definedFolders.getFolderPath());
                    }
                }
                userExcludedFoldersList = this.userDefinedFoldersDao.getAllUserDefinedExclusionFolders(cloudId, cloudName, deviceUUID, userName);
                ArrayList<String> existingUserExcludedFolders = new ArrayList<String>();
                if (!CollectionUtils.isEmpty((Collection)userExcludedFoldersList)) {
                    Iterator iterator = userExcludedFoldersList.iterator();
                    while (iterator.hasNext()) {
                        UserDefinedFolders definedFolders = (UserDefinedFolders)iterator.next();
                        existingUserExcludedFolders.add(definedFolders.getFolderPath());
                    }
                }
                element.setUserDefinedFolders(existingUserDefinedFolders);
                element.setUserExcludedFolders(existingUserExcludedFolders);
                Map mailFilterMap = backupPolicy.getOutlookFilters();
                String fromVal = "";
                String toVal = "";
                String subject = "";
                if (mailFilterMap != null && mailFilterMap.size() > 0) {
                    for (Map.Entry filterEntry : mailFilterMap.entrySet()) {
                        if ("from".equalsIgnoreCase((String)filterEntry.getKey())) {
                            fromVal = (String)filterEntry.getValue();
                        }
                        if ("to".equalsIgnoreCase((String)filterEntry.getKey())) {
                            toVal = (String)filterEntry.getValue();
                        }
                        if (!"subject".equalsIgnoreCase((String)filterEntry.getKey())) continue;
                        subject = (String)filterEntry.getValue();
                    }
                }
                logger.debug(backupPolicy.getPolicyName() + "...filtername..." + fromVal);
                element.setSubjectFilter(subject);
                element.setToFilter(toVal);
                element.setFromFilter(fromVal);
            } else {
                BackupPolicy backupPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName());
                boolean isSQLBackupEnabled = this.isSQLBackupEnabled(cloud);
                List filters = backupPolicy.getInclusionFilter();
                if (!CollectionUtils.isEmpty((Collection)filters)) {
                    element.setFilterType(this.getFilter(filters, backupPolicy.getFilterType()).getFilterType());
                    element.setFileTypes(this.getFilter(filters, backupPolicy.getFilterType()).getFilters());
                }
                element.setMaxSizeAllowed(backupPolicy.getMaxFileSize());
                ArrayList<String> defaultFoldersList = new ArrayList<String>();
                for (BackupFolders backupFolders : backupPolicy.getBackupFolders()) {
                    defaultFoldersList.add(backupFolders.getFolderPath());
                }
                element.setDefaultFolders(defaultFoldersList);
                List userDefinedFoldersList = this.userDefinedFoldersDao.getAllUserDefinedInclusionFolders(cloudId, cloudName, deviceUUID, userName);
                ArrayList<String> existingUserDefinedFolders = new ArrayList<String>();
                if (!CollectionUtils.isEmpty((Collection)userDefinedFoldersList)) {
                    for (UserDefinedFolders definedFolders : userDefinedFoldersList) {
                        existingUserDefinedFolders.add(definedFolders.getFolderPath());
                    }
                }
                List userExcludedFoldersList = this.userDefinedFoldersDao.getAllUserDefinedExclusionFolders(cloudId, cloudName, deviceUUID, userName);
                ArrayList<String> existingUserExcludedFolders = new ArrayList<String>();
                if (!CollectionUtils.isEmpty((Collection)userExcludedFoldersList)) {
                    for (Object definedFolders : userExcludedFoldersList) {
                        existingUserExcludedFolders.add(definedFolders.getFolderPath());
                    }
                }
                ArrayList<String> existingUserSQLBackupFolders = new ArrayList<String>();
                if (!CollectionUtils.isEmpty((Collection)backupPolicy.getSqlBackupFolders())) {
                    for (SQLBackupFolders backupFolders : backupPolicy.getSqlBackupFolders()) {
                        existingUserSQLBackupFolders.add(backupFolders.getFolderPath());
                    }
                }
                logger.debug("isSQLBackupEnabled........." + isSQLBackupEnabled);
                if (isSQLBackupEnabled) {
                    element.setUserSQLBackupFolders(existingUserSQLBackupFolders);
                }
                element.setUserDefinedFolders(existingUserDefinedFolders);
                element.setUserExcludedFolders(existingUserExcludedFolders);
                element.setCanAdminRestore(device.isCanAdminRestore());
                CloudPropertyElement cloudPropertyElement = this.cloudSettingsService.getCloudPropertyElement(cloudId);
                if (cloudPropertyElement.isOverridePolicySettings() && cloudPropertyElement.getCanAdminRestoreAll() && cloudPropertyElement.isAllowEndUserTocontrolRestore() || !cloudPropertyElement.isOverridePolicySettings() && backupPolicy.isAllowEndUserTocontrolRestore()) {
                    element.setShowdisableAdminRestore(true);
                } else {
                    element.setShowdisableAdminRestore(false);
                }
            }
        }
        return element;
    }

    private boolean isSQLBackupEnabled(Cloud cl) {
        boolean isClamAVScanEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"SQL Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isClamAVScanEnabled = true;
                break;
            }
        }
        logger.debug("SQL Backup Enabled" + isClamAVScanEnabled);
        return isClamAVScanEnabled;
    }

    private InclusionFilterElement getFilter(List<InclusionFilter> filters, String filterType) {
        InclusionFilterElement filterElement = new InclusionFilterElement();
        StringBuilder fileExtensions = new StringBuilder();
        InclusionFilter inclusionFilter = new InclusionFilter();
        inclusionFilter = filters.get(0);
        filterElement.setFilterName(inclusionFilter.getFilterName());
        filterElement.setFilterType(filterType);
        for (InclusionFilter filter : filters) {
            fileExtensions.append(filter.getExtensionName());
            fileExtensions.append(",");
        }
        filterElement.setFilters(fileExtensions.toString().replaceAll(",$", ""));
        return filterElement;
    }

    @Override
    public List<UserDefinedFolderElement> getAllUserDefinedFolders(int cloudId, String cloudName, String deviceUUID, String userName) {
        List backupFoldersList = this.userDefinedFoldersDao.getAllUserDefinedInclusionFolders(cloudId, cloudName, deviceUUID, userName);
        ArrayList<UserDefinedFolderElement> elements = new ArrayList<UserDefinedFolderElement>();
        for (UserDefinedFolders backupFolders : backupFoldersList) {
            UserDefinedFolderElement element = new UserDefinedFolderElement();
            BeanUtils.copyProperties((Object)backupFolders, (Object)element);
            elements.add(element);
        }
        return elements;
    }
}

