/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bp.service.impl;

import com.parablu.bp.service.ScheduleService;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.NoBkpScheduleElement;
import com.parablu.paracloud.element.ScheduleElement;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.SchedulesDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.NoBkpSchedule;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.Schedule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    @Resource
    private SchedulesDao schedulesDao;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    @Resource
    private BackupPolicyDao backupPolicyDao;
    @Resource
    private UserDao userDao;

    @Override
    public void saveSchedule(int cloudId, String cloudName, Schedule schedule, String userName) {
        Schedule existingSchedule = this.schedulesDao.getSchedule(cloudId, cloudName, schedule.getScheduleName());
        if (existingSchedule != null) {
            ObjectId id = existingSchedule.getId();
            BeanUtils.copyProperties((Object)schedule, (Object)existingSchedule);
            existingSchedule.setId(id);
            this.schedulesDao.saveSchedule(cloudId, cloudName, existingSchedule);
            this.saveStatisticToDatabase(cloudId, cloudName, "modified schedule", userName, existingSchedule.getScheduleName(), PCActionTypes.SCHEDULE_UPDATE.getActionTypeValue());
        } else {
            this.schedulesDao.saveSchedule(cloudId, cloudName, schedule);
            this.saveStatisticToDatabase(cloudId, cloudName, "created a new schedule", userName, schedule.getScheduleName(), PCActionTypes.SCHEDULE_CREATE.getActionTypeValue());
        }
        List backupPolicyList = this.backupPolicyDao.getAllBackupPolicies(cloudId);
        List<BackupPolicy> policiesAfterFilter = this.filterWithSchedule(backupPolicyList, schedule.getScheduleName());
        for (BackupPolicy backupPolicy : policiesAfterFilter) {
            backupPolicy.setLastModifiedTimestamp(System.currentTimeMillis());
            this.backupPolicyDao.saveBackupPolicy(cloudId, cloudName, backupPolicy);
            this.userDao.updateBackupPolicyModifiedTime(cloudId, backupPolicy.getPolicyName());
        }
    }

    private List<BackupPolicy> filterWithSchedule(List<BackupPolicy> backupPolicyList, String scheduleName) {
        ArrayList<BackupPolicy> backupPolicies = new ArrayList<BackupPolicy>();
        for (BackupPolicy backupPolicy : backupPolicyList) {
            for (Schedule schedule : backupPolicy.getSchedules()) {
                if (!schedule.getScheduleName().equals(scheduleName)) continue;
                backupPolicies.add(backupPolicy);
            }
        }
        return backupPolicies;
    }

    private List<BackupPolicy> filterWithNoBKPSchedule(List<BackupPolicy> backupPolicyList, String scheduleName) {
        ArrayList<BackupPolicy> backupPolicies = new ArrayList<BackupPolicy>();
        for (BackupPolicy backupPolicy : backupPolicyList) {
            if (CollectionUtils.isEmpty((Collection)backupPolicy.getNoBkpSchedules())) continue;
            for (NoBkpSchedule schedule : backupPolicy.getNoBkpSchedules()) {
                if (!schedule.getScheduleName().equals(scheduleName)) continue;
                backupPolicies.add(backupPolicy);
            }
        }
        return backupPolicies;
    }

    @Override
    public ScheduleElement getSchedule(int cloudId, String cloudName, String scheduleName) {
        Schedule schedule = this.schedulesDao.getSchedule(cloudId, cloudName, scheduleName);
        return this.getSchedule(schedule);
    }

    private ScheduleElement getSchedule(Schedule schedule) {
        ScheduleElement element = null;
        if (schedule != null) {
            element = new ScheduleElement();
            element.setScheduleName(schedule.getScheduleName());
            element.setTime(String.valueOf(schedule.getTime()));
            element.setTimeZone(schedule.getTimeZone());
            element.setDayArray(schedule.getDayArray());
            element.setBackupType(schedule.getBackupType());
        }
        return element;
    }

    @Override
    public boolean deleteSchedule(int cloudId, String cloudName, String scheduleName, String userName) {
        List backupPolicies = this.backupPolicyDao.getAllBackupPolicies(cloudId);
        HashSet<String> backupPolicyScheduleNames = new HashSet<String>();
        for (Object backupPolicy : backupPolicies) {
            ArrayList schedules = backupPolicy.getSchedules();
            for (Schedule schedule : schedules) {
                backupPolicyScheduleNames.add(schedule.getScheduleName());
            }
        }
        List officeBackupPolicies = this.backupPolicyDao.getAllOfficePolicies(cloudId);
        if (!CollectionUtils.isEmpty((Collection)officeBackupPolicies)) {
            for (OfficeBackupPolicy backupPolicy : officeBackupPolicies) {
                if (CollectionUtils.isEmpty((Collection)backupPolicy.getSchedules())) continue;
                for (Schedule schedule : backupPolicy.getSchedules()) {
                    if (schedule == null || StringUtils.isEmpty((String)schedule.getScheduleName())) continue;
                    backupPolicyScheduleNames.add(schedule.getScheduleName());
                }
            }
        }
        if (!CollectionUtils.isEmpty(backupPolicyScheduleNames) && backupPolicyScheduleNames.contains(scheduleName)) {
            return false;
        }
        boolean deleted = this.schedulesDao.removeSchedule(cloudId, scheduleName);
        if (deleted) {
            this.saveStatisticToDatabase(cloudId, cloudName, "deleted schedule", userName, scheduleName, PCActionTypes.SCHEDULE_DELETE.getActionTypeValue());
            return true;
        }
        return false;
    }

    @Override
    public List<ScheduleElement> getAllSchedules(int cloudId, String cloudName) {
        List schedulesList = this.schedulesDao.getAllSchedules(cloudId, cloudName);
        ArrayList<ScheduleElement> elements = new ArrayList<ScheduleElement>();
        for (Schedule schedule : schedulesList) {
            ScheduleElement element = this.getSchedule(schedule);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public List<ScheduleElement> getAllSchedules(int cloudId, String cloudName, List<String> scheduleNames) {
        List schedulesList = this.schedulesDao.getSchedules(cloudId, cloudName, scheduleNames);
        ArrayList<ScheduleElement> elements = new ArrayList<ScheduleElement>();
        for (Schedule schedule : schedulesList) {
            ScheduleElement element = this.getSchedule(schedule);
            elements.add(element);
        }
        return elements;
    }

    private void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(System.currentTimeMillis());
        audit.setActionUsingObject("Portal");
        audit.setActionType(actionType);
        this.auditHistoryDao.saveAudit(cloudId, cloudName, audit);
    }

    @Override
    public void saveNoBKPSchedule(int cloudId, String cloudName, NoBkpSchedule schedule, String userName) {
        NoBkpSchedule existingSchedule = this.schedulesDao.getNobkpSchedule(cloudId, cloudName, schedule.getScheduleName());
        if (existingSchedule != null) {
            ObjectId id = existingSchedule.getId();
            BeanUtils.copyProperties((Object)schedule, (Object)existingSchedule);
            existingSchedule.setId(id);
            this.schedulesDao.saveNoBkpSchedule(cloudId, cloudName, existingSchedule);
            this.saveStatisticToDatabase(cloudId, cloudName, "modified No Backup windows", userName, existingSchedule.getScheduleName(), PCActionTypes.SCHEDULE_UPDATE.getActionTypeValue());
        } else {
            this.schedulesDao.saveNoBkpSchedule(cloudId, cloudName, schedule);
            this.saveStatisticToDatabase(cloudId, cloudName, "created a new No Backup windows", userName, schedule.getScheduleName(), PCActionTypes.SCHEDULE_CREATE.getActionTypeValue());
        }
        List backupPolicyList = this.backupPolicyDao.getAllBackupPolicies(cloudId);
        List<BackupPolicy> policiesAfterFilter = this.filterWithNoBKPSchedule(backupPolicyList, schedule.getScheduleName());
        for (BackupPolicy backupPolicy : policiesAfterFilter) {
            backupPolicy.setLastModifiedTimestamp(System.currentTimeMillis());
            this.backupPolicyDao.saveBackupPolicy(cloudId, cloudName, backupPolicy);
            this.userDao.updateBackupPolicyModifiedTime(cloudId, backupPolicy.getPolicyName());
        }
    }

    @Override
    public NoBkpScheduleElement getNoBkpSchedule(int cloudId, String cloudName, String scheduleName) {
        NoBkpSchedule schedule = this.schedulesDao.getNobkpSchedule(cloudId, cloudName, scheduleName);
        return this.getNoBkpSchedule(schedule);
    }

    private NoBkpScheduleElement getNoBkpSchedule(NoBkpSchedule schedule) {
        NoBkpScheduleElement element = null;
        if (schedule != null) {
            element = new NoBkpScheduleElement();
            element.setScheduleName(schedule.getScheduleName());
            element.setFromTime(String.valueOf(schedule.getFromTime()));
            element.setToTime(String.valueOf(schedule.getToTime()));
            element.setTimeZone(schedule.getTimeZone());
            element.setDayArray(schedule.getDayArray());
            element.setBackupType(schedule.getBackupType());
        }
        return element;
    }

    @Override
    public List<NoBkpScheduleElement> getAllNoBkpSchedules(int cloudId, String cloudName) {
        List schedulesList = this.schedulesDao.getAllNoBkpSchedules(cloudId, cloudName);
        ArrayList<NoBkpScheduleElement> elements = new ArrayList<NoBkpScheduleElement>();
        for (NoBkpSchedule schedule : schedulesList) {
            NoBkpScheduleElement element = this.getNoBkpSchedule(schedule);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public boolean deleteNoBkpSchedule(int cloudId, String cloudName, String scheduleName, String userName) {
        List backupPolicies = this.backupPolicyDao.getAllBackupPolicies(cloudId);
        HashSet<String> backupPolicyScheduleNames = new HashSet<String>();
        for (BackupPolicy backupPolicy : backupPolicies) {
            ArrayList schedules = backupPolicy.getNoBkpSchedules();
            if (CollectionUtils.isEmpty((Collection)schedules)) continue;
            for (NoBkpSchedule schedule : schedules) {
                backupPolicyScheduleNames.add(schedule.getScheduleName());
            }
        }
        if (!CollectionUtils.isEmpty(backupPolicyScheduleNames) && backupPolicyScheduleNames.contains(scheduleName)) {
            return false;
        }
        boolean deleted = this.schedulesDao.removeNoBkpSchedule(cloudId, scheduleName);
        if (deleted) {
            this.saveStatisticToDatabase(cloudId, cloudName, "deleted No Backup windows", userName, scheduleName, PCActionTypes.SCHEDULE_DELETE.getActionTypeValue());
            return true;
        }
        return false;
    }

    @Override
    public List<NoBkpScheduleElement> getAllNoBkpSchedules(int cloudId, String cloudName, List<String> scheduleNames) {
        List schedulesList = this.schedulesDao.getNoBKPSchedules(cloudId, cloudName, scheduleNames);
        ArrayList<NoBkpScheduleElement> elements = new ArrayList<NoBkpScheduleElement>();
        if (!CollectionUtils.isEmpty((Collection)schedulesList)) {
            for (NoBkpSchedule schedule : schedulesList) {
                NoBkpScheduleElement element = this.getNoBkpSchedule(schedule);
                elements.add(element);
            }
        }
        return elements;
    }
}

