/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bp.service.impl;

import com.parablu.bp.service.OfficeBackupPolicyService;
import com.parablu.helper.utils.OfficeBackupPolicyDiffFinder;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.BackupFolderElement;
import com.parablu.paracloud.element.OfficeBackupPolicyElement;
import com.parablu.paracloud.element.PrivacyGatewayMappingElement;
import com.parablu.paracloud.element.bp.EditUserBackupPolicyMappingElement;
import com.parablu.paracloud.element.bp.ExcludedFolderElement;
import com.parablu.paracloud.element.bp.UserBackupPolicyMappingElement;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.BackupFoldersDao;
import com.parablu.pcbd.dao.BluVaultDao;
import com.parablu.pcbd.dao.CalloutScriptDao;
import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.dao.ExcludedFoldersDao;
import com.parablu.pcbd.dao.InclusionFilterDao;
import com.parablu.pcbd.dao.NetworkThrottlingDao;
import com.parablu.pcbd.dao.OfficeBackupPolicyDao;
import com.parablu.pcbd.dao.PrivacyGateWayDao;
import com.parablu.pcbd.dao.ReleaseDao;
import com.parablu.pcbd.dao.SchedulesDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.dao.UserDefinedFoldersDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.ExcludedFolders;
import com.parablu.pcbd.domain.InclusionFilter;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PrivacyGateway;
import com.parablu.pcbd.domain.Schedule;
import com.parablu.pcbd.domain.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class OfficeBackupPolicyServiceImpl
implements OfficeBackupPolicyService {
    private static Logger logger = LogManager.getLogger(OfficeBackupPolicyServiceImpl.class);
    @Resource
    private OfficeBackupPolicyDao oneDriveBackupPolicyDao;
    @Resource
    private BackupFoldersDao backupFoldersDao;
    @Resource
    private CalloutScriptDao calloutScriptDao;
    @Resource
    private SchedulesDao schedulesDao;
    @Resource
    private NetworkThrottlingDao networkThrottlingDao;
    @Resource
    private InclusionFilterDao inclusionFilterDao;
    @Resource
    private PrivacyGateWayDao privacyGateWayDao;
    @Resource
    private UserDefinedFoldersDao userDefinedFoldersDao;
    @Resource
    private ExcludedFoldersDao excludedFoldersDao;
    @Resource
    private ReleaseDao releaseDao;
    @Resource
    private UserDao userDao;
    @Resource
    private BluVaultDao bluVaultDao;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    @Resource
    private CloudDao cloudDao;

    @Override
    public void saveBackupPolicy(int cloudId, String cloudName, OfficeBackupPolicyElement backupPolicyElement, String userName) {
        List odbackupFolderPaths = backupPolicyElement.getBackupFolderPaths();
        List odexcludedFolderPaths = backupPolicyElement.getExcludedFolderpaths();
        OfficeBackupPolicy existingOfficeBackupPolicy = this.oneDriveBackupPolicyDao.getOfficeBackupPolicy(cloudId, backupPolicyElement.getPolicygroupName(), backupPolicyElement.getPolicyType());
        List odscheduleNames = backupPolicyElement.getScheduleNames();
        List odschedules = this.schedulesDao.getSchedules(cloudId, cloudName, odscheduleNames);
        List odFilterNames = backupPolicyElement.getFilterInclusionName();
        ArrayList<Object> odFilters = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)odFilterNames)) {
            odFilters = this.getFiltersbyName(cloudId, cloudName, odFilterNames);
        }
        List searchFilterInclusionNames = backupPolicyElement.getSearchFilterInclusionName();
        ArrayList<Object> odSearchfilters = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)searchFilterInclusionNames)) {
            odSearchfilters = this.getFiltersbyName(cloudId, cloudName, searchFilterInclusionNames);
        }
        String changedFields = "";
        OfficeBackupPolicyElement existingOfficeBackupPolicyElement = new OfficeBackupPolicyElement();
        ArrayList<ObjectId> existingOdBackFoldersList = new ArrayList<ObjectId>();
        ArrayList<String> existingOdBackupFolderPath = new ArrayList<String>();
        ArrayList existingMailBackFoldersList = new ArrayList();
        ArrayList<String> existingOdExcludedFolderPath = new ArrayList<String>();
        ArrayList<String> existingPrivacyGateways = new ArrayList<String>();
        ArrayList<String> existingodScheduleNames = new ArrayList<String>();
        if (existingOfficeBackupPolicy != null) {
            BeanUtils.copyProperties((Object)existingOfficeBackupPolicy, (Object)existingOfficeBackupPolicyElement);
            for (Schedule sch : existingOfficeBackupPolicy.getSchedules()) {
                existingodScheduleNames.add(sch.getScheduleName());
            }
            existingOfficeBackupPolicyElement.setScheduleNames(existingodScheduleNames);
            existingOfficeBackupPolicyElement.setEndpointUiPreferences((List)existingOfficeBackupPolicy.getEndpointUiPreferences());
            for (BackupFolders backupFolders : existingOfficeBackupPolicy.getBackupFolders()) {
                existingOdBackFoldersList.add(backupFolders.getId());
                existingOdBackupFolderPath.add(backupFolders.getFolderPath());
            }
            if (existingOfficeBackupPolicy.getExcludedFolders() != null) {
                for (ExcludedFolders excludedFolders : existingOfficeBackupPolicy.getExcludedFolders()) {
                    existingOdExcludedFolderPath.add(excludedFolders.getFolderPath());
                }
            }
            if (StringUtils.isEmpty((Object)backupPolicyElement.getExcludedFolderpaths())) {
                backupPolicyElement.setExcludedFolderpaths(new ArrayList());
            }
            existingOfficeBackupPolicy.setCanAdminRestore(backupPolicyElement.isCanAdminRestore());
            this.oneDriveBackupPolicyDao.saveOfficeBackupPolicy(cloudId, existingOfficeBackupPolicy);
        }
        List<BackupFolders> odbackupFolders = this.getBackupFolders(cloudId, cloudName, backupPolicyElement, odbackupFolderPaths);
        List<Object> oduserExcludedFodlers = new ArrayList();
        if (!StringUtils.isEmpty((Object)odexcludedFolderPaths)) {
            oduserExcludedFodlers = this.getUserExclusionFolders(cloudId, backupPolicyElement, odexcludedFolderPaths);
        }
        OfficeBackupPolicy backupPolicy = new OfficeBackupPolicy();
        BeanUtils.copyProperties((Object)backupPolicyElement, (Object)backupPolicy);
        backupPolicy.setPolicyName(backupPolicyElement.getPolicygroupName());
        backupPolicy.setBackupFolders(new ArrayList());
        backupPolicy.getBackupFolders().addAll(odbackupFolders);
        backupPolicy.setSchedules(new ArrayList());
        backupPolicy.getSchedules().addAll(odschedules);
        backupPolicy.setCanAdminRestore(backupPolicyElement.isCanAdminRestore());
        backupPolicy.setInclusionFilter(odFilters);
        backupPolicy.setSearchInclusionFilter(odSearchfilters);
        backupPolicy.setCompressionEnabled(backupPolicyElement.isCompressionEnabled());
        backupPolicy.setInPlaceMailArchiveEnabled(backupPolicyElement.isInPlaceMailArchiveEnabled());
        backupPolicy.setBackupAllVersions(backupPolicyElement.isBackupAllVersions());
        backupPolicy.setContactsEnabled(backupPolicyElement.isContactsEnabled());
        backupPolicy.setTasksEnabled(backupPolicyElement.isTasksEnabled());
        backupPolicy.setCalendarEnabled(backupPolicyElement.isCalendarEnabled());
        backupPolicy.setShareEnabled(backupPolicyElement.isShareEnabled());
        backupPolicy.setAllowDownload(backupPolicyElement.isAllowDownload());
        backupPolicy.setComplexPassword(backupPolicyElement.isComplexPassword());
        backupPolicy.setShareExpireDateEnable(backupPolicyElement.isShareExpireDateEnable());
        backupPolicy.setHighSecureShareEnabled(backupPolicyElement.isHighSecureShareEnabled());
        backupPolicy.setSearchAlgoForPg(backupPolicyElement.getSearchAlgoForPg());
        backupPolicy.setEndpointUiPreferences(new ArrayList(backupPolicyElement.getEndpointUiPreferences()));
        backupPolicy.setOutlookFilters(new HashMap(backupPolicyElement.getOutlookFilters()));
        backupPolicy.setCanAdminRestore(backupPolicyElement.isCanAdminRestore());
        if (!CollectionUtils.isEmpty(oduserExcludedFodlers)) {
            backupPolicy.setExcludedFolders(new ArrayList());
            backupPolicy.getExcludedFolders().addAll(oduserExcludedFodlers);
        }
        if (existingOfficeBackupPolicy != null) {
            if (StringUtils.isEmpty((Object)existingOfficeBackupPolicy.getPrivacyGateways())) {
                existingOfficeBackupPolicy.setPrivacyGateways(new ArrayList());
            } else {
                PrivacyGatewayMappingElement privacyGatewayMappingElement = new PrivacyGatewayMappingElement();
                for (PrivacyGateway pb : existingOfficeBackupPolicy.getPrivacyGateways()) {
                    if (pb == null || StringUtils.isEmpty((Object)pb.getGatewayName())) continue;
                    existingPrivacyGateways.add(pb.getGatewayName());
                }
                privacyGatewayMappingElement.setPrivacyGatewayNames(existingPrivacyGateways);
                existingOfficeBackupPolicyElement.setPrivacyGatewayMappingElement(privacyGatewayMappingElement);
            }
            ArrayList existingFilters = existingOfficeBackupPolicy.getInclusionFilter();
            List existingFilterNames = existingFilters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(existingFilterNames)) {
                existingOfficeBackupPolicyElement.setFilterInclusionName(existingFilterNames);
            } else {
                existingOfficeBackupPolicyElement.setFilterInclusionName(new ArrayList());
            }
            ArrayList existingSearchFilters = existingOfficeBackupPolicy.getSearchInclusionFilter();
            List existingSearchFilterNames = existingSearchFilters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(existingSearchFilterNames)) {
                existingOfficeBackupPolicyElement.setSearchFilterInclusionName(searchFilterInclusionNames);
            } else {
                existingOfficeBackupPolicyElement.setSearchFilterInclusionName(new ArrayList());
            }
            OfficeBackupPolicyElement tempOfficeBackupPolicyElement = new OfficeBackupPolicyElement();
            BeanUtils.copyProperties((Object)backupPolicy, (Object)tempOfficeBackupPolicyElement);
            tempOfficeBackupPolicyElement.setBackupFolderPaths(odbackupFolderPaths);
            if (!StringUtils.isEmpty((Object)backupPolicy.getExcludedFolders())) {
                tempOfficeBackupPolicyElement.setExcludedFolderpaths(backupPolicy.getExcludedFolders().stream().filter(folder -> Objects.nonNull(folder.getFolderPath())).map(folder -> folder.getFolderPath()).collect(Collectors.toList()));
            }
            ArrayList inclusionFilterList = backupPolicy.getInclusionFilter();
            ArrayList<String> incList = new ArrayList<String>();
            for (InclusionFilter inclusionFilter : inclusionFilterList) {
                incList.add(inclusionFilter.getFilterName());
            }
            tempOfficeBackupPolicyElement.setFilterInclusionName(incList);
            ArrayList inclusionSearchFilterList = backupPolicy.getSearchInclusionFilter();
            ArrayList<String> inclusionSearchFilterNames = new ArrayList<String>();
            for (InclusionFilter inclusionSearchFilter : inclusionSearchFilterList) {
                inclusionSearchFilterNames.add(inclusionSearchFilter.getFilterName());
            }
            tempOfficeBackupPolicyElement.setSearchFilterInclusionName(inclusionSearchFilterNames);
            if (!StringUtils.isEmpty(existingOdBackupFolderPath)) {
                existingOfficeBackupPolicyElement.setBackupFolderPaths(existingOdBackupFolderPath);
            }
            if (!StringUtils.isEmpty(existingOdExcludedFolderPath)) {
                existingOfficeBackupPolicyElement.setExcludedFolderpaths(existingOdExcludedFolderPath);
            }
            tempOfficeBackupPolicyElement.setBackupFolderPaths(odbackupFolderPaths);
            if (!StringUtils.isEmpty((Object)backupPolicy.getExcludedFolders())) {
                tempOfficeBackupPolicyElement.setExcludedFolderpaths(backupPolicy.getExcludedFolders().stream().filter(folder -> Objects.nonNull(folder.getFolderPath())).map(folder -> folder.getFolderPath()).collect(Collectors.toList()));
            }
            if (!StringUtils.isEmpty(existingOdBackupFolderPath)) {
                existingOfficeBackupPolicyElement.setBackupFolderPaths(existingOdBackupFolderPath);
            }
            if (!StringUtils.isEmpty(existingOdExcludedFolderPath)) {
                existingOfficeBackupPolicyElement.setExcludedFolderpaths(existingOdExcludedFolderPath);
            }
            tempOfficeBackupPolicyElement.setPrivacyGatewayMappingElement(backupPolicyElement.getPrivacyGatewayMappingElement());
            tempOfficeBackupPolicyElement.setScheduleNames(odscheduleNames);
            OfficeBackupPolicyDiffFinder backupPolicyDiffFinder = new OfficeBackupPolicyDiffFinder();
            changedFields = backupPolicyDiffFinder.findDiff(existingOfficeBackupPolicyElement, tempOfficeBackupPolicyElement);
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (existingOfficeBackupPolicy != null) {
            ObjectId id = existingOfficeBackupPolicy.getId();
            BeanUtils.copyProperties((Object)backupPolicy, (Object)existingOfficeBackupPolicy);
            existingOfficeBackupPolicy.setId(id);
            existingOfficeBackupPolicy.getSchedules().clear();
            existingOfficeBackupPolicy.getSchedules().addAll(odschedules);
            existingOfficeBackupPolicy.getBackupFolders().clear();
            existingOfficeBackupPolicy.getBackupFolders().addAll(odbackupFolders);
            if (!CollectionUtils.isEmpty(oduserExcludedFodlers)) {
                existingOfficeBackupPolicy.getExcludedFolders().clear();
                existingOfficeBackupPolicy.getExcludedFolders().addAll(oduserExcludedFodlers);
            }
            existingOfficeBackupPolicy.setLastModifiedTimestamp(currentTimeMillis);
            this.setPrivacyGateWayElements(cloudId, cloudName, existingOfficeBackupPolicy, backupPolicyElement.getPrivacyGatewayMappingElement());
            existingOfficeBackupPolicy.setEndpointUiPreferences(new ArrayList(backupPolicyElement.getEndpointUiPreferences()));
            if (!StringUtils.isEmpty((Object)backupPolicyElement.getMsAppBluKrypt())) {
                existingOfficeBackupPolicy.setMsAppBluKrypt(backupPolicyElement.getMsAppBluKrypt());
            }
            existingOfficeBackupPolicy.setSearchFilterType(backupPolicyElement.getSearchFilterType());
            existingOfficeBackupPolicy.setFilterType(backupPolicyElement.getFilterType());
            existingOfficeBackupPolicy.setInPlaceMailArchiveEnabled(backupPolicyElement.isInPlaceMailArchiveEnabled());
            existingOfficeBackupPolicy.setBackupAllVersions(backupPolicyElement.isBackupAllVersions());
            existingOfficeBackupPolicy.setContactsEnabled(backupPolicyElement.isContactsEnabled());
            existingOfficeBackupPolicy.setTasksEnabled(backupPolicyElement.isTasksEnabled());
            existingOfficeBackupPolicy.setCalendarEnabled(backupPolicyElement.isCalendarEnabled());
            existingOfficeBackupPolicy.setCanAdminRestore(backupPolicyElement.isCanAdminRestore());
            existingOfficeBackupPolicy.setOutlookFilters(new HashMap(backupPolicyElement.getOutlookFilters()));
            existingOfficeBackupPolicy.setCompressionEnabled(backupPolicyElement.isCompressionEnabled());
            this.oneDriveBackupPolicyDao.saveOfficeBackupPolicy(cloudId, existingOfficeBackupPolicy);
            this.userDao.updateBackupPolicyModifiedTime(cloudId, existingOfficeBackupPolicy.getPolicyName());
            if (!StringUtils.isEmpty((Object)changedFields)) {
                String policyTypeName = backupPolicyElement.getPolicyType();
                if (policyTypeName != null) {
                    if (policyTypeName.contains("Sharepoint")) {
                        policyTypeName = policyTypeName + " Online";
                    } else if (policyTypeName.contains("Exchange")) {
                        policyTypeName = "Microsoft Exchange";
                    }
                }
                this.saveStatisticToDatabase(cloudId, cloudName, " modified  " + policyTypeName + " policy " + backupPolicyElement.getPolicygroupName() + ".The changed fields are " + changedFields, userName, "", PCActionTypes.BACKUP_POLICY_UPDATE.getActionTypeValue());
            }
        } else {
            backupPolicy.setLastModifiedTimestamp(currentTimeMillis);
            this.setPrivacyGateWayElements(cloudId, cloudName, backupPolicy, backupPolicyElement.getPrivacyGatewayMappingElement());
            if (!StringUtils.isEmpty((Object)backupPolicyElement.getMsAppBluKrypt())) {
                backupPolicy.setMsAppBluKrypt(backupPolicyElement.getMsAppBluKrypt());
            }
            backupPolicy.setSearchFilterType(backupPolicyElement.getSearchFilterType());
            backupPolicy.setFilterType(backupPolicyElement.getFilterType());
            backupPolicy.setInPlaceMailArchiveEnabled(backupPolicyElement.isInPlaceMailArchiveEnabled());
            backupPolicy.setBackupAllVersions(backupPolicyElement.isBackupAllVersions());
            backupPolicy.setContactsEnabled(backupPolicyElement.isContactsEnabled());
            backupPolicy.setTasksEnabled(backupPolicyElement.isTasksEnabled());
            backupPolicy.setCalendarEnabled(backupPolicyElement.isCalendarEnabled());
            backupPolicy.setCanAdminRestore(backupPolicyElement.isCanAdminRestore());
            backupPolicy.setOutlookFilters(new HashMap(backupPolicyElement.getOutlookFilters()));
            backupPolicy.setCompressionEnabled(backupPolicyElement.isCompressionEnabled());
            this.oneDriveBackupPolicyDao.saveOfficeBackupPolicy(cloudId, backupPolicy);
            this.saveStatisticToDatabase(cloudId, cloudName, "created", userName, backupPolicyElement.getPolicyType() + " policy name: " + backupPolicyElement.getPolicygroupName(), PCActionTypes.BACKUP_POLICY_CREATE.getActionTypeValue());
        }
        if (!CollectionUtils.isEmpty(existingOdBackFoldersList)) {
            this.backupFoldersDao.deleteBackupFoldersForPolicyId(cloudId, cloudName, existingOdBackFoldersList);
        }
        if (!CollectionUtils.isEmpty(existingMailBackFoldersList)) {
            this.backupFoldersDao.deleteBackupFoldersForPolicyId(cloudId, cloudName, existingMailBackFoldersList);
        }
    }

    private ArrayList<InclusionFilter> getFiltersbyName(int cloudId, String cloudName, List<String> filterNames) {
        ArrayList<InclusionFilter> inclusionFilters = new ArrayList<InclusionFilter>();
        for (String filterName : filterNames) {
            InclusionFilter inclusionFilter = this.inclusionFilterDao.getInclusionFilter(cloudId, cloudName, filterName);
            if (inclusionFilter == null) continue;
            inclusionFilters.add(inclusionFilter);
        }
        return inclusionFilters;
    }

    private List<BackupFolders> getBackupFolders(int cloudId, String cloudName, OfficeBackupPolicyElement backupPolicyElement, List<String> backupFolderPaths) {
        ArrayList<BackupFolders> backupFolders = new ArrayList<BackupFolders>();
        for (String backupFolderPath : backupFolderPaths) {
            BackupFolders backupFoldersObj = this.backupFoldersDao.getBackupFolders(cloudId, cloudName, backupFolderPath);
            if (backupFoldersObj == null) {
                backupFoldersObj = new BackupFolders();
                backupFoldersObj.setFolderPath(backupFolderPath);
                backupFoldersObj.setOs(backupPolicyElement.getOsType());
                this.backupFoldersDao.saveBackupFolders(cloudId, cloudName, backupFoldersObj);
            }
            backupFolders.add(backupFoldersObj);
        }
        return backupFolders;
    }

    private List<ExcludedFolders> getUserExclusionFolders(int cloudId, OfficeBackupPolicyElement backupPolicyElement, List<String> userExcludedFoldersPath) {
        ArrayList<ExcludedFolders> userExcludedFoldersList = new ArrayList<ExcludedFolders>();
        for (String backupFolderPath : userExcludedFoldersPath) {
            ExcludedFolders excludedFolders = this.excludedFoldersDao.getExcludedFoldersByPath(cloudId, backupFolderPath);
            if (excludedFolders == null || StringUtils.isEmpty((Object)excludedFolders.getFolderPath())) {
                excludedFolders = new ExcludedFolders();
                excludedFolders.setFolderPath(backupFolderPath);
                this.excludedFoldersDao.saveExcludedFolders(cloudId, excludedFolders);
            }
            userExcludedFoldersList.add(excludedFolders);
        }
        return userExcludedFoldersList;
    }

    @Override
    public OfficeBackupPolicyElement getBackupPolicy(int cloudId, String cloudName, String policyName, String policyType) {
        OfficeBackupPolicy backupPolicy = this.oneDriveBackupPolicyDao.getOfficeBackupPolicy(cloudId, policyName, policyType);
        return this.getOfficeBackupPolicyElement(cloudId, backupPolicy);
    }

    @Override
    public List<OfficeBackupPolicyElement> getAllBackupPolicies(int cloudId, String cloudName) {
        List backupPolicyList = this.oneDriveBackupPolicyDao.loadAllOneDriveBackupPolicies(cloudId);
        ArrayList<OfficeBackupPolicyElement> elements = new ArrayList<OfficeBackupPolicyElement>();
        for (OfficeBackupPolicy backupPolicy : backupPolicyList) {
            OfficeBackupPolicyElement element = this.getOfficeBackupPolicyElement(cloudId, backupPolicy);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public OfficeBackupPolicyElement getBackupPolicyForDevice(int cloudId, String cloudName, String deviceUUID) {
        return null;
    }

    private OfficeBackupPolicyElement getOfficeBackupPolicyElement(int cloudId, OfficeBackupPolicy backupPolicy) {
        OfficeBackupPolicyElement element = null;
        ArrayList<String> odfolderPaths = new ArrayList<String>();
        ArrayList<String> oduserExcludedFolderPaths = new ArrayList<String>();
        ArrayList<String> odScheduleNames = new ArrayList<String>();
        ArrayList calloutScriptStrs = new ArrayList();
        if (backupPolicy == null) {
            return null;
        }
        for (Schedule schedule : backupPolicy.getSchedules()) {
            odScheduleNames.add(schedule.getScheduleName());
        }
        for (BackupFolders backupFolder : backupPolicy.getBackupFolders()) {
            BackupFolderElement backupFolderElement = new BackupFolderElement();
            if (backupFolder == null) continue;
            backupFolderElement.setFolderPath(backupFolder.getFolderPath());
            backupFolderElement.setOsType(backupFolder.getOs());
            odfolderPaths.add(backupFolder.getFolderPath());
        }
        if (backupPolicy != null) {
            List searchFlterNames;
            ArrayList searchFilters;
            element = new OfficeBackupPolicyElement();
            BeanUtils.copyProperties((Object)backupPolicy, (Object)element);
            element.setSearchFilterType(backupPolicy.getSearchFilterType());
            element.setPolicygroupName(backupPolicy.getPolicyName());
            element.setBackupFolderPaths(new ArrayList());
            element.getBackupFolderPaths().addAll(odfolderPaths);
            element.setOutlookFilters(new HashMap());
            element.setOutlookFilters(backupPolicy.getOutlookFilters());
            if (!StringUtils.isEmpty((Object)backupPolicy.getExcludedFolders())) {
                for (ExcludedFolders userExcludedFolders : backupPolicy.getExcludedFolders()) {
                    ExcludedFolderElement userExcludedFolderElement = new ExcludedFolderElement();
                    if (userExcludedFolders == null) continue;
                    userExcludedFolderElement.setFolderPath(userExcludedFolders.getFolderPath());
                    oduserExcludedFolderPaths.add(userExcludedFolders.getFolderPath());
                }
                if (!oduserExcludedFolderPaths.isEmpty()) {
                    element.setExcludedFolderpaths(oduserExcludedFolderPaths);
                }
            }
            element.setCalloutScripts(calloutScriptStrs);
            ArrayList filters = backupPolicy.getInclusionFilter();
            List filterNames = filters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterNames)) {
                element.setFilterInclusionName(filterNames);
            }
            if (!CollectionUtils.isEmpty((Collection)(searchFilters = backupPolicy.getSearchInclusionFilter())) && !CollectionUtils.isEmpty(searchFlterNames = searchFilters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList()))) {
                element.setSearchFilterInclusionName(searchFlterNames);
            }
            element.setScheduleNames(new ArrayList());
            element.getScheduleNames().addAll(odScheduleNames);
            element.setEndpointUiPreferences((List)backupPolicy.getEndpointUiPreferences());
            ArrayList list = backupPolicy.getPrivacyGateways();
            PrivacyGatewayMappingElement mappingElement = new PrivacyGatewayMappingElement();
            ArrayList<String> pgList = new ArrayList<String>();
            for (PrivacyGateway privacyGateway : list) {
                if (privacyGateway == null) continue;
                mappingElement.setGatewayNwThrottlingName("PGThrottle-name");
                pgList.add(privacyGateway.getGatewayName());
            }
            mappingElement.setPrivacyGatewayNames(new ArrayList());
            mappingElement.setPrivacyGatewayNames(pgList);
            element.setPrivacyGatewayMappingElement(mappingElement);
            element.setSearchAlgoForPg(backupPolicy.getSearchAlgoForPg());
            element.setContentIndexEnabled(backupPolicy.isContentIndexEnabled());
            element.setCanAdminRestore(backupPolicy.isCanAdminRestore());
        }
        element.setFilterType(backupPolicy.getFilterType());
        logger.debug(element.getFilterType() + "...filt......content index enabled ... " + backupPolicy.isContentIndexEnabled());
        return element;
    }

    private void setPrivacyGateWayElements(int cloudId, String cloudName, OfficeBackupPolicy backupPolicy, PrivacyGatewayMappingElement privacyGatewayMappingElement) {
        List list = this.privacyGateWayDao.getAllGateways(cloudId);
        backupPolicy.setPrivacyGateways(new ArrayList());
        List pgList = privacyGatewayMappingElement.getPrivacyGatewayNames();
        for (String pgname : pgList) {
            PrivacyGateway gateway = this.getPrivacyGateWay(list, pgname);
            backupPolicy.getPrivacyGateways().add(gateway);
        }
    }

    private PrivacyGateway getPrivacyGateWay(List<PrivacyGateway> pgList, String gateWayName) {
        PrivacyGateway privacyGateway = null;
        for (PrivacyGateway gateway : pgList) {
            if (!gateway.getGatewayName().equals(gateWayName)) continue;
            privacyGateway = gateway;
            break;
        }
        return privacyGateway;
    }

    private void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser, int actionType) {
        AuditHistory audit = this.auditHistoryDefaultValue(action, actionByUser, actionType);
        audit.setActionOnObject(actionOnUser);
        this.auditHistoryDao.saveAudit(cloudId, cloudName, audit);
    }

    @Override
    public List<String> getAllBackupPolicyNames(int cloudId, String cloudName) {
        List backupPolicyList = this.oneDriveBackupPolicyDao.loadAllOneDriveBackupPolicies(cloudId);
        return backupPolicyList.stream().filter(policy -> !StringUtils.isEmpty((Object)policy.getPolicyName())).sorted(Comparator.comparing(OfficeBackupPolicy::getPolicyName)).map(policy -> policy.getPolicyName()).collect(Collectors.toList());
    }

    private AuditHistory auditHistoryDefaultValue(String action, String actionByUser, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setTimestamp(System.currentTimeMillis());
        audit.setActionUsingObject("Portal");
        audit.setActionType(actionType);
        return audit;
    }

    @Override
    public List<OfficeBackupPolicyElement> loadAllBackupPolicies(int cloudId, String policyType) {
        List backupPolicyList = this.oneDriveBackupPolicyDao.loadAllOneDriveBackupPolicies(cloudId, policyType);
        ArrayList<OfficeBackupPolicyElement> elements = new ArrayList<OfficeBackupPolicyElement>();
        for (OfficeBackupPolicy backupPolicy : backupPolicyList) {
            OfficeBackupPolicyElement element = this.loadAllBackupPolicyElements(cloudId, backupPolicy);
            element.setMappedUserCount(Long.toString(this.userDao.getODBBackupPolicyMappedUserCountbyPolicyName(cloudId, backupPolicy.getPolicyName(), policyType)));
            elements.add(element);
        }
        logger.debug("... total no of policies .." + elements.size());
        return elements;
    }

    @Override
    public List<OfficeBackupPolicyElement> getAllOfficePoliciesWithPagination(int cloudId, int pageNu, String policyType) {
        List backupPolicyList = this.oneDriveBackupPolicyDao.getAllOfficePoliciesWithPagination(cloudId, pageNu, policyType);
        ArrayList<OfficeBackupPolicyElement> elements = new ArrayList<OfficeBackupPolicyElement>();
        for (OfficeBackupPolicy backupPolicy : backupPolicyList) {
            OfficeBackupPolicyElement element = this.loadAllBackupPolicyElements(cloudId, backupPolicy);
            element.setMappedUserCount(Long.toString(this.userDao.getODBBackupPolicyMappedUserCountbyPolicyName(cloudId, backupPolicy.getPolicyName(), policyType)));
            elements.add(element);
        }
        logger.debug("... total no of policies .." + elements.size());
        return elements;
    }

    @Override
    public long getOfficeBkpPoliciesCount(int cloudId, String policyType) {
        return this.oneDriveBackupPolicyDao.getOfficeBkpPoliciesCount(cloudId, policyType);
    }

    private OfficeBackupPolicyElement loadAllBackupPolicyElements(int cloudId, OfficeBackupPolicy backupPolicy) {
        OfficeBackupPolicyElement element = null;
        ArrayList<String> odscheduleNames = new ArrayList<String>();
        if (backupPolicy == null) {
            return null;
        }
        if (!CollectionUtils.isEmpty((Collection)backupPolicy.getSchedules())) {
            for (Schedule schedule : backupPolicy.getSchedules()) {
                odscheduleNames.add(schedule.getScheduleName());
            }
        }
        if (backupPolicy != null) {
            element = new OfficeBackupPolicyElement();
            BeanUtils.copyProperties((Object)backupPolicy, (Object)element);
            element.setPolicygroupName(backupPolicy.getPolicyName());
            element.setScheduleNames(new ArrayList());
            element.getScheduleNames().addAll(odscheduleNames);
        }
        return element;
    }

    @Override
    public EditUserBackupPolicyMappingElement getBackupPolicyElements(int cloudId, List<String> userNames, User userObj, String policyType) {
        EditUserBackupPolicyMappingElement editUserBackupPolicyMappingElement = new EditUserBackupPolicyMappingElement();
        List<Object> managedPolicyNames = new ArrayList();
        if (userObj.isReadOnlyAdmin() && OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType)) {
            managedPolicyNames = userObj.getOdbPoliciesAdmin().stream().filter(exchangePolicyName -> exchangePolicyName.startsWith("EX_")).collect(Collectors.toList());
        } else if (userObj.isReadOnlyAdmin() && OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType)) {
            managedPolicyNames = userObj.getOdbPoliciesAdmin().stream().filter(odbPolicyName -> odbPolicyName.startsWith("ODB_")).collect(Collectors.toList());
        } else if (userObj.isReadOnlyAdmin() && OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType)) {
            managedPolicyNames = userObj.getOdbPoliciesAdmin().stream().filter(sharePointPolicyName -> sharePointPolicyName.startsWith("SP_")).collect(Collectors.toList());
        }
        List userList = this.userDao.searchUsers(cloudId, userNames, false);
        ArrayList<UserBackupPolicyMappingElement> elements = new ArrayList<UserBackupPolicyMappingElement>();
        for (User user : userList) {
            if (user.isSite() || (!userObj.isReadOnlyAdmin() || CollectionUtils.isEmpty(managedPolicyNames) || (!OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType) || !managedPolicyNames.contains(user.getExchangePolicyName())) && (!OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType) || !managedPolicyNames.contains(user.getOneDrivePolicyName())) && (!OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType) || !managedPolicyNames.contains(user.getSpPolicyName()))) && !userObj.isAdmin() || OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType) && !user.isOnedriveBkpEnabled() || OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType) && !user.isExchangeBkpEnabled()) continue;
            UserBackupPolicyMappingElement element = new UserBackupPolicyMappingElement();
            element.setBackupPolicyName(user.getOneDrivePolicyName());
            element.setOneDrivePolicyName(user.getOneDrivePolicyName());
            element.setExchangePolicyName(user.getExchangePolicyName());
            element.setSpPolicyName(user.getSpPolicyName());
            String userName = user.getUserName();
            element.setUserName(userName);
            elements.add(element);
        }
        List policyNamesList = null;
        List allOneDriveBackupPolicies = this.oneDriveBackupPolicyDao.loadAllOneDriveBackupPolicies(cloudId, policyType);
        if (userObj.isAdmin()) {
            policyNamesList = allOneDriveBackupPolicies.stream().filter(odbPolicy -> Objects.nonNull(odbPolicy.getPolicyName())).map(odbPolicy -> odbPolicy.getPolicyName()).collect(Collectors.toList());
        } else if (userObj.isReadOnlyAdmin()) {
            if (OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType)) {
                policyNamesList = userObj.getOdbPoliciesAdmin().stream().filter(exchangePolicyName -> exchangePolicyName.startsWith("EX_")).collect(Collectors.toList());
            } else if (OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType)) {
                policyNamesList = userObj.getOdbPoliciesAdmin().stream().filter(odbPolicyName -> odbPolicyName.startsWith("ODB_")).collect(Collectors.toList());
            } else if (OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType)) {
                policyNamesList = userObj.getOdbPoliciesAdmin().stream().filter(sharePointPolicyName -> sharePointPolicyName.startsWith("SP_")).collect(Collectors.toList());
            }
        }
        if (CollectionUtils.isEmpty(policyNamesList)) {
            policyNamesList = new ArrayList();
        }
        editUserBackupPolicyMappingElement.setUserBackupPolicyMappingElements(elements);
        editUserBackupPolicyMappingElement.setExistingPolicies(policyNamesList);
        return editUserBackupPolicyMappingElement;
    }

    @Override
    public List<OfficeBackupPolicyElement> getAllOfficePoliciesWithPagination(int cloudId, List<String> policyNames, int skipValue, String policyType) {
        List backupPolicyList = this.oneDriveBackupPolicyDao.getAllOfficePoliciesWithPagination(cloudId, policyNames, skipValue);
        ArrayList<OfficeBackupPolicyElement> elements = new ArrayList<OfficeBackupPolicyElement>();
        for (OfficeBackupPolicy backupPolicy : backupPolicyList) {
            OfficeBackupPolicyElement element = this.loadAllBackupPolicyElements(cloudId, backupPolicy);
            element.setMappedUserCount(Long.toString(this.userDao.getODBBackupPolicyMappedUserCountbyPolicyName(cloudId, backupPolicy.getPolicyName(), policyType)));
            elements.add(element);
        }
        logger.debug("... total no of policies .." + elements.size());
        return elements;
    }

    @Override
    public long getOfficeBkpPoliciesCount(int cloudId, List<String> policyNames, String policyType) {
        if (CollectionUtils.isEmpty(policyNames)) {
            return this.oneDriveBackupPolicyDao.getOfficeBkpPoliciesCount(cloudId, policyType);
        }
        return this.oneDriveBackupPolicyDao.getOfficeBkpPoliciesCount(cloudId, policyNames, policyType);
    }

    @Override
    public List<OfficeBackupPolicyElement> loadAllOfficePoliciesBasedOnType(int cloudId, String policyType) {
        List backupPolicyList = this.oneDriveBackupPolicyDao.loadAllOfficePoliciesBasedOnType(cloudId, policyType);
        ArrayList<OfficeBackupPolicyElement> elements = new ArrayList<OfficeBackupPolicyElement>();
        for (OfficeBackupPolicy backupPolicy : backupPolicyList) {
            OfficeBackupPolicyElement element = this.loadAllBackupPolicyElements(cloudId, backupPolicy);
            element.setMappedUserCount(Long.toString(this.userDao.getODBBackupPolicyMappedUserCountbyPolicyName(cloudId, backupPolicy.getPolicyName(), policyType)));
            elements.add(element);
        }
        logger.debug("... total no of policies .." + elements.size());
        return elements;
    }

    @Override
    public List<String> getAllOfficePolicyNames(int cloudId, String productType) {
        List backupPolicyList = this.oneDriveBackupPolicyDao.loadAllOfficePoliciesBasedOnType(cloudId, productType);
        return backupPolicyList.stream().filter(policy -> !StringUtils.isEmpty((Object)policy.getPolicyName())).sorted(Comparator.comparing(OfficeBackupPolicy::getPolicyName)).map(policy -> policy.getPolicyName()).collect(Collectors.toList());
    }

    @Override
    public OfficeBackupPolicyElement getOfficeBackupPolicyForDeviceUUID(int cloudId, String deviceUUID) {
        OfficeBackupPolicy backupPolicy = this.oneDriveBackupPolicyDao.getOfficeBackupPolicyForDeviceUUID(cloudId, deviceUUID);
        return this.getOfficeBackupPolicyElement(cloudId, backupPolicy);
    }
}

