#!/bin/bash
#Reference: https://medium.com/@myingole28/complete-guide-to-clamav-installation-and-setup-on-ubuntu-linux-29e65566665f

# Set environment PATHs
export PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:$PATH"

########################################
# Step 1: Install ClamAV
########################################

echo "[1/3] Installing ClamAV (First Time)..."

sudo apt-get update
sudo apt-get install -y clamav clamav-daemon

# Fix log issue before running freshclam
sudo killall -q freshclam || true
sudo rm -f /var/log/clamav/freshclam.log.lock
sudo touch /var/log/clamav/freshclam.log
sudo chown clamav:clamav /var/log/clamav/freshclam.log
sudo chmod 644 /var/log/clamav/freshclam.log

if ! grep -q "^TCPSocket" /etc/clamav/clamd.conf; then
    echo "TCPSocket 3310" >> /etc/clamav/clamd.conf
fi

if ! grep -q "^TCPAddr" /etc/clamav/clamd.conf; then
    echo "TCPAddr 127.0.0.1" >> /etc/clamav/clamd.conf
fi

if grep -q "^StreamMaxLength" /etc/clamav/clamd.conf; then
    sed -i 's/^StreamMaxLength.*/StreamMaxLength 4000M/' /etc/clamav/clamd.conf
else
    echo "StreamMaxLength 4000M" >> /etc/clamav/clamd.conf
fi

if grep -q "^MaxFileSize" /etc/clamav/clamd.conf; then
    sed -i 's/^MaxFileSize.*/MaxFileSize 4000M/' /etc/clamav/clamd.conf
else
    echo "MaxFileSize 4000M" >> /etc/clamav/clamd.conf
fi

# Fetch virus database BEFORE starting clamd
echo "Running freshclam to fetch virus database..."
sudo freshclam

# Start daemon AFTER virus DB exists
echo "Starting ClamAV daemon..."
sudo systemctl restart clamav-daemon

# Optional: verify clamd is running
echo "Checking if clamd is listening on 127.0.0.1:3310..."
for i in {1..5}; do
    if sudo ss -tulnp | grep -q '127.0.0.1:3310'; then
        echo "clamd is up and listening on 127.0.0.1:3310"
        break
    fi
    echo "Waiting for clamd... ($i/5)"
    sleep 10
done

echo "Restarting ClamAV FreshClam..."
sudo systemctl restart clamav-freshclam

echo "ClamAV installation completed."

########################################
# Step 2: Uninstall Completely
########################################
echo "[2/3] Uninstalling ClamAV completely..."

sudo systemctl stop clamav-freshclam
sleep 5
sudo systemctl stop clamav-daemon
sleep 5
sudo apt-get purge --auto-remove -y clamav clamav-daemon clamav-freshclam clamav-base
sudo rm -rf /etc/clamav
sudo rm -rf /var/lib/clamav
sudo rm -rf /var/log/clamav
sudo rm -rf /var/run/clamav
sudo apt-get autoremove --purge -y
sudo apt-get clean

sleep 10

########################################
# Step 3: ReIistall ClamAV
########################################

echo "[3/3] Reinstalling ClamAV..."

sudo apt-get update
sudo apt-get install -y clamav clamav-daemon

# Fix log issue before running freshclam
sudo killall -q freshclam || true
sudo rm -f /var/log/clamav/freshclam.log.lock
sudo touch /var/log/clamav/freshclam.log
sudo chown clamav:clamav /var/log/clamav/freshclam.log
sudo chmod 644 /var/log/clamav/freshclam.log

if ! grep -q "^TCPSocket" /etc/clamav/clamd.conf; then
    echo "TCPSocket 3310" >> /etc/clamav/clamd.conf
fi

if ! grep -q "^TCPAddr" /etc/clamav/clamd.conf; then
    echo "TCPAddr 127.0.0.1" >> /etc/clamav/clamd.conf
fi

if grep -q "^StreamMaxLength" /etc/clamav/clamd.conf; then
    sed -i 's/^StreamMaxLength.*/StreamMaxLength 4000M/' /etc/clamav/clamd.conf
else
    echo "StreamMaxLength 4000M" >> /etc/clamav/clamd.conf
fi

if grep -q "^MaxFileSize" /etc/clamav/clamd.conf; then
    sed -i 's/^MaxFileSize.*/MaxFileSize 4000M/' /etc/clamav/clamd.conf
else
    echo "MaxFileSize 4000M" >> /etc/clamav/clamd.conf
fi

# Fetch virus database BEFORE starting clamd
echo "Running freshclam to fetch virus database..."
sudo freshclam

# Start daemon AFTER virus DB exists
echo "Starting ClamAV daemon..."
sudo systemctl restart clamav-daemon

# Optional: verify clamd is running
echo "Checking if clamd is listening on 127.0.0.1:3310..."
for i in {1..5}; do
    if sudo ss -tulnp | grep -q '127.0.0.1:3310'; then
        echo "clamd is up and listening on 127.0.0.1:3310"
        break
    fi
    echo "Waiting for clamd... ($i/5)"
    sleep 10
done

echo "Restarting ClamAV FreshClam..."
sudo systemctl restart clamav-freshclam

echo "ClamAV installation completed."

