#!/bin/bash
#Reference: https://medium.com/@myingole28/complete-guide-to-clamav-installation-and-setup-on-ubuntu-linux-29e65566665f

# Set environment PATHs
export PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:$PATH"

echo "=== Updating package index ==="
sudo apt-get update

echo "=== Installing ClamAV and Daemon ==="
sudo apt-get install -y clamav clamav-daemon

CONF_FILE="/etc/clamav/clamd.conf"

# Stop freshclam daemon to avoid lock issues
echo "=== Stopping freshclam daemon ==="
sudo systemctl stop clamav-freshclam

# Run freshclam to update virus definitions
echo "=== Manually updating ClamAV database ==="
sudo freshclam

# Ensure config file exists
if [ ! -f "$CONF_FILE" ]; then
    echo "ERROR: $CONF_FILE not found!"
fi

# Configure clamd.conf as needed
echo "=== Updating clamd.conf ==="
grep "TCPSocket" "$CONF_FILE" || echo "TCPSocket 3310" | sudo tee -a "$CONF_FILE"
grep "TCPAddr" "$CONF_FILE" || echo "TCPAddr 127.0.0.1" | sudo tee -a "$CONF_FILE"

# Modify StreamMaxLength if exists, or add it
if grep -q "StreamMaxLength" "$CONF_FILE"; then
    sudo sed -i 's/StreamMaxLength .*/StreamMaxLength 4000M/' "$CONF_FILE"
else
    echo "StreamMaxLength 4000M" | sudo tee -a "$CONF_FILE"
fi

# Modify or add MaxFileSize
if grep -q "^MaxFileSize" "$CONF_FILE"; then
    echo "Updating MaxFileSize to 4000M"
    sudo sed -i 's/^MaxFileSize .*/MaxFileSize 4000M/' "$CONF_FILE"
else
    echo "MaxFileSize 4000M" | sudo tee -a "$CONF_FILE"
fi

# Restart ClamAV services to apply changes
echo "=== Restarting clamav-daemon ==="
sudo systemctl stop clamav-daemon
sleep 10
sudo systemctl start clamav-daemon

echo "=== Restarting freshclam daemon ==="
sudo systemctl start clamav-freshclam

# Show final statuses
echo "=== ClamAV Daemon Status ==="
sudo systemctl status clamav-daemon --no-pager

echo "=== freshclam Daemon Status ==="
sudo systemctl status clamav-freshclam --no-pager

echo "ClamAV installation and configuration complete!"

