<?php
use \Core\View;
use Helpers\Form;
use Helpers\Url;
use Core\Language;
use Helpers\Auth;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
if($data['userDetails']->{'sync-enabled'} == 'true' || $data['userDetails']->{'sync-webAccess-enabled'} == 'true'){
    $data['userDetails']->{'sync-enabled'} = 'true';
}
?>
<?php
if(googleAuthenticator == true){
include_once('/var/www/portal/app/views/login/GoogleAuthenticator.php');
$ga = new GoogleAuthenticator();
$website = MFATITLE; //Your Website
$title = $data['userDetails']->{'user-name'};
$secret = $data['userDetails']->{'google-secret-key'};
$qrCodeUrl = $ga->getQRCodeGoogleUrl($title, $secret,$website);
}
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <?php if($data['userDetails']->{'site'} != 'true'){ ?>
            <ol class="breadcrumb">
                <?php if(\Helpers\Auth::checkUserPermission('admin')){ ?>
                    <li><h3><a href="<?=Url::basePath('users')?>"><?=$data['title']?></a></h3></li>
                <?php }else{ ?>
                    <li><h3><?=$data['title']?></h3></li>
                <?php } ?>
                <li><?=$data['subPageName']?></li>
            </ol>
        <?php } else { ?>
            <ol class="breadcrumb">
                <li><a href="<?=Url::basePath('devices')?>"><h3><?='Assets'?></h3></a></li>
                <li><?=Language::show('Site', 'keywords')?></li>
            </ol>
        <?php } ?>
        </div>
    </div>
</div>
<div class="main" ng-controller="UserController">
    <span class="currentPage d-none"><?='myaccount'?></span>
    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <div class="row">
                <div class="col-lg-3">
                    <div class="sidebar">
                        <div class="side-menu">
                            <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?>
                                <div class="<?php if(D_PROFILE_PIC == false){echo 'd-none';}?>" ng-app="fileUpload" align="center">
                                    <br/>
                                    <img class="profileImg drop-box"
                                         ngf-select ngf-drop
                                         ng-model="file"
                                         ngf-drag-over-class="dragover"
                                         ngf-multiple="false"
                                         ngf-allow-dir="true"
                                         ngf-keep="false"
                                         ngf-src="file"
                                         ngf-pattern="'.jpg'"
                                         ngf-default-src="'<?=Url::profilePic($data['userDetails']->{'user-name'})?>'"
                                         accept="image/*" ngf-accept="'image/*'">
                                    <div ngf-no-file-drop><?=Language::show('drag_drop_not_supported', 'keywords');?></div>
                                </div>
                            <?php }else{ ?>
                                <div class="<?php if(D_PROFILE_PIC == false){echo 'd-none';}?>" align="center">
                                    <br/>
                                    <img class="profileImg" src="<?=Url::profilePic($data['userDetails']->{'user-name'})?>" />
                                </div>
                            <?php } ?>
                            <br/>
                            <div align="center">
                                <ul class="nav wordwrap">
				    <li><p><?=Language::show('name', 'keywords');?>: <span class="userName"><?=$data['userDetails']->{'user-name'};?></span></p></li>
				    <?php if($data['userDetails']->{'site'} != 'true'){ ?>
				    	<li><p><?=Language::show('email', 'keywords');?>: <?=$data['userDetails']->{'email-id'};?></p></li>
				    <?php } ?>
				    <li><p><?=Language::show('account_type', 'keywords');?>:
				    		<?php if($data['userDetails']->{'site'} == 'true'){
        						echo 'Site';
						      }else{
							    if((string)$data['userDetails']->{'is-admin'} == 'true'){
								echo 'Admin';
							    }elseif((string)$data['userDetails']->{'is-readonly-admin'} == 'true' && $data['userDetails']->{'delegated-admin'} == 'false'){
								//echo 'Read Only Admin';
								echo 'Delegated Administrator';
							    }elseif((string)$data['userDetails']->{'is-readonly-admin'} == 'true' && $data['userDetails']->{'delegated-admin'} == 'true'){
								//echo 'Read Only Admin';
								echo 'Read Only Admin';
							    }else{
								echo 'User';
							    }
						      }
				    		?>
				    </p></li>
                                    <li><p><?=Language::show('last_modified_time', 'keywords');?>: <?php if(!empty(((int)$data['userDetails']->{'last-modified-timestamp'}/1000))){echo date('d-M-y H:i:s', ((int)$data['userDetails']->{'last-modified-timestamp'}/1000));}else{echo 'Not Updated';}?></p></li>
                                    <?php if($data['lastLoggedInTime']){ ?>
                                    	<li><p><?=Language::show('last_loggedin_time', 'keywords');?>: <?php if(!empty(((int)$data['lastLoggedInTime']/1000))){echo date('d-M-y H:i:s', ((int)$data['lastLoggedInTime']/1000));}else{echo '-';}?></p></li>
                                    <?php } ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-9">
                    <div class="panel">
                        <div class="panel-heading <?php if($data['userDetails']->{'site'} == 'true'){ echo 'hide'; } ?>" style="border-bottom: 1px solid #f0f4f7; padding-bottom: 13px; padding-top: 15px;">
                            <span class="h4"><?=Language::show('profileDisplay', 'user');?></span>
                            <ul class="list list-inline <?php if(!isMobile()) { ?> float-right <?php } ?>">
				<?php if($data['readOnlyAdminUser'] == 'No'){ ?>                            
					<?php if($data['userDetails']->{'localUser'} == 'true'){ ?>
					<?php if($data['loggedInUser']['admin'] == true || $data['loggedInUser']['readOnlyAdmin'] == true){?>
					<?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?>
					     <li><a class="btn btn-default btn-small change" data-toggle="modal" data-target="#changePassword"><i class="fa fa-key"></i> <?=Language::show('change_password', 'keywords');?></a></li>
					 <?php } else {?>
					     <?php if($data['enableChangePasswordAdmin'] == 'true'){ ?>
						 <li><a class="btn btn-default btn-small reset" data-toggle="modal" data-target="#changePassword"><i class="fa fa-key"></i> <?=Language::show('Reset Password', 'keywords');?></a></li>
					 <?php } ?>
					 <?php } ?> 
					 <?php } else { ?>
					     <?php if($data['enableChangePasswordUser'] == 'true'){ ?>
						 <li><a class="btn btn-default btn-small change" data-toggle="modal" data-target="#changePassword"><i class="fa fa-key"></i> <?=Language::show('change_password', 'keywords');?></a></li>
					 <?php } ?>
					 <?php } ?>
					 <?php } ?>
				<?php } ?>                                 
                                <?php
				$ciphering = "AES-256-CBC";
				$iv_length = openssl_cipher_iv_length($ciphering);
				$options = 0;
				$encryption_iv = '2007199020071990';
				$encryption_key = "PORTAL";
				$encryption = openssl_encrypt($data['userDetails']->{'user-name'}, $ciphering,$encryption_key, $options, $encryption_iv);
				?>
				<li><a class="btn btn-default btn-small" href="<?=Url::basePath('user/settings/'.base64_encode($encryption))?>"><i class="fa fa-edit"></i> <?=Language::show('edit_profile', 'keywords');?></a></li>
                                <!--<li><a class="btn btn-default btn-small" href="<?=Url::basePath('user/settings/'.base64_encode($data['userDetails']->{'user-name'}))?>"><i class="fa fa-edit"></i> <?=Language::show('edit_profile', 'keywords');?></a></li>-->
                                <?php if($data['loggedInUser']['admin'] == true && $data['loggedInUser']['userName'] != $data['userDetails']->{'user-name'}){ ?>
                                    <span class="userStatusCollector d-none"><?php if($data['userDetails']->{'is-active'} == 'true'){echo true;}?></span>
                                    <?php if($data['userDetails']->{'localUser'} == 'false' && $data['count'] > 0){?>
                                    <li ng-show="userStatus">
                                        <a class="btn btn-default btn-small"             
                                           ng-bootbox-alert="<h4><?php echo $data['type'];?></h4>"
                                           ng-bootbox-alert-action=""
                                           href="javascript:;"><i class="fa fa-user-times"></i> <?=Language::show('Block Profile', 'keywords');?></a>
                                    </li>
                                    <?php }else{ ?>
                                    <li ng-show="userStatus">
                                        <a class="btn btn-default btn-small"
                                           ng-bootbox-confirm="<?=Language::show('blockConfirm', 'keywords')?>"
                                           ng-bootbox-confirm-action="blockUserProfile('<?=urlencode($data['userDetails']->{'user-name'});?>', 'true')"
                                           ng-bootbox-confirm-action-cancel=""
                                           href="javascript:;"><i class="fa fa-user-times"></i> <?=Language::show('Block Profile', 'keywords');?></a>
                                    </li>
                                    <?php } ?>       
                                    <?php if($data['userDetails']->{'localUser'} == 'false' && $data['count'] > 0){?>
                                    <li ng-hide="userStatus">
                                        <a class="btn btn-default btn-small"
                                           ng-bootbox-alert="<h4><?php echo $data['type'];?></h4>"
                                           ng-bootbox-alert-action=""
                                           href="javascript:;"><i class="fa fa-user-times"></i> <?=Language::show('UnBlock Profile', 'keywords');?></a>
                                    </li>
                                    <?php } else { ?>
                                    <li ng-hide="userStatus">
                                        <a class="btn btn-default btn-small"
                                           ng-bootbox-confirm="<?=Language::show('unBlockConfirm', 'keywords')?>"
                                           ng-bootbox-confirm-action="unBlockUserProfile('<?=urlencode($data['userDetails']->{'user-name'});?>', 'true')"
                                           ng-bootbox-confirm-action-cancel=""
                                           href="javascript:;"><i class="fa fa-user-plus"></i> <?=Language::show('UnBlock Profile', 'keywords');?></a>
                                    </li>
                                    <?php } ?>
                                    <?php if($data['userDetails']->{'localUser'} == 'true' || ($data['userDetails']->{'localUser'} == 'false' && $data['count'] > 0)){?>
                                    <li ng-hide="userStatus">
                                        <a class="btn btn-default btn-small"
                                           ng-bootbox-confirm="<?=Language::show('deleteConfirm', 'keywords')?>"
                                           ng-bootbox-confirm-action="deleteUserProfile('<?=urlencode($data['userDetails']->{'user-name'});?>', 'true')"
                                           ng-bootbox-confirm-action-cancel="" href="javascript:;"><i class="fa fa-trash"></i> <?=Language::show('Delete Profile', 'keywords');?></a>
                                    </li>
                                    <?php } ?>
                                <?php } ?>
				<?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'} && googleAuthenticator == true){ ?>
					<a class="btn btn-default btn-small" data-toggle="modal" data-target="#myQR"><i class="fa fa-qrcode"></i> <?=Language::show('My QR Code', 'keywords');?></a>
				<?php } ?>
                            </ul>
                        </div>
                        <div class="panel-body">
                            <div class="row <?php if($data['userDetails']->{'site'} == 'true'){ echo 'hide'; } ?>">
                                <div class="col-lg-12">
                                    <div class="col-lg-8">
                                        <h4>Access Details</h4>
                                        <ul class="list-group">
					<?php if(DISABLE_BLUSYNC == false){ ?>
                                            <?php if(Auth::checkCloudPermission('sync') == true){ ?>
                                                <li class="list-group-item"><?=Language::show('BluSync', 'keywords');?>: <?php if($data['userDetails']->{'sync-enabled'} =='true'){ echo '<label class="badge badge-success pull-right">'.Language::show('enabled', 'keywords').'</label>';}else{echo '<label class="badge badge-danger pull-right">'.Language::show('disabled', 'keywords').'</label>';}?></li>
                                            <?php } ?>
					<?php } ?>
					<?php if(DISABLE_BLUVAULT == false){ ?>
                                            <?php if(Auth::checkCloudPermission('backup') == true){ ?>
                                                <li class="list-group-item"><?=Language::show('backup', 'keywords');?>: <?php if($data['userDetails']->{'backup-enabled'} == 'true'){ echo '<label class="badge badge-success pull-right">'.Language::show('enabled', 'keywords').'</label>';}else{echo '<label class="badge badge-danger pull-right">'.Language::show('disabled', 'keywords').'</label>';}?></li>
                                            <?php } ?>
					<?php } ?>
					<?php if(Auth::checkCloudPermission('onedrive') == true){ ?>
						<li class="list-group-item"><?=Language::show('OneDrive Backup', 'keywords');?>: <?php if($data['userDetails']->{'onedriveBkpEnabled'} == 'true'){ echo '<label class="badge badge-success pull-right">'.Language::show('enabled', 'keywords').'</label>';}else{echo '<label class="badge badge-danger pull-right">'.Language::show('disabled', 'keywords').'</label>';}?></li>
					<?php } ?>
					<?php if(Auth::checkCloudPermission('exchange') == true){ ?>
						<li class="list-group-item"><?=Language::show('Exchange Backup', 'keywords');?>: <?php if($data['userDetails']->{'exchangeBkpEnabled'} == 'true'){ echo '<label class="badge badge-success pull-right">'.Language::show('enabled', 'keywords').'</label>';}else{echo '<label class="badge badge-danger pull-right">'.Language::show('disabled', 'keywords').'</label>';}?></li>
					<?php } ?>
                                        </ul>
                                    </div>
                                    <div class="col-lg-4 d-none">
                                        <h4>Storage Details</h4>
                                        <canvas id="storage" width="245" height="150" data-used="{{ userUsed }}" data-free="{{ userFree }}"></canvas>
                                        <span class="help-block text-center" style="color:black !important;">{{ userStorage }} GB* Used, out of {{ userLimit }} GB</span>
                                    </div>
                                </div>
                            </div>
                            <!--<div class="modal fade" id="changePassword" tabindex="-1">
                                <div class="modal-dialog">                                  
                                  <div class="modal-content">
                                    <?php if($data['loggedInUser']['userName'] != $data['userDetails']->{'user-name'}){ ?>
                                        <?= Form::open(array(
                                                'ng-submit' => 'resetPassword()',
                                                'method' => 'post',
                                                'id' => 'changePasswordForm',
                                                'csrf' => $data['csrf_token'],
                                                'autocomplete' => 'off',
                                                'data-parsley-validate' => true
                                            )); ?>
                                    <?php } else { ?>
                                        <?= Form::open(array(
                                                'ng-submit' => 'changePassword()',
                                                'method' => 'post',
                                                'id' => 'changePasswordForm',
                                                'csrf' => $data['csrf_token'],
                                                'autocomplete' => 'off',
                                                'data-parsley-validate' => true
                                            )); ?>
                                    <?php } ?>
                                    <div class="modal-header">
					<h4 class="modal-title" id="myModalLabel">Change Password</h4>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                    </div>
                                    <div class="modal-body">
                                        <input type="text" class="form-control d-none" name="username1" id="username1" value="<?=$data['userDetails']->{'user-name'}?>">
                                        <input type="text" class="form-control d-none" name="recoverykey1" id="recoverykey1" value="<?=$data['userDetails']->{'recovery-key'}?>">
					<input type="text" class="form-control d-none" name="googleSecretKey1" id="googleSecretKey1" value="<?=$data['userDetails']->{'google-secret-key'}?>">
                                        <div class="form-group <?php if($data['loggedInUser']['userName'] != $data['userDetails']->{'user-name'}){ echo 'd-none'; }?>">
                                        	<label for="password">Enter Old Password</label>
                                                <input type="password" class="form-control" name="oldpassword" id="oldpassword" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('old', 'keywords');?> <?=Language::show('password', 'keywords');?>" autocomplete="off">     
                                         </div>
                                      <div class="form-group">
                                                    <label for="password">Enter New Password</label>
                                                    <?php if(complexPassword == true) { ?>
                                                    <input type="password" name="password" class="form-control" id="password" placeholder="Enter a Password" data-parsley-minlength="6" data-parsley-required data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')" data-parsley-trigger="change">
                                                    <?php } else { ?>
                                                    <input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('new', 'keywords');?> <?=Language::show('password', 'keywords');?>" autocomplete="off" data-parsley-required data-parsley-minlength="6">
                                                    <?php } ?>
                                                    
                                                </div>
                                                <div class="form-group">
                                                    <label for="rePassword">Re Type Password</label>
                                                    <input type="password" name="rePassword" class="form-control" id="rePassword" placeholder="Re-Type the New Password" data-parsley-equalto="#password" data-parsley-trigger="change" data-parsley-required>
                                                </div>
                                    </div>
                                    <div class="modal-footer">
                                      <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('cancel', 'keywords');?></button>
                                      <button type="submit" id="changePasswordBtn" class="btn btn-primary"><?=Language::show('save', 'keywords');?></button>                  
                                    </div>
                                    <?= Form::close(); ?>
                                  </div>
                                  
                                </div>-->
                            </div>
<!--actions modal start-->
    <div class="modal fade deviceLogs">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
<!--                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                    <h4 class="modal-title">Device Actions</h4>
                </div>
                <div class="modal-body">
					<?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'eventHubForm',
                        'autocomplete' => 'off',
                        'ng-submit' => 'saveEventHub()',
                        'data-parsley-validate' => true
                    ));
                    ?>					
					<span class="d-none" id="actionToUserName"></span>
					<span class="d-none" id="actionToDeviceUUID"></span>
					<span class="d-none" id="deviceType"></span>
					<div class="row col-lg-12 d-none" style="margin-bottom: 10px;">
						<div class="col-lg-6">
							<p><b>Backup Policy Refresh</b>:</p>
						</div>
						<div class="col-lg-6">
							<input id="backupPolicyRefresh" name="backupPolicyRefresh" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
						</div>
					</div></br>
					<?php if(Auth::checkCloudPermission('backup')  || Auth::checkCloudPermission('office365')) {?>
					<div class="row col-lg-12" style="margin-bottom: 10px;">
 						<div class="col-lg-6">
 							<p><b>Current Backup Status</b>:</p>
 						</div>
 						<div class="col-lg-6">
                            			<center>
					       		<label ng-if="currentBackup == true">Running</label>
		                    	   		<label ng-if="currentBackup == false">Not Running</label>
                            			</center>
 						</div>
 					</div>
 					<?php } ?>
					<?php if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')) {?>
                                        <div class="row col-lg-12" style="margin-bottom: 10px;">
                                                <div class="col-lg-6">
                                                        <p><b>Current Restore Status</b>:</p>
                                                </div>
                                                <div class="col-lg-6">
                                                <center>
                                                        <label ng-if="currentRestore == true">Running</label>
                                                        <label ng-if="currentRestore == false">Not Running</label>
                                                </center>
                                                </div>
                                        </div>
                                        <?php } ?>
					<div class="row col-lg-12 agLogs" style="margin-bottom: 10px;">
                        <div class="col-lg-6">
                            <p><b>Pull Agent Logs</b>:</p>
                        </div>
                        <div class="col-lg-6">
                            <center>
                                <input id="agentLogs" name="agentLogs" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                                <div class="checkbox check-primary" id="historicalLogsBlock" style="display: none;margin-top: 8px;">
                                    <input id="historicalLogs" name="historicalLogs" type="checkbox" value="enabled">
                                    <label for="historicalLogs"><?=Language::show('Include Historical Logs', 'keywords');?></label>
                                    <input id="setupLogs" name="setupLogs" type="checkbox" value="enabled">
                                    <label for="setupLogs"><?=Language::show('Include Setup Logs', 'keywords');?></label>
                                    <input id="databases" name="databases" type="checkbox" value="enabled">
                                    <label for="databases"><?=Language::show('Include Databases', 'keywords');?></label>
                                </div>
                            </center>
                        </div>
                    </div>
                    <div class="row col-lg-12 fBackup" style="margin-bottom: 10px;display:none;">
                        <div class="col-lg-6">
                            <p><b>Full Backup</b>:</p>
                        </div>
                        <div class="col-lg-6">
                            <center>
                                <input id="fullBackup" name="fullBackup" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                            </center>
                        </div>
                    </div>
		     <?php //if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')) {?>
		     <input class="d-none" id="startBackupGet" name="startBackupGet" type="text" value="">
		     <div class="row col-lg-12 <?php if($data['readOnlyAdminUser'] == 'Yes'){ ?>hide<?php } ?><?php if($data['showBackupOptions'] != 'true'){?> hide <?php } ?>" style="margin-bottom: 10px;">
                         		<div class="col-lg-6">
                             		<p><b>Start Backup</b>:</p>
                         		</div>
                         		<div class="col-lg-6">
                                    <center>
                             			<a ng-if="buttonValue=='startBackup'" class="btn btn-small btn-success startBackup" ng-class="{'false': 'disabled'}[isAllowBackup]" id="startBackup" name="startBackup" val="No" ng-click="startBackupButton()">Start Backup</a>
                             			<a ng-if="buttonValue=='stopBackup'" class="btn btn-small btn-danger stopBackup" id="stopBackup" name="stopBackup" val="false" ng-bootbox-confirm="<h4>Stop Backup </h4><br><?=Language::show('Are you sure?', 'keywords')?>" ng-bootbox-confirm-action="stopBackupButton()" ng-bootbox-confirm-action-cancel="" href="javascript:;"><?=Language::show('Stop Backup', 'keywords');?></a>
                                        <a ng-if="buttonPauseValue=='pauseBackup'" class="btn btn-small btn-danger pauseBackup" id="pauseBackup" name="pauseBackup" val="false" ng-click="pauseBackupButton()">Pause Backup</a>
                             			<a ng-if="buttonValue=='cancelBackup'" class="btn btn-small btn-warning cancelBackup" id="cancelBackup" name="cancelBackup" val="No" ng-click="cancelBackupButton()">Cancel Schedule</a>
                                    </center>
                                </div>
                    </div>
                    <?php //} ?>
		    <?php //if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')) {?>
		    <input class="d-none" id="startRestoreGet" name="startRestoreGet" type="text" value="">
                    <div class="row col-lg-12 d-none" style="margin-bottom: 10px;">
                                        <div class="col-lg-6">
                                        <p><b>Restore</b>:</p>
                                        </div>
                                        <div class="col-lg-6">
                                    <center>
                                                <a ng-if="buttonValueRestore=='startRestore'" class="btn btn-small btn-success startRestore" id="startRestore" name="startRestore" val="No" ng-click="startRestoreButton()">Start Restore</a>
                                                <a ng-if="buttonValueRestore=='stopRestore'" class="btn btn-small btn-danger stopRestore" id="stopRestore" name="stopRestore" val="false" ng-bootbox-confirm="<h4>Stop Restore </h4><br><?=Language::show('Are you sure?', 'keywords')?>" ng-bootbox-confirm-action="stopRestoreButton()" ng-bootbox-confirm-action-cancel="" href="javascript:;"><?=Language::show('Stop Restore', 'keywords');?></a>
<!--                                        <a ng-if="buttonPauseValueRestore=='pauseRestore'" class="btn btn-small btn-danger pauseRestore" id="pauseRestore" name="pauseRestore" val="false" ng-click="pauseRestoreButton()">Pause Restore</a>-->
                                                <a ng-if="buttonValueRestore=='cancelRestore'" class="btn btn-small btn-warning cancelRestore" id="cancelRestore" name="cancelRestore" val="No" ng-click="cancelRestoreButton()">Cancel Restore</a>
                                    </center>
                                </div>
                    </div>
                    <?php //} ?>
                    <div class="row col-lg-12 stopBackupWhileRestoreBlock d-none">
                        <div class="col-lg-6">
                             <label for="stopBackupWhileRestoree" style="font-weight:600!important;"><?=Language::show('Disable Backup:', 'keywords');?></label>
                        </div>
                        <div class="form-group col-lg-6">
                            <center>
                                <label class="switch">
                                    <input id="stopBackupWhileRestore" name="stopBackupWhileRestore" type="checkbox">
                                    <div class="slider round"></div>
                                </label>
                            </center>
                        </div>
                    </div>
                    <p>Note: Some of the changes may take effect only during next policy refresh.</p>
                    <?= Form::close(); ?>
                </div>
                <div class="modal-footer">
					<!--<button type="submit" class="btn btn-primary">Save changes</button>-->
					<a class="btn btn-success disabled" id="saveBtn" data-dismiss="modal" ng-click="saveEventHub()">Save</a>
                    <button type="button" id="modalClose" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
<!--actions modal end-->			
			    
<?php //if($data['userDetails']->{'backup-enabled'} =='true' || $data['userDetails']->{'onedriveBkpEnabled'} == 'true' || $data['userDetails']->{'exchangeBkpEnabled'} == 'true'){ ?>			    
<?php if(DISABLE_BLUVAULT == false){ ?>
                            <?php //if(($data['userDetails']->{'backup-enabled'} == 'true' || $data['userDetails']->{'onedriveBkpEnabled'} == 'true') && $data['userDetails']->{'is-guest'} == 'false'){ ?>
                                <div class="row col-lg-12 userDevices" style="display: none;margin-top:10px;">
                                    <div class="col-lg-12">
					<h4>
					<?php if($data['userDetails']->{'site'} == 'true'){ ?>
<?=Language::show('My Sites', 'user');?>
<?php }else{ ?>
<?=Language::show('myDevices', 'user');?>	
<?php } ?>
					</h4>
					<span id="final"></span>
                                    </div>

              	<?php if($data['loggedInUser']['admin'] == true || $data['loggedInUser']['readOnlyAdmin'] == true) { ?>
                                    <div ng-if="value.storageUsedByDevice != null" ng-repeat="value in userDevices track by $index" class="col-lg-4 userDevicemydevice{{$index}}" id="userDevicemydevice{{$index}}" block-ui="myBlockUImydevice{{$index}}">
                                <?php } else { ?>
                                    <div <?php if($data['userDetails']->{'is-readonly-admin'} != 'true' && $data['userDetails']->{'is-admin'} != 'true'){ ?> <?php } ?> ng-if="value.storageUsedByDevice != null" ng-repeat="value in userDevices track by $index" class="col-lg-4 userDevicemydevice{{$index}}" id="userDevicemydevice{{$index}}" block-ui="myBlockUImydevice{{$index}}">
                                <?php } ?>
                                        <div class="panel panel-default no-box-shadow widget-{{ value.background }}" <?php if($data['rwDetectionEnabled'] == 'true'){?> ng-class="{'true':'alerts-border'}[value.showBlink]" <?php } ?>>
                                            <div class="devicebackground">
						<i ng-if="value.deviceType !='SHAREPOINT'" class="fa fa-{{ value.os }}"></i>
<!--<img ng-if="value.deviceType =='SHAREPOINT'" src="<?=Url::templatePath()?>images/SharePoint-Logo.wine.svg" />-->
                                            </div>
                                            <div class="panel-heading widget-header">
                                                <a class="displayNameTrimmedmydevice{{$index}}" title="{{ value.deviceDisplayName }}">{{ value.deviceDisplayName | limitTo:15}}{{value.deviceDisplayName.length > 15 ? '...' : ''}}</a>
                                                <a class="displayNameNotTrimmedmydevice{{$index}} hide" title="{{ value.deviceDisplayName }}">{{ value.deviceDisplayName}}</a>
                                                <a class="dropdown-toggle pull-right toolTip" data-toggle="dropdown" data-placement="right" title="Details" href="javascript:;"><i class="fa fa-bars"></i></a>
                                                <ul class="dropdown-menu">
<?php if($data['showBackupOptions'] == 'true'){?>							
<!--exp new start-->
<?php if($data['loggedInUser']['admin'] == true || $data['loggedInUser']['readOnlyAdmin'] == true){ ?>
    <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'} && $data['userDetails']->{'is-active'} == 'true'){?>
            <li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
            <li ng-if="value.icon == 'cloud'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
            <li ng-if="value.icon == 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
            <li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceNameEncoded+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
    <?php }else{ ?>
    <?php if($data['readOnlyAdminUser'] == 'No'){ ?>
            <?php if($data['showButtons'] == 'true'){?>
		<?php if($data['allowEndUserTocontrolRestoreGS'] == 'true'){ ?>
			<?php if($data['userDetails']->{'is-active'} == 'true'){?>							
                	<li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" ng-show="value.canAdminRestore == true" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
                	<li ng-if="value.icon == 'cloud'" ng-show="value.canAdminRestore == true" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
			<li ng-if="value.icon == 'envelope'" ng-show="value.canAdminRestore == true" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
                	<li ng-show="value.canAdminRestore == true"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceNameEncoded+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
			<?php } ?>
		<?php } else { ?>
			<?php if($data['userDetails']->{'is-active'} == 'true'){?>
				<li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
                		<li ng-if="value.icon == 'cloud'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
				<li ng-if="value.icon == 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
				<li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceNameEncoded+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
			<?php } ?>							
		<?php } ?>
            <?php } ?>
            <?php if($data['showBackupButtons'] == 'true'){?>
		<?php if($data['allowEndUserTocontrolRestoreBP'] == 'true'){ ?>
			<?php if($data['userDetails']->{'is-active'} == 'true'){?>
                	<li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" ng-show="value.canAdminRestore == true" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
                	<li ng-show="value.canAdminRestore == true"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceNameEncoded+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
			<?php } ?>							
		<?php } else { ?>
			<?php if($data['userDetails']->{'is-active'} == 'true'){?>
			<li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
                	<li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceNameEncoded+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
			<?php } ?>
		<?php } ?>
            <?php } ?>
	    <!--new logic starts-->
	    <?php if($data['showOnedriveButtons'] == 'true'){?>
                <?php if($data['allowEndUserTocontrolRestoreOP'] == 'true'){ ?>
			<?php if($data['userDetails']->{'is-active'} == 'true'){?>
                        <li ng-if="value.icon == 'cloud'" ng-show="value.canAdminRestore == true" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>                        
                        <li ng-if="value.icon == 'cloud'" ng-show="value.canAdminRestore == true"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
			<?php } ?>							
                <?php } else { ?>
			<?php if($data['userDetails']->{'is-active'} == 'true'){?>
                        <li ng-if="value.icon == 'cloud'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>                        
                        <li ng-if="value.icon == 'cloud'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
			<?php } ?>
                <?php } ?>
            <?php } ?>
            <?php if($data['showExchangeButtons'] == 'true'){?>
                <?php if($data['allowEndUserTocontrolRestoreEX'] == 'true'){ ?>
			<?php if($data['userDetails']->{'is-active'} == 'true'){?>
                        <li ng-if="value.icon == 'envelope'" ng-show="value.canAdminRestore == true" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
                        <li ng-if="value.icon == 'envelope'" ng-show="value.canAdminRestore == true"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
			<?php } ?>
                <?php } else { ?>
			<?php if($data['userDetails']->{'is-active'} == 'true'){?>
                        <li ng-if="value.icon == 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
                        <li ng-if="value.icon == 'envelope'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
			<?php } ?>
                <?php } ?>
            <?php } ?>
            <?php if($data['showSharepointButtons'] == 'true'){?>
                <?php if($data['allowEndUserTocontrolRestoreSP'] == 'true'){ ?>
			<?php if($data['userDetails']->{'is-active'} == 'true'){?>
                        <li ng-show="value.canAdminRestore == true" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
                        <li ng-show="value.canAdminRestore == true"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
			<?php } ?>
                <?php } else { ?>
			<?php if($data['userDetails']->{'is-active'} == 'true'){?>
                        <li class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
                        <li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
			<?php } ?>
                <?php } ?>
            <?php } ?>
	    <!--new logic ends-->					
	    <!--old logic starts-->							
            <?php //if($data['showOnedriveButtons'] == 'true'){?>
		<?php //if($data['allowEndUserTocontrolRestoreOP'] == 'true'){ ?>
                	<!--<li ng-if="value.icon == 'cloud'" ng-show="value.canAdminRestore == true" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
                	<li ng-if="value.icon == 'envelope'" ng-show="value.canAdminRestore == true" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
                	<li ng-show="value.canAdminRestore == true"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>-->
		<?php //} else { ?>
			<!--<li ng-if="value.icon == 'cloud'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
                	<li ng-if="value.icon == 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
                	<li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>-->
		<?php //} ?>
            <?php //} ?>
	    <!--old logic ends-->							
    <?php } ?>
	    <?php //if($data['userDetails']->{'site'} == 'true'){ ?>
		<!--<li class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
		<li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>-->
	    <?php //} ?>
    <?php } ?>
<?php }else{ ?>
	<?php if($data['userDetails']->{'is-active'} == 'true'){?>
            <li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
            <li ng-if="value.icon == 'cloud'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
            <li ng-if="value.icon == 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
	    <?php if($data['bkpRestore'] == 'true'){?>
            <li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
	    <?php } ?>
	<?php } ?>
<?php } ?>
<!--exp new end-->							
<!--exp start-->
<!--							
<?php if($data['loggedInUser']['admin'] == true || $data['loggedInUser']['readOnlyAdmin'] == true){ ?>
    <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){?>        
<li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
<?php }else { ?>
<?php if($data['canAdminRestore'] == true){?>
                <?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'backup-enabled'} == 'true'){?>
<?php if(($data['userDetails']->{'backupPolicyElement'}->{'allowEndUserTocontrolRestore'} == 'true' && $data['userDetails']->{'backupPolicyElement'}->{'canAdminRestore'} == 'true') || ($data['userDetails']->{'backupPolicyElement'}->{'allowEndUserTocontrolRestore'} == 'false' && $data['userDetails']->{'backupPolicyElement'}->{'canAdminRestore'} == 'true')){ ?>
                        <li <?php if($data['userDetails']->{'backupPolicyElement'}->{'canAdminRestore'} == 'true' && $data['userDetails']->{'backupPolicyElement'}->{'allowEndUserTocontrolRestore'} == 'true'){ ?>ng-show="value.canAdminRestore == true" <?php } ?> ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
<?php } ?>
<?php } ?>
<?php } ?>
<?php } ?>
<?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){?>
<li ng-if="value.icon != 'cloud' && value.icon != 'envelope'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
<?php } else { ?>
<?php if($data['canAdminRestore'] == true){?>
<?php if(($data['userDetails']->{'backupPolicyElement'}->{'allowEndUserTocontrolRestore'} == 'true' && $data['userDetails']->{'backupPolicyElement'}->{'canAdminRestore'} == 'true') || ($data['userDetails']->{'backupPolicyElement'}->{'allowEndUserTocontrolRestore'} == 'false' && $data['userDetails']->{'backupPolicyElement'}->{'canAdminRestore'} == 'true')){ ?>
                <?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'backup-enabled'} == 'true'){?>
                        <li <?php if($data['userDetails']->{'backupPolicyElement'}->{'canAdminRestore'} == 'true' && $data['userDetails']->{'backupPolicyElement'}->{'allowEndUserTocontrolRestore'} == 'true'){ ?> ng-show="value.canAdminRestore == true" <?php } ?>  ng-if="value.icon != 'cloud' && value.icon != 'envelope'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
                <?php } ?>
<?php } ?>
        <?php } ?>
        <?php } ?>
        <?php if($data['userDetails']->{'officeBackupPolicyElement'}->{'canAdminRestore'} == 'true' || $data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){?>
                <?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'onedriveBkpEnabled'} == 'true'){?>
                        <li ng-if="value.icon == 'cloud'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
                <?php } ?>
<?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'exchangeBkpEnabled'} == 'true'){?>
                        <li ng-if="value.icon == 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
							<?php } ?>
        <?php if($data['ODBRestore'] == 'true'){ ?>
                <?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'onedriveBkpEnabled'} == 'true'){?>
                        <li ng-if="value.icon == 'cloud'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
                <?php } ?>
                <?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'exchangeBkpEnabled'} == 'true'){?>
                        <li ng-if="value.icon == 'envelope'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
                <?php } ?>
        <?php } ?>
        <?php } ?>
    <?php //} ?>
<?php }else{ ?>
        <?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'backup-enabled'} == 'true'){?>
                <li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
        <?php } ?>
<?php if($data['bkpRestore'] == 'true'){ ?>
                <?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'backup-enabled'} == 'true'){?>
                        <li ng-if="value.icon != 'cloud' && value.icon != 'envelope'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
                <?php } ?>
        <?php } ?>
        <?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'onedriveBkpEnabled'} == 'true'){?>
                <li ng-if="value.icon == 'cloud'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
        <?php } ?>
							<?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'exchangeBkpEnabled'} == 'true'){?>
                <li ng-if="value.icon == 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
        <?php } ?>
        <?php if($data['ODBRestore'] == 'true'){ ?>
                <?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'onedriveBkpEnabled'} == 'true'){?>
                        <li ng-if="value.icon == 'cloud'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
                <?php } ?>
                <?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'exchangeBkpEnabled'} == 'true'){?>
                        <li ng-if="value.icon == 'envelope'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
                <?php } ?>
        <?php } ?>

<?php } ?>-->
<!--exp end-->
<?php } ?>
<li><a href="javascript:;" ng-click="restorableSizeMethod(value.deviceUUID)"><?=Language::show('Restorable Size', 'keywords');?></a></li>
<?php
$ciphering = "AES-256-CBC";
$iv_length = openssl_cipher_iv_length($ciphering);
$options = 0;
$encryption_iv = '2007199020071990';
$encryption_key = "PORTAL";
$encryption = openssl_encrypt($data['userDetails']->{'user-name'}, $ciphering,$encryption_key, $options, $encryption_iv);
?>
<li><a href="<?=Url::basePath('user/backupHistory/'.base64_encode($encryption).'/{{ value.deviceUUID }}/{{value.deviceNameEncoded}}')?>"><?=Language::show('backup_activity_history', 'keywords');?></a></li>
<!--<li><a href="<?=Url::basePath('user/backupHistory/'.base64_encode($data['userDetails']->{'user-name'}).'/{{ value.deviceUUID }}/{{value.deviceName}}')?>"><?=Language::show('backup_activity_history', 'keywords');?></a></li>-->
<?php if($data['showBackupOptions'] == 'true'){ ?>						    
						    <?php if($data['userDetails']->{'is-active'} == 'true' && ($data['userDetails']->{'backup-enabled'} == 'true' || $data['userDetails']->{'onedriveBkpEnabled'} == 'true' || $data['userDetails']->{'exchangeBkpEnabled'} == 'true')){?>
                                                    	<!--<li><a href="<?=Url::basePath('user/device/policyInfo/'.base64_encode($data['userDetails']->{'user-name'}).'/{{ value.deviceUUID }}/{{ value.icon }}')?>"><?=Language::show('policy_configuration', 'keywords');?></a></li>-->
							<?php if($data['showBackupSettingsForBackupDevice'] == 'true'){?>
                                                        	<li ng-if="value.icon != 'cloud' && value.icon != 'envelope' && value.blocked == 'active'" ><a href="<?=Url::basePath('user/device/policyInfo/'.base64_encode($data['userDetails']->{'user-name'}).'/{{ value.deviceUUID }}/{{ value.icon }}')?>"><?=Language::show('policy_configuration', 'keywords');?></a></li>
							<?php } ?>
							<li ng-if="value.icon == 'cloud' && value.blocked == 'active'"><a href="<?=Url::basePath('user/device/policyInfo/'.base64_encode($data['userDetails']->{'user-name'}).'/{{ value.deviceUUID }}/{{ value.icon }}')?>"><?=Language::show('policy_configuration', 'keywords');?></a></li>
							<li ng-if="value.icon == 'envelope' && value.blocked == 'active'"><a href="<?=Url::basePath('user/device/policyInfo/'.base64_encode($data['userDetails']->{'user-name'}).'/{{ value.deviceUUID }}/{{ value.icon }}')?>"><?=Language::show('policy_configuration', 'keywords');?></a></li>
						    <?php } ?>
<?php } ?>							
						    <?php //if($data['loggedInUser']['admin'] == true || $data['loggedInUser']['readOnlyAdmin'] == true){ ?>
						    <?php if($data['loggedInUser']['admin'] == true || $data['ECD'] == 'true'){ ?>
						    	<li ng-if="value.deviceType != 'SHAREPOINT'"><a href="" ng-bootbox-confirm="<h4><?=Language::show('blockConfirmDevice', 'keywords')?></h4>" ng-bootbox-confirm-action="blockUnBlockDevice(value.deviceUUID, true,value.userName, value.deviceName)" ng-bootbox-confirm-action-cancel="" ng-if="value.blocked == 'active'"><?=Language::show('block', 'keywords');?></a></li>
							<?php if($data['userDetails']->{'is-active'} == 'true'){ ?>
						    		<li ng-if="value.deviceType != 'SHAREPOINT'"><a href="" ng-bootbox-confirm="<h4><?=Language::show('unBlockConfirmDevice', 'keywords')?></h4>" ng-bootbox-confirm-action="blockUnBlockDevice(value.deviceUUID, false,value.userName, value.deviceName)" ng-bootbox-confirm-action-cancel="" ng-if="value.blocked != 'active'"><?=Language::show('Unblock', 'keywords');?></a></li>
							<?php } ?>
						    	<li ng-if="value.deviceType != 'SHAREPOINT'"><a href="" ng-bootbox-confirm="<h4><?=Language::show('deleteConfirmDevice', 'keywords')?></h4><br><span style='font-size:12px;'>Note : This action will result in <u>permanently</u> deleting all backups for this device.  Are you sure you wish to proceed?</span>" ng-bootbox-confirm-action="deleteDevice(value.deviceUUID,value.userName, value.deviceName)" ng-bootbox-confirm-action-cancel="" ng-if="value.blocked != 'active'"><?=Language::show('Delete', 'keywords');?></a></li>							
						    	<li ng-if="value.decoupled == false && value.blocked == 'active'"><a href="" ng-click="logAction(value.deviceUUID,value.deviceType)" >Actions</a></li>
						    <?php } ?>
                                                </ul>
                                                <?php //if($data['showBackupOptions'] == 'true'){ ?>
                                                	<a class="pull-right eye hide" ng-click="viewDeviceDetails($index, value.deviceUUID,'mydevice',value.deviceType)" href="javascript:;"><i class="fa fa-eye"></i></a>
                                                <?php //} ?>
                                            </div>
                                            <div class="panel-body widget widget-body">
						<i ng-if="value.deviceType != 'SHAREPOINT'" ng-click="viewDeviceDetails($index, value.deviceUUID,'mydevice',value.deviceType)" class="clickAble fa fa-{{ value.os }}"></i>
						<img ng-if="value.deviceType == 'SHAREPOINT'" src="<?=Url::templatePath()?>images/SharePoint-Logo.wine.svg?>" class="clickAble" ng-click="viewDeviceDetails($index, value.deviceUUID,'mydevice',value.deviceType)" style="height:40px;width:40px;">
                                                <?php //if($data['showBackupOptions'] == 'true'){ ?>
						    <a style="font-size: 18px;margin-top: -10px; margin-right: 13px;" class="pull-right" ng-cloak>{{ value.storageUsedByDevice }}*</a>
						<?php //} ?>
                                                <div class="row expandDetailsmydevice{{$index}} col-lg-12" style="font-size: 10px; color: #FFFFFF; display: none;">
                                                    <?php if(!isMobile()){ ?>
                                                    <div class="col-lg-6" style="padding: 30px 10px 10px 35px;">
                                                        <?php }else{ ?>
                                                    <div class="col-lg-12" style="padding: 30px 10px 10px 35px;">
                                                    <?php } ?>
                                                        <p>Last Successful Backup:
                                                            <b class="pull-right" ng-if="deviceDetails.lastSuccessBackup == null" ng-cloak>Not completed yet</b>
                                                            <b class="pull-right" ng-if="deviceDetails.lastSuccessBackup != null" ng-cloak>{{deviceDetails.lastSuccessBackup}}</b>
                                                        </p>
                                                        <p>Next Scheduled Backup:
                                                            <b class="pull-right" ng-if="deviceDetails.nextScheduledBackup != null" ng-cloak>{{deviceDetails.nextScheduledBackup}}</b>
                                                            <b class="pull-right" ng-if="deviceDetails.nextScheduledBackup == null" ng-cloak>-</b>
                                                        </p>
                                                        <p ng-if="value.deviceType != 'SHAREPOINT'">Policy Refresh Frequency:
                                                                <b class="pull-right" ng-if="deviceDetails.nextPolicyRefresh != null" ng-cloak>{{deviceDetails.nextPolicyRefresh}} hours</b>
                                                                <b class="pull-right" ng-if="deviceDetails.nextPolicyRefresh == null">-</b>
							</p>
							<?php if($data['showLatestBkpInfo'] == true){?>
                                                            <p>Total Size of Restorable Data(Latest Version): <b class="pull-right" ng-cloak>{{deviceDetails.totalSizeOfDataInCurrentBackupLatestVersion}}</b></p>
                                                        <?php } ?>
							<p>Device registered on: <b class="pull-right" ng-cloak>{{deviceDetails.createdTimeStamp}}</b></p>
                                                    <?php if(!isMobile()){ ?></div>
                                                    <div class="col-lg-6" style="padding: 30px 10px 10px 35px;"><?php } ?>
                                                        <p ng-if="deviceDetails.osType != 'ONEDRIVE'">Operating System: <b class="pull-right" ng-cloak>{{deviceDetails.osTypeDisplay.replace("(unknown)", "");}} {{deviceDetails.version}}</b></p>
                                                        <p ng-if="deviceDetails.osType != 'ONEDRIVE' && value.deviceType != 'SHAREPOINT'">End Point Agent Version: <b class="pull-right" ng-cloak>{{deviceDetails.productVersion}}</b></p>
                                                        <p>Storage Media: <b class="pull-right" ng-cloak>{{deviceDetails.storageMedia}}</b></p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="h4 loading text-center">Loading ...</div>
<hr>
			<?php } ?>
<?php //} ?>
<!--new blockedDevices -->
<!--<div class="row blockedDevices" style="display: none;">
<div class="col-lg-12">
                                        <h4><?=Language::show('Blocked Devices', 'user');?></h4>
</div>
<div ng-if="value.storageUsedByDevice != null" ng-repeat="value in blockedDevices track by $index" class="col-lg-4 userDeviceblockeddevice{{$index}}" id="userDeviceblocked{{$index}}" block-ui="myBlockUIblockeddevice{{$index}}">
                                        <div class="panel panel-default no-box-shadow widget-{{ value.background }}">
                                            <div class="background">
                                                <i class="fa fa-{{ value.icon }}"></i>
                                            </div>
                                            <div class="panel-heading widget-header">
                 <a title="{{ value.deviceName }}">{{ value.deviceName | limitTo:15}}{{value.deviceName.length > 15 ? '...' : ''}}</a>
<a class="dropdown-toggle pull-right toolTip" data-toggle="dropdown" data-placement="right" title="Details" href="javascript:;"><i class="fa fa-bars"></i></a>
                                                <ul class="dropdown-menu">
<?php if($data['canAdminRestore'] == true){?>
<?php if($data['canAdminRestoreBackupPolicy'] == 'true'){?>
<li class="fileListBtnblockeddevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
<?php } ?>
<?php } ?>
<li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID)">Restore</a></li>
<li><a href="<?=Url::basePath('user/backupHistory/'.$data['userDetails']->{'user-name'}.'/{{ value.deviceUUID }}/{{value.deviceName}}')?>"><?=Language::show('backup_activity_history', 'keywords');?></a></li>
<li ng-if="policyconfiguration != 'false'"><a href="<?=Url::basePath('user/device/policyInfo/'.$data['userDetails']->{'user-name'}.'/{{ value.deviceUUID }}/{{ value.icon }}')?>"><?=Language::show('policy_configuration', 'keywords');?></a></li>
                                                </ul>
   <a class="pull-right eye" ng-click="viewDeviceDetails($index, value.deviceUUID,'blockeddevice')" href="javascript:;"><i class="fa fa-eye"></i></a>
                                            </div>
                                            <div class="panel-body widget widget-body">
                      <i ng-click="viewDeviceDetails($index, value.deviceUUID)" class="clickAble fa fa-{{ value.icon }}"></i>
          <a style="font-size: 18px;margin-top: -10px; margin-right: 13px;" class="pull-right" ng-cloak>{{ value.storageUsedByDevice }}*</a>
              <div class="row expandDetailsblockeddevice{{$index}} col-lg-12" style="font-size: 10px; color: #FFFFFF; display: none;">
                                                    <?php if(!isMobile()){ ?>
                                                    <div class="col-lg-6" style="padding: 30px 10px 10px 35px;">
                                                        <?php }else{ ?>
                                                    <div class="col-lg-12" style="padding: 30px 10px 10px 35px;">
                                                    <?php } ?>
<p>Last Successful Backup:
<b class="pull-right" ng-if="deviceDetails.lastSuccessBackup == null" ng-cloak>Not completed yet</b>
                     <b class="pull-right" ng-if="deviceDetails.lastSuccessBackup != null" ng-cloak>{{deviceDetails.lastSuccessBackup}}</b>
                                                        </p>
                          <p>Next Scheduled Backup: <b class="pull-right" ng-cloak>{{deviceDetails.nextScheduledBackup}}</b></p>
                                 <p>Policy Refresh Frequency: <b class="pull-right" ng-cloak>{{deviceDetails.nextPolicyRefresh}} hours</b></p>
                                                       <?php if($data['showLatestBkpInfo'] == true){?>
<p>Total Size of Restorable Data(Latest Version): <b class="pull-right" ng-cloak>{{deviceDetails.totalSizeOfDataInCurrentBackupLatestVersion}}</b></p>
                                                        <?php } ?>
                                                    <?php if(!isMobile()){ ?></div>
                                                    <div class="col-lg-6" style="padding: 30px 10px 10px 35px;"><?php } ?>
                                                    <p ng-if="deviceDetails.osType != 'ONEDRIVE'">Operating System: <b class="pull-right" ng-cloak>{{deviceDetails.osType.replace("(unknown)", "");}} {{deviceDetails.version}}</b></p>
                                                    <p ng-if="deviceDetails.osType != 'ONEDRIVE'">End Point Agent Version: <b class="pull-right" ng-cloak>{{deviceDetails.productVersion}}</b></p>
                                                    <p>Storage Media: <b class="pull-right" ng-cloak>{{deviceDetails.storageMedia}}</b></p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>-->
<!--new blocked end-->
<!--new assignDevices -->
<?php //if($data['loggedInUser']['admin'] == true) { ?>
<div class="row col-lg-12 assignDevices" style="display: none;">
<div class="col-lg-12">
                                        <h4><?=Language::show('Devices assigned to me', 'user');?></h4>
                                    </div>
<div ng-if="value.storageUsedByDevice != null" ng-repeat="value in assignDevices track by $index" class="col-lg-4 userDeviceassigndevice{{$index}}" id="userDeviceassigndevice{{$index}}" block-ui="myBlockUIassigndevice{{$index}}">
                                        <div class="panel panel-default no-box-shadow widget-{{ value.background }}" <?php if($data['rwDetectionEnabled'] == 'true'){?> ng-class="{'true':'alerts-border'}[value.showBlink]" <?php } ?>>
                                            <div class="devicebackground">
                                                <i class="fa fa-{{ value.os }}"></i>
                                            </div>
                                            <div class="panel-heading widget-header">
		 				<a class="displayNameTrimmedassigndevice{{$index}}" title="{{ value.deviceDisplayName }}">{{ value.deviceDisplayName | limitTo:15}}{{value.deviceDisplayName.length > 15 ? '...' : ''}}</a>
                                                <a class="displayNameNotTrimmedassigndevice{{$index}} hide" title="{{ value.deviceDisplayName }}">{{ value.deviceDisplayName}}</a>
<a class="dropdown-toggle pull-right toolTip" data-toggle="dropdown" data-placement="right" title="Details" href="javascript:;"><i class="fa fa-bars"></i></a>
                                                <ul class="dropdown-menu">
<?php if($data['showBackupOptions'] == 'true'){?>
<!--exp new start-->
<?php if($data['loggedInUser']['admin'] == true || $data['loggedInUser']['readOnlyAdmin'] == true){ ?>
    <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){?>
	<?php if($data['userDetails']->{'is-active'} == 'true'){?>
            <li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
            <li ng-if="value.icon == 'cloud'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
            <li ng-if="value.icon == 'envelope'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
            <li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
	<?php } ?>
    <?php }else{ ?>
    	<?php if($data['readOnlyAdminUser'] == 'No'){ ?>
            <?php if($data['showButtons'] == 'true'){?>
                <?php if($data['allowEndUserTocontrolRestoreGS'] == 'true'){ ?>
			<?php if($data['userDetails']->{'is-active'} == 'true'){?>
                        <li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" ng-show="value.canAdminRestore == true" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
                        <li ng-if="value.icon == 'cloud'" ng-show="value.canAdminRestore == true" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
                        <li ng-if="value.icon == 'envelope'" ng-show="value.canAdminRestore == true" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
                        <li ng-show="value.canAdminRestore == true"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
			<?php } ?>
                <?php } else { ?>
			<?php if($data['userDetails']->{'is-active'} == 'true'){?>
                        <li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
                        <li ng-if="value.icon == 'cloud'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
                        <li ng-if="value.icon == 'envelope'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
                        <li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
			<?php } ?>
                <?php } ?>
            <?php } ?>
            <?php if($data['showBackupButtons'] == 'true'){?>
                <?php if($data['allowEndUserTocontrolRestoreBP'] == 'true'){ ?>
			<?php if($data['userDetails']->{'is-active'} == 'true'){?>
                        <li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" ng-show="value.canAdminRestore == true" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
                        <li ng-show="value.canAdminRestore == true"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
			<?php } ?>
                <?php } else { ?>
			<?php if($data['userDetails']->{'is-active'} == 'true'){?>
                        <li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
                        <li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
			<?php } ?>
                <?php } ?>
            <?php } ?>
	    <!--new logic starts-->
	    <?php if($data['showOnedriveButtons'] == 'true'){?>
                <?php if($data['allowEndUserTocontrolRestoreOP'] == 'true'){ ?>
			<?php if($data['userDetails']->{'is-active'} == 'true'){?>
                        <li ng-if="value.icon == 'cloud'" ng-show="value.canAdminRestore == true" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>                        
                        <li ng-if="value.icon == 'cloud'" ng-show="value.canAdminRestore == true"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
			<?php } ?>
                <?php } else { ?>
			<?php if($data['userDetails']->{'is-active'} == 'true'){?>
                        <li ng-if="value.icon == 'cloud'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
                        <li ng-if="value.icon == 'cloud'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
			<?php } ?>
                <?php } ?>
            <?php } ?>
	    <?php if($data['showExchangeButtons'] == 'true'){?>
                <?php if($data['allowEndUserTocontrolRestoreEX'] == 'true'){ ?>                        
			<?php if($data['userDetails']->{'is-active'} == 'true'){?>
                        <li ng-if="value.icon == 'envelope'" ng-show="value.canAdminRestore == true" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
                        <li ng-if="value.icon == 'envelope'" ng-show="value.canAdminRestore == true"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
			<?php } ?>
                <?php } else { ?>
			<?php if($data['userDetails']->{'is-active'} == 'true'){?>
                        <li ng-if="value.icon == 'envelope'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
                        <li ng-if="value.icon == 'envelope'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
			<?php } ?>
                <?php } ?>
            <?php } ?>
            <?php if($data['showSharepointButtons'] == 'true'){?>
                <?php if($data['allowEndUserTocontrolRestoreSP'] == 'true'){ ?>
			<?php if($data['userDetails']->{'is-active'} == 'true'){?>
                        <li ng-show="value.canAdminRestore == true" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
                        <li ng-show="value.canAdminRestore == true"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
			<?php } ?>
                <?php } else { ?>
			<?php if($data['userDetails']->{'is-active'} == 'true'){?>
                        <li class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
                        <li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
			<?php } ?>
                <?php } ?>
            <?php } ?>							
	    <!--new logic ends--> 							
	    <!--old logic starts-->   							
            <?php //if($data['showOnedriveButtons'] == 'true'){?>
                <?php //if($data['allowEndUserTocontrolRestoreBP'] == 'true'){ ?>
                	<!--<li ng-if="value.icon == 'cloud'" ng-show="value.canAdminRestore == true" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
                        <li ng-if="value.icon == 'envelope'" ng-show="value.canAdminRestore == true" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
                        <li ng-show="value.canAdminRestore == true"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>-->
                <?php //} else { ?>
                        <!--<li ng-if="value.icon == 'cloud'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
                        <li ng-if="value.icon == 'envelope'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
                        <li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>-->
                <?php //} ?>
            <?php //} ?>
	    <!--old logic ends-->
    <?php } ?>
	    <?php //if($data['userDetails']->{'site'} == 'true'){ ?>
		<!--<li class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
		<li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>-->
	    <?php //} ?>				
    <?php } ?>
<?php }else{ ?>
	<?php if($data['userDetails']->{'is-active'} == 'true'){?>
            <li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
            <li ng-if="value.icon == 'cloud'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
            <li ng-if="value.icon == 'envelope'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked, value.quarantineDevice)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
            <?php if($data['bkpRestore'] == 'true'){?>
	    <li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked+'/'+value.quarantineDevice)" href="javascript:;">Restore</a></li>
	    <?php } ?>
	<?php } ?>
<?php } ?>
<!--exp new end-->
<?php } ?>
<li><a href="javascript:;" ng-click="restorableSizeMethod(value.deviceUUID)"><?=Language::show('Restorable Size', 'keywords');?></a></li>
<?php
$ciphering = "AES-256-CBC";
$iv_length = openssl_cipher_iv_length($ciphering);
$options = 0;
$encryption_iv = '2007199020071990';
$encryption_key = "PORTAL";
$encryption = openssl_encrypt($data['userDetails']->{'user-name'}, $ciphering,$encryption_key, $options, $encryption_iv);
?>
<li><a href="<?=Url::basePath('user/backupHistory/'.base64_encode($encryption).'/{{ value.deviceUUID }}/{{value.deviceNameEncoded}}')?>"><?=Language::show('backup_activity_history', 'keywords');?></a></li>
<!--<li><a href="<?=Url::basePath('user/backupHistory/{{ value.userName }}/{{ value.deviceUUID }}/{{value.deviceName}}')?>"><?=Language::show('backup_activity_history', 'keywords');?></a></li>-->
<?php if($data['showBackupOptions'] == 'true'){ ?>                                                	
                                                	<?php if($data['userDetails']->{'is-active'} == 'true' && ($data['userDetails']->{'backup-enabled'} == 'true' || $data['userDetails']->{'onedriveBkpEnabled'} == 'true' || $data['userDetails']->{'exchangeBkpEnabled'} == 'true')){?>
                                                		<!--<li><a href="<?=Url::basePath('user/device/policyInfo/{{ value.userName }}/{{ value.deviceUUID }}/{{ value.icon }}')?>"><?=Language::show('policy_configuration', 'keywords');?></a></li>-->
								<?php if($data['showBackupSettingsForBackupDevice'] == 'true'){?>
									<li ng-if="value.icon != 'cloud' && value.icon != 'envelope' && value.blocked == 'active'"><a href="<?=Url::basePath('user/device/policyInfo/{{ value.userName }}/{{ value.deviceUUID }}/{{ value.icon }}')?>"><?=Language::show('policy_configuration', 'keywords');?></a></li>
								<?php } ?>
									<li ng-if="value.icon == 'cloud' && value.blocked == 'active'"><a href="<?=Url::basePath('user/device/policyInfo/{{ value.userName }}/{{ value.deviceUUID }}/{{ value.icon }}')?>"><?=Language::show('policy_configuration', 'keywords');?></a></li>
									<li ng-if="value.icon == 'envelope' && value.blocked == 'active'"><a href="<?=Url::basePath('user/device/policyInfo/{{ value.userName }}/{{ value.deviceUUID }}/{{ value.icon }}')?>"><?=Language::show('policy_configuration', 'keywords');?></a></li>								
                                                	<?php } ?>
<?php } ?>
							<?php //if($data['loggedInUser']['admin'] == true || $data['loggedInUser']['readOnlyAdmin'] == true){ ?>
							<?php if($data['loggedInUser']['admin'] == true || $data['ECD'] == 'true'){ ?>
                                                		<li ng-if="value.deviceType != 'SHAREPOINT'"><a href="" ng-bootbox-confirm="<h4><?=Language::show('blockConfirmDevice', 'keywords')?></h4>" ng-bootbox-confirm-action="blockUnBlockDevice(value.deviceUUID, true,value.userName, value.deviceName)" ng-bootbox-confirm-action-cancel="" ng-if="value.blocked == 'active'"><?=Language::show('block', 'keywords');?></a></li>
                                                		<?php if($data['userDetails']->{'is-active'} == 'true'){ ?>
									<li class="d-none"><a href="" ng-bootbox-confirm="<h4><?=Language::show('unBlockConfirmDevice', 'keywords')?></h4>" ng-bootbox-confirm-action="blockUnBlockDevice(value.deviceUUID, false,value.userName, value.deviceName)" ng-bootbox-confirm-action-cancel="" ng-if="value.blocked != 'active'"><?=Language::show('Unblock', 'keywords');?></a></li>
								<?php } ?>
                                                		<li class="d-none"><a href="" ng-bootbox-confirm="<h4><?=Language::show('deleteConfirmDevice', 'keywords')?></h4><br><span style='font-size:12px;'>Note : This action will result in <u>permanently</u> deleting all backups for this device.  Are you sure you wish to proceed?</span>" ng-bootbox-confirm-action="deleteDevice(value.deviceUUID,value.userName, value.deviceName)" ng-bootbox-confirm-action-cancel="" ng-if="value.blocked != 'active'"><?=Language::show('Delete', 'keywords');?></a></li>                                                	
								<li ng-if="value.decoupled == false && value.blocked == 'active'"><a href="" ng-click="logAction(value.deviceUUID,value.deviceType)">Actions</a></li>
							<?php } ?>
                                                </ul>
						<?php //if($data['showBackupOptions'] == 'true'){ ?>
   							<a class="pull-right eye" ng-click="viewDeviceDetails($index, value.deviceUUID,'assigndevice', value.deviceType)" href="javascript:;"><i class="fa fa-eye"></i></a>
						<?php //} ?>
                                            </div>
                                            <div class="panel-body widget widget-body">
                      				<i ng-if="value.deviceType != 'SHAREPOINT'" ng-click="viewDeviceDetails($index, value.deviceUUID,'assigndevice', value.deviceType)" class="clickAble fa fa-{{ value.os }}"></i>
						<img ng-if="value.deviceType == 'SHAREPOINT'" src="<?=Url::templatePath()?>images/SharePoint-Logo.wine.svg?>" class="clickAble" ng-click="viewDeviceDetails($index, value.deviceUUID,'mydevice',value.deviceType)" style="height:40px;width:40px;">						    
          					<?php //if($data['showBackupOptions'] == 'true'){ ?>
						    <a style="font-size: 18px;margin-top: -10px; margin-right: 13px;" class="pull-right" ng-cloak>{{ value.storageUsedByDevice }}*</a>
						<?php //} ?>
              					<div class="row expandDetailsassigndevice{{$index}} col-lg-12" style="font-size: 10px; color: #FFFFFF; display: none;">
						   <?php if(!isMobile()){ ?>
                                                    <div class="col-lg-6" style="padding: 30px 10px 10px 35px;">
                                                        <?php }else{ ?>
                                                    <div class="col-lg-12" style="padding: 30px 10px 10px 35px;">
                                                    <?php } ?>
                                                        <p>Last Successful Backup:
                               					<b class="pull-right" ng-if="deviceDetails.lastSuccessBackup == null" ng-cloak>Not completed yet</b>
                               					<b class="pull-right" ng-if="deviceDetails.lastSuccessBackup != null" ng-cloak>{{deviceDetails.lastSuccessBackup}}</b>
                                                        </p>
							<p>Next Scheduled Backup:
                                                            <b class="pull-right" ng-if="deviceDetails.nextScheduledBackup != null" ng-cloak>{{deviceDetails.nextScheduledBackup}}</b>
                                                            <b class="pull-right" ng-if="deviceDetails.nextScheduledBackup == null" ng-cloak>-</b>
                                                        </p>
							<p ng-if="value.deviceType != 'SHAREPOINT'">Policy Refresh Frequency:
                                                                <b class="pull-right" ng-if="deviceDetails.nextPolicyRefresh != null" ng-cloak>{{deviceDetails.nextPolicyRefresh}} hours</b>
                                                                <b class="pull-right" ng-if="deviceDetails.nextPolicyRefresh == null">-</b>
							</p>
                                                        <?php if($data['showLatestBkpInfo'] == true){?>
                                                        	<p>Total Size of Restorable Data(Latest Version): <b class="pull-right" ng-cloak>{{deviceDetails.totalSizeOfDataInCurrentBackupLatestVersion}}</b></p>
                                                        <?php } ?>
							<p>Device registered on: <b class="pull-right" ng-cloak>{{deviceDetails.createdTimeStamp}}</b></p>
                                                    <?php if(!isMobile()){ ?></div>
                                                    <div class="col-lg-6" style="padding: 30px 10px 10px 35px;"><?php } ?>
                                                    	<p ng-if="deviceDetails.osType != 'ONEDRIVE'">Operating System: <b class="pull-right" ng-cloak>{{deviceDetails.osTypeDisplay.replace("(unknown)", "");}} {{deviceDetails.version}}</b></p>
                                                    	<p ng-if="deviceDetails.osType != 'ONEDRIVE' && value.deviceType != 'SHAREPOINT'">End Point Agent Version: <b class="pull-right" ng-cloak>{{deviceDetails.productVersion}}</b></p>
                                                    	<p>Storage Media: <b class="pull-right" ng-cloak>{{deviceDetails.storageMedia}}</b></p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
<?php //} ?>
<!--new assign end-->
<?php if(DISABLE_BLUVAULT == false){ ?>
		<?php if($data['loggedInUser']['admin'] == true) { ?>
                        <div class="panel-footer">                            
			    <div class="row"><span class="help-block" style="color:black !important;">Note:- * size includes the sizes of earlier file versions</span></div>
			    <div class="row" style="margin-bottom:5px;"><span class="label label-danger"> </span> : Blocked Devices.</div>
			    <?php if($data['rwDetectionEnabled'] == 'true'){?>
			    	<div class="row"><div class="alerts-border" style="height: 15px;width: 15px;background-color: red;"></div>  : Unusual activity detected for the device.</div>
			    	<div class="row"><i class="fa fa-ban" style="margin-top:2px;"></i> : Device has been Quarantined.</div>
			    <?php } ?>
                        </div>
		<?php } ?>
<?php } ?>
	</div>
</div>
                    </div>
                </div>
            </div>
<!--modal confirmation starts-->
  <div class="modal fade" id="confirmUnblock" role="dialog" data-keyboard="false" data-backdrop="static">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
		<h4 class="modal-title">Confirmation</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>                
        </div>
        <div class="modal-body">
                This user's device has been assigned to someone else, by saying yes will undo that. Are you sure you want to continue?
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('No', 'keywords')?></button>
          <button type="button" ng-click="unBlockUserProfile1(operatedUser, 'true', 'user')" class="btn btn-primary">Yes</button>
        </div>
      </div>
    </div>
  </div>
<!--modal confirmation ends-->		
<!--modal for restore size starts-->
	    <div class="modal fade restorableSizeModal" id="restorableSizeModal" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Restorable Size </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
				<span id="restorableSizeLabel" style="display:none;"> Calculating....</span>
                             	<center><span id="restorableSizeSpinner" style="display:none;"><i class="fa fa-spinner fa-4x fa-pulse fa-fw"></i></span></center>
                            	<h4 id="restorableSize" class="modal-title">
                                	<p><span>Size: {{restorableSize}}</span></p>
                                	<p ng-if="totalNumberOfFiles !=''"><span>Contains: {{totalNumberOfFiles}} items</span></p>
                            	</h4>
			    <h4 id="restorableSizeError" class="modal-title">Operation to Calculate restorable size of folder failed.</h4>

                        </div>
                        <div class="modal-footer">
                                <button type="button" class="btn btn-primary" data-dismiss="modal">Close </button>
                        </div>
                    </div>
                </div>
            </div>
<!--modal for restore size ends-->			
<?php if(googleAuthenticator == true){ ?>
<!--modal qr code starts-->
  <div class="modal fade" id="myQR" role="dialog" data-keyboard="false" data-backdrop="static">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
          	<h4 class="modal-title">My QR Code</h4>
        </div>
        <div class="modal-body">
		<center>
			<div id="img">
				<img src='<?php echo $qrCodeUrl; ?>' />
                        </div>
		</center>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('Close', 'keywords')?></button>
        </div>
      </div>
    </div>
  </div>
<!--modal my qr code ends-->
<?php } ?>
<!--modal change password starts-->
<?php $showmodal = 'false';?>
<?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?>
        <?php if($data['enableChangePasswordUser'] == 'true'){ ?>
                <?php $showmodal = 'true';?>
        <?php } ?>
<?php } else { ?>

        <?php if($data['loggedInUser']['admin'] == true || $data['loggedInUser']['readOnlyAdmin'] == true){?>
                <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?>
                        <?php if($data['enableChangePasswordUser'] == 'true'){ ?>
                                <?php $showmodal = 'true';?>
                        <?php } ?>
                <?php }else {  ?>
                <?php if($data['enableChangePasswordAdmin'] == 'true'){ ?>
                        <?php $showmodal = 'true';?>
                <?php } ?>
                <?php } ?>
        <?php } ?>
<?php } ?>
<?php if($showmodal == 'true' ){?>			    
<div class="modal fade" id="changePassword" tabindex="-1">
                                <div class="modal-dialog">
                                  <!-- Modal content-->
                                  <div class="modal-content">
                                    <?php if($data['loggedInUser']['userName'] != $data['userDetails']->{'user-name'}){ ?>
                                        <?= Form::open(array(
                                                'ng-submit' => 'resetPassword()',
                                                'method' => 'post',
                                                'id' => 'changePasswordForm',
                                                'csrf' => $data['csrf_token'],
                                                'autocomplete' => 'off',
                                                'data-parsley-validate' => true
                                            )); ?>
                                    <?php } else { ?>
                                        <?= Form::open(array(
                                                'ng-submit' => 'changePassword()',
                                                'method' => 'post',
                                                'id' => 'changePasswordForm',
                                                'csrf' => $data['csrf_token'],
                                                'autocomplete' => 'off',
                                                'data-parsley-validate' => true
                                            )); ?>
                                    <?php } ?>
                                    <div class="modal-header">
					<?php if($data['loggedInUser']['userName'] != $data['userDetails']->{'user-name'}){ ?>
						<h4 class="modal-title" id="myModalLabel">Reset Password</h4>
					<?php } ?>
					<?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?>
                                        	<h4 class="modal-title" id="myModalLabel">Change Password</h4>
					<?php } ?>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                    </div>
                                    <div class="modal-body">
                                        <input type="text" class="form-control d-none" name="username1" id="username1" value="<?=$data['userDetails']->{'user-name'}?>">
                                        <input type="text" class="form-control d-none" name="recoverykey1" id="recoverykey1" value="<?=$data['userDetails']->{'recovery-key'}?>">
					<input type="text" class="form-control d-none" name="googleSecretKey1" id="googleSecretKey1" value="<?=$data['userDetails']->{'google-secret-key'}?>">
				    <div class="form-group <?php if($data['loggedInUser']['userName'] != $data['userDetails']->{'user-name'}){ echo 'd-none'; }?>">
                                                <label for="password">Enter Old Password</label>
                                                <input type="password" class="form-control" name="oldpassword" id="oldpassword" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('old', 'keywords');?> <?=Language::show('password', 'keywords');?>" autocomplete="off">
                                         </div>
                                      <div class="form-group">
                                                    <label for="password">Enter New Password</label>
                                                    <?php if(complexPassword == true) { ?>
                                                    <input type="password" name="password" class="form-control" id="password" placeholder="Enter a Password" data-parsley-minlength="6" data-parsley-required data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')" data-parsley-trigger="change">
                                                    <?php } else { ?>
                                                    <input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('new', 'keywords');?> <?=Language::show('password', 'keywords');?>" autocomplete="off" data-parsley-required data-parsley-minlength="6">
                                                    <?php } ?>

                                                </div>
                                                <div class="form-group">
                                                    <label for="rePassword">Re Type Password</label>
                                                    <input type="password" name="rePassword" class="form-control" id="rePassword" placeholder="Re-Type the New Password" data-parsley-equalto="#password" data-parsley-trigger="change" data-parsley-required>
                                                </div>
					    <div id="captchaDiv">
			    <?php
		    	    if(enableRecaptcha == true){
                            global $image;
                            $image = imagecreatetruecolor(200, 50) or die("Cannot Initialize new GD image stream");
                            $background_color = imagecolorallocate($image, 255, 255, 255);
                            $text_color = imagecolorallocate($image, 0, 255, 255);
                            $line_color = imagecolorallocate($image, 64, 64, 64);
                            $pixel_color = imagecolorallocate($image, 0, 0, 255);
                            imagefilledrectangle($image, 0, 0, 200, 50, $background_color);
                            for ($i = 0; $i < 3; $i++) {
                                imageline($image, 0, rand() % 50, 200, rand() % 50, $line_color);
                            }
                            for ($i = 0; $i < 1000; $i++) {
                                imagesetpixel($image, rand() % 200, rand() % 50, $pixel_color);
                            }
                            $letters = $data['letter'];
                            //$letters = $data['letter'];
                            $len = strlen($letters);
                            $letter = $letters[rand(0, $len - 1)];
                            $text_color = imagecolorallocate($image, 0, 0, 0);
                            $word = "";
                            $font = '/var/www/portal/app/templates/default/css/fonts/monofont.ttf';
                            for ($i = 0; $i < strlen($letters); $i++) {
                                    $letter = $letters[$i];
                                    $letter = trim($letter);
                        //          imagestring($image, 8, 70 + ($i * 15), 20, $letter, $text_color);
                                    imagettftext($image, 36, 0, 70 + ($i * 15), 35, $text_color, $font, $letter);
                                $word .= $letter;
                            }
                            $images = glob("*.png");
                            foreach ($images as $image_to_delete) {
                                @unlink($image_to_delete);
                                }
			    imagepng($image, "image" . $data['count'] . ".png");
			    }
                        ?>
			</div>
			<?php if(enableRecaptcha == true){ ?>
				<div class="from-group">
				    <label>Enter captcha shown below </label>
				    <input class="form-control" type="text" id="code" name="code" required autocomplete="off"/>
				    <!--<img id="captchaImage" src="image<?php echo $data['count'] ?>.png">-->
				    <span id="captchaSpan">
					<img id="captchaImage" src="https://<?=PARACLOUD_IP?>/portal/image<?=$data['count']?>.png">
				    </span>
				    <span id="refreshSpan"><a class="loginCaptchaRefresh" id="loginCaptchaRefresh" style="margin-left:10px;"><i class="glyphicon glyphicon-refresh" title="refresh captcha"></i></a></span>
				</div>
                        <?php }else{ ?>
                        	<input class="form-control d-none" type="text" id="code" name="code" value="<?=$data['letter']?>" autocomplete="off"/>
			<?php } ?>
                                    </div>
                                    <div class="modal-footer">
                                      <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('cancel', 'keywords');?></button>
                                      <button type="submit" id="changePasswordBtn" class="btn btn-primary"><?=Language::show('save', 'keywords');?></button>
                                    </div>
                                    <?= Form::close(); ?>
                                  </div>

                                </div>
                            </div>
<?php } ?>
<!--modal change password ends-->
<!--modal confirmation starts-->
  <div class="modal fade" id="confirmUnblockDevice" role="dialog" data-keyboard="false" data-backdrop="static">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
                <h4 class="modal-title">Confirmation</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        </div>
        <div class="modal-body">
                This device has been assigned to someone else, by saying yes will undo that. Are you sure you want to continue?
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('No', 'keywords')?></button>
          <button type="button" ng-click="blockUnBlockDevice1(operatedDeviceUUID, false,operatedUserName, operatedDeviceName, operatedIsSite)" class="btn btn-primary">Yes</button>
        </div>
      </div>
    </div>
  </div>
<!--modal confirmation ends-->		
			
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/UserController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script src="<?=Url::templatePath()?>js/angular/directives/fileUpload.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<style>
.alerts-border {
    border: 5px #ff0000 solid;

    animation: blink 1s linear infinite;
}

@keyframes blink { 50% { border-color:#fff ; }  }
</style>
<style>
.switch {
  position: relative;
  display: inline-block;
  width: 45%;
  height: 34px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #f27331;
}

input:focus + .slider {
  box-shadow: 0 0 1px #f27331;
}

input:checked + .slider:before {
  -webkit-transform: translateX(70px);
  -ms-transform: translateX(70px);
  transform: translateX(70px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
</style>
<script>
    $('#agentLogs').on('change', function(){
        $('#saveBtn').removeClass('disabled');
            if($(this).prop('checked')){
                $('#historicalLogsBlock').show();
            }else{
                $('#historicalLogsBlock').hide();
                //$('#historicalLogs').prop('checked',false);
            }
    });
    $("#stopBackupWhileRestore").click(function(){
        $('#saveBtn').removeClass('disabled');
    });
	
    $("#agentLogs").click(function(){
	$('#saveBtn').removeClass('disabled');
    });

    $("#historicalLogs").click(function(){
	$('#saveBtn').removeClass('disabled');
    });

    $("#setupLogs").click(function(){
	$('#saveBtn').removeClass('disabled');
    });

    $("#databases").click(function(){
	$('#saveBtn').removeClass('disabled');
    });

    document.getElementById('agentLogs').addEventListener('click', function(){
	$('#saveBtn').removeClass('disabled');
    });
	
    $(function () {
	$('.ios').tooltip({ trigger: 'click' });
    });
</script>
