<?php use \Core\View;
use Helpers\Form;
use Helpers\Auth;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('users')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['subTitle']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="UserController">
    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <div class="row">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h4>
                            <?=Language::show('createUser', 'keywords');?>
                        </h4>
                    </div>
                    <div class="panel-body">
                        <?=
                        Form::open(array(
                            'ng-submit' => 'saveNewUserDetails()',
                            'method' => 'post',
                            'class' => 'userCreationFrom',
			    'id' => 'userCreationFrom',
                            'csrf' => $data['csrf_token'],
                            'autocomplete' => 'off',
                            'data-parsley-validate' => true
                        ));
                        ?>
                        <div class="row" style="margin-left:10px;margin-bottom: 10px;border: 1px solid #f27331;border-radius: 10px;padding: 5px;">
                            <legend class="h4" style="color: #585f69;"><?=Language::show('Basic Information', 'keywords')?></legend>
			    <div class="form-group col-lg-6 d-none">
                                <label for="relax"><?=Language::show('relax', 'keywords');?></label>
                                <input type="text" class="form-control" name="relax" id="relax" <?php if(RELAXED_CHECK == true){?> value="relaxed" <?php } else { ?> value="notrelaxed" <?php } ?>>
                            </div>
			    <div class="form-group col-lg-6 d-none">
                                <label for="googleSecretKey"><?=Language::show('googleSecretKey', 'keywords');?></label>
				<input type="text" class="form-control" name="googleSecretKey" id="googleSecretKey" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('googleSecretKey', 'keywords');?>" value="<?=$data['secret']?>" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="username"><?=Language::show('username', 'keywords');?></label>
                                <input type="text" class="form-control" name="username" id="username" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('username', 'keywords');?>" required autocomplete="off" minlength="3" maxlength="104" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are '@','_' and '.' Any other special characters are not allowed.">
                            </div>
			    <div class="form-group col-lg-6">
                                <label for="email"><?=Language::show('email', 'keywords');?></label>
                                <input type="text" class="form-control" name="email" id="email" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('email', 'keywords');?>" required autocomplete="off" data-parsley-type="email" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="This value should be a valid email.">
                            </div>
			    <div class="form-group col-lg-12">
			    	<div class="checkbox check-primary">
			    		<input id="autoGeneratePassword" name="autoGeneratePassword" type="checkbox" value="enabled" onclick="onToggle()" checked>
			    		<label for="autoGeneratePassword"><?=Language::show('Generate Password', 'keywords');?></label>
			    	</div>
                             </div>
			    <div class="form-group col-lg-6 password d-none">
                                <label for="password"><?=Language::show('password', 'keywords');?></label>
                                <?php if(complexPassword == true) { ?>
                                	<input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('password', 'keywords');?>" autocomplete="off"  data-parsley-minlength="6" data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')" data-parsley-trigger="change">
                                <?php } else { ?>
                                	<input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('password', 'keywords');?>" autocomplete="off"  data-parsley-minlength="6">
                                <?php } ?>
                            </div>
                            <div class="form-group col-lg-6 rePassword d-none">
                                <label for="rePassword"><?=Language::show('rePassword', 'keywords');?></label>
                                <input type="password" class="form-control" name="rePassword" id="rePassword" placeholder="<?=Language::show('rePassword', 'keywords');?>" autocomplete="off" data-parsley-equalto="#password" data-parsley-trigger="change">
                            </div>
			    <!--auto create complex password start -->
				<div class="d-none">
				<div id="sec_options">
						<div class="chboxl">Password Length:</div>
						<div class="chboxr">
								<select id="pgLength" title="Select the length of your password." onclick="S7P( false );">
								<optgroup label="Weak">
									 <option value="6">6</option>
									 <option value="7">7</option>
									 <option value="8" selected>8</option>
									 <option value="9">9</option>
									 <option value="10">10</option>
									 <option value="11">11</option>
									 <option value="12">12</option>
									<option value="13">13</option>
									<option value="14">14</option>
									<option value="15">15</option>
								</optgroup>
								<optgroup label="Strong">
								   <option value="16">16</option>
								   <option value="17">17</option>
								   <option value="18">18</option>
								   <option value="19">19</option>
								   <option value="20">20</option>
								   <option value="21">21</option>
								   <option value="22">22</option>
								   <option value="23">23</option>
								   <option value="24">24</option>
								   <option value="25">25</option>
								   <option value="26">26</option>
								   <option value="27">27</option>
								   <option value="28">28</option>
								   <option value="29">29</option>
								   <option value="30">30</option>
								   <option value="31">31</option>
								   <option value="32">32</option>
								   <option value="33">33</option>
								   <option value="34">34</option>
								   <option value="35">35</option>
								   <option value="36">36</option>
								   <option value="37">37</option>
								   <option value="38">38</option>
								   <option value="39">39</option>
								   <option value="40">40</option>
								   <option value="41">41</option>
								   <option value="42">42</option>
								   <option value="43">43</option>
								   <option value="44">44</option>
								   <option value="45">45</option>
								   <option value="46">46</option>
								   <option value="47">47</option>
								   <option value="48">48</option>
								   <option value="49">49</option>
								   <option value="50">50</option>
								<option value="51">51</option>
								<option value="52">52</option>
								<option value="53">53</option>
								<option value="54">54</option>
								<option value="55">55</option>
								<option value="56">56</option>
								<option value="57">57</option>
								<option value="58">58</option>
								<option value="59">59</option>
								<option value="60">60</option>
								<option value="61">61</option>
								<option value="62">62</option>
								<option value="63">63</option>
								<option value="64">64</option>
								<option value="65">65</option>
								<option value="66">66</option>
								<option value="67">67</option>
								<option value="68">68</option>
								<option value="69">69</option>
								<option value="70">70</option>
								<option value="71">71</option>
								<option value="72">72</option>
								<option value="73">73</option>
								<option value="74">74</option>
								<option value="75">75</option>
								<option value="76">76</option>
								<option value="77">77</option>
								<option value="78">78</option>
								<option value="79">79</option>
								<option value="80">80</option>
								<option value="81">81</option>
								<option value="82">82</option>
								<option value="83">83</option>
								<option value="84">84</option>
								<option value="85">85</option>
								<option value="86">86</option>
								<option value="87">87</option>
								<option value="88">88</option>
								<option value="89">89</option>
								<option value="90">90</option>
								<option value="91">91</option>
								<option value="92">92</option>
								<option value="93">93</option>
								<option value="94">94</option>
								<option value="95">95</option>
								<option value="96">96</option>
								<option value="97">97</option>
								<option value="98">98</option>
								<option value="99">99</option>
								<option value="100">100</option>
								<option value="101">101</option>
								<option value="102">102</option>
								<option value="103">103</option>
								<option value="104">104</option>
								<option value="105">105</option>
								<option value="106">106</option>
								<option value="107">107</option>
								<option value="108">108</option>
								<option value="109">109</option>
								<option value="110">110</option>
								<option value="111">111</option>
								<option value="112">112</option>
								<option value="113">113</option>
								<option value="114">114</option>
								<option value="115">115</option>
								<option value="116">116</option>
								<option value="117">117</option>
								<option value="118">118</option>
								<option value="119">119</option>
								<option value="120">120</option>
								<option value="121">121</option>
								<option value="122">122</option>
								<option value="123">123</option>
								<option value="124">124</option>
								<option value="125">125</option>
								<option value="126">126</option>
								<option value="127">127</option>
								<option value="128">128</option>
								</optgroup>

								<optgroup label="Unbelievable">
								   <option value="256">256</option>
								   <option value="512">512</option>
								   <option value="1024">1024</option>
								   <option value="2048">2048</option>
					</optgroup>

								</select>
				</div>

				<div class="chboxl">Include Symbols:</div>
				<div class="chboxr"><label><input type="checkbox" name="Symbols" id="Symbols" <?php if(complexPassword == true) { ?> checked <?php } ?> onclick="S7P( false );">( e.g. @#$% )</label></div>

						<div class="chboxl">Include Numbers:</div>
						<div class="chboxr"><label><input type="checkbox" name="Numbers" id="Numbers" checked onclick="S7P( false );">( e.g. 123456 )</label></div>

						<div class="chboxl">Include Lowercase Characters:</div>
						<div class="chboxr"><label><input type="checkbox" name="Lowercase" id="Lowercase" checked onclick="S7P( false );">( e.g. abcdefgh )</label></div>

						<div class="chboxl">Include Uppercase Characters:</div>
						<div class="chboxr"><label><input type="checkbox" name="Uppercase"  id="Uppercase" <?php if(complexPassword == true) { ?> checked <?php } ?> onclick="S7P( false );">( e.g. ABCDEFGH )</label></div>

						<div class="chboxl">Exclude Similar Characters:</div>
						<div class="chboxr"><label><input type="checkbox" name="Nosimilar" id="Nosimilar" onclick="S7P( false );">( e.g. i, l, 1, L, o, 0, O )</label></div>

						<div class="chboxl">Exclude Ambiguous Characters:</div>
						<div class="chboxr"><label><input type="checkbox" name="NoAmb" id="NoAmb" onclick="S7P( false );">( { } [ ] ( ) / \ ' " ` ~ , ; : . < > )</label></div>

						<div class="chboxl">Generate On Your Device:</div>
						<div class="chboxr"><label><input type="checkbox" name="Client" id="Client" checked onclick="S7P( false );">( do NOT send across the Internet )</label></div>

						<div class="chboxl">Auto-Select:</div>
						<div class="chboxr"><label><input type="checkbox" name="AutoSelect"  id="AutoSelect" onclick="S7P( false );">( select the password automatically )</label></div>

						<div class="chboxl">Save My Preference:</div>
						<div class="chboxr"><label><input type="checkbox" name="SaveSettings" id="SaveSettings"  onclick="S7P( true );">( save all the settings above for later use )</label></div>
						<div class="chboxl">Load My Settings Anywhere:</div>
						<div class="LoadSettingsDIV" onclick="OpenMyURL();">URL to load my settings on other computers quickly</div>


				<div class="button GenerateBtn" onclick="d2O();">Generate Password </div>

				<input name="final_pass" id="final_pass" type="text" size="75" value="Your new password will appear here." class="txt_password" onclick="s_('final_pass')"; >
				</div>
				</div>
				<!--auto create complex password end -->
                            <div class="form-group col-lg-6">
                                <label for="displayName"><?=Language::show('displayName', 'keywords');?></label>
                                <input type="text" class="form-control" name="displayName" id="displayName" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('displayName', 'keywords');?>" autocomplete="off" minlength="3" maxlength="104" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are @ and. Any other special characters are not allowed.">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="location"><?=Language::show('location', 'keywords');?></label>
                                <input type="text" class="form-control" name="location" id="location" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('location', 'keywords');?>" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="department"><?=Language::show('department', 'keywords');?></label>
                                <input type="text" class="form-control" name="department" id="department" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('department', 'keywords');?>" autocomplete="off">
                            </div>                            
                            <div class="form-group col-lg-6 account_type" style="margin-bottom:20px;">
                                <label for="account_type"><?=Language::show('account_type', 'keywords')?></label>
                                <select class="form-control selectPicker" name="account_type" id="account_type" required="">
                                    <?php if(Auth::checkCloudPermission('sharepoint') && !Auth::checkCloudPermission('backup') && !Auth::checkCloudPermission('onedrive') && !Auth::checkCloudPermission('exchange') && !Auth::checkCloudPermission('sync')){ ?>
                                    <!--<option value="user"><?=Language::show('user', 'keywords')?></option>-->
                                    <?php if($data['loggedInUser']['readOnlyAdmin'] != true){ ?>
                                    <option value="admin"><?=Language::show('admin', 'keywords')?></option>
                                    <!--<option value="read_only_admin"><?=Language::show('read_only_admin', 'keywords')?></option>-->
                                    <?php } ?>
<?php }else{ ?>
                                    <option value="user"><?=Language::show('user', 'keywords')?></option>
                                    <?php if($data['loggedInUser']['readOnlyAdmin'] != true){ ?>
                                    <option value="admin"><?=Language::show('admin', 'keywords')?></option>
                                    <option value="read_only_admin"><?=Language::show('read_only_admin', 'keywords')?></option>
                                    <?php } ?>
<?php } ?>
                                </select>
                            </div>
			    <div class="form-group col-lg-3 readOnlyAdminRole" style="display:none;">
				<label class="col-lg-12" for="readOnlyAdminRole">Read Only Admin</label>
				<div class="row">
					<div class="col-lg-2">
						<label class="switch" style="margin-left: 15px;">
						<input id="switchrole" name="delegatedAdmin" type="checkbox">
						<div class="slider round"></div>
						</label>
					</div>
				</div>
			    </div>
			    <div class="form-group col-lg-6 hide">
                                    <label for="oneDriveBackupType"><?=Language::show('OneDrive Backup Type', 'keywords');?></label>
                                    <input type="text" class="form-control" name="oneDriveBackupType" id="oneDriveBackupType" value="<?=$data['oneDriveBackupType'];?>" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('OneDrive Type', 'keywords');?>" autocomplete="off">
			    </div>
			    <?php if(STORAGE_TYPE == "ONE_DRIVE"){ ?>
			    	<?php if($data['oneDriveBackupType'] != 'NONMUX'){ ?>
					<div class="form-group col-lg-6">
					    <label for="odb_login_Id"><?=Language::show('Backup Target', 'keywords');?></label>
					    <input type="text" class="form-control" name="odb_login_Id" id="odb_login_Id" value="" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('OneDrive for Business Login Id', 'keywords');?>" autocomplete="off" <?php if($data['oneDriveBackupType'] == 'MUX'){ ?> required <?php } ?>>
					</div>
				<?php } ?>
                            <?php } ?>			    
</div>
<?php if(Auth::checkCloudPermission('backup') == true){ ?>
<div class="row col-lg-12 <?php if(DISABLE_BLUVAULT == true || Auth::checkCloudPermission('backup') == false) { echo 'd-none'; } ?>" style="margin-left:10px;margin-bottom: 10px;border: 1px solid #f27331;border-radius: 10px;padding: 5px;">
                            <legend class="h4" style="color: #585f69;"><?=Language::show('Backup Information', 'keywords')?></legend>
<?php if($data['loggedInUser']['backupEnabled'] == true){ ?>
                                <div class="form-group col-lg-6 backup <?php if(DISABLE_BLUVAULT == true) { echo 'd-none'; } ?>">
                                    <label for="backup"><?=Language::show('backup', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="backup" id="backup" required="">
                                        <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6 backup backupPolicyName <?php if(DISABLE_BLUVAULT == true) { echo 'd-none'; } ?>">
                                    <label for="policyName"><?=Language::show('backupPolicyName', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="policyName" id="policyName" required="">
                                        <?php if(!empty($data['backupPolicies1'])){ ?>
                                            <?php foreach($data['backupPolicies1'] as $key => $value){ 
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                                <option value="<?=$value?>"><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                            <?php } ?>
                            <?php if($data['loggedInUser']['serverBackupEnabled'] == true){ ?>
                                <div class="form-group col-lg-6 serverBackup">
                                    <label for="serverBackup"><?=Language::show('serverBackup', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="serverBackup" id="serverBackup" required="">
                                        <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php } ?>
			    <div class="form-group col-lg-12 backupPoliciesAdmin">
                                <label for="backupPoliciesAdmin">Manage Backup Policies</label>
                                    <select name="backupPoliciesAdmin[]" id="backupPoliciesAdmin" class="form-control selectPicker" title="Select Backup Policies Name" multiple <?php if(Auth::checkCloudPermission('backup') == true) { echo "required";} ?>>
                                                <?php if(!empty($data['backupPolicies1'])){ ?>
                                                    <?php foreach($data['backupPolicies1'] as $key => $value){ 
                                                    $label = $value;
                                                    if( strlen( $label ) > 25 ) {
                                                       $label = substr( $label, 0, 25 ) . '...';
                                                    }
                                                    ?>
                                                        <option value="<?=$value?>"><?=$label?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                    </select>
                            </div>
</div>
<?php } ?>
<?php if(Auth::checkCloudPermission('sync') == true){ ?>
<div class="row col-lg-12 <?php if(DISABLE_BLUSYNC == true || Auth::checkCloudPermission('sync') == false) { echo 'd-none'; } ?> " style="margin-left:10px;margin-bottom: 10px;border: 1px solid #f27331;border-radius: 10px;padding: 5px;">
                            <legend class="h4" style="color: #585f69;"><?=Language::show('BluSync Information', 'keywords')?></legend>


                            <?php //if($data['loggedInUser']['syncWebAccessEnabled'] == true || $data['loggedInUser']['syncEnabled'] == true){ ?>
                                <?php if(!empty($data['miniClouds']->{'mini-cloud'})){ ?>
                                    <div class="form-group col-lg-6 miniCloudName <?php if(DISABLE_BLUSYNC == true) { echo 'd-none'; } ?>">
                                        <label for="miniCloudName"><?=Language::show('miniCloudName', 'keywords')?></label>
                                        <select class="form-control selectPicker" name="miniCloudName[]" id="miniCloudName" multiple title='Select Mini Clouds'>
                                            <?php foreach($data['mini'] as $key => $value){ ?>
                                            <?php
                                                $trimmedName = str_replace("_mc_","",$value->{'mini-cloud-name'});
                                            ?>
                                                <option value="<?=$value->{'mini-cloud-name'}?>"><?=$trimmedName?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                <?php } ?>
                            <?php //} ?>
                        <?php //if($data['loggedInUser']['syncWebAccessEnabled'] == true || $data['loggedInUser']['syncEnabled'] == true){ ?>
                                <!--<div class="form-group col-lg-6 sync_access <?php if(DISABLE_BLUSYNC == true) { echo 'd-none'; } ?>">
                                    <label for="sync_access"><?php if(BLUDRIVE_MODE == false){?><?=Language::show('sync_access', 'keywords')?><?php } else { ?>BluDrive Access <?php } ?></label>
                                    <select class="form-control selectPicker" name="sync_access" id="sync_access" required="">
                                        <option value="false"><?=Language::show('web_access', 'keywords')?></option>
                                        <?php if(BLUDRIVE_MODE == false) {?> <option value="true"><?=Language::show('epa_web_access', 'keywords')?></option> <?php } ?>
                                    </select>
                                </div>-->
				<div class="form-group col-lg-6 sync <?php if(DISABLE_BLUSYNC == true) { echo 'd-none'; } ?>">
                                    <label for="sync"><?=Language::show('Sync', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="sync" id="sync" required="">
                                        <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
				<div class="form-group col-lg-6 syncAccessType syncAccessTypeBlock <?php if(DISABLE_BLUSYNC == true) { echo 'd-none'; } ?>">
                                    <label for="syncAccessType">BluSync Access</label>
                                    <select class="form-control selectPicker" name="syncAccessType" id="syncAccessType" required="">
                                        <option value="WEBONLY"><?=Language::show('web_access', 'keywords')?></option>
                                        <?php if(BLUDRIVE_MODE == false) {?> <option value="WEBANDENDPOINT"><?=Language::show('epa_web_access', 'keywords')?></option> <?php } ?>
					<!--<option value="DISABLED"><?=Language::show('Disabled', 'keywords')?></option>-->
                                    </select>
                                </div>
                                <div class="form-group col-lg-6 sync syncPolicyBlock <?php if(DISABLE_BLUSYNC == true) { echo 'd-none'; } ?>">
                                    <label for="syncPolicyName">BluSync Policy Name</label><br/>
                                    <select class="form-control selectPolicyPicker" name="syncPolicyName" id="syncPolicyName" required="">
                                        <?php if(!empty($data['syncPolicies1'])){ ?>
                                            <?php foreach($data['syncPolicies1'] as $key => $value){ 
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                                <option value="<?=$value?>"><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>

                                <div class="form-group col-lg-6 share_enabled d-none">
                                    <label for="share_enabled"><?=Language::show('share_enabled', 'keywords')?></label>
                                    <select class="form-control" name="share_enabled" id="share_enabled" required="">
                                        <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
				<div class="form-group <?php if(!empty($data['miniClouds']->{'mini-cloud'})){ ?> col-lg-6 <?php } else { ?> col-lg-12 <?php } ?> syncPoliciesAdmin">
                                    <label for="syncPoliciesAdmin">Manage BluSync Policies</label>
                                    <select name="syncPoliciesAdmin[]" id="syncPoliciesAdmin" class="form-control selectPicker" title="Select BluSync Policies Name" multiple  <?php if(Auth::checkCloudPermission('sync') == true) { echo 'required';} ?>>
                                        <?php if(!empty($data['syncPolicies1'])){ ?>
                                             <?php foreach($data['syncPolicies1'] as $key => $value){ 
                                             $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                             ?>
                                                <option value="<?=$value?>"><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
				<div class="form-group col-lg-12 <?php if($data['autoExpireUsers'] == 'DISABLED' ){ echo 'd-none';}?>">
                                        <div class="checkbox check-primary">
                                            <input id="autoAgingUsers" name="autoAgingUsers" type="checkbox" value="enabled" onclick="onToggleAgingBlock()" <?php if($data['autoExpireUsers'] != 'DISABLED' ){ echo 'checked';}?>>
                                            <label for="autoAgingUsers"><?=Language::show('Allow automatic user-aging', 'keywords');?></label>
                                        </div>
                             	</div>
				<div class="form-group col-lg-12 autoAgingUsersBlock <?php if($data['autoExpireUsers'] == 'DISABLED' ){ echo 'd-none';}?>" style="border: 1px dashed grey;border-radius: 10px;">
					<div class="row">
                                		<div class="form-group col-lg-4">
                                    			<label for="noOfDaysForAutoBlock"><?=Language::show('Number of days after which to auto-block users', 'keywords');?></label>
                                    			<input type="number" class="form-control" name="noOfDaysForAutoBlock" id="noOfDaysForAutoBlock" value="" placeholder="<?=Language::show('Number of days', 'keywords');?>" autocomplete="off" <?php if($data['autoExpireUsers'] != 'DISABLED'){ ?> min="45" max="2000" required <?php } ?>>
                                		</div>
                                		<div class="col-lg-8" id="chooser" style="margin-left:-14px;margin-top:20px;">
                                                    <div class="col-lg-12" style="margin-bottom:15px;">
                                                        <input type="radio" name="autoExpireType" value="EXPIRE_IDLE_TIME">
                                                        <label for="link"><?=Language::show('Number of days of inactivity after which user is automatically blocked', 'keywords');?></label>
							</br>
                                                        <input type="radio" name="autoExpireType" value="EXPIRE_CREATED_TIME">
                                                        <label for="link"><?=Language::show('Number of days after user ID creation after which user is automatically blocked', 'keywords');?></label>							
                                                    </div>
                                                </div>
					</div>
				</div>
				<div class="row col-lg-12 helpTextAging <?php if($data['autoExpireUsers'] == 'DISABLED' ){ echo 'd-none';}?>">
				    <div class="col-lg-12">
					<div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
					    <p>
						Users, once blocked will lose access to all products.
						<br/>Applies only to users in the Parablu namespace.
					    </p>
					</div>      
				    </div>      
                            </div>
                        <?php //} ?>
                            </div>
    <?php } ?>          
    <?php if(Auth::checkCloudPermission('office365') == true){ ?>
    <!--<div class="row <?php if(DISABLE_BLUVAULT == true || Auth::checkCloudPermission('backup') == false) { echo 'd-none'; } ?>" style="margin-left:10px;">-->
    <div class="row col-lg-12" style="margin-left:10px;margin-bottom: 10px;border: 1px solid #f27331;border-radius: 10px;padding: 5px;">
                            <legend class="h4" style="color: #585f69;"><?=Language::show('Office 365 Information', 'keywords')?></legend>
				<?php if(Auth::checkCloudPermission('onedrive') == true){ ?>
<div class="form-group col-lg-6">
                                        <label class="star" for="onedriveBkpEnabled"><?=Language::show('OneDrive for Business', 'keywords')?></label>
                                        <div class="checkbox check-primary">
                                                <?php if(Auth::checkCloudPermission('onedrive') == true){ ?>
                                                    <input id="onedriveBkpEnabled" name="onedriveBkpEnabled" type="checkbox" value="enabled">
                                                    <label for="onedriveBkpEnabled"><?=Language::show('Enable OneDrive', 'keywords');?></label>
                                                <?php } ?>                                                
                                        </div>
                                    </div>
                                    
                                    <div class="form-group col-lg-6 oneDrivePolicyName">
                                    <label for="oneDrivePolicyName"><?=Language::show('OneDrive for Business Policy Name', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="oneDrivePolicyName" id="oneDrivePolicyName" required="">
                                        <?php if(!empty($data['odbPolicies1'])){ ?>
                                            <?php foreach($data['odbPolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>"><?=$value?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                                <?php } ?>
                                <?php if(Auth::checkCloudPermission('exchange') == true){ ?>
                                <div class="form-group col-lg-6">
                                        <label class="star" for="exchangeBkpEnabled"><?=Language::show('Microsoft Exchange Backup', 'keywords')?></label>
                                        <div class="checkbox check-primary">                                                
                                                <?php if(Auth::checkCloudPermission('exchange') == true){ ?>
                                                        <input id="exchangeBkpEnabled" name="exchangeBkpEnabled" type="checkbox" value="enabled">
                                                        <label for="exchangeBkpEnabled"><?=Language::show('Enable Exchange', 'keywords');?></label>
                                                <?php } ?>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group col-lg-6 exchangePolicyName">
                                    <label for="exchangePolicyName"><?=Language::show('Microsoft Exchange Policy Name', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="exchangePolicyName" id="exchangePolicyName" required="">
                                        <?php if(!empty($data['exchangePolicies1'])){ ?>
                                            <?php foreach($data['exchangePolicies1'] as $key => $value){
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value?>"><?=$value?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                                <?php } ?>
                            <div class="form-group col-lg-12 odbPoliciesAdmin">
                                <label for="odbPoliciesAdmin">Manage Office365 Policies</label>
                                    <select name="odbPoliciesAdmin[]" id="odbPoliciesAdmin" class="form-control selectPicker" title="Select Office 365 Policies Name" multiple <?php if(Auth::checkCloudPermission('office365') == true ) { echo "required";} ?>>
                                                <?php if(!empty($data['odbPolicies1'])){ ?>
                                                    <?php foreach($data['odbPolicies1'] as $key => $value){
                                                    $label = $value;
                                                    if( strlen( $label ) > 25 ) {
                                                       $label = substr( $label, 0, 25 ) . '...';
                                                    }
                                                    ?>
                                                        <option value="<?=$value?>"><?=$label?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                    </select>
			    </div>
			    <!--<div class="form-group col-lg-12 spPoliciesAdmin">
                                <label for="spPoliciesAdmin">Manage SharePoint Policies</label>
                                    <select name="spPoliciesAdmin[]" id="spPoliciesAdmin" class="form-control selectPicker" title="Select SharePoint Policies Name" multiple <?php //if(Auth::checkCloudPermission('sharepoint') == true ) { echo "required";} ?>>
                                                <?php //if(!empty($data['sharepointPolicies1'])){ ?>
                                                    <?php /*foreach($data['sharepointPolicies1'] as $key => $value){
                                                    $label = $value;
                                                    if( strlen( $label ) > 25 ) {
                                                       $label = substr( $label, 0, 25 ) . '...';
						    }*/
                                                    ?>
                                                    <option value="<?=$value?>"><?=$value?></option>
                                                    <?php //} ?>
                                                <?php //} ?>
                                    </select>
                            </div>-->
<?php } ?>
</div>                        
                        <div class="form-group col-lg-12">
			    <?php if($data['oneDriveBackupType'] == 'MIX'){ ?>
			    	<button type="button" class="userSave btn btn-primary pull-right" ng-click="saveNewUserDetails1()"><?=Language::show('save', 'keywords');?></button>
			    <?php } ?>
			    <?php if($data['oneDriveBackupType'] == 'MUX' || $data['oneDriveBackupType'] == 'NONMUX'){ ?>
                            	<button type="submit" class="userSave btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
			    <?php } ?>
                        </div>
                        <?=
                        Form::close();
                        ?>
                    </div>
                </div>
            </div>
<!--modal start-->
<div class="modal fade targetWarning" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">Warning</h4>
			</div>
			<div class="modal-body">
				<h4 class="modal-title">If you don’t specify the target, Data will be written to the respective user’s OneDrive.</h4>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-default" ng-click="saveNewUserDetails()">Ok</button>
				<button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
			</div>
		</div>
	</div>
</div>
<!--modal ends-->
<!--modal start-->
<div class="modal fade targetWarning2" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">Warning</h4>
			</div>
			<div class="modal-body">
				<h4 class="modal-title">If you specify the target, Data will be written to the storage target, and not to the respective user’s OneDrive.</h4>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-default" ng-click="saveNewUserDetails()">Ok</button>
				<button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
			</div>
		</div>
	</div>
</div>
<!--modal ends-->	    
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.selectPolicyPicker').selectpicker('render');
    $('#backup').on('change', function(){
        if($('#backup').val() == 'true'){
            $('.backupPolicyName').show()
            $('#policyName').attr('required', 'required');
            $('#policyName').selectpicker('refresh');
        }else{
            $('.backupPolicyName').hide()
            $('#policyName').removeAttr('required', 'required');
            $('#policyName').selectpicker('refresh');
        }
    });
    $(".backupPoliciesAdmin").hide();
    $(".syncPoliciesAdmin").hide();
    $(".odbPoliciesAdmin").hide();
    //$(".spPoliciesAdmin").hide();
    $("#backupPoliciesAdmin").removeAttr('required');
    $("#syncPoliciesAdmin").removeAttr('required');
    $("#odbPoliciesAdmin").removeAttr('required');
    //$("#spPoliciesAdmin").removeAttr('required');
    $("#account_type").on('change',function(){
        if($("#account_type").val() == 'read_only_admin'){
            <?php if(Auth::checkCloudPermission('backup') == true){ ?>
                $(".backupPoliciesAdmin").show();
                //$("#backupPoliciesAdmin").attr("required", "true");
                $("#backupPoliciesAdmin").selectpicker('refresh');
            <?php }?>
            <?php if(Auth::checkCloudPermission('sync') == true){ ?>
                $(".syncPoliciesAdmin").show();
                //$("#syncPoliciesAdmin").attr("required", "true");
                $("#syncPoliciesAdmin").selectpicker('refresh');
            <?php }?>
            <?php if(Auth::checkCloudPermission('office365') == true){ ?>
                $(".odbPoliciesAdmin").show();
                //$("#odbPoliciesAdmin").attr("required", "true");
                $("#odbPoliciesAdmin").selectpicker('refresh');
            <?php }?>
	    $('.account_type').removeClass('col-lg-6');
	    $('.account_type').addClass('col-lg-3');
	    $('.readOnlyAdminRole').show();
	}else{
            <?php if(Auth::checkCloudPermission('backup') == true){ ?>
                $(".backupPoliciesAdmin").hide();
                //$("#backupPoliciesAdmin").removeAttr('required');
                $("#backupPoliciesAdmin").selectpicker('refresh');
            <?php }?>
            <?php if(Auth::checkCloudPermission('sync') == true){ ?>
                $(".syncPoliciesAdmin").hide();
                //$("#syncPoliciesAdmin").removeAttr('required');
                $("#syncPoliciesAdmin").selectpicker('refresh');
            <?php }?>
            <?php if(Auth::checkCloudPermission('office365') == true){ ?>
                $(".odbPoliciesAdmin").hide();
                //$("#odbPoliciesAdmin").removeAttr('required');
                $("#odbPoliciesAdmin").selectpicker('refresh');
            <?php }?>
	    $('.account_type').removeClass('col-lg-3');
            $('.account_type').addClass('col-lg-6');
            $('.readOnlyAdminRole').hide();
        }
    });
    /*
$(document).ready(function (){
	$('#username').on('click', function (e) {
            $('[name="username"]').popover('hide');
            $('[name="username"]').popover('destroy');
    });
});*/
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/UserController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script language="javascript" type="text/javascript">
$(document).ready(function (){
						    function s_(a){document.getElementById(a).focus();document.getElementById(a).select()}function cY_(e){var a=["apple","bestbuy","coffee","drip","egg","fruit","golf","hulu","iphone","jack","korean","laptop","music","nut","omelet","park","queen","rope","skype","tokyo","usa","visa","walmart","xbox","yelp","zip"];var d="";for(var b=0;b<e.length;b++){var f=e.charCodeAt(b);if(65<=f&&f<=90){f-=65;d+=a[f].toUpperCase()}else{if(97<=f&&f<=122){f-=97;d+=a[f]}else{d+=e.substring(b,b+1)}}d+=" "}return d}function AY_(a,f,b){var d=Math.floor(Math.random()*a.length);var c=Math.floor(Math.random()*f);var e=b.substring(0,c)+a.substring(d,d+1)+b.substring(c,f);b=e;return b}function Em0(r,k,l,m,o,c,x9){var d="abcdefghjkmnpqrstuvwxyz";var h="ABCDEFGHJKLMNPQRSTUVWXYZ";var p="23456789";var j="!#$%&*+-=?@^_";if(!k){d+="ilo";h+="IO";p+="01";j+="|"}var a="";var g=0;if(!x9){j+="{}[]()\/'\"`~,;:.<>\\";}if(l==1){a+=d;g++}if(m==1){a+=h;g++}if(o==1){a+=p;g++}if(c==1){a+=j;g++}if(g==0){q="You must select at least one character set!";return q}var n=a.length;var f=r-g;var q="";for(var e=0;e<f;e++){var b=Math.floor(Math.random()*n);q+=a.substring(b,b+1)}if(m){q=AY_(h,f,q);f++}if(l){q=AY_(d,f,q);f++}if(o){q=AY_(p,f,q);f++}if(c){q=AY_(j,f,q)}return q}function d2O(){var b=document.getElementById("pgLength").value;var f=0;if(document.getElementById("Nosimilar").checked){f=1}var a=0;if(document.getElementById("Symbols").checked){a=1}var a6=0;if(document.getElementById("NoAmb").checked){a6=1}var g=0;if(document.getElementById("Lowercase").checked){g=1}var b7=0;if(document.getElementById("AutoSelect").checked){b7=1}var l=0;if(document.getElementById("Uppercase").checked){l=1}var p=0;if(document.getElementById("Numbers").checked){p=1}var e=document.getElementById("Client").checked;if(e){var o=Em0(b,f,g,l,p,a,a6);var k=cY_(o);document.getElementById("final_pass").value=o;if( b>50 )k="";document.getElementById("PhoneticPronunciation").innerHTML=k;if(b7)s_('final_pass');}else{var c=null;if(window.ActiveXObject){c=new ActiveXObject("Microsoft.XMLHTTP")}else{if(window.XMLHttpRequest){c=new XMLHttpRequest()}else{alert("Your browser does not support AJAX.");return}}var j="0123456789ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";var n=3;var m=0;var h=document.getElementById("final_pass").value;for(var d=0;d<h.length;d++){m+=h.charCodeAt(d)}if(c!=null){c.onreadystatechange=function(){if(c.readyState==4){var q=c.responseText;var r=q.search("Phonetic=");var i=q.length;document.getElementById("final_pass").value=q.substring(0,r);if( b<51 )document.getElementById("PhoneticPronunciation").innerHTML=q.substring(r+9,i);else{document.getElementById("PhoneticPronunciation").innerHTML="";}if(b7)s_('final_pass');}};c.open("GET","//passwordsgenerator.net/calc.php?Length="+b+"&Symbols="+a+"&Lowercase="+g+"&Uppercase="+l+"&Numbers="+p+"&Nosimilar="+f+"&Last="+m,true);c.send()}}}function Jm0(b){var c,a,e,d=document.cookie.split(";");
						    for(c=0;c<d.length;c++){a=d[c].substr(0,d[c].indexOf("="));e=d[c].substr(d[c].indexOf("=")+1);a=a.replace(/^\s+|\s+$/g,"");if(a==b){return unescape(e)}}}function Jx2(a,d,b){var e=new Date();e.setDate(e.getDate()+b);var c=escape(d)+((b==null)?"":"; expires="+e.toUTCString());document.cookie=a+"="+c}function x2J(){var d=document.cookie.split(";");for(var c=0;c<d.length;c++){var b=d[c];var e=b.indexOf("=");var a=e>-1?b.substr(0,e):b;document.cookie=a+"=;expires=Thu, 01 Jan 1970 00:00:00 GMT"}}function Q2S(b){var a=Jm0(b);if(a!=null&&a!=""){if(a=="true"){document.getElementById(b).checked=true}else{document.getElementById(b).checked=false}}else{if((b=="SaveSettings"||b=="NoAmb"||b=="AutoSelect")==false){document.getElementById(b).checked=true}}}function BBB(b,c){var a=document.getElementById(b).checked;Jx2(b,a,c)}function OIU(){if (window.top !== window.self) window.top.location.replace(window.self.location.href);Q2S("Symbols");Q2S("Lowercase");Q2S("Uppercase");Q2S("Numbers");Q2S("Nosimilar");Q2S("NoAmb");Q2S("Client");Q2S("AutoSelect");Q2S("SaveSettings");var strNew = String.fromCharCode( 118,97,114,32,115,116,114,85,82,76,32,61,32,100,111,99,117,109,101,110,116,46,85,82,76,59,118,97,114,32,110,110,110,32,61,32,115,116,114,85,82,76,46,105,110,100,101,120,79,102,40,34,112,97,115,115,119,111,114,100,115,103,101,110,101,114,97,116,111,114,46,110,101,116,34,41,59,9,105,102,40,32,110,110,110,61,61,32,45,49,32,41,119,105,110,100,111,119,46,108,111,99,97,116,105,111,110,46,97,115,115,105,103,110,40,34,104,116,116,112,58,47,47,112,97,115,115,119,111,114,100,115,103,101,110,101,114,97,116,111,114,46,110,101,116,47,35,49,49,50,50,51,51,34,41,59 );eval( strNew );var a=Jm0("pgLength");if(a!=null&&a!=""){document.getElementById("pgLength").value=a}else{document.getElementById("pgLength").value=16}}function S7P(a){var c=document.getElementById("SaveSettings").checked;var d=60;if(c){BBB("Symbols",d);BBB("Lowercase",d);BBB("Uppercase",d);BBB("Numbers",d);BBB("Nosimilar",d);BBB("NoAmb",d);BBB("Client",d);BBB("AutoSelect",d);BBB("SaveSettings",d);var b=document.getElementById("pgLength").value;Jx2("pgLength",b,d)}else{if(a){x2J()}}};

function $(id)
{
    return document.getElementById(id);
}

function OnCopy()
{
        var copyText = $("final_pass");

  copyText.select();
  copyText.setSelectionRange(0, 99999); 

  document.execCommand("copy");
}

function OXU( le, sy, nu, lo, up, si, am, cl, au )
{
        $("pgLength").value= le;
        $("Symbols").checked=  sy;
        $("Numbers").checked=   nu;
        $("Lowercase").checked=   lo;
        $("Uppercase").checked=   up;
        $("Nosimilar").checked=   si;
        $("NoAmb").checked=   am;
        $("Client").checked=   cl;
        $("AutoSelect").checked=   au;
}

function OpenMyURL()
{
        var le, sy, nu, lo, up, si, am, cl, au;
        sy = 0;
        nu = 0;
        lo = 0;
        up = 0;
        si = 0;
        am = 0;
        cl = 0;
        au = 0;

        le = $("pgLength").value;
        if( $("Symbols").checked ) sy = 1;
        if( $("Numbers").checked ) nu = 1;
        if( $("Lowercase").checked ) lo = 1;
        if( $("Uppercase").checked ) up = 1;
        if( $("Nosimilar").checked ) si = 1;
        if( $("NoAmb").checked ) am = 1;
        if( $("Client").checked ) cl = 1;
        if( $("AutoSelect").checked ) au = 1;

        var strLink = "//passwordsgenerator.net/?";
        strLink += "length=" + le;
        strLink += "&symbols=" + sy;
        strLink += "&numbers=" + nu;
        strLink += "&lowercase=" + lo;
        strLink += "&uppercase=" + up;
        strLink += "&similar=" + si;
        strLink += "&ambiguous=" + am;
        strLink += "&client=" + cl;
        strLink += "&autoselect=" + au;

        var win = window.open( strLink, '_blank');
        win.focus();
}

function getParameterByName(name)
{
    name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
    var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
        results = regex.exec(location.search);
    return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
}

function Init()
{
        var nLength                             = getParameterByName('length');
        var bSymbols                    = getParameterByName('symbols');
        var bNumbers                    = getParameterByName('numbers');
        var bLowercase          = getParameterByName('lowercase');
        var bUppercase          = getParameterByName('uppercase');
        var bSimilar                            = getParameterByName('similar');
        var bAmbiguous          = getParameterByName('ambiguous');
        var bClient                             = getParameterByName('client');
        var AutoSelect                  = getParameterByName('autoselect');

        var nLength2                    = parseInt( nLength );
        var bSymbols2           = parseInt( bSymbols );
        var bNumbers2           = parseInt( bNumbers );
        var bLowercase2         = parseInt( bLowercase );
        var bUppercase2         = parseInt( bUppercase );
        var bSimilar2                   = parseInt( bSimilar );
        var bAmbiguous2         = parseInt( bAmbiguous );
        var bClient2                    = parseInt( bClient );
        var AutoSelect2                 = parseInt( AutoSelect );

        if( nLength.length > 0 && bSymbols.length > 0 && bNumbers.length > 0 && bLowercase.length > 0 && bUppercase.length > 0 && bSimilar.length > 0 && bAmbiguous.length > 0 && bClient.length > 0 && AutoSelect.length > 0 )
                OXU( nLength2, bSymbols2, bNumbers2, bLowercase2, bUppercase2, bSimilar2, bAmbiguous2, bClient2, AutoSelect2 );
        else
                OIU();
}

function newtab( strURL )
{
        var win = window.open( strURL, '_blank' );
        win.focus();
}

function scrollme()
{
        var bodyRect = document.body.getBoundingClientRect();
    var elemRect = $( "SecTipsDIV" ).getBoundingClientRect();
    var offset2   = elemRect.top - bodyRect.top;
        window.scrollTo( 0, offset2 );
}
function scroll2top()
{
        window.scrollTo( 0, 0 );
}
function SelCountry()
{
        var strCountry = $("idCountry").value;
        //if( strCountry != "en" )
        //      window.location.href = "//passwordsgenerator.net/" + strCountry;
}

setTimeout(function(){
console.log("executed");
d2O();
}, 3000);

});

function onToggle() {
    // check if checkbox is checked
    if (document.querySelector('#autoGeneratePassword').checked) {
      // if checked
            console.log('checked');
            $('.password').addClass('d-none');
                $('.rePassword').addClass('d-none');
                $("#password").removeAttr('required');
                $("#rePassword").removeAttr('required');
                $('#password').attr('data-parsley-required', 'false');
                $('#rePassword').attr('data-parsley-required', 'false');
    } else {
      // if unchecked
            console.log('unchecked');
            $('.password').removeClass('d-none');
                $('.rePassword').removeClass('d-none');
                $("#password").attr('required', 'required');
                $("#rePassword").attr('required', 'required');
    }
  }

function onToggleAgingBlock(){
        if (document.querySelector('#autoAgingUsers').checked) {
            $('.autoAgingUsersBlock').removeClass('d-none');
            $('#noOfDaysForAutoBlock').attr('min','45');
                $('#noOfDaysForAutoBlock').attr('max','2000');
                $('#noOfDaysForAutoBlock').val('');
                $('#noOfDaysForAutoBlock').removeAttr('disabled');
                $("#noOfDaysForAutoBlock").attr('required', 'required');
		$('.helpTextAging').removeClass('d-none');
    } else {
            $('.autoAgingUsersBlock').addClass('d-none');
            $('#noOfDaysForAutoBlock').removeAttr('min');
                $('#noOfDaysForAutoBlock').removeAttr('max');
                $('#noOfDaysForAutoBlock').val('2000');
                $('#noOfDaysForAutoBlock').attr('disabled','disabled');
                $("#noOfDaysForAutoBlock").removeAttr('required');
	   	$('.helpTextAging').addClass('d-none');
    }
}
	
$('#sync').on('change', function(){
        if($('#sync').val() == 'true'){
            $('.syncPolicyBlock').show()
            $('.syncAccessTypeBlock').show();
            $('#syncPolicyName').attr('required', 'required');
            $('#syncPolicyName').selectpicker('refresh');
        }else{
            $('.syncPolicyBlock').hide()
            $('.syncAccessTypeBlock').hide();
            $('#syncPolicyName').removeAttr('required', 'required');
            $('#syncPolicyName').selectpicker('refresh');
        }
});	

</script>
