<?php
use \Core\View;
use \Helpers\Url;
use Core\Language;
use Helpers\Form;
 /*
 *
 * Copyright 2019
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Naveen Verma - naveenverma@parablu.com
 * @version 2.4.1.1
 * @date 06/08/2019
 * @time 05:32 PM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
            <span class="currentPage d-none"><?='dashboard'?></span>
            <div class="row">
                <div class="panel col-lg-12">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;"><?=$data['crumb1']?></h4>
                    </div>

                    <div class="panel-body">
                        <form class="cloudConfiguration" id="cloudConfiguration" ng-submit="saveCloudConfiguration()" data-parsley-validate>
				<input type="text" class="hide" value="<?=$data["csrf_token"]?>" name="csrf_token" />
                            <?php if(isMobile()){ ?>
				    <ul class="nav nav-pills nav-stacked" style="border: 1px solid #EC6621;border-radius: 10px;">
				      <li class="nav-item" style="display:unset !important;"><a class="nav-link active" data-toggle="tab" data-target="#general" aria-expanded="true" aria-controls="general">General</a></li>
				      <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#advanced" aria-expanded="false" aria-controls="advanced">Advanced</a></li>
				    </ul>
				    <?php } ?>
				    <!-- for mobile end -->
			    <?php if(!isMobile()){ ?>
				    <ul class="nav nav-tabs" role="tablist" style="font-size: medium;font-weight: 600;">
					<li role="presentation" class="nav-item"><a href="" class="nav-link active" data-target="#general" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
					<li role="presentation" class="nav-item"><a href="" class="nav-link" data-target="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
				    </ul>
			    <?php } ?>

                            <!-- Tab panes -->
                            <div class="tab-content">
                                <div role="tabpanel" class="tab-pane active" id="general">
                                    </br>
                                    <div class="row" style="margin-left:10px;">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Default Policy', 'keywords')?></legend>
                                        <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="defaultBkpPolicyName">Default Policy name for BluVault users</label>
                                                    <select class="form-control selectPolicyPicker" name="defaultBkpPolicyName" id="defaultBkpPolicyName" placeholder="" required >
                                                         <?php if(!empty($data['backupPolicies1'])){ ?>
                                                            <?php foreach($data['backupPolicies1'] as $key => $value){ 
                                                            $label = $value;
                                                            if( strlen( $label ) > 25 ) {
                                                               $label = substr( $label, 0, 25 ) . '...';
                                                            }?>
                                                                 <option value="<?=$value?>" <?php if($data['defaultBkpPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                                                 </option>
                                                             <?php } ?>
                                                         <?php } ?>
                                                     </select>
                                                </div>
                                                <div class="form-group col-lg-6 d-none">
                                                        <label for="defaultGuestBkpPolicyName">Default Policy name for BluVault guest users</label>
                                                        <select class="form-control selectPolicyPicker" name="defaultGuestBkpPolicyName" id="defaultGuestBkpPolicyName" placeholder="" required >
                                                             <?php if(!empty($data['backupPolicies'])){ ?>
                                                                 <?php foreach($data['backupPolicies'] as $key => $value){ 
                                                                    $label = $value['name'];
                                                                    if( strlen( $label ) > 25 ) {
                                                                       $label = substr( $label, 0, 25 ) . '...';
                                                                    }?>
                                                                     <option value="<?=$value['name']?>" <?php if($data['defaultGuestBkpPolicyName'] == $value['name']){echo 'selected';}?>><?=$label?></option>
                                                                     </option>
                                                                 <?php } ?>
                                                             <?php } ?>
                                                         </select>
                                                </div>
                                            <?php } ?>
                                            <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="defaultSyncPolicyName">Default BluSync policy name</label>
                                                    <select class="form-control selectPolicyPicker" name="defaultSyncPolicyName" id="defaultSyncPolicyName" placeholder="" required >
                                                         <?php if(!empty($data['syncPolicies1'])){ ?>
                                                            <?php foreach($data['syncPolicies1'] as $key => $value){
                                                                $label = $value;
                                                                if( strlen( $label ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                                 <option value="<?=$value?>" <?php if($data['defaultSyncPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                                                 </option>
                                                             <?php } ?>
                                                         <?php } ?>
                                                     </select>
                                                </div>
                                                <div class="form-group col-lg-6">
                                                        <label for="defaultGuestSyncPolicyName">Default BluSync guest policy name</label>
                                                        <select class="form-control selectPolicyPicker" name="defaultGuestSyncPolicyName" id="defaultGuestSyncPolicyName" placeholder="" required >
                                                             <?php if(!empty($data['syncPolicies1'])){ ?>
                                                                 <?php foreach($data['syncPolicies1'] as $key => $value){ 
                                                                    $label = $value;
                                                                    if( strlen( $label ) > 25 ) {
                                                                       $label = substr( $label, 0, 25 ) . '...';
                                                                    }?>
                                                                     <option value="<?=$value?>" <?php if($data['defaultGuestSyncPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                                                     </option>
                                                                 <?php } ?>
                                                             <?php } ?>
                                                         </select>
                                                </div>
                                            <?php } ?>
					    <?php if(\Helpers\Auth::checkCloudPermission('exchange')){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="exchangePolicyName"><?=Language::show('Default Policy name for Microsoft Exchange users', 'keywords');?></label><br/>
                                                    <select class="form-control selectPolicyPicker" name="defaultExchangePolicyName" id="defaultExchangePolicyName" required="">
                                                        <?php if(!empty($data['exchangePolicies1'])){ ?>
                                                            <?php foreach($data['exchangePolicies1'] as $key => $value){
                                                                $label = $value;
                                                                if( strlen( $label ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }
                                                            ?>
                                                            <option value="<?=$value?>" <?php if($data['defaultExchangePolicyName'] == $value){echo 'selected';}?>><?=$value?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            <?php } ?>
					    <?php if(\Helpers\Auth::checkCloudPermission('onedrive')){ ?>
                                                <div class="form-group col-lg-6">
                                                    <label for="odbPolicyName"><?=Language::show('Default Policy name for OneDrive for Business users', 'keywords');?></label><br/>
                                                    <select class="form-control selectPolicyPicker" name="defaultOdbPolicyName" id="defaultOdbPolicyName" required="">
                                                        <?php if(!empty($data['odbPolicies1'])){ ?>
                                                            <?php foreach($data['odbPolicies1'] as $key => $value){
                                                                $label = $value;
                                                                if( strlen( $label ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }
                                                            ?>
                                                            <option value="<?=$value?>" <?php if($data['defaultOdbPolicyName'] == $value){echo 'selected';}?>><?=$value?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            <?php } ?>                                        
                                    </div>
                                    <div class="row" style="margin-left:10px;">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Password Enforcement', 'keywords')?></legend>
                                    <!-- Default checked -->
                                    <div class="form-group col-lg-12">
                                        <input type="checkbox" class="custom-control-input d-none" id="controller">
                                        <label class="d-none" for="controller">Enforce Rules</label>
                                        <span><p>Enforce Rules</p></span>
                                        <div class="col-lg-4" style="padding-left:0%;">
                                            <label class="switch">
                                            <input id="controller1" type="checkbox" name="passwordChangeEnforce" value="true" <?php if($data["passwordChangeEnforce"] == true){echo "checked";}?>>
                                            <div class="slider round"></div>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-6" id="canUserChangePasswordBlock" <?php if($data['passwordChangeEnforce'] == false){?> style="opacity:0.5;pointer-events:none;" <?php } ?>>
                                        <label for="canUserChangePassword1">Can users change their own password</label>
                                        <select class="form-control canUserChangePassword1 <?php if($data["passwordChangeEnforce"] == false){echo 'hide';}?>" name="canUserChangePassword1" required="" title='Select <?=Language::show('canUserChangePassword1', 'keywords')?>' <?php if($data["passwordChangeEnforce"] == false){echo "disabled";}?>>
                                            <option value="true" <?php if($data["canUserChangePassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["canUserChangePassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                    </div>
                                    <div class="form-group col-lg-6" id="canAdminChangeUserPasswordBlock" <?php if($data['passwordChangeEnforce'] == false){?> style="opacity:0.5;pointer-events:none;" <?php } ?>>
                                        <label for="canAdminChangeUserPassword1">Can an Administrator change a user password</label>
                                         <select class="form-control canAdminChangeUserPassword1 <?php if($data["passwordChangeEnforce"] == false){echo 'hide';}?>" name="canAdminChangeUserPassword1" <?php if($data["passwordChangeEnforce"] == false){echo "disabled";}?>>
                                            <option value="true" <?php if($data["canAdminChangeUserPassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["canAdminChangeUserPassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="d-none">
                                      <input type="checkbox" class="custom-control-input canUserChangePassword">
                                      <label class="custom-control-label" for="canUserChangePassword">Can users change their own password</label>
                                    </div>
                                    <div class="d-none">
                                      <input type="checkbox" class="custom-control-input canAdminChangeUserPassword">
                                      <label class="custom-control-label" for="canAdminChangeUserPassword">Can an Administrator change a user password</label>
                                    </div>
                                </div>
                                    <div class="row" style="margin-left:10px;">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Data Management', 'keywords')?></legend>
					<div class="form-group col-lg-12">
						<span><p>Global settings override policy settings</p></span>
						<div class="col-lg-4" style="padding-left:0%;">
							<label class="switch">
								<input id="controllerGS" type="checkbox" name="overridePolicySettings" value="true" <?php if($data["overridePolicySettings"] == true){echo "checked";}?>>
								<div class="slider round"></div>
							</label>
						</div>
					</div>
                                        <div class="form-group col-lg-6" id="canAdminRestoreAllBlock" <?php if($data['overridePolicySettings'] == false){?> style="opacity:0.5;pointer-events:none;" <?php } ?>>
                                        	<label for="canAdminRestoreAll">Can Administrator restore other users’ data</label>
                                        	<select class="form-control canAdminRestoreAll <?php if($data['overridePolicySettings'] == false){?> hide <?php } ?>" name="canAdminRestoreAll" id="canAdminRestoreAll"  onclick="flipDelete()">
                                        		<option value="true" <?php if($data["canAdminRestoreAll"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        		<option value="false" <?php if($data["canAdminRestoreAll"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        	</select>
					<div class="form-group <?php if($data['overridePolicySettings'] == false){?> hide <?php } ?>" id="allowEndUserTocontrolRestoreBlock" style="margin-left:30px;">
                                        	<label for="allowEndUserTocontrolRestore"><?=Language::show('Allow end-user over-ride', 'keywords');?></label>
                                        	<select class="form-control allowEndUserTocontrolRestore" name="allowEndUserTocontrolRestore" id="allowEndUserTocontrolRestore" required="" title='Select option'>
                                        		<option value="true" <?php if($data["allowEndUserTocontrolRestore"] == true){echo "selected";}?>><?=Language::show('Yes', 'keywords')?></option>
                                        		<option value="false" <?php if($data["allowEndUserTocontrolRestore"] == false){echo "selected";}?>> <?=Language::show('No', 'keywords')?></option>
                                        	</select>
                                    	</div>
					</div>
                                        <div class="form-group col-lg-6" id="isAdminDeleteBackupFileBlock" <?php if($data['overridePolicySettings'] == false){?> style="opacity:0.5;pointer-events:none;" <?php } ?>>
                                        	<label for="isAdminDeleteBackupFile">Can Administrator delete other users’ data</label>
                                        	<select class="form-control isAdminDeleteBackupFile <?php if($data['overridePolicySettings'] == false){?> hide <?php } ?>" name="isAdminDeleteBackupFile" id="isAdminDeleteBackupFile" <?php if($data['canAdminRestoreAll'] == false){?> style="pointer-events:none;opacity: 0.4;"<?php } ?>>
                                        		<option value="true" <?php if($data["isAdminDeleteBackupFile"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        		<option value="false" <?php if($data["isAdminDeleteBackupFile"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        	</select>
					</div>
					<div class="form-group col-lg-6">
	                                        <label for="canUserRestoreDeletedFiles">Can User Restore Deleted Files</label>
	                                        <select class="form-control canUserRestoreDeletedFiles selectpicker" name="canUserRestoreDeletedFiles" id="canUserRestoreDeletedFiles" >
	                                        	<option value="true" <?php if($data["canUserRestoreDeletedFiles"] == true){echo "selected";}?>>Enabled</option>
	                                        	<option value="false" <?php if($data["canUserRestoreDeletedFiles"] == false){echo "selected";}?>>Disabled</option>
                                        	</select>
					</div>
                                    </div>
		    		    <div class="row" style="margin-left:10px;">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Soft Block Management', 'keywords')?></legend>
                                        <div class="form-group col-lg-12 row">
					    <div class="col-lg-12">
                                                <span style="margin-top:5px;">Auto Block Soft Blocked Users</span>
                                                <div class="col-lg-2">
                                                    <label class="switch">
                                                        <input id="autoBlockSoftBlockedUsers" type="checkbox" name="autoBlockSoftBlockedUsers" <?php if($data["autoBlockSoftBlockedUsers"] == true){echo "checked";}?>>
                                                        <div class="slider round"></div>
                                                    </label>
                                                </div>
					    </div>
                                            <div class="col-lg-6 form-group" id="daysToBlockSoftBlockedUsersBlock" <?php if($data["autoBlockSoftBlockedUsers"] == 'true'){ ?> style="margin-top:8px;" <?php } else { ?> style="margin-top:8px;opacity:0.4;pointer-events:none;display:none" <?php } ?>>
                                            	<div class="row">
                                            	    <div class="col-lg-12">
                                            	        <label for="disallowAging" style="margin-top:5px;"><?=Language::show('Auto-block users in a soft-blocked state after days', 'keywords');?></label>
                                                        <input class="form-control col-lg-2" id="daysToBlockSoftBlockedUsers" name="daysToBlockSoftBlockedUsers" type="number" value="<?=$data['daysToBlockSoftBlockedUsers']?>" min="30" style="display:inline;margin-left:10px;margin-right:10px;">
                                                        <span>days</span>
                                            	    </div>
                                            	</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row" style="margin-left:10px;">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Email Alerts', 'keywords')?></legend>
                                        <div class="form-group col-lg-6">
                                            <label for="supportMail"> Server alert email ID</label>
                                            <a href="#" data-toggle="tooltip" data-placement="top" title="This will be included as a contact email ID that will be advertised to users as part of all automated emails that get sent out from the system"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                            <input type="text" class="form-control" name="supportMail" id="supportMail" value="<?=$data['supportMail']?>" placeholder="Enter Email ID" required autocomplete="off">
                                        </div>
                                        <div class="form-group col-lg-6">
                                            <label for="clientMailName">Signature string for end-user automated emails</label>
                                            <a href="#" data-toggle="tooltip" data-placement="top" title="The string you enter here will be part of the signature.  For instance if you enter Parablu, the signature for all end-user automated emails will be Team Parablu"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                            <input type="text" class="form-control" name="clientMailName" id="clientMailName" value="<?=$data['clientMailName']?>" placeholder="Enter client Mail Name" required autocomplete="off">
                                        </div>
                                        <div class="form-group col-lg-6">
                                            <label for="clientSupportMailName">Administrator contact email ID</label>
                                            <input type="email" class="form-control" name="clientSupportMailName" id="clientSupportMailName" value="<?=$data['clientSupportMailName']?>" placeholder="Enter client Support Mail Name" required autocomplete="off">
                                        </div>
                                        <div class="form-group col-lg-6">
                                            <label for="bulkEmailDelay">Bulk email delay (in seconds)</label>
                                            <input type="text" class="form-control" name="bulkEmailDelay" id="bulkEmailDelay" value="<?=$data['bulkEmailDelay']?>" onfocusout="myFunctionEmailDelay();" placeholder="Enter Bulk Email Delay" required autocomplete="off">
                                        <span id="delayerror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>
                                    <div class="row" style="margin-left:10px;">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Search', 'keywords')?></legend>
                                        <div class="form-group col-lg-6">
                                            <label for="solrUrl">Full text search URL</label>
                                            <input type="text" class="form-control" name="solrUrl" id="solrUrl" value="<?=$data['solrUrl']?>" placeholder="Enter Solr URL" required autocomplete="off">
                                        </div>
                                        <div class="form-group col-lg-6 <?php if($data['searchEnabled'] == false){ ?>d-none <?php } ?>">
                                            <label for="solrServerUrl">Solr Server Url</label>
                                            <input type="text" class="form-control" name="solrServerUrl" id="solrServerUrl" value="<?=$data['solrServerUrl']?>" placeholder="Enter Solr Server Url" <?php if($data['searchEnabled'] == true){ ?>required <?php } ?>autocomplete="off">
                                        </div>
                                    </div>
		    		    <div class="row <?php if(\Helpers\Auth::checkCloudPermission('sync') == false) { echo 'd-none'; } ?>" style="margin-left:10px;">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('BluSync Options', 'keywords')?></legend>
                                        <div class="form-group col-lg-12 row">
                                                <input type="checkbox" class="custom-control-input d-none">                                                                        
						<span style="margin-top:5px;">Allow automatic user-aging</span>
                                                <div class="col-lg-2">
                                                        <label class="switch">
                                                        <input id="autoExpireUsers" type="checkbox" name="autoExpireUsers" value="true" <?php if($data["autoExpireUsers"] == 'LOCAL USERS' || $data["autoExpireUsers"] == 'ALL USERS'){echo "checked";}?>>
                                                        <div class="slider round"></div>
                                                        </label>
                                                </div>
                                                <div class="checkbox check-primary col-lg-6 d-none" id="disallowAgingBlock" <?php if($data["autoExpireUsers"] == 'LOCAL USERS' || $data["autoExpireUsers"] == 'ALL USERS'){ ?> style="margin-top:8px;" <?php } else { ?> style="margin-top:8px;display:none;" <?php } ?>>
                                                        <input id="disallowAging" name="disallowAging" type="checkbox" value="enabled" <?php if($data["autoExpireUsers"] == 'LOCAL USERS'){echo "checked";}?>>
                                                        <label for="disallowAging"><?=Language::show('Disallow aging for domain joined users', 'keywords');?></label>
                                                </div>
                                        </div>
				    </div>
                                    <div class="row" style="margin-left:10px;">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Miscellaneous', 'keywords')?></legend>
                                        <div class="form-group col-lg-6">
                                            <label for="reportRows">Number of rows to show per page in the administrative screens and reports</label>
                                            <input type="number" class="form-control" name="reportRows" id="reportRows" value="<?=$data['reportRows']?>" placeholder="" required autocomplete="off">
                                        </div>
                                        <div class="form-group col-lg-6">
                                            <label for="dbBackupPassword">Passphrase to encrypt meta-data during automatic backups</label>
                                            <input type="password" class="form-control" name="dbBackupPassword" id="dbBackupPassword" value="<?=$data['dbBackupPassword']?>" placeholder="Enter DB Backup Password" autocomplete="off">
                                            <span toggle="#passwordphrase" title="show password" class="fa fa-fw fa-eye-slash field-icon toggle-passwordphrase"></span>
                                        </div>					                                           
                                    </div>
                                </div>
                                <div role="tabpanel" class="tab-pane" id="advanced">
                                    </br>
	    			   <div class="row" style="margin-left:10px;">
	    				<legend class="h4" style="color: #585f69;"><?=Language::show('Authentication Settings', 'keywords')?></legend>
					    <div class="row col-lg-12">
						<div class="form-group col-lg-6 complexPassword">
						<label for="complexPassword">Complex password</label>
						<select class="form-control complexPassword" name="complexPassword" required="" title='Select complex Password option'>
						    <option value="true" <?php if($data["complexPassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
						    <option value="false" <?php if($data["complexPassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
						</select>
					    </div>
					    <div class="form-group col-lg-6 eyeOption">
						<label for="eyeOption">Password Visibility</label>
						<select class="form-control eyeOption" name="eyeOption">
						    <option value="true" <?php if($data["eyeOption"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
						    <option value="false" <?php if($data["eyeOption"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
						</select>
					    </div>
					    <div class="form-group col-lg-6" <?php if(multifactorAuthWithAccessCode == true){ ?> style="pointer-events:none;opacity:0.4;" <?php } ?>>
						<label for="enableRecaptcha">Brute force password protection</label>
						<select class="form-control enableRecaptcha selectpicker" name="enableRecaptcha" id="enableRecaptcha" >
						    <option value="true" <?php if($data["enableRecaptcha"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
						    <option value="false" <?php if($data["enableRecaptcha"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
						</select>
						</div>
					    <div class="form-group col-lg-6">
						<label for="googleAuthenticator">Multi-factor authentication</label>
						<select class="form-control googleAuthenticator selectpicker" name="googleAuthenticator" id="googleAuthenticator" >
						    <option value="true" <?php if($data["googleAuthenticator"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
						    <option value="false" <?php if($data["googleAuthenticator"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
						</select>
					     </div>
					     <div class="form-group col-lg-6">
                                                <label for="allowPasswordReset">Allow reset password for Parablu namespace users</label>
                                                <select class="form-control allowPasswordReset selectpicker" name="allowPasswordReset" id="allowPasswordReset" >
                                                    <option value="true" <?php if($data["allowPasswordReset"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                                    <option value="false" <?php if($data["allowPasswordReset"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                             </div>
					     <div class="form-group col-lg-6">
                                                <label for="forceChangePasswordAtFirstTimeLogin">Force change password at first time login</label>
                                                <select class="form-control forceChangePasswordAtFirstTimeLogin selectpicker" name="forceChangePasswordAtFirstTimeLogin" id="forceChangePasswordAtFirstTimeLogin">
                                                    <option value="true" <?php if($data["forceChangePasswordAtFirstTimeLogin"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                                    <option value="false" <?php if($data["forceChangePasswordAtFirstTimeLogin"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                             </div>
					     <div class="form-group col-lg-6">
                                                <label for="forceSessionLogoutAfterChangepassword">Force session logout after change password</label>
                                                <select class="form-control forceSessionLogoutAfterChangepassword selectpicker" name="forceSessionLogoutAfterChangepassword" id="forceSessionLogoutAfterChangepassword" >
                                                    <option value="true" <?php if($data["forceSessionLogoutAfterChangepassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                                    <option value="false" <?php if($data["forceSessionLogoutAfterChangepassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                             </div>
					</div>
				    </div>
				    <div class="row" style="margin-left:10px;">
				    <?php if(isMobile()){ ?>
                        		<div class="col-lg-12">
				    <?php } ?>
				<div class="row col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('GUI Settings', 'keywords')?></legend>
					<div class="col-lg-12">
					    <div class="row">
						<div class="form-group col-lg-6">
						   <label for="portalSSOEnable"><?=Language::show('Azure Active Directory Single SignOn from Portal', 'keywords');?></label>
						   <select class="form-control portalSSOEnable" name="portalSSOEnable" id="portalSSOEnable" title='Select <?=Language::show('Portal SSO Enable', 'keywords')?>'>
							<option value="true" <?php if($data["portalSSOEnable"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
							<option value="false" <?php if($data["portalSSOEnable"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
						   </select>
						    <?php if($data["portalSSOEnable"] == true){ ?>
						    <span id="ssourl" style="color: #f55753;font-size: 0.9em;word-break: break-all;">Note: In order to login without AAD SSO, admin can use this URL: <?=PROTOCOL?><?=PARACLOUD_IP?>/portal/locallogin</span>
						    <?php } else { ?>
						    <span id="ssourl" style="color: #f55753;font-size: 0.9em;word-break: break-all;"></span>
						    <?php } ?>
						</div>
						<div class="form-group col-lg-6">
						   <label for="portalSSOutEnable"><?=Language::show('Azure Active Directory Single SignOut from Portal', 'keywords');?></label>
						   <select class="form-control portalSSOutEnable" name="portalSSOutEnable" id="portalSSOutEnable" title='Select <?=Language::show('Portal SSOut Enable', 'keywords')?>'>
							<option value="true" <?php if($data["portalSSOutEnable"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
							<option value="false" <?php if($data["portalSSOutEnable"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
						   </select>
						</div>
					    </div>
					</div>
					<!--table starts-->
					<div class="table-responsive">
					<table class="table table-bordered table-striped deviceListTable">
						<thead>
						<tr>
						    <th>Tile position</th>
						    <th>Make flippable</th>
						    <th>Head/Tail position</th>
						</tr>
						</thead>
						<tbody>
						<tr>
						   <td>
							<span>Tile 1</span>
						    </td>
						    <td>
							<div class="col-lg-4">
							    <label class="switch">
								<input id="tile1flip" name="tile1flip" type="checkbox" <?php if($data["flipUsersTile"] == true){echo "checked";}?>>
								<div class="slider round"></div>
							    </label>
						       </div>
						    </td>
						    <td>
							<div class="col-lg-8">
							    <select class="form-control" name="tile1" id="tile1">
								<option value="true" <?php if($data["activeUsers"] == true){echo "selected";}?>>Show "Active Users" in front</option>
								<option value="false" <?php if($data["activeUsers"] == false){echo "selected";}?>>Show "Blocked Users" in front</option>
							    </select>
							</div>
						    </td>
						 </tr>
						 <tr>
						    <td>
							<span>Tile 2</span>
						     </td>
						    <td>
							<div class="col-lg-4">
							    <label class="switch">
								<input id="tile2flip" name="tile2flip" type="checkbox" <?php if($data["flipDevicesTile"] == true){echo "checked";}?>>
								<div class="slider round"></div>
							    </label>
						       </div>
						    </td>
						    <td>
							<div class="col-lg-8">
							    <select class="form-control" name="tile2" id="tile2">
								<option value="true" <?php if($data["activeDevices"] == true){echo "selected";}?>>Show "Active Devices" in front</option>
								<option value="false" <?php if($data["activeDevices"] == false){echo "selected";}?>>Show "Blocked Devices" in front</option>
							    </select>
							</div>
						    </td>
						 </tr>
						 <tr>
						    <td>
							<span>Tile 3</span>
						    </td>
						    <td>
							<div class="col-lg-4">
							    <label class="switch">
								<input id="tile3flip" name="tile3flip" type="checkbox" <?php if($data["flipTotalCompletedBackups"] == true){echo "checked";}?>>
								<div class="slider round"></div>
							    </label>
						       </div>
						    </td>
						    <td>
							<div class="col-lg-8">
							    <select class="form-control" name="tile3" id="tile3">
								<option value="true" <?php if($data["totalCompletedBackups"] == true){echo "selected";}?>>Show "Active Devices with Full Backups Completed" in front</option>
								<option value="false" <?php if($data["totalCompletedBackups"] == false){echo "selected";}?>>Show "Active Users with Full Backups Completed" in front</option>
							    </select>
							</div>
						    </td>
						 </tr>
						 <tr>
						    <td>
							    <span>Tile 4</span>
						    </td>
						    <td>
							<div class="col-lg-4">
							    <label class="switch">
								<input id="tile4flip" name="tile4flip" type="checkbox" <?php if($data["flipNotProtectedTile"] == true){echo "checked";}?>>
								<div class="slider round"></div>
							    </label>
						       </div>
						    </td>
						    <td>
							<div class="col-lg-8">
							    <select class="form-control" name="tile4ReportType" id="tile8">
								<option value="systemsWithoutBackup" <?php if($data["tile8ReportType"] == "systemsWithoutBackup"){echo "selected";}?>>Show "Systems not protected" in front</option>
								    <option value="usersWithSystemsNotProtected" <?php if($data["tile8ReportType"] == "usersWithSystemsNotProtected"){echo "selected";}?>>Show "Users without any systems protected" in front</option>
							    </select>
							</div>
						    </td>
						 </tr>
						 <tr>
						    <td>
							<span>Tile 5</span>
						    </td>
						    <td>
							<div class="col-lg-4">
							    <label class="switch">
								<input id="tile5flip" name="tile5flip" type="checkbox" <?php if($data["flipTotalActualStorageUtilized"] == true){echo "checked";}?>>
								<div class="slider round"></div>
							    </label>
						       </div>
						    </td>
						    <td>
							<div class="col-lg-8">
							    <select class="form-control" name="tile5" id="tile5">
								<option value="true" <?php if($data["totalActualStorageUtilized"] == true){echo "selected";}?>>Show "Total Actual Storage Utilized" in front</option>
								    <option value="false" <?php if($data["totalActualStorageUtilized"] == false){echo "selected";}?>>Show "Total Data Backed up" in front</option>
							    </select>
							</div>
						    </td>
						 </tr>
						</tbody>	
                                    	</table>
                                    	</div>
					<!--table ends-->
                                        <?php if(isMobile()){ ?>
                                                </div>
                                        <?php } ?>
                                    </div>
				    <div class="row col-lg-12">
                                    	<legend class="h4" style="color: #585f69;"><?=Language::show('Branding Settings', 'keywords')?></legend>
					<div class="form-group col-lg-6">
						<a class="btn btn-success btn-small" ng-click="branding()"> Change Branding Settings</a>
					</div>
				    </div>
				    <div class="row col-lg-12 d-none" style="margin-left:10px;">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Administration approval', 'keywords')?></legend>
                                        <div class="form-group col-lg-6">
                                            <label for="softBlockEnabled">Enable administration approval for blocked users</label>
                                            <select class="form-control softBlockEnabled selectpicker" name="softBlockEnabled" id="softBlockEnabled" >
                                                <option value="false" <?php if($data["softBlockEnabled"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                                <option value="true" <?php if($data["softBlockEnabled"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            </select>
                                            <span style="color: #f55753;font-size: 0.9em;word-break: break-all;">Note: Relevant only if using an AD group or AAD group for user provisioning and de-provisioning.</span>
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                         <label for="storageLimitInKb">Storage Limit In Kb</label>
                                         <input type="number" class="form-control" name="storageLimitInKb" id="storageLimitInKb" value="<?=$data['storageLimitInKb']?>" placeholder="" autocomplete="off">
                                     </div>
				    <div class="form-group col-lg-6 d-none">
                                     	<label class="form-control" for="defaultBkpPolicyName">No Backup Policy Name</label>
                                     	<input type="text" class="form-control" name="noBackupPolicyName" id="noBackupPolicyName" value="<?=$data['noBackupPolicyName']?>" placeholder="" autocomplete="off">
                                     </div>
                                     <div class="form-group col-lg-6 d-none">
                                        <label for="oneDriveBackupType">Is Muxed Enabled</label>
                                        <select class="form-control oneDriveBackupType selectpicker" name="oneDriveBackupType" id="oneDriveBackupType" >
                                            <option value="MUX" <?php if($data["oneDriveBackupType"] == 'MUX'){echo "selected";}?>><?=Language::show('Muxed Environment', 'keywords')?></option>
                                            <option value="NONMUX" <?php if($data["oneDriveBackupType"] == 'NONMUX'){echo "selected";}?>><?=Language::show('Non-Muxed Environment', 'keywords')?></option>
                                            <option value="MIX" <?php if($data["oneDriveBackupType"] == 'MIX'){echo "selected";}?>><?=Language::show('Mixed Environment', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="blusyncDownloadPath">BluSync Download Path</label>
                                        <input type="text" class="form-control" name="blusyncDownloadPath" id="blusyncDownloadPath" value="<?=$data['blusyncDownloadPath']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="mntParacloudPath">Mnt Paracloud Path</label>
                                        <input type="text" class="form-control" name="mntParacloudPath" id="mntParacloudPath" value="<?=$data['mntParacloudPath']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="cloudScriptsFolder">Parablu Installation Script Folder</label>
                                        <input type="text" class="form-control" name="cloudScriptsFolder" id="cloudScriptsFolder" value="<?=$data['cloudScriptsFolder']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="scriptsBinDir">Scripts Bin Directory</label>
                                        <input type="text" class="form-control" name="scriptsBinDir" id="scriptsBinDir" value="<?=$data['scriptsBinDir']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="scriptsVideoThumbnail">Scripts Video Thumbnail</label>
                                        <input type="text" class="form-control" name="scriptsVideoThumbnail" id="scriptsVideoThumbnail" value="<?=$data['scriptsVideoThumbnail']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="scriptsGeneralThumbnail">Scripts General Thumbnail</label>
                                        <input type="text" class="form-control" name="scriptsGeneralThumbnail" id="scriptsGeneralThumbnail" value="<?=$data['scriptsGeneralThumbnail']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="cloudFileName">Parablu Installation File Name</label>
                                        <input type="text" class="form-control" name="cloudFileName" id="cloudFileName" value="<?=$data['cloudFileName']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="cloudType">Parablu Installation Type</label>
                                        <input type="text" class="form-control" name="cloudType" id="cloudType" value="<?=$data['cloudType']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="showLatestBkpInfo">Can Admin Restore Other Users' Data</label>
                                        <select class="form-control showLatestBkpInfo selectpicker" name="showLatestBkpInfo" id="showLatestBkpInfo" >
                                            <option value="true" <?php if($data["showLatestBkpInfo"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["showLatestBkpInfo"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="azureVM">Azure VM</label>
                                        <select class="form-control azureVM selectpicker" name="azureVM" id="azureVM" >
                                            <option value="false" <?php if($data["azureVM"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                            <option value="true" <?php if($data["azureVM"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="localAD">Local AD</label>
                                        <select class="form-control localAD selectpicker" name="localAD" id="localAD" >
                                            <option value="true" <?php if($data["localAD"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["localAD"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="sslAuthEnabled">SSl Auth Enabled</label>
                                        <select class="form-control sslAuthEnabled selectpicker" name="sslAuthEnabled" id="sslAuthEnabled" >
                                            <option value="false" <?php if($data["sslAuthEnabled"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                            <option value="true" <?php if($data["sslAuthEnabled"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="isCrawlEnabled">Is Crawl Enabled</label>
                                        <select class="form-control isCrawlEnabled selectpicker" name="isCrawlEnabled" id="isCrawlEnabled" >
                                            <option value="false" <?php if($data["isCrawlEnabled"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                            <option value="true" <?php if($data["isCrawlEnabled"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="isShareFileNameEnabled">Is Share File Name Enabled</label>
                                        <select class="form-control isShareFileNameEnabled selectpicker" name="isShareFileNameEnabled" id="isShareFileNameEnabled" >
                                            <option value="true" <?php if($data["isShareFileNameEnabled"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["isShareFileNameEnabled"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="maxCrawlHit">Maximum Crawl Hit</label>
                                        <input type="number" class="form-control" name="maxCrawlHit" id="maxCrawlHit" value="<?=$data['maxCrawlHit']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="noOfMultiADConfig">No. Of Multi AD Configuration</label>
                                        <input type="number" class="form-control" name="noOfMultiADConfig" id="noOfMultiADConfig" value="<?=$data['noOfMultiADConfig']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none" style="margin-bottom:20px;">
                                        <label for="mongoReadPreference">Mongo Read Preference</label>
                                        <select class="form-control mongoReadPreference selectpicker" name="mongoReadPreference" id="mongoReadPreference" >
                                            <option value="false" <?php if($data["mongoReadPreference"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                            <option value="true" <?php if($data["mongoReadPreference"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="writeConcernLimit">Write Concern Limit</label>
                                        <input type="number" class="form-control" name="writeConcernLimit" id="writeConcernLimit" value="<?=$data['writeConcernLimit']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="ebmsWriteDelayLimit">EBMS Write Delay Limit</label>
                                        <input type="number" class="form-control" name="ebmsWriteDelayLimit" id="ebmsWriteDelayLimit" value="<?=$data['ebmsWriteDelayLimit']?>" placeholder="" required autocomplete="off">
                                    </div>
				    <div class="form-group col-lg-6 d-none">
                                        <label for="numOfChunksToCheckPgOverloadLimit">Number of Chunks To Check Pg Overload Limit</label>
                                        <input type="number" class="form-control" name="numOfChunksToCheckPgOverloadLimit" id="numOfChunksToCheckPgOverloadLimit" value="<?=$data['numOfChunksToCheckPgOverloadLimit']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="emailBkpGroupName">Email Backup Group Name</label>
                                        <input type="text" class="form-control" name="emailBkpGroupName" id="emailBkpGroupName" value="<?=$data['emailBkpGroupName']?>" placeholder="Enter Email Backup Group Name" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="emailSyncGroupName">Email Sync Group Name</label>
                                        <input type="text" class="form-control" name="emailSyncGroupName" id="emailSyncGroupName" value="<?=$data['emailSyncGroupName']?>" placeholder="Enter Email Sync Group Name" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="bkpGroupEmail">Backup Group Email</label>
                                        <input type="email" class="form-control" name="bkpGroupEmail" id="bkpGroupEmail" value="<?=$data['bkpGroupEmail']?>" placeholder="Enter Backup group Email ID" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="syncGroupEmail">Sync Group Email</label>
                                        <input type="email" class="form-control" name="syncGroupEmail" id="syncGroupEmail" value="<?=$data['syncGroupEmail']?>" placeholder="Enter Sync group Email ID" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="chunkUpdateMaxRetry">Maximum Retry for Chunk Update</label>
                                        <input type="number" class="form-control" name="chunkUpdateMaxRetry" id="chunkUpdateMaxRetry" value="<?=$data['chunkUpdateMaxRetry']?>" placeholder="Enter value" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="adGroupName">Enter AD Group Name</label>
                                        <input type="text" class="form-control" name="adGroupName" id="adGroupName" value="<?=$data['adGroupName']?>" placeholder="Enter AD Group Name" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="adfsUrl">ADFS URL</label>
                                        <input type="text" class="form-control" name="adfsUrl" id="adfsUrl" value="<?=$data['adfsUrl']?>" placeholder="Enter ADFS URL" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="isDomainCheckEnabled">Is Domain Check Enabled</label>
                                        <select class="form-control isDomainCheckEnabled selectpicker" name="isDomainCheckEnabled" id="isDomainCheckEnabled" >
                                            <option value="true" <?php if($data["isDomainCheckEnabled"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["isDomainCheckEnabled"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="supportParacloudUrl">Support Paracloud Url</label>
                                        <input type="text" class="form-control" name="supportParacloudUrl" id="supportParacloudUrl" value="<?=$data['supportParacloudUrl']?>" placeholder="Enter supportParacloudUrl" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="reportRows">Days To Wait For Next Backup</label>
                                        <input type="number" class="form-control" name="daysToWaitForNextBackup" id="daysToWaitForNextBackup" value="<?=$data['daysToWaitForNextBackup']?>" placeholder="" required autocomplete="off">
                                    </div>
				    <div class="form-group col-lg-6 d-none">
                                         <label for="accessCodeExpiryTimeInMins">Access Code Time In Minutes</label>
                                         <input type="number" class="form-control" name="accessCodeExpiryTimeInMins" id="accessCodeExpiryTimeInMins" value="<?=$data['accessCodeExpiryTimeInMins']?>" placeholder="" autocomplete="off">
                                     </div>
				     <div class="form-group col-lg-6 d-none">
                                        <label for="multifactorAuthWithAccessCode">Multi factor Authentication With Access Code</label>
                                        <select class="form-control multifactorAuthWithAccessCode selectpicker" name="multifactorAuthWithAccessCode" id="multifactorAuthWithAccessCode" >
                                            <option value="true" <?php if($data["multifactorAuthWithAccessCode"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["multifactorAuthWithAccessCode"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group col-lg-6 d-none">
                                        <label for="daysToKeepAuditLog">Days To Keep Audit Log</label>
                                        <input type="text" class="form-control" name="daysToKeepAuditLog" id="daysToKeepAuditLog" value="<?=$data['daysToKeepAuditLog']?>" placeholder="Enter days To Keep Audit Log" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="dnsUserName">DNS Username</label>
                                        <input type="text" class="form-control" name="dnsUserName" id="dnsUserName" value="<?=$data['dnsUserName']?>" placeholder="Enter AD Group Name" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="dnsPassword">DNS Password</label>
                                        <input type="text" class="form-control" name="dnsPassword" id="dnsPassword" value="<?=$data['dnsPassword']?>" placeholder="Enter AD Group Name" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="adEmailConfig">AD Email Config</label>
                                        <input type="text" class="form-control" name="adEmailConfig" id="adEmailConfig" value="<?=$data['adEmailConfig']?>" placeholder="Enter AD Group Name" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="hideCompressedSize">Hide Compressed Size</label>
                                        <select class="form-control hideCompressedSize selectpicker" name="hideCompressedSize" id="hideCompressedSize" >
                                        <option value="true" <?php if($data["hideCompressedSize"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["hideCompressedSize"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group col-lg-6 d-none">
                                        <label for="showSmtpSettings">Show Smtp Settings</label>
                                        <select class="form-control showSmtpSettings selectpicker" name="showSmtpSettings" id="showSmtpSettings" >
                                        <option value="true" <?php if($data["showSmtpSettings"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["showSmtpSettings"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none" style="margin-bottom:20px;">
                                        <label for="hideStorageSizeInCloud">Hide Storage Size In Cloud</label>
                                        <select class="form-control hideStorageSizeInCloud selectpicker" name="hideStorageSizeInCloud" id="hideStorageSizeInCloud" >
                                        <option value="true" <?php if($data["hideStorageSizeInCloud"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["hideStorageSizeInCloud"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group col-lg-6 d-none" style="margin-bottom:20px;">
                                        <label for="hideStorageSizeOnServer">Hide Storage Size On Server</label>
                                        <select class="form-control hideStorageSizeOnServer selectpicker" name="hideStorageSizeOnServer" id="hideStorageSizeOnServer" >
                                        <option value="true" <?php if($data["hideStorageSizeOnServer"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["hideStorageSizeOnServer"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
		   		    <div class="form-group col-lg-6 d-none">
                                        <label for="useLocalPackage">Use Local Package</label>
                                        <select class="form-control useLocalPackage" name="useLocalPackage" id="useLocalPackage" >
                                            <option value="true" <?php if($data["useLocalPackage"] == true){echo "selected";}?>><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false" <?php if($data["useLocalPackage"] == false){echo "selected";}?>><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group col-lg-6 d-none">
                                                <label for="showSupportPage">Show Support Page</label>
                                                <select class="form-control showSupportPage" name="showSupportPage" id="showSupportPage" >
                                                <option value="true" <?php if($data["showSupportPage"] == true){echo "selected";}?>><?=Language::show('Yes', 'keywords')?></option>
                                                <option value="false" <?php if($data["showSupportPage"] == false){echo "selected";}?>><?=Language::show('No', 'keywords')?></option>
                                                </select>
                                    </div>
				    <div class="form-group col-lg-6 d-none">
                                                <label for="showCurrentlyRunningReports">Show Currently Running Reports for Delegated Administrator</label>
                                                <select class="form-control showCurrentlyRunningReports" name="showCurrentlyRunningReports" id="showCurrentlyRunningReports" >
                                                <option value="true" <?php if($data["showCurrentlyRunningReports"] == true){echo "selected";}?>><?=Language::show('Yes', 'keywords')?></option>
                                                <option value="false" <?php if($data["showCurrentlyRunningReports"] == false){echo "selected";}?>><?=Language::show('No', 'keywords')?></option>
                                                </select>
                                    </div>
				    <div class="form-group col-lg-6 d-none">           
                                                <label for="showAuditHistory">Show Audit History for Delegated Administrator</label>
                                                <select class="form-control showAuditHistory selectpicker" name="showAuditHistory" id="showAuditHistory" >
                                                <option value="true" <?php if($data["showAuditHistory"] == true){echo "selected";}?>><?=Language::show('Yes', 'keywords')?></option>
                                                <option value="false" <?php if($data["showAuditHistory"] == false){echo "selected";}?>><?=Language::show('No', 'keywords')?></option>
                                                </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="showBackupOverview"><?=Language::show('Show Backup Overview Report', 'keywords');?></label>
                                        <select class="form-control showBackupOverview" name="showBackupOverview" id="showBackupOverview" title='Select <?=Language::show('showBackupOverview', 'keywords')?>'>
                                            <option value="true" <?php if($data["showBackupOverview"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option> 
                                            <option value="false" <?php if($data["showBackupOverview"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="showBackupHistory"><?=Language::show('Show Backup History Report', 'keywords');?></label>
                                        <select class="form-control showBackupHistory" name="showBackupHistory" id="showBackupHistory" title='Select <?=Language::show('showBackupHistory', 'keywords')?>'>
                                            <option value="true" <?php if($data["showBackupHistory"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["showBackupHistory"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="showFailedBackupHistory"><?=Language::show('Show Failed Backup History Report', 'keywords');?></label>
                                        <select class="form-control showFailedBackupHistory" name="showFailedBackupHistory" id="showFailedBackupHistory" title='Select <?=Language::show('showFailedBackupHistory', 'keywords')?>'>
                                            <option value="true" <?php if($data["showFailedBackupHistory"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["showFailedBackupHistory"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group col-lg-6 d-none">
                                        <label for="showIncompleteBackupHistory"><?=Language::show('Show Incomplete Backup History Report', 'keywords');?></label>
                                        <select class="form-control showIncompleteBackupHistory" name="showIncompleteBackupHistory" id="showIncompleteBackupHistory" title='Select <?=Language::show('showIncompleteBackupHistory', 'keywords')?>'>
                                            <option value="true" <?php if($data["showIncompleteBackupHistory"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["showIncompleteBackupHistory"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="showSystemsWithoutBackups"><?=Language::show('Show Systems Without Backups Report', 'keywords');?></label>
                                        <select class="form-control showSystemsWithoutBackups" name="showSystemsWithoutBackups" id="showSystemsWithoutBackups" title='Select <?=Language::show('showSystemsWithoutBackups', 'keywords')?>'>
                                            <option value="true" <?php if($data["showSystemsWithoutBackups"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["showSystemsWithoutBackups"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="showRestoreHistory"><?=Language::show('Show Restore History Report', 'keywords');?></label>
                                        <select class="form-control showRestoreHistory" name="showRestoreHistory" id="showRestoreHistory" title='Select <?=Language::show('showRestoreHistory', 'keywords')?>'>
                                            <option value="true" <?php if($data["showRestoreHistory"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["showRestoreHistory"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="showStorageUtilizationReport"><?=Language::show('Show Storage Utilization Report', 'keywords');?></label>
                                        <select class="form-control showStorageUtilizationReport" name="showStorageUtilizationReport" id="showStorageUtilizationReport" title='Select <?=Language::show('showStorageUtilizationReport', 'keywords')?>'>
                                            <option value="true" <?php if($data["showStorageUtilizationReport"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["showStorageUtilizationReport"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="showDeviceHeartbeatReport"><?=Language::show('Show Device Heart beat Report', 'keywords');?></label>
                                        <select class="form-control showDeviceHeartbeatReport" name="showDeviceHeartbeatReport" id="showDeviceHeartbeatReport" title='Select <?=Language::show('showDeviceHeartbeatReport', 'keywords')?>'>
                                            <option value="true" <?php if($data["showDeviceHeartbeatReport"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["showDeviceHeartbeatReport"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="showUserBackupSummary"><?=Language::show('Show User Backup Summary', 'keywords');?></label>
                                        <select class="form-control showUserBackupSummary" name="showUserBackupSummary" id="showUserBackupSummary" title='Select <?=Language::show('showUserBackupSummary', 'keywords')?>'>
                                            <option value="true" <?php if($data["showUserBackupSummary"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["showUserBackupSummary"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group col-lg-6 d-none">
                                        <label for="showBackupCompletionReport"><?=Language::show('Show Backup Completion Report', 'keywords');?></label>
                                        <select class="form-control showBackupCompletionReport" name="showBackupCompletionReport" id="showBackupCompletionReport" title='Select <?=Language::show('Show Backup Completion Report', 'keywords')?>'>
                                            <option value="true" <?php if($data["showBackupCompletionReport"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["showBackupCompletionReport"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="hideDashboard">Show Dashboard Tiles for Delegated Administrator</label>
                                        <select class="form-control hideDashboard selectpicker" name="hideDashboard" id="hideDashboard" >
                                        	<option value="false" <?php if($data["hideDashboard"] == false){echo "selected";}?>><?=Language::show('Yes', 'keywords')?></option>          
                                        	<option value="true" <?php if($data["hideDashboard"] == true){echo "selected";}?>><?=Language::show('No', 'keywords')?></option>             
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="hideDashboard">Stop Pause Access for Read Only Admin</label>
                                        <select class="form-control stopPauseAccess selectpicker" name="stopPauseAccess" id="stopPauseAccess" >
                                        	<option value="true" <?php if($data["stopPauseAccess"] == true){echo "selected";}?>>Yes</option>
                                        	<option value="false" <?php if($data["stopPauseAccess"] == false){echo "selected";}?>>No</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">  
                                        <label for="winDeviceDisplayNameUpdate">Allow Windows Device Display Name Update</label>
                                        <select class="form-control winDeviceDisplayNameUpdate selectpicker" name="winDeviceDisplayNameUpdate" id="winDeviceDisplayNameUpdate" >
                                        	<option value="true" <?php if($data["winDeviceDisplayNameUpdate"] == true){echo "selected";}?>>Enabled</option>
                                        	<option value="false" <?php if($data["winDeviceDisplayNameUpdate"] == false){echo "selected";}?>>Disabled</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="macDeviceDisplayNameUpdate">Allow Mac Device Display Name Update</label>
                                        <select class="form-control macDeviceDisplayNameUpdate selectpicker" name="macDeviceDisplayNameUpdate" id="macDeviceDisplayNameUpdate" >
                                        	<option value="true" <?php if($data["macDeviceDisplayNameUpdate"] == true){echo "selected";}?>>Enabled</option>
                                        	<option value="false" <?php if($data["macDeviceDisplayNameUpdate"] == false){echo "selected";}?>>Disabled</option>
                                        </select>
                                    </div>
				    <div class="form-group col-lg-6 d-none">  
                                        <label for="brevityLogging">Brevity Logging</label>
                                        <select class="form-control brevityLogging selectpicker" name="brevityLogging" id="brevityLogging" >
                                        	<option value="true" <?php if($data["brevityLogging"] == true){echo "selected";}?>>Enabled</option>
                                        	<option value="false" <?php if($data["brevityLogging"] == false){echo "selected";}?>>Disabled</option>
                                        </select>
                                    </div>
				    <div class="form-group col-lg-6 d-none">
                                        <label for="showMultipleLoginWarning">Show multiple user login warning</label>
                                        <select class="form-control showMultipleLoginWarning selectpicker" name="showMultipleLoginWarning" id="showMultipleLoginWarning" >
                                        	<option value="true" <?php if($data["showMultipleLoginWarning"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        	<option value="false" <?php if($data["showMultipleLoginWarning"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
				    </div>
				    <div class="form-group col-lg-6 d-none">
                                                <label for="httpEnabled">Http Enabled</label>
                                                <select class="form-control httpEnabled selectpicker" name="httpEnabled" id="httpEnabled" >
                                                    <option value="true" <?php if($data["httpEnabled"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                                    <option value="false" <?php if($data["httpEnabled"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                     </div>
				    <div class="form-group col-lg-6 d-none">
                                        <label for="allowUserLevelFolderExclusions">Allow User Level Folder Exclusions</label>
                                        <select class="form-control allowUserLevelFolderExclusions selectpicker" name="allowUserLevelFolderExclusions" id="allowUserLevelFolderExclusions" >
                                        	<option value="true" <?php if($data["allowUserLevelFolderExclusions"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        	<option value="false" <?php if($data["allowUserLevelFolderExclusions"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
				    </div>
				    <div class="form-group col-lg-6 d-none">
                                            <label for="numOfHitsToDBForContentChunkCheck">Number of Hits to DB for Content Chunk Check</label>
                                            <input type="number" class="form-control" name="numOfHitsToDBForContentChunkCheck" id="numOfHitsToDBForContentChunkCheck" value="<?=$data['numOfHitsToDBForContentChunkCheck']?>" placeholder="" required autocomplete="off">
				    </div>
				    <div class="form-group col-lg-6 d-none">
                                            <label for="daysToDeleteTmpChunk">Days to Delete Tmp Chunk</label>
                                            <input type="number" class="form-control" name="daysToDeleteTmpChunk" id="daysToDeleteTmpChunk" value="<?=$data['daysToDeleteTmpChunk']?>" placeholder="" required autocomplete="off">
				    </div>
				    <div class="form-group col-lg-6 d-none">
                                            <label for="daysToDeleteLocalSyncFilesAndFolders">Days to Delete Local Sync Files and Folders</label>
                                            <input type="number" class="form-control" name="daysToDeleteLocalSyncFilesAndFolders" id="daysToDeleteLocalSyncFilesAndFolders" value="<?=$data['daysToDeleteLocalSyncFilesAndFolders']?>" placeholder="" required autocomplete="off">
				    </div>
			 	    <div class="form-group col-lg-6 d-none">
                                        <label for="showUserConsentFieldInPolicies">Show User Consent Field In Policies</label>
                                        <select class="form-control showUserConsentFieldInPolicies selectpicker" name="showUserConsentFieldInPolicies" id="showUserConsentFieldInPolicies" >
                                        	<option value="true" <?php if($data["showUserConsentFieldInPolicies"] == true){echo "selected";}?>>Enabled</option>
                                        	<option value="false" <?php if($data["showUserConsentFieldInPolicies"] == false){echo "selected";}?>>Disabled</option>
                                        </select>
                                    </div>
				    <div class="form-group col-lg-6 d-none">  
                                        <label for="globalCheckForLocalStorage">Global Check For Local Storage</label>
                                        <select class="form-control globalCheckForLocalStorage selectpicker" name="globalCheckForLocalStorage" id="globalCheckForLocalStorage" >
                                        	<option value="true" <?php if($data["globalCheckForLocalStorage"] == true){echo "selected";}?>>Enabled</option>
                                        	<option value="false" <?php if($data["globalCheckForLocalStorage"] == false){echo "selected";}?>>Disabled</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 d-none">
                                        <label for="">Extensions To Pdf View</label>
                                        <input type="text" class="form-control" name="extensionsToPdfView" id="extensionsToPdfView" value="<?=$data['extensionsToPdfView']?>" placeholder="" autocomplete="off">
                                    </div>				    
				    <div class="form-group col-lg-6 d-none">
                                    	<label for="policyEdit">Allow Policy Management</label>
                                        <select class="form-control policyEdit selectpicker" name="policyEdit" id="policyEdit" >
                                        	<option value="true" <?php if($data["policyEdit"] == true){echo "selected";}?>>Yes</option>
                                                <option value="false" <?php if($data["policyEdit"] == false){echo "selected";}?>>No</option>
                                        </select>
                                    </div>				    
                        </div>
                            </div>
                            <br/>
                            <div class="form-group col-lg-12">
                                <button type="submit" class="btn btn-success pull-right saveCloudProperties">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
<!-- branding start -->
<div class="modal fade branding">
                <div class="modal-dialog" style="width:90%;">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Branding Configuration</h4>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
				<div class="panel">
                            <div class="panel-heading">
                            </div>  
                            <div class="panel-body">
				<form class="logoform" data-parsley-validate enctype="multipart/form-data">
				<input type="text" class="hide" value="<?=$data["csrf_token"]?>" name="csrf_token" />
				<!-- table start-->                     
                                <div class="table-responsive keychart">
                                    <div class="h4 loading text-center d-none">Loading.....</div>
                                    <table class="table table-bordered table-striped deviceListTable">
                                        <thead>
                                        <tr>
                                            <th>Placeholder Name</th>
                                            <th>Import from</th>                                        
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td>
						    <span>Login Page Logo</span>
					    </td>
                                            <td>
						<input type="file" class="form-control" name="loginlogo" id="loginlogo" accept=".png" autocomplete="off" style="height:auto !important;width:fit-content;">
						<span class="help-line text-muted">Note:- files with an extension .png and file size 399 x 257 px can only be uploaded.</span>
				            </td>
                                         </tr>
					 <tr>
                                            <td>
						    <span>Header Logo</span>
					    </td>
                                            <td>
                                                <input type="file" class="form-control" name="headerlogo" id="headerlogo" accept=".png" autocomplete="off" style="height:auto !important;width:fit-content;">
                                        	<span class="help-line text-muted">Note:- files with an extension .png and file size 205 x 41 px can only be uploaded.</span>
                                           </td>
                                         </tr>
					 <tr>
                                            <td>
						    <span>Disclaimer File</span>
					    </td>
                                            <td>
                                                <input type="file" class="form-control" name="disclaimer" id="disclaimer" accept=".txt" autocomplete="off" style="height:auto !important;width:fit-content;">
                                        	<span class="help-line text-muted">Note:- files with an extension of .txt can only be uploaded.</span>
                                            </td>
					 </tr>
					 <tr>
					    <td>
						    <span>Custom Email Template File</span>
				            </td>
	   				    <td>
                                                <input type="file" class="form-control" name="customemail" id="customemail" accept=".xml" autocomplete="off" style="height:auto !important;width:fit-content;">
						<span class="help-line text-muted">Note:- files with an extension of .xml can only be uploaded.</span>
                                           </td>
                                         </tr>
					<tr>
                                            <td>
                                                    <span>User Manual Guide</span>
                                            </td>
                                            <td>
                                                <input type="file" class="form-control" name="getting" id="getting" accept=".pdf" autocomplete="off" style="height:auto !important;width:fit-content;">
                                                <span class="help-line text-muted">Note:- files with an extension of .pdf can only be uploaded.</span>
                                           </td>
                                         </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <!-- table ends-->
 				<br/>
                                     	<button type="submit" class="btn btn-success pull-right">Save</button>
					<button type="button" class="btn btn-default pull-right" data-dismiss="modal" style="margin-right: 5px;">Cancel</button>
				</form>
                            </div>
            		   </div>
                        </div>
                    </div>
                </div>
            </div>
<!--branding end -->
<!-- modal confirm starts -->
<div id="scriptConfirm" class="modal fade scriptConfirm" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content smallModal">
            <div class="modal-header">
		<h4 class="modal-title">Confirmation</h4>
<button type="button" class="close" data-dismiss="modal">&times;</button>
		    </div>
            	<div class="modal-body">
                     	<p>Some of the branding changes will need a few hours to take effect.  If you wish for the changes to take effect immediately, it will need a restart of all services.  This will impact all current backup and restore activity - and is not generally recommended.   Would you like to restart all services now?</p>
                </div>

                        <div class="modal-footer">
				<a ng-click="noRestart()" class="btn btn-primary pull-right"><?=Language::show('No', 'keywords');?></a>
				<a ng-click="restartScript()" class="btn btn-primary pull-right" style="margin-right: 5px;"><?=Language::show('Yes', 'keywords');?></a>
                        </div>
                    </div>
            </div>
        </div>
<!-- modal confirm ends -->
<!-- modal confirm starts -->
<div id="info" class="modal fade info" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content smallModal">
            <div class="modal-header">
                <h4 class="modal-title">Warning</h4>
			<button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <div class="modal-body">
                        <p> This will impact all current users.</p>
            </div>

<!--                        <div class="modal-footer">
                                <a ng-click="noRestart()" class="btn btn-primary pull-right"><?=Language::show('No', 'keywords');?></a>
                                <a ng-click="restartScript()" class="btn btn-primary pull-right" style="margin-right: 5px;"><?=Language::show('Yes', 'keywords');?></a>
                        </div>-->
                    </div>
            </div>
        </div>
<!-- modal confirm ends -->
<div id="overlayText"><center><h2 style="color:white;margin-top:20%;">The branding changes will be made now.  Please logout of this session and log in again after some time to view the changes.</h2></center></div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script type="text/javascript">
    
    function myFunctionEmailDelay(){
        document.getElementById("delayerror").innerHTML = "";
        if(isNaN($('#bulkEmailDelay').val()))
        {
        if (  $('#bulkEmailDelay').val() !='NO DELAY')  {
                document.getElementById("delayerror").innerHTML = "Input can be either 'NO DELAY' or any integer";
                //alert('Invalid Input');
            }
        }
        else{
            document.getElementById("delayerror").innerHTML = "";
        }
    }
    
    $('#portalSSOEnable').on('change', function(){
        document.getElementById("ssourl").innerHTML = "";
        if($('#portalSSOEnable').val() == 'true')
        {
            document.getElementById("ssourl").innerHTML = "Note: To login as a local user bypassing Azure Active Directory Single SignOn, please use the following URL - "+$('.protocol').html()+$('.paracloudIP').html()+"/portal/locallogin";
        }else{
            document.getElementById("ssourl").innerHTML = "";
        }
});
    
    $("#switchFairnessAlgorithm").click(function(){
         if ($(this).is(':checked')) {
             $('#daysToWaitForNextBackup').removeAttr('disabled');
         } else {
             $('#daysToWaitForNextBackup').val('0');
             $('#daysToWaitForNextBackup').attr('disabled', true); 
         }
     });


    $('#controller1').click(function(){
        if ($(this).is(':checked')) {
            console.log("checked");
            $('.canUserChangePassword1').attr("disabled", false);
            $('.canAdminChangeUserPassword1').attr("disabled", false);      
            $('.canUserChangePassword1').find('option[value="true"]').prop("selected",true);
	    $('.canUserChangePassword1').removeClass('hide');
            $('.canAdminChangeUserPassword1').removeClass('hide');
            document.getElementById("canUserChangePasswordBlock").style.opacity = "1";
            document.getElementById("canUserChangePasswordBlock").style['pointer-events'] = 'unset';
            document.getElementById("canAdminChangeUserPasswordBlock").style.opacity = "1";
            document.getElementById("canAdminChangeUserPasswordBlock").style['pointer-events'] = 'unset';
         } else {
            console.log("unchecked");
            $('.canUserChangePassword1').find('option[value="true"]').prop("selected",true);  
            $('.canAdminChangeUserPassword1').find('option[value="false"]').prop("selected",true);  
            $('.canUserChangePassword1').attr('disabled', true); 
            $('.canAdminChangeUserPassword1').attr('disabled', true);
	    $('.canUserChangePassword1').addClass('hide');
            $('.canAdminChangeUserPassword1').addClass('hide');
            document.getElementById("canUserChangePasswordBlock").style.opacity = "0.5";
            document.getElementById("canUserChangePasswordBlock").style['pointer-events'] = 'none';
            document.getElementById("canAdminChangeUserPasswordBlock").style.opacity = "0.5";
            document.getElementById("canAdminChangeUserPasswordBlock").style['pointer-events'] = 'none';
             
         }

    });
</script>
<style>
 .switch {
   position: relative;
   display: inline-block;
   width: 60px;
   height: 34px;
 }
 
 .switch input {display:none;}
 
 .slider {
   position: absolute;
   cursor: pointer;
   top: 0;
   left: 0;
   right: 0;
   bottom: 0;
   background-color: #ccc;
   -webkit-transition: .4s;
   transition: .4s;
 }
 
 .slider:before {
   position: absolute;
   content: "";
   height: 26px;
   width: 26px;
   left: 4px;
   bottom: 4px;
   background-color: white;
   -webkit-transition: .4s;
   transition: .4s;
 }
 
 input:checked + .slider {
   background-color: #f27331;
 }
 
 input:focus + .slider {
   box-shadow: 0 0 1px #f27331;
 }
 
 input:checked + .slider:before {
   -webkit-transform: translateX(26px);
   -ms-transform: translateX(26px);
   transform: translateX(26px);
 }
 /* Rounded sliders */
 .slider.round {
   border-radius: 34px;
 }
 
 .slider.round:before {
   border-radius: 50%;
 }
 </style>
 <script>
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();   
});

$( ".toggle-passwordphrase" ).mousedown(function() {
  $("#dbBackupPassword").attr("type", "text");
$(this).toggleClass("fa-eye-slash fa-eye");
});

$( ".toggle-passwordphrase" ).mouseup(function() {
  $("#dbBackupPassword").attr("type", "password");
$(this).toggleClass("fa-eye fa-eye-slash");
});
	 
function flipDelete(){
        $('#allowEndUserTocontrolRestoreBlock').removeClass('hide');
        $('.allowEndUserTocontrolRestore').removeClass('hide');
        if($('.canAdminRestoreAll').val() == 'true'){
                document.getElementById("allowEndUserTocontrolRestore").style.opacity = "1";
                document.getElementById("allowEndUserTocontrolRestore").style['pointer-events'] = 'unset';
                document.getElementById("isAdminDeleteBackupFile").style.opacity = "1";
                document.getElementById("isAdminDeleteBackupFile").style['pointer-events'] = 'unset';
        }else{
                $('.allowEndUserTocontrolRestore').find('option[value="false"]').prop("selected",true);
                document.getElementById("allowEndUserTocontrolRestore").style.opacity = "0.5";
                document.getElementById("allowEndUserTocontrolRestore").style['pointer-events'] = 'none';               
                $('.isAdminDeleteBackupFile').find('option[value="false"]').prop("selected",true);
                document.getElementById("isAdminDeleteBackupFile").style.opacity = "0.5";
                document.getElementById("isAdminDeleteBackupFile").style['pointer-events'] = 'none';
        }

}
	 
$('#controllerGS').click(function(){
        if($(this).is(':checked')) {
            $('.canAdminRestoreAll').attr("disabled", false);
            $('.isAdminDeleteBackupFile').attr("disabled", false);
            $('.allowEndUserTocontrolRestore').attr("disabled", false);
            $('.canAdminRestoreAll').removeClass('hide');
            $('.isAdminDeleteBackupFile').removeClass('hide');
            $('.allowEndUserTocontrolRestore').removeClass('hide');
	    document.getElementById("canAdminRestoreAllBlock").style.opacity = "1";
            document.getElementById("canAdminRestoreAllBlock").style['pointer-events'] = 'unset';
	    document.getElementById("allowEndUserTocontrolRestoreBlock").style.opacity = "1";
            document.getElementById("allowEndUserTocontrolRestoreBlock").style['pointer-events'] = 'unset';
	    document.getElementById("isAdminDeleteBackupFileBlock").style.opacity = "1";
            document.getElementById("isAdminDeleteBackupFileBlock").style['pointer-events'] = 'unset';          
         }else{
            $('.canAdminRestoreAll').attr('disabled', true);
            $('.isAdminDeleteBackupFile').attr('disabled', true);
            $('.allowEndUserTocontrolRestore').attr('disabled', true);
            $('.canAdminRestoreAll').addClass('hide');
            $('.isAdminDeleteBackupFile').addClass('hide');
            $('.allowEndUserTocontrolRestore').addClass('hide');
	    document.getElementById("canAdminRestoreAllBlock").style.opacity = "0.5";
            document.getElementById("canAdminRestoreAllBlock").style['pointer-events'] = 'none';
	    document.getElementById("allowEndUserTocontrolRestoreBlock").style.opacity = "0.5";
            document.getElementById("allowEndUserTocontrolRestoreBlock").style['pointer-events'] = 'none';
	    document.getElementById("isAdminDeleteBackupFileBlock").style.opacity = "0.5";
            document.getElementById("isAdminDeleteBackupFileBlock").style['pointer-events'] = 'none';           
         }
    });
$('#autoBlockSoftBlockedUsers').click(function(){
        if($(this).is(':checked')) {
            document.getElementById("daysToBlockSoftBlockedUsersBlock").style.display = "block";
            document.getElementById("daysToBlockSoftBlockedUsersBlock").style['pointer-events'] = 'unset';
            document.getElementById("daysToBlockSoftBlockedUsersBlock").style.opacity = "1";
         }else{
            document.getElementById("daysToBlockSoftBlockedUsersBlock").style.display = "none";
            document.getElementById("daysToBlockSoftBlockedUsersBlock").style['pointer-events'] = 'none';
            document.getElementById("daysToBlockSoftBlockedUsersBlock").style.opacity = "0.5";
         }
});		 
/*$('#autoExpireUsers').click(function(){
        if ($(this).is(':checked')) {
            console.log("checked");
            document.getElementById("disallowAgingBlock").style.display = "block";
         } else {
            console.log("unchecked");
            document.getElementById("disallowAgingBlock").style.display = "none";

         }
});*/
</script>
<style>
.field-icon {
  float: right;
  margin-left: -25px;
  margin-top: -25px;
  position: relative;
  z-index: 2;
}
td:nth-child(2) {
    white-space: unset !important;
}
#overlayText {
  position: fixed;
  display: none;
  width: 100%;
  height: 100%;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: rgba(0,0,0,0.5);
  z-index: 2;
  cursor: pointer;
}	
.parsley-errors-list{
display:none;
}
.filled{
display:block;	
}	
</style>
